/*
 * Copyright (C) 2015 ~ 2017 Deepin Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "dslider.h"
#include "slidertab.h"
#include "darrowrectangle.h"

DWIDGET_USE_NAMESPACE

SliderTab::SliderTab(QWidget *parent) : QLabel(parent)
{
    setStyleSheet("SliderTab{background-color:  #1A1B1B}");
    QHBoxLayout *layout = new QHBoxLayout(this);

    DSlider * slider = new DSlider(Qt::Horizontal, this);
    slider->setFixedWidth(300);
    slider->setFixedHeight(40);
    layout->addWidget(slider, 0, Qt::AlignTop | Qt::AlignHCenter);
}

void SliderTab::mousePressEvent(QMouseEvent *event)
{
    auto ptr = new DArrowRectangle(DArrowRectangle::ArrowBottom, DArrowRectangle::FloatWidget, this);
    ptr->setFixedSize(80,300);
    ptr->show(event->x(), event->y());
}
