/* SPDX-License-Identifier: BSD-3-Clause
 * Copyright(c) 2014-2020 Broadcom
 * All rights reserved.
 */

#include "ulp_template_db_enum.h"
#include "ulp_template_db_field.h"
#include "ulp_template_struct.h"
#include "ulp_rte_parser.h"

uint16_t ulp_class_sig_tbl[BNXT_ULP_CLASS_SIG_TBL_MAX_SZ] = {
	[BNXT_ULP_CLASS_HID_0138] = 1,
	[BNXT_ULP_CLASS_HID_03f0] = 2,
	[BNXT_ULP_CLASS_HID_0139] = 3,
	[BNXT_ULP_CLASS_HID_03f1] = 4,
	[BNXT_ULP_CLASS_HID_068b] = 5,
	[BNXT_ULP_CLASS_HID_0143] = 6,
	[BNXT_ULP_CLASS_HID_0118] = 7,
	[BNXT_ULP_CLASS_HID_03d0] = 8,
	[BNXT_ULP_CLASS_HID_0119] = 9,
	[BNXT_ULP_CLASS_HID_03d1] = 10,
	[BNXT_ULP_CLASS_HID_06ab] = 11,
	[BNXT_ULP_CLASS_HID_0163] = 12,
	[BNXT_ULP_CLASS_HID_0128] = 13,
	[BNXT_ULP_CLASS_HID_03e0] = 14,
	[BNXT_ULP_CLASS_HID_0129] = 15,
	[BNXT_ULP_CLASS_HID_03e1] = 16,
	[BNXT_ULP_CLASS_HID_069b] = 17,
	[BNXT_ULP_CLASS_HID_0153] = 18,
	[BNXT_ULP_CLASS_HID_0134] = 19,
	[BNXT_ULP_CLASS_HID_03fc] = 20,
	[BNXT_ULP_CLASS_HID_0135] = 21,
	[BNXT_ULP_CLASS_HID_03fd] = 22,
	[BNXT_ULP_CLASS_HID_0687] = 23,
	[BNXT_ULP_CLASS_HID_014f] = 24,
	[BNXT_ULP_CLASS_HID_0114] = 25,
	[BNXT_ULP_CLASS_HID_03dc] = 26,
	[BNXT_ULP_CLASS_HID_0115] = 27,
	[BNXT_ULP_CLASS_HID_03dd] = 28,
	[BNXT_ULP_CLASS_HID_06a7] = 29,
	[BNXT_ULP_CLASS_HID_016f] = 30,
	[BNXT_ULP_CLASS_HID_0124] = 31,
	[BNXT_ULP_CLASS_HID_03ec] = 32,
	[BNXT_ULP_CLASS_HID_0125] = 33,
	[BNXT_ULP_CLASS_HID_03ed] = 34,
	[BNXT_ULP_CLASS_HID_0697] = 35,
	[BNXT_ULP_CLASS_HID_015f] = 36,
	[BNXT_ULP_CLASS_HID_0452] = 37,
	[BNXT_ULP_CLASS_HID_0528] = 38,
	[BNXT_ULP_CLASS_HID_0790] = 39,
	[BNXT_ULP_CLASS_HID_046e] = 40,
	[BNXT_ULP_CLASS_HID_0462] = 41,
	[BNXT_ULP_CLASS_HID_0518] = 42,
	[BNXT_ULP_CLASS_HID_07a0] = 43,
	[BNXT_ULP_CLASS_HID_045e] = 44,
	[BNXT_ULP_CLASS_HID_0228] = 45,
	[BNXT_ULP_CLASS_HID_06d0] = 46,
	[BNXT_ULP_CLASS_HID_02be] = 47,
	[BNXT_ULP_CLASS_HID_07a6] = 48,
	[BNXT_ULP_CLASS_HID_0218] = 49,
	[BNXT_ULP_CLASS_HID_06e0] = 50,
	[BNXT_ULP_CLASS_HID_028e] = 51,
	[BNXT_ULP_CLASS_HID_0796] = 52,
	[BNXT_ULP_CLASS_HID_079c] = 53,
	[BNXT_ULP_CLASS_HID_0654] = 54,
	[BNXT_ULP_CLASS_HID_06d2] = 55,
	[BNXT_ULP_CLASS_HID_058a] = 56,
	[BNXT_ULP_CLASS_HID_052f] = 57,
	[BNXT_ULP_CLASS_HID_07e7] = 58,
	[BNXT_ULP_CLASS_HID_079d] = 59,
	[BNXT_ULP_CLASS_HID_0655] = 60,
	[BNXT_ULP_CLASS_HID_046d] = 61,
	[BNXT_ULP_CLASS_HID_0725] = 62,
	[BNXT_ULP_CLASS_HID_06d3] = 63,
	[BNXT_ULP_CLASS_HID_058b] = 64,
	[BNXT_ULP_CLASS_HID_07ac] = 65,
	[BNXT_ULP_CLASS_HID_0664] = 66,
	[BNXT_ULP_CLASS_HID_06e2] = 67,
	[BNXT_ULP_CLASS_HID_05ba] = 68,
	[BNXT_ULP_CLASS_HID_051f] = 69,
	[BNXT_ULP_CLASS_HID_07d7] = 70,
	[BNXT_ULP_CLASS_HID_07ad] = 71,
	[BNXT_ULP_CLASS_HID_0665] = 72,
	[BNXT_ULP_CLASS_HID_045d] = 73,
	[BNXT_ULP_CLASS_HID_0715] = 74,
	[BNXT_ULP_CLASS_HID_06e3] = 75,
	[BNXT_ULP_CLASS_HID_05bb] = 76,
	[BNXT_ULP_CLASS_HID_016a] = 77,
	[BNXT_ULP_CLASS_HID_03d2] = 78,
	[BNXT_ULP_CLASS_HID_0612] = 79,
	[BNXT_ULP_CLASS_HID_00da] = 80,
	[BNXT_ULP_CLASS_HID_06bd] = 81,
	[BNXT_ULP_CLASS_HID_0165] = 82,
	[BNXT_ULP_CLASS_HID_016b] = 83,
	[BNXT_ULP_CLASS_HID_03d3] = 84,
	[BNXT_ULP_CLASS_HID_03a5] = 85,
	[BNXT_ULP_CLASS_HID_066d] = 86,
	[BNXT_ULP_CLASS_HID_0613] = 87,
	[BNXT_ULP_CLASS_HID_00db] = 88,
	[BNXT_ULP_CLASS_HID_015a] = 89,
	[BNXT_ULP_CLASS_HID_03e2] = 90,
	[BNXT_ULP_CLASS_HID_0622] = 91,
	[BNXT_ULP_CLASS_HID_00ea] = 92,
	[BNXT_ULP_CLASS_HID_068d] = 93,
	[BNXT_ULP_CLASS_HID_0155] = 94,
	[BNXT_ULP_CLASS_HID_015b] = 95,
	[BNXT_ULP_CLASS_HID_03e3] = 96,
	[BNXT_ULP_CLASS_HID_0395] = 97,
	[BNXT_ULP_CLASS_HID_065d] = 98,
	[BNXT_ULP_CLASS_HID_0623] = 99,
	[BNXT_ULP_CLASS_HID_00eb] = 100,
	[BNXT_ULP_CLASS_HID_04bc] = 101,
	[BNXT_ULP_CLASS_HID_0442] = 102,
	[BNXT_ULP_CLASS_HID_050a] = 103,
	[BNXT_ULP_CLASS_HID_06ba] = 104,
	[BNXT_ULP_CLASS_HID_0472] = 105,
	[BNXT_ULP_CLASS_HID_0700] = 106,
	[BNXT_ULP_CLASS_HID_04c8] = 107,
	[BNXT_ULP_CLASS_HID_0678] = 108,
	[BNXT_ULP_CLASS_HID_061f] = 109,
	[BNXT_ULP_CLASS_HID_05ad] = 110,
	[BNXT_ULP_CLASS_HID_06a5] = 111,
	[BNXT_ULP_CLASS_HID_0455] = 112,
	[BNXT_ULP_CLASS_HID_05dd] = 113,
	[BNXT_ULP_CLASS_HID_0563] = 114,
	[BNXT_ULP_CLASS_HID_059b] = 115,
	[BNXT_ULP_CLASS_HID_070b] = 116,
	[BNXT_ULP_CLASS_HID_04bd] = 117,
	[BNXT_ULP_CLASS_HID_0443] = 118,
	[BNXT_ULP_CLASS_HID_050b] = 119,
	[BNXT_ULP_CLASS_HID_06bb] = 120,
	[BNXT_ULP_CLASS_HID_0473] = 121,
	[BNXT_ULP_CLASS_HID_0701] = 122,
	[BNXT_ULP_CLASS_HID_04c9] = 123,
	[BNXT_ULP_CLASS_HID_0679] = 124,
	[BNXT_ULP_CLASS_HID_05e2] = 125,
	[BNXT_ULP_CLASS_HID_00b0] = 126,
	[BNXT_ULP_CLASS_HID_0648] = 127,
	[BNXT_ULP_CLASS_HID_03f8] = 128,
	[BNXT_ULP_CLASS_HID_02ea] = 129,
	[BNXT_ULP_CLASS_HID_05b8] = 130,
	[BNXT_ULP_CLASS_HID_0370] = 131,
	[BNXT_ULP_CLASS_HID_00e0] = 132,
	[BNXT_ULP_CLASS_HID_0745] = 133,
	[BNXT_ULP_CLASS_HID_0213] = 134,
	[BNXT_ULP_CLASS_HID_031b] = 135,
	[BNXT_ULP_CLASS_HID_008b] = 136,
	[BNXT_ULP_CLASS_HID_044d] = 137,
	[BNXT_ULP_CLASS_HID_071b] = 138,
	[BNXT_ULP_CLASS_HID_0003] = 139,
	[BNXT_ULP_CLASS_HID_05b3] = 140,
	[BNXT_ULP_CLASS_HID_05e3] = 141,
	[BNXT_ULP_CLASS_HID_00b1] = 142,
	[BNXT_ULP_CLASS_HID_0649] = 143,
	[BNXT_ULP_CLASS_HID_03f9] = 144,
	[BNXT_ULP_CLASS_HID_02eb] = 145,
	[BNXT_ULP_CLASS_HID_05b9] = 146,
	[BNXT_ULP_CLASS_HID_0371] = 147,
	[BNXT_ULP_CLASS_HID_00e1] = 148,
	[BNXT_ULP_CLASS_HID_0000] = 149,
	[BNXT_ULP_CLASS_HID_00ce] = 150,
	[BNXT_ULP_CLASS_HID_01b6] = 151,
	[BNXT_ULP_CLASS_HID_0074] = 152,
	[BNXT_ULP_CLASS_HID_00fe] = 153,
	[BNXT_ULP_CLASS_HID_03bc] = 154,
	[BNXT_ULP_CLASS_HID_0206] = 155,
	[BNXT_ULP_CLASS_HID_02c4] = 156,
	[BNXT_ULP_CLASS_HID_055a] = 157,
	[BNXT_ULP_CLASS_HID_045a] = 158,
	[BNXT_ULP_CLASS_HID_061a] = 159,
	[BNXT_ULP_CLASS_HID_051a] = 160,
	[BNXT_ULP_CLASS_HID_074a] = 161,
	[BNXT_ULP_CLASS_HID_004e] = 162,
	[BNXT_ULP_CLASS_HID_040a] = 163,
	[BNXT_ULP_CLASS_HID_010e] = 164,
	[BNXT_ULP_CLASS_HID_048b] = 165,
	[BNXT_ULP_CLASS_HID_0749] = 166,
	[BNXT_ULP_CLASS_HID_05f1] = 167,
	[BNXT_ULP_CLASS_HID_04b7] = 168,
	[BNXT_ULP_CLASS_HID_049b] = 169,
	[BNXT_ULP_CLASS_HID_0759] = 170,
	[BNXT_ULP_CLASS_HID_05e1] = 171,
	[BNXT_ULP_CLASS_HID_04a7] = 172,
	[BNXT_ULP_CLASS_HID_0301] = 173,
	[BNXT_ULP_CLASS_HID_07f9] = 174,
	[BNXT_ULP_CLASS_HID_0397] = 175,
	[BNXT_ULP_CLASS_HID_068f] = 176,
	[BNXT_ULP_CLASS_HID_02f1] = 177,
	[BNXT_ULP_CLASS_HID_0609] = 178,
	[BNXT_ULP_CLASS_HID_0267] = 179,
	[BNXT_ULP_CLASS_HID_077f] = 180,
	[BNXT_ULP_CLASS_HID_01e1] = 181,
	[BNXT_ULP_CLASS_HID_0329] = 182,
	[BNXT_ULP_CLASS_HID_01c1] = 183,
	[BNXT_ULP_CLASS_HID_0309] = 184,
	[BNXT_ULP_CLASS_HID_01d1] = 185,
	[BNXT_ULP_CLASS_HID_0319] = 186,
	[BNXT_ULP_CLASS_HID_01e2] = 187,
	[BNXT_ULP_CLASS_HID_032a] = 188,
	[BNXT_ULP_CLASS_HID_0650] = 189,
	[BNXT_ULP_CLASS_HID_0198] = 190,
	[BNXT_ULP_CLASS_HID_01c2] = 191,
	[BNXT_ULP_CLASS_HID_030a] = 192,
	[BNXT_ULP_CLASS_HID_0670] = 193,
	[BNXT_ULP_CLASS_HID_01b8] = 194,
	[BNXT_ULP_CLASS_HID_01d2] = 195,
	[BNXT_ULP_CLASS_HID_031a] = 196,
	[BNXT_ULP_CLASS_HID_0660] = 197,
	[BNXT_ULP_CLASS_HID_01a8] = 198,
	[BNXT_ULP_CLASS_HID_01dd] = 199,
	[BNXT_ULP_CLASS_HID_0315] = 200,
	[BNXT_ULP_CLASS_HID_003d] = 201,
	[BNXT_ULP_CLASS_HID_02f5] = 202,
	[BNXT_ULP_CLASS_HID_01cd] = 203,
	[BNXT_ULP_CLASS_HID_0305] = 204,
	[BNXT_ULP_CLASS_HID_01de] = 205,
	[BNXT_ULP_CLASS_HID_0316] = 206,
	[BNXT_ULP_CLASS_HID_066c] = 207,
	[BNXT_ULP_CLASS_HID_01a4] = 208,
	[BNXT_ULP_CLASS_HID_003e] = 209,
	[BNXT_ULP_CLASS_HID_02f6] = 210,
	[BNXT_ULP_CLASS_HID_078c] = 211,
	[BNXT_ULP_CLASS_HID_0044] = 212,
	[BNXT_ULP_CLASS_HID_01ce] = 213,
	[BNXT_ULP_CLASS_HID_0306] = 214,
	[BNXT_ULP_CLASS_HID_067c] = 215,
	[BNXT_ULP_CLASS_HID_01b4] = 216
};

struct bnxt_ulp_class_match_info ulp_class_match_list[] = {
	[1] = {
	.class_hid = BNXT_ULP_CLASS_HID_0138,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 0
	},
	[2] = {
	.class_hid = BNXT_ULP_CLASS_HID_03f0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 1
	},
	[3] = {
	.class_hid = BNXT_ULP_CLASS_HID_0139,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 2
	},
	[4] = {
	.class_hid = BNXT_ULP_CLASS_HID_03f1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 3
	},
	[5] = {
	.class_hid = BNXT_ULP_CLASS_HID_068b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF6_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 4
	},
	[6] = {
	.class_hid = BNXT_ULP_CLASS_HID_0143,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 5
	},
	[7] = {
	.class_hid = BNXT_ULP_CLASS_HID_0118,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 6
	},
	[8] = {
	.class_hid = BNXT_ULP_CLASS_HID_03d0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 7
	},
	[9] = {
	.class_hid = BNXT_ULP_CLASS_HID_0119,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 8
	},
	[10] = {
	.class_hid = BNXT_ULP_CLASS_HID_03d1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 9
	},
	[11] = {
	.class_hid = BNXT_ULP_CLASS_HID_06ab,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF6_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 10
	},
	[12] = {
	.class_hid = BNXT_ULP_CLASS_HID_0163,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 11
	},
	[13] = {
	.class_hid = BNXT_ULP_CLASS_HID_0128,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 12
	},
	[14] = {
	.class_hid = BNXT_ULP_CLASS_HID_03e0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 13
	},
	[15] = {
	.class_hid = BNXT_ULP_CLASS_HID_0129,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 14
	},
	[16] = {
	.class_hid = BNXT_ULP_CLASS_HID_03e1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 15
	},
	[17] = {
	.class_hid = BNXT_ULP_CLASS_HID_069b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF6_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 16
	},
	[18] = {
	.class_hid = BNXT_ULP_CLASS_HID_0153,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF6_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF6_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF6_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 6,
	.wc_pri = 17
	},
	[19] = {
	.class_hid = BNXT_ULP_CLASS_HID_0134,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 0
	},
	[20] = {
	.class_hid = BNXT_ULP_CLASS_HID_03fc,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 1
	},
	[21] = {
	.class_hid = BNXT_ULP_CLASS_HID_0135,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 2
	},
	[22] = {
	.class_hid = BNXT_ULP_CLASS_HID_03fd,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 3
	},
	[23] = {
	.class_hid = BNXT_ULP_CLASS_HID_0687,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF7_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 4
	},
	[24] = {
	.class_hid = BNXT_ULP_CLASS_HID_014f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 5
	},
	[25] = {
	.class_hid = BNXT_ULP_CLASS_HID_0114,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 6
	},
	[26] = {
	.class_hid = BNXT_ULP_CLASS_HID_03dc,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 7
	},
	[27] = {
	.class_hid = BNXT_ULP_CLASS_HID_0115,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 8
	},
	[28] = {
	.class_hid = BNXT_ULP_CLASS_HID_03dd,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 9
	},
	[29] = {
	.class_hid = BNXT_ULP_CLASS_HID_06a7,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF7_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 10
	},
	[30] = {
	.class_hid = BNXT_ULP_CLASS_HID_016f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 11
	},
	[31] = {
	.class_hid = BNXT_ULP_CLASS_HID_0124,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 12
	},
	[32] = {
	.class_hid = BNXT_ULP_CLASS_HID_03ec,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 13
	},
	[33] = {
	.class_hid = BNXT_ULP_CLASS_HID_0125,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 14
	},
	[34] = {
	.class_hid = BNXT_ULP_CLASS_HID_03ed,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 15
	},
	[35] = {
	.class_hid = BNXT_ULP_CLASS_HID_0697,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF7_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 16
	},
	[36] = {
	.class_hid = BNXT_ULP_CLASS_HID_015f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF7_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF7_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF7_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 7,
	.wc_pri = 17
	},
	[37] = {
	.class_hid = BNXT_ULP_CLASS_HID_0452,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF8_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF8_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF8_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF8_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF8_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 8,
	.wc_pri = 0
	},
	[38] = {
	.class_hid = BNXT_ULP_CLASS_HID_0528,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF8_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF8_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF8_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF8_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 8,
	.wc_pri = 1
	},
	[39] = {
	.class_hid = BNXT_ULP_CLASS_HID_0790,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF8_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF8_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF8_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF8_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 8,
	.wc_pri = 2
	},
	[40] = {
	.class_hid = BNXT_ULP_CLASS_HID_046e,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF8_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF8_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF8_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF8_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 8,
	.wc_pri = 3
	},
	[41] = {
	.class_hid = BNXT_ULP_CLASS_HID_0462,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF9_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF9_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF9_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 9,
	.wc_pri = 0
	},
	[42] = {
	.class_hid = BNXT_ULP_CLASS_HID_0518,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF9_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF9_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 9,
	.wc_pri = 1
	},
	[43] = {
	.class_hid = BNXT_ULP_CLASS_HID_07a0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF9_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF9_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 9,
	.wc_pri = 2
	},
	[44] = {
	.class_hid = BNXT_ULP_CLASS_HID_045e,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF9_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF9_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF9_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF9_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 9,
	.wc_pri = 3
	},
	[45] = {
	.class_hid = BNXT_ULP_CLASS_HID_0228,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF10_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF10_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 10,
	.wc_pri = 0
	},
	[46] = {
	.class_hid = BNXT_ULP_CLASS_HID_06d0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF10_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 10,
	.wc_pri = 1
	},
	[47] = {
	.class_hid = BNXT_ULP_CLASS_HID_02be,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF10_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 10,
	.wc_pri = 2
	},
	[48] = {
	.class_hid = BNXT_ULP_CLASS_HID_07a6,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF10_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF10_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF10_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF10_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 10,
	.wc_pri = 3
	},
	[49] = {
	.class_hid = BNXT_ULP_CLASS_HID_0218,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF11_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF11_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF11_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF11_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF11_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF11_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 11,
	.wc_pri = 0
	},
	[50] = {
	.class_hid = BNXT_ULP_CLASS_HID_06e0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF11_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF11_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF11_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF11_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF11_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 11,
	.wc_pri = 1
	},
	[51] = {
	.class_hid = BNXT_ULP_CLASS_HID_028e,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF11_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF11_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF11_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF11_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF11_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 11,
	.wc_pri = 2
	},
	[52] = {
	.class_hid = BNXT_ULP_CLASS_HID_0796,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF11_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF11_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF11_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF11_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 11,
	.wc_pri = 3
	},
	[53] = {
	.class_hid = BNXT_ULP_CLASS_HID_079c,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 0
	},
	[54] = {
	.class_hid = BNXT_ULP_CLASS_HID_0654,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 1
	},
	[55] = {
	.class_hid = BNXT_ULP_CLASS_HID_06d2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 2
	},
	[56] = {
	.class_hid = BNXT_ULP_CLASS_HID_058a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 3
	},
	[57] = {
	.class_hid = BNXT_ULP_CLASS_HID_052f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 4
	},
	[58] = {
	.class_hid = BNXT_ULP_CLASS_HID_07e7,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 5
	},
	[59] = {
	.class_hid = BNXT_ULP_CLASS_HID_079d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 6
	},
	[60] = {
	.class_hid = BNXT_ULP_CLASS_HID_0655,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 7
	},
	[61] = {
	.class_hid = BNXT_ULP_CLASS_HID_046d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 8
	},
	[62] = {
	.class_hid = BNXT_ULP_CLASS_HID_0725,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 9
	},
	[63] = {
	.class_hid = BNXT_ULP_CLASS_HID_06d3,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 10
	},
	[64] = {
	.class_hid = BNXT_ULP_CLASS_HID_058b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF12_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF12_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF12_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF12_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF12_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 12,
	.wc_pri = 11
	},
	[65] = {
	.class_hid = BNXT_ULP_CLASS_HID_07ac,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 0
	},
	[66] = {
	.class_hid = BNXT_ULP_CLASS_HID_0664,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 1
	},
	[67] = {
	.class_hid = BNXT_ULP_CLASS_HID_06e2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 2
	},
	[68] = {
	.class_hid = BNXT_ULP_CLASS_HID_05ba,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 3
	},
	[69] = {
	.class_hid = BNXT_ULP_CLASS_HID_051f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 4
	},
	[70] = {
	.class_hid = BNXT_ULP_CLASS_HID_07d7,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 5
	},
	[71] = {
	.class_hid = BNXT_ULP_CLASS_HID_07ad,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 6
	},
	[72] = {
	.class_hid = BNXT_ULP_CLASS_HID_0665,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 7
	},
	[73] = {
	.class_hid = BNXT_ULP_CLASS_HID_045d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 8
	},
	[74] = {
	.class_hid = BNXT_ULP_CLASS_HID_0715,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 9
	},
	[75] = {
	.class_hid = BNXT_ULP_CLASS_HID_06e3,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 10
	},
	[76] = {
	.class_hid = BNXT_ULP_CLASS_HID_05bb,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF13_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF13_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF13_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF13_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF13_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 13,
	.wc_pri = 11
	},
	[77] = {
	.class_hid = BNXT_ULP_CLASS_HID_016a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 0
	},
	[78] = {
	.class_hid = BNXT_ULP_CLASS_HID_03d2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 1
	},
	[79] = {
	.class_hid = BNXT_ULP_CLASS_HID_0612,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 2
	},
	[80] = {
	.class_hid = BNXT_ULP_CLASS_HID_00da,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 3
	},
	[81] = {
	.class_hid = BNXT_ULP_CLASS_HID_06bd,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 4
	},
	[82] = {
	.class_hid = BNXT_ULP_CLASS_HID_0165,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 5
	},
	[83] = {
	.class_hid = BNXT_ULP_CLASS_HID_016b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 6
	},
	[84] = {
	.class_hid = BNXT_ULP_CLASS_HID_03d3,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 7
	},
	[85] = {
	.class_hid = BNXT_ULP_CLASS_HID_03a5,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 8
	},
	[86] = {
	.class_hid = BNXT_ULP_CLASS_HID_066d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 9
	},
	[87] = {
	.class_hid = BNXT_ULP_CLASS_HID_0613,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 10
	},
	[88] = {
	.class_hid = BNXT_ULP_CLASS_HID_00db,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF14_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF14_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF14_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF14_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF14_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 14,
	.wc_pri = 11
	},
	[89] = {
	.class_hid = BNXT_ULP_CLASS_HID_015a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 0
	},
	[90] = {
	.class_hid = BNXT_ULP_CLASS_HID_03e2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 1
	},
	[91] = {
	.class_hid = BNXT_ULP_CLASS_HID_0622,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 2
	},
	[92] = {
	.class_hid = BNXT_ULP_CLASS_HID_00ea,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 3
	},
	[93] = {
	.class_hid = BNXT_ULP_CLASS_HID_068d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 4
	},
	[94] = {
	.class_hid = BNXT_ULP_CLASS_HID_0155,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 5
	},
	[95] = {
	.class_hid = BNXT_ULP_CLASS_HID_015b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 6
	},
	[96] = {
	.class_hid = BNXT_ULP_CLASS_HID_03e3,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 7
	},
	[97] = {
	.class_hid = BNXT_ULP_CLASS_HID_0395,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 8
	},
	[98] = {
	.class_hid = BNXT_ULP_CLASS_HID_065d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 9
	},
	[99] = {
	.class_hid = BNXT_ULP_CLASS_HID_0623,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 10
	},
	[100] = {
	.class_hid = BNXT_ULP_CLASS_HID_00eb,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF15_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF15_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF15_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF15_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF15_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 15,
	.wc_pri = 11
	},
	[101] = {
	.class_hid = BNXT_ULP_CLASS_HID_04bc,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 0
	},
	[102] = {
	.class_hid = BNXT_ULP_CLASS_HID_0442,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 1
	},
	[103] = {
	.class_hid = BNXT_ULP_CLASS_HID_050a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 2
	},
	[104] = {
	.class_hid = BNXT_ULP_CLASS_HID_06ba,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 3
	},
	[105] = {
	.class_hid = BNXT_ULP_CLASS_HID_0472,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 4
	},
	[106] = {
	.class_hid = BNXT_ULP_CLASS_HID_0700,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 5
	},
	[107] = {
	.class_hid = BNXT_ULP_CLASS_HID_04c8,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 6
	},
	[108] = {
	.class_hid = BNXT_ULP_CLASS_HID_0678,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 7
	},
	[109] = {
	.class_hid = BNXT_ULP_CLASS_HID_061f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 8
	},
	[110] = {
	.class_hid = BNXT_ULP_CLASS_HID_05ad,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 9
	},
	[111] = {
	.class_hid = BNXT_ULP_CLASS_HID_06a5,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 10
	},
	[112] = {
	.class_hid = BNXT_ULP_CLASS_HID_0455,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 11
	},
	[113] = {
	.class_hid = BNXT_ULP_CLASS_HID_05dd,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 12
	},
	[114] = {
	.class_hid = BNXT_ULP_CLASS_HID_0563,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 13
	},
	[115] = {
	.class_hid = BNXT_ULP_CLASS_HID_059b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 14
	},
	[116] = {
	.class_hid = BNXT_ULP_CLASS_HID_070b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 15
	},
	[117] = {
	.class_hid = BNXT_ULP_CLASS_HID_04bd,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 16
	},
	[118] = {
	.class_hid = BNXT_ULP_CLASS_HID_0443,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 17
	},
	[119] = {
	.class_hid = BNXT_ULP_CLASS_HID_050b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 18
	},
	[120] = {
	.class_hid = BNXT_ULP_CLASS_HID_06bb,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 19
	},
	[121] = {
	.class_hid = BNXT_ULP_CLASS_HID_0473,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 20
	},
	[122] = {
	.class_hid = BNXT_ULP_CLASS_HID_0701,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 21
	},
	[123] = {
	.class_hid = BNXT_ULP_CLASS_HID_04c9,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 22
	},
	[124] = {
	.class_hid = BNXT_ULP_CLASS_HID_0679,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF16_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF16_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF16_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 16,
	.wc_pri = 23
	},
	[125] = {
	.class_hid = BNXT_ULP_CLASS_HID_05e2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 0
	},
	[126] = {
	.class_hid = BNXT_ULP_CLASS_HID_00b0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 1
	},
	[127] = {
	.class_hid = BNXT_ULP_CLASS_HID_0648,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 2
	},
	[128] = {
	.class_hid = BNXT_ULP_CLASS_HID_03f8,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 3
	},
	[129] = {
	.class_hid = BNXT_ULP_CLASS_HID_02ea,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 4
	},
	[130] = {
	.class_hid = BNXT_ULP_CLASS_HID_05b8,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 5
	},
	[131] = {
	.class_hid = BNXT_ULP_CLASS_HID_0370,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 6
	},
	[132] = {
	.class_hid = BNXT_ULP_CLASS_HID_00e0,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 7
	},
	[133] = {
	.class_hid = BNXT_ULP_CLASS_HID_0745,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 8
	},
	[134] = {
	.class_hid = BNXT_ULP_CLASS_HID_0213,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 9
	},
	[135] = {
	.class_hid = BNXT_ULP_CLASS_HID_031b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 10
	},
	[136] = {
	.class_hid = BNXT_ULP_CLASS_HID_008b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 11
	},
	[137] = {
	.class_hid = BNXT_ULP_CLASS_HID_044d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 12
	},
	[138] = {
	.class_hid = BNXT_ULP_CLASS_HID_071b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_TYPE |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 13
	},
	[139] = {
	.class_hid = BNXT_ULP_CLASS_HID_0003,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 14
	},
	[140] = {
	.class_hid = BNXT_ULP_CLASS_HID_05b3,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_OO_VLAN_VID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 15
	},
	[141] = {
	.class_hid = BNXT_ULP_CLASS_HID_05e3,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 16
	},
	[142] = {
	.class_hid = BNXT_ULP_CLASS_HID_00b1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 17
	},
	[143] = {
	.class_hid = BNXT_ULP_CLASS_HID_0649,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 18
	},
	[144] = {
	.class_hid = BNXT_ULP_CLASS_HID_03f9,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 19
	},
	[145] = {
	.class_hid = BNXT_ULP_CLASS_HID_02eb,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 20
	},
	[146] = {
	.class_hid = BNXT_ULP_CLASS_HID_05b9,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 21
	},
	[147] = {
	.class_hid = BNXT_ULP_CLASS_HID_0371,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 22
	},
	[148] = {
	.class_hid = BNXT_ULP_CLASS_HID_00e1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF17_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF17_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF17_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 17,
	.wc_pri = 23
	},
	[149] = {
	.class_hid = BNXT_ULP_CLASS_HID_0000,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF18_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 0
	},
	[150] = {
	.class_hid = BNXT_ULP_CLASS_HID_00ce,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 1
	},
	[151] = {
	.class_hid = BNXT_ULP_CLASS_HID_01b6,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF18_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 2
	},
	[152] = {
	.class_hid = BNXT_ULP_CLASS_HID_0074,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 3
	},
	[153] = {
	.class_hid = BNXT_ULP_CLASS_HID_00fe,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF18_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 4
	},
	[154] = {
	.class_hid = BNXT_ULP_CLASS_HID_03bc,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 5
	},
	[155] = {
	.class_hid = BNXT_ULP_CLASS_HID_0206,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 6
	},
	[156] = {
	.class_hid = BNXT_ULP_CLASS_HID_02c4,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_F1 |
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF18_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF18_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF18_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 18,
	.wc_pri = 7
	},
	[157] = {
	.class_hid = BNXT_ULP_CLASS_HID_055a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF19_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 0
	},
	[158] = {
	.class_hid = BNXT_ULP_CLASS_HID_045a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 1
	},
	[159] = {
	.class_hid = BNXT_ULP_CLASS_HID_061a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 2
	},
	[160] = {
	.class_hid = BNXT_ULP_CLASS_HID_051a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_SMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 3
	},
	[161] = {
	.class_hid = BNXT_ULP_CLASS_HID_074a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF19_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 4
	},
	[162] = {
	.class_hid = BNXT_ULP_CLASS_HID_004e,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 5
	},
	[163] = {
	.class_hid = BNXT_ULP_CLASS_HID_040a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 6
	},
	[164] = {
	.class_hid = BNXT_ULP_CLASS_HID_010e,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_HDR_BIT_T_VXLAN |
		BNXT_ULP_HDR_BIT_I_ETH |
		BNXT_ULP_HDR_BIT_I_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_ING },
	.field_sig = { .bits =
		BNXT_ULP_HF19_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF19_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF19_BITMASK_T_VXLAN_VNI |
		BNXT_ULP_HF19_BITMASK_I_ETH_DMAC |
		BNXT_ULP_HF19_BITMASK_I_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 19,
	.wc_pri = 7
	},
	[165] = {
	.class_hid = BNXT_ULP_CLASS_HID_048b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF20_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF20_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF20_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF20_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF20_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF20_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 20,
	.wc_pri = 0
	},
	[166] = {
	.class_hid = BNXT_ULP_CLASS_HID_0749,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF20_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF20_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF20_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF20_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF20_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 20,
	.wc_pri = 1
	},
	[167] = {
	.class_hid = BNXT_ULP_CLASS_HID_05f1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF20_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF20_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF20_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF20_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF20_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 20,
	.wc_pri = 2
	},
	[168] = {
	.class_hid = BNXT_ULP_CLASS_HID_04b7,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF20_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF20_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF20_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF20_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 20,
	.wc_pri = 3
	},
	[169] = {
	.class_hid = BNXT_ULP_CLASS_HID_049b,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF21_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF21_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF21_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF21_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF21_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF21_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 21,
	.wc_pri = 0
	},
	[170] = {
	.class_hid = BNXT_ULP_CLASS_HID_0759,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF21_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF21_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF21_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF21_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF21_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 21,
	.wc_pri = 1
	},
	[171] = {
	.class_hid = BNXT_ULP_CLASS_HID_05e1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF21_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF21_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF21_BITMASK_O_IPV4_PROTO_ID |
		BNXT_ULP_HF21_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF21_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 21,
	.wc_pri = 2
	},
	[172] = {
	.class_hid = BNXT_ULP_CLASS_HID_04a7,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF21_BITMASK_O_IPV4_SRC_ADDR |
		BNXT_ULP_HF21_BITMASK_O_IPV4_DST_ADDR |
		BNXT_ULP_HF21_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF21_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 21,
	.wc_pri = 3
	},
	[173] = {
	.class_hid = BNXT_ULP_CLASS_HID_0301,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF22_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF22_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF22_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF22_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF22_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF22_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 22,
	.wc_pri = 0
	},
	[174] = {
	.class_hid = BNXT_ULP_CLASS_HID_07f9,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF22_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF22_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF22_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF22_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF22_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 22,
	.wc_pri = 1
	},
	[175] = {
	.class_hid = BNXT_ULP_CLASS_HID_0397,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF22_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF22_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF22_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF22_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF22_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 22,
	.wc_pri = 2
	},
	[176] = {
	.class_hid = BNXT_ULP_CLASS_HID_068f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF22_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF22_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF22_BITMASK_O_UDP_SRC_PORT |
		BNXT_ULP_HF22_BITMASK_O_UDP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 22,
	.wc_pri = 3
	},
	[177] = {
	.class_hid = BNXT_ULP_CLASS_HID_02f1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF23_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF23_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF23_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF23_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF23_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF23_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 23,
	.wc_pri = 0
	},
	[178] = {
	.class_hid = BNXT_ULP_CLASS_HID_0609,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF23_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF23_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF23_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF23_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF23_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 23,
	.wc_pri = 1
	},
	[179] = {
	.class_hid = BNXT_ULP_CLASS_HID_0267,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF23_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF23_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF23_BITMASK_O_IPV6_PROTO_ID |
		BNXT_ULP_HF23_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF23_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 23,
	.wc_pri = 2
	},
	[180] = {
	.class_hid = BNXT_ULP_CLASS_HID_077f,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF23_BITMASK_O_IPV6_SRC_ADDR |
		BNXT_ULP_HF23_BITMASK_O_IPV6_DST_ADDR |
		BNXT_ULP_HF23_BITMASK_O_TCP_SRC_PORT |
		BNXT_ULP_HF23_BITMASK_O_TCP_DST_PORT |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 23,
	.wc_pri = 3
	},
	[181] = {
	.class_hid = BNXT_ULP_CLASS_HID_01e1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 0
	},
	[182] = {
	.class_hid = BNXT_ULP_CLASS_HID_0329,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 1
	},
	[183] = {
	.class_hid = BNXT_ULP_CLASS_HID_01c1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 2
	},
	[184] = {
	.class_hid = BNXT_ULP_CLASS_HID_0309,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 3
	},
	[185] = {
	.class_hid = BNXT_ULP_CLASS_HID_01d1,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 4
	},
	[186] = {
	.class_hid = BNXT_ULP_CLASS_HID_0319,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 5
	},
	[187] = {
	.class_hid = BNXT_ULP_CLASS_HID_01e2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 6
	},
	[188] = {
	.class_hid = BNXT_ULP_CLASS_HID_032a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 7
	},
	[189] = {
	.class_hid = BNXT_ULP_CLASS_HID_0650,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF24_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 8
	},
	[190] = {
	.class_hid = BNXT_ULP_CLASS_HID_0198,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 9
	},
	[191] = {
	.class_hid = BNXT_ULP_CLASS_HID_01c2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 10
	},
	[192] = {
	.class_hid = BNXT_ULP_CLASS_HID_030a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 11
	},
	[193] = {
	.class_hid = BNXT_ULP_CLASS_HID_0670,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF24_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 12
	},
	[194] = {
	.class_hid = BNXT_ULP_CLASS_HID_01b8,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 13
	},
	[195] = {
	.class_hid = BNXT_ULP_CLASS_HID_01d2,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 14
	},
	[196] = {
	.class_hid = BNXT_ULP_CLASS_HID_031a,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 15
	},
	[197] = {
	.class_hid = BNXT_ULP_CLASS_HID_0660,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF24_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 16
	},
	[198] = {
	.class_hid = BNXT_ULP_CLASS_HID_01a8,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV4 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF24_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF24_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF24_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 24,
	.wc_pri = 17
	},
	[199] = {
	.class_hid = BNXT_ULP_CLASS_HID_01dd,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 0
	},
	[200] = {
	.class_hid = BNXT_ULP_CLASS_HID_0315,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 1
	},
	[201] = {
	.class_hid = BNXT_ULP_CLASS_HID_003d,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 2
	},
	[202] = {
	.class_hid = BNXT_ULP_CLASS_HID_02f5,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 3
	},
	[203] = {
	.class_hid = BNXT_ULP_CLASS_HID_01cd,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 4
	},
	[204] = {
	.class_hid = BNXT_ULP_CLASS_HID_0305,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 5
	},
	[205] = {
	.class_hid = BNXT_ULP_CLASS_HID_01de,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 6
	},
	[206] = {
	.class_hid = BNXT_ULP_CLASS_HID_0316,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 7
	},
	[207] = {
	.class_hid = BNXT_ULP_CLASS_HID_066c,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF25_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 8
	},
	[208] = {
	.class_hid = BNXT_ULP_CLASS_HID_01a4,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 9
	},
	[209] = {
	.class_hid = BNXT_ULP_CLASS_HID_003e,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 10
	},
	[210] = {
	.class_hid = BNXT_ULP_CLASS_HID_02f6,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 11
	},
	[211] = {
	.class_hid = BNXT_ULP_CLASS_HID_078c,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF25_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 12
	},
	[212] = {
	.class_hid = BNXT_ULP_CLASS_HID_0044,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_UDP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 13
	},
	[213] = {
	.class_hid = BNXT_ULP_CLASS_HID_01ce,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 14
	},
	[214] = {
	.class_hid = BNXT_ULP_CLASS_HID_0306,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 15
	},
	[215] = {
	.class_hid = BNXT_ULP_CLASS_HID_067c,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_TYPE |
		BNXT_ULP_HF25_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 16
	},
	[216] = {
	.class_hid = BNXT_ULP_CLASS_HID_01b4,
	.hdr_sig = { .bits =
		BNXT_ULP_HDR_BIT_O_ETH |
		BNXT_ULP_HDR_BIT_OO_VLAN |
		BNXT_ULP_HDR_BIT_O_IPV6 |
		BNXT_ULP_HDR_BIT_O_TCP |
		BNXT_ULP_FLOW_DIR_BITMASK_EGR },
	.field_sig = { .bits =
		BNXT_ULP_HF25_BITMASK_O_ETH_SMAC |
		BNXT_ULP_HF25_BITMASK_O_ETH_DMAC |
		BNXT_ULP_HF25_BITMASK_OO_VLAN_VID |
		BNXT_ULP_MATCH_TYPE_BITMASK_EM },
	.class_tid = 25,
	.wc_pri = 17
	}
};
