/*
   Copyright The containerd Authors.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package apply

import (
	"context"
	"io"

	"github.com/containerd/containerd/archive"
	"github.com/containerd/containerd/mount"
)

func apply(ctx context.Context, mounts []mount.Mount, r io.Reader) error {
	// We currently do not support mounts nor bind mounts on MacOS in the containerd daemon.
	// Using this as an exception to enable native snapshotter and allow further research.
	if len(mounts) == 1 && mounts[0].Type == "bind" {
		path := mounts[0].Source
		_, err := archive.Apply(ctx, path, r)
		return err
	}

	return mount.WithTempMount(ctx, mounts, func(root string) error {
		_, err := archive.Apply(ctx, root, r)
		return err
	})
}
