{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAppearance: TAppearanceNode;
    procedure SetAppearance(const Value: TAppearanceNode);
    function GetGeometry: TAbstractGeometryNode;
    procedure SetGeometry(const Value: TAbstractGeometryNode);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
    function GetShading: TShading;
    procedure SetShading(const Value: TShading);
    function GetVisible: Boolean;
    procedure SetVisible(const Value: Boolean);
    function GetCollision: TShapeCollision;
    procedure SetCollision(const Value: TShapeCollision);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdAppearance: TSFNode;
    { Internal wrapper for property @code(Appearance). This wrapper API may change, we advise to access simpler @code(Appearance) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdAppearance: TSFNode read FFdAppearance;
    {  }
    property Appearance: TAppearanceNode read GetAppearance write SetAppearance;

    strict private FFdGeometry: TSFNode;
    { Internal wrapper for property @code(Geometry). This wrapper API may change, we advise to access simpler @code(Geometry) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGeometry: TSFNode read FFdGeometry;
    {  }
    property Geometry: TAbstractGeometryNode read GetGeometry write SetGeometry;

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @code(BboxCenter). This wrapper API may change, we advise to access simpler @code(BboxCenter) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    { You can provide a manually-calculated bounding box of the shape here, for optimization purposes. Leave this field as empty (TBox3D.Empty) to let the engine calculate best bounding box automatically.

      Manually providing the bounding box makes sense if you can do it more efficiently than the engine. E.g. if the shape vertexes are animated, then the engine would have to recalcualate the perfect bounding box every frame. It is more efficient to calculate a bounding box of all possible animation frames, and store it here.

      The glTF skinned animation automatically fills this field for the affected shapes.

      @italic(Note: This property is not useful if you want to know the bounding box of a shape, calculated by the engine). This property only allows to override the automatic engine calculation.

      To read the calculated bounding box, load the nodes to TCastleScene. You can then use @link(TCastleTransform.BoundingBox Scene.BoundingBox), @link(TCastleTransform.LocalBoundingBox Scene.LocalBoundingBox), @link(TCastleTransform.WorldBoundingBox Scene.WorldBoundingBox) to know bounding box of the scene. To get bounding box of a particular shape, enumerate @link(TCastleSceneCore.Shapes) to find the correct shape (using any criteria you want -- note that the same TShapeNode may be reused multiple times), and then read @link(TShape.BoundingBox), @link(TShape.LocalBoundingBox). }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @code(BboxSize). This wrapper API may change, we advise to access simpler @code(BboxSize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

    strict private FFdShading: TSFStringEnum;
    { Internal wrapper for property @code(Shading). This wrapper API may change, we advise to access simpler @code(Shading) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShading: TSFStringEnum read FFdShading;
    { How to display given shape. }
    property Shading: TShading read GetShading write SetShading;

    strict private FFdVisible: TSFBool;
    { Internal wrapper for property @code(Visible). This wrapper API may change, we advise to access simpler @code(Visible) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdVisible: TSFBool read FFdVisible;
    { Is the shape visible. Shapes that are not visible are not rendered, but otherwise are still processed (for example, hidden shapes are still used for collision detection). Toggling this is guaranteed to be ultra-fast.

Note: An alternative method to hide (and more) things in X3D is to wrap them in a @link(TSwitchNode), and toggle @link(TSwitchNode.WhichChoice) between -1 and 0. When @link(TSwitchNode.WhichChoice) is -1, the children are not processed (not rendered, and do not collide). }
    property Visible: Boolean read GetVisible write SetVisible;

    strict private FFdCollision: TSFStringEnum;
    { Internal wrapper for property @code(Collision). This wrapper API may change, we advise to access simpler @code(Collision) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCollision: TSFStringEnum read FFdCollision;
    { How does the given shape collide. This only matters if @link(TCastleSceneCore.PreciseCollisions) is @true, otherwise the whole scene (with all shapes) collides as one big bounding box. }
    property Collision: TShapeCollision read GetCollision write SetCollision;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractShapeNode ----------------------------------------------- }

function TAbstractShapeNode.GetAppearance: TAppearanceNode;
begin
  if FdAppearance.Value is TAppearanceNode then
    Result := TAppearanceNode(FdAppearance.Value)
  else
    Result := nil;
end;

procedure TAbstractShapeNode.SetAppearance(const Value: TAppearanceNode);
begin
  FdAppearance.Send(Value);
end;

function TAbstractShapeNode.GetGeometry: TAbstractGeometryNode;
begin
  if FdGeometry.Value is TAbstractGeometryNode then
    Result := TAbstractGeometryNode(FdGeometry.Value)
  else
    Result := nil;
end;

procedure TAbstractShapeNode.SetGeometry(const Value: TAbstractGeometryNode);
begin
  FdGeometry.Send(Value);
end;

function TAbstractShapeNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TAbstractShapeNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

function TAbstractShapeNode.GetShading: TShading;
begin
  Result := TShading(FdShading.EnumValue);
end;

procedure TAbstractShapeNode.SetShading(const Value: TShading);
begin
  FdShading.SendEnumValue(Ord(Value));
end;

function TAbstractShapeNode.GetVisible: Boolean;
begin
  Result := FdVisible.Value;
end;

procedure TAbstractShapeNode.SetVisible(const Value: Boolean);
begin
  FdVisible.Send(Value);
end;

function TAbstractShapeNode.GetCollision: TShapeCollision;
begin
  Result := TShapeCollision(FdCollision.EnumValue);
end;

procedure TAbstractShapeNode.SetCollision(const Value: TShapeCollision);
begin
  FdCollision.SendEnumValue(Ord(Value));
end;

class function TAbstractShapeNode.ClassX3DType: String;
begin
  Result := 'X3DShapeNode';
end;

procedure TAbstractShapeNode.CreateNode;
begin
  inherited;

  FFdAppearance := TSFNode.Create(Self, True, 'appearance', [TAppearanceNode]);
   FdAppearance.ChangeAlways := chVisibleNonGeometry;
   FdAppearance.OnBeforeValueChange := {$ifdef FPC}@{$endif}SetAppearanceBefore;
  AddField(FFdAppearance);

  FFdGeometry := TSFNode.Create(Self, True, 'geometry', [TAbstractGeometryNode]);
   FdGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGeometry);

  FFdBboxCenter := TSFVec3f.Create(Self, True, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, True, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);

  FFdShading := TSFStringEnum.Create(Self, True, 'shading', @ShadingNames, Ord(High(ShadingNames)) + 1, Ord(shDefault));
   FdShading.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShading);

  FFdVisible := TSFBool.Create(Self, True, 'visible', true);
   FdVisible.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdVisible);

  FFdCollision := TSFStringEnum.Create(Self, False, 'collision', @ShapeCollisionNames, Ord(High(ShapeCollisionNames)) + 1, Ord(scDefault));
   FdCollision.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdCollision);
end;

{$endif read_implementation}
