{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetSize: TVector3;
    procedure SetSize(const Value: TVector3);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdCenter: TSFVec3f;
    { Internal wrapper for property @code(Center). This wrapper API may change, we advise to access simpler @code(Center) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdCenter: TSFVec3f read FFdCenter;
    {  }
    property Center: TVector3 read GetCenter write SetCenter;

    strict private FFdSize: TSFVec3f;
    { Internal wrapper for property @code(Size). This wrapper API may change, we advise to access simpler @code(Size) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSize: TSFVec3f read FFdSize;
    {  }
    property Size: TVector3 read GetSize write SetSize;

    strict private FEventEnterTime: TSFTimeEvent;
    {  }
    public property EventEnterTime: TSFTimeEvent read FEventEnterTime;

    strict private FEventExitTime: TSFTimeEvent;
    {  }
    public property EventExitTime: TSFTimeEvent read FEventExitTime;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractEnvironmentalSensorNode ----------------------------------------------- }

function TAbstractEnvironmentalSensorNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure TAbstractEnvironmentalSensorNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

function TAbstractEnvironmentalSensorNode.GetSize: TVector3;
begin
  Result := FdSize.Value;
end;

procedure TAbstractEnvironmentalSensorNode.SetSize(const Value: TVector3);
begin
  FdSize.Send(Value);
end;

class function TAbstractEnvironmentalSensorNode.ClassX3DType: String;
begin
  Result := 'X3DEnvironmentalSensorNode';
end;

procedure TAbstractEnvironmentalSensorNode.CreateNode;
begin
  inherited;

  FFdCenter := TSFVec3f.Create(Self, True, 'center', Vector3(0, 0, 0));
   FdCenter.ChangeAlways := chEnvironmentalSensorBounds;
  AddField(FFdCenter);

  FFdSize := TSFVec3f.Create(Self, True, 'size', Vector3(0, 0, 0));
   FdSize.ChangeAlways := chEnvironmentalSensorBounds;
  AddField(FFdSize);

  FEventEnterTime := TSFTimeEvent.Create(Self, 'enterTime', false);
  AddEvent(FEventEnterTime);

  FEventExitTime := TSFTimeEvent.Create(Self, 'exitTime', false);
  AddEvent(FEventExitTime);
end;

{$endif read_implementation}
