{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FEventHitNormal_changed: TSFVec3fEvent;
    {  }
    public property EventHitNormal_changed: TSFVec3fEvent read FEventHitNormal_changed;

    strict private FEventHitPoint_changed: TSFVec3fEvent;
    {  }
    public property EventHitPoint_changed: TSFVec3fEvent read FEventHitPoint_changed;

    strict private FEventHitTexCoord_changed: TSFVec2fEvent;
    {  }
    public property EventHitTexCoord_changed: TSFVec2fEvent read FEventHitTexCoord_changed;

{$endif read_interface}

{$ifdef read_implementation}

{ TTouchSensorNode ----------------------------------------------- }

class function TTouchSensorNode.ClassX3DType: String;
begin
  Result := 'TouchSensor';
end;

procedure TTouchSensorNode.CreateNode;
begin
  inherited;

  FEventHitNormal_changed := TSFVec3fEvent.Create(Self, 'hitNormal_changed', false);
  AddEvent(FEventHitNormal_changed);

  FEventHitPoint_changed := TSFVec3fEvent.Create(Self, 'hitPoint_changed', false);
  AddEvent(FEventHitPoint_changed);

  FEventHitTexCoord_changed := TSFVec2fEvent.Create(Self, 'hitTexCoord_changed', false);
  AddEvent(FEventHitTexCoord_changed);
end;

{$endif read_implementation}
