{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetEnableARC: Boolean;
    procedure SetEnableARC(const Value: Boolean);
    function GetFrustumCulling: Boolean;
    procedure SetFrustumCulling(const Value: Boolean);
    function GetGammaCorrectionDefault: String;
    procedure SetGammaCorrectionDefault(const Value: String);
    function GetLowPriorityCulling: Boolean;
    procedure SetLowPriorityCulling(const Value: Boolean);
    function GetLowPriorityFactor: Single;
    procedure SetLowPriorityFactor(const Value: Single);
    function GetLowPriorityThreshold: Single;
    procedure SetLowPriorityThreshold(const Value: Single);
    function GetMaxFrameRate: Single;
    procedure SetMaxFrameRate(const Value: Single);
    function GetMinFrameRate: Single;
    procedure SetMinFrameRate(const Value: Single);
    function GetOcclusionCulling: Boolean;
    procedure SetOcclusionCulling(const Value: Boolean);
    function GetOcclusionVisibilityFactor: Single;
    procedure SetOcclusionVisibilityFactor(const Value: Single);
    function GetOcclusionVisibilityThreshold: Single;
    procedure SetOcclusionVisibilityThreshold(const Value: Single);
    function GetShadowExcludeTransparentObjects: Boolean;
    procedure SetShadowExcludeTransparentObjects(const Value: Boolean);
    function GetSmallFeatureCulling: Boolean;
    procedure SetSmallFeatureCulling(const Value: Boolean);
    function GetSmallFeatureFactor: Single;
    procedure SetSmallFeatureFactor(const Value: Single);
    function GetSmallFeatureThreshold: Single;
    procedure SetSmallFeatureThreshold(const Value: Single);
    function GetSortTrans: Boolean;
    procedure SetSortTrans(const Value: Boolean);
    function GetSSAO: Boolean;
    procedure SetSSAO(const Value: Boolean);
    function GetSSAOamount: Single;
    procedure SetSSAOamount(const Value: Single);
    function GetSSAOblurDepthTreshold: Single;
    procedure SetSSAOblurDepthTreshold(const Value: Single);
    function GetSSAOradius: Single;
    procedure SetSSAOradius(const Value: Single);
    function GetSSAOrandomTextureSize: Single;
    procedure SetSSAOrandomTextureSize(const Value: Single);
    function GetTessellationDetailCulling: Boolean;
    procedure SetTessellationDetailCulling(const Value: Boolean);
    function GetTessellationErrorFactor: Single;
    procedure SetTessellationErrorFactor(const Value: Single);
    function GetTessellationErrorThreshold: Single;
    procedure SetTessellationErrorThreshold(const Value: Single);
    function GetTonemapping: TToneMapping;
    procedure SetTonemapping(const Value: TToneMapping);
    function GetUserDataFactor: Single;
    procedure SetUserDataFactor(const Value: Single);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdEnableARC: TSFBool;
    { Internal wrapper for property @code(EnableARC). This wrapper API may change, we advise to access simpler @code(EnableARC) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdEnableARC: TSFBool read FFdEnableARC;
    { Experimental: If true ARC adjusts rendering parameters }
    property EnableARC: Boolean read GetEnableARC write SetEnableARC;

    strict private FFdFrustumCulling: TSFBool;
    { Internal wrapper for property @code(FrustumCulling). This wrapper API may change, we advise to access simpler @code(FrustumCulling) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdFrustumCulling: TSFBool read FFdFrustumCulling;
    { If TRUE, objects outside the viewing frustum are ignored }
    property FrustumCulling: Boolean read GetFrustumCulling write SetFrustumCulling;

    strict private FFdGammaCorrectionDefault: TSFString;
    { Internal wrapper for property @code(GammaCorrectionDefault). This wrapper API may change, we advise to access simpler @code(GammaCorrectionDefault) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdGammaCorrectionDefault: TSFString read FFdGammaCorrectionDefault;
    { The gamma correction to apply by default, see lighting and gamma tutorial }
    property GammaCorrectionDefault: String read GetGammaCorrectionDefault write SetGammaCorrectionDefault;

    strict private FFdLowPriorityCulling: TSFBool;
    { Internal wrapper for property @code(LowPriorityCulling). This wrapper API may change, we advise to access simpler @code(LowPriorityCulling) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLowPriorityCulling: TSFBool read FFdLowPriorityCulling;
    { If TRUE and occlusion culling supported, only threshold fraction of objects, sorted by their screen space coverage, are rendered }
    property LowPriorityCulling: Boolean read GetLowPriorityCulling write SetLowPriorityCulling;

    strict private FFdLowPriorityFactor: TSFFloat;
    { Internal wrapper for property @code(LowPriorityFactor). This wrapper API may change, we advise to access simpler @code(LowPriorityFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLowPriorityFactor: TSFFloat read FFdLowPriorityFactor;
    { Experimenal: Factor of low priority culling for controlling speed-performance trade-off }
    property LowPriorityFactor: Single read GetLowPriorityFactor write SetLowPriorityFactor;

    strict private FFdLowPriorityThreshold: TSFFloat;
    { Internal wrapper for property @code(LowPriorityThreshold). This wrapper API may change, we advise to access simpler @code(LowPriorityThreshold) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdLowPriorityThreshold: TSFFloat read FFdLowPriorityThreshold;
    { Only threshold fraction of objects, sorted by their screen space coverage, are rendered }
    property LowPriorityThreshold: Single read GetLowPriorityThreshold write SetLowPriorityThreshold;

    strict private FFdMaxFrameRate: TSFFloat;
    { Internal wrapper for property @code(MaxFrameRate). This wrapper API may change, we advise to access simpler @code(MaxFrameRate) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMaxFrameRate: TSFFloat read FFdMaxFrameRate;
    { Experimental: Define maximal target frame-rate for dynamic moments and quality-speed trade-off }
    property MaxFrameRate: Single read GetMaxFrameRate write SetMaxFrameRate;

    strict private FFdMinFrameRate: TSFFloat;
    { Internal wrapper for property @code(MinFrameRate). This wrapper API may change, we advise to access simpler @code(MinFrameRate) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdMinFrameRate: TSFFloat read FFdMinFrameRate;
    { Experimental: Define minimal target frame-rate for static moments and quality-speed trade-off }
    property MinFrameRate: Single read GetMinFrameRate write SetMinFrameRate;

    strict private FFdOcclusionCulling: TSFBool;
    { Internal wrapper for property @code(OcclusionCulling). This wrapper API may change, we advise to access simpler @code(OcclusionCulling) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOcclusionCulling: TSFBool read FFdOcclusionCulling;
    { If TRUE and occlusion culling supported, objects occluding less than the threshold below are ignored }
    property OcclusionCulling: Boolean read GetOcclusionCulling write SetOcclusionCulling;

    strict private FFdOcclusionVisibilityFactor: TSFFloat;
    { Internal wrapper for property @code(OcclusionVisibilityFactor). This wrapper API may change, we advise to access simpler @code(OcclusionVisibilityFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOcclusionVisibilityFactor: TSFFloat read FFdOcclusionVisibilityFactor;
    { Experimenal: Factor of occlusion culling for controlling speed-performance trade-off }
    property OcclusionVisibilityFactor: Single read GetOcclusionVisibilityFactor write SetOcclusionVisibilityFactor;

    strict private FFdOcclusionVisibilityThreshold: TSFFloat;
    { Internal wrapper for property @code(OcclusionVisibilityThreshold). This wrapper API may change, we advise to access simpler @code(OcclusionVisibilityThreshold) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdOcclusionVisibilityThreshold: TSFFloat read FFdOcclusionVisibilityThreshold;
    { Objects occluding less than the threshold below are ignored }
    property OcclusionVisibilityThreshold: Single read GetOcclusionVisibilityThreshold write SetOcclusionVisibilityThreshold;

    strict private FFdShadowExcludeTransparentObjects: TSFBool;
    { Internal wrapper for property @code(ShadowExcludeTransparentObjects). This wrapper API may change, we advise to access simpler @code(ShadowExcludeTransparentObjects) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShadowExcludeTransparentObjects: TSFBool read FFdShadowExcludeTransparentObjects;
    { Transparent objects like glass do not throw much shadow, enable this IR convenience flag with TRUE }
    property ShadowExcludeTransparentObjects: Boolean read GetShadowExcludeTransparentObjects write SetShadowExcludeTransparentObjects;

    strict private FFdSmallFeatureCulling: TSFBool;
    { Internal wrapper for property @code(SmallFeatureCulling). This wrapper API may change, we advise to access simpler @code(SmallFeatureCulling) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSmallFeatureCulling: TSFBool read FFdSmallFeatureCulling;
    { If TRUE, objects smaller than the threshold below are ignored }
    property SmallFeatureCulling: Boolean read GetSmallFeatureCulling write SetSmallFeatureCulling;

    strict private FFdSmallFeatureFactor: TSFFloat;
    { Internal wrapper for property @code(SmallFeatureFactor). This wrapper API may change, we advise to access simpler @code(SmallFeatureFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSmallFeatureFactor: TSFFloat read FFdSmallFeatureFactor;
    { Experimenal: Factor of small feature culling for controlling speed-performance trade-off }
    property SmallFeatureFactor: Single read GetSmallFeatureFactor write SetSmallFeatureFactor;

    strict private FFdSmallFeatureThreshold: TSFFloat;
    { Internal wrapper for property @code(SmallFeatureThreshold). This wrapper API may change, we advise to access simpler @code(SmallFeatureThreshold) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSmallFeatureThreshold: TSFFloat read FFdSmallFeatureThreshold;
    { Objects smaller than the threshold below are ignored }
    property SmallFeatureThreshold: Single read GetSmallFeatureThreshold write SetSmallFeatureThreshold;

    strict private FFdSortTrans: TSFBool;
    { Internal wrapper for property @code(SortTrans). This wrapper API may change, we advise to access simpler @code(SortTrans) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSortTrans: TSFBool read FFdSortTrans;
    { If TRUE, transparent objects are sorted from back to front (allows explicitly disabling sorting) }
    property SortTrans: Boolean read GetSortTrans write SetSortTrans;

    strict private FFdSSAO: TSFBool;
    { Internal wrapper for property @code(SSAO). This wrapper API may change, we advise to access simpler @code(SSAO) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSSAO: TSFBool read FFdSSAO;
    { Flag to enable Screen Space Ambient Occlusion }
    property SSAO: Boolean read GetSSAO write SetSSAO;

    strict private FFdSSAOamount: TSFFloat;
    { Internal wrapper for property @code(SSAOamount). This wrapper API may change, we advise to access simpler @code(SSAOamount) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSSAOamount: TSFFloat read FFdSSAOamount;
    { Value that determines the amount of contribution of SSAO (from 0 to 1) }
    property SSAOamount: Single read GetSSAOamount write SetSSAOamount;

    strict private FFdSSAOblurDepthTreshold: TSFFloat;
    { Internal wrapper for property @code(SSAOblurDepthTreshold). This wrapper API may change, we advise to access simpler @code(SSAOblurDepthTreshold) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSSAOblurDepthTreshold: TSFFloat read FFdSSAOblurDepthTreshold;
    { Value that determines the maximum depth difference for the SSAO blurring pass. Pixels with higher depth difference to the filer kernel center are not incorporated into the average. }
    property SSAOblurDepthTreshold: Single read GetSSAOblurDepthTreshold write SetSSAOblurDepthTreshold;

    strict private FFdSSAOradius: TSFFloat;
    { Internal wrapper for property @code(SSAOradius). This wrapper API may change, we advise to access simpler @code(SSAOradius) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSSAOradius: TSFFloat read FFdSSAOradius;
    { Value that determines the radius in which the SSAO is sampled in world space }
    property SSAOradius: Single read GetSSAOradius write SetSSAOradius;

    strict private FFdSSAOrandomTextureSize: TSFFloat;
    { Internal wrapper for property @code(SSAOrandomTextureSize). This wrapper API may change, we advise to access simpler @code(SSAOrandomTextureSize) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdSSAOrandomTextureSize: TSFFloat read FFdSSAOrandomTextureSize;
    { Value that determines the size of the random texture used for sparse sampling of SSAO }
    property SSAOrandomTextureSize: Single read GetSSAOrandomTextureSize write SetSSAOrandomTextureSize;

    strict private FFdTessellationDetailCulling: TSFBool;
    { Internal wrapper for property @code(TessellationDetailCulling). This wrapper API may change, we advise to access simpler @code(TessellationDetailCulling) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTessellationDetailCulling: TSFBool read FFdTessellationDetailCulling;
    { If TRUE, shape tesselation is lowered as long as resulting error is lower than threshold }
    property TessellationDetailCulling: Boolean read GetTessellationDetailCulling write SetTessellationDetailCulling;

    strict private FFdTessellationErrorFactor: TSFFloat;
    { Internal wrapper for property @code(TessellationErrorFactor). This wrapper API may change, we advise to access simpler @code(TessellationErrorFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTessellationErrorFactor: TSFFloat read FFdTessellationErrorFactor;
    { Experimenal: Factor of tesselation error for controlling speed-performance trade-off }
    property TessellationErrorFactor: Single read GetTessellationErrorFactor write SetTessellationErrorFactor;

    strict private FFdTessellationErrorThreshold: TSFFloat;
    { Internal wrapper for property @code(TessellationErrorThreshold). This wrapper API may change, we advise to access simpler @code(TessellationErrorThreshold) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTessellationErrorThreshold: TSFFloat read FFdTessellationErrorThreshold;
    { Shape tesselation is lowered as long as resulting error is lower than threshold }
    property TessellationErrorThreshold: Single read GetTessellationErrorThreshold write SetTessellationErrorThreshold;

    strict private FFdTonemapping: TSFStringEnum;
    { Internal wrapper for property @code(Tonemapping). This wrapper API may change, we advise to access simpler @code(Tonemapping) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdTonemapping: TSFStringEnum read FFdTonemapping;
    { Specifies the used tonemapping operator. Note that X3DOM and Castle Game Engine support a bit different tone mapping options. }
    property Tonemapping: TToneMapping read GetTonemapping write SetTonemapping;

    strict private FFdUserDataFactor: TSFFloat;
    { Internal wrapper for property @code(UserDataFactor). This wrapper API may change, we advise to access simpler @code(UserDataFactor) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdUserDataFactor: TSFFloat read FFdUserDataFactor;
    { Experimenal: Factor of user data for controlling speed-performance trade-off }
    property UserDataFactor: Single read GetUserDataFactor write SetUserDataFactor;

{$endif read_interface}

{$ifdef read_implementation}

{ TEnvironmentNode ----------------------------------------------- }

function TEnvironmentNode.GetEnableARC: Boolean;
begin
  Result := FdEnableARC.Value;
end;

procedure TEnvironmentNode.SetEnableARC(const Value: Boolean);
begin
  FdEnableARC.Send(Value);
end;

function TEnvironmentNode.GetFrustumCulling: Boolean;
begin
  Result := FdFrustumCulling.Value;
end;

procedure TEnvironmentNode.SetFrustumCulling(const Value: Boolean);
begin
  FdFrustumCulling.Send(Value);
end;

function TEnvironmentNode.GetGammaCorrectionDefault: String;
begin
  Result := FdGammaCorrectionDefault.Value;
end;

procedure TEnvironmentNode.SetGammaCorrectionDefault(const Value: String);
begin
  FdGammaCorrectionDefault.Send(Value);
end;

function TEnvironmentNode.GetLowPriorityCulling: Boolean;
begin
  Result := FdLowPriorityCulling.Value;
end;

procedure TEnvironmentNode.SetLowPriorityCulling(const Value: Boolean);
begin
  FdLowPriorityCulling.Send(Value);
end;

function TEnvironmentNode.GetLowPriorityFactor: Single;
begin
  Result := FdLowPriorityFactor.Value;
end;

procedure TEnvironmentNode.SetLowPriorityFactor(const Value: Single);
begin
  FdLowPriorityFactor.Send(Value);
end;

function TEnvironmentNode.GetLowPriorityThreshold: Single;
begin
  Result := FdLowPriorityThreshold.Value;
end;

procedure TEnvironmentNode.SetLowPriorityThreshold(const Value: Single);
begin
  FdLowPriorityThreshold.Send(Value);
end;

function TEnvironmentNode.GetMaxFrameRate: Single;
begin
  Result := FdMaxFrameRate.Value;
end;

procedure TEnvironmentNode.SetMaxFrameRate(const Value: Single);
begin
  FdMaxFrameRate.Send(Value);
end;

function TEnvironmentNode.GetMinFrameRate: Single;
begin
  Result := FdMinFrameRate.Value;
end;

procedure TEnvironmentNode.SetMinFrameRate(const Value: Single);
begin
  FdMinFrameRate.Send(Value);
end;

function TEnvironmentNode.GetOcclusionCulling: Boolean;
begin
  Result := FdOcclusionCulling.Value;
end;

procedure TEnvironmentNode.SetOcclusionCulling(const Value: Boolean);
begin
  FdOcclusionCulling.Send(Value);
end;

function TEnvironmentNode.GetOcclusionVisibilityFactor: Single;
begin
  Result := FdOcclusionVisibilityFactor.Value;
end;

procedure TEnvironmentNode.SetOcclusionVisibilityFactor(const Value: Single);
begin
  FdOcclusionVisibilityFactor.Send(Value);
end;

function TEnvironmentNode.GetOcclusionVisibilityThreshold: Single;
begin
  Result := FdOcclusionVisibilityThreshold.Value;
end;

procedure TEnvironmentNode.SetOcclusionVisibilityThreshold(const Value: Single);
begin
  FdOcclusionVisibilityThreshold.Send(Value);
end;

function TEnvironmentNode.GetShadowExcludeTransparentObjects: Boolean;
begin
  Result := FdShadowExcludeTransparentObjects.Value;
end;

procedure TEnvironmentNode.SetShadowExcludeTransparentObjects(const Value: Boolean);
begin
  FdShadowExcludeTransparentObjects.Send(Value);
end;

function TEnvironmentNode.GetSmallFeatureCulling: Boolean;
begin
  Result := FdSmallFeatureCulling.Value;
end;

procedure TEnvironmentNode.SetSmallFeatureCulling(const Value: Boolean);
begin
  FdSmallFeatureCulling.Send(Value);
end;

function TEnvironmentNode.GetSmallFeatureFactor: Single;
begin
  Result := FdSmallFeatureFactor.Value;
end;

procedure TEnvironmentNode.SetSmallFeatureFactor(const Value: Single);
begin
  FdSmallFeatureFactor.Send(Value);
end;

function TEnvironmentNode.GetSmallFeatureThreshold: Single;
begin
  Result := FdSmallFeatureThreshold.Value;
end;

procedure TEnvironmentNode.SetSmallFeatureThreshold(const Value: Single);
begin
  FdSmallFeatureThreshold.Send(Value);
end;

function TEnvironmentNode.GetSortTrans: Boolean;
begin
  Result := FdSortTrans.Value;
end;

procedure TEnvironmentNode.SetSortTrans(const Value: Boolean);
begin
  FdSortTrans.Send(Value);
end;

function TEnvironmentNode.GetSSAO: Boolean;
begin
  Result := FdSSAO.Value;
end;

procedure TEnvironmentNode.SetSSAO(const Value: Boolean);
begin
  FdSSAO.Send(Value);
end;

function TEnvironmentNode.GetSSAOamount: Single;
begin
  Result := FdSSAOamount.Value;
end;

procedure TEnvironmentNode.SetSSAOamount(const Value: Single);
begin
  FdSSAOamount.Send(Value);
end;

function TEnvironmentNode.GetSSAOblurDepthTreshold: Single;
begin
  Result := FdSSAOblurDepthTreshold.Value;
end;

procedure TEnvironmentNode.SetSSAOblurDepthTreshold(const Value: Single);
begin
  FdSSAOblurDepthTreshold.Send(Value);
end;

function TEnvironmentNode.GetSSAOradius: Single;
begin
  Result := FdSSAOradius.Value;
end;

procedure TEnvironmentNode.SetSSAOradius(const Value: Single);
begin
  FdSSAOradius.Send(Value);
end;

function TEnvironmentNode.GetSSAOrandomTextureSize: Single;
begin
  Result := FdSSAOrandomTextureSize.Value;
end;

procedure TEnvironmentNode.SetSSAOrandomTextureSize(const Value: Single);
begin
  FdSSAOrandomTextureSize.Send(Value);
end;

function TEnvironmentNode.GetTessellationDetailCulling: Boolean;
begin
  Result := FdTessellationDetailCulling.Value;
end;

procedure TEnvironmentNode.SetTessellationDetailCulling(const Value: Boolean);
begin
  FdTessellationDetailCulling.Send(Value);
end;

function TEnvironmentNode.GetTessellationErrorFactor: Single;
begin
  Result := FdTessellationErrorFactor.Value;
end;

procedure TEnvironmentNode.SetTessellationErrorFactor(const Value: Single);
begin
  FdTessellationErrorFactor.Send(Value);
end;

function TEnvironmentNode.GetTessellationErrorThreshold: Single;
begin
  Result := FdTessellationErrorThreshold.Value;
end;

procedure TEnvironmentNode.SetTessellationErrorThreshold(const Value: Single);
begin
  FdTessellationErrorThreshold.Send(Value);
end;

function TEnvironmentNode.GetTonemapping: TToneMapping;
begin
  Result := TToneMapping(FdTonemapping.EnumValue);
end;

procedure TEnvironmentNode.SetTonemapping(const Value: TToneMapping);
begin
  FdTonemapping.SendEnumValue(Ord(Value));
end;

function TEnvironmentNode.GetUserDataFactor: Single;
begin
  Result := FdUserDataFactor.Value;
end;

procedure TEnvironmentNode.SetUserDataFactor(const Value: Single);
begin
  FdUserDataFactor.Send(Value);
end;

class function TEnvironmentNode.ClassX3DType: String;
begin
  Result := 'Environment';
end;

procedure TEnvironmentNode.CreateNode;
begin
  inherited;

  FFdEnableARC := TSFBool.Create(Self, True, 'enableARC', false);
   FdEnableARC.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEnableARC);

  FFdFrustumCulling := TSFBool.Create(Self, True, 'frustumCulling', true);
   FdFrustumCulling.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFrustumCulling);

  FFdGammaCorrectionDefault := TSFString.Create(Self, True, 'gammaCorrectionDefault', 'linear');
   FdGammaCorrectionDefault.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdGammaCorrectionDefault);

  FFdLowPriorityCulling := TSFBool.Create(Self, True, 'lowPriorityCulling', false);
   FdLowPriorityCulling.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLowPriorityCulling);

  FFdLowPriorityFactor := TSFFloat.Create(Self, True, 'lowPriorityFactor', -1);
   FdLowPriorityFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdLowPriorityFactor);

  FFdLowPriorityThreshold := TSFFloat.Create(Self, True, 'lowPriorityThreshold', 1.0);
   FdLowPriorityThreshold.ChangeAlways := chVisibleNonGeometry;
   FdLowPriorityThreshold.MustBeNonnegative := true;
  AddField(FFdLowPriorityThreshold);

  FFdMaxFrameRate := TSFFloat.Create(Self, True, 'maxFrameRate', 62.5);
   FdMaxFrameRate.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMaxFrameRate);

  FFdMinFrameRate := TSFFloat.Create(Self, True, 'minFrameRate', 1.0);
   FdMinFrameRate.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMinFrameRate);

  FFdOcclusionCulling := TSFBool.Create(Self, True, 'occlusionCulling', false);
   FdOcclusionCulling.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOcclusionCulling);

  FFdOcclusionVisibilityFactor := TSFFloat.Create(Self, True, 'occlusionVisibilityFactor', -1);
   FdOcclusionVisibilityFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdOcclusionVisibilityFactor);

  FFdOcclusionVisibilityThreshold := TSFFloat.Create(Self, True, 'occlusionVisibilityThreshold', 0.0);
   FdOcclusionVisibilityThreshold.ChangeAlways := chVisibleNonGeometry;
   FdOcclusionVisibilityThreshold.MustBeNonnegative := true;
  AddField(FFdOcclusionVisibilityThreshold);

  FFdShadowExcludeTransparentObjects := TSFBool.Create(Self, True, 'shadowExcludeTransparentObjects', false);
   FdShadowExcludeTransparentObjects.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShadowExcludeTransparentObjects);

  FFdSmallFeatureCulling := TSFBool.Create(Self, True, 'smallFeatureCulling', false);
   FdSmallFeatureCulling.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSmallFeatureCulling);

  FFdSmallFeatureFactor := TSFFloat.Create(Self, True, 'smallFeatureFactor', -1);
   FdSmallFeatureFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSmallFeatureFactor);

  FFdSmallFeatureThreshold := TSFFloat.Create(Self, True, 'smallFeatureThreshold', 1.0);
   FdSmallFeatureThreshold.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSmallFeatureThreshold);

  FFdSortTrans := TSFBool.Create(Self, True, 'sortTrans', true);
   FdSortTrans.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSortTrans);

  FFdSSAO := TSFBool.Create(Self, True, 'SSAO', false);
   FdSSAO.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSSAO);

  FFdSSAOamount := TSFFloat.Create(Self, True, 'SSAOamount', 0);
   FdSSAOamount.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSSAOamount);

  FFdSSAOblurDepthTreshold := TSFFloat.Create(Self, True, 'SSAOblurDepthTreshold', 5);
   FdSSAOblurDepthTreshold.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSSAOblurDepthTreshold);

  FFdSSAOradius := TSFFloat.Create(Self, True, 'SSAOradius', 4);
   FdSSAOradius.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSSAOradius);

  FFdSSAOrandomTextureSize := TSFFloat.Create(Self, True, 'SSAOrandomTextureSize', 4);
   FdSSAOrandomTextureSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSSAOrandomTextureSize);

  FFdTessellationDetailCulling := TSFBool.Create(Self, True, 'tessellationDetailCulling', false);
   FdTessellationDetailCulling.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTessellationDetailCulling);

  FFdTessellationErrorFactor := TSFFloat.Create(Self, True, 'tessellationErrorFactor', -1);
   FdTessellationErrorFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTessellationErrorFactor);

  FFdTessellationErrorThreshold := TSFFloat.Create(Self, True, 'tessellationErrorThreshold', 0.0);
   FdTessellationErrorThreshold.ChangeAlways := chVisibleNonGeometry;
   FdTessellationErrorThreshold.MustBeNonnegative := true;
  AddField(FFdTessellationErrorThreshold);

  FFdTonemapping := TSFStringEnum.Create(Self, True, 'tonemapping', @ToneMappingNames, Ord(High(ToneMappingNames)) + 1, Ord(tmNone));
   FdTonemapping.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTonemapping);

  FFdUserDataFactor := TSFFloat.Create(Self, True, 'userDataFactor', -1);
   FdUserDataFactor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdUserDataFactor);

  DefaultContainerField := 'environment';
end;

{$endif read_implementation}
