{ -*- buffer-read-only: t -*-

  Copyright 2015-2024 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetShape: TShapeNode;
    procedure SetShape(const Value: TShapeNode);
  public
    { Create node fields and events. }
    procedure CreateNode; override;
    class function ClassX3DType: String; override;

    strict private FFdShape: TSFNode;
    { Internal wrapper for property @code(Shape). This wrapper API may change, we advise to access simpler @code(Shape) instead, if it is defined (TODO: for now, some field types do not have a simpler counterpart). }
    public property FdShape: TSFNode read FFdShape;
    {  }
    property Shape: TShapeNode read GetShape write SetShape;

{$endif read_interface}

{$ifdef read_implementation}

{ TCollidableShapeNode ----------------------------------------------- }

function TCollidableShapeNode.GetShape: TShapeNode;
begin
  if FdShape.Value is TShapeNode then
    Result := TShapeNode(FdShape.Value)
  else
    Result := nil;
end;

procedure TCollidableShapeNode.SetShape(const Value: TShapeNode);
begin
  FdShape.Send(Value);
end;

class function TCollidableShapeNode.ClassX3DType: String;
begin
  Result := 'CollidableShape';
end;

procedure TCollidableShapeNode.CreateNode;
begin
  inherited;

  FFdShape := TSFNode.Create(Self, False, 'shape', [TShapeNode]);
   FdShape.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdShape);
end;

{$endif read_implementation}
