PRAGMA foreign_keys=OFF;
BEGIN TRANSACTION;
CREATE TABLE moz_places (   id INTEGER PRIMARY KEY, url LONGVARCHAR, title LONGVARCHAR, rev_host LONGVARCHAR, visit_count INTEGER DEFAULT 0, hidden INTEGER DEFAULT 0 NOT NULL, typed INTEGER DEFAULT 0 NOT NULL, favicon_id INTEGER, frecency INTEGER DEFAULT -1 NOT NULL, last_visit_date INTEGER , guid TEXT, foreign_count INTEGER DEFAULT 0 NOT NULL, url_hash INTEGER DEFAULT 0 NOT NULL);
INSERT INTO moz_places VALUES(1,'place:folder=BOOKMARKS_MENU&folder=UNFILED_BOOKMARKS&folder=TOOLBAR&queryType=1&sort=12&maxResults=10&excludeQueries=1',NULL,NULL,0,1,0,NULL,0,NULL,'3L8RhCORmJhI',1,268506299617350);
INSERT INTO moz_places VALUES(2,'place:type=6&sort=14&maxResults=10',NULL,NULL,0,1,0,NULL,0,NULL,'THKmZ1sqzg9e',1,268505606444332);
INSERT INTO moz_places VALUES(3,'http://www.ubuntu.com/',NULL,'moc.utnubu.www.',0,0,0,NULL,64,NULL,'zZD-rGLsu3ta',1,125508050257634);
INSERT INTO moz_places VALUES(4,'http://wiki.ubuntu.com/',NULL,'moc.utnubu.ikiw.',0,0,0,NULL,64,NULL,'buL63RhXNx5I',1,125511519733047);
INSERT INTO moz_places VALUES(5,'https://answers.launchpad.net/ubuntu/+addquestion',NULL,'ten.daphcnual.srewsna.',0,0,0,NULL,64,NULL,'R7Y0VYN5Qdc0',1,47359338650210);
INSERT INTO moz_places VALUES(6,'http://www.debian.org/',NULL,'gro.naibed.www.',0,0,0,NULL,64,NULL,'v3JUUM0EFXCG',1,125508165346216);
INSERT INTO moz_places VALUES(7,'https://one.ubuntu.com/',NULL,'moc.utnubu.eno.',0,0,0,NULL,64,NULL,'AGUzUoXo3NUs',1,47359195550374);
INSERT INTO moz_places VALUES(8,'https://www.mozilla.org/en-US/firefox/help/',NULL,'gro.allizom.www.',0,0,0,NULL,64,NULL,'j_Zj5HQyRB0C',1,47356364765622);
INSERT INTO moz_places VALUES(9,'https://www.mozilla.org/en-US/firefox/customize/',NULL,'gro.allizom.www.',0,0,0,NULL,64,NULL,'geto35febbf0',1,47357014640010);
INSERT INTO moz_places VALUES(10,'https://www.mozilla.org/en-US/contribute/',NULL,'gro.allizom.www.',0,0,0,NULL,64,NULL,'Rk5TBl9nW_0G',1,47358034485371);
INSERT INTO moz_places VALUES(11,'https://www.mozilla.org/en-US/about/',NULL,'gro.allizom.www.',0,0,0,NULL,64,NULL,'ajjJNGoeVZos',1,47358774953055);
INSERT INTO moz_places VALUES(12,'place:sort=8&maxResults=10',NULL,NULL,0,1,0,NULL,0,NULL,'vDKpX_SQJZNF',1,268505095842199);
INSERT INTO moz_places VALUES(13,'http://voyagerlive.org/',NULL,'gro.evilregayov.',0,0,0,NULL,64,NULL,'Tg0y_kuW7hAd',1,125507606885498);
INSERT INTO moz_places VALUES(14,'file:///.startpage/0/index.html',NULL,'.',7,0,0,NULL,513,1468499310694226,'k3q8NHlxwJ8d',1,219669470494363);
INSERT INTO moz_places VALUES(15,'file:///.startpage/1/index.html',NULL,'.',0,0,0,NULL,64,NULL,'4VbS_4dqJ79q',1,219668736475133);
INSERT INTO moz_places VALUES(16,'file:///.startpage/2/index.html',NULL,'.',0,0,0,NULL,64,NULL,'D8KMVz0PnhzZ',1,219669324140854);
INSERT INTO moz_places VALUES(17,'file:///.startpage/3/index.html',NULL,'.',0,0,0,NULL,64,NULL,'8ybRhb7Km8vY',1,219667182856922);
INSERT INTO moz_places VALUES(18,'file:///.startpage/4/index.html',NULL,'.',0,0,0,NULL,64,NULL,'N5CP9cHa9ZDM',1,219669164690790);
INSERT INTO moz_places VALUES(19,'file:///.startpage/5/index.html',NULL,'.',0,0,0,NULL,64,NULL,'4GND-j6aizWA',1,219669839582445);
INSERT INTO moz_places VALUES(20,'file:///.startpage/6/index.html',NULL,'.',0,0,0,NULL,64,NULL,'AlCg03lD3iJL',1,219667108107103);
INSERT INTO moz_places VALUES(21,'file:///.startpage/7/index.html',NULL,'.',0,0,0,NULL,64,NULL,'OTvU7l-YdvmN',1,219668183071102);
INSERT INTO moz_places VALUES(22,'file:///.startpage/8/index.html',NULL,'.',0,0,0,NULL,64,NULL,'IPI7YoUqVbqd',1,219668476324512);
INSERT INTO moz_places VALUES(23,'file:///.startpage/9/index.html',NULL,'.',0,0,0,NULL,64,NULL,'5kmSOb_Xe4I_',1,219669049854574);
INSERT INTO moz_places VALUES(24,'file:///.startpage/10/index.html',NULL,'.',0,0,0,NULL,64,NULL,'BoSf-LyJzWzu',1,219669428108279);
INSERT INTO moz_places VALUES(25,'file:///.startpage/11/index.html',NULL,'.',0,0,0,NULL,64,NULL,'216qE1FWvaJN',1,219668510215844);
INSERT INTO moz_places VALUES(26,'file:///.startpage/12/index.html',NULL,'.',0,0,0,NULL,64,NULL,'hVpHyr-MGelW',1,219666403675874);
INSERT INTO moz_places VALUES(27,'file:///.startpage/13/index.html',NULL,'.',0,0,0,NULL,64,NULL,'2r8eRn19hmv4',1,219667091819632);
INSERT INTO moz_places VALUES(28,'file:///.startpage/14/index.html',NULL,'.',0,0,0,NULL,64,NULL,'vxAWivZ0jJmP',1,219668747999666);
INSERT INTO moz_places VALUES(29,'file:///.startpage/15/index.html',NULL,'.',0,0,0,NULL,64,NULL,'_80kLPC1SXsf',1,219668718232164);
INSERT INTO moz_places VALUES(30,'file:///.startpage/16/index.html',NULL,'.',0,0,0,NULL,64,NULL,'RQTXoE_MEOin',1,219668369570932);
INSERT INTO moz_places VALUES(31,'file:///.startpage/17/index.html',NULL,'.',0,0,0,NULL,64,NULL,'4hvYmF1jW_OE',1,219666243124822);
INSERT INTO moz_places VALUES(32,'file:///.startpage/18/index.html',NULL,'.',0,0,0,NULL,64,NULL,'zPKBW3WnmK0M',1,219670060396334);
INSERT INTO moz_places VALUES(33,'file:///.startpage/19/index.html',NULL,'.',0,0,0,NULL,64,NULL,'AvLKOMNhR38s',1,219669203074249);
INSERT INTO moz_places VALUES(34,'file:///.startpage/20/index.html',NULL,'.',0,0,0,NULL,64,NULL,'CFEXVi6ajxMJ',1,219667678613885);
INSERT INTO moz_places VALUES(35,'file:///.startpage/21/index.html',NULL,'.',0,0,0,NULL,64,NULL,'9zywynfkqAEh',1,219667658155164);
INSERT INTO moz_places VALUES(36,'file:///.startpage/22/index.html',NULL,'.',0,0,0,NULL,64,NULL,'n12ZqgkI0xgv',1,219669359046484);
INSERT INTO moz_places VALUES(37,'file:///.startpage/23/index.html',NULL,'.',0,0,0,NULL,64,NULL,'dV1nUAJuxYhJ',1,219667663302713);
INSERT INTO moz_places VALUES(38,'file:///.startpage/24/index.html',NULL,'.',0,0,0,NULL,64,NULL,'bHFeAKm2VoxV',1,219668865743796);
INSERT INTO moz_places VALUES(39,'file:///.startpage/25/index.html',NULL,'.',0,0,0,NULL,64,NULL,'ZlveTgWYOHyl',1,219666516621298);
INSERT INTO moz_places VALUES(40,'file:///.startpage/26/index.html',NULL,'.',0,0,0,NULL,64,NULL,'LT0TSp-aRcGW',1,219669783839253);
INSERT INTO moz_places VALUES(41,'file:///.startpage/27/index.html',NULL,'.',0,0,0,NULL,64,NULL,'3L5m6XPVjUwh',1,219667796938995);
INSERT INTO moz_places VALUES(42,'apt://flashplugin-installer',NULL,NULL,0,0,0,NULL,64,NULL,'wk7Q00E1AJtJ',1,130688315308473);
INSERT INTO moz_places VALUES(43,'https://addons.mozilla.org/fr/firefox/addon/adblock-plus/',NULL,'gro.allizom.snodda.',0,0,0,NULL,64,NULL,'BQTNVCrOi6cy',2,47359114341489);
INSERT INTO moz_places VALUES(44,'https://addons.mozilla.org/fr/firefox/addon/searchpreview/','SearchPreview :: Modules pour Firefox','gro.allizom.snodda.',1,0,0,32,120,1500352310710639,'ISDOqrYxP-o2',1,47359086811128);
INSERT INTO moz_places VALUES(45,'https://addons.mozilla.org/fr/firefox/language-tools/','Dictionnaires et paquetages linguistiques :: Modules pour Firefox','gro.allizom.snodda.',1,0,0,32,135,1502469203205795,'ejTA_lnpIVGp',3,47356529039849);
INSERT INTO moz_places VALUES(86,'place:type=3&sort=4',NULL,NULL,0,1,0,NULL,0,NULL,'0P7W4IkZ9d-x',1,268506321168863);
INSERT INTO moz_places VALUES(87,'place:transition=7&sort=4',NULL,NULL,0,1,0,NULL,0,NULL,'pfR1SwF8WV5b',1,268507063987631);
INSERT INTO moz_places VALUES(88,'place:type=6&sort=1',NULL,NULL,0,1,0,NULL,0,NULL,'4bHN8NzrU69O',1,268504878649678);
INSERT INTO moz_places VALUES(89,'place:folder=TOOLBAR',NULL,NULL,0,1,0,NULL,0,NULL,'-UNrGlY2qHS-',1,268507032739381);
INSERT INTO moz_places VALUES(90,'place:folder=BOOKMARKS_MENU',NULL,NULL,0,1,0,NULL,0,NULL,'_ZtxELNAGorr',1,268504983346218);
INSERT INTO moz_places VALUES(91,'place:folder=UNFILED_BOOKMARKS',NULL,NULL,0,1,0,NULL,0,NULL,'28nTBc-Glbdq',1,268507911875319);
INSERT INTO moz_places VALUES(1896,'https://www.google.co.in/','Google','ni.oc.elgoog.www.',2,0,1,11,2698,1504975524486254,'j_p-Y6RhkHko',1,47357009725544);
CREATE TABLE moz_historyvisits (  id INTEGER PRIMARY KEY, from_visit INTEGER, place_id INTEGER, visit_date INTEGER, visit_type INTEGER, session INTEGER);
CREATE TABLE moz_inputhistory (  place_id INTEGER NOT NULL, input LONGVARCHAR NOT NULL, use_count INTEGER, PRIMARY KEY (place_id, input));
CREATE TABLE moz_hosts (  id INTEGER PRIMARY KEY, host TEXT NOT NULL UNIQUE, frecency INTEGER, typed INTEGER NOT NULL DEFAULT 0, prefix TEXT);
CREATE TABLE moz_bookmarks (  id INTEGER PRIMARY KEY, type INTEGER, fk INTEGER DEFAULT NULL, parent INTEGER, position INTEGER, title LONGVARCHAR, keyword_id INTEGER, folder_type TEXT, dateAdded INTEGER, lastModified INTEGER, guid TEXT, syncStatus INTEGER DEFAULT 0 NOT NULL, syncChangeCounter INTEGER DEFAULT 1 NOT NULL);
INSERT INTO moz_bookmarks VALUES(1,2,NULL,0,0,'',NULL,NULL,1467725517327000,1470428315627000,'root________',0,1);
INSERT INTO moz_bookmarks VALUES(2,2,NULL,1,0,'Bookmarks Menu',NULL,NULL,1467725517327000,1504975536882000,'menu________',0,4);
INSERT INTO moz_bookmarks VALUES(3,2,NULL,1,1,'Bookmarks Toolbar',NULL,NULL,1467725517327000,1470428315492000,'toolbar_____',0,1);
INSERT INTO moz_bookmarks VALUES(4,2,NULL,1,2,'Tags',NULL,NULL,1467725517327000,1502516392069000,'tags________',0,128);
INSERT INTO moz_bookmarks VALUES(6,1,1,2,0,'Marqués récemment',NULL,NULL,1440206436707000,1470428315238000,'ePlbveDPxcVC',0,1);
INSERT INTO moz_bookmarks VALUES(9,2,NULL,2,3,'Ubuntu, and Free Software links',NULL,NULL,1440206436614000,1467725517796000,'IIOoE1AVQALy',0,1);
INSERT INTO moz_bookmarks VALUES(10,1,3,9,0,'Ubuntu',NULL,NULL,1440206436615000,1440206436616000,'BdTJgxwzX-bY',0,1);
INSERT INTO moz_bookmarks VALUES(11,1,4,9,1,'Ubuntu Wiki (community-edited website)',NULL,NULL,1440206436617000,1440206436618000,'Q3CHtiX8BAQm',0,1);
INSERT INTO moz_bookmarks VALUES(12,1,5,9,2,'Make a Support Request to the Ubuntu Community',NULL,NULL,1440206436618000,1440206436619000,'abuWmpFRfxHw',0,1);
INSERT INTO moz_bookmarks VALUES(13,1,6,9,3,'Debian (Ubuntu is based on Debian)',NULL,NULL,1440206436619000,1440206436621000,'09Wm3713Bb1z',0,1);
INSERT INTO moz_bookmarks VALUES(14,1,7,9,4,'Ubuntu One - The personal cloud that brings your digital life together',NULL,NULL,1440206436622000,1440206436622000,'BkV2PLxgT2hL',0,1);
INSERT INTO moz_bookmarks VALUES(15,2,NULL,2,4,'Mozilla Firefox',NULL,NULL,1440206436622000,1440206436627000,'4TFNf2K_7e1a',0,1);
INSERT INTO moz_bookmarks VALUES(16,1,8,15,0,'Help and Tutorials',NULL,NULL,1440206436623000,1440206436624000,'vC7MQXkMREQV',0,1);
INSERT INTO moz_bookmarks VALUES(17,1,9,15,1,'Customize Firefox',NULL,NULL,1440206436624000,1440206436625000,'hNcuVhGLSBMT',0,1);
INSERT INTO moz_bookmarks VALUES(18,1,10,15,2,'Get Involved',NULL,NULL,1440206436625000,1440206436626000,'ChmDGJ8Nh2Rj',0,1);
INSERT INTO moz_bookmarks VALUES(19,1,11,15,3,'About Us',NULL,NULL,1440206436627000,1440206436627000,'4KMQLdKoA5ME',0,1);
INSERT INTO moz_bookmarks VALUES(21,1,13,3,1,'Voyager',NULL,NULL,1440206499903000,1440206519634000,'GOB7TZA0gCGU',0,1);
INSERT INTO moz_bookmarks VALUES(23,1,14,22,0,'0',NULL,NULL,1440206567367000,1440206589837000,'e_UDXJIzf2zR',0,1);
INSERT INTO moz_bookmarks VALUES(24,1,15,22,1,'1',NULL,NULL,1440206671321000,1440206683533000,'2hZfPJd4TtJn',0,1);
INSERT INTO moz_bookmarks VALUES(25,1,16,22,2,'2',NULL,NULL,1440206671321000,1440206770420000,'W2p3TBdOtDvH',0,1);
INSERT INTO moz_bookmarks VALUES(26,1,17,22,3,'3',NULL,NULL,1440206671321000,1440206784296000,'qZYep98FnR__',0,1);
INSERT INTO moz_bookmarks VALUES(27,1,18,22,4,'4',NULL,NULL,1440206671321000,1440206793116000,'zZu4UGpXYow3',0,1);
INSERT INTO moz_bookmarks VALUES(28,1,19,22,5,'5',NULL,NULL,1440206671321000,1440206801937000,'VXZ3mBzzcA4Q',0,1);
INSERT INTO moz_bookmarks VALUES(29,1,20,22,6,'6',NULL,NULL,1440206671321000,1440206810195000,'a0RFsnB3EwVc',0,1);
INSERT INTO moz_bookmarks VALUES(30,1,21,22,7,'7',NULL,NULL,1440206671321000,1440206817630000,'6Biu707lOdHg',0,1);
INSERT INTO moz_bookmarks VALUES(31,1,22,22,8,'8',NULL,NULL,1440206671321000,1440206825212000,'AP1mXZa0ahQ4',0,1);
INSERT INTO moz_bookmarks VALUES(32,1,23,22,9,'9',NULL,NULL,1440206671321000,1440206832966000,'WxjKjeWFlrMP',0,1);
INSERT INTO moz_bookmarks VALUES(33,1,24,22,10,'10',NULL,NULL,1440206671321000,1440206844808000,'-QeCAla6-KY8',0,1);
INSERT INTO moz_bookmarks VALUES(34,1,25,22,11,'11',NULL,NULL,1440206671321000,1440206849594000,'ZN_9hCgM4lf0',0,1);
INSERT INTO moz_bookmarks VALUES(35,1,26,22,12,'12',NULL,NULL,1440206671321000,1440206856076000,'oWFTNWyZ6gMq',0,1);
INSERT INTO moz_bookmarks VALUES(36,1,27,22,13,'13',NULL,NULL,1440206671321000,1440206867754000,'-lcyQ56ww8NA',0,1);
INSERT INTO moz_bookmarks VALUES(37,1,28,22,14,'14',NULL,NULL,1440206671321000,1440206910367000,'w43SFrygDRwR',0,1);
INSERT INTO moz_bookmarks VALUES(38,1,29,22,15,'15',NULL,NULL,1440206671321000,1440206917428000,'8Q-1muzTEeWE',0,1);
INSERT INTO moz_bookmarks VALUES(39,1,30,22,16,'16',NULL,NULL,1440206671321000,1440206928910000,'Ghx1rkNDlp4H',0,1);
INSERT INTO moz_bookmarks VALUES(40,1,31,22,17,'17',NULL,NULL,1440206671321000,1440206935983000,'d2AJXtLXpkFb',0,1);
INSERT INTO moz_bookmarks VALUES(41,1,32,22,18,'18',NULL,NULL,1440206671321000,1440206942585000,'MMo9b33f9xyE',0,1);
INSERT INTO moz_bookmarks VALUES(42,1,33,22,19,'19',NULL,NULL,1440206671321000,1440206950138000,'K7socCLnYy4L',0,1);
INSERT INTO moz_bookmarks VALUES(43,1,34,22,20,'20',NULL,NULL,1440206671321000,1440206957207000,'5V11irxjjd38',0,1);
INSERT INTO moz_bookmarks VALUES(44,1,35,22,21,'21',NULL,NULL,1440206671321000,1440206964605000,'-oxnXIHTe0Qa',0,1);
INSERT INTO moz_bookmarks VALUES(45,1,36,22,22,'22',NULL,NULL,1440206671321000,1440206971117000,'EKZ1Rmek4lTO',0,1);
INSERT INTO moz_bookmarks VALUES(46,1,37,22,23,'23',NULL,NULL,1440206671321000,1440206978351000,'gpzcG4LjZ2Re',0,1);
INSERT INTO moz_bookmarks VALUES(47,1,38,22,24,'24',NULL,NULL,1440206671321000,1440737505375000,'PvDZnqwbwj4u',0,1);
INSERT INTO moz_bookmarks VALUES(48,1,39,22,25,'25',NULL,NULL,1440206671321000,1440737513706000,'BuKY3E03NnmF',0,1);
INSERT INTO moz_bookmarks VALUES(49,1,40,22,26,'26',NULL,NULL,1440206671321000,1440737524663000,'lf6NCbNyKMnX',0,1);
INSERT INTO moz_bookmarks VALUES(50,1,41,22,27,'27',NULL,NULL,1440206671321000,1440737540732000,'StBEBdR-nxjO',0,1);
INSERT INTO moz_bookmarks VALUES(51,2,NULL,3,3,'F+',NULL,NULL,1440207026112000,1440207159607000,'njpFXZMf3dGr',0,1);
INSERT INTO moz_bookmarks VALUES(52,1,42,51,0,'Flash Install',NULL,NULL,1440207037033000,1440207058958000,'FSJNRAVVHZw2',0,1);
INSERT INTO moz_bookmarks VALUES(53,1,43,51,1,'Adblock Plus',NULL,NULL,1440207069038000,1440207082178000,'IrUa9S-JhU_c',0,1);
INSERT INTO moz_bookmarks VALUES(54,1,44,51,2,'SearchPreview',NULL,NULL,1440207088169000,1500352294532000,'yS24nxSktibH',0,2);
INSERT INTO moz_bookmarks VALUES(55,1,45,51,3,'Language Tools',NULL,NULL,1440207113748000,1440207156708000,'Wp2tuVDbc5tZ',0,2);
INSERT INTO moz_bookmarks VALUES(57,1,86,56,0,'History',NULL,NULL,1468512203179000,1468512203180000,'XNGjCIZLlYX7',0,1);
INSERT INTO moz_bookmarks VALUES(58,1,87,56,1,'Downloads',NULL,NULL,1468512203180000,1468512203181000,'C4MPThOkxXJp',0,1);
INSERT INTO moz_bookmarks VALUES(59,1,88,56,2,'Tags',NULL,NULL,1468512203181000,1468512203182000,'gpxshKA-aBjG',0,1);
INSERT INTO moz_bookmarks VALUES(61,1,89,60,0,NULL,NULL,NULL,1468512203184000,1468512203185000,'NrSbqdjDsUqF',0,1);
INSERT INTO moz_bookmarks VALUES(62,1,90,60,1,NULL,NULL,NULL,1468512203185000,1468512203186000,'BaYiLZ99gJSr',0,1);
INSERT INTO moz_bookmarks VALUES(63,1,91,60,2,NULL,NULL,NULL,1468512203186000,1468512203187000,'w-U2zBo1eOHU',0,1);
INSERT INTO moz_bookmarks VALUES(64,1,12,3,0,'Most Visited',NULL,NULL,1470428315492000,1470428315588000,'RtkxwHiU0MDn',0,1);
INSERT INTO moz_bookmarks VALUES(65,1,2,2,1,'Recent Tags',NULL,NULL,1470428315627000,1470428315690000,'fLDmWrAmGNWW',0,1);
INSERT INTO moz_bookmarks VALUES(67,2,NULL,4,0,'language',NULL,NULL,1491534915350000,1491534938078000,'4bL9ZoFmnBLt',0,1);
INSERT INTO moz_bookmarks VALUES(68,1,45,67,0,NULL,NULL,NULL,1491534915363000,1491534915363000,'49l3q4-FiBp0',0,2);
INSERT INTO moz_bookmarks VALUES(69,1,43,67,1,NULL,NULL,NULL,1491534938078000,1491534938078000,'d8z-e3rN3r4T',0,1);
INSERT INTO moz_bookmarks VALUES(70,2,NULL,4,1,'hello',NULL,NULL,1502469210372000,1502469210376000,'TpKnUAtkhxK6',1,2);
INSERT INTO moz_bookmarks VALUES(71,1,45,70,0,NULL,NULL,NULL,1502469210376000,1502469210376000,'2Qo36cSCjizq',1,2);
INSERT INTO moz_bookmarks VALUES(72,1,1896,2,5,'',NULL,NULL,1504975536882000,1504976368646000,'uWFrltEh9OTA',1,4);
CREATE TABLE moz_keywords (  id INTEGER PRIMARY KEY AUTOINCREMENT, keyword TEXT UNIQUE, place_id INTEGER, post_data TEXT);
CREATE TABLE moz_favicons (  id INTEGER PRIMARY KEY, url LONGVARCHAR UNIQUE, data BLOB, mime_type VARCHAR(32), expiration LONG);
CREATE TABLE moz_anno_attributes (  id INTEGER PRIMARY KEY, name VARCHAR(32) UNIQUE NOT NULL);
CREATE TABLE moz_annos (  id INTEGER PRIMARY KEY, place_id INTEGER NOT NULL, anno_attribute_id INTEGER, mime_type VARCHAR(32) DEFAULT NULL, content LONGVARCHAR, flags INTEGER DEFAULT 0, expiration INTEGER DEFAULT 0, type INTEGER DEFAULT 0, dateAdded INTEGER DEFAULT 0, lastModified INTEGER DEFAULT 0);
CREATE TABLE moz_items_annos (  id INTEGER PRIMARY KEY, item_id INTEGER NOT NULL, anno_attribute_id INTEGER, mime_type VARCHAR(32) DEFAULT NULL, content LONGVARCHAR, flags INTEGER DEFAULT 0, expiration INTEGER DEFAULT 0, type INTEGER DEFAULT 0, dateAdded INTEGER DEFAULT 0, lastModified INTEGER DEFAULT 0);
ANALYZE sqlite_schema;
INSERT INTO sqlite_stat1 VALUES('moz_places','moz_places_guid_uniqueindex','1535 1');
INSERT INTO sqlite_stat1 VALUES('moz_places','moz_places_url_hashindex','1535 1');
INSERT INTO sqlite_stat1 VALUES('moz_places','moz_places_lastvisitdateindex','1535 2');
INSERT INTO sqlite_stat1 VALUES('moz_places','moz_places_frecencyindex','1535 9');
INSERT INTO sqlite_stat1 VALUES('moz_places','moz_places_visitcount','1535 86');
INSERT INTO sqlite_stat1 VALUES('moz_places','moz_places_hostindex','1535 8');
INSERT INTO sqlite_stat1 VALUES('moz_places','moz_places_faviconindex','1535 12');
INSERT INTO sqlite_stat1 VALUES('moz_bookmarks','moz_bookmarks_guid_uniqueindex','69 1');
INSERT INTO sqlite_stat1 VALUES('moz_bookmarks','moz_bookmarks_itemlastmodifiedindex','69 2 1');
INSERT INTO sqlite_stat1 VALUES('moz_bookmarks','moz_bookmarks_parentindex','69 6 1');
INSERT INTO sqlite_stat1 VALUES('moz_bookmarks','moz_bookmarks_itemindex','69 2 2');
INSERT INTO sqlite_stat1 VALUES('moz_historyvisits','moz_historyvisits_dateindex','2151 1');
INSERT INTO sqlite_stat1 VALUES('moz_historyvisits','moz_historyvisits_fromindex','2151 3');
INSERT INTO sqlite_stat1 VALUES('moz_historyvisits','moz_historyvisits_placedateindex','2151 2 1');
INSERT INTO sqlite_stat1 VALUES('moz_inputhistory','sqlite_autoindex_moz_inputhistory_1','36 2 1');
CREATE TABLE moz_bookmarks_deleted (  guid TEXT PRIMARY KEY, dateRemoved INTEGER NOT NULL DEFAULT 0);
DELETE FROM sqlite_sequence;
CREATE INDEX moz_places_faviconindex ON moz_places (favicon_id);
CREATE INDEX moz_places_hostindex ON moz_places (rev_host);
CREATE INDEX moz_places_visitcount ON moz_places (visit_count);
CREATE INDEX moz_places_frecencyindex ON moz_places (frecency);
CREATE INDEX moz_places_lastvisitdateindex ON moz_places (last_visit_date);
CREATE INDEX moz_historyvisits_placedateindex ON moz_historyvisits (place_id, visit_date);
CREATE INDEX moz_historyvisits_fromindex ON moz_historyvisits (from_visit);
CREATE INDEX moz_historyvisits_dateindex ON moz_historyvisits (visit_date);
CREATE INDEX moz_bookmarks_itemindex ON moz_bookmarks (fk, type);
CREATE INDEX moz_bookmarks_parentindex ON moz_bookmarks (parent, position);
CREATE INDEX moz_bookmarks_itemlastmodifiedindex ON moz_bookmarks (fk, lastModified);
CREATE INDEX moz_places_url_hashindex ON moz_places (url_hash);
CREATE UNIQUE INDEX moz_places_guid_uniqueindex ON moz_places (guid);
CREATE UNIQUE INDEX moz_bookmarks_guid_uniqueindex ON moz_bookmarks (guid);
CREATE UNIQUE INDEX moz_keywords_placepostdata_uniqueindex ON moz_keywords (place_id, post_data);
CREATE UNIQUE INDEX moz_annos_placeattributeindex ON moz_annos (place_id, anno_attribute_id);
CREATE UNIQUE INDEX moz_items_annos_itemattributeindex ON moz_items_annos (item_id, anno_attribute_id);
COMMIT;
