inline int String::casecmp(std::string const &lhs, std::string const &rhs)
{
    return strcasecmp(lhs.c_str(), rhs.c_str());
}

//static
template <std::unsigned_integral ValueType>
std::string String::to_string(ValueType value, unsigned base)
{
    std::string ret;
    if (not (2 <= base and base <= 36))         // 2 <= base <= 36
        return ret;

    if (value == 0)
        return ret = "0";

    std::string reversed;
    char const a10 = 'a' - 10;
    while (value != 0)
    {
        unsigned modVal = value % base;
        reversed.push_back( (modVal < 10 ? '0' : a10) + modVal);
        value /= base;
    }

    ret.reserve(reversed.length());
    reverse_copy(reversed.begin(), reversed.end(), back_inserter(ret));

    return ret;
}




