/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include <config.h>
#include <config_path.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <wordexp.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>
//portability problem?
#include <pthread.h>

#include <cstdio>


#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Check_Button.H>
//#include <FL/Fl_PNG_Image.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <prefs.hpp>

#include <set_conf.hpp>
#include <command_line.hpp>
#include <util.hpp>



#include <insert_template.hpp>

#include <insert_template_dialog.hpp>

extern finestra_pr* MainWindow;

extern Preferences  __pref;

extern bool __close;




/**
 *Un plugin deve avere :
 *
 *una funzione  bool (*need_group)()  che ritorna true  se il  plugin ha
 *bisogno di conoscre quali atomi sono selezionati;
 *
 *una funzione  bool (*need_leg)()  che ritorna true  se il  plugin ha
 *bisogno di conoscere quali legami sono selezionati;
 *
 *una funzione  bool (*act)()  che computa quello  per cui il  plugin e'
 *stato scritto
 *
 */



insert_template::insert_template(immagine* image,string libpath)
  :bist_plugin(image,libpath),
   _has_to_act(true),
   _has_acted(false),
   _name_template("")
  
{
  
}


void insert_template::inizialize(){

 _the_image->elimina_elem_selected();
 _the_image->elimina_legami_selected();

 Fl_Double_Window* win=  make_insert_template_dialog();
 
 while(win->shown()){
   Fl::wait();
 }
  
 Fl_Input* d = dynamic_cast<Fl_Input*>(win->child(1));
 _name_template=d->value();
 _has_to_act=false;
 delete win;


 std::cerr << _name_template << std::endl;

 /*
   #define LIB_PATH_HOME "/.bist/rings/"
   #define LIB_PATH_SHARE "/usr/local/share/bist/rings/"
 */

 string home_dir=getenv("HOME");

 if(_name_template!=""){
   bool found=false;
   if(!search(home_dir + string(LIB_PATH_HOME),found)){
     found=false;
     search(string(LIB_PATH_SHARE),found);
   }

 }
}


bool insert_template::search(string pt, bool& found){
  if(!found){
    DIR* direc=opendir(pt.c_str());
    
    if(direc==NULL){
      fl_alert(_("Can not open library directory %s"),pt.c_str());
      return false;
    }
    
    dirent* acc;
    struct stat attrb;
    while((acc=readdir(direc))!=NULL){
      string file=pt+"/"+acc->d_name;
      stat(file.c_str(),&attrb);
      if(S_ISDIR(attrb.st_mode) && 
         string(acc->d_name)!="." &&
         string(acc->d_name)!=".."){
        search(file,found);
      }else if(S_ISREG(attrb.st_mode) && !found){
        if(file.find(_name_template)!=string::npos &&
           file.rfind("bist")!=string::npos){
          _the_image->aggiungi_template(file);
          found=true;
          return true;
        }
      }
    }

    return false;    
  }else{
    return true;
  }


}



bool insert_template::need_atom(){
  return false;
}

bool insert_template::need_leg(){
  return false;
}

bool insert_template::act(int e){

  return _has_to_act;
}


insert_template::~insert_template(){
  
  cout << "join ring distruzione!!! " << _the_image <<endl;
}

void insert_template::register_plugin(){

}

 
bool insert_template::time_to_act(){
  return _has_to_act;
}
    

string insert_template::libpath(){
  return _lib;
}

std::string insert_template::menu_path(){
  return "template/";
}


/**************fine metodi di classe**********************************/




extern "C" bist_plugin* create_plugin(immagine* imm, string libpath){
  return new insert_template(imm, libpath);
}

extern "C" void destroy_plugin(bist_plugin* j){
  cout << "distruzione plugin: " << j <<  endl;
  delete j;
  cout << "riuscita" << endl;
}


