//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_14.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot14(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[14] = {4.329203573977358e-02,3.904209260420317e-01,1.088965867569269e+00,2.147799470582228e+00,3.581028249991773e+00,
    5.409112330616467e+00,7.660691115610086e+00,1.037556300977004e+01,1.360971142939024e+01,1.744429447570418e+01,2.200319676691491e+01,2.749204150484384e+01,
    3.430462050937307e+01,4.344926230785205e+01};
  constexpr double aw[14] = {3.986047178264514e-01,2.825613912593883e-01,1.413946097869548e-01,4.951488928989820e-02,1.196842321435483e-02,
    1.957331294408983e-03,2.106181000240331e-04,1.434550422971453e-05,5.857719720992989e-07,1.325682501541725e-08,1.475853168277663e-10,6.639436714909627e-13,
    8.315937951206607e-16,1.140139347903643e-19};
  constexpr double x[5376] = {  5.863225884460311e-03, -1.008043144465862e-04,  1.296004351984622e-06, -1.475479046909010e-08,  1.567062995589956e-10,
 -1.588297140384826e-12,  1.553865214556062e-14, -1.476599426091007e-16,  1.367387121887355e-18, -1.235844912295443e-20,  1.090091135956141e-22, -9.371934659193016e-25,
  5.238366777658657e-02, -8.802977803161387e-04,  1.080241163157701e-05, -1.134729482139249e-07,  1.059846526012089e-09, -8.797575471953788e-12,  6.262537735117497e-14,
 -3.370956954774454e-16,  5.188731973816234e-19,  1.921788137313139e-20, -3.654400567239601e-22,  4.494055860999608e-24,  1.433824494455882e-01, -2.300491983769947e-03,
  2.558799508830967e-05, -2.230829626216780e-07,  1.442687079083948e-09, -4.254440094128623e-12, -5.304500903027189e-14,  1.150361119359405e-15, -1.261570734288234e-17,
  8.551923435721120e-20, -1.010608112532512e-22, -7.014166258125183e-24,  2.748390423764122e-01, -4.106621670785870e-03,  3.882985352646161e-05, -2.305509251693198e-07,
  1.127668362523057e-10,  1.666106987410722e-11, -2.178676314458979e-13,  1.218867580476416e-15,  5.856593520208325e-18, -2.060573841176195e-19,  2.157150810046312e-21,
 -6.588766797876048e-24,  4.408836594427169e-01, -5.970574291250924e-03,  4.379460574147852e-05, -8.170516082517434e-08, -2.318054635632380e-09,  2.876122441040221e-11,
 -6.364676420985773e-14, -2.294374840537390e-15,  3.059645768297778e-17, -6.250791536921141e-20, -2.916185056753157e-21,  3.904448389026771e-23,  6.339951266236190e-01,
 -7.547430722386719e-03,  3.659612738956914e-05,  1.704533751523089e-07, -3.699224388681669e-09,  8.296257586526523e-12,  3.131616936841459e-13, -3.015490650459629e-15,
 -1.482166267575923e-17,  4.641587700965130e-19, -1.495252340042164e-21, -4.814541922540987e-23,  8.452711540603508e-01, -8.537517561394070e-03,  1.795691632980370e-05,
  3.898434450483705e-07, -2.391226237229295e-09, -2.888237619484909e-11,  3.301490649878412e-13,  2.209460603783691e-15, -4.574613100962106e-17, -1.276347054625787e-19,
  6.244183717161989e-21, -3.539109112436806e-24,  1.064773675244259e+00, -8.743769448712229e-03, -6.800895802100522e-06,  4.432624831212727e-07,  8.993926048984528e-10,
 -4.017178412925182e-11, -1.303753601254989e-13,  4.394874496078717e-15,  1.973773995877051e-17, -5.287164457490065e-19, -3.068621157619123e-21,  6.719723562092875e-23,
  1.281948718796478e+00, -8.113625230860387e-03, -2.967707810406805e-05,  2.925539645844272e-07,  3.526097328064375e-09, -1.059660229339900e-11, -4.137885672239799e-13,
 -8.500993795729048e-16,  4.463806428107263e-17,  3.327416374018159e-19, -3.993119447842068e-21, -6.475729977401544e-23,  1.486114319393513e+00, -6.755909369145940e-03,
 -4.318523145402982e-05,  2.653910668332824e-08,  3.380028743286698e-09,  2.499737894014909e-11, -1.277191148201796e-13, -3.809675305637469e-15, -1.903541584735290e-17,
  2.853613107346918e-19,  4.965997822430363e-21,  9.391264404839365e-24,  1.667001099027993e+00, -4.926630684206402e-03, -4.353850036005314e-05, -1.963910682231091e-07,
  9.581280607442921e-10,  2.724912115852620e-11,  2.248860415682211e-13, -1.127418991910107e-16, -2.579087139408676e-17, -3.069751201466616e-19, -8.304199929730889e-22,
  2.652991396260985e-23,  1.815319094051472e+00, -2.983364125444777e-03, -3.239420113247507e-05, -2.589718368859876e-07, -1.252436850314293e-09,  3.140938005471561e-12,
  1.533722975736869e-13,  1.923651166888228e-15,  1.314173298919698e-17, -2.889287347615802e-21, -1.464166500937628e-21, -2.231021148225729e-23,  1.923313795399180e+00,
 -1.315065150353466e-03, -1.622652713805964e-05, -1.675141367928527e-07, -1.480788862239368e-09, -1.079553791846640e-11, -5.442421683866964e-14,  2.691184343761610e-17,
  5.254605518946411e-18,  8.531778472582897e-20,  9.435236970234360e-22,  7.790266791949415e-24,  1.985280411121451e+00, -2.608470074688910e-04, -3.441117022419120e-06,
 -3.994502080232744e-08, -4.290836670310868e-10, -4.352962210607571e-12, -4.206283833071638e-14, -3.879782397675029e-16, -3.406241070254044e-18, -2.821811330702494e-20,
 -2.165042980178893e-22, -1.475492991887727e-24,  5.479680482230278e-03, -9.110417466307429e-05,  1.133004392558474e-06, -1.248267656648711e-08,  1.283586532573620e-10,
 -1.260421643476448e-12,  1.195544251848650e-14, -1.102549627076781e-16,  9.919580609051584e-19, -8.722989038084272e-21,  7.499501269306976e-23, -6.299828468691810e-25,
  4.902708129719267e-02, -7.990497680450140e-04,  9.536930978020190e-06, -9.784452050828754e-08,  8.981726451356018e-10, -7.405406996878674e-12,  5.350511481215751e-14,
 -3.118913307685523e-16,  9.900484413791161e-19,  7.994180955668067e-21, -2.082614834525540e-22,  2.771482101009864e-24,  1.345734800890797e-01, -2.106110459367281e-03,
  2.304649353008582e-05, -2.007396837019589e-07,  1.347252658734571e-09, -5.183813723079054e-12, -2.603249353425701e-14,  7.946282251460060e-16, -9.670010650503822e-18,
  7.681915365573742e-20, -3.012761035446299e-22, -2.513260342755216e-24,  2.590163859172911e-01, -3.806995076482695e-03,  3.608417651631361e-05, -2.263530814354732e-07,
  3.965468725550574e-10,  1.185668861301286e-11, -1.821158765581664e-13,  1.303565389927017e-15, -9.443522485787215e-20, -1.272652395437058e-19,  1.751347941210392e-21,
 -1.090966552541281e-23,  4.176950330798940e-01, -5.624726726525889e-03,  4.261026916827624e-05, -1.142951203161776e-07, -1.762748717212108e-09,  2.657062649826624e-11,
 -1.146617851154194e-13, -1.370530240241280e-15,  2.664695214351792e-17, -1.464010278900399e-19, -1.331572245013936e-21,  3.186451365278279e-23,  6.044024955167627e-01,
 -7.247471012646869e-03,  3.829316033686668e-05,  1.129720702114058e-07, -3.465192839840652e-09,  1.476027146143896e-11,  2.244959101925935e-13, -3.237640182445409e-15,
  3.734119544499602e-19,  3.699656936978546e-19, -3.014837390716199e-21, -2.091423587038223e-23,  8.114370501028533e-01, -8.375841170915490e-03,  2.238786235647441e-05,
  3.474111798519133e-07, -2.885493633104338e-09, -2.038438010538977e-11,  3.711675429274231e-13,  7.192983839716780e-16, -4.598346629339333e-17,  1.081270108474162e-19,
  5.298011685326509e-21, -3.713309491850786e-23,  1.029723734794966e+00, -8.776717334673157e-03, -1.422351493159125e-06,  4.510981607634667e-07,  7.492603463580114e-11,
 -4.177102773959754e-11, -1.471475580160048e-15,  4.704372828361724e-15, -7.435609407936034e-19, -5.872611788729874e-19,  2.213398146866047e-22,  7.809417586754597e-23,
  1.249042947060088e+00, -8.336059807300036e-03, -2.583668162259982e-05,  3.467314260633123e-07,  3.213804718769263e-09, -2.064191768172737e-11, -4.160436124261317e-13,
  7.338207985725211e-16,  5.309411621500484e-17,  1.206794951583756e-19, -6.449826229257578e-21, -4.280457440280502e-23,  1.458403081623552e+00, -7.099161246485576e-03,
 -4.252642241564038e-05,  8.441523012063149e-08,  3.840372966351290e-09,  2.059411065144011e-11, -2.410980516877903e-13, -4.215818804654909e-15, -5.168294805994139e-18,
  4.831594905882200e-19,  4.672439903762768e-21, -2.502659272738574e-23,  1.646583459477477e+00, -5.284061536233562e-03, -4.578428580699676e-05, -1.764107921476594e-07,
  1.556301492324647e-09,  3.250486837284065e-11,  2.084830427838012e-13, -1.118603397611508e-15, -3.709859520634449e-17, -3.101991711090122e-19,  8.407597885731706e-22,
  4.997649795717170e-23,  1.802847175582415e+00, -3.255282877528254e-03, -3.561932416439457e-05, -2.782891164205563e-07, -1.148202346337246e-09,  7.515189817651822e-12,
  2.130139212317667e-13,  2.329144363515239e-15,  1.172344418975233e-17, -8.366475745134579e-20, -2.637320837502163e-21, -3.085891047218629e-23,  1.917780588454524e+00,
 -1.453337688099233e-03, -1.838620584558660e-05, -1.930043767522844e-07, -1.709589151716237e-09, -1.207056045026450e-11, -5.079890624399614e-14,  2.521893044606498e-16,
  9.092900496838571e-18,  1.304448344719822e-19,  1.324731999875419e-21,  9.403535837829168e-24,  1.984178755433796e+00, -2.904170075441805e-04, -3.964710585571779e-06,
 -4.756561115231279e-08, -5.271857942034809e-10, -5.506149660353641e-12, -5.461762667219702e-14, -5.150367709002033e-16, -4.594655654362830e-18, -3.829036637592390e-20,
 -2.899304467143225e-22, -1.861282371156060e-24,  5.132490055809899e-03, -8.260621395981222e-05,  9.947506056554623e-07, -1.061600429760369e-08,  1.057868460295823e-10,
 -1.007220498750216e-12,  9.269325812022207e-15, -8.300793607610019e-17,  7.258577892044840e-19, -6.211696945398101e-21,  5.204431875798006e-23, -4.269381563015776e-25,
  4.597636754831853e-02, -7.272173716384865e-04,  8.444351791349776e-06, -8.459175454762523e-08,  7.622178021163349e-10, -6.222285792178146e-12,  4.524877109437844e-14,
 -2.769968601741728e-16,  1.153906093115608e-18,  1.739723912751403e-21, -1.125014265286432e-22,  1.664372723799997e-24,  1.265030326538528e-01, -1.931015628051865e-03,
  2.076344152776192e-05, -1.800400300882731e-07,  1.238960615741710e-09, -5.574097460664962e-12, -7.716899309899962e-15,  5.269454553325634e-16, -7.140349767261730e-18,
  6.338111105436121e-20, -3.533593619921777e-22, -1.295130706059247e-25,  2.443487237675830e-01, -3.529062210818389e-03,  3.341309798033447e-05, -2.183363862566929e-07,
  5.929112761017024e-10,  7.919790476118716e-12, -1.462562524086962e-13,  1.239801891574403e-15, -3.533191287134560e-18, -6.703828391595579e-20,  1.260117318904169e-21,
 -1.093117308711354e-23,  3.958685791088282e-01, -5.289770848630682e-03,  4.108652451021905e-05, -1.384086978828133e-07, -1.261487194964581e-09,  2.344942798571460e-11,
 -1.419494291678956e-13, -6.098767334515332e-16,  2.072742722296157e-17, -1.747498881382781e-19, -1.658211229607243e-22,  2.095818112547080e-23,  5.760325890644034e-01,
 -6.936621417895548e-03,  3.932677288455188e-05,  6.015272197109363e-08, -3.123395308625415e-09,  1.907311465976150e-11,  1.358373795949877e-13, -3.037217311868159e-15,
  1.136730955722249e-17,  2.382931460236507e-19, -3.400524725842763e-21,  2.111935724595801e-24,  7.783171495750423e-01, -8.180875207376075e-03,  2.626791488398295e-05,
  2.984696993425282e-07, -3.203308683868745e-09, -1.139597864497382e-11,  3.715636062161575e-13, -6.525810175290691e-16, -3.872846563977020e-17,  2.812358385693441e-19,
  3.241002732984555e-21, -5.310727993468074e-23,  9.946283366092163e-01, -8.766486338161893e-03,  3.970565952914564e-06,  4.456561830647548e-07, -7.502741946059166e-10,
 -4.024767169755060e-11,  1.267901473913587e-13,  4.350623751188804e-15, -2.091828970605860e-17, -5.123321647178808e-19,  3.414256309469007e-21,  6.299237132096282e-23,
  1.215312860867023e+00, -8.525270848547366e-03, -2.138273281192094e-05,  3.943175472168252e-07,  2.703782718838112e-09, -3.018625736307853e-11, -3.714304526902071e-13,
  2.449532115690258e-15,  5.244352514537454e-17, -1.634391979316865e-19, -7.438976715954038e-21,  4.986083762888964e-25,  1.429333942593571e+00, -7.434247052721786e-03,
 -4.113230013205407e-05,  1.488016105781667e-07,  4.184806271089360e-09,  1.338984826443342e-11, -3.586004448528895e-13, -4.069726882012226e-15,  1.521123713777521e-17,
  6.355617170549065e-19,  2.632908191643042e-21, -6.796851919769978e-23,  1.624701922447237e+00, -5.658329116160275e-03, -4.772951171315738e-05, -1.460505190037762e-07,
  2.253161923723779e-09,  3.698849009981930e-11,  1.589364572189730e-13, -2.473217351539525e-15, -4.706631798308823e-17, -2.256112778140300e-19,  3.551253386297901e-21,
  7.208349595902851e-23,  1.789234561474586e+00, -3.553894318692335e-03, -3.906309886213929e-05, -2.951572606277076e-07, -9.412883012667126e-10,  1.344892936818037e-11,
  2.828681174464818e-13,  2.632964496384354e-15,  6.467100424395377e-18, -2.182468857819344e-19, -4.128864828734689e-21, -3.582379612862341e-23,  1.911657708879832e+00,
 -1.610175316290883e-03, -2.087455195686346e-05, -2.223522829156799e-07, -1.962430394692819e-09, -1.316739360251212e-11, -3.888034893156430e-14,  6.293478477015377e-16,
  1.484426539670111e-17,  1.918763020305327e-19,  1.746371992558153e-21,  9.293367405904485e-24,  1.982949822960061e+00, -3.245700937840154e-04, -4.589986673215322e-06,
 -5.695800837994773e-08, -6.516766956075768e-10, -7.007997127929720e-12, -7.132120609858151e-14, -6.865257298891758e-16, -6.202539215851615e-18, -5.162707946603750e-20,
 -3.791280444422035e-22, -2.161933697788843e-24,  4.817213091370106e-03, -7.513045948444471e-05,  8.768864283753803e-07, -9.073228366243290e-09,  8.769154979431204e-11,
 -8.102157644761238e-13,  7.239335276711565e-15, -6.299068444981845e-17,  5.355874268468952e-19, -4.461853035591665e-21,  3.642960844088100e-23, -2.917825442025104e-25,
  4.319645940655273e-02, -6.635247255959903e-04,  7.498501044488488e-06, -7.333539252200751e-08,  6.480252697878891e-10, -5.225183606773166e-12,  3.801379158128881e-14,
 -2.398092224590802e-16,  1.151058655401775e-18, -1.524103882820320e-21, -5.572207283787799e-23,  9.711697083539276e-25,  1.190979667000615e-01, -1.773221534882431e-03,
  1.871820253097096e-05, -1.611140006248647e-07,  1.126696876052596e-09, -5.606057901339837e-12,  4.162325842234234e-15,  3.322475121590757e-16, -5.110738688021057e-18,
  4.952219778165036e-20, -3.317980738559614e-22,  9.488894279962488e-25,  2.307507329852149e-01, -3.272065445075220e-03,  3.085462174368679e-05, -2.077618097823767e-07,
  7.189431576272443e-10,  4.811532867722876e-12, -1.134234408810388e-13,  1.096940336508606e-15, -5.150933418397498e-18, -2.576616523673412e-20,  8.176994197234163e-22,
 -9.002773107670616e-24,  3.753559220831839e-01, -4.968030977637085e-03,  3.931938161221369e-05, -1.550302187256054e-07, -8.275870446417162e-10,  1.990685595344067e-11,
 -1.506854567614375e-13, -4.692212461202958e-17,  1.451040782650773e-17, -1.660849905331206e-19,  5.247057519642973e-22,  1.077849846604358e-23,  5.489187434831480e-01,
 -6.619939465962691e-03,  3.976184461053924e-05,  1.337914489646550e-08, -2.715977771450778e-09,  2.136080914163710e-11,  5.699288057675155e-14, -2.561975190704297e-15,
  1.756494847559740e-17,  1.089410220131800e-19, -2.965750520700782e-21,  1.602882844872530e-23,  7.460353700888149e-01, -7.957290857334185e-03,  2.953605901856001e-05,
  2.458693183533583e-07, -3.344214214740294e-09, -2.827626197456475e-12,  3.376146635746546e-13, -1.709500807428673e-15, -2.683982875336905e-17,  3.637049214094042e-19,
  9.023182687532392e-22, -5.048591942719230e-23,  9.596594230165000e-01, -8.713594291253865e-03,  9.220495361984238e-06,  4.274173519094023e-07, -1.515390181244833e-09,
 -3.583451421635674e-11,  2.366802520105297e-13,  3.417390559331680e-15, -3.631703056897463e-17, -3.294377498916454e-19,  5.479969618357825e-21,  2.884635063714204e-23,
  1.180900595834125e+00, -8.676718940418816e-03, -1.641277921851679e-05,  4.322905658761493e-07,  2.017419369723908e-09, -3.809538195129301e-11, -2.806381856708606e-13,
  3.977092809811232e-15,  4.134518067379462e-17, -4.455910800437116e-19, -6.300028691577515e-21,  5.075661510902454e-23,  1.398951776246227e+00, -7.755007582031229e-03,
 -3.893771970810232e-05,  2.173957940875240e-07,  4.357685111111077e-09,  3.492723083540660e-12, -4.621909902795834e-13, -3.203118779184193e-15,  3.915937821632358e-17,
  6.695267737737476e-19, -1.190098518923826e-21, -1.026798043748381e-22,  1.601294774833350e+00, -6.046505335351090e-03, -4.924080253772051e-05, -1.039012088801159e-07,
  3.024559875886910e-09,  3.979540620817144e-11,  6.761233072411095e-14, -4.075417878897224e-15, -5.183001948152130e-17, -1.635289650083957e-20,  6.965851699672696e-21,
  7.922588579554512e-23,  1.774371211335277e+00, -3.880799723892145e-03, -4.268520926343753e-05, -3.076718029434865e-07, -5.983641475500713e-10,  2.113734985987236e-11,
  3.580622125485423e-13,  2.679267204121904e-15, -4.737638405449646e-18, -4.141865431905852e-19, -5.621501875063574e-21, -2.922742943185591e-23,  1.904865335675481e+00,
 -1.788398732458944e-03, -2.374000849656079e-05, -2.559016084587134e-07, -2.233375878482571e-09, -1.382850065273595e-11, -1.346941286286071e-14,  1.229119616655518e-15,
  2.310006648629097e-17,  2.689801207640552e-19,  2.074332900444469e-21,  4.471393160792068e-24,  1.981573508898893e+00, -3.642125181885794e-04, -5.340989154847271e-06,
 -6.860608019751792e-08, -8.106343645725877e-10, -8.974633713640706e-12, -9.362402466458696e-14, -9.178589488775336e-16, -8.357247217007142e-18, -6.871290738595738e-20,
 -4.745621230035273e-22, -2.068456537008924e-24,  4.530063994602380e-03, -6.852820395578387e-05,  7.759203547140810e-07, -7.790924633523485e-09,  7.309122605417782e-11,
 -6.558388558397470e-13,  5.693260326902642e-15, -4.816398176586069e-17,  3.983677450905086e-19, -3.232129136091166e-21,  2.571503519498803e-23, -2.011424544475733e-25,
  4.065700179370676e-02, -6.068881844668796e-04,  6.677392649854083e-06, -6.375565648375148e-08,  5.521222663385104e-10, -4.389330451497091e-12,  3.180393297551425e-14,
 -2.042085566242943e-16,  1.065059702335489e-18, -3.038973677296769e-21, -2.310431857938931e-23,  5.463353605774473e-25,  1.122927486160831e-01, -1.630911396635579e-03,
  1.688932289332159e-05, -1.439755414726629e-07,  1.016239367970545e-09, -5.411449421125287e-12,  1.142591666227423e-14,  1.947580686963741e-16, -3.555417989960501e-18,
  3.722592314700158e-20, -2.805225093939365e-22,  1.296863731025975e-24,  2.181406398228570e-01, -3.034999082396808e-03,  2.843322278768201e-05, -1.956266793029886e-07,
  7.903409145703476e-10,  2.438666664054165e-12, -8.511545001501006e-14,  9.228492939426344e-16, -5.578785900763916e-18, -2.701507830908138e-22,  4.748469511093486e-22,
 -6.577393581471059e-24,  3.561008464751829e-01, -4.661113495725303e-03,  3.739207356145975e-05, -1.652825801994576e-07, -4.654725346887582e-10,  1.632174914311376e-11,
 -1.463639516395065e-13,  3.265751526715951e-16,  9.000987740157776e-18, -1.380337325255813e-19,  8.233955466464809e-22,  3.303438894259572e-24,  5.230751922859445e-01,
 -6.301908421114287e-03,  3.967593554951826e-05, -2.660765990617570e-08, -2.280553089222681e-09,  2.193417140348063e-11, -6.438319866160259e-15, -1.958531042337996e-15,
  1.954079490106072e-17,  6.420268396895290e-21, -2.125643702185391e-21,  2.083204368648804e-23,  7.146961833238542e-01, -7.710111809237408e-03,  3.216495779586888e-05,
  1.923318562636361e-07, -3.324066039333218e-09,  4.615924231248373e-12,  2.797183057627980e-13, -2.356045040799072e-15, -1.359853414879199e-17,  3.591966464046192e-19,
 -1.016745681559492e-21, -3.539018897181489e-23,  9.249844064846818e-01, -8.619778793419497e-03,  1.418145801558511e-05,  3.977762636120753e-07, -2.168246088896516e-09,
 -2.914666456852624e-11,  3.146268253588631e-13,  2.109583080965688e-15, -4.403092477429682e-17, -9.643715654041008e-20,  5.887050295033041e-21, -9.771890863554425e-24,
  1.145964665280244e+00, -8.786782573295416e-03, -1.105783905609178e-05,  4.581484082215533e-07,  1.197882431605991e-09, -4.336132939028361e-11, -1.534861031929457e-13,
  4.999983128544076e-15,  2.142201307607156e-17, -6.404913611647945e-19, -3.176778193193940e-21,  8.730746326824640e-23,  1.367326939729982e+00, -8.054887798041472e-03,
 -3.591035608015536e-05,  2.870472285864906e-07,  4.310173460458289e-09, -8.512790564583315e-12, -5.308297096136125e-13, -1.582705604176886e-15,  6.127252121243811e-17,
  5.272351976431696e-19, -5.963976222855981e-21, -1.078576161589934e-22,  1.576314245810903e+00, -6.444535477841671e-03, -5.017082283499511e-05, -4.909497600018192e-08,
  3.826488539824236e-09,  3.986288828005542e-11, -6.938583622605115e-14, -5.683022144434305e-15, -4.659971730144453e-17,  3.274429992952496e-19,  1.004010354463274e-20,
  5.376681659772437e-23,  1.758141482595266e+00, -4.237177112594389e-03, -4.641918221675736e-05, -3.133717339184724e-07, -8.375847632599021e-11,  3.059856044839977e-11,
  4.283954090157483e-13,  2.243540252253522e-15, -2.394834961805716e-17, -6.580643033904209e-19, -6.354560776665358e-21,  8.896835895060168e-25,  1.897311566693638e+00,
 -1.991230624697893e-03, -2.703437973659664e-05, -2.938524224562343e-07, -2.509919138930763e-09, -1.364572645569815e-11,  3.286598178938044e-14,  2.139464311661118e-15,
  3.429455866353389e-17,  3.524439922477768e-19,  1.989815584820848e-21, -1.064412682282789e-23,  1.980025658614003e+00, -4.104684961456315e-04, -6.248426993047807e-06,
 -8.314356945054490e-08, -1.014844878967535e-09, -1.156265156500689e-11, -1.234670894795120e-13, -1.228698870934714e-15, -1.119254699918293e-17, -8.927688686852434e-20,
 -5.449044820591561e-22, -8.448076625814301e-25,  4.267800605015024e-03, -6.267587550449780e-05,  6.890360181754123e-07, -6.719409137467750e-09,  6.123860850171434e-11,
 -5.340440299187340e-13,  4.506966432207394e-15, -3.709549278153807e-17,  2.985762379245304e-19, -2.360767323105986e-21,  1.829783411314095e-23, -1.399224740813572e-25,
  3.833164545504900e-02, -5.563855492371557e-04,  5.962560743320942e-06, -5.558439689155963e-08,  4.715249113183792e-10, -3.690905279629078e-12,  2.654576765730898e-14,
 -1.720137218579719e-16,  9.440235280013659e-19, -3.567276105599845e-21, -5.164431044925411e-24,  2.908115499876243e-25,  1.060287695781596e-01, -1.502439342655896e-03,
  1.525565662378542e-05, -1.285650061814904e-07,  9.111328488530862e-10, -5.083481457315528e-12,  1.547299452573803e-14,  1.003739177602771e-16, -2.403363199371019e-18,
  2.715841473168727e-20, -2.230189583368357e-22,  1.277283959651502e-24,  2.064410149513247e-01, -2.816705380151141e-03,  2.616284848980015e-05, -1.826936048929992e-07,
  8.206757019427744e-10,  6.859091567720518e-13, -6.175336881234604e-14,  7.473132872686812e-16, -5.310161016023608e-18,  1.361188259917975e-20,  2.352664089449739e-22,
 -4.382858250173064e-24,  3.380419566199248e-01, -4.370013492933212e-03,  3.537416112959537e-05, -1.703058814482108e-07, -1.732746565158095e-10,  1.294693207758824e-11,
 -1.338879520113175e-13,  5.416446957917699e-16,  4.645351463137786e-18, -1.037206514381980e-19,  8.594578086029776e-22, -1.210622216660089e-24,  4.984995194363788e-01,
 -5.986365216850877e-03,  3.915211200168883e-05, -5.961281412043254e-08, -1.847492715115224e-09,  2.119191613957116e-11, -5.259476725874096e-14, -1.344144588771143e-15,
  1.846191408888901e-17, -6.039748923076020e-20, -1.227431857598523e-21,  1.921224171708074e-23,  6.843837282873816e-01, -7.444455092181535e-03,  3.415799468361602e-05,
  1.402269356725758e-07, -3.170163345288262e-09,  1.049995853720060e-11,  2.095289050654453e-13, -2.594862785921468e-15, -1.723982948327796e-18,  2.929793379842161e-19,
 -2.154434487646810e-21, -1.632234941432325e-23,  8.907615380841892e-01, -8.487865181010463e-03,  1.872876166046293e-05,  3.588483266255409e-07, -2.671715052179913e-09,
 -2.104763158243922e-11,  3.537635997512705e-13,  6.890611019112238e-16, -4.345648177309338e-17,  1.208809355362522e-19,  4.768029034786915e-21, -3.859660273688406e-23,
  1.110675800587677e+00, -8.852995306674185e-03, -5.474195442246901e-06,  4.702252820749415e-07,  3.054664905401640e-10, -4.530952944284883e-11, -7.485584943736281e-15,
  5.299866376371700e-15, -2.952378417170538e-18, -6.862890384105562e-19,  9.361978939096996e-22,  9.403698550635844e-23,  1.334556270740770e+00, -8.327237507049508e-03,
 -3.205990447076368e-05,  3.539448809749305e-07,  4.010141710591264e-09, -2.154726213458144e-11, -5.452220506065605e-13,  6.267921815223072e-16,  7.488202174500588e-17,
  2.017443276493999e-19, -1.003161134792056e-20, -6.964915006130861e-23,  1.549731187690855e+00, -6.847158091078010e-03, -5.036675799049479e-05,  1.835945716125820e-08,
  4.593390386884248e-09,  3.613338862175762e-11, -2.470402815962958e-13, -6.904439143785868e-15, -2.716422223469011e-17,  7.590712844814437e-19,  1.103084151452530e-20,
 -1.619975424430818e-23,  1.740426284826303e+00, -4.623544958000212e-03, -5.016562528326645e-05, -3.092379691655314e-07,  6.355692104829529e-10,  4.152365742947435e-11,
  4.765794251776947e-13,  1.050098523920760e-15, -5.205964062870725e-17, -8.950030625310893e-19, -5.014714978348788e-21,  6.651779321092917e-23,  1.888890770665416e+00,
 -2.222313629219141e-03, -3.081036703630381e-05, -3.361288336061675e-07, -2.769400978176236e-09, -1.200183192435721e-11,  1.101443252687951e-13,  3.453875126664471e-15,
  4.822926464378492e-17,  4.143207127885067e-19,  8.549492674472317e-22, -4.503166533274012e-23,  1.978277076622140e+00, -4.647415236415842e-04, -7.351761609609320e-06,
 -1.014045777219441e-07, -1.278739020147495e-09, -1.498229783238026e-11, -1.633982661575554e-13, -1.642514793656492e-15, -1.480015103776701e-17, -1.109257299664592e-19,
 -5.087492847853419e-22,  3.161273005864177e-24,  4.027633495645377e-03, -5.747023733782621e-05,  6.139476630408706e-07, -5.819496045278187e-09,  5.156053130327592e-11,
 -4.373350303725850e-13,  3.590219774243356e-15, -2.877081185833013e-17,  2.254035747957325e-19, -1.738579802574108e-21,  1.311339525419614e-23, -9.838152961874504e-26,
  3.619745375849572e-02, -5.112302527317209e-04,  5.338486174031369e-06, -4.859750515955758e-08,  4.037047978439394e-10, -3.108309403961241e-12,  2.213284499392343e-14,
 -1.438777028869813e-16,  8.144963210046463e-19, -3.568414083177179e-21,  4.007759970429885e-24,  1.391369222735419e-25,  1.002536716309654e-01, -1.386324973484580e-03,
  1.379705782187475e-05, -1.147792506552347e-07,  8.133630904167837e-10, -4.686249995639383e-12,  1.734208808173358e-14,  3.749517669538104e-17, -1.573092658689262e-18,
  1.931586572259592e-20, -1.704245928739986e-22,  1.098194309853611e-24,  1.955792301890070e-01, -2.615948108129439e-03,  2.404952057359265e-05, -1.695267992588242e-07,
  8.211708764052765e-10, -5.637669761344419e-13, -4.312295402640167e-14,  5.867006060822428e-16, -4.692245339881627e-18,  1.970407168350708e-20,  8.169901388876065e-23,
 -2.686620477648117e-24,  3.211149039911100e-01, -4.095223445193294e-03,  3.332185034263529e-05, -1.711759399267787e-07,  5.483235112160288e-11,  9.929194974091019e-12,
 -1.171556648907892e-13,  6.370342743378617e-16,  1.510043199881415e-18, -7.118391466668064e-20,  7.518286723691968e-22, -3.359424056083838e-24,  4.751752941854635e-01,
 -5.676480546554319e-03,  3.827313130107664e-05, -8.586219849439588e-08, -1.438990271384314e-09,  1.954245918953383e-11, -8.234508863313133e-14, -7.960483471505645e-16,
  1.559616947216315e-17, -9.387162664950315e-20, -4.816093061845497e-22,  1.440112745399211e-23,  6.551618988663955e-01, -7.165304913848288e-03,  3.554412974585755e-05,
  9.143284469149162e-08, -2.915755508725597e-09,  1.465966653738529e-11,  1.375608440258527e-13, -2.498996664412647e-15,  7.146468300143934e-18,  1.975866500074443e-19,
 -2.496473687617437e-21, -7.312504844339757e-26,  8.571359457031700e-01, -8.321566048555457e-03,  2.276607105093805e-05,  3.131983689522735e-07, -3.006992170537933e-09,
 -1.247767046013748e-11,  3.544846574195179e-13, -5.987399330128750e-16, -3.612645488507316e-17,  2.729119319959370e-19,  2.749510782311948e-21, -5.015211408863008e-23,
  1.075211996077611e+00, -8.874203654980985e-03,  1.680335849880306e-07,  4.679034344029187e-07, -5.906510166947508e-10, -4.374147893427191e-11,  1.359708891225095e-13,
  4.825126872356593e-15, -2.603295817426331e-17, -5.715043642683768e-19,  4.615917373613783e-21,  6.855677980160882e-23,  1.300762753006999e+00, -8.565673951320492e-03,
 -2.744408834383360e-05,  4.139595131574587e-07,  3.451182112320040e-09, -3.414740105971079e-11, -4.936140729051449e-13,  3.056949185029423e-15,  7.436355275140835e-17,
 -2.405976014397935e-19, -1.153283094828434e-20,  5.745723691778372e-24,  1.521539915749233e+00, -7.247909001342070e-03, -4.968285757633882e-05,  9.724576032227952e-08,
  5.240719612071523e-09,  2.781453290558429e-11, -4.478353935187036e-13, -7.254425994742576e-15,  7.668564966047935e-18,  1.156641780392226e-18,  8.074770098835531e-21,
 -1.216633100216092e-22,  1.721106285304714e+00, -5.039473319907650e-03, -5.378602927847871e-05, -2.917974004353935e-07,  1.581699320258610e-09,  5.309516479460709e-11,
  4.775807415548354e-13, -1.162703001642933e-15, -8.693607891438211e-17, -1.009251279273519e-18,  4.694366717047680e-23,  1.683205809553907e-22,  1.879481918373341e+00,
 -2.485701159625084e-03, -3.511713370940421e-05, -3.821797177251108e-07, -2.974209296382613e-09, -8.009564071789894e-12,  2.307218854504339e-13,  5.237643037107212e-15,
  6.313672971688729e-17,  3.923538754121281e-19, -2.425619984636908e-21, -1.100224050918214e-22,  1.976292252690315e+00, -5.287950923760640e-04, -8.701999147750584e-06,
 -1.244912891801834e-07, -1.621618510157880e-09, -1.951307968841757e-11, -2.166452649222157e-13, -2.183535510335520e-15, -1.910541037067144e-17, -1.260918835382126e-19,
 -1.750474684373131e-22,  1.350269176359041e-23,  3.807152386752701e-03, -5.282460301479849e-05,  5.487893308369099e-07, -5.060079443665299e-09,  4.361421070819810e-11,
 -3.600761011326932e-13,  2.876884145317620e-15, -2.246599103772932e-17,  1.712973116142027e-19, -1.291539480527824e-21,  9.442482491894351e-24, -7.033237547977134e-26,
  3.423440413771180e-02, -4.707497795932168e-04,  4.792110159358557e-06, -4.260801490384482e-08,  3.465389004183446e-10, -2.622636145739359e-12,  1.845013207217123e-14,
 -1.198281816233904e-16,  6.901142082698598e-19, -3.315754161843689e-21,  7.963891465993032e-24,  4.786857844060301e-26,  9.492070456608179e-02, -1.281243654974507e-03,
  1.249477074470072e-05, -1.024923647252365e-07,  7.238583953168993e-10, -4.262532053257437e-12,  1.778289287474691e-14, -2.942965241432389e-18, -9.893859960476867e-19,
  1.339851402296465e-20, -1.271464317165208e-22,  8.649287139004880e-25,  1.854876598209124e-01, -2.431467067170461e-03,  2.209349169415768e-05, -1.565292115806193e-07,
  8.007918225237570e-10, -1.417880927678450e-12, -2.868755058988305e-14,  4.483212933099116e-16, -3.949033047038351e-18,  2.098834077226447e-20, -8.988849276533845e-24,
 -1.518914516823560e-24,  3.052541901848986e-01, -3.836836042927153e-03,  3.127907811721674e-05, -1.688565876424218e-07,  2.267625880832158e-10,  7.334794998600617e-12,
 -9.898783606712025e-14,  6.498511115304463e-16, -5.494551346181166e-19, -4.433172257478855e-20,  5.863887566638434e-22, -3.974528655386217e-24,  4.530747022438772e-01,
 -5.374779313762772e-03,  3.711717369670972e-05, -1.058732321807889e-07, -1.069431526329532e-09,  1.735187398164958e-11, -9.817520021329627e-14, -3.536171779622239e-16,
  1.200788817960334e-17, -1.020946351113517e-19,  3.020725561930935e-23,  8.896228570478649e-24,  6.270752452375905e-01, -6.877332852678458e-03,  3.637160407562095e-05,
  4.728243444393437e-08, -2.595056354122274e-09,  1.715319294028190e-11,  7.172352829864111e-14, -2.175562300530046e-15,  1.249373617477339e-17,  1.011255071181998e-19,
 -2.252951178472599e-21,  1.003561154773436e-23,  8.242365657692527e-01, -8.125237860593442e-03,  2.622902134572432e-05,  2.635443875592114e-07, -3.173461393205484e-09,
 -4.292118535717142e-12,  3.231386057122020e-13, -1.580676535926980e-15, -2.485211816236740e-17,  3.391507382715895e-19,  5.978450389455171e-22, -4.540293051290345e-23,
  1.039753117908167e+00, -8.850625793257424e-03,  5.697998195340626e-06,  4.516756992707505e-07, -1.422466297456738e-09, -3.896867385147120e-11,  2.566033643219663e-13,
  3.703689861655693e-15, -4.266910328366926e-17, -3.390794523628842e-19,  6.672599603728326e-21,  2.320108572044663e-23,  1.266093664464924e+00, -8.764473802172202e-03,
 -2.216979213665079e-05,  4.631049765229584e-07,  2.658044147194427e-09, -4.470925131023760e-11, -3.766311578051620e-13,  5.210981809793088e-15,  5.769064853509013e-17,
 -6.715147887365964e-19, -9.398983524302735e-21,  8.939872947060389e-23,  1.491762807684205e+00, -7.639240444767860e-03, -4.799651982069976e-05,  1.848955710934135e-07,
  5.673390490843391e-09,  1.469713373404816e-11, -6.408898548566588e-13, -6.292883045642828e-15,  5.353752212965931e-17,  1.340631567967612e-18,  3.846642689853559e-22,
 -2.222223604769938e-22,  1.700066357730117e+00, -5.483252935836738e-03, -5.709873963047769e-05, -2.573893710279786e-07,  2.753819171362301e-09,  6.381891056775155e-11,
  4.007119938351951e-13, -4.509129022797829e-15, -1.211454951656552e-16, -8.259019906220029e-19,  9.919279199645247e-21,  2.767800765747605e-22,  1.868947038574002e+00,
 -2.785801795751999e-03, -3.999297968066702e-05, -4.306936070742412e-07, -3.065916346140065e-09, -4.719699949355567e-13,  4.075884555330536e-13,  7.454226178778258e-15,
  7.410276995119202e-17,  1.710022359969136e-19, -9.389620354649025e-21, -2.124714698457803e-22,  1.974027714746653e+00, -6.048593514114439e-04, -1.036542364495394e-05,
 -1.538638676222548e-07, -2.069202133427619e-09, -2.551952731547932e-11, -2.870272618104714e-13, -2.867408628340770e-15, -2.357779376060783e-17, -1.155046578454437e-19,
  8.776373551894346e-22,  3.750662085431560e-23,  3.604266093672727e-03, -4.866583307720640e-05,  4.920292847626962e-07, -4.416316049656255e-09,  3.705521593749167e-11,
 -2.980005420256095e-13,  2.318074281127082e-15, -1.766118868225988e-17,  1.309105750163410e-19, -9.697146719094047e-22,  6.782560065837923e-24, -5.191664659760136e-26,
  3.242496857813656e-02, -4.343676600362974e-04,  4.312425696523171e-06, -3.746005256673698e-08,  2.982548759698921e-10, -2.217707809333225e-12,  1.538662562381766e-14,
 -9.958998364548570e-17,  5.768106397946654e-19, -2.974298500631881e-21,  8.672810191089864e-24, -1.224551354624387e-26,  8.998812646720980e-02, -1.186014561813935e-03,
  1.133161439802245e-05, -9.156953364159738e-08,  6.428522534314028e-10, -3.839896721693015e-12,  1.732316958230695e-14, -2.779719993723077e-17, -5.900670103511433e-19,
  9.001949697524203e-21, -9.446261003754191e-23,  6.207421771433572e-25,  1.761036955803604e-01, -2.262017098440318e-03,  2.029097125522839e-05, -1.439767919313223e-07,
  7.664951289764490e-10, -1.969333173291960e-12, -1.779131044151758e-14,  3.338562385626716e-16, -3.213810856035883e-18,  1.952987942718195e-20, -5.881730062707848e-23,
 -8.145414886535177e-25,  2.903945789189751e-01, -3.594636514000410e-03,  2.927900789378569e-05, -1.641777656978142e-07,  3.511593059428035e-10,  5.174128799120879e-12,
 -8.124779112136844e-14,  6.109184344051282e-16, -1.765278188068261e-18, -2.435857263254743e-20,  4.136079780929925e-22, -3.798553305035721e-24,  4.321610364492723e-01,
 -5.083189195291890e-03,  3.575505961654818e-05, -1.203384857478912e-07, -7.465480198407819e-10,  1.491690386254836e-11, -1.032438336898325e-13, -2.726309412797214e-17,
  8.434853828664550e-18, -9.454947810043236e-20,  3.119935397047339e-22,  4.090647025170879e-24,  6.001504914746046e-01, -6.584769737446639e-03,  3.670143739440872e-05,
  8.579709725584810e-09, -2.239467456532309e-09,  1.819151134481636e-11,  1.683377102103356e-14, -1.733943691913321e-15,  1.463322656700433e-17,  2.136574866907194e-20,
 -1.707885350359845e-21,  1.379193572208198e-23,  7.921740841815054e-01, -7.903622607884225e-03,  2.908538915049828e-05,  2.124871195815129e-07, -3.185751735473587e-09,
  2.853589146954359e-12,  2.695927335779780e-13, -2.179666569158933e-15, -1.265975150888780e-17,  3.269364541244124e-19, -1.102283873404202e-21, -3.093926876950100e-23,
  1.004475488677099e+00, -8.783805180071902e-03,  1.095700376976249e-05,  4.230482186488761e-07, -2.132693441220343e-09, -3.172944859631293e-11,  3.397304494936961e-13,
  2.195625333328142e-15, -4.995493298694232e-17, -6.586733193041252e-20,  6.652019877550138e-21, -2.266392881367425e-23,  1.230717175949659e+00, -8.918951000798172e-03,
 -1.638831526582046e-05,  4.980421274354520e-07,  1.686260716707237e-09, -5.181361810334815e-11, -2.089792674090120e-13,  6.606626303445052e-15,  2.787628719479778e-17,
 -9.497003681352743e-19, -4.117899495797704e-21,  1.428397847577148e-22,  1.460454154503326e+00, -8.012777824986602e-03, -4.522628855589441e-05,  2.771297829139741e-07,
  5.800435885334517e-09, -2.560834347511821e-12, -7.859456008266275e-13, -3.824768172209978e-15,  9.955545593378883e-17,  1.143559226910618e-18, -1.049116890102548e-20,
 -2.561195807015991e-22,  1.677201393897288e+00, -5.951548350555176e-03, -5.987936932217140e-05, -2.026458384098059e-07,  4.113772956303656e-09,  7.145874977968261e-11,
  2.164041480595688e-13, -8.759757052953027e-15, -1.406038244449043e-16, -1.653308675917453e-19,  2.341502588607969e-20,  3.169705582395919e-22,  1.857130037547107e+00,
 -3.127249747827283e-03, -4.545401517656328e-05, -4.792164598503706e-07, -2.959230373657433e-09,  1.208533273694335e-11,  6.497970053268141e-13,  9.831082197406285e-15,
  7.091638623641503e-17, -4.277954567493192e-19, -2.145423115780049e-20, -3.354322362597397e-22,  1.971429887957998e+00, -6.957723924904913e-04, -1.242856713315451e-05,
 -1.914573873947124e-07, -2.655438255112936e-09, -3.346039554039863e-11, -3.784322571349076e-13, -3.677719787295354e-15, -2.659622934814206e-17, -3.481475350054738e-20,
  3.532573261648098e-21,  8.949494879134289e-23,  3.417153245670415e-03, -4.493193707438233e-05,  4.424034643175929e-07, -3.868249926081706e-09,  3.161380339875979e-11,
 -2.478580367553801e-13,  1.877309453612284e-15, -1.398247455087908e-17,  1.003695430449637e-19, -7.402438359581478e-22,  4.777536722261759e-24, -3.994579136146254e-26,
  3.075376002936975e-02, -4.015884567803758e-04,  3.890136336848061e-06, -3.302365545641206e-08,  2.573780080347364e-10, -1.879901866824569e-12,  1.284088739843937e-14,
 -8.278018585551927e-17,  4.757230794929822e-19, -2.651895258459591e-21,  7.142408429947499e-24, -5.374372185720406e-26,  8.541865410897810e-02, -1.099587819769890e-03,
  1.029203184428615e-05, -8.187599107695337e-08,  5.701389882353899e-10, -3.435339579905374e-12,  1.632430600817206e-14, -4.217425262642267e-17, -3.280645357740265e-19,
  5.700212383245623e-21, -7.227397630906169e-23,  3.957564146817705e-25,  1.673696307064753e-01, -2.106394856891912e-03,  1.863546657281562e-05, -1.320481856629300e-07,
  7.235383697412703e-10, -2.295138245542707e-12, -9.781031066998663e-15,  2.417472726534209e-16, -2.560536740508108e-18,  1.658653482269246e-20, -8.569681213682369e-23,
 -4.457533240455410e-25,  2.764721638607449e-01, -3.368182263552697e-03,  2.734567332736970e-05, -1.578316115321478e-07,  4.364919372601600e-10,  3.422363096542044e-12,
 -6.504384031761284e-14,  5.432726144425176e-16, -2.383511590705434e-18, -1.102674910580598e-20,  2.565998106574505e-22, -3.301691215719227e-24,  4.123909570151905e-01,
 -4.803106226921787e-03,  3.424873875798109e-05, -1.300309295856244e-07, -4.729056731980976e-10,  1.245734030568072e-11, -1.007212249894578e-13,  1.908819527699367e-16,
  5.288486142347037e-18, -7.961441791851224e-20,  4.089729251916141e-22,  5.566216616101546e-25,  5.743984641657011e-01, -6.291327831728350e-03,  3.660143973792867e-05,
 -2.433472698333300e-08, -1.875254848873534e-09,  1.806609936615957e-11, -2.513243082757258e-14, -1.265366741976689e-15,  1.431938145752100e-17, -3.482169029008540e-20,
 -1.108322351258468e-21,  1.289912580388692e-23,  7.610398941354478e-01, -7.661600121858462e-03,  3.133236616430998e-05,  1.623017767852428e-07, -3.069112921169027e-09,
  8.556179630080352e-12,  2.045852435062985e-13, -2.407339550581929e-15, -1.966722101023985e-18,  2.605625512215527e-19, -2.094989272288273e-21, -1.434260672313064e-23,
  9.695468528780254e-01, -8.676468188068897e-03,  1.580938667207048e-05,  3.843090623065403e-07, -2.681703787201476e-09, -2.301924027204879e-11,  3.788232707056395e-13,
  6.078801041140980e-16, -4.787442389720093e-17,  1.698521722889435e-19,  4.912550620374496e-21, -5.294909703785358e-23,  1.194817551951113e+00, -9.025773046877166e-03,
 -1.028483310776043e-05,  5.165239063693184e-07,  6.152009155163744e-10, -5.454091009299215e-11, -1.679876740704932e-14,  6.932448807856613e-15, -7.721658041074947e-18,
 -9.850088928483913e-19,  2.336873267675339e-21,  1.407780081416188e-22,  1.427702698110589e+00, -8.359718889167212e-03, -4.134898220178053e-05,  3.684726698804899e-07,
  5.553927320653939e-09, -2.231404895928336e-11, -8.429512139062518e-13, -8.263850054601784e-17,  1.305706530871289e-16,  5.130612255448536e-19, -2.045496084651669e-20,
 -1.768014203215199e-22,  1.652423454154754e+00, -6.439081359664060e-03, -6.186837020750915e-05, -1.252024218835882e-07,  5.572392539678406e-09,  7.320236832508186e-11,
 -9.131257786852344e-14, -1.314736117920249e-14, -1.265193473339699e-16,  1.027103445738557e-18,  3.525290733545343e-20,  1.849025939418331e-22,  1.843856249259077e+00,
 -3.514664812622283e-03, -5.147771144249028e-05, -5.236851981307537e-07, -2.538034613415150e-09,  3.121923718629179e-11,  9.531655187773175e-13,  1.165769089041710e-14,
  3.624397013883013e-17, -1.609170033690484e-18, -3.811185869394470e-20, -4.008290333117764e-22,  1.968432299550590e+00, -8.051674101040199e-04, -1.500476005319968e-05,
 -2.398282841371345e-07, -3.424308679073743e-09, -4.387462146061342e-11, -4.932657858286319e-13, -4.512408873295250e-15, -2.412825785001830e-17,  2.112920042959520e-19,
  9.538135043536099e-21,  1.952251337905900e-22,  3.244221628059766e-03, -4.157014787682495e-05,  3.988633851249976e-07, -3.399765232621714e-09,  2.707726043427659e-11,
 -2.071611716581591e-13,  1.527003458952338e-15, -1.116340247336568e-17,  7.676494136347683e-20, -5.811884859497266e-22,  3.258464886020308e-24, -2.829471585813992e-26,
  2.920723378406741e-02, -3.719852471828481e-04,  3.517372183614350e-06, -2.919040533941841e-08,  2.226825609839765e-10, -1.597900859853192e-12,  1.072217862026037e-14,
 -6.903436558713410e-17,  3.847809366464935e-19, -2.417651579590390e-21,  4.599914528089618e-24, -4.785087240245338e-26,  8.117896498472486e-02, -1.021031620271285e-03,
  9.362053780481158e-06, -7.328255530564209e-08,  5.052489825255649e-10, -3.058742615037888e-12,  1.502350816790506e-14, -4.991581989716327e-17, -1.711279989485389e-19,
  3.113011526090262e-21, -5.780097653544173e-23,  3.027598466307504e-25,  1.592324562300103e-01, -1.963456195486452e-03,  1.711879782430653e-05, -1.208494066483949e-07,
  6.757908412280209e-10, -2.457387586044284e-12, -4.074376258132060e-15,  1.686689673452713e-16, -2.029084934269676e-18,  1.285238176413312e-20, -9.855392362559267e-23,
 -9.670302121954990e-26,  2.634251441850089e-01, -3.156869392506743e-03,  2.549559497880210e-05, -1.503799667711464e-07,  4.905149561421767e-10,  2.034928960388505e-12,
 -5.094716126395861e-14,  4.623576835558528e-16, -2.628858583588744e-18, -3.454711188629349e-21,  1.283538469251143e-22, -2.413870997392331e-24,  3.937164718833461e-01,
 -4.535468339669387e-03,  3.265077077814149e-05, -1.357334579449499e-07, -2.474110351216560e-10,  1.012075536066268e-11, -9.341558997314216e-14,  3.174176619303695e-16,
  2.716338373768992e-18, -6.343837459605451e-20,  3.870569588660189e-22, -1.173817071312590e-24,  5.498162422052425e-01, -6.000167258572886e-03,  3.614118530460839e-05,
 -5.149213371121623e-08, -1.522572839333902e-09,  1.708809913151667e-11, -5.439086507584878e-14, -8.346952568977353e-16,  1.239763527425038e-17, -6.857479221045572e-20,
 -5.988930850899815e-22,  1.028312985180110e-23,  7.309059870933158e-01, -7.403970881265997e-03,  3.299180119459351e-05,  1.148087972390371e-07, -2.854350880124017e-09,
  1.265831127121677e-11,  1.375876781980635e-13, -2.337329481473933e-15,  5.793702056181742e-18,  1.685652211853511e-19, -2.400509082742825e-21,  1.130505160282002e-26,
  9.351220659595467e-01, -8.532307446615161e-03,  2.015006780477330e-05,  3.382154660522626e-07, -3.050658477996871e-09, -1.388946014764083e-11,  3.755580512914652e-13,
 -7.931650283953341e-16, -3.882267560200578e-17,  3.158741393727416e-19,  2.336082643921639e-21, -6.013996645845461e-23,  1.158589285404058e+00, -9.083173949904579e-03,
 -4.063376683133693e-06,  5.176837533984687e-07, -4.642062587897055e-10, -5.267453189609348e-11,  1.687150819895985e-13,  6.147450010223488e-15, -4.011640134026061e-17,
 -7.803156193250863e-19,  7.511048011117278e-21,  8.827870235182105e-23,  1.393632321793332e+00, -8.671354418056920e-03, -3.641240237979697e-05,  4.526739189558160e-07,
  4.907641520512773e-09, -4.208940753874015e-11, -7.851933869508558e-13,  4.220765920433534e-15,  1.328642414256720e-16, -4.127193626804121e-19, -2.449668033269708e-20,
  5.588328322069211e-24,  1.625670004135199e+00, -6.938412505809327e-03, -6.278828237810131e-05, -2.458369203754024e-08,  6.982523703558235e-09,  6.618005781799993e-11,
 -5.085527158945239e-13, -1.632138156370014e-14, -6.299266947848828e-17,  2.509755826805464e-18,  3.625053495777780e-20, -1.743660553124190e-22,  1.828933245360729e+00,
 -3.952257652780927e-03, -5.798064707641913e-05, -5.579432025076004e-07, -1.658041336127054e-09,  5.807836755090402e-11,  1.284816590737925e-12,  1.156297202483143e-14,
 -5.318752851561006e-17, -3.461004425195454e-18, -5.324065847012520e-20, -2.260168087707107e-22,  1.964951918409163e+00, -9.377197477488658e-04, -1.824259480089050e-05,
 -3.023247893493618e-07, -4.430829046864584e-09, -5.730628890618988e-11, -6.286430340068397e-13, -5.069514298708485e-15, -7.140366331265319e-18,  8.148949026311791e-19,
  2.208780292984517e-20,  3.944876348071729e-22,  3.084074466749819e-03, -3.853536696853887e-05,  3.605350641407733e-07, -2.997785161396842e-09,  2.327655487699547e-11,
 -1.740048977392860e-13,  1.245840272585183e-15, -9.018648461438901e-18,  5.793855012318806e-20, -4.699324835946201e-22,  2.487578583867226e-24, -2.762517388785070e-27,
  2.777343469794375e-02, -3.451891806493625e-04,  3.187453783624872e-06, -2.586979997327516e-08,  1.931481506059118e-10, -1.362451978351314e-12,  8.948750601544138e-15,
 -5.808097740487666e-17,  3.008062860546122e-19, -2.244598804479372e-21,  5.230304080670132e-24,  1.170457351944760e-25,  7.723924993321866e-02, -9.495198493687677e-04,
  8.529210385686358e-06, -6.566886490561372e-08,  4.475637485791682e-10, -2.715480648605565e-12,  1.356302891520410e-14, -5.401635549030417e-17, -9.701588835720731e-20,
  1.125555349145201e-21, -3.895716116643691e-23,  6.709315595305724e-25,  1.516436022030482e-01, -1.832126531595510e-03,  1.573184586036707e-05, -1.104337692569365e-07,
  6.260115759552814e-10, -2.505436687482678e-12, -1.965328159563470e-16,  1.103842160472830e-16, -1.636449935640421e-18,  9.052585507867341e-21, -8.374818195683623e-23,
  9.784367171230216e-25,  2.511943591750143e-01, -2.959986768391488e-03,  2.373926427820916e-05, -1.422683444767863e-07,  5.199853419946468e-10,  9.579591828788465e-13,
 -3.919157536278248e-14,  3.770555631443364e-16, -2.681979656228711e-18,  6.882070663656200e-23,  6.418674297073175e-23, -1.354531490585327e-25,  3.760866194125801e-01,
 -4.280830067466510e-03,  3.100451155968529e-05, -1.381913550440610e-07, -6.665357701537815e-11,  7.993249941593166e-12, -8.363357797432709e-14,  3.706900876869246e-16,
  6.995824874220083e-19, -4.884464203360864e-20,  3.538277552884036e-22,  4.094980990498535e-25,  5.263893676854555e-01, -5.713898061536511e-03,  3.538814126867888e-05,
 -7.319729939179688e-08, -1.195536278970261e-09,  1.554466559755512e-11, -7.260729890702576e-14, -4.812361018616000e-16,  9.602926856358901e-18, -8.384164706417829e-20,
 -1.646709638755870e-22,  1.034710824831449e-23,  7.018256284882032e-01, -7.135281735316244e-03,  3.410436498512579e-05,  7.132211816363667e-08, -2.573335008989458e-09,
  1.520097175240486e-11,  7.551932360903973e-14, -2.073137176074691e-15,  1.016902662734857e-17,  7.643569486314790e-20, -2.107512899257339e-21,  1.364963572458664e-23,
  9.013397462966563e-01, -8.355720318425790e-03,  2.390818308982523e-05,  2.876624077949229e-07, -3.240791634450809e-09, -5.271926554135860e-12,  3.377657467604490e-13,
 -1.840523658858462e-15, -2.637981706554209e-17,  3.597245525331452e-19, -1.655822802650879e-23, -4.268785869780127e-23,  1.122230637868711e+00, -9.091036764378982e-03,
  2.070364961351206e-06,  5.021041358135628e-07, -1.464114611193188e-09, -4.672860529461290e-11,  3.190998913715466e-13,  4.478626987523453e-15, -6.204925580159645e-17,
 -4.225460089473432e-19,  9.882360315081330e-21,  2.114072078057471e-23,  1.358400500992512e+00, -8.939660804766813e-03, -3.054014735068976e-05,  5.234865695706378e-07,
  3.889379982305484e-09, -5.905584206499769e-11, -6.110491613029075e-13,  8.049879498382332e-15,  1.010091293458378e-16, -1.323839590044417e-18, -1.948977565878620e-20,
  2.196394149444826e-22,  1.596912680764281e+00, -7.439904034426544e-03, -6.237186558826981e-05,  9.690402956114949e-08,  8.146267174458198e-09,  4.835599323305342e-11,
 -9.783215753273637e-13, -1.663495681526832e-14,  5.034687719508239e-17,  3.667149935719073e-18,  1.815482645410871e-20, -6.443473800196376e-22,  1.812153614768861e+00,
 -4.443235399387629e-03, -6.479108975482975e-05, -5.733989264211594e-07, -1.634303314282720e-10,  9.247664476037965e-11,  1.563018472978800e-12,  7.445460080922056e-15,
 -2.171706836902219e-16, -5.633345859886412e-18, -5.038072907601433e-20,  4.633721200464471e-22,  1.960884357935579e+00, -1.099469953050388e-03, -2.233646149478840e-05,
 -3.832551228779094e-07, -5.739320047418709e-09, -7.408876286769572e-11, -7.679412063495507e-13, -4.619108253208867e-15,  4.306258677323492e-17,  2.133345502731507e-18,
  4.627267780425018e-20,  7.292086354272976e-22,  2.935482330514214e-03, -3.578890326454259e-05,  3.266863847263529e-07, -2.651658772972450e-09,  2.007602323842643e-11,
 -1.469404278102410e-13,  1.016870791002682e-15, -7.415512455214462e-18,  4.291052564347483e-20, -3.582288779240683e-22,  3.537043320347417e-24,  5.773401822417102e-26,
  2.644178266186711e-02, -3.208807622642394e-04,  2.894695521873741e-06, -2.298628701027924e-08,  1.679203945501910e-10, -1.166182312311848e-12,  7.445474231272947e-15,
 -4.969109164077323e-17,  2.260330216047190e-19, -1.814082707173797e-21,  1.995910389444213e-23,  6.214188923035788e-25,  7.357281363244088e-02, -8.843205496610218e-04,
  7.782413780280043e-06, -5.892515580239632e-08,  3.963850656043730e-10, -2.408439842862057e-12,  1.201147062504820e-14, -5.669863772408027e-17, -7.476239447318639e-20,
  4.670936466726952e-22,  1.580664777557574e-23,  2.016611702368318e-24,  1.445586480152828e-01, -1.711406115619463e-03,  1.446508594523765e-05, -1.008177621431745e-07,
  5.760766460754675e-10, -2.478701006203783e-12,  2.206150327603494e-15,  6.270799887213266e-17, -1.354483464827782e-18,  7.253733865330693e-21,  1.495560254517623e-23,
  3.891169305082710e-24,  2.397236291324751e-01, -2.776758957507584e-03,  2.208243883354143e-05, -1.338429960502458e-07,  5.305436658418234e-10,  1.343750355129456e-13,
 -2.983135416502935e-14,  2.918292474112909e-16, -2.623225987318475e-18,  3.833669967325021e-21,  1.636006937638094e-22,  5.308816602748988e-24,  3.594488583371486e-01,
 -4.039433830972041e-03,  2.934474854099784e-05, -1.380843958212967e-07,  7.398663041855559e-11,  6.111601007727288e-12, -7.318507270863739e-14,  3.678006767174669e-16,
 -7.852208785310438e-19, -3.264197405386214e-20,  5.104983283902584e-22,  7.869854086747234e-24,  5.040939939707085e-01, -5.434608595195911e-03,  3.440494388674098e-05,
 -8.993740589583327e-08, -9.029926278042495e-10,  1.367230843441651e-11, -8.223705234834599e-14, -2.225303736792919e-16,  6.589624852840105e-18, -7.966211712721850e-20,
  4.330479959955141e-22,  1.854867888220444e-23,  6.738346348595656e-01, -6.859699650810537e-03,  3.472348960334833e-05,  3.266034310457722e-08, -2.255693992639543e-09,
  1.635562789187104e-11,  2.233310708415988e-14, -1.718503778991285e-15,  1.159329925784486e-17,  9.241309789489975e-21, -1.109655176537548e-21,  3.331049119985553e-23,
  8.683200067573511e-01, -8.151533798664592e-03,  2.704691156356208e-05,  2.353875945265294e-07, -3.269783180926034e-09,  2.132527242948413e-12,  2.763405010720876e-13,
 -2.480671265221043e-15, -1.379986623155057e-17,  3.322294044458363e-19, -1.047185598477081e-21, -2.949736707063780e-26,  1.085937124344150e+00, -9.050839214668956e-03,
  7.925673029194839e-06,  4.716562783154900e-07, -2.313154409492820e-09, -3.780105920118431e-11,  4.149665734536180e-13,  2.326887751887800e-15, -7.005242155873373e-17,
 -2.231798918350924e-20,  9.885820457521458e-21, -1.171733884272359e-23,  1.322194369541202e+00, -9.157891253518473e-03, -2.392626208224926e-05,  5.755534999081978e-07,
  2.581551357877191e-09, -7.069989887198140e-11, -3.485118800503831e-13,  1.039139527034851e-14,  4.214516795165187e-17, -1.856551131765685e-18, -5.961916194150139e-21,
  3.815232870277759e-22,  1.566165693178429e+00, -7.931947335656492e-03, -6.039961439686550e-05,  2.335520421803826e-07,  8.842333755074838e-09,  1.959447946383455e-11,
 -1.401053582162124e-12, -1.283352392301877e-14,  1.876213340886589e-16,  3.723722032979000e-18, -1.715206256489966e-20, -8.884068784651186e-22,  1.793300577013917e+00,
 -4.988977626763522e-03, -7.161977524119977e-05, -5.591251460391088e-07,  2.073213236213146e-09,  1.315055353262216e-10,  1.641267982951369e-12, -3.077516147941600e-15,
 -4.481779094143296e-16, -6.884839493504601e-18, -2.201501826109854e-21,  1.829269053273939e-21,  1.956097606533393e+00, -1.298238310236638e-03, -2.753875120794510e-05,
 -4.879799660378650e-07, -7.414719523046347e-09, -9.383023065545068e-11, -8.634913070901447e-13, -1.584771581021874e-15,  1.620674277712728e-16,  4.754108019011749e-18,
  8.807040419841878e-20,  1.179194251979205e-21,  2.797359598706838e-03, -3.329744620368111e-05,  2.967009057777451e-07, -2.352694816042822e-09,  1.736520067109153e-11,
 -1.248827645151409e-13,  8.267528170111931e-16, -6.214852848488881e-18,  3.341765096432287e-20, -1.386245384927018e-22,  8.172012114345907e-24,  1.568044496003808e-25,
  2.520289000441216e-02, -2.987825773288454e-04,  2.634240946263566e-06, -2.047690003000414e-08,  1.462749558167377e-10, -1.003423061668256e-12,  6.147044236004259e-15,
 -4.328156062098506e-17,  1.838162624214159e-19, -2.305014054495708e-22,  6.562241234027511e-23,  1.491336816769364e-24,  7.015571925268860e-02, -8.247853919254636e-04,
  7.111824557144864e-06, -5.295322652426655e-08,  3.509691296869613e-10, -2.139460745536476e-12,  1.039500279961914e-14, -5.848849854466354e-17, -1.933540221498254e-20,
  3.528917510340672e-21,  1.549559846141115e-22,  4.417068550397677e-24,  1.379370190508660e-01, -1.600371734110711e-03,  1.330895095966211e-05, -9.199373907828979e-08,
  5.271500809964925e-10, -2.409326180832391e-12,  3.397570054118720e-15,  2.407196246461704e-17, -1.029153416185513e-18,  1.263736354436453e-20,  2.907682617043281e-22,
  8.857056329576835e-24,  2.289599439517780e-01, -2.606379638146507e-03,  2.052722493764624e-05, -1.253690877358239e-07,  5.266852370244300e-10, -4.928218297545215e-13,
 -2.280224481834484e-14,  2.119571673906601e-16, -2.289095198241679e-18,  1.751178996736897e-20,  5.861031785123920e-22,  1.425472556625519e-23,  3.437501844742151e-01,
 -3.811275082537805e-03,  2.769857244758169e-05, -1.360147488927509e-07,  1.794697016710836e-10,  4.474976684171815e-12, -6.338202879278164e-14,  3.287043191151170e-16,
 -1.476273300782511e-18, -1.591209993614465e-21,  1.142465975993759e-21,  2.151687556267802e-23,  4.828988832108830e-01, -5.163911577273170e-03,  3.324767925046409e-05,
 -1.023066779192402e-07, -6.496755716520195e-10,  1.164519111801738e-11, -8.591248681935498e-14, -5.233727825296974e-17,  4.272255934609367e-18, -4.128393829536160e-20,
  1.617289285034444e-21,  3.639017506732841e-23,  6.469530610091950e-01, -6.580932614674227e-03,  3.490971326433540e-05, -8.003423366960761e-10, -1.926901957489358e-09,
  1.635620725068486e-11, -2.058336238475234e-14, -1.347424306582895e-15,  1.155261747137153e-17,  2.237453763487493e-21,  9.730500602066966e-22,  6.237400909960010e-23,
  8.361632630841129e-01, -7.924743820455096e-03,  2.956017185774566e-05,  1.837482410647420e-07, -3.166649072392902e-09,  7.892074333667710e-12,  2.024447518163504e-13,
 -2.737963222116881e-15, -2.436358985587968e-18,  3.078367155504283e-19,  2.857594022036401e-22,  6.238889073964345e-23,  1.049895464667128e+00, -8.965477357571671e-03,
  1.334033925459879e-05,  4.291563664401746e-07, -2.965608661625870e-09, -2.731137319472867e-11,  4.491541364809229e-13,  1.478328922116464e-16, -6.383130334487171e-17,
  3.671318710108110e-19,  9.807598085342004e-21,  1.807450767197589e-23,  1.285224572922450e+00, -9.321082517155755e-03, -1.681965004521963e-05,  6.051927458258653e-07,
  1.108000484628493e-09, -7.548283346230834e-11, -4.884857937006173e-14,  1.065923211889476e-14, -2.467908062880877e-17, -1.732357457265188e-18,  1.265082661224714e-20,
  4.470661239440493e-22,  1.533492679057751e+00, -8.401511275802569e-03, -5.674141264666246e-05,  3.762290808595728e-07,  8.872872690879313e-09, -1.754716140207526e-11,
 -1.657562662103506e-12, -4.891495111735006e-15,  3.002898700332934e-16,  2.307759683757014e-18, -5.112750146892061e-20, -5.425720094836916e-22,  1.772157333428436e+00,
 -5.587996402459064e-03, -7.803667874225912e-05, -5.028339941985206e-07,  5.080912988398028e-09,  1.680161246402397e-10,  1.317987887436913e-12, -2.121510470238054e-14,
 -6.737596891514277e-16, -4.874654457054326e-18,  1.144530195271977e-19,  3.415471136997645e-21,  1.950423902261187e+00, -1.544138123680810e-03, -3.417191011523772e-05,
 -6.227565667950648e-07, -9.498359494035995e-09, -1.143153690461155e-10, -8.040576857401398e-13,  7.128480484483798e-15,  4.102207412987707e-16,  9.429484262148148e-18,
  1.478157923524066e-19,  1.454526801510539e-21,  2.668744650025845e-03, -3.103222807663732e-05,  2.700565403229097e-07, -2.093811787379466e-09,  1.505248509780242e-11,
 -1.070100383987324e-13,  6.674942998634200e-16, -5.147037312207100e-18,  3.622926693871708e-20,  3.532671139475389e-22,  1.693787872542477e-23,  2.243939923373986e-25,
  2.404840552772306e-02, -2.786532292943017e-04,  2.401923150698934e-06, -1.828943265649011e-08,  1.275871022840308e-10, -8.697580152293735e-13,  5.020693645838112e-15,
 -3.688206225795935e-17,  2.408428613802380e-19,  3.945958942664310e-21,  1.477432197169822e-22,  2.086260358135362e-24,  6.696647302491833e-02, -7.703402534148395e-04,
  6.508709219551560e-06, -4.766703515015607e-08,  3.105423887388966e-10, -1.909532367270877e-12,  8.778701651982788e-15, -5.545599405622618e-17,  2.723918981864984e-19,
  1.427785390124816e-20,  3.950571668803058e-22,  6.060911426592345e-24,  1.317416814402969e-01, -1.498176073591341e-03,  1.225405717318312e-05, -8.394023099546354e-08,
  4.798164783082751e-10, -2.322896603552505e-12,  3.699768788331722e-15,  1.511986005325426e-18, -2.580050293763224e-19,  3.342969942013944e-20,  7.748724159740414e-22,
  1.226593851562102e-23,  2.188535339752286e-01, -2.448037229297356e-03,  1.907294126339738e-05, -1.170488313418939e-07,  5.117973694459152e-10, -9.763578643883185e-13,
 -1.775804316720619e-14,  1.547006009433548e-16, -1.062240146690080e-18,  5.596589117881242e-20,  1.384142196994158e-21,  2.049931610870769e-23,  3.289380014086029e-01,
 -3.596160114999092e-03,  2.608631863572353e-05, -1.325068515252292e-07,  2.544765462388383e-10,  3.059227294414538e-12, -5.477346725753348e-14,  2.914631524847072e-16,
 -4.463417758902192e-19,  6.691117595853783e-20,  2.357917961511626e-21,  3.140212052017853e-23,  4.627671974052344e-01, -4.903000604115861e-03,  3.196495247172173e-05,
 -1.109505192328396e-07, -4.374335408830261e-10,  9.580311471374573e-12, -8.557858996268845e-14,  7.654312335067821e-17,  4.385641411270217e-18,  6.065174753424869e-20,
  3.579797732230023e-21,  4.948988637011323e-23,  6.211871176905309e-01, -6.302192815889065e-03,  3.472580149057953e-05, -2.905269240685069e-08, -1.607556132686312e-09,
  1.545173159117978e-11, -5.303642516788831e-14, -9.630721313086044e-16,  1.306956576603759e-17,  1.039126276283236e-19,  4.259937208120617e-21,  8.190965806931405e-23,
  8.049500172432901e-01, -7.680290277094199e-03,  3.146714502380934e-05,  1.345824849486133e-07, -2.966431848631324e-09,  1.183245485128339e-11,  1.264084991337171e-13,
 -2.629955814238461e-15,  9.675055934631372e-18,  3.914756629974006e-19,  4.253285142572075e-21,  1.099836951800093e-22,  1.014278427805602e+00, -8.838999500807404e-03,
  1.818938318582966e-05,  3.779199433041716e-07, -3.404834865690617e-09, -1.669783906114542e-11,  4.272379011566291e-13, -1.604984912173198e-15, -4.320225092775301e-17,
  7.927565312090058e-19,  1.188059108611992e-20,  7.166334025169523e-23,  1.247717397388724e+00, -9.426403742499759e-03, -9.500722179371514e-06,  6.108789758844448e-07,
 -3.898946590999449e-10, -7.321611963650758e-11,  2.300966224973011e-13,  9.007610753365177e-15, -7.323551312501129e-17, -8.393814158486007e-19,  3.157415532475113e-20,
  3.872175307255429e-22,  1.499010718907423e+00, -8.835011023156312e-03, -5.139352892753085e-05,  5.131998420243983e-07,  8.118903681989916e-09, -5.782461437810710e-11,
 -1.650523027400280e-12,  5.619372636077969e-15,  3.429297832248613e-16,  2.472076280590056e-20, -5.641119912527537e-20,  3.530228679352206e-22,  1.748520845974097e+00,
 -6.234778492116924e-03, -8.346712235875508e-05, -3.931856565980744e-07,  8.696296913116376e-09,  1.899603009388922e-10,  4.038288925546950e-13, -4.438853916593568e-14,
 -7.281837386269420e-16,  2.946702629626977e-18,  2.783479581755809e-19,  3.612390733701293e-21,  1.943649385224141e+00, -1.850169384360665e-03, -4.263541662090789e-05,
 -7.939702769133521e-07, -1.195231774016028e-08, -1.293767458081770e-10, -3.608115499532006e-13,  2.694787684089484e-14,  8.705751685806810e-16,  1.649143806385855e-17,
  1.985336909947666e-19,  4.861993911293199e-22,  2.548783085213841e-03, -2.896834167717099e-05,  2.463079025315005e-07, -1.869269662145287e-09,  1.306155493364271e-11,
 -9.257168254349142e-14,  5.425603752503475e-16, -3.634986159965281e-18,  6.336871553606314e-20,  1.207006801799270e-21,  2.462446395670127e-23,  6.526576264460109e-26,
  2.297088068606682e-02, -2.602823143336572e-04,  2.194144570644044e-06, -1.638098665092284e-08,  1.113184803320028e-10, -7.606064845783940e-13,  4.126386994309245e-15,
 -2.558995522010033e-17,  5.099706900791201e-19,  1.149483236658784e-20,  2.194014873924861e-22,  6.293287705876621e-25,  6.398574417627968e-02, -7.204769604563305e-04,
  5.965292272704495e-06, -4.299293764916183e-08,  2.743403992871054e-10, -1.715895211508618e-12,  7.449904333120873e-15, -3.496668181528701e-17,  1.131002813568571e-18,
  3.484924099257075e-20,  6.042000780830797e-22,  1.914804198445126e-24,  1.259388422371455e-01, -1.404045736610157e-03,  1.129131933384729e-05, -7.662999214703478e-08,
  4.342506785215052e-10, -2.233175699446963e-12,  3.856012502192200e-15,  1.950458853249007e-17,  1.625384203443724e-18,  7.410385607485781e-20,  1.200266931596463e-21,
  3.979007723684234e-24,  2.093578507998187e-01, -2.300934461593773e-03,  1.771677234656027e-05, -1.090380155999219e-07,  4.883487209880122e-10, -1.352126179773661e-12,
 -1.351331723678969e-14,  1.653250400081617e-16,  2.153591127782806e-18,  1.275580131802628e-19,  2.097195445865963e-21,  6.583678380823809e-24,  3.149607748080010e-01,
 -3.393756477403356e-03,  2.452246148047937e-05, -1.280143939119021e-07,  3.031801839751467e-10,  1.843923712575058e-12, -4.630534715590380e-14,  3.365212585857429e-16,
  3.973587447846078e-18,  1.860916603804798e-19,  3.448757404406047e-21,  9.813296186693095e-24,  4.436580523059580e-01, -4.652711749238382e-03,  3.059751689799828e-05,
 -1.165271501708411e-07, -2.660981216998484e-10,  7.571110759370119e-12, -8.092142363035405e-14,  2.835376965333273e-16,  9.639281746751785e-18,  2.429535079686595e-19,
  5.301321404897539e-21,  1.635411841104260e-23,  5.965311642927448e-01, -6.026195193032910e-03,  3.423279502780071e-05, -5.237873399535671e-08, -1.313170744482265e-09,
  1.390732772643272e-11, -7.331074486915548e-14, -4.453208417290134e-16,  2.069826137475093e-17,  3.397822699418407e-19,  7.188061380337860e-21,  3.300952496134441e-23,
  7.747414445277970e-01, -7.422881091950532e-03,  3.280563425094801e-05,  8.915337722616651e-08, -2.705168353673400e-09,  1.403200888977572e-11,  5.951154251019540e-14,
 -2.052655868418687e-15,  2.797121945286520e-17,  6.535527972210726e-19,  8.457654775510297e-21,  5.389904288915127e-23,  9.792408453848755e-01, -8.676292240278601e-03,
  2.238829472713829e-05,  3.213103305474398e-07, -3.640577673714872e-09, -7.109818824497806e-12,  3.679242740093561e-13, -2.432897248061204e-15, -5.356347024662130e-18,
  1.327685170503050e-18,  1.443257533886731e-20,  8.701507071567642e-24,  1.209905904171899e+00, -9.473302314140735e-03, -2.254732826157639e-06,  5.933068503766718e-07,
 -1.780017483378509e-09, -6.495050366056283e-11,  4.468722134609922e-13,  6.454283394213112e-15, -7.715236749445441e-17,  7.010473628070914e-19,  4.332943527997986e-20,
  9.279529906219017e-23,  1.462890366135223e+00, -9.219418841209309e-03, -4.450065251841724e-05,  6.317737523455136e-07,  6.585389377540057e-09, -9.432271423681239e-11,
 -1.342262583578694e-12,  1.621847321421230e-14,  3.093725415472742e-16, -1.662596621662972e-18, -2.270286647198597e-20,  1.054676408846204e-21,  1.722220097527102e+00,
 -6.918733112393830e-03, -8.722469046603866e-05, -2.235925498549308e-07,  1.247885918606724e-08,  1.822864721851351e-10, -1.132374366576038e-12, -6.356884460885487e-14,
 -3.891454347031783e-16,  1.656454893874337e-17,  3.772854890181861e-19,  1.307612931736210e-22,  1.935501348325169e+00, -2.232812500726986e-03, -5.339654143737992e-05,
 -1.006057392947403e-06, -1.454653226359842e-08, -1.252302750317621e-10,  8.839108588227145e-13,  6.582572635637148e-14,  1.603710783911461e-15,  2.383601144883588e-17,
  1.333897352466734e-19, -4.439912491098647e-21,  2.436713416177752e-03, -2.708418692321383e-05,  2.250716869519753e-07, -1.674418655149944e-09,  1.133347102519539e-11,
 -8.049550496662191e-14,  4.770513658424658e-16, -7.243354357890672e-19,  1.239620412192740e-19,  2.100504952572436e-21,  1.529606609304954e-23, -5.897221856646384e-25,
  2.196365405166247e-02, -2.434862887200899e-04,  2.007774160634943e-06, -1.471641214069832e-08,  9.705001952438807e-11, -6.678844062692625e-13,  3.712581860157123e-15,
 -9.756673505703986e-19,  1.076772855051385e-18,  1.946968296554905e-20,  1.361015521213146e-22, -5.327587156674499e-24,  6.119611553352754e-02, -6.747462090355554e-04,
  5.474611980095345e-06, -3.886856263198744e-08,  2.417578329208174e-10, -1.543430222559003e-12,  7.199340164178778e-15,  2.591880110001427e-17,  2.807876019285443e-18,
  5.686248445526438e-20,  3.739702078869552e-22, -1.496046887070423e-23,  1.204976588405457e-01, -1.317278665665708e-03,  1.041199072245744e-05, -7.003393489780093e-08,
  3.905988918460528e-10, -2.125403130423442e-12,  5.597397127645893e-15,  1.233886834275336e-16,  5.133040174143033e-18,  1.178870377289355e-19,  7.421439751015214e-22,
 -3.001502898834171e-23,  2.004294791042818e-01, -2.164303437845237e-03,  1.645425292087379e-05, -1.014566235683967e-07,  4.584983272612068e-10, -1.608285895404869e-12,
 -7.113788748947772e-15,  3.237518769084319e-16,  8.211875285615898e-18,  2.040235814774447e-19,  1.303366062323320e-21, -5.165479373474072e-23,  3.017684988313780e-01,
 -3.203636583732506e-03,  2.301642501490314e-05, -1.229253145012127e-07,  3.298126086076262e-10,  8.671781431040023e-13, -3.390612604138630e-14,  5.972088263066393e-16,
  1.308212964222851e-17,  3.119708128909733e-19,  2.181945159203375e-21, -8.156869453284012e-23,  4.255278216630341e-01, -4.413586457077506e-03,  2.917830993728773e-05,
 -1.196754196144305e-07, -1.332341959231602e-10,  5.768670750273558e-12, -6.705726017982173e-14,  7.725781839771284e-16,  2.210854502893324e-17,  4.382858851254450e-19,
  3.470168039289644e-21, -1.207577123222379e-22,  5.729696502691217e-01, -5.755183691450242e-03,  3.348704701368182e-05, -7.126261909129812e-08, -1.053186658577576e-09,
  1.208640004027413e-11, -7.426779099835068e-14,  4.685897667535939e-16,  3.806364833233087e-17,  6.107371724357417e-19,  4.902197679315546e-21, -1.677991435894411e-22,
  7.455805758269994e-01, -7.156870717379510e-03,  3.362524276005988e-05,  4.817598830866185e-08, -2.414277149823361e-09,  1.489586676781482e-11,  1.858145657075230e-14,
 -7.145987372901504e-16,  5.762106975094445e-17,  9.763246044213710e-19,  5.637035044933740e-21, -2.277166188765941e-22,  9.449169002816460e-01, -8.482761027911402e-03,
  2.589132205803987e-05,  2.623803847177270e-07, -3.699888377537994e-09,  9.316308194944179e-13,  3.053666515607336e-13, -1.731796038829336e-15,  5.222181777890852e-17,
  1.830138315279643e-18,  7.950068823206800e-21, -3.692084272752045e-22,  1.172020901941564e+00, -9.463440265482089e-03,  4.653244651539809e-06,  5.550740534490107e-07,
 -2.958439095325451e-09, -5.230061446673511e-11,  5.992053428934018e-13,  4.721803095757502e-15, -2.128118047041869e-17,  2.338675836361504e-18,  3.323268736292150e-20,
 -6.393652221380797e-22,  1.425351021606306e+00, -9.543461591814793e-03, -3.635462412936811e-05,  7.204718122357308e-07,  4.419106894540752e-09, -1.200282344250564e-10,
 -7.592684292683439e-13,  2.507560899357561e-14,  2.441261840547262e-16, -1.691120607857658e-18,  1.705729960943498e-20,  4.668766304603882e-22,  1.693137718342123e+00,
 -7.623604426559233e-03, -8.859600171310336e-05,  3.135992260878632e-09,  1.570408460012602e-08,  1.329965395909538e-10, -2.976720204316100e-12, -6.367169710659680e-14,
  4.623578673153057e-16,  2.975912430644062e-17,  2.266187537672554e-19, -7.462089663975944e-21,  1.925633470240372e+00, -2.712411534320845e-03, -6.694262946800995e-05,
 -1.256944721303032e-06, -1.665627710037620e-08, -7.528285147799395e-11,  3.578775186548739e-12,  1.313454813188121e-13,  2.483122338003379e-15,  2.208289143003435e-17,
 -3.186993170377672e-19, -1.790080251291297e-20,  2.331854755490277e-03, -2.536102112879207e-05,  2.060155669259288e-07, -1.505338231703448e-09,  9.839033898253070e-12,
 -6.876890809874118e-14,  5.241289624736188e-16,  4.500764202001782e-18,  2.014167609074033e-19,  1.864674266477941e-21, -3.614349969743397e-23, -1.824612931148523e-24,
  2.102075080473428e-02, -2.281050690757043e-04,  1.840069056949066e-06, -1.326556281190878e-08,  8.460410045065941e-11, -5.745459147432188e-13,  4.277027653156971e-15,
  4.511593187630733e-17,  1.792611703818270e-18,  1.723779738469591e-20, -3.299980568044630e-22, -1.655067256283144e-23,  5.858186029958909e-02, -6.327515290383137e-04,
  5.030410894801801e-06, -3.523754385887167e-08,  2.127366017122893e-10, -1.349830060554183e-12,  9.501495912734504e-15,  1.496364192392393e-16,  4.890301223904325e-18,
  5.019522530671941e-20, -9.404054742995263e-22, -4.674358657443036e-23,  1.153899592497252e-01, -1.237241301687041e-03,  9.607706000591569e-06, -6.411555792065852e-08,
  3.498271052959858e-10, -1.927001424639738e-12,  1.201100408857379e-14,  3.577135812079547e-16,  9.441302241219417e-18,  1.040962781981776e-19, -1.901833329568475e-21,
 -9.412817961454586e-23,  1.920279954822785e-01, -2.037417107945519e-03,  1.527970766241273e-05, -9.438354673334045e-08,  4.255426991522559e-10, -1.633536263743843e-12,
  6.772157674447845e-15,  7.079800280233258e-16,  1.568675167330833e-17,  1.813877678105065e-19, -3.243262168323902e-21, -1.618541603710506e-22,  2.893130010358882e-01,
 -3.025314826663196e-03,  2.157343025157468e-05, -1.175471042304934e-07,  3.406631806094934e-10,  3.121560960962286e-13, -9.568543036985823e-15,  1.202705803239865e-15,
  2.460923976783796e-17,  2.813650351690723e-19, -4.983761283215457e-21, -2.549656933537981e-22,  4.083311931969351e-01, -4.185932394123875e-03,  2.773296247235840e-05,
 -1.209626352570733e-07, -3.172483382633820e-11,  4.514034994233158e-12, -3.303693138378059e-14,  1.744929565925719e-15,  3.849075900793862e-17,  4.017563313668780e-19,
 -7.201452667902874e-21, -3.805238201989373e-22,  5.504789113414331e-01, -5.490976612556788e-03,  3.253847172027907e-05, -8.626941964476932e-08, -8.274191519910960e-10,
  1.062026328995668e-11, -4.063149339563478e-14,  2.056007671622547e-15,  6.090259141528486e-17,  5.581841808837386e-19, -1.031384832642088e-20, -5.474795188558386e-22,
  7.174938611626063e-01, -6.886190229176035e-03,  3.398148513876750e-05,  1.195249478682110e-08, -2.112302670162731e-09,  1.534347115596174e-11,  2.982721210552482e-14,
  1.707252638956707e-15,  9.312796753479381e-17,  8.568253498151480e-19, -1.561012234515901e-20, -7.729385788124298e-22,  9.114186425207241e-01, -8.264038624772475e-03,
  2.868656699706577e-05,  2.037171339448702e-07, -3.610656368261211e-09,  7.929457901223638e-12,  2.903739920916365e-13,  1.011525216622052e-15,  1.181294323773354e-16,
  1.621876732099580e-18, -2.397014786619789e-20, -1.133734944544276e-21,  1.134282544235535e+00, -9.400449648352918e-03,  1.099825759977382e-05,  5.001969336996271e-07,
 -3.849972636770776e-09, -3.632485971432192e-11,  7.359553043281924e-13,  5.570126031022140e-15,  7.708521348969488e-17,  2.772281258650867e-18, -2.056648066316440e-20,
 -1.868986108058773e-21,  1.386651706927317e+00, -9.798701568897459e-03, -2.736646487696907e-05,  7.712368506898520e-07,  1.897531508175262e-09, -1.289936265097743e-10,
  4.408396896567367e-14,  3.205378061746322e-14,  1.955252679519269e-16, -1.164780396391492e-18, -7.543918198155156e-21, -1.820058557967642e-21,  1.661232264599109e+00,
 -8.327776307320917e-03, -8.697712881895308e-05,  2.712362206619440e-07,  1.751820484148734e-08,  4.286723615817574e-11, -4.383316247345086e-12, -3.077643385952861e-14,
  1.595289639758427e-15,  2.983094864643759e-17, -2.773239700406704e-19, -1.478179794060207e-20,  1.913610713932063e+00, -3.312893641500374e-03, -8.365571508907777e-05,
 -1.529403539988908e-06, -1.695607747179179e-08,  6.432056234487169e-11,  8.460139963524969e-12,  2.191551776022818e-13,  2.801923517591291e-15, -1.278807874690728e-17,
 -1.596076585899580e-18, -4.111502535534904e-20,  2.233596160635404e-03, -2.378257643129544e-05,  1.888530319306031e-07, -1.358176637255151e-09,  8.603631518453436e-12,
 -5.390152672034602e-14,  7.474568053798839e-16,  1.155957970661497e-17,  2.194740579007461e-19, -1.586888446978449e-21, -1.453367661477497e-22, -3.013987218995749e-24,
  2.013679483598711e-02, -2.139990857666296e-04,  1.688644630646025e-06, -1.199769504119248e-08,  7.427746784114950e-11, -4.498133107192493e-13,  6.409141693391036e-15,
  1.082136990475874e-16,  1.966447315795517e-18, -1.416378496394947e-20, -1.321010219711003e-21, -2.736375154509313e-23,  5.612874180185062e-02, -5.941437424458160e-04,
  4.627137026830077e-06, -3.203558044101133e-08,  1.884569097724816e-10, -1.052534204114570e-12,  1.607565133192933e-14,  3.231246016869769e-16,  5.429323871791412e-18,
 -3.885879250583407e-20, -3.741663591540797e-21, -7.739234837182390e-23,  1.105899751804021e-01, -1.163364855239704e-03,  8.870692487707000e-06, -5.880692502376052e-08,
  3.151695179870509e-10, -1.481692351940101e-12,  2.666217084561132e-14,  6.957376926407010e-16,  1.062903960547861e-17, -7.561198609407871e-20, -7.546983927256617e-21,
 -1.560559194867218e-22,  1.841157894766096e-01, -1.919596497036542e-03,  1.418692869027565e-05, -8.781957249040431e-08,  3.964172581546220e-10, -1.171647051766294e-12,
  3.433492301642774e-14,  1.273275513489262e-15,  1.783434726162249e-17, -1.265812778147967e-19, -1.295359487396561e-20, -2.685636311572909e-22,  2.775481144489155e-01,
 -2.858276528146808e-03,  2.019576963584226e-05, -1.120458733842556e-07,  3.478302553229535e-10,  5.829834477661659e-13,  3.623645785282604e-14,  2.088395964418102e-15,
  2.792499532259110e-17, -1.987863345250905e-19, -2.028353925383498e-20, -4.233616230049087e-22,  3.920219944841982e-01, -3.969876855389798e-03,  2.628125671820539e-05,
 -1.207718068065588e-07,  5.535039624433256e-11,  4.457096783085837e-12,  3.462765836644150e-14,  3.114523637454038e-15,  4.295215545984604e-17, -3.057816465722431e-19,
 -3.006711677382565e-20, -6.334640094192325e-22,  5.290287672217352e-01, -5.235018916396921e-03,  3.143070765435145e-05, -9.783813248983319e-08, -6.189000172125714e-10,
  1.057056314022077e-11,  4.636403348499979e-14,  4.192093047594162e-15,  6.662253804713694e-17, -4.599409022149970e-19, -4.336519946713881e-20, -9.183949737211792e-22,
  6.904929324690817e-01, -6.614315493472706e-03,  3.393244637870205e-05, -1.932787798572461e-08, -1.792562936066755e-09,  1.699205452304706e-11,  1.226903394618131e-13,
  4.982914529036151e-15,  1.028867550010541e-16, -6.266673492526674e-19, -6.258450350570508e-20, -1.310911615024637e-21,  8.788355881911630e-01, -8.025735170908871e-03,
  3.079105572389559e-05,  1.476119126527104e-07, -3.377679491373194e-09,  1.571009221225152e-11,  3.784352867708500e-13,  5.427729773358374e-15,  1.448919084182123e-16,
 -5.887260279746892e-19, -9.228507305482066e-20, -1.899779046548670e-21,  1.096893189750000e+00, -9.289550018594927e-03,  1.661031706100072e-05,  4.338042128927896e-07,
 -4.385410410304911e-09, -1.642951268610555e-11,  9.392760462644313e-13,  9.290386847091663e-15,  1.386892766687634e-16, -8.122396819787160e-20, -1.306936394749118e-19,
 -3.018712943507864e-21,  1.347078123740146e+00, -9.980291922578963e-03, -1.801354601658429e-05,  7.813331784957390e-07, -5.955961711018048e-10, -1.165041742643198e-10,
  1.021306995260882e-12,  3.737360494496260e-14,  1.210965082366520e-16, -3.915174073165130e-18, -1.498014104747465e-19, -4.484799685145598e-21,  1.626556904155363e+00,
 -9.005782016773899e-03, -8.203129424894485e-05,  5.524929022747036e-07,  1.728739277513098e-08, -6.602150705045923e-11, -4.391831669465931e-12,  3.398954201119473e-14,
  2.305597473702706e-15,  5.087375886403797e-18, -9.565467207993048e-19, -1.425514419756131e-20,  1.898898134777493e+00, -4.059982279415557e-03, -1.035520363558130e-04,
 -1.777119343635583e-06, -1.309353934015056e-08,  3.501710694508938e-10,  1.567230131492975e-11,  2.852140158822057e-13,  7.012303219010786e-16, -1.184656551885949e-16,
 -3.767394047732984e-18, -5.073068871282842e-20,  2.141387486480240e-03, -2.233467946389138e-05,  1.733487758505420e-07, -1.228044889727573e-09,  7.734918193748566e-12,
 -3.138434203933015e-14,  1.151338598990679e-15,  1.628418659472704e-17,  2.552865309281733e-20, -1.002951471222260e-20, -2.697894257685640e-22, -1.981064638379719e-24,
  1.930693267852367e-02, -2.010462384292306e-04,  1.551536224030401e-06, -1.087172012322586e-08,  6.709805550075618e-11, -2.534183449716317e-13,  1.015689980398998e-14,
  1.503997729524470e-16,  2.132565993094504e-19, -9.088008303355510e-20, -2.451371783878495e-21, -1.800864085257024e-23,  5.382383677033802e-02, -5.586145408575643e-04,
  4.260184352146208e-06, -2.916431137053535e-08,  1.720889064123661e-10, -5.410089461537663e-13,  2.710010542407072e-14,  4.388510607519568e-16,  5.097949206509333e-19,
 -2.560854490073133e-19, -6.941218617994424e-21, -5.106464069400517e-23,  1.060740958964911e-01, -1.095138312411089e-03,  8.194420010696517e-06, -5.395925647145109e-08,
  2.936918138542986e-10, -5.745334964058906e-13,  5.000111749167196e-14,  9.204487703864874e-16,  8.055803047919979e-19, -5.138136652018641e-19, -1.400625430954410e-20,
 -1.033802896875981e-22,  1.766578703812930e-01, -1.810210006933249e-03,  1.317055733704242e-05, -8.160639896278235e-08,  3.844130153183523e-10,  1.363337216944375e-13,
  7.644253356591776e-14,  1.647641514400386e-15,  1.079281656519720e-18, -8.795321193221622e-19, -2.408708103797169e-20, -1.789173412588408e-22,  2.664297604145254e-01,
 -2.701992664421674e-03,  1.888520707877206e-05, -1.063185082942409e-07,  3.733936178816052e-10,  2.242209079656041e-12,  1.048154241544485e-13,  2.673964642546658e-15,
  1.634378491002564e-18, -1.380695677467416e-18, -3.787081882739485e-20, -2.842091034412588e-22,  3.765538392610699e-01, -3.765401567089519e-03,  2.484048389802921e-05,
 -1.190956885593737e-07,  1.605915940635875e-10,  6.470113325165685e-12,  1.374462544450893e-13,  4.025422635979537e-15,  3.509753910479101e-18, -2.063837258946945e-18,
 -5.645883025640348e-20, -4.296092388887013e-22,  5.085839314624137e-01, -4.988421151621189e-03,  3.020452685991482e-05, -1.059448702539454e-07, -3.857236037732761e-10,
  1.330349072048869e-11,  1.882478186134473e-13,  5.643993326519623e-15,  8.986215556488402e-18, -3.001701472675416e-18, -8.178628486446192e-20, -6.310739701746561e-22,
  6.645764680535318e-01, -6.344244109162691e-03,  3.354030356193912e-05, -4.507649637085746e-08, -1.410212697784297e-09,  2.194195555089579e-11,  3.008033066489012e-13,
  7.316330510198771e-15,  2.116647655523367e-17, -4.285737687057276e-18, -1.177033111468214e-19, -9.142755359949285e-22,  8.472352617535691e-01, -7.773212703597561e-03,
  3.225027137959046e-05,  9.663669971336558e-08, -2.957824494298098e-09,  2.709100667275885e-11,  5.860928940790541e-13,  8.846260278524618e-15,  3.681264163643162e-17,
 -5.956243627556450e-18, -1.723287404422956e-19, -1.339263305474129e-21,  1.060032017547822e+00, -9.137054252436988e-03,  2.138835473312658e-05,  3.623307667875580e-07,
 -4.465075884582361e-09,  9.690870798401098e-12,  1.252377426189727e-12,  1.240891327564656e-14,  9.281263670021692e-18, -7.964725037600535e-18, -2.577096122487031e-19,
 -2.162167729953131e-21,  1.306927671534613e+00, -1.008722494297228e-02, -8.766317342576532e-06,  7.548562783725290e-07, -2.594274926207352e-09, -7.917896472325130e-11,
  2.090239063003686e-12,  3.743030919060411e-14, -1.780340890343907e-16, -1.408749694855646e-17, -3.548845094607620e-19, -3.839204670976681e-21,  1.589269726705449e+00,
 -9.630945886280714e-03, -7.380267072248692e-05,  8.132737220588812e-07,  1.503276467012174e-08, -1.517904439516406e-10, -2.438712611898067e-12,  1.022400502150613e-13,
  1.673135494313675e-15, -4.287114990252219e-17, -1.347643754616098e-18, -1.374979890601746e-21,  1.880862169500026e+00, -4.976583248997693e-03, -1.258297389882505e-04,
 -1.907452529035339e-06, -1.689622715211862e-09,  8.195961133051210e-10,  2.310170521287616e-11,  2.066323312246661e-13, -6.702065060888618e-15, -2.996168264266839e-16,
 -4.684178447210470e-18,  3.439590588332481e-20,  2.054731938154572e-03, -2.100476870486650e-05,  1.593393556443365e-07, -1.107654689472823e-09,  7.419265801409852e-12,
  1.400705199099058e-15,  1.549006739871956e-15,  9.153172723840063e-18, -5.376125554128232e-19, -2.100451716421244e-20, -2.256344835355835e-22,  5.388040352459146e-24,
  1.852677142841231e-02, -1.891378326691700e-04,  1.427396489788995e-06, -9.824053471867132e-09,  6.479705765659329e-11,  3.792767492524079e-14,  1.383143246900804e-14,
  8.514971034062246e-17, -4.894810851754741e-18, -1.906270781728196e-19, -2.051946816583410e-21,  4.888118272652376e-23,  5.165539038098776e-02, -5.258867171072694e-04,
  3.926501773632182e-06, -2.645802926281159e-08,  1.687342229260693e-10,  2.481845217391845e-13,  3.783289654765749e-14,  2.517883371604058e-16, -1.391073541481579e-17,
 -5.386843241400824e-19, -5.820745378419717e-21,  1.379922115694054e-22,  1.018206646757002e-01, -1.032093519308165e-03,  7.574958871903879e-06, -4.927835438243133e-08,
  2.962169385488849e-10,  9.165731174612948e-13,  7.255150787661146e-14,  5.374882701583623e-16, -2.819326345514221e-17, -1.084603337831726e-18, -1.177943483293801e-20,
  2.772336931674043e-22,  1.696217059817689e-01, -1.708657163548147e-03,  1.222863914624882e-05, -7.531898265897480e-08,  4.090936872260177e-10,  2.492304676667464e-12,
  1.169195127210752e-13,  9.814864099554266e-16, -4.866009016088130e-17, -1.862611210811026e-18, -2.034261259747043e-20,  4.741288713959139e-22,  2.559160220104444e-01,
 -2.555908312526699e-03,  1.764722167846072e-05, -9.982390950038808e-08,  4.492542485936349e-10,  5.605353045781648e-12,  1.707741875602722e-13,  1.625543109764917e-15,
 -7.652881287076762e-17, -2.929659670284663e-18, -3.216599008008249e-20,  7.404653731634768e-22,  3.618807057918116e-01, -3.572339421381327e-03,  2.343170629717496e-05,
 -1.152742622101927e-07,  3.318260229562052e-10,  1.104919956513186e-11,  2.373193628348969e-13,  2.493014905748725e-15, -1.132894566126409e-16, -4.379580403783721e-18,
 -4.830447105993992e-20,  1.094864374984152e-21,  4.891053483489419e-01, -4.751953127208039e-03,  2.890587937911710e-05, -1.096896071206638e-07, -6.201485129752391e-11,
  1.962696797166035e-11,  3.293591491972104e-13,  3.541138706539267e-15, -1.607639298672827e-16, -6.367138281851640e-18, -7.058543231754094e-20,  1.568398479627736e-21,
  6.397322167400332e-01, -6.078432686134516e-03,  3.287994644699589e-05, -6.366806695017366e-08, -8.829196441302016e-10,  3.151965944492806e-11,  4.851774291817812e-13,
  4.572096898054994e-15, -2.220489828949452e-16, -9.143950864462445e-18, -1.025777423902769e-19,  2.217347497450027e-21,  8.166646849203530e-01, -7.511329937992449e-03,
  3.314654570650312e-05,  5.449392379226491e-08, -2.255611545641648e-09,  4.401499683551141e-11,  8.081247129528183e-13,  5.196873336306824e-15, -3.080229623434952e-16,
 -1.309321732574430e-17, -1.521083633256220e-19,  3.148369421373417e-21,  1.023851870250515e+00, -8.949744123210991e-03,  2.531967803198350e-05,  2.941878090901296e-07,
 -3.943765568452529e-09,  4.361147458255851e-11,  1.545963824331014e-12,  6.015698284758786e-15, -4.742087805681390e-16, -1.878384613210772e-17, -2.349972249639352e-19,
  4.521676461256332e-21,  1.266494749266368e+00, -1.012192896854595e-02,  4.092741843109489e-10,  7.037426554312960e-07, -3.596998322757460e-09, -1.765329226891314e-11,
  2.961350844490092e-12,  2.065698603847628e-14, -9.639373717920347e-16, -2.956804253923789e-17, -3.444236524370698e-19,  6.520551082464049e-21,  1.549632357930235e+00,
 -1.017848738393444e-02, -6.270784915938972e-05,  1.027391684839331e-06,  1.166741730563687e-08, -1.717108148370464e-10,  8.685708182067468e-13,  1.209517359118598e-13,
 -7.949287592339579e-16, -9.115899034184433e-17, -8.693393785236241e-19,  2.582505765848237e-20,  1.858798843726217e+00, -6.073789440404511e-03, -1.482388350724274e-04,
 -1.771834686866581e-06,  2.054352448148154e-08,  1.408109649947321e-09,  2.404020669426494e-11, -2.099763986652419e-13, -1.992662407077798e-14, -3.915292929056703e-16,
  2.017794960434278e-18,  2.959452403824033e-19,  1.973180979925473e-03, -1.978118773433977e-05,  1.467673497152229e-07, -9.866596965036385e-10,  7.826611445952600e-12,
  3.896303722623535e-14,  1.442163070172875e-15, -2.119522189148341e-17, -1.363265571130882e-18, -2.127027195912152e-20,  3.205324934927675e-22,  1.995859806129143e-23,
  1.779233692221711e-02, -1.781724132530584e-04,  1.315813083809379e-06, -8.762789436352617e-09,  6.894827552510603e-11,  3.740276621336986e-13,  1.291274208643114e-14,
 -1.908125502315192e-16, -1.239100609474118e-17, -1.931919281078071e-19,  2.906683693040042e-21,  1.812741016228373e-22,  4.961272243492856e-02, -4.956980874661736e-04,
  3.625531359838495e-06, -2.366798824025975e-08,  1.830082709729557e-10,  1.171350331929114e-12,  3.551298654426790e-14, -5.307352540131094e-16, -3.511006526802572e-17,
 -5.467839106287091e-19,  8.199616685977157e-21,  5.129612560697650e-22,  9.780986116401454e-02, -9.737766142212129e-04,  7.012975345744685e-06, -4.429482960228903e-08,
  3.324905049362706e-10,  2.697937501972091e-12,  6.864900715727438e-14, -1.044480785210215e-15, -7.092275583491867e-17, -1.103420475145399e-18,  1.646035921875226e-20,
  1.034535204834673e-21,  1.629771746834363e-01, -1.614327278584373e-03,  1.136623922392880e-05, -6.821691188169875e-08,  4.880380866368193e-10,  5.386009563062499e-12,
  1.117381282865701e-13, -1.744058702190890e-15, -1.221374947066712e-16, -1.900490991233375e-18,  2.813557928411594e-20,  1.779235480185881e-21,  2.459673433236302e-01,
 -2.419389870615653e-03,  1.649691148508783e-05, -9.150711780753522e-08,  6.041645921358493e-10,  9.869224547208607e-12,  1.649060112054829e-13, -2.662900834159005e-15,
 -1.922725666765415e-16, -2.999868760125702e-18,  4.394169876646113e-20,  2.800347628845248e-21,  3.479576467596707e-01, -3.390309792482980e-03,  2.208860817330973e-05,
 -1.078733184490055e-07,  6.126469692055431e-10,  1.701706081083271e-11,  2.307911639386833e-13, -3.884923501503962e-15, -2.866032268098640e-16, -4.503675258950435e-18,
  6.501298511700626e-20,  4.183321136005871e-21,  4.705517126756540e-01, -4.525955323063306e-03,  2.759805637462913e-05, -1.070916613605158e-07,  4.136423986657562e-10,
  2.791342756546892e-11,  3.192693792223975e-13, -5.610127247740856e-15, -4.132539370211550e-16, -6.583506371303202e-18,  9.315502812199480e-20,  6.070208627238675e-21,
  6.159394558446702e-01, -5.818637172442334e-03,  3.205409690746614e-05, -7.209400746565370e-08, -1.312373256358150e-10,  4.357129135309810e-11,  4.601820854834861e-13,
 -8.300188350804241e-15, -5.859048418326173e-16, -9.533428827269224e-18,  1.312607004373644e-19,  8.713214794361381e-21,  7.871530822922090e-01, -7.244081497332664e-03,
  3.361647156960129e-05,  2.652384928441827e-08, -1.177303330480252e-09,  6.357416352677825e-11,  7.386896807953793e-13, -1.295854501290242e-14, -8.328546669698876e-16,
 -1.385615542549089e-17,  1.840196237685519e-19,  1.260372893495553e-20,  9.884789565328165e-01, -8.734058871966325e-03,  2.850670762884234e-05,  2.400992156589590e-07,
 -2.698568362187106e-09,  8.034504473750610e-11,  1.390682247874254e-12, -2.118433566837625e-14, -1.237717762233077e-15, -2.037693398020116e-17,  2.610814702305108e-19,
  1.880351560246910e-20,  1.226059140194826e+00, -1.008912549947137e-02,  8.101224152598913e-06,  6.473483240399973e-07, -3.214960778315398e-09,  5.581590934093900e-11,
  2.933882070803468e-12, -2.896530601321865e-14, -2.152502695678774e-15, -3.142454817756651e-17,  4.242263577632009e-19,  2.985454276557291e-20,  1.507997316581208e+00,
 -1.062791011489587e-02, -4.936580400211734e-05,  1.188788322202876e-06,  8.687592897840277e-09, -1.163045378524104e-10,  3.374107478902953e-12,  3.920417006245318e-14,
 -4.323021952676907e-15, -9.139589261444236e-17,  1.171799854551948e-18,  6.837661294532503e-20,  1.832008153284882e+00, -7.336832088796943e-03, -1.665066996614679e-04,
 -1.189943311690374e-06,  5.357583245575552e-08,  1.830729573077196e-09,  7.399172628412827e-12, -1.026934631617920e-12, -2.866573965614780e-14,  2.946095704716889e-17,
  2.036873323096319e-17,  4.636465681467985e-19,  1.896332617655548e-03, -1.865220971171543e-05,  1.357098131947129e-07, -8.536175419106664e-10,  8.875912581933846e-12,
  6.095128454062121e-14,  1.514772838494312e-16, -7.267387038847259e-17, -1.657189474505402e-18,  1.199775305163827e-20,  1.364984406266075e-21,  2.221391702166131e-23,
  1.710006165485546e-02, -1.680471031710928e-04,  1.217572985289609e-06, -7.585628143029209e-09,  7.884056553142417e-11,  5.698134687427704e-13,  1.233138440673266e-15,
 -6.586941402453574e-16, -1.506342553384325e-17,  1.088504529434605e-19,  1.239827108791256e-20,  2.020194613143066e-22,  4.768621277881174e-02, -4.677780755319013e-04,
  3.359987643221420e-06, -2.051366897509580e-08,  2.130334402646139e-10,  1.703649166966924e-12,  2.697969682804140e-15, -1.856447458757958e-15, -4.269088967653352e-17,
  3.072903026282533e-19,  3.508947489576143e-20,  5.731785536175695e-22,  9.402372963707697e-02, -9.197039129499736e-04,  6.515387914890738e-06, -3.846875716769386e-08,
  3.990992489938815e-10,  3.708366301071259e-12,  3.135030045597320e-15, -3.722693189550901e-15, -8.628019875615130e-17,  6.172414391692997e-19,  7.078916309000781e-20,
  1.160733181557781e-21,  1.566967401622198e-01, -1.526530014016773e-03,  1.059844864004517e-05, -5.942608448647511e-08,  6.161107131204556e-10,  6.988777293632506e-12,
  4.321808884306780e-16, -6.358106390686711e-15, -1.487488119250476e-16,  1.054829220959035e-18,  1.218091665555610e-19,  2.007764845517262e-21,  2.365470332024757e-01,
 -2.291626369912877e-03,  1.546393429267224e-05, -8.008533787786706e-08,  8.311355470408306e-10,  1.215586752579189e-11, -8.062512203441611e-15, -9.933520980451895e-15,
 -2.346585447648280e-16,  1.644233140612538e-18,  1.918751750029171e-19,  3.184228131079017e-21,  3.347418984490372e-01, -3.218584650471951e-03,  2.086499895707268e-05,
 -9.510458100304603e-08,  9.936719783645865e-10,  2.009228869647990e-11, -2.486535729568079e-14, -1.474321758150868e-14, -3.510692219425316e-16,  2.421175085046648e-18,
  2.869810422846705e-19,  4.803913377834547e-21,  4.528815390402106e-01, -4.310154010833638e-03,  2.637222151398397e-05, -9.567364112142902e-08,  1.027298809789863e-09,
  3.201752136062633e-11, -5.008899703651714e-14, -2.131789902866107e-14, -5.091899101912661e-16,  3.440653439673959e-18,  4.170630456102622e-19,  7.058587151852855e-21,
  5.931723347164171e-01, -5.565631038760621e-03,  3.120675539082693e-05, -6.674300044059281e-08,  8.197097001214021e-10,  4.944775697160266e-11, -7.423654934244426e-14,
 -3.067883690111606e-14, -7.280143493937447e-16,  4.799226980124552e-18,  5.995206202731248e-19,  1.029252118570388e-20,  7.587163178319182e-01, -6.974094766486979e-03,
  3.386633686716938e-05,  1.863939404810095e-08,  2.248351180954592e-10,  7.355662524156045e-11, -5.510441202085639e-14, -4.493913752889034e-14, -1.044329371393581e-15,
  6.719419993028424e-18,  8.674640714061897e-19,  1.518357266677437e-20,  9.540162138684367e-01, -8.495081908183750e-03,  3.118697588031931e-05,  2.113009571400114e-07,
 -8.315520707234437e-10,  1.015666132677255e-10,  1.576378526984701e-13, -6.866685510651536e-14, -1.550868295619378e-15,  9.941956968242807e-18,  1.293182856968717e-18,
  2.323647783288222e-20,  1.185880362482129e+00, -9.994009739228812e-03,  1.560888262981083e-05,  6.082378136917060e-07, -1.504212583039726e-09,  1.078561457860984e-10,
  1.028645121068873e-12, -1.097147791349238e-13, -2.605440218112652e-15,  1.752571602551413e-17,  2.094194233536646e-18,  3.818649482816004e-20,  1.464789310897288e+00,
 -1.096355929109999e-02, -3.432857744961461e-05,  1.313638382341691e-06,  7.168196710698422e-09, -4.034424692198236e-11,  2.142236160780724e-12, -1.362202050527050e-13,
 -5.954661191853388e-15,  2.451738645241123e-17,  4.696846773735132e-18,  7.555234070946374e-20,  1.799930534985991e+00, -8.708640821837964e-03, -1.744342532049715e-04,
 -4.173105235876730e-08,  8.912898076128386e-08,  1.567098292739243e-09, -3.271268924214053e-11, -1.736078224591014e-12, -9.030024209144334e-15,  1.124409857430839e-15,
  2.900390953278900e-17, -2.743352971484611e-19,  1.823833788325785e-03, -1.760500051338574e-05,  1.263572272992054e-07, -7.024437430713615e-10,  9.938692940260465e-12,
  3.499060055789496e-14, -2.477021204831979e-15, -1.068436885133507e-16, -8.814915617384309e-20,  7.635099282385885e-20,  1.500646463882202e-21, -2.575716564645596e-23,
  1.644680928966159e-02, -1.586483430823298e-04,  1.134476109117053e-06, -6.238568772953759e-09,  8.878636013274093e-11,  3.310144116352627e-13, -2.260777444367816e-14,
 -9.694625303192281e-16, -8.131602696602012e-19,  6.936336929379617e-19,  1.364287971241615e-20, -2.337900178157473e-22,  4.586738636836942e-02, -4.418223712501786e-04,
  3.135356148269023e-06, -1.684924830410882e-08,  2.428276704969301e-10,  1.011174064379856e-12, -6.458806210935107e-14, -2.738159969269825e-15, -2.370211164541075e-18,
  1.963816762293512e-18,  3.868313541564769e-20, -6.607232226851922e-22,  9.044639704564762e-02, -8.693132888991165e-04,  6.094427767197091e-06, -3.152632399401404e-08,
  4.641285190608161e-10,  2.262898389196030e-12, -1.320594527217881e-13, -5.507549736113093e-15, -4.979347874907720e-18,  3.963692130552948e-18,  7.826019347281891e-20,
 -1.329991156502181e-21,  1.507559290885223e-01, -1.444417005390562e-03,  9.948909693453873e-06, -4.851894275066701e-08,  7.390729696421429e-10,  4.397185621998404e-12,
 -2.310275788089604e-13, -9.441591220614546e-15, -8.983163718981518e-18,  6.824107683636602e-18,  1.351920622853721e-19, -2.281552790180700e-21,  2.276222069747999e-01,
 -2.171515041647610e-03,  1.459039559354898e-05, -6.496131021426998e-08,  1.045846858417405e-09,  7.889440304540666e-12, -3.706063049394260e-13, -1.480961456308735e-14,
 -1.485192897063852e-17,  1.075471618769882e-17,  2.140480551021601e-19, -3.579552749891205e-21,  3.221945924990948e-01, -3.055929853721622e-03,  1.983185784775181e-05,
 -7.618480305568545e-08,  1.350209927794363e-09,  1.344056875820630e-11, -5.641436980328785e-13, -2.205713361841806e-14, -2.316220552935016e-17,  1.609086932174222e-17,
  3.222345138966585e-19, -5.326982879717656e-21,  4.360560640773637e-01, -4.103442039196957e-03,  2.534304990705007e-05, -7.441274593786047e-08,  1.598709365694442e-09,
  2.205342711020022e-11, -8.307085355126927e-13, -3.195188890932854e-14, -3.449344094670400e-17,  2.338693688581202e-17,  4.721364449566568e-19, -7.695190895344456e-21,
  5.714044572668567e-01, -5.318884796804764e-03,  3.051594945981468e-05, -4.614841261385842e-08,  1.709003931559807e-09,  3.506895720859429e-11, -1.196283185740099e-12,
 -4.590909603260561e-14, -4.913609657018428e-17,  3.361994224094893e-17,  6.856478320099650e-19, -1.098897869020301e-20,  7.313634470084470e-01, -6.702099268404690e-03,
  3.415858729071447e-05,  3.344363651926672e-08,  1.563214386764195e-09,  5.384845200459456e-11, -1.690998286036281e-12, -6.678808624389727e-14, -6.670060904694754e-17,
  4.870093491746145e-17,  1.004749684122717e-18, -1.581185245835975e-20,  9.205508182143091e-01, -8.235517749404822e-03,  3.370844612745787e-05,  2.137058244479212e-07,
  1.055735679736586e-09,  7.739952066239713e-11, -2.325352501300680e-12, -1.010355647270985e-13, -8.949121070524247e-17,  7.305621598309948e-17,  1.520057422431026e-18,
 -2.359202953377714e-20,  1.146199934135333e+00, -9.840185581949131e-03,  2.283562893831946e-05,  6.015684742002194e-07,  6.070685092983449e-10,  8.748844584655046e-11,
 -2.984823026160375e-12, -1.642664434827764e-13, -1.814429735820957e-16,  1.201780502633755e-16,  2.473577096551210e-18, -3.910872984459036e-20,  1.420488337979099e+00,
 -1.117323462629547e-02, -1.789877370427540e-05,  1.423007991929084e-06,  6.463840864065181e-09, -5.398802178234070e-11, -3.918585828487628e-12, -2.715642375127629e-13,
 -1.163655247439217e-15,  2.454697832161902e-16,  5.110021209309590e-18, -9.408979839509123e-20,  1.762338768283053e+00, -1.007985256219462e-02, -1.655279204636747e-04,
  1.575846032144507e-06,  1.086983813441128e-07,  2.103843963930830e-10, -7.794551759844286e-11, -1.201988082758139e-12,  4.562857381767548e-14,  1.627882894230115e-15,
 -1.351108819189705e-17, -1.543057639657878e-18,  1.755385970288604e-03, -1.662512941903889e-05,  1.188919328134169e-07, -5.420430888209318e-10,  9.812088273207197e-12,
 -5.780172609967778e-14, -5.031715769255240e-15, -5.764637293268335e-17,  3.267132861475045e-18,  9.201761150797807e-20, -1.188484545845730e-21, -8.740192709643409e-23,
  1.582992786508513e-02, -1.498475689215108e-04,  1.068235113014736e-06, -4.803460406191239e-09,  8.787621166887085e-11, -5.141355933079877e-13, -4.578825692426166e-14,
 -5.228278681259783e-16,  2.967630055089663e-17,  8.363195694886535e-19, -1.079558836355085e-20, -7.946737381328100e-22,  4.414907646698126e-02, -4.174813739167359e-04,
  2.956801592291569e-06, -1.291173600852663e-08,  2.416052765611142e-10, -1.393573984011441e-12, -1.300593755215788e-13, -1.475347612837562e-15,  8.399446239855849e-17,
  2.369854453502042e-18, -3.055653484665468e-20, -2.253654790764523e-21,  8.706443977311301e-02, -8.219428217472189e-04,  5.761463923887368e-06, -2.396129568737223e-08,
  4.657333279577542e-10, -2.625742349616325e-12, -2.637476235248301e-13, -2.963486501815283e-15,  1.694709634195328e-16,  4.789677414485524e-18, -6.165496606382527e-20,
 -4.560771670498691e-21,  1.451340457988592e-01, -1.366949320327982e-03,  9.439319650283665e-06, -3.637873374956276e-08,  7.510656705714032e-10, -4.095109085138780e-12,
 -4.567722873669295e-13, -5.071055775928638e-15,  2.916882708194145e-16,  8.261639606168436e-18, -1.061229608942157e-19, -7.882086458419624e-21,  2.191650687009104e-01,
 -2.057617383680858e-03,  1.391452621808465e-05, -4.758559672699365e-08,  1.082522796472737e-09, -5.629176704345291e-12, -7.246655830057435e-13, -7.936110851946095e-15,
  4.596967985296740e-16,  1.305236531928259e-17, -1.672557041005733e-19, -1.248759085074603e-20,  3.102829309118268e-01, -2.900549976610470e-03,  1.905318730720713e-05,
 -5.337048472529794e-08,  1.435711546197874e-09, -6.986316190162725e-12, -1.091370640192427e-12, -1.178798244391179e-14,  6.881936003069488e-16,  1.958952634038953e-17,
 -2.504200414761827e-19, -1.881698800349868e-20,  4.200427767767489e-01, -3.903809600578754e-03,  2.461380685515720e-05, -4.668345727572066e-08,  1.770996564871537e-09,
 -7.860097631543771e-12, -1.594172903438739e-12, -1.702434809267109e-14,  1.001897663369541e-15,  2.858031873410769e-17, -3.647248831730947e-19, -2.761172240970342e-20,
  5.506143771633653e-01, -5.076466434016064e-03,  3.014315793395701e-05, -1.517760219399101e-08,  2.023561253403329e-09, -7.972210063706189e-12, -2.292572624354985e-12,
 -2.438503472972747e-14,  1.445051483263607e-15,  4.126354563238121e-17, -5.268366924448302e-19, -4.020228760291385e-20,  7.051048154109266e-01, -6.426735652561088e-03,
  3.473667904016024e-05,  6.424868596236068e-08,  2.089348790715839e-09, -7.570714693472823e-12, -3.284438026712313e-12, -3.538537378117658e-14,  2.104382866593406e-15,
  6.001353125036859e-17, -7.710675605375798e-19, -5.921061727118842e-20,  8.881648539808051e-01, -7.955211873544601e-03,  3.641296105982850e-05,  2.390162495242128e-07,
  1.826423455292009e-09, -9.906932713986827e-12, -4.734040998870114e-12, -5.351401083699588e-14,  3.172711383319113e-15,  9.006720044538907e-17, -1.182262113025714e-18,
 -9.058026071062207e-20,  1.107250648366773e+00, -9.628360061916242e-03,  3.015368586337984e-05,  6.198688423740863e-07,  1.283588227964307e-09, -3.544335138455314e-11,
 -6.910074625846403e-12, -8.746995147087554e-14,  5.155053461290326e-15,  1.460294197761455e-16, -2.040741826560781e-18, -1.512196083021996e-19,  1.375619484256623e+00,
 -1.124649027034116e-02, -2.613273840723373e-07,  1.510136753685922e-06,  3.844839792142348e-09, -2.342035609749466e-10, -1.050514749761676e-11, -1.409847976420141e-13,
  9.610728594398397e-15,  2.867516868992028e-16, -4.764317962781847e-18, -3.168249605061522e-19,  1.719531953236223e+00, -1.129925245708907e-02, -1.363958426584351e-04,
  3.239196493480947e-06,  9.253116522456114e-08, -1.852103479528734e-09, -8.387196547535458e-11,  9.579996421106811e-13,  7.832738500709613e-14, -2.004464062631265e-16,
 -6.981615963683868e-17, -4.361614351686444e-19,  1.690750124419546e-03, -1.569747536317784e-05,  1.132690615356744e-07, -4.011610497719437e-10,  7.389953350569285e-12,
 -1.835698778133219e-13, -4.792445423184748e-15,  8.341164699246665e-17,  4.843479446596774e-18, -2.479085653434320e-20, -4.137146789973490e-21, -1.732448313625928e-23,
  1.524729649420146e-02, -1.415095369499705e-04,  1.018488706234049e-06, -3.542143666708649e-09,  6.607490652111447e-11, -1.658253234629519e-12, -4.359050992979070e-14,
  7.586526686701774e-16,  4.400328796927107e-17, -2.254388876183187e-19, -3.761261045100048e-20, -1.576120840808068e-22,  4.252556704563239e-02, -3.943842723552905e-04,
  2.823562478747560e-06, -9.446313018683952e-09,  1.810315525343389e-10, -4.641355953390637e-12, -1.237021378389067e-13,  2.152860289211064e-15,  1.245915993125664e-16,
 -6.395983566685994e-19, -1.066492126707530e-19, -4.474782159967021e-22,  8.386720150527233e-02, -7.768808876046394e-04,  5.515745139608349e-06, -1.728899892278903e-08,
  3.469478824922433e-10, -9.205941597854648e-12, -2.505138196070671e-13,  4.360313977306866e-15,  2.515121637350817e-16, -1.295508064689383e-18, -2.157680246936695e-19,
 -9.068584159412074e-22,  1.398147879884395e-01, -1.292986898450596e-03,  9.070165592551938e-06, -2.563873289012161e-08,  5.544936682122339e-10, -1.547791437948196e-11,
 -4.330873602133986e-13,  7.541587989933968e-15,  4.331546964015216e-16, -2.242796131538071e-18, -3.727412033535824e-19, -1.569358590898189e-21,  2.111540114620446e-01,
 -1.948305768373696e-03,  1.344052138073088e-05, -3.215161343233776e-08,  7.882001045772533e-10, -2.366382729234799e-11, -6.856384451977744e-13,  1.195346267303191e-14,
  6.830321555155854e-16, -3.564638604013627e-18, -5.901725011215313e-19, -2.487667564641869e-21,  2.989820510784990e-01, -2.750315962441700e-03,  1.854116626927632e-05,
 -3.300015933008530e-08,  1.022566738525416e-09, -3.410879073215161e-11, -1.030146320820488e-12,  1.800452671726993e-14,  1.022877931742465e-15, -5.402375676527516e-18,
 -8.885169929345612e-19, -3.742575087358792e-21,  4.048184580177190e-01, -3.708684195727457e-03,  2.421143734787799e-05, -2.177010100861955e-08,  1.214783881137062e-09,
 -4.742603221021540e-11, -1.500998974137725e-12,  2.636234944752341e-14,  1.488748200577979e-15, -8.008399734427720e-18, -1.302113188512442e-18, -5.457092785590581e-21,
  5.307903841745087e-01, -4.835531543113028e-03,  3.013996929959356e-05,  1.281164465366628e-08,  1.290618927481874e-09, -6.482007117055400e-11, -2.153462134685707e-12,
  3.817545772281925e-14,  2.143971929662703e-15, -1.187110019988571e-17, -1.892239205537456e-18, -7.814633931300688e-21,  6.799592933677140e-01, -6.145230350449406e-03,
  3.568882941694045e-05,  9.200655440093756e-08,  1.116032150117892e-09, -8.901939455808722e-11, -3.079307914675817e-12,  5.558668650738032e-14,  3.109655325375727e-15,
 -1.805108685338231e-17, -2.778842723109351e-18, -1.105792695873275e-20,  8.569454081230014e-01, -7.651995354951518e-03,  3.942913677439495e-05,  2.602113105923285e-07,
  4.409408534374984e-10, -1.275544906992878e-10, -4.433327888164551e-12,  8.314721633572833e-14,  4.647254972352161e-15, -2.926244954771927e-17, -4.231502326964161e-18,
 -1.528168544063036e-20,  1.069267122054728e+00, -9.357142730552810e-03,  3.766140750070572e-05,  6.252813640659862e-07, -1.168212733932555e-09, -2.080595355986872e-10,
 -6.445964559357393e-12,  1.332075232006338e-13,  7.424628068759304e-15, -5.438383308671630e-17, -7.003240921812170e-18, -1.840049702130908e-20,  1.330745002624096e+00,
 -1.117549727161299e-02,  1.802853858529257e-05,  1.519869966466501e-06, -3.467052385286543e-09, -4.913774019557799e-10, -9.009114921269508e-12,  2.692359955679623e-13,
  1.344357612593365e-14, -1.390644258733042e-16, -1.411575862367924e-17,  8.747343658409607e-21,  1.672429792941614e+00, -1.221322995708676e-02, -9.018254088339489e-05,
  4.327929775948168e-06,  3.889767647209832e-08, -3.285815820539624e-09, -2.684536300923383e-11,  2.824912418295624e-12,  2.420391985814305e-14, -2.502859065867831e-15,
 -2.496155964652255e-17,  2.231562814279534e-18,  1.629744464681847e-03, -1.480888301069372e-05,  1.090260476751818e-07, -3.174548678631034e-10,  2.840436304268143e-12,
 -2.549994553908835e-13, -6.436219194718366e-16,  1.935331780134035e-16,  1.220583438506558e-18, -1.583060262980961e-19, -1.444185167896893e-21,  1.268259057459640e-22,
  1.469730660401362e-02, -1.335165208275246e-04,  9.810738104632066e-07, -2.797220130710683e-09,  2.492174605389800e-11, -2.308143438904042e-12, -5.876866314885395e-15,
  1.758802899252686e-15,  1.106541082668628e-17, -1.439098228923456e-18, -1.311413499087930e-20,  1.153707251261181e-21,  4.099254809188077e-02, -3.722079249927642e-04,
  2.724074274872297e-06, -7.425692154422606e-09,  6.553033781567759e-11, -6.486639297006476e-12, -1.679972280736580e-14,  4.982881692060436e-15,  3.119271770631369e-17,
 -4.079762794204320e-18, -3.709208567497551e-20,  3.275247365293414e-21,  8.084672834501107e-02, -7.335062751638640e-04,  5.334600485759737e-06, -1.348071470708233e-08,
  1.168971507274250e-10, -1.294558513007534e-11, -3.435729460053291e-14,  1.006740585634437e-14,  6.252846150705412e-17, -8.251695550207105e-18, -7.473922237016306e-20,
  6.638916749774840e-21,  1.347861923496812e-01, -1.221532141675896e-03,  8.803947295267880e-06, -1.971003182106373e-08,  1.655052671221175e-10, -2.194784027155427e-11,
 -6.004164391560987e-14,  1.735568807256068e-14,  1.065977929708167e-16, -1.424946721495650e-17, -1.283297182995417e-19,  1.149982798624029e-20,  2.035736420292024e-01,
 -1.842151526824173e-03,  1.311226633680611e-05, -2.406557430655738e-08,  1.891536966106941e-10, -3.391217788350845e-11, -9.594877098873801e-14,  2.739658488987696e-14,
  1.657166145370940e-16, -2.255057317300666e-17, -2.013905234857907e-19,  1.827537971833513e-20,  2.882752525361313e-01, -2.603351968680442e-03,  1.821708628280223e-05,
 -2.320655826381275e-08,  1.514573516804245e-10, -4.950557159510691e-11, -1.447360830746680e-13,  4.106332833732095e-14,  2.432947601674643e-16, -3.392943384141308e-17,
 -2.992731793582190e-19,  2.765091074125672e-20,  3.903698070822425e-01, -3.515790427914621e-03,  2.403007833357988e-05, -1.153812598140954e-08, -8.792835895658765e-12,
 -6.982952842313944e-11, -2.091343709192306e-13,  5.978256481469737e-14,  3.442743419819353e-16, -4.968453181960869e-17, -4.300853252166816e-19,  4.079381743743605e-20,
  5.119318167477579e-01, -4.593560214513241e-03,  3.036703842307112e-05,  2.077497691533622e-08, -3.995245099242154e-10, -9.683270951043912e-11, -2.897512763931008e-13,
  8.600705349227631e-14,  4.755981840051433e-16, -7.212761729157010e-17, -6.060926157279134e-19,  5.982471181980518e-20,  6.559566071570969e-01, -5.855157837973999e-03,
  3.683018838102213e-05,  9.232087205246369e-08, -1.224516055713077e-09, -1.343553533066244e-10, -3.760956125470884e-13,  1.242929773267173e-13,  6.457472917046259e-16,
 -1.057609527833610e-16, -8.450859531711145e-19,  8.898311617599972e-20,  8.269879415026019e-01, -7.324178544397871e-03,  4.249393094928729e-05,  2.421466677726006e-07,
 -2.907044545062439e-09, -1.913291181829894e-10, -4.068790163487296e-13,  1.841260085555470e-13,  8.566300714718104e-16, -1.605826937862525e-16, -1.166006555050894e-18,
  1.380284249560348e-19,  1.032487730550344e+00, -9.026518459930920e-03,  4.489262786339440e-05,  5.666042412351523e-07, -6.450127052271124e-09, -2.948409863354569e-10,
 -5.285740317851861e-14,  2.891120705257853e-13,  1.031121413153006e-15, -2.636627716246155e-16, -1.526185883717371e-18,  2.348902350955010e-19,  1.286444587429672e+00,
 -1.096006550371432e-02,  3.558068259642931e-05,  1.377370615049323e-06, -1.462807717081598e-08, -5.768154584957788e-10,  3.082409859825947e-12,  5.223117705678652e-13,
  5.172607503770245e-17, -5.152896720188366e-16, -9.716194240430900e-19,  4.943800891726623e-19,  1.622471106523016e+00, -1.272145525386283e-02, -3.672035707309425e-05,
  4.416928783436227e-06, -2.676476188156887e-08, -2.978612568396006e-09,  4.933201810772695e-11,  2.163999874753856e-12, -5.960271953480050e-14, -1.544080983573951e-15,
  6.377970852822350e-17,  1.038293825183592e-18,  1.572229806928072e-03, -1.395152368676821e-05,  1.053233273350940e-07, -3.117943586328670e-10, -1.975166891475830e-12,
 -2.063875742333832e-13,  4.452016053677734e-15,  1.416628672992545e-16, -4.121626481147447e-18, -1.025880349974801e-19,  3.804364379320260e-21,  7.068528498022022e-23,
  1.417873009694031e-02, -1.257988924937508e-04,  9.483975696636987e-07, -2.758603175429223e-09, -1.866386475362076e-11, -1.867137823560378e-12,  4.041820701180325e-14,
  1.286464876659967e-15, -3.748161543702212e-17, -9.315561705963446e-19,  3.461061076637257e-20,  6.419780013118130e-22,  3.954674950257696e-02, -3.507637042208470e-04,
  2.637035350528701e-06, -7.389290381785411e-09, -5.693996992560605e-11, -5.241444179742664e-12,  1.142812811844905e-13,  3.639157641751224e-15, -1.063357928850197e-16,
 -2.634858310085621e-18,  9.827385532652507e-20,  1.816436055769152e-21,  7.799705148191508e-02, -6.914642380912507e-04,  5.175628630928445e-06, -1.363014713910762e-08,
 -1.274512281185212e-10, -1.044174077131681e-11,  2.302303031114803e-13,  7.334855385714561e-15, -2.153135741951246e-16, -5.309791834099420e-18,  1.992574434294631e-19,
  3.662276969129932e-21,  1.300394489155362e-01, -1.152034669938403e-03,  8.569030812116685e-06, -2.048595094565650e-08, -2.485647594415929e-10, -1.765569286967461e-11,
  3.954810938110301e-13,  1.260101346229319e-14, -3.723818486103494e-16, -9.120545611537943e-18,  3.452859500153207e-19,  6.294151808935602e-21,  1.964130084417143e-01,
 -1.738408148794241e-03,  1.281956800899583e-05, -2.632841527404766e-08, -4.501399635819263e-10, -2.717552782053941e-11,  6.217788585089735e-13,  1.979510820296949e-14,
 -5.904773204537779e-16, -1.432604711327114e-17,  5.490038106266986e-19,  9.891572473353070e-21,  2.781515141322482e-01, -2.458762517765935e-03,  1.792093642669087e-05,
 -2.850089617959658e-08, -7.806048257437860e-10, -3.945199974262165e-11,  9.283083265113490e-13,  2.947214767687683e-14, -8.906247041608222e-16, -2.133008415703868e-17,
  8.311796117669641e-19,  1.473102149622610e-20,  3.766901076452890e-01, -3.324211094242386e-03,  2.384536762855345e-05, -2.255433489616311e-08, -1.320709201358546e-09,
 -5.519782319079533e-11,  1.347617009128006e-12,  4.250786696668720e-14, -1.308158753114743e-15, -3.077320936508137e-17,  1.227188572389611e-18,  2.124162445350242e-20,
  4.940446818191030e-01, -4.349880937622911e-03,  3.051509360521865e-05, -6.700772391467119e-10, -2.212131067785580e-09, -7.560272154478152e-11,  1.938763381716489e-12,
  6.033315639669438e-14, -1.906153891033623e-15, -4.370820856410166e-17,  1.801229286401946e-18,  3.010081743542677e-20,  6.331315389093681e-01, -5.556619517960986e-03,
  3.773345637533044e-05,  5.192081899968920e-08, -3.723067986874826e-09, -1.028392432890157e-10,  2.820364996622394e-12,  8.540323644561683e-14, -2.807873525326255e-15,
 -6.194995353410892e-17,  2.681277675740457e-18,  4.238372439286183e-20,  7.983880398950512e-01, -6.973680352143876e-03,  4.499739132016528e-05,  1.662301639954480e-07,
 -6.420536080782934e-09, -1.414914458428098e-10,  4.269740719148624e-12,  1.221635630396743e-13, -4.288813425311745e-15, -8.876947992362140e-17,  4.159863261120458e-18,
  5.965015342126706e-20,  9.971399489320739e-01, -8.642369928957866e-03,  5.088528426924236e-05,  4.188657279652987e-07, -1.172177107179564e-08, -2.039239006493928e-10,
  7.111436242153078e-12,  1.786902548000315e-13, -7.109602398518148e-15, -1.297008562805347e-16,  7.060217955491714e-18,  8.233459776127425e-20,  1.243271585520914e+00,
 -1.061411178368171e-02,  5.035028215598803e-05,  1.059812214985599e-06, -2.430942202026160e-08, -3.435353014522519e-10,  1.512609694892274e-11,  2.600840575880035e-13,
 -1.436732821307565e-14, -1.786463986862037e-16,  1.463965456324392e-17,  8.114294483481516e-20,  1.571317829991603e+00, -1.281451028808650e-02,  1.200175522525641e-05,
  3.592693047756615e-06, -7.085294604478870e-08, -1.315637128120070e-09,  7.862054190638687e-11, -1.062111497497536e-13, -6.659070108475577e-14,  1.022994817611667e-15,
  4.532048504740552e-17, -1.509820372299418e-18,  1.518084071224041e-03, -1.312471094569559e-05,  1.012777350065513e-07, -3.695656878979360e-10, -4.800502164632314e-12,
 -6.911197657782556e-14,  6.246614014441744e-15, -1.689870777810772e-17, -4.786607390173492e-18,  6.158105434034232e-20,  3.250506068551495e-21, -8.221250189739090e-23,
  1.369048881801217e-02, -1.183516472565421e-04,  9.124679473798981e-07, -3.293748563370345e-09, -4.418278201888232e-11, -6.209572200657545e-13,  5.669530820764019e-14,
 -1.546699559452309e-16, -4.348093771955147e-17,  5.609592405389244e-19,  2.952367494663277e-20, -7.485629183697213e-22,  3.818529468878393e-02, -3.300444529494750e-04,
  2.539997137250068e-06, -8.963046227846381e-09, -1.283398150393421e-10, -1.718542654733869e-12,  1.602087112347459e-13, -4.446540745977261e-16, -1.230763280083577e-16,
  1.596970565574127e-18,  8.354815596541972e-20, -2.129109367630375e-21,  7.531290163483251e-02, -6.507617600744632e-04,  4.994065801084783e-06, -1.698568423131819e-08,
 -2.689517064888512e-10, -3.347033522927802e-12,  3.224201621739268e-13, -9.192517858932051e-16, -2.483204893791602e-16,  3.251160952580216e-18,  1.684981051378732e-19,
 -4.328358798688028e-21,  1.255667317830850e-01, -1.084556358080359e-03,  8.289617947926209e-06, -2.667933178397360e-08, -4.860550686419586e-10, -5.476501505562305e-12,
  5.529075309574208e-13, -1.637355532286941e-15, -4.272698895626043e-16,  5.665987403775553e-18,  2.897410964384998e-19, -7.528235662043027e-21,  1.896622682332269e-01,
 -1.637273082558979e-03,  1.244551647487681e-05, -3.692240610777003e-08, -8.119891727517648e-10, -8.048889446253813e-12,  8.669626056931611e-13, -2.701917462368582e-15,
 -6.727394940390240e-16,  9.077668475878496e-18,  4.557670849931355e-19, -1.202888873415749e-20,  2.686006654588158e-01, -2.317026362833268e-03,  1.748248265384926e-05,
 -4.587641207946703e-08, -1.298762051280677e-09, -1.095148810199393e-11,  1.288902666327847e-12, -4.296216594609736e-15, -1.004970933257397e-15,  1.388058419953073e-17,
  6.798684574965511e-19, -1.832809441055249e-20,  3.637724736316520e-01, -3.134960849097704e-03,  2.341806870744071e-05, -5.045001611032177e-08, -2.032294109453823e-09,
 -1.396056544885532e-11,  1.858516640215225e-12, -6.763154298705151e-15, -1.456694599732312e-15,  2.075987347904812e-17,  9.832414754179192e-19, -2.728313879659282e-20,
  4.771323711851381e-01, -4.106490243917707e-03,  3.025422036079412e-05, -4.519550607275339e-08, -3.161899526632525e-09, -1.661257810174755e-11,  2.644584127539551e-12,
 -1.079514548886075e-14, -2.083335494762101e-15,  3.098825984949041e-17,  1.400968236116953e-18, -4.046845655420857e-20,  6.115111404317255e-01, -5.253401537185670e-03,
  3.794487071630795e-05, -1.981309778197059e-08, -4.967619592193597e-09, -1.787872618288168e-11,  3.776489044290077e-12, -1.794995959452909e-14, -2.985428463188480e-15,
  4.717370830652433e-17,  1.994163305243122e-18, -6.105995308416239e-20,  7.712232123521278e-01, -6.607642907652994e-03,  4.630288029224913e-05,  4.728872964785467e-08,
 -8.036831119223403e-09, -1.521908820436471e-11,  5.530613618362085e-12, -3.232260052071091e-14, -4.363657320762256e-15,  7.548162678592053e-17,  2.875224597449922e-18,
 -9.638887598587663e-20,  9.634116415377498e-01, -8.218613702016238e-03,  5.468528597475918e-05,  2.091660513441401e-07, -1.383205446707293e-08, -1.214011051189041e-12,
  8.629281570404150e-12, -6.760291806056934e-14, -6.673307564357872e-15,  1.340843561175728e-16,  4.248173217020795e-18, -1.671456754725251e-19,  1.201691437094808e+00,
 -1.016743637448407e-02,  6.057591280635736e-05,  6.371250650971433e-07, -2.723906224622323e-08,  5.298414146634034e-11,  1.579487311482979e-11, -1.938708383402844e-13,
 -1.107515956804869e-14,  3.018991770440975e-16,  6.127118306753604e-18, -3.533430164356424e-19,  1.520495831627533e+00, -1.256667347369073e-02,  4.776391867271513e-05,
  2.346253812000280e-06, -7.960299953509101e-08,  3.379385796032363e-10,  5.305476915546592e-11, -1.434230754070502e-12, -1.381193905212405e-14,  1.480254013552860e-15,
 -1.763538152503947e-17, -9.128048935809472e-19,  1.467175666633868e-03, -1.233358803356262e-05,  9.636175330603151e-08, -4.497248057055784e-10, -4.799993515894318e-12,
  6.057221770129391e-14,  4.095570629990345e-15, -1.174568393558706e-16, -1.217457964992320e-18,  1.092672902299495e-19, -7.737762577746520e-22, -7.198720990258526e-23,
  1.323141376434514e-02, -1.112225026186871e-04,  8.685208908934038e-07, -4.030091566747205e-09, -4.405520539877295e-11,  5.555786907697332e-13,  3.713040920289404e-14,
 -1.067381484839645e-15, -1.102034409780009e-17,  9.928929031312444e-19, -7.072699602126651e-21, -6.537619088953810e-22,  3.690502456208752e-02, -3.101909159817747e-04,
  2.419633470027941e-06, -1.109391050804268e-08, -1.272757545645761e-10,  1.603187996107435e-12,  1.046806980703677e-13, -3.023809381622116e-15, -3.096730027123349e-17,
  2.812339134662344e-18, -2.027518176729591e-20, -1.849566177633291e-21,  7.278836206724915e-02, -6.117001603854694e-04,  4.763512079948962e-06, -2.142714527357216e-08,
 -2.646413172409935e-10,  3.328733286495350e-12,  2.099062994956007e-13, -6.109151023548998e-15, -6.175910416185460e-17,  5.680147493385079e-18, -4.171933492453749e-20,
 -3.728531884973146e-21,  1.213589206727395e-01, -1.019656049317737e-03,  7.921422756081458e-06, -3.465178557266996e-08, -4.735511889721521e-10,  5.948902970346424e-12,
  3.580974229254979e-13, -1.053314972372293e-14, -1.044879341164600e-16,  9.787995708871036e-18, -7.378448070982488e-20, -6.407164946952066e-21,  1.833091790342931e-01,
 -1.539707265549371e-03,  1.192268130016128e-05, -5.013614278951994e-08, -7.819467292518940e-10,  9.817356999291073e-12,  5.575109545003659e-13, -1.663427744351150e-14,
 -1.606640831280268e-16,  1.544238143450657e-17, -1.205097039016113e-19, -1.006876763564505e-20,  2.596082856723107e-01, -2.179728002653401e-03,  1.680524774414376e-05,
 -6.682697346041617e-08, -1.234474108055745e-09,  1.551132980345452e-11,  8.208726067121765e-13, -2.495809670709245e-14, -2.321764542852833e-16,  2.313081981729649e-17,
 -1.888318434178450e-19, -1.499805676891996e-20,  3.516026957855695e-01, -2.950596825922600e-03,  2.261582436569449e-05, -8.292504789224632e-08, -1.904307141583149e-09,
  2.400268525242995e-11,  1.168143725863084e-12, -3.641180819362284e-14, -3.209861659507274e-16,  3.364873612556286e-17, -2.911936449640612e-19, -2.164366533569126e-20,
  4.611858224263700e-01, -3.867489753378789e-03,  2.940796637084735e-05, -9.521741253513258e-08, -2.917384254265334e-09,  3.702123464012521e-11,  1.631914241832047e-12,
 -5.259294387758020e-14, -4.278638295961912e-16,  4.835870646935852e-17, -4.515223905228107e-19, -3.073449583642817e-20,  5.911012414510223e-01, -4.952141527737864e-03,
  3.723349222613733e-05, -9.757176650797582e-08, -4.507122560547820e-09,  5.791095450032316e-11,  2.268829020657388e-12, -7.656867486437270e-14, -5.475621071397681e-16,
  6.976990978231478e-17, -7.206394782456528e-19, -4.350148089069786e-20,  7.455340200482442e-01, -6.237114851749436e-03,  4.611068448259591e-05, -7.707705794122349e-08,
 -7.155872197931991e-09,  9.396436945422557e-11,  3.186763816086100e-12, -1.150302010585246e-13, -6.488586950766197e-16,  1.029974491066906e-16, -1.222984466604794e-18,
 -6.207518172231886e-20,  9.314228203446157e-01, -7.774787233204167e-03,  5.590038902233818e-05, -2.100464424625046e-09, -1.204132255742820e-08,  1.643107126526352e-10,
  4.620919602205108e-12, -1.857807637952608e-13, -5.733900892325138e-16,  1.600432815568948e-16, -2.336299810320478e-18, -8.969960714021200e-20,  1.162029128557697e+00,
 -9.659453351562026e-03,  6.570167632875831e-05,  2.279472430122254e-07, -2.298888168937251e-08,  3.378733323561554e-10,  7.205982819026087e-12, -3.559998980688308e-13,
  7.338676907163513e-16,  2.740799029830655e-16, -5.709214872260194e-18, -1.210068272475956e-19,  1.471142266955835e+00, -1.209270023659269e-02,  6.868600562838033e-05,
  1.181877745369240e-06, -6.343560550672266e-08,  1.122339946250159e-09,  1.342811670580714e-11, -1.211205377055957e-12,  2.117014733540248e-14,  4.084286864593125e-16,
 -2.667803722557034e-17,  3.321845118308631e-19,  1.419347238391055e-03, -1.158546534928287e-05,  9.055838305496350e-08, -5.126464904208758e-10, -2.880521297767528e-12,
  1.182944057262193e-13,  7.818827649713609e-16, -1.040867191029591e-16,  1.633547043367122e-18,  4.106990716582501e-20, -2.012419300986592e-21,  1.115660249844503e-23,
  1.280009833024523e-02, -1.044786558296926e-04,  8.164253891574413e-07, -4.608148130794175e-09, -2.652979064117236e-11,  1.078161664648225e-12,  7.034558107579327e-15,
 -9.447938626073046e-16,  1.486382773833028e-17,  3.722127661476601e-19, -1.829010013233227e-20,  1.023111644273842e-22,  3.570208717312484e-02, -2.913977984089549e-04,
  2.275707295183204e-06, -1.276699336530575e-08, -7.715929079037184e-11,  3.072300096571516e-12,  1.952095155045254e-14, -2.670200093094934e-15,  4.221836803693798e-17,
  1.048567413467273e-18, -5.182682761145937e-20,  2.952217612936798e-22,  7.041605608235652e-02, -5.746860083037991e-04,  4.483900746504685e-06, -2.491501444336140e-08,
 -1.619602206294323e-10,  6.261478292191922e-12,  3.816994367881025e-14, -5.374672530187628e-15,  8.564182852365758e-17,  2.099708837297979e-18, -1.047400614042994e-19,
  6.134755412178214e-22,  1.174042389794910e-01, -9.580651945904695e-04,  7.465297465176534e-06, -4.091301538147530e-08, -2.932005201088766e-10,  1.092045954341936e-11,
  6.277440735773196e-14, -9.217562967589081e-15,  1.484960292026223e-16,  3.573806379273430e-18, -1.806401318977033e-19,  1.099356548138854e-21,  1.773370268982154e-01,
 -1.446926201089869e-03,  1.125437065582777e-05, -6.051222004702555e-08, -4.905243341266580e-10,  1.749067264994663e-11,  9.280940606433687e-14, -1.445064162382510e-14,
  2.362726770926526e-16,  5.542781613143521e-18, -2.853080422772592e-19,  1.825370399934414e-21,  2.511527431088408e-01, -2.048800169613712e-03,  1.589785388900535e-05,
 -8.326990331043826e-08, -7.851912340208008e-10,  2.667849179340586e-11,  1.270375271884904e-13, -2.146824433840314e-14,  3.579600489749075e-16,  8.110024608308549e-18,
 -4.279530039435956e-19,  2.917397854681217e-21,  3.401551865371107e-01, -2.774123983478627e-03,  2.145771801450023e-05, -1.083845534090847e-07, -1.228143697769721e-09,
  3.964529377964757e-11,  1.626111255813391e-13, -3.090173743241652e-14,  5.287788365168892e-16,  1.142045099061530e-17, -6.236216090672998e-19,  4.603596491674650e-21,
  4.461781225947837e-01, -3.637522421040490e-03,  2.801522237058637e-05, -1.343537164304317e-07, -1.906375175860671e-09,  5.840116689259559e-11,  1.928723851822330e-13,
 -4.380887247451696e-14,  7.760954170247292e-16,  1.566821754449185e-17, -8.981104722637595e-19,  7.326486104519927e-21,  5.718794008200079e-01, -4.660079393884495e-03,
  3.567573434985038e-05, -1.581988051863915e-07, -2.979389200296093e-09,  8.670577939736542e-11,  2.013674609067604e-13, -6.208925648822171e-14,  1.153675366518786e-15,
  2.107456346547596e-17, -1.298899130777847e-18,  1.203053079110752e-20,  7.213149415260728e-01, -5.873711116065411e-03,  4.457126711758690e-05, -1.734787445188726e-07,
 -4.771798651172685e-09,  1.324387816876208e-10,  1.429534003627559e-13, -8.951771917291044e-14,  1.781702750896694e-15,  2.768387042638031e-17, -1.922429426949455e-18,
  2.102346401281406e-20,  9.012136620902239e-01, -7.330680000331906e-03,  5.484239178724216e-05, -1.641914743773757e-07, -8.058369381651392e-09,  2.152587190967949e-10,
 -1.306805661784292e-13, -1.348171954317000e-13,  2.987441906123448e-15,  3.399323635895781e-17, -2.992469114168367e-18,  4.119806206794349e-20,  1.124451772362849e+00,
 -9.128593110158267e-03,  6.647462071352592e-05, -7.965996292269935e-08, -1.526324892007137e-08,  4.012419602577873e-10, -1.297081219096415e-12, -2.236488504382309e-13,
  6.021372843733159e-15,  2.505288240960871e-17, -5.105023386419901e-18,  1.010666317352743e-19,  1.423938235337046e+00, -1.150196807651373e-02,  7.754824096190985e-05,
  3.539475846308049e-07, -4.008390172689446e-08,  1.121273737346069e-09, -1.005749793880744e-11, -4.689422821876519e-13,  2.114486584130385e-14, -2.769949542177048e-16,
 -7.241120957458004e-18,  4.002136284221037e-19,  1.374414483843460e-03, -1.088620682963494e-05,  8.420904815286897e-08, -5.396604486092266e-10, -5.286257578558102e-13,
  1.088431936626721e-13, -1.279665893426066e-15, -4.195227837704586e-17,  1.893571685779724e-18, -1.838479606352448e-20, -8.166823612134003e-22,  3.162931184481318e-23,
  1.239488829286699e-02, -9.817400184836881e-05,  7.593000551935566e-07, -4.858861625727419e-09, -5.108010307402021e-12,  9.909782816088281e-13, -1.166582697297970e-14,
 -3.800738606444820e-16,  1.719641233803210e-17, -1.676087832646984e-19, -7.402510810232153e-21,  2.874612846921857e-22,  3.457191360149960e-02, -2.738212216854199e-04,
  2.117144117670534e-06, -1.350687850149354e-08, -1.619618940949947e-11,  2.817874386526752e-12, -3.325944214973969e-14, -1.069967283494745e-15,  4.864972981450365e-17,
 -4.779368231720600e-19, -2.085959134577827e-20,  8.145151407947759e-22,  6.818711140248243e-02, -5.400451645017033e-04,  4.173541212432245e-06, -2.649973678922448e-08,
 -3.796149587437081e-11,  5.724379957534434e-12, -6.784420394050661e-14, -2.140430104868381e-15,  9.807560489809189e-17, -9.753806922643134e-19, -4.178924720987792e-20,
  1.645969144845725e-21,  1.136882230569603e-01, -9.003696517837433e-04,  6.953452568049153e-06, -4.385212223923451e-08, -7.752137587854245e-11,  9.939618041960261e-12,
 -1.184946247938131e-13, -3.638700983584857e-15,  1.685616059081214e-16, -1.705384852940311e-18, -7.117486220388985e-20,  2.838307128967025e-21,  1.717246400245571e-01,
 -1.359902487530193e-03,  1.049273433947399e-05, -6.556164411305322e-08, -1.462808354925650e-10,  1.582866504008591e-11, -1.902096635592712e-13, -5.636232168117283e-15,
  2.650097491278201e-16, -2.743240715816097e-18, -1.104946949467038e-19,  4.481756625713496e-21,  2.432053317714679e-01, -1.925787149759914e-03,  1.484088406063827e-05,
 -9.157747193430023e-08, -2.623889808834357e-10,  2.396941422599856e-11, -2.911140963510913e-13, -8.238180364314616e-15,  3.951458808634249e-16, -4.214308312427506e-18,
 -1.618977663031165e-19,  6.719534102961041e-21,  3.293933848422783e-01, -2.607938423330975e-03,  2.006534074602936e-05, -1.217360617449013e-07, -4.553845805692119e-10,
  3.529901965962658e-11, -4.348278691142638e-13, -1.159864637537410e-14,  5.714346178064527e-16, -6.335062322629311e-18, -2.284564758871787e-19,  9.784383433693814e-21,
  4.320654503706744e-01, -3.420279600061850e-03,  2.625831717169098e-05, -1.556221909777621e-07, -7.755399421955855e-10,  5.141171344874905e-11, -6.454897160942673e-13,
 -1.594434369306314e-14,  8.149490601767349e-16, -9.503080932393053e-18, -3.144567363342851e-19,  1.407211517175270e-20,  5.537969005162079e-01, -4.382946565471341e-03,
  3.354798230292907e-05, -1.922438418445969e-07, -1.314427304550890e-09,  7.522481712801824e-11, -9.695689121239713e-13, -2.160655404158831e-14,  1.163937548977103e-15,
 -1.451690163612637e-17, -4.253662240617144e-19,  2.030207651857901e-20,  6.985184829455400e-01, -5.526567104053992e-03,  4.211740947611358e-05, -2.291801878639791e-07,
 -2.256290637414041e-09,  1.126806760005862e-10, -1.507955988981071e-12, -2.903155306790681e-14,  1.695331513805384e-15, -2.320017221542714e-17, -5.652696777172505e-19,
  2.990489831130494e-20,  8.727532705779851e-01, -6.901693402158888e-03,  5.223698712539081e-05, -2.599363369183303e-07, -4.032377991398735e-09,  1.780333908356890e-10,
 -2.523723605936499e-12, -3.849779978050219e-14,  2.589254523321621e-15, -4.060662960294639e-17, -7.169317031219689e-19,  4.606946851022156e-20,  1.088989857859928e+00,
 -8.604181507409025e-03,  6.430789429570812e-05, -2.631034013968889e-07, -7.945281095286332e-09,  3.163911233139015e-10, -4.953744171172249e-12, -4.672782651584701e-14,
  4.381333156409121e-15, -8.611613752136531e-17, -6.647019848475184e-19,  7.643401445267253e-20,  1.379184761477971e+00, -1.087389338747985e-02,  7.863594300835491e-05,
 -1.243262856335631e-07, -2.078455753386568e-08,  7.883278228500029e-10, -1.544026319272797e-11,  2.113959545794192e-14,  9.355196829518262e-15, -3.079177887620779e-16,
  3.407625370526820e-18,  9.428817037801971e-20,  };
  constexpr double w[5376] = {  2.157467298688094e-01, -2.149689809613580e-03,  2.368129152577846e-05, -2.737340226577125e-07,  3.208943944678369e-09,
 -3.752480879495194e-11,  4.346835796430948e-13, -4.977523498639337e-15,  5.632688491460471e-17, -6.302897884568314e-19,  6.979034356357115e-21, -7.652135770194193e-23,
  2.086247345420539e-01, -4.302884016144076e-03,  9.402451875987304e-05, -1.880879699631911e-06,  3.494863482529493e-08, -6.135692647208846e-10,  1.029077874735242e-11,
 -1.661008422926312e-13,  2.593634845184754e-15, -3.933410747348967e-17,  5.811453111881288e-19, -8.383666918678551e-21,  1.953218825674791e-01, -8.108259105119326e-03,
  2.782868090968712e-04, -8.065227081746292e-06,  2.084452496095281e-07, -4.940963538283786e-09,  1.092689883447477e-10, -2.280596562936283e-12,  4.529460320491060e-14,
 -8.613239947430073e-16,  1.575707117869344e-17, -2.782842922992934e-19,  1.774612987366934e-01, -1.272624059441563e-02,  6.302134436039910e-04, -2.498497195274867e-05,
  8.524736972457676e-07, -2.598309826094512e-08,  7.237736328480372e-10, -1.870828356377731e-11,  4.536198782562240e-13, -1.040113118750764e-14,  2.269330914323873e-16,
 -4.732728779161480e-18,  1.569390888552968e-01, -1.722869920838346e-02,  1.168950496386447e-03, -6.072721605569917e-05,  2.633427045828933e-06, -9.972427739607294e-08,
  3.389683546564499e-09, -1.053336692248563e-10,  3.031740908312133e-12, -8.161133541640760e-14,  2.070096299317554e-15, -4.974691739950742e-17,  1.355213992606657e-01,
 -2.083212733981865e-02,  1.850654616788636e-03, -1.214647435893871e-04,  6.488707121978839e-06, -2.968977576755704e-07,  1.200454703247081e-08, -4.379755096277614e-10,
  1.463480349059376e-11, -4.528765228087306e-13,  1.309033047309387e-14, -3.556140790419693e-16,  1.145701549207505e-01, -2.303673053838269e-02,  2.571277815793166e-03,
 -2.063735622557564e-04,  1.321020533729493e-05, -7.126617512806622e-07,  3.352277002742333e-08, -1.406766713445125e-09,  5.353616190882511e-11, -1.870429629534228e-12,
  6.056579824775877e-14, -1.830011000876941e-15,  9.494078785074381e-02, -2.365146819970525e-02,  3.195672553360362e-03, -3.044227181248647e-04,  2.276171184013240e-05,
 -1.415478089256045e-06,  7.589368704269409e-08, -3.595102998109109e-09,  1.531252901763209e-10, -5.942165182803546e-12,  2.122553880032917e-13, -7.029948745111556e-15,
  7.702180451920315e-02, -2.273444121108670e-02,  3.595888671002838e-03, -3.954560560686583e-04,  3.371994160193758e-05, -2.366171517686251e-06,  1.418402056123712e-07,
 -7.451089271912186e-09,  3.493976319111830e-10, -1.483031091590826e-11,  5.760107432466841e-13, -2.062957244722217e-14,  6.085079194029078e-02, -2.049768163116640e-02,
  3.681880797229963e-03, -4.554997516495220e-04,  4.329461943660074e-05, -3.358640276398275e-06,  2.209399743321893e-07, -1.265226256957781e-08,  6.428932430641598e-10,
 -2.940879540368349e-11,  1.224926930429908e-12, -4.682633484774919e-14,  4.624504458026683e-02, -1.721761945605053e-02,  3.416353850575219e-03, -4.639931573673222e-04,
  4.809685713054364e-05, -4.043881823407833e-06,  2.866653590635571e-07, -1.759805939486598e-08,  9.540195597050103e-10, -4.635735604522821e-11,  2.042823212203857e-12,
 -8.230634102857463e-14,  3.290885483205063e-02, -1.317265304885567e-02,  2.814540403668853e-03, -4.100398051022860e-04,  4.538546035564024e-05, -4.056375353385657e-06,
  3.043877238579654e-07, -1.970314066622287e-08,  1.122234135015046e-09, -5.710287868072127e-11,  2.626945644210119e-12, -1.101692968471293e-13,  2.050490029934778e-02,
 -8.611597943441438e-03,  1.934668627361792e-03, -2.956998625763570e-04,  3.423759397797027e-05, -3.191566640969901e-06,  2.490843396807649e-07, -1.672472306544494e-08,
  9.856923542299230e-10, -5.177943623607584e-11,  2.453976987093267e-12, -1.058069957983455e-13,  8.704518446789501e-03, -3.751853231560194e-03,  8.663899426351412e-04,
 -1.359682854271588e-04,  1.614007627108082e-05, -1.540043679112918e-06,  1.228387497999197e-07, -8.417390245255479e-09,  5.055912791047436e-10, -2.703369059504206e-11,
  1.302556842452753e-12, -5.703286238438644e-14,  2.075072289125829e-01, -1.972559454065357e-03,  2.068149039799573e-05, -2.278720339872006e-07,  2.552452997498483e-09,
 -2.858036347454476e-11,  3.174854012911552e-13, -3.490177537198239e-15,  3.794573777434064e-17, -4.082042791131126e-19,  4.347359757971487e-21, -4.586796037633809e-23,
  1.927869356070791e-01, -3.632316723838430e-03,  7.444359577263953e-05, -1.407881309630999e-06,  2.481376886122654e-08, -4.141860687473494e-10,  6.617277355083777e-12,
 -1.019072322135748e-13,  1.520370086950763e-15, -2.205708683563827e-17,  3.120871695053719e-19, -4.315925204254316e-21,  1.667996666993747e-01, -6.219079940403731e-03,
  1.986623922773809e-04, -5.397263564728671e-06,  1.314171509468198e-07, -2.945831645043511e-09,  6.178878993743115e-11, -1.226104399621712e-12,  2.319975112056545e-14,
 -4.210546918081049e-16,  7.363318296620207e-18, -1.244935138957407e-19,  1.350229459209901e-01, -8.686079435703674e-03,  3.977154663252021e-04, -1.471136696123788e-05,
  4.712955225504333e-07, -1.355035992765684e-08,  3.573446604319445e-10, -8.770839496218184e-12,  2.024538512127990e-13, -4.428976428149262e-15,  9.237694579274487e-17,
 -1.845028570182674e-18,  1.029545540917352e-01, -1.020285606730995e-02,  6.392017995235250e-04, -3.096355711533950e-05,  1.260490541605347e-06, -4.503523386727717e-08,
  1.450043218285004e-09, -4.282529467765805e-11,  1.174810474587646e-12, -3.021649302765290e-14,  7.339342534834584e-16, -1.692318385007927e-17,  7.457552318846858e-02,
 -1.045926164561147e-02,  8.612882347785114e-04, -5.287522380571629e-05,  2.659157939003869e-06, -1.151170489217654e-07,  4.421599729687815e-09, -1.537647335862089e-10,
  4.911726374139554e-12, -1.456729080829673e-13,  4.044741076246667e-15, -1.057718810630935e-16,  5.181461013443099e-02, -9.633187495267965e-03,  1.004551683466880e-03,
 -7.589101126254632e-05,  4.598669919369863e-06, -2.359244038522012e-07,  1.059348360186201e-08, -4.257250764022994e-10,  1.555885387390155e-11, -5.233194470240772e-13,
  1.634954509613144e-14, -4.776049150667373e-16,  3.487576606556383e-02, -8.152520458738082e-03,  1.039994540904812e-03, -9.406595970109250e-05,  6.709149955592539e-06,
 -3.995372034329036e-07,  2.058178733280932e-08, -9.394006561281459e-10,  3.864878786485375e-11, -1.451941283075445e-12,  5.030893385956231e-14, -1.619289667596272e-15,
  2.294336643036793e-02, -6.450138017796326e-03,  9.747013704639642e-04, -1.028144404870486e-04,  8.438460245579442e-06, -5.717053085289519e-07,  3.317671926604398e-08,
 -1.691144416542812e-09,  7.711021341407606e-11, -3.188470684811464e-12,  1.208460720401862e-13, -4.230018374458707e-15,  1.483625479375879e-02, -4.827127038885602e-03,
  8.384043493732922e-04, -1.005453954141969e-04,  9.286753105079830e-06, -7.016389043506313e-07,  4.504076940434387e-08, -2.521450687639108e-09,  1.254475816644549e-10,
 -5.626836421758997e-12,  2.301043737504176e-13, -8.646917553838087e-15,  9.418859025061174e-03, -3.428696428173753e-03,  6.652061881215224e-04, -8.846378665876071e-05,
  8.992914936454344e-06, -7.425775336957781e-07,  5.176704053677591e-08, -3.128954807727511e-09,  1.671941095970380e-10, -8.015689173759590e-12,  3.488208527037634e-13,
 -1.389066441079174e-14,  5.774283901121808e-03, -2.281971788830548e-03,  4.812318105836769e-04, -6.924491661383311e-05,  7.576286479292710e-06, -6.698992287283143e-07,
  4.976913584271583e-08, -3.191782086227629e-09,  1.802284830960375e-10, -9.096905800665010e-12,  4.153503027218660e-13, -1.729704529691884e-14,  3.225010399878701e-03,
 -1.346489635430529e-03,  3.006380216355760e-04, -4.567944757595785e-05,  5.259667320922850e-06, -4.877519437801129e-07,  3.788163017076415e-08, -2.532009048857860e-09,
  1.485929718351235e-10, -7.774657165125856e-12,  3.670867312231575e-13, -1.577210260309860e-14,  1.285354111055018e-03, -5.529047514756476e-04,  1.274014209358044e-04,
 -1.995152322064891e-05,  2.363523672179818e-06, -2.250841938427082e-07,  1.792032869468436e-08, -1.225817534419869e-09,  7.350597023437730e-11, -3.924077812578372e-12,
  1.887863082959810e-13, -8.254151413365962e-15,  1.999315027333439e-01, -1.817392029217460e-03,  1.817445429534396e-05, -1.912225639545202e-07,  2.049782086600963e-09,
 -2.200867108486531e-11,  2.347691749791893e-13, -2.481054952238454e-15,  2.594959932719598e-17, -2.687236811078604e-19,  2.756067169436029e-21, -2.801707055768951e-23,
  1.793505309123955e-01, -3.098174861715485e-03,  5.968329880547514e-05, -1.069381714746891e-06,  1.791265415698738e-08, -2.847705167651580e-10,  4.340873182520288e-12,
 -6.387832756182537e-14,  9.118255498173873e-16, -1.267123896573732e-17,  1.719081023164732e-19, -2.281652688295737e-21,  1.447369093045329e-01, -4.857110565890430e-03,
  1.447994079740422e-04, -3.695674187639068e-06,  8.492977624770697e-08, -1.803191807322832e-09,  3.592334955737816e-11, -6.786033519520851e-13,  1.224706152631371e-14,
 -2.123623015155758e-16,  3.553462608848597e-18, -5.756502816602679e-20,  1.056811992309794e-01, -6.100244979307635e-03,  2.587895125835896e-04, -8.944710592079798e-06,
  2.693986843528889e-07, -7.314289609838180e-09,  1.827837649996674e-10, -4.263443869672075e-12,  9.374924232671924e-14, -1.957872099942156e-15,  3.905685081642185e-17,
 -7.473671571564480e-19,  7.042423627392527e-02, -6.290560796216818e-03,  3.640933894132211e-04, -1.645289294351502e-05,  6.289944988023410e-07, -2.120895079153921e-08,
  6.470012099343252e-10, -1.816293348186302e-11,  4.749107182381056e-13, -1.167053210381816e-14,  2.714142609607372e-16, -6.003925791152551e-18,  4.333064564869216e-02,
 -5.527349803563186e-03,  4.214175169284230e-04, -2.417860728240274e-05,  1.143932783459385e-06, -4.682254910260107e-08,  1.707306425443492e-09, -5.655541448138512e-11,
  1.725827108879492e-12, -4.902197309850141e-14,  1.306569479373683e-15, -3.286567804811913e-17,  2.497270800995847e-02, -4.274230112297800e-03,  4.153210352374436e-04,
 -2.947252561811284e-05,  1.687631957868298e-06, -8.220403701296624e-08,  3.518240724307824e-09, -1.352119541133247e-10,  4.739171007743028e-12, -1.532574741578259e-13,
  4.613851150614317e-15, -1.301447073063183e-16,  1.370778591093312e-02, -2.991753089502632e-03,  3.590225983020029e-04, -3.074087424322834e-05,  2.086110185262001e-06,
 -1.186900643485746e-07,  5.861988945145174e-09, -2.572895924499642e-10,  1.020603557613699e-11, -3.705357871878915e-13,  1.243341723968011e-14, -3.883033640871709e-16,
  7.295110367259899e-03, -1.943716844638322e-03,  2.795022456902403e-04, -2.818296192195700e-05,  2.219852472973982e-06, -1.448186013075742e-07,  8.115959363388127e-09,
 -4.005392408932119e-10,  1.772185906473400e-11, -7.124961906739373e-13,  2.630374812384551e-14, -8.983378448030864e-16,  3.827691203926817e-03, -1.197763264275039e-03,
  2.004140904196249e-04, -2.322310112457238e-05,  2.078391791409223e-06, -1.525360176861904e-07,  9.532880040596438e-09, -5.205766040613208e-10,  2.530911673615737e-11,
 -1.111083178167456e-12,  4.453439802418172e-14, -1.642482282130208e-15,  2.002850816316728e-03, -7.105987379335180e-04,  1.344070892526508e-04, -1.745646486847480e-05,
  1.736203375535716e-06, -1.405009661084364e-07,  9.613637166186595e-09, -5.711169760781527e-10,  3.003132956871690e-11, -1.418429064670680e-12,  6.087276140852694e-14,
 -2.392827502046375e-15,  1.041658600633700e-03, -4.056415228225502e-04,  8.427090600901562e-05, -1.195578812862174e-05,  1.291057973827307e-06, -1.127753881369115e-07,
  8.284489886461901e-09, -5.257652688061285e-10,  2.940057799746845e-11, -1.470591725024222e-12,  6.658025550323706e-14, -2.750978772814685e-15,  5.143370567997131e-04,
 -2.132917698754756e-04,  4.728674924109908e-05, -7.136469264524662e-06,  8.165290323347727e-07, -7.527435105364959e-08,  5.814132247785222e-09, -3.866255108077619e-10,
  2.258085582937750e-11, -1.176185811493626e-12,  5.530194623972725e-14, -2.366775581869320e-15,  1.907436355335029e-04, -8.186468059233816e-05,  1.881764143142193e-05,
 -2.939942129165555e-06,  3.474883719676878e-07, -3.302112656282856e-08,  2.623658498852164e-09, -1.791212247055535e-10,  1.072127250560207e-11, -5.713517940535538e-13,
  2.744200153620232e-14, -1.197935409135655e-15,  1.929389383514801e-01, -1.680649112196838e-03,  1.606296784138977e-05, -1.616633378577891e-07,  1.660775838511967e-09,
 -1.712224531766050e-11,  1.756095391971222e-13, -1.786368188275039e-15,  1.799561347609747e-17, -1.796177303719741e-19,  1.776088575368743e-21, -1.741762062003544e-23,
  1.678378419260790e-01, -2.667565422606826e-03,  4.839919062282546e-05, -8.232358020345234e-07,  1.312958729491324e-08, -1.991340031648903e-10,  2.900637513759300e-12,
 -4.084530366174621e-14,  5.585949652599839e-16, -7.444962365540568e-18,  9.696363773525722e-20, -1.236543067007562e-21,  1.273737335496439e-01, -3.855472397785624e-03,
  1.075502963491642e-04, -2.584209691693700e-06,  5.615058257319681e-08, -1.130949945442475e-09,  2.143007427572551e-11, -3.858680875925345e-13,  6.649970911738550e-15,
 -1.102850510016357e-16,  1.767469594717150e-18, -2.745855901168825e-20,  8.483157616845503e-02, -4.395747063404743e-03,  1.731620596190347e-04, -5.601496538737966e-06,
  1.588218144284305e-07, -4.076747911259058e-09,  9.663821647070394e-11, -2.143995491956741e-12,  4.494549761162049e-14, -8.966649366869475e-16,  1.711764205886663e-17,
 -3.139704294547995e-19,  5.004208814548829e-02, -4.023970493000936e-03,  2.153695554821469e-04, -9.085064726841769e-06,  3.263666975154574e-07, -1.039075255699515e-08,
  3.004375134050090e-10, -8.018974619398490e-12,  1.998885433317400e-13, -4.693742980959626e-15,  1.045223763886768e-16, -2.218089691451968e-18,  2.648722032137126e-02,
 -3.064419177694044e-03,  2.161603629322225e-04, -1.158492179713621e-05,  5.154188798658235e-07, -1.993878798555303e-08,  6.899046177004440e-10, -2.175915415345322e-11,
  6.340179313160076e-13, -1.723932824143551e-14,  4.408129637729830e-16, -1.065966211693442e-17,  1.279534368761302e-02, -2.007783063972021e-03,  1.813739862753324e-04,
 -1.206885357475185e-05,  6.520797739452123e-07, -3.011678420014519e-08,  1.227050082307031e-09, -4.504323549030940e-11,  1.512344187220751e-12, -4.696847129264097e-14,
  1.361027121907786e-15, -3.702979689750745e-17,  5.762441357303853e-03, -1.168383093113300e-03,  1.314429225373315e-04, -1.062463018969815e-05,  6.843490827995638e-07,
 -3.712004985519938e-08,  1.754236141261201e-09, -7.390562081771164e-11,  2.821702673634510e-12, -9.883968668273213e-14,  3.206825586855891e-15, -9.702964067239938e-17,
  2.480662664670208e-03, -6.231673990421479e-04,  8.492786681359959e-05, -8.158227258730657e-06,  6.148576603243756e-07, -3.852252093315247e-08,  2.079875218766392e-09,
 -9.915999366591332e-11,  4.248529058416300e-12, -1.657592929721643e-13,  5.949929154638722e-15, -1.979269736544926e-16,  1.048851901608398e-03, -3.141853873196325e-04,
  5.044480822412579e-05, -5.628627215819581e-06,  4.866300972081876e-07, -3.459860247078096e-08,  2.099902396926883e-09, -1.116081974909038e-10,  5.291359008957920e-12,
 -2.269184238612224e-13,  8.898798495441072e-15, -3.215750174020269e-16,  4.465662778329145e-04, -1.538648056903568e-04,  2.828077411624335e-05, -3.576775426573344e-06,
  3.471524116788099e-07, -2.746774917161476e-08,  1.840813885693256e-09, -1.072756909567259e-10,  5.541301084028050e-12, -2.574262387685647e-13,  1.087855958896814e-14,
 -4.215281491985294e-16,  1.938818179324897e-04, -7.422772654469831e-05,  1.515811579132632e-05, -2.116181562628227e-06,  2.251350526361076e-07, -1.939656911003376e-08,
  1.406824454815118e-09, -8.823457911953669e-11,  4.880301694842172e-12, -2.416370622307239e-13,  1.083686580480777e-14, -4.438339013154242e-16,  8.334319917211590e-05,
 -3.429127778229953e-05,  7.540633902093560e-06, -1.129246796066526e-06,  1.282732356591217e-07, -1.174599273467421e-08,  9.015950065666388e-10, -5.960605591684959e-11,
  3.462477759906807e-12, -1.794435156780822e-13,  8.397353196810093e-15, -3.578053424036708e-16,  2.846340631296711e-05, -1.218499111534424e-05,  2.793232480526216e-06,
 -4.352398611790703e-07,  5.131367410442355e-08, -4.864582817700781e-09,  3.856364619425308e-10, -2.627168458218482e-11,  1.569302915078356e-12, -8.346984495762952e-14,
  4.001750787703270e-15, -1.743883847463665e-16,  1.864616681759432e-01, -1.559478096631664e-03,  1.427183955382049e-05, -1.376173963377122e-07,  1.356738359402884e-09,
 -1.344828318384435e-11,  1.327709007916008e-13, -1.301624354389334e-15,  1.264319684264337e-17, -1.217827381173741e-19,  1.162144277852605e-21, -1.100906286415498e-23,
  1.578840728270144e-01, -2.316595871050470e-03,  3.966064381373476e-05, -6.415968500352312e-07,  9.759900836668590e-09, -1.414461451684498e-10,  1.971706446821977e-12,
 -2.660466507134195e-14,  3.490343043151629e-16, -4.467048664446069e-18,  5.591616509025315e-20, -6.859009933063396e-22,  1.134957525439677e-01, -3.105393252423754e-03,
  8.126524021053818e-05, -1.842091004888529e-06,  3.790996525225792e-08, -7.254668926576935e-10,  1.309322792002512e-11, -2.250024985513558e-13,  3.707117935326360e-15,
 -5.886359863894135e-17,  9.044168258389755e-19, -1.348666343219336e-20,  6.964720540278248e-02, -3.241591481386408e-03,  1.188590616410819e-04, -3.604438177983991e-06,
  9.634609607415719e-08, -2.340984237204870e-09,  5.269511810018447e-11, -1.113032930514964e-12,  2.226317192628547e-14, -4.245966943363507e-16,  7.761941459351613e-18,
 -1.365418992015207e-19,  3.680895565712404e-02, -2.661906418565941e-03,  1.319099920998398e-04, -5.199033741179877e-06,  1.756342335635525e-07, -5.283224635396444e-09,
  1.448628760814909e-10, -3.677817986646740e-12,  8.742724290491972e-14, -1.962180659679499e-15,  4.184582089626123e-17, -8.519874075214210e-19,  1.697190083774784e-02,
 -1.776363873356625e-03,  1.158954468467100e-04, -5.800997765221310e-06,  2.426652037737865e-07, -8.870739544664193e-09,  2.912033555762014e-10, -8.742422193513430e-12,
  2.431641370048978e-13, -6.326968959224329e-15,  1.551513440110371e-16, -3.605278916721885e-18,  6.949911813225265e-03, -9.959014532750655e-04,  8.348131140882902e-05,
 -5.201474102455209e-06,  2.648619563743588e-07, -1.158646363575617e-08,  4.489333849365268e-10, -1.572522087222800e-11,  5.052764695411815e-13, -1.505577423821291e-14,
  4.195328336930366e-16, -1.099909024510352e-17,  2.588129931330142e-03, -4.851106997147621e-04,  5.099798684426875e-05, -3.881551534487544e-06,  2.367906297627450e-07,
 -1.222083956788515e-08,  5.516321808639255e-10, -2.227006056037163e-11,  8.170769150770853e-13, -2.757211558709542e-14,  8.637017146194334e-16, -2.528305699217251e-17,
  9.032989547000062e-04, -2.127995760791594e-04,  2.737508593376414e-05, -2.496855769319179e-06,  1.795369302404370e-07, -1.077479395056198e-08,  5.591329714137565e-10,
 -2.569594368001014e-11,  1.063961734864984e-12, -4.020754977511608e-14,  1.400760414694836e-15, -4.530993734369767e-17,  3.063023177831337e-04, -8.738870985283299e-05,
  1.340730593824593e-05, -1.435373896077219e-06,  1.195041730404986e-07, -8.207935705130799e-09,  4.825641727098181e-10, -2.490433112327641e-11,  1.148922871369372e-12,
 -4.803534485641134e-14,  1.839625812228340e-15, -6.502408959386847e-17,  1.048711967009280e-04, -3.494719149157209e-05,  6.219367874734493e-06, -7.635342917933735e-07,
  7.211250303495029e-08, -5.564589612991366e-09,  3.644175575638598e-10, -2.078908201402369e-11,  1.052868860002476e-12, -4.802398439483662e-14,  1.995143097491570e-15,
 -7.609283272426787e-17,  3.738168057326615e-05, -1.403253334911462e-05,  2.809727594732000e-06, -3.851172736302574e-07,  4.028283280540697e-08, -3.416778092390256e-09,
  2.442716758988939e-10, -1.511780851842933e-11,  8.259288371060003e-13, -4.042903250180920e-14,  1.793985309750723e-15, -7.275294539777713e-17,  1.375332690941671e-05,
 -5.607231749864942e-06,  1.221458712339311e-06, -1.812965788101705e-07,  2.042375631471934e-08, -1.855883988924078e-09,  1.414420397592562e-10, -9.289389694527329e-12,
  5.363121055968341e-13, -2.763617457975688e-14,  1.286415704710745e-15, -5.454240885258923e-17,  4.274055625601865e-06, -1.824394560066875e-06,  4.169253012106256e-07,
 -6.477119870719488e-08,  7.614736668796057e-09, -7.199541547453153e-10,  5.692999376522853e-11, -3.869162767138757e-12,  2.306002035399720e-13, -1.223939106811118e-14,
  5.856079588856847e-16, -2.547118510540206e-17,  1.804421416830223e-01, -1.451559357297396e-03,  1.274233065262766e-05, -1.178997924961424e-07,  1.116905810610300e-09,
 -1.065716171627157e-11,  1.013893593047035e-13, -9.590840937580882e-16,  8.991102549134478e-18, -8.368691636789522e-20,  7.712298634256767e-22, -7.069450779803962e-24,
  1.492069822384588e-01, -2.027652141557005e-03,  3.281276487915444e-05, -5.057310465312239e-07,  7.349792148682040e-09, -1.019367512984414e-10,  1.361734604862112e-12,
 -1.762964289533810e-14,  2.221488645434662e-16, -2.733330630117941e-18,  3.292009760308318e-20, -3.888392207801318e-22,  1.022476558884070e-01, -2.534381707500163e-03,
  6.237068008398854e-05, -1.336456382203724e-06,  2.609449076672887e-08, -4.751597034982426e-10,  8.179163928482315e-12, -1.343122498542262e-13,  2.118023468876422e-15,
 -3.223399121192855e-17,  4.752783849331164e-19, -6.809066170213123e-21,  5.834145728346506e-02, -2.440685039537405e-03,  8.350674141746274e-05, -2.378053337954672e-06,
  6.001196074303298e-08, -1.382016865164623e-09,  2.957385052834019e-11, -5.953039603029211e-13,  1.137149696070583e-14, -2.074884101169554e-16,  3.634720941520350e-18,
 -6.136005866478265e-20,  2.793497773929071e-02, -1.815364134136078e-03,  8.342385071156467e-05, -3.075361255586229e-06,  9.778929317283760e-08, -2.781432684793880e-09,
  7.237061620809062e-11, -1.748643914519838e-12,  3.965893635330863e-14, -8.510442740664803e-16,  1.738651456513431e-17, -3.397012061480132e-19,  1.135797387472540e-02,
 -1.073016884723158e-03,  6.476022588499168e-05, -3.027680667424898e-06,  1.190969529614550e-07, -4.114271217366623e-09,  1.281372407298619e-10, -3.661558720669217e-12,
  9.720508371206848e-14, -2.419832879153473e-15,  5.689464996318191e-17, -1.270070100741198e-18,  3.989203792450416e-03, -5.201163129055135e-04,  4.039767432566855e-05,
 -2.354378688880957e-06,  1.128862128552942e-07, -4.673478328297128e-09,  1.720704025235708e-10, -5.746855573378414e-12,  1.765773848243144e-13, -5.044124636530080e-15,
  1.350535016640687e-16, -3.409201082081518e-18,  1.239913987195130e-03, -2.138078212876089e-04,  2.094267439320352e-05, -1.497532827566549e-06,  8.635621047105034e-08,
 -4.233365097566375e-09,  1.822260956785309e-10, -7.039023985300233e-12,  2.478218933205499e-13, -8.045175757509704e-15,  2.429965415741366e-16, -6.872898436081639e-18,
  3.524530595862011e-04, -7.743769515929227e-05,  9.366046421635231e-06, -8.085080497707475e-07,  5.531168122543747e-08, -3.171822145993124e-09,  1.578397140694891e-10,
 -6.977632649532249e-12,  2.786640134664443e-13, -1.018138267038569e-14,  3.436608731002351e-16, -1.079141459338486e-17,  9.562442921466154e-05, -2.584274681568556e-05,
  3.772111222307450e-06, -3.860484710722894e-07,  3.085181218191636e-08, -2.041142441426798e-09,  1.159428162910399e-10, -5.796307068125721e-12,  2.596315054493574e-13,
 -1.056108718987323e-14,  3.942370807380632e-16, -1.360575587912965e-17,  2.605819242663831e-05, -8.359986594147776e-06,  1.434796984132918e-06, -1.703907495902986e-07,
  1.561162251006892e-08, -1.171649292168835e-09,  7.479394751092580e-11, -4.167425923587460e-12,  2.065093041842386e-13, -9.230876463200046e-15,  3.763536509261182e-16,
 -1.410514959029155e-17,  7.499046378274091e-06, -2.751491770948119e-06,  5.386215925094380e-07, -7.229470876258313e-08,  7.417598329374064e-09, -6.181176948526032e-10,
  4.347639267505306e-11, -2.650618076777786e-12,  1.428152432861375e-13, -6.901527361295814e-15,  3.026173465470519e-16, -1.213738038590794e-17,  2.317627216063802e-06,
 -9.348405178463627e-07,  2.014261480500833e-07, -2.959078787683995e-08,  3.301870021487074e-09, -2.974051165406072e-10,  2.248230660256465e-11, -1.465479333281769e-12,
  8.401967226357249e-14, -4.301603550182943e-15,  1.990310771501121e-16, -8.391645291141806e-18,  6.463596539458897e-07, -2.749862589455130e-07,  6.262135502310320e-08,
 -9.695611875534155e-09,  1.136208453646747e-09, -1.071027080202646e-10,  8.445163619433846e-12, -5.724383719718046e-13,  3.403173744228639e-14, -1.802019432737000e-15,
  8.602791598167447e-17, -3.733961321571788e-18,  1.748312297243703e-01, -1.354991486723154e-03,  1.142812702899591e-05, -1.016108129056968e-07,  9.260777620610707e-10,
 -8.516142543656967e-12,  7.814927786080814e-14, -7.141769650210678e-16,  6.466202505743447e-18, -5.825167441704493e-20,  5.183606704735503e-22, -4.612814659016531e-24,
  1.415855739715748e-01, -1.787570154879915e-03,  2.738761991339584e-05, -4.028230138408526e-07,  5.601685702215172e-09, -7.445798932870483e-11,  9.544697878550149e-13,
 -1.187114438968622e-14,  1.438448521590580e-16, -1.703440478995519e-18,  1.976102057340247e-20, -2.249839092371609e-22,  9.301563748133941e-02, -2.093127253128443e-03,
  4.855602839437049e-05, -9.854578648934730e-07,  1.828514242393018e-08, -3.172841223015377e-10,  5.215966361149693e-12, -8.194768922066651e-14,  1.238249028684112e-15,
 -1.808080390859930e-17,  2.560866183625178e-19, -3.527947382273842e-21,  4.975465251938751e-02, -1.872329942507013e-03,  5.993015941185376e-05, -1.605427355389605e-06,
  3.830569405920259e-08, -8.371626557216951e-10,  1.705000562859161e-11, -3.274105272989140e-13,  5.978191631150891e-15, -1.044456985427502e-16,  1.754580438895268e-18,
 -2.844430312812845e-20,  2.180723517107098e-02, -1.272679933705494e-03,  5.433725495841331e-05, -1.875778122908591e-06,  5.620008263801286e-08, -1.512821743324404e-09,
  3.738069133944354e-11, -8.601493071579664e-13,  1.862238805835572e-14, -3.822661801641252e-16,  7.484102250602999e-18, -1.403659259492333e-19,  7.910637781596260e-03,
 -6.731880307666419e-04,  3.760520199682091e-05, -1.642751754573857e-06,  6.078459981889094e-08, -1.984896036557830e-09,  5.866029421587008e-11, -1.595643226376435e-12,
  4.043240081336544e-14, -9.629724725298906e-16,  2.170642757179400e-17, -4.654310141855620e-19,  2.411704284265855e-03, -2.851174013005765e-04,  2.049865582082198e-05,
 -1.116631656057101e-06,  5.038311532857057e-08, -1.972911910520159e-09,  6.898672833099149e-11, -2.195587829090712e-12,  6.447212212525834e-14, -1.764550517290562e-15,
  4.536663822568545e-17, -1.101931484845780e-18,  6.322351986782941e-04, -9.982739056162318e-05,  9.087549699408287e-06, -6.093066947113100e-07,  3.315853948918491e-08,
 -1.541701590774781e-09,  6.319808923999135e-11, -2.332752237334995e-12,  7.871104699299634e-14, -2.455220561366190e-15,  7.141819447125050e-17, -1.949465875446053e-18,
  1.473509219975192e-04, -3.002569534324411e-05,  3.401441800925018e-06, -2.770482224509493e-07,  1.798554865210244e-08, -9.831960969813554e-10,  4.681931719527576e-11,
 -1.987020640207890e-12,  7.639814994217796e-14, -2.693972475484742e-15,  8.795508912708682e-17, -2.676934710608249e-18,  3.199401973751648e-05, -8.143012534490798e-06,
  1.125750095373749e-06, -1.097254447831657e-07,  8.389878373055407e-09, -5.331311285978771e-10,  2.918214327874012e-11, -1.409844275539308e-12,  6.117934611186291e-14,
 -2.416250443523677e-15,  8.774730202014936e-17, -2.951438727153671e-18,  6.882156158286171e-06, -2.114751573047782e-06,  3.485043650183700e-07, -3.988511014801987e-08,
  3.533491395643965e-09, -2.571621250306465e-10,  1.595991822656670e-11, -8.664715875618074e-13,  4.191837861460027e-14, -1.832523301507285e-15,  7.318623249138160e-17,
 -2.690744463000850e-18,  1.572834740993892e-06, -5.620001495622346e-07,  1.071990588776281e-07, -1.404835443943194e-08,  1.410175092539519e-09, -1.151791162695164e-10,
  7.953644352550454e-12, -4.767706526843097e-13,  2.529054221552673e-14, -1.204654529017847e-15,  5.212022096249440e-17, -2.064721928722693e-18,  4.000956498204661e-07,
 -1.593662961015789e-07,  3.390294107322037e-08, -4.921494865142253e-09,  5.431502038565489e-10, -4.842938020552014e-11,  3.627025244065487e-12, -2.343981555693033e-13,
  1.333229594903371e-14, -6.775802728609028e-16,  3.113794572431466e-17, -1.304584207921675e-18,  9.854270495708248e-08, -4.176368265392026e-08,  9.472380991894046e-09,
 -1.460946581893269e-09,  1.705840765883470e-10, -1.602514754412068e-11,  1.259578085338684e-12, -8.512331901813336e-14,  5.046461456945839e-15, -2.665132929961790e-16,
  1.269178652706410e-17, -5.495935510001637e-19,  1.695867307304610e-01, -1.268204210943841e-03,  1.029239257178196e-05, -8.806064664532065e-08,  7.730040934497223e-10,
 -6.858945399288296e-12,  6.076031061893818e-14, -5.371752731193867e-16,  4.698163703795218e-18, -4.106940629557338e-20,  3.519633666224404e-22, -3.068514645433704e-24,
  1.348448920995617e-01, -1.586386657040048e-03,  2.304610723481902e-05, -3.239690232908506e-07,  4.317141056867824e-09, -5.507092801545548e-11,  6.782863335574216e-13,
 -8.114164171899551e-15,  9.465265264725331e-17, -1.079998232735012e-18,  1.207964195082851e-20, -1.327012931906602e-22,  8.535156708531566e-02, -1.747449097742860e-03,
  3.829657919209670e-05, -7.375660755310071e-07,  1.302625790915573e-08, -2.156954447171529e-10,  3.390827970137871e-12, -5.102912169359537e-14,  7.396500006396602e-16,
 -1.037306175214090e-17,  1.412637024525545e-19, -1.873042698311064e-21,  4.311539933736574e-02, -1.460672107500240e-03,  4.385420093688852e-05, -1.107017276387936e-06,
  2.501043938603749e-08, -5.193996552329045e-10,  1.007952745467267e-11, -1.848404989363682e-13,  3.229099020934952e-15, -5.406496722069993e-17,  8.716456171475408e-19,
 -1.357913355964300e-20,  1.746225613164183e-02, -9.147518646191691e-04,  3.636278279282104e-05, -1.177005680055510e-06,  3.326491363366520e-08, -8.482707966385865e-10,
  1.992170510915562e-11, -4.368752629159614e-13,  9.034727626418112e-15, -1.775010275765314e-16,  3.331883998527654e-18, -6.000932911896379e-20,  5.714628612410781e-03,
 -4.372511578934968e-04,  2.262928852920838e-05, -9.242070383659416e-07,  3.218490968770308e-08, -9.938841652214953e-10,  2.788133721698461e-11, -7.221318009862523e-13,
  1.746858797321258e-14, -3.980854562546958e-16,  8.603151238297424e-18, -1.771850449633635e-19,  1.530369866329583e-03, -1.635256555446278e-04,  1.087669486673216e-05,
 -5.535617765307692e-07,  2.349692238472227e-08, -8.699970670599793e-10,  2.888147321741532e-11, -8.755967601637837e-13,  2.456208423009002e-14, -6.437946982182015e-16,
  1.588644131441230e-17, -3.711040013057003e-19,  3.422235432671783e-04, -4.925514257740742e-05,  4.158215841028632e-06, -2.609999839998698e-07,  1.338611979017188e-08,
 -5.895796062571462e-10,  2.298940281123157e-11, -8.099864812548155e-13,  2.616494931784658e-14, -7.833886733610752e-16,  2.192295028344998e-17, -5.769339886549471e-19,
  6.595689732828427e-05, -1.239530465394387e-05,  1.310512438952717e-06, -1.004324254621821e-07,  6.172138930960873e-09, -3.209579402573439e-10,  1.459690069943130e-11,
 -5.936515902885209e-13,  2.193679409213795e-14, -7.453461180422537e-16,  2.350126608968177e-17, -6.922199113010485e-19,  1.149410347943109e-05, -2.738349333966740e-06,
  3.569339831631258e-07, -3.300977363946711e-08,  2.407154199145987e-09, -1.464966611359270e-10,  7.707268571717503e-12, -3.589801376644798e-13,  1.505833903722134e-14,
 -5.762476490630071e-16,  2.031926995955662e-17, -6.648991366356153e-19,  1.940440653804610e-06, -5.678535121873072e-07,  8.943685581162009e-08, -9.825067638104967e-09,
  8.387046072678087e-10, -5.900960215733094e-11,  3.550526307455736e-12, -1.873443439297689e-13,  8.828035855389457e-15, -3.766392570994434e-16,  1.470538793836724e-17,
 -5.294046102061462e-19,  3.467141733519499e-07, -1.201319797505110e-07,  2.224325597812839e-08, -2.836579955828011e-09,  2.777497180614537e-10, -2.217724969870837e-11,
  1.499989096255102e-12, -8.821828591891253e-14,  4.598238496055628e-15, -2.155097687545872e-16,  9.185617475557314e-18, -3.588798728846617e-19,  7.102171434322715e-08,
 -2.787242726397941e-08,  5.841695997468391e-09, -8.363234628958742e-10,  9.113062250830095e-11, -8.031221438483527e-12,  5.950725299548834e-13, -3.807993092996141e-14,
  2.146381677164207e-15, -1.081747561271546e-16,  4.932774126053817e-18, -2.051934397005737e-19,  1.516404551221891e-08, -6.398192818552369e-09,  1.444429560426902e-09,
 -2.217917140345604e-10,  2.578964660240207e-11, -2.413382609769616e-12,  1.890079851597016e-13, -1.273031158209458e-14,  7.523299129714069e-16, -3.961486235726677e-17,
  1.881305396529414e-18, -8.125514874899944e-20,  1.646721832658213e-01, -1.189891659336500e-03,  9.305589679013572e-06, -7.671560582498473e-08,  6.492716823928264e-10,
 -5.565475433397923e-12,  4.761985296460938e-14, -4.080172369603916e-16,  3.443496024158197e-18, -2.937355101080043e-20,  2.398203171696804e-22, -2.105550661018288e-24,
  1.288450157604813e-01, -1.416472371283560e-03,  1.953924558149004e-05, -2.628931480518353e-07,  3.361736005108971e-09, -4.120900416168436e-11,  4.882533806938754e-13,
 -5.624419282552281e-15,  6.322830298148943e-17, -6.958675579109858e-19,  7.510979885699149e-21, -7.970252965379075e-23,  7.892306423110544e-02, -1.473237854334200e-03,
  3.056705044744750e-05, -5.596773244634804e-07,  9.422902194858675e-09, -1.490964881777490e-10,  2.244169718359546e-12, -3.238747847663325e-14,  4.508104518242415e-16,
 -6.078220357535823e-18,  7.966608445844724e-20, -1.017518952841575e-21,  3.789890578724610e-02, -1.156884539960037e-03,  3.266641968808473e-05, -7.783809760605492e-07,
  1.667581987528580e-08, -3.295048599079454e-10,  6.099999319131855e-12, -1.069374605496468e-13,  1.789106820701509e-15, -2.873163078959015e-17,  4.449098108060200e-19,
 -6.665393184883083e-21,  1.430686454891508e-02, -6.724369122763215e-04,  2.494633926507098e-05, -7.581512775706542e-07,  2.023663929927371e-08, -4.893685365573543e-10,
  1.093340744962870e-11, -2.286841024186796e-13,  4.520564484045269e-15, -8.505471575937878e-17,  1.531559592148440e-18, -2.650139979723007e-20,  4.268080935781559e-03,
 -2.931290258528196e-04,  1.407398611432760e-05, -5.377998842799513e-07,  1.763878572482743e-08, -5.153989295381547e-10,  1.373093096683856e-11, -3.387512886906424e-13,
  7.825293427680299e-15, -1.706676970857941e-16,  3.536778457638540e-18, -6.997137468295525e-20,  1.015767518467393e-03, -9.780534153716608e-05,  6.018003812828927e-06,
 -2.861235977436928e-07,  1.142457179502049e-08, -3.999353240794387e-10,  1.260304097898144e-11, -3.638976126423813e-13,  9.749424529682686e-15, -2.446583825803315e-16,
  5.792636683092008e-18, -1.300883144834938e-19,  1.960628992720367e-04, -2.561015632534298e-05,  2.001671973228074e-06, -1.174682703139368e-07,  5.671965687389048e-09,
 -2.364227236147716e-10,  8.761152855154082e-12, -2.943821144584268e-13,  9.095932261403578e-15, -2.611721049272665e-16,  7.025398182670219e-18, -1.780883557949288e-19,
  3.156528308033212e-05, -5.440529162740611e-06,  5.350836784000135e-07, -3.848537373216209e-08,  2.234192365170131e-09, -1.103060829243730e-10,  4.782743188942661e-12,
 -1.860917098550233e-13,  6.598589964504890e-15, -2.157053134867495e-16,  6.558941794456652e-18, -1.867054527165951e-19,  4.439141665596063e-06, -9.836784177464886e-07,
  1.203490274250458e-07, -1.052221241955640e-08,  7.295036461578168e-10, -4.240292300163943e-11,  2.138797255535598e-12, -9.581954171959358e-14,  3.877062144278901e-15,
 -1.434689102289931e-16,  4.902779348768408e-18, -1.557975926226481e-19,  5.864546242497139e-07, -1.624270534159135e-07,  2.432821950103589e-08, -2.554650894019467e-09,
  2.093685066838001e-10, -1.419518595082465e-11,  8.256641154165748e-13, -4.223140045671281e-14,  1.933693913334921e-15, -8.033457397249779e-17,  3.060074107752238e-18,
 -1.076668620561356e-19,  8.078002996137313e-08, -2.700658060148064e-08,  4.833032362048205e-09, -5.975211282661148e-10,  5.688491663506162e-11, -4.427312216318103e-12,
  2.925346177735361e-13, -1.684051954308854e-14,  8.606936133860815e-16, -3.961444632674058e-17,  1.660439965661474e-18, -6.387700939636557e-20,  1.302027289504708e-08,
 -5.020574428695816e-09,  1.033990066226574e-09, -1.456554536669441e-10,  1.563856827233335e-11, -1.359734118647844e-12,  9.951416362825281e-14, -6.296548574667190e-15,
  3.512410292604831e-16, -1.753372404822865e-17,  7.925205251435773e-19, -3.270025203891405e-20,  2.358750069947564e-09, -9.900553126527211e-10,  2.223039061369713e-10,
 -3.396005257401409e-11,  3.930002186824312e-12, -3.661395662996749e-13,  2.855694410195494e-14, -1.916053613479091e-15,  1.128309669372064e-16, -5.921518896187226e-18,
  2.803388497453720e-19, -1.207292955434228e-20,  1.600559143301299e-01, -1.118960763589908e-03,  8.443850322969362e-06, -6.715931088909977e-08,  5.485259884200852e-10,
 -4.548156221660826e-12,  3.759129703500864e-14, -3.130622420363275e-16,  2.538203740740831e-18, -2.143897779080041e-20,  1.611910361656917e-22, -1.514287878632342e-24,
  1.234729875544388e-01, -1.271921636845909e-03,  1.668198189228112e-05, -2.151118386698727e-07,  2.643070973205713e-09, -3.117332636459471e-11,  3.557067539972869e-13,
 -3.950165059099795e-15,  4.283611387275027e-17, -4.552406124800760e-19,  4.745126141966067e-21, -4.869852962404071e-23,  7.347999196462922e-02, -1.253211967016330e-03,
  2.466581974714546e-05, -4.301213204143808e-07,  6.913758759713097e-09, -1.046706606944353e-10,  1.510313759636555e-12, -2.092548953602734e-14,  2.800070629403834e-16,
 -3.632939603160893e-18,  4.587365438743921e-20, -5.648285949997878e-22,  3.374067602863529e-02, -9.288334351889026e-04,  2.473249392903986e-05, -5.572470264063728e-07,
  1.133697303032322e-08, -2.134122140744673e-10,  3.773301754632095e-12, -6.330185474851381e-14,  1.015231494854374e-15, -1.565141179837704e-17,  2.329756477569028e-19,
 -3.358913595053826e-21,  1.196553379609083e-02, -5.044140343509966e-04,  1.750912873978297e-05, -5.003223230986008e-07,  1.262848088141732e-08, -2.899150824037639e-10,
  6.167863503624993e-12, -1.231489556443145e-13,  2.328695390038747e-15, -4.198799919423242e-17,  7.257104462343853e-19, -1.207055284178121e-20,  3.285745463701222e-03,
 -2.022350289410531e-04,  9.023819654271327e-06, -3.229180159897804e-07,  9.983219566983815e-09, -2.762124707577464e-10,  6.992568951597601e-12, -1.644033950580314e-13,
  3.628158776743437e-15, -7.575516033574501e-17,  1.505763587696695e-18, -2.862173620063627e-20,  7.027906053056932e-04, -6.080383165575594e-05,  3.462419118986354e-06,
 -1.538062506491413e-07,  5.777978692451229e-09, -1.912568747425049e-10,  5.721475653355477e-12, -1.573349055529015e-13,  4.025612716032467e-15, -9.670665572743969e-17,
  2.196502319329199e-18, -4.741189901488625e-20,  1.185046819625104e-04, -1.398946682250565e-05,  1.011087190948906e-06, -5.542552587214374e-08,  2.517656124729490e-09,
 -9.924732518241616e-11,  3.492885736848620e-12, -1.118512717229698e-13,  3.303486255689412e-15, -9.090136951092591e-17,  2.348695081136274e-18, -5.730742279740408e-20,
  1.611856635993855e-05, -2.533927548641008e-06,  2.311648952114960e-07, -1.556970944450016e-08,  8.522453411510578e-10, -3.988332442446610e-11,  1.646149512253539e-12,
 -6.118855242507409e-14,  2.079100587809911e-15, -6.530240180132794e-17,  1.912394011501390e-18, -5.254363276355888e-20,  1.843792229416038e-06, -3.775422478819158e-07,
  4.316708650303056e-08, -3.555660491202267e-09,  2.336770594533049e-10, -1.293871616974839e-11,  6.242127651636446e-13, -2.683969515096336e-14,  1.045387892328376e-15,
 -3.733507455982206e-17,  1.234222488465404e-18, -3.802139022484147e-20,  1.906660548619285e-07, -4.964080629663925e-08,  7.034036240212173e-09, -7.030051481688615e-10,
  5.511035534826736e-11, -3.588844939334329e-12,  2.012003719541570e-13, -9.949010356912945e-15,  4.415614772625009e-16, -1.782258081598041e-17,  6.609371853507113e-19,
 -2.268262457600381e-20,  2.000869164857342e-08, -6.417666819440870e-09,  1.104668467427201e-09, -1.318556893843489e-10,  1.216063955417757e-11, -9.196023256743767e-13,
  5.919082782158039e-14, -3.326784535925623e-15,  1.663287082678376e-16, -7.502072017963057e-18,  3.086292347937592e-19, -1.166990942673228e-20,  2.477722484910230e-09,
 -9.355595371184636e-10,  1.887500997613036e-10, -2.609075450164434e-11,  2.753549818291066e-12, -2.357035824902806e-13,  1.700664113506190e-14, -1.062169618297113e-15,
  5.855040140450394e-17, -2.891048289359105e-18,  1.293677960643596e-19, -5.288705931156427e-21,  3.715373216414028e-10, -1.549889441613225e-10,  3.458041687885316e-11,
 -5.251161831841838e-12,  6.043307513685496e-13, -5.601537454223914e-14,  4.348303641599272e-15, -2.904799990722917e-16,  1.703629580789835e-17, -8.907226319876794e-19,
  4.202108534356256e-20, -1.803749942831399e-21,  1.557102706766802e-01, -1.054491017740358e-03,  7.687746324751898e-06, -5.906440496647107e-08,  4.659193098845804e-10,
 -3.742647597172926e-12,  2.985479801613633e-14, -2.430665755566570e-16,  1.867601234895717e-18, -1.619274688348123e-20,  1.043223636733884e-22, -1.068056862650618e-24,
  1.186368202666852e-01, -1.148116780586557e-03,  1.433520630962557e-05, -1.773815943834100e-07,  2.096755810299363e-09, -2.382265438886421e-11,  2.620677378834819e-13,
 -2.808805817452922e-15,  2.940463771671556e-17, -3.021634525554301e-19,  3.042702643265629e-21, -3.022279017221955e-23,  6.883156810985766e-02, -1.074797914122475e-03,
  2.010487806633407e-05, -3.344614635537723e-07,  5.140124319901071e-09, -7.455087978978869e-11,  1.032450911888217e-12, -1.374711116440051e-14,  1.770368442939212e-16,
 -2.212106456082288e-18,  2.694034431195265e-20, -3.200044120290294e-22,  3.038267405118888e-02, -7.549328485449724e-04,  1.900746439761133e-05, -4.056237018537574e-07,
  7.847729007407164e-09, -1.409141325762222e-10,  2.382293012537336e-12, -3.828479891606770e-14,  5.891779577547316e-16, -8.726918506479879e-18,  1.249792575888794e-19,
 -1.735305759844689e-21,  1.019432696126138e-02, -3.853152077931354e-04,  1.254943004958450e-05, -3.376471364958980e-07,  8.069411049917618e-09, -1.760632325794613e-10,
  3.570351906000813e-12, -6.810864872820544e-14,  1.232978172336267e-15, -2.131946402565929e-17,  3.539117844757588e-19, -5.661482967038437e-21,  2.599990892834137e-03,
 -1.431966152352332e-04,  5.950657636992149e-06, -1.996199010714509e-07,  5.822767898872240e-09, -1.526690072628534e-10,  3.675214672781973e-12, -8.239574029931943e-14,
  1.738016025536971e-15, -3.475650991275130e-17,  6.628574547032998e-19, -1.210897256147384e-20,  5.051732843957976e-04, -3.916430615828236e-05,  2.065826639945053e-06,
 -8.577078075499779e-08,  3.032661408760216e-09, -9.494765524668897e-11,  2.696962708676690e-12, -7.064257122073666e-14,  1.726284463982522e-15, -3.969941463264517e-17,
  8.649634713628600e-19, -1.794330378643390e-20,  7.531148954849398e-05, -8.002187384669936e-06,  5.344611798038102e-07, -2.735099574836155e-08,  1.168247883497809e-09,
 -4.353442691726896e-11,  1.454443494337811e-12, -4.436648675891211e-14,  1.251889641073609e-15, -3.299542236174298e-17,  8.184296421723597e-19, -1.921022095273971e-20,
  8.760130718465824e-06, -1.249245778014127e-06,  1.054565311461569e-07, -6.639195515497475e-09,  3.421303371584728e-10, -1.515536238239248e-11,  5.946819542403635e-13,
 -2.109122779097759e-14,  6.859153295144949e-16, -2.067579595443399e-17,  5.824906826094860e-19, -1.542983244411751e-20,  8.232582794821487e-07, -1.547344963394370e-07,
  1.646584174345915e-08, -1.273658866045870e-09,  7.912938723739028e-11, -4.163587443540692e-12,  1.916982380215132e-13, -7.894673659269612e-15,  2.954270801686925e-16,
 -1.016444942418831e-17,  3.244884981472411e-19, -9.674529045817529e-21,  6.687652485675906e-08, -1.624857112545238e-08,  2.166593788439486e-09, -2.051988772096764e-10,
  1.532945886223630e-11, -9.556807149396350e-13,  5.148904842681424e-14, -2.454791470688080e-15,  1.053434627331506e-16, -4.121476490327446e-18,  1.484812213843053e-19,
 -4.960401429407394e-21,  5.300213432601775e-09, -1.620314882898378e-09,  2.668218343098598e-10, -3.060876895721616e-11,  2.724000676875204e-12, -1.994556751912834e-13,
  1.246742098604860e-14, -6.822322417633185e-16,  3.328364101706708e-17, -1.467768108141099e-18,  5.914082269630856e-20, -2.193763571926772e-21,  4.923005006301214e-10,
 -1.812791447609759e-10,  3.569503933454072e-11, -4.826079206170117e-12,  4.992424533279280e-13, -4.196845315032045e-14,  2.978805259165858e-15, -1.832840895778946e-16,
  9.966275233350241e-18, -4.859935446835813e-19,  2.149899554548768e-20, -8.696928437032693e-22,  5.939292261285585e-11, -2.459413764690032e-11,  5.446246079961188e-12,
 -8.212445557010499e-13,  9.390394368926748e-14, -8.652420407508633e-15,  6.680050721284676e-16, -4.440099131601468e-17,  2.592003164925048e-18, -1.349387444230372e-19,
  6.340591478402094e-21, -2.711641687722405e-22,  1.516109933700496e-01, -9.957028554409321e-04,  7.021351633473405e-06, -5.217178809469446e-08,  3.977129485373857e-10,
 -3.101561511068093e-12,  2.380324067932268e-14, -1.919071726558288e-16,  1.349967817846172e-18, -1.278608349863611e-20,  7.125937911634482e-23, -3.355209464173717e-25,
  1.142609955014218e-01, -1.041413244665760e-03,  1.239323103419059e-05, -1.473283376318176e-07,  1.677338333406181e-09, -1.837973169638046e-11,  1.951126931452337e-13,
 -2.020784494277748e-15,  2.043158181890768e-17, -2.033379821826831e-19,  1.980304820020915e-21, -1.895327650418143e-23,  6.483047011714550e-02, -9.287201024718853e-04,
  1.653961814707348e-05, -2.629215288002999e-07,  3.868737748006662e-09, -5.381769804969462e-11,  7.162098345644406e-13, -9.172818181392695e-15,  1.138306925863515e-16,
 -1.370538085381585e-18,  1.611576169096589e-20, -1.850064358211342e-22,  2.763898921084676e-02, -6.204041612332219e-04,  1.480951036268702e-05, -2.998293366416789e-07,
  5.524260151121992e-09, -9.473148598698909e-11,  1.533142231374039e-12, -2.362463227609971e-14,  3.492307321331407e-16, -4.973714459646785e-18,  6.858872399359560e-20,
 -9.180422153903918e-22,  8.830976183332971e-03, -2.991722404059421e-04,  9.169610706167057e-06, -2.326273300988399e-07,  5.270913471377419e-09, -1.094231628009393e-10,
  2.117285114931379e-12, -3.862330178642136e-14,  6.699471713827915e-16, -1.111673335629821e-17,  1.773654591856556e-19, -2.730560463161286e-21,  2.109208801433625e-03,
 -1.037937185853407e-04,  4.027066974339142e-06, -1.267747096013976e-07,  3.492731554708805e-09, -8.686018968656272e-11,  1.989888781233301e-12, -4.256819221985900e-14,
  8.587378250523085e-16, -1.645552446126441e-17,  3.012444270906009e-19, -5.290671293494217e-21,  3.760501660272080e-04, -2.605421344582916e-05,  1.274839387107612e-06,
 -4.949803390079358e-08,  1.648179637356157e-09, -4.882938561280516e-11,  1.317439396720604e-12, -3.287890170383518e-14,  7.675221862704148e-16, -1.689926373997862e-17,
  3.532244454652580e-19, -7.042224475014553e-21,  5.015011591943535e-05, -4.777241605471153e-06,  2.948271266535733e-07, -1.408099307100117e-08,  5.654482802979011e-10,
 -1.991489262036223e-11,  6.314490293030286e-13, -1.834331070555267e-14,  4.943445055828687e-16, -1.247529117524755e-17,  2.969454499045467e-19, -6.702006952249799e-21,
  5.052195694752006e-06, -6.500554890487642e-07,  5.068242241341700e-08, -2.978123563937523e-09,  1.443064835961219e-10, -6.044100011203997e-12,  2.252368305467954e-13,
 -7.614386520746295e-15,  2.367752422160155e-16, -6.842884224389126e-18,  1.852761215105009e-19, -4.727118009893950e-21,  3.946863563712139e-07, -6.763259697115542e-08,
  6.673091064901036e-09, -4.833161751590212e-10,  2.831649657637946e-11, -1.412790664835635e-12,  6.195418481769122e-14, -2.439207550764369e-15,  8.754192320800934e-17,
 -2.896770286144336e-18,  8.915970835159998e-20, -2.568743650206912e-21,  2.535916934962349e-08, -5.705427401181680e-09,  7.120655498265831e-10, -6.363473189258115e-11,
  4.513719224263525e-12, -2.685252085352646e-13,  1.386289468264591e-14, -6.355492898121031e-16,  2.630622956109094e-17, -9.953549235363491e-19,  3.476141399652030e-20,
 -1.128191027177956e-21,  1.510274784399670e-09, -4.367995427047474e-10,  6.840905362634613e-11, -7.505243853594298e-12,  6.417984003147184e-13, -4.533425737574665e-14,
  2.742850353619856e-15, -1.456988203743287e-16,  6.917408279326305e-18, -2.975208908260617e-19,  1.171506614053019e-20, -4.254233145364846e-22,  1.028148275444071e-10,
 -3.673607535500208e-11,  7.028807194656332e-12, -9.259894753537115e-13,  9.358438693549960e-14, -7.703731962188997e-15,  5.365160536790980e-16, -3.244829589396793e-17,
  1.736985172355261e-18, -8.349870698250622e-20,  3.645657531368268e-21, -1.457164909342840e-22,  9.662038643656448e-12, -3.965512531386327e-12,  8.702949817577795e-13,
 -1.301451673751993e-13,  1.476846324514589e-14, -1.351367065975615e-15,  1.036713535526770e-16, -6.850865649293408e-18,  3.978018709006408e-19, -2.060765532362150e-20,
  9.639283175555352e-22, -4.105067173574380e-23,  1.477367052681411e-01, -9.419326317240841e-04,  6.431519341710860e-06, -4.627533572358695e-08,  3.409827444749560e-10,
 -2.590289018223475e-12,  1.896929163953127e-14, -1.555289839796964e-16,  9.409813984944888e-19, -9.821880279231879e-21,  8.939638862901457e-23,  1.382697754628830e-24,
  1.102830465024620e-01, -9.489092951665984e-04,  1.077495945202802e-05, -1.231952446460252e-07,  1.352342598005308e-09, -1.430838499541449e-11,  1.466838731759268e-13,
 -1.470295790175863e-15,  1.435787540928503e-17, -1.384771952172381e-19,  1.314537489698171e-21, -1.181352147762330e-23,  6.136162645439169e-02, -8.080472345522043e-04,
  1.372324224674823e-05, -2.087790818578249e-07,  2.945419021006118e-09, -3.934062299237312e-11,  5.037524086455869e-13, -6.209586895402339e-15,  7.437034689287614e-17,
 -8.633024630201043e-19,  9.792527999150818e-21, -1.095708630955438e-22,  2.537348427818695e-02, -5.149493219603792e-04,  1.168527640167128e-05, -2.248031287528729e-07,
  3.949891398838593e-09, -6.475943063485830e-11,  1.004552720654978e-12, -1.485456349672947e-14,  2.111767735849426e-16, -2.893972359752705e-18,  3.844150824389445e-20,
 -4.972716537599032e-22,  7.765146625516864e-03, -2.356978272831485e-04,  6.819905367289571e-06, -1.633678879108957e-07,  3.514113003006465e-09, -6.948929680111996e-11,
  1.284357852136673e-12, -2.242358988185831e-14,  3.730169886742076e-16, -5.944252279131832e-18,  9.120451673714010e-20, -1.352575068091526e-21,  1.750018288964876e-03,
 -7.682932214814989e-05,  2.791163649554922e-06, -8.254947791522208e-08,  2.150551863661199e-09, -5.077483103791591e-11,  1.107908660030115e-12, -2.263088799909155e-14,
  4.369063554684383e-16, -8.026893164309356e-18,  1.411171583584982e-19, -2.383862502040552e-21,  2.890163188372205e-04, -1.784753200632599e-05,  8.116766669865754e-07,
 -2.949134398199772e-08,  9.254782174433736e-10, -2.596058822082892e-11,  6.656395139872047e-13, -1.583403951026668e-14,  3.532098571031281e-16, -7.447667158441449e-18,
  1.493647037345888e-19, -2.862298736263317e-21,  3.487126884714843e-05, -2.966383969894285e-06,  1.692517636523686e-07, -7.543871863327540e-09,  2.848311563493476e-10,
 -9.481260580146799e-12,  2.853034341664843e-13, -7.891968785874050e-15,  2.031013962577129e-16, -4.906580233683506e-18,  1.120453495673892e-19, -2.430918746861926e-21,
  3.081885503171671e-06, -3.558796130525780e-07,  2.559419087680495e-08, -1.402134790249733e-09,  6.382912721586370e-11, -2.525698916309904e-12,  8.931751341903238e-14,
 -2.875877382389775e-15,  8.544021380649424e-17, -2.365538904129196e-18,  6.150530775632597e-20, -1.510209921922633e-21,  2.027795545773685e-07, -3.146333153784983e-08,
  2.868917953236382e-09, -1.940661818011957e-10,  1.069934548754893e-11, -5.052184700236306e-13,  2.106464176690863e-14, -7.915496234175341e-16,  2.720278840144621e-17,
 -8.644069724086539e-19,  2.561389307916822e-20, -7.120831760618696e-22,  1.040756261260340e-08, -2.150667953983186e-09,  2.499179938717348e-10, -2.098695906478993e-11,
  1.408499312685792e-12, -7.971329443820343e-14,  3.932378364795648e-15, -1.729156427424601e-16,  6.886963440052159e-18, -2.514521456345243e-19,  8.495061788043049e-21,
 -2.673208633325330e-22,  4.654524347909125e-10, -1.262986639980711e-10,  1.869347393044607e-11, -1.951248221852723e-12,  1.596223339513802e-13, -1.083491162319497e-14,
  6.323344628667705e-16, -3.250487753456654e-17,  1.497606192672909e-18, -6.266093382153472e-20,  2.405414157573964e-21, -8.532757803294738e-23,  2.274031624157242e-11,
 -7.836101553996210e-12,  1.449275208359437e-12, -1.852196845123910e-13,  1.821828993754599e-14, -1.463689264914535e-15,  9.972970699349578e-17, -5.913391232429728e-18,
  3.109103517695006e-19, -1.470303669506476e-20,  6.324168697129899e-22, -2.493403093986551e-23,  1.605071906197176e-12, -6.516311305227204e-13,  1.414706915739174e-13,
 -2.094635397012194e-14,  2.355570892160097e-15, -2.137866820191033e-16,  1.627936145243119e-17, -1.068517349195710e-18,  6.166130137978062e-20, -3.176193343191710e-21,
  1.477926951891801e-22, -6.263818742899222e-24,  1.440684880653891e-01, -8.926127294461130e-04,  5.907316285190375e-06, -4.121074543091601e-08,  2.933931548567793e-10,
 -2.184179402682556e-12,  1.498872431597502e-14, -1.302183043352107e-16,  6.737715811859970e-19, -4.202424374355030e-21,  2.144022556769545e-22,  4.496719243621214e-24,
  1.066509379449555e-01, -8.682757260391317e-04,  9.417581345581898e-06, -1.036689476733755e-07,  1.098294415341531e-09, -1.123434023408650e-11,  1.112654126496669e-13,
 -1.081380545171839e-15,  1.020811450203543e-17, -9.475753458819411e-20,  9.059563926293557e-22, -7.063840070765984e-24,  5.833419942438061e-02, -7.075373435313249e-04,
  1.147666590032737e-05, -1.673446040585490e-07,  2.266700909187547e-09, -2.909429401746485e-11,  3.590184861368387e-13, -4.259939713780452e-15,  4.931331711483917e-17,
 -5.537797208074964e-19,  5.989868385735165e-21, -6.729487039013567e-23,  2.348496328166136e-02, -4.312738645055933e-04,  9.327974617347414e-06, -1.707852521157097e-07,
  2.865678747961072e-09, -4.496430889194615e-11,  6.694614307893463e-13, -9.505136738648505e-15,  1.301044375518248e-16, -1.718570838246826e-18,  2.192683578287452e-20,
 -2.763635753063278e-22,  6.920280527858966e-03, -1.881201162488725e-04,  5.155877819850040e-06, -1.167770763892684e-07,  2.387931325060728e-09, -4.502536848135309e-11,
  7.958569016167827e-13, -1.330868653993521e-14,  2.125176332624247e-16, -3.255582549313712e-18,  4.803136224130036e-20, -6.876082635368283e-22,  1.481820561735762e-03,
 -5.794619432421091e-05,  1.977664299077614e-06, -5.501000449314985e-08,  1.356785412179309e-09, -3.044174101845001e-11,  6.332583520356409e-13, -1.236042664715578e-14,
  2.285283882429263e-16, -4.028047096520218e-18,  6.803185615257059e-20, -1.106210427202829e-21,  2.286813246347463e-04, -1.255245886240635e-05,  5.319413717060526e-07,
 -1.809996570888318e-08,  5.357904693489299e-10, -1.424015472803666e-11,  3.472033998709886e-13, -7.876145768384670e-15,  1.679598215641773e-16, -3.392783889537240e-18,
  6.530298080380153e-20, -1.203135592286415e-21,  2.523344792604159e-05, -1.909321837541080e-06,  1.008390851966547e-07, -4.195280945745231e-09,  1.489807103563945e-10,
 -4.688045026994955e-12,  1.338989822510300e-13, -3.527140712704784e-15,  8.668168780376729e-17, -2.004536782876550e-18,  4.391028412989704e-20, -9.156319371734389e-22,
  1.981571498906845e-06, -2.042658012757962e-07,  1.354315341372284e-08, -6.911938497255599e-10,  2.954451021525218e-11, -1.103877735050877e-12,  3.702440862568203e-14,
 -1.134789939144877e-15,  3.219163981318386e-17, -8.533154553468217e-19,  2.129200928092417e-20, -5.028060513617620e-22,  1.113624327573210e-07, -1.553773513289299e-08,
  1.305780877726318e-09, -8.231834240966362e-11,  4.263192026374459e-12, -1.902168006606712e-13,  7.529425195685778e-15, -2.696609886178572e-16,  8.861939366761223e-18,
 -2.700620736955676e-19,  7.694123834842520e-21, -2.061402268371903e-22,  4.623489141906355e-09, -8.701006856025859e-10,  9.367607671185038e-11, -7.363311212212930e-12,
  4.660475705848409e-13, -2.501943140599913e-14,  1.176314611992565e-15, -4.949246107707122e-17,  1.892511338091312e-18, -6.653543461335947e-20,  2.170117638615553e-21,
 -6.608468212243065e-23,  1.558970651689376e-10, -3.932218448921078e-11,  5.463811632753133e-12, -5.397024847832947e-13,  4.204388112811606e-14, -2.731545076239722e-15,
  1.532268417981393e-16, -7.597899247494656e-18,  3.387170706370356e-19, -1.374987208865601e-20,  5.133158734131174e-22, -1.774658059824546e-23,  5.371020943451798e-12,
 -1.771785318328674e-12,  3.148224964710475e-13, -3.883189957152674e-14,  3.701119793583704e-15, -2.891162606729945e-16,  1.920879513816450e-17, -1.113370694905435e-18,
  5.734518560573147e-20, -2.661581797161346e-21,  1.125436943553297e-22, -4.368586495596838e-24,  2.734578601975131e-13, -1.095360151662328e-13,  2.346881666746869e-14,
 -3.433386724135514e-15,  3.819638155081656e-16, -3.433105522739238e-17,  2.591403129144537e-18, -1.687440484611010e-19,  9.667667418726370e-21, -4.947118461952846e-22,
  2.288105815852234e-23, -9.644048727311817e-25,  1.405895306300532e-01, -8.472557109561929e-04,  5.439571552553985e-06, -3.684757533211361e-08,  2.530237735319104e-10,
 -1.865836885918576e-12,  1.163606686805860e-14, -1.089739081772507e-16,  7.339071848710383e-19,  9.343456234896961e-21,  4.852780898107662e-22,  7.483111932237333e-24,
  1.033210378619031e-01, -7.976286307846217e-04,  8.272018944371260e-06, -8.775831003404127e-08,  8.980369979192273e-10, -8.893317479004017e-12,  8.509382208538696e-14,
 -8.028517833307327e-16,  7.383738752262956e-18, -6.371338045232035e-20,  6.686496595738385e-22, -3.993120805207143e-24,  5.567577422348880e-02, -6.231813854836445e-04,
  9.668344628119336e-06, -1.353018836994432e-07,  1.762166906767116e-09, -2.174777480702154e-11,  2.591341084140318e-13, -2.959940236966201e-15,  3.305125036855350e-17,
 -3.653798762026526e-19,  3.604377575364459e-21, -4.320962637681326e-23,  2.189715268537665e-02, -3.641313863695694e-04,  7.526579754652596e-06, -1.313384057352637e-07,
  2.107714751046187e-09, -3.167215891258810e-11,  4.533850931536655e-13, -6.183685898042174e-15,  8.146851395254876e-17, -1.044538200059267e-18,  1.263195950024163e-20,
 -1.579015957951007e-22,  6.242253573005144e-03, -1.518911494169291e-04,  3.957123578758143e-06, -8.485057732019796e-08,  1.651801452266624e-09, -2.972442450261425e-11,
  5.031388982077945e-13, -8.064561270292229e-15,  1.236743272674993e-16, -1.825854749645208e-18,  2.583277836315457e-20, -3.585383599060250e-22,  1.277963764535123e-03,
 -4.443775026302622e-05,  1.430089843662475e-06, -3.745070032192066e-08,  8.756628119731338e-10, -1.868761006274965e-11,  3.710046789072237e-13, -6.924791125865359e-15,
  1.226874865408783e-16, -2.076922154299622e-18,  3.369398050299066e-20, -5.279934006645761e-22,  1.857874589804327e-04, -9.039027173760215e-06,  3.580643508338271e-07,
 -1.141833052608431e-08,  3.191712658496410e-10, -8.043416660610294e-12,  1.866279669030157e-13, -4.039511500624096e-15,  8.239014627373904e-17, -1.595202752190191e-18,
  2.947350199364884e-20, -5.222799262221066e-22,  1.893980820708549e-05, -1.269597769100169e-06,  6.218951897978658e-08, -2.415760443747054e-09,  8.073155426750076e-11,
 -2.402407887888255e-12,  6.515004862702546e-14, -1.634627428978090e-15,  3.836705073939310e-17, -8.493880840428393e-19,  1.784802159643079e-20, -3.576924258558651e-22,
  1.338139490653761e-06, -1.224722314944291e-07,  7.487764208444535e-09, -3.558445099054036e-10,  1.427865690144351e-11, -5.036031490569002e-13,  1.601530306724204e-14,
 -4.670925291226408e-16,  1.264720224359439e-17, -3.208280921459416e-19,  7.678867035556125e-21, -1.743087769449741e-22,  6.517086064251914e-08, -8.119268593476780e-09,
  6.276470956339513e-10, -3.681144541728773e-11,  1.788341534231650e-12, -7.530147491352693e-14,  2.826396812425644e-15, -9.636426711442860e-17,  3.024863521299830e-18,
 -8.830399691748238e-20,  2.416169667521434e-21, -6.231535347583191e-23,  2.221314450861440e-09, -3.773521623029149e-10,  3.747002154993255e-11, -2.747205740654172e-12,
  1.635014662304801e-13, -8.304439696273411e-15,  3.712320818046947e-16, -1.491204601052509e-17,  5.463088306155910e-19, -1.845784627778828e-20,  5.801103123066228e-22,
 -1.706449876221961e-23,  5.696697019841400e-11, -1.322168743007312e-11,  1.712960773092489e-12, -1.592525189144675e-13,  1.176024377690061e-14, -7.283861295327979e-16,
  3.913320287554524e-17, -1.865774916753728e-18,  8.024437498358357e-20, -3.151782361008918e-21,  1.141404593169730e-22, -3.836907488036476e-24,  1.366801414728399e-12,
 -4.277968200960933e-13,  7.251378023856488e-14, -8.582153145408670e-15,  7.887147360491693e-16, -5.964952069137964e-17,  3.850065385204555e-18, -2.174229940302160e-19,
  1.093825560080744e-20, -4.969598381662380e-22,  2.060917832102902e-23, -7.859309241280583e-25,  4.804407643392580e-14, -1.892300034893826e-14,  3.989039422725241e-15,
 -5.751187057805816e-16,  6.315429149058479e-17, -5.610726588539109e-18,  4.191228559312942e-19, -2.703712659538192e-20,  1.535925302985790e-21, -7.799319805837967e-23,
  3.582065125853262e-24, -1.500158999214833e-25,  1.372848340554881e-01, -8.054417421150125e-04,  5.020505921118614e-06, -3.308353968940919e-08,  2.182681130071902e-10,
 -1.620071819779229e-12,  8.994637656778241e-15, -7.571073993974095e-17,  1.499267888672681e-18,  3.524910660863607e-20,  7.917134318173276e-22,  4.813829507090369e-24,
  1.002565338983827e-01, -7.354334450595345e-04,  7.299600839405773e-06, -7.470887470558553e-08,  7.389019381555584e-10, -7.096067034506209e-12,  6.561204806951627e-14,
 -5.984198016230601e-16,  5.533973767800824e-18, -3.998159464471389e-20,  5.262558339016655e-22, -2.868439498410238e-24,  5.332809494668928e-02, -5.518808023897786e-04,
  8.200558958707413e-06, -1.102751213077224e-07,  1.383259881700052e-09, -1.641482828097855e-11,  1.892636786588168e-13, -2.088343383333571e-15,  2.208107013229993e-17,
 -2.541829181823165e-19,  2.073137892287186e-21, -2.691219611584105e-23,  2.055182109468584e-02, -3.096942661866340e-04,  6.133721977505825e-06, -1.021452828917618e-07,
  1.570446126376966e-09, -2.260561435925959e-11,  3.117101932799464e-13, -4.093029991594800e-15,  5.149363994605172e-17, -6.559288912937938e-19,  7.283870510130907e-21,
 -9.081356883604845e-23,  5.692133973438840e-03, -1.238989680255705e-04,  3.079804755027760e-06, -6.259101115656227e-08,  1.161853073805759e-09, -1.996587821330406e-11,
  3.241168487432531e-13, -4.986492933905792e-15,  7.328000950903564e-17, -1.050601546063916e-18,  1.414285552425298e-20, -1.907405742534793e-22,  1.120550347882184e-03,
 -3.458204455400379e-05,  1.053815694882535e-06, -2.600506691651774e-08,  5.772764961840216e-10, -1.172738901194690e-11,  2.224552320589725e-13, -3.974471000670718e-15,
  6.746507724569077e-17, -1.099678651838308e-18,  1.711161423338034e-20, -2.586667838565058e-22,  1.546008118428150e-04, -6.646593822303462e-06,  2.470709776966297e-07,
 -7.388877917355890e-09,  1.952729732822924e-10, -4.669615183960143e-12,  1.031937591537165e-13, -2.132736043058467e-15,  4.161695303037522e-17, -7.730566578365170e-19,
  1.371072597821706e-20, -2.337844218498089e-22,  1.469964995991814e-05, -8.692470904048537e-07,  3.960301376821551e-08, -1.436869697358166e-09,  4.522494360173709e-11,
 -1.273301790355754e-12,  3.280093644448233e-14, -7.841628867209255e-16,  1.758192682555209e-17, -3.727350271331833e-19,  7.513379520126933e-21, -1.447283885791162e-22,
  9.456318770403333e-07, -7.641580816432843e-08,  4.313221127847425e-09, -1.908209546623758e-10,  7.188637704439380e-12, -2.393195270326888e-13,  7.215527629024867e-15,
 -2.002217570935976e-16,  5.173309767955904e-18, -1.255596188075899e-19,  2.881713404609000e-21, -6.285720100343269e-23,  4.049971745750725e-08, -4.472993851776857e-09,
  3.177267288876439e-10, -1.731318238575196e-11,  7.882179987096895e-13, -3.129134537445099e-14,  1.112688626694549e-15, -3.608179689940251e-17,  1.080833505871385e-18,
 -3.019765099574626e-20,  7.928040052480523e-22, -1.966469080998770e-23,  1.152028015586303e-09, -1.750467869696954e-10,  1.597005440747689e-11, -1.088765152318800e-12,
  6.077610078586167e-14, -2.913895473847842e-15,  1.235914626393185e-16, -4.730439034900609e-18,  1.657259091035266e-19, -5.371325205214936e-21,  1.623895931816725e-22,
 -4.606582523397409e-24,  2.277145474323662e-11, -4.809797584509436e-12,  5.771025072219846e-13, -5.023011508750036e-14,  3.500596136481795e-15, -2.058903077718169e-16,
  1.055751624679467e-17, -4.824491387791742e-19,  1.995949137288530e-20, -7.564745882315097e-22,  2.650806575598629e-23, -8.643812568377654e-25,  3.782199599098144e-13,
 -1.111302278817665e-13,  1.782583118054114e-14, -2.011168315532275e-15,  1.772451345403071e-16, -1.291709698433406e-17,  8.066286464782495e-19, -4.422117681897352e-20,
  2.165964924914844e-21, -9.604899421900997e-23,  3.896297060222446e-24, -1.456299299054134e-25,  8.765561752575106e-15, -3.379414963751829e-15,  6.981389953980061e-16,
 -9.886499105504691e-17,  1.068598861780365e-17, -9.361508145384995e-19,  6.906432896606588e-20, -4.405861593460257e-21,  2.477928539174373e-22, -1.246943748658556e-23,
  5.680181445461464e-25, -2.361199796481716e-26,  1.341409614932487e-01, -7.668087251543198e-04,  4.643424232267114e-06, -2.983933837448946e-08,  1.878874905385090e-10,
 -1.422820152246504e-12,  7.782202379893866e-15, -1.104340308307577e-18,  3.357392949356828e-18,  6.738791861540653e-20,  6.880149266490327e-22, -1.278161970303951e-23,
  9.742618604232488e-02, -6.804319400360617e-04,  6.469607936232094e-06, -6.394160890391109e-08,  6.114685569412489e-10, -5.703627080762725e-12,  5.114661504063814e-14,
 -4.405583549680638e-16,  4.441004701876598e-18, -2.173505433714452e-20,  3.731067248926322e-22, -4.662447943769082e-24,  5.124389995372448e-02, -4.912167301815602e-04,
  6.999965025079394e-06, -9.054108349612701e-08,  1.096028921801468e-09, -1.250227338718981e-11,  1.394088030374593e-13, -1.514190658316219e-15,  1.418055422338598e-17,
 -1.901884910478428e-19,  1.251596205870487e-21, -9.648201913715731e-24,  1.940398139555845e-02, -2.651322030857751e-04,  5.045039393043599e-06, -8.026444986397577e-08,
  1.184737763897262e-09, -1.633361257848613e-11,  2.169845314938309e-13, -2.773768340866006e-15,  3.229181444516319e-17, -4.303987068484623e-19,  4.316609725100851e-21,
 -4.607761582427757e-23,  5.241467393489805e-03, -1.019766944672228e-04,  2.428322968699128e-06, -4.681637043998459e-08,  8.302483572885566e-10, -1.362896925128483e-11,
  2.123314384837238e-13, -3.152010337154285e-15,  4.390291602701618e-17, -6.223350358860891e-19,  7.923095125874084e-21, -1.005158822943312e-22,  9.973071726461840e-04,
 -2.725885551112669e-05,  7.902792548895469e-07, -1.838881765448818e-08,  3.882250145694103e-10, -7.512286353921796e-12,  1.362699502354195e-13, -2.336329751311252e-15,
  3.787635803084309e-17, -5.979215187352122e-19,  8.911366550684888e-21, -1.291580551160511e-22,  1.314726346330897e-04, -4.977892295609877e-06,  1.744549828074673e-07,
 -4.894976081414839e-09,  1.224910774942736e-10, -2.781452444855562e-12,  5.859002716167766e-14, -1.157712011510107e-15,  2.160104720272555e-17, -3.856970515455729e-19,
  6.566075389728749e-21, -1.076446787728252e-22,  1.176223221285715e-05, -6.107819828951449e-07,  2.598239016508406e-08, -8.806885057923116e-10,  2.613527596299740e-11,
 -6.965781177160273e-13,  1.705495605709200e-14, -3.887451476284754e-16,  8.326587241933400e-18, -1.691425041168368e-19,  3.271043103755388e-21, -6.056026474707284e-23,
  6.968255300281874e-07, -4.942503218191321e-08,  2.581505640452932e-09, -1.063010043344199e-10,  3.761343873176728e-12, -1.182120145458422e-13,  3.379397265376657e-15,
 -8.922592221073679e-17,  2.199697015660728e-18, -5.107729329826925e-20,  1.123889583188630e-21, -2.355065974713686e-23,  2.662562524273498e-08, -2.587412344577189e-09,
  1.688915926179772e-10, -8.541553537548982e-12,  3.642191249147895e-13, -1.362336803117643e-14,  4.586457024957944e-16, -1.413648946328221e-17,  4.038207723053319e-19,
 -1.079034990563369e-20,  2.716123324671340e-22, -6.474234921630521e-24,  6.432046803983176e-10, -8.658461422098005e-11,  7.236930397788921e-12, -4.575747658747399e-13,
  2.390680136061015e-14, -1.079904538313676e-15,  4.338178809660401e-17, -1.579454493940524e-18,  5.282924143018197e-20, -1.639929983922388e-21,  4.761866453774847e-23,
 -1.300702212533730e-24,  9.970089156052308e-12, -1.893833685465203e-12,  2.091002766679224e-13, -1.695316114075459e-14,  1.110339837253021e-15, -6.178732163909215e-17,
  3.013884445539204e-18, -1.316047309040768e-19,  5.222607834171772e-21, -1.904985018454302e-22,  6.443193391582586e-24, -2.033301153642041e-25,  1.148454674113199e-13,
 -3.128248504681655e-14,  4.706328152230769e-15, -5.025972924052751e-16,  4.222565232968548e-17, -2.950277833895437e-18,  1.774553631217391e-19, -9.407106591661178e-21,
  4.470216453444790e-22, -1.928697584889596e-23,  7.631336215889212e-25, -2.788349004800768e-26,  1.675658283975482e-15, -6.284822541311775e-16,  1.265804276319032e-16,
 -1.753175419447574e-17,  1.858584645990384e-18, -1.600775147448744e-19,  1.163375892762742e-20, -7.323313238505780e-22,  4.070002753313392e-23, -2.026334529462841e-24,
  9.141989723374960e-26, -3.767294565835674e-27,  1.311458229722617e-01, -7.310446099569066e-04,  4.302483744541327e-06, -2.705040356383000e-08,  1.613691410890402e-10,
 -1.221883920888476e-12,  9.648861488020155e-15,  1.487948357980649e-16,  6.055493294739016e-18,  7.371787089574051e-20, -6.561969735579542e-22, -5.171193460677176e-23,
  9.480333634255086e-02, -6.315862102035934e-04,  5.757450477641820e-06, -5.500791067683139e-08,  5.087522812398137e-10, -4.608708537529080e-12,  4.070077304982443e-14,
 -3.085610438352694e-16,  3.866094177009267e-18, -1.224314578456710e-20,  6.232623849046496e-23, -1.001397888434663e-23,  4.938454857625567e-02, -4.392827525975654e-04,
  6.010990825427466e-06, -7.483676572129942e-08,  8.762467541473368e-10, -9.619947953110799e-12,  1.024009720660497e-13, -1.160752140805299e-15,  8.190647189293336e-18,
 -1.421353929276951e-19,  1.324543113635636e-21,  1.411921851575691e-23,  1.841849748731504e-02, -2.283254448316945e-04,  4.185669706408039e-06, -6.366355366931233e-08,
  9.043976693021714e-10, -1.195441356997345e-11,  1.516744454023370e-13, -1.958291855732702e-15,  1.952143193638996e-17, -2.868354744236375e-19,  3.139789657101744e-21,
 -7.837463307904649e-24,  4.869149339035432e-03, -8.459052434319334e-05,  1.938056481242290e-06, -3.546354780315515e-08,  6.022197035532340e-10, -9.452045503742244e-12,
  1.407669710893461e-13, -2.051976453897091e-15,  2.630108514986225e-17, -3.762990794445781e-19,  4.766221779690945e-21, -4.704237236414432e-23,  8.996540229093809e-04,
 -2.172405294491861e-05,  6.024451878795632e-07, -1.322149756756460e-08,  2.660168614678388e-10, -4.907531847083759e-12,  8.501845496307634e-14, -1.409607714913853e-15,
  2.160685079689926e-17, -3.328423744497801e-19,  4.811620267003633e-21, -6.425814815172602e-23,  1.140223542741807e-04, -3.787674676656978e-06,  1.258590815991066e-07,
 -3.313514148032548e-09,  7.865311298872481e-11, -1.697396519907240e-12,  3.407803874821804e-14, -6.459454716043168e-16,  1.149079022251857e-17, -1.977564643794186e-19,
  3.241577590177562e-21, -5.069706443163100e-23,  9.676692162413924e-06, -4.390178233155902e-07,  1.752646401876856e-08, -5.549601984436034e-10,  1.554987713753755e-11,
 -3.926062022158104e-13,  9.138792564180471e-15, -1.988923830057831e-16,  4.067289896172471e-18, -7.924272816334994e-20,  1.471431856786519e-21, -2.615033153616959e-23,
  5.335896102613795e-07, -3.300710497193506e-08,  1.601218775773009e-09, -6.135208537778168e-11,  2.040679684511790e-12, -6.056483458842539e-14,  1.641923976943538e-15,
 -4.126740698430122e-17,  9.705663097820104e-19, -2.156483649930797e-20,  4.549425748234840e-22, -9.155317281911194e-24,  1.844583279192227e-08, -1.564603878528553e-09,
  9.399067670963749e-11, -4.407977442272360e-12,  1.760230667967053e-13, -6.201293468154844e-15,  1.975802825145395e-16, -5.786312088121631e-18,  1.575429480794885e-19,
 -4.024063262324181e-21,  9.706467741410720e-23, -2.222014602164224e-24,  3.852836287215154e-10, -4.548681202092837e-11,  3.477482167453969e-12, -2.034688848695461e-13,
  9.934173472623221e-15, -4.221416866317712e-16,  1.603840287728601e-17, -5.546840088571320e-19,  1.768857165524674e-20, -5.251904499121727e-22,  1.462721229537506e-23,
 -3.842051943871883e-25,  4.780412268970596e-12, -8.062307209350306e-13,  8.145317218040847e-14, -6.123299867039328e-15,  3.754678173433129e-16, -1.970182391458232e-17,
  9.113997686594529e-19, -3.792120792105381e-20,  1.439683588608976e-21, -5.041353583781009e-23,  1.641934597478401e-24, -5.003264040087306e-26,  3.858661480071458e-14,
 -9.601981025428074e-15,  1.342019754090570e-15, -1.346410346854035e-16,  1.071673325068881e-17, -7.140443056976181e-19,  4.117516811473869e-20, -2.101866262176355e-21,
  9.653984885960152e-23, -4.038965148656079e-24,  1.554002241605529e-25, -5.535190844466201e-27,  3.394582995833361e-16, -1.228286199483890e-16,  2.395547301779578e-17,
 -3.227366475078847e-18,  3.340735218947576e-19, -2.818274691678618e-20,  2.011335531246133e-21, -1.245988993030414e-22,  6.826934351930976e-24, -3.356063933255552e-25,
  1.496978140828833e-26, -6.106032013531415e-28,  1.282884880723398e-01, -6.978810337500240e-04,  3.992609534616036e-06, -2.464957749918695e-08,  1.397071656405104e-10,
 -9.162746985251868e-13,  1.686077612829787e-14,  3.746463470622097e-16,  7.556204938041837e-18, -1.254671931235995e-20, -4.007148037742134e-21, -9.884602179821434e-23,
  9.236511665096254e-02, -5.880352794749080e-04,  5.143318508731863e-06, -4.755488495443487e-08,  4.257169881825895e-10, -3.722000383050701e-12,  3.372464197362340e-14,
 -1.924032602621398e-16,  3.345062759939686e-18, -2.064488702508800e-20, -5.329664723093099e-22, -1.681336473506861e-23,  4.771822405352948e-02, -3.945624593077385e-04,
  5.191123666120093e-06, -6.223305263292874e-08,  7.059259001348040e-10, -7.527043460982404e-12,  7.288237395651405e-14, -9.686033932767921e-16,  4.249664745140533e-18,
 -6.880169636590930e-20,  2.530978030364085e-21,  3.961821944423547e-23,  1.756765283676038e-02, -1.976669151106531e-04,  3.501231867046119e-06, -5.092560034430561e-08,
  6.975973236821986e-10, -8.910303001089455e-12,  1.042075711452597e-13, -1.474621609347689e-15,  1.146921783282801e-17, -1.576722758042784e-19,  3.561137602800008e-21,
  2.514201682227792e-23,  4.559314617871467e-03, -7.063778411455808e-05,  1.564613666620654e-06, -2.717477156428972e-08,  4.427518878593858e-10, -6.679286495528012e-12,
  9.330031104954268e-14, -1.393649420153895e-15,  1.579133888492048e-17, -2.158426148842035e-19,  3.503775698440212e-21, -1.313081314949947e-23,  8.214852484458073e-04,
 -1.747356728108084e-05,  4.664114147757332e-07, -9.651712369921121e-09,  1.854349052193334e-10, -3.272453596073829e-12,  5.366438230201410e-14, -8.775637195560897e-16,
  1.251599974508903e-17, -1.853441832487789e-19,  2.808722702229904e-21, -3.036363902065387e-23,  1.006607047659999e-04, -2.920776151651056e-06,  9.265610420534775e-08,
 -2.287688118543767e-09,  5.160867591585722e-11, -1.060790967402168e-12,  2.022525297289970e-14, -3.708995093249674e-16,  6.255231856750785e-18, -1.034290354444052e-19,
  1.666383586854145e-21, -2.415173594807360e-23,  8.164138910255743e-06, -3.217424036667532e-07,  1.213460900547108e-08, -3.587211944731966e-10,  9.506117268496987e-12,
 -2.276749642939335e-13,  5.032690934178161e-15, -1.049441694140692e-16,  2.045671300379073e-18, -3.821377280303001e-20,  6.846719984427368e-22, -1.161235751063634e-23,
  4.231955975768682e-07, -2.266706070632670e-08,  1.026922423704314e-09, -3.658833165978923e-11,  1.145345809183799e-12, -3.212378305616378e-14,  8.256566877828337e-16,
 -1.977879233530364e-17,  4.436082412920986e-19, -9.431877114536988e-21,  1.909567823136064e-22, -3.686619832505413e-24,  1.341324580266459e-08, -9.843722749119705e-10,
  5.460577281293287e-11, -2.372491518330090e-12,  8.875350206864931e-14, -2.945035330493091e-15,  8.877195044148984e-17, -2.470296836500430e-18,  6.407954251588078e-20,
 -1.564088120909972e-21,  3.614338461847622e-23, -7.941619556599349e-25,  2.466251821976282e-10, -2.525935855022766e-11,  1.766591633457597e-12, -9.547026466460600e-14,
  4.351404576793445e-15, -1.737559458996637e-16,  6.236346341922971e-18, -2.046664680754969e-19,  6.215643911388331e-21, -1.763202600966208e-22,  4.704977175210088e-24,
 -1.187030133401249e-25,  2.505986538798927e-12, -3.700967965442760e-13,  3.406483256991150e-14, -2.364735788534792e-15,  1.353128406622194e-16, -6.675531212602111e-18,
  2.920692817833064e-19, -1.155015745143723e-20,  4.185008797732552e-22, -1.403640689791098e-23,  4.392468453643350e-25, -1.289688878715296e-26,  1.444547011450659e-14,
 -3.228892857891445e-15,  4.151802363090634e-16, -3.883427492211498e-17,  2.909991180079749e-18, -1.838958036206426e-19,  1.011782982974424e-20, -4.952227878510709e-22,
  2.190036322928015e-23, -8.853487914742890e-25,  3.301745583489291e-26, -1.143083517077017e-27,  7.392459772880226e-17, -2.550933359271888e-17,  4.775350472483527e-18,
 -6.214593687290864e-19,  6.245942082590197e-20, -5.137041553522348e-21,  3.586187981422095e-22, -2.179061149039072e-23,  1.173752801665223e-24, -5.683413027490929e-26,
  2.501091793832691e-27, -1.007918974830864e-28,  1.255590243371790e-01, -6.670865670899249e-04,  3.709703862953872e-06, -2.253484007463418e-08,  1.264126614413480e-10,
 -3.601547178525891e-13,  3.039601274134215e-14,  5.693347362535986e-16,  3.111034018003125e-18, -2.651688870383245e-19, -8.580323673226581e-21, -9.049105966527375e-23,
  9.009181082421222e-02, -5.490609508332075e-04,  4.611210149186766e-06, -4.129658086625757e-08,  3.589934673131825e-10, -2.966031689280142e-12,  2.968616157318975e-14,
 -1.028772507574440e-16,  2.031279397520321e-18, -5.750689151383248e-20, -1.301834803812630e-21, -1.529816983908678e-23,  4.621855919753237e-02, -3.558395130429928e-04,
  4.507411348827635e-06, -5.205649295418171e-08,  5.707525453106458e-10, -6.089451020347461e-12,  4.745332200611913e-14, -8.490459523107676e-16,  4.049781956153539e-18,
  7.049260818013088e-20,  4.428345740838607e-21,  3.778695085862785e-23,  1.682938559218169e-02, -1.719244702013999e-04,  2.951616690877048e-06, -4.106715427634981e-08,
  5.412524917180672e-10, -6.867522995342131e-12,  6.741335173518279e-14, -1.168426373292466e-15,  8.672538552381475e-18,  1.165734783617827e-20,  4.938502767212585e-21,
  2.868092590466897e-23,  4.299889568886963e-03, -5.931425936634408e-05,  1.276972400112599e-06, -2.105008644071301e-08,  3.286655298664935e-10, -4.857477242571885e-12,
  6.037269840390364e-14, -9.863575213140622e-16,  1.045952105599987e-17, -8.156536859642886e-20,  3.301958915231975e-21, -8.981064956598647e-25,  7.583852065981006e-04,
 -1.415967776973884e-05,  3.664384512939876e-07, -7.145980083830225e-09,  1.310853426669263e-10, -2.239559687328177e-12,  3.383799636948628e-14, -5.643681042461428e-16,
  7.599138450546037e-18, -9.387463009338027e-20,  1.880836069032753e-21, -1.442601674655058e-23,  9.030412170826569e-05, -2.276755859508580e-06,  6.953483312874534e-08,
 -1.608466069497126e-09,  3.450953998587738e-11, -6.804149577003935e-13,  1.216371430577970e-14, -2.192441459104413e-16,  3.516726052386837e-18, -5.364878183111868e-20,
  9.124094887593263e-22, -1.173292802912808e-23,  7.047302561483858e-06, -2.396063849972657e-07,  8.611092978938807e-09, -2.373692704193501e-10,  5.955902282462858e-12,
 -1.358586852174404e-13,  2.836509490577938e-15, -5.706509111514550e-17,  1.060970265876188e-18, -1.880361641875815e-20,  3.313244952920432e-22, -5.299640342397502e-24,
  3.465606334533381e-07, -1.593905050902668e-08,  6.796486742932187e-10, -2.248893879910533e-11,  6.632976607621525e-13, -1.761755467518753e-14,  4.284632265736539e-16,
 -9.809427691308432e-18,  2.098322641697497e-19, -4.259482886289789e-21,  8.311978517880462e-23, -1.535337609648622e-24,  1.019814197172518e-08, -6.410909836830034e-10,
  3.303195910733242e-11, -1.327811217607164e-12,  4.656371625226585e-14, -1.456333671710753e-15,  4.149954401421419e-17, -1.098090021959501e-18,  2.713269034921506e-20,
 -6.324799648400880e-22,  1.400911472211764e-23, -2.952170368224807e-25,  1.679766549116737e-10, -1.474514871447408e-11,  9.458548111893507e-13, -4.712471636458422e-14,
  2.004121311469441e-15, -7.515714519225019e-17,  2.545826415468086e-18, -7.923292489334127e-20,  2.289610888792313e-21, -6.199714928949680e-23,  1.583751364993984e-24,
 -3.834077512731295e-26,  1.432061381041663e-12, -1.824057378420893e-13,  1.525998136366717e-14, -9.746637183409499e-16,  5.190952146462088e-17, -2.401891362559367e-18,
  9.916067126259780e-20, -3.719026568071452e-21,  1.283341216144616e-22, -4.114267340279456e-24,  1.234608285973695e-25, -3.486119205732371e-27,  6.055344628639616e-15,
 -1.192483035401701e-15,  1.397693405855399e-16, -1.209763737259802e-17,  8.482296440278591e-19, -5.057128653440326e-20,  2.642245504378040e-21, -1.234749736750878e-22,
  5.237091500048649e-24, -2.038463221868616e-25,  7.344300713197445e-27, -2.463865726657470e-28,  1.761342000009673e-17, -5.704724332425910e-18,  1.013496921047230e-18,
 -1.263000300880918e-19,  1.223915278571582e-20, -9.757938661009033e-22,  6.631728926041141e-23, -3.936597659937563e-24,  2.077454985427440e-25, -9.878895334623937e-27,
  4.278109365034640e-28, -1.699546669347140e-29,  1.229483688611222e-01, -6.384564869227127e-04,  3.451327089000498e-06, -2.052474090533567e-08,  1.278074236001935e-10,
  5.605489407946562e-13,  4.578830419663630e-14,  4.441749620112091e-16, -1.323943280089899e-17, -6.478128450257338e-19, -9.077876955766629e-21,  1.142383025596735e-22,
  8.796634006409261e-02, -5.140601205874687e-04,  4.148279946146516e-06, -3.598941519819396e-08,  3.065926318556861e-10, -2.283084773888979e-12,  2.732662301704596e-14,
 -8.204380034209004e-17, -1.086027804635107e-18, -1.166994737659357e-19, -1.424023818124097e-21,  1.722044869453686e-23,  4.486357085812672e-02, -3.221325820793979e-04,
  3.933685722514550e-06, -4.384466214852096e-08,  4.585169844649442e-10, -5.217574931883103e-12,  2.613404783105699e-14, -6.423417244907512e-16,  1.002521806240709e-17,
  2.625586156911500e-19,  4.498279515432483e-21, -5.617573988358739e-23,  1.618598720804208e-02, -1.501454597844952e-04,  2.506494271276296e-06, -3.342855155054073e-08,
  4.176000851150894e-10, -5.609035754478134e-12,  3.892809866908490e-14, -8.444142163268347e-16,  1.281831216943684e-17,  2.181061607644744e-19,  4.763122516174933e-21,
 -5.760147394454635e-23,  4.081581347067222e-03, -5.002640312733026e-05,  1.052948256060711e-06, -1.649864382858530e-08,  2.439556306942036e-10, -3.703934372938182e-12,
  3.717937318445460e-14, -6.734520398329530e-16,  9.851400728970292e-18,  4.459185758594526e-20,  2.776894325190451e-21, -3.279178356470399e-23,  7.071125957870752e-04,
 -1.153866423583669e-05,  2.919221378023110e-07, -5.367732943545084e-09,  9.326583991338622e-11, -1.592229437295639e-12,  2.102883916975049e-14, -3.619032043017441e-16,
  5.432398318685893e-18, -3.033368421388214e-20,  1.287070446992788e-21, -1.575671884302134e-23,  8.219941848831502e-05, -1.789237656193253e-06,  5.314326432433304e-08,
 -1.151197324375893e-09,  2.338227755015753e-11, -4.509908415068436e-13,  7.354989606373562e-15, -1.314581012324193e-16,  2.135352637819246e-18, -2.565344570180156e-20,
  5.207541847738943e-22, -7.119413419144183e-24,  6.210656536905114e-06, -1.806762771220026e-07,  6.255408991250351e-09, -1.605948464165080e-10,  3.807540524036485e-12,
 -8.366400966100629e-14,  1.628140883290173e-15, -3.178116979726155e-17,  5.756050047430439e-19, -9.240671805105742e-21,  1.663275124042308e-22, -2.595079225404314e-24,
  2.921931181645591e-07, -1.142447582670866e-08,  4.634143753631343e-10, -1.421761649364535e-11,  3.949241835747020e-13, -9.993288255098176e-15,  2.286614742107092e-16,
 -5.018694618758118e-18,  1.030248126016439e-19, -1.972270143756564e-21,  3.749551779215695e-23, -6.656533612883511e-25,  8.076724863304758e-09, -4.298125248700984e-10,
  2.075762093751397e-11, -7.706143211083456e-13,  2.533653786102545e-14, -7.489107220432137e-16,  2.013082392211710e-17, -5.071318291187748e-19,  1.195227431361296e-20,
 -2.653330447008635e-22,  5.646353416064741e-24, -1.141159512868981e-25,  1.211904552451167e-10, -8.991066338581514e-12,  5.321512222011073e-13, -2.439219154604814e-14,
  9.676772684601572e-16, -3.409528727648980e-17,  1.088699694240849e-18, -3.212762568367601e-20,  8.830472626392760e-22, -2.279916148490642e-23,  5.574153183972302e-25,
 -1.293799609766534e-26,  8.885217300563934e-13, -9.594821503305347e-14,  7.301049743911032e-15, -4.276333708447523e-16,  2.115684822680616e-17, -9.165538649127884e-19,
  3.563395141399812e-20, -1.265290085150213e-21,  4.150869970486780e-23, -1.269698601757444e-24,  3.647425433985312e-26, -9.887416601780607e-28,  2.849112395434226e-15,
 -4.834823800390641e-16,  5.126386819904308e-17, -4.077078923598360e-18,  2.659831773222923e-19, -1.488687107129870e-20,  7.353228209676123e-22, -3.267402740532004e-23,
  1.324139173604117e-24, -4.945065456911344e-26,  1.715608722394152e-27, -5.560194186143746e-29,  4.688470789975787e-18, -1.394362786234025e-18,  2.317995143924856e-19,
 -2.736704880696381e-20,  2.535553577409726e-21, -1.946167982475670e-22,  1.280292252086651e-23, -7.388587455614319e-25,  3.804387522463806e-26, -1.770378735072850e-27,
  7.521426649399475e-29, -2.937708454507889e-30,  1.204482549768271e-01, -6.117950377338815e-04,  3.217871916635178e-06, -1.832735689493396e-08,  1.506681576112541e-10,
  1.737156173677896e-12,  4.838023835266216e-14, -4.056534155359257e-16, -4.076322981062221e-17, -7.834067053219229e-19,  5.872870953653313e-21,  5.977518088498814e-22,
  8.597385030794105e-02, -4.825212228777990e-04,  3.744446028440112e-06, -3.141449759017135e-08,  2.672652294480751e-10, -1.662956865422996e-12,  2.384713701524582e-14,
 -1.923580538335421e-16, -5.948015167445193e-18, -1.378718894727778e-19,  9.532925200663178e-22,  9.685802486237582e-23,  4.363481316707793e-02, -2.926506600570828e-04,
  3.448219325644060e-06, -3.731446378178033e-08,  3.592092023067095e-10, -4.760137673505122e-12,  1.426421711404856e-14, -1.437365796747174e-16,  2.160354421989888e-17,
  3.345848001020677e-19, -2.539621010451719e-21, -2.782669234966472e-22,  1.562311819647852e-02, -1.315927209656367e-04,  2.141883998396315e-06, -2.760073410731485e-08,
  3.131215466235742e-10, -4.903743219251627e-12,  2.242568476231216e-14, -2.799394154585732e-16,  2.299831729866413e-17,  3.023667606296242e-19, -2.123180601167492e-21,
 -2.703824263879603e-22,  3.897155627168577e-03, -4.233374018753672e-05,  8.760807999420580e-07, -1.314524589306242e-08,  1.774654986947608e-10, -3.000130495964657e-12,
  2.310757035887899e-14, -3.152321077827792e-16,  1.290172034105611e-17,  1.033045693647277e-19, -5.179359243243087e-22, -1.243173795003329e-22,  6.652535738303339e-04,
 -9.437827743315567e-06,  2.354922327110456e-07, -4.105916247327347e-09,  6.574578736731511e-11, -1.190185175573621e-12,  1.322683496907756e-14, -1.972197819953389e-16,
  5.058720266502297e-18,  2.500499243407007e-21,  2.066750238514336e-22, -3.571719535111505e-23,  7.581341565334926e-05, -1.413617911286356e-06,  4.130390229649913e-08,
 -8.407707108341731e-10,  1.586627101461423e-11, -3.116440802300603e-13,  4.517143961437482e-15, -7.448407464362484e-17,  1.512646269675255e-18, -1.100372283390691e-20,
  2.059182112735139e-22, -7.848927066571677e-24,  5.577142907311990e-06, -1.374206449111920e-07,  4.644709439061278e-09, -1.112059805548657e-10,  2.462537715561119e-12,
 -5.345225616815305e-14,  9.541107907731309e-16, -1.759963035762193e-17,  3.387295507146453e-19, -4.500156615989081e-21,  7.759011751582310e-23, -1.632924732148390e-24,
  2.529631107099000e-07, -8.305652234485224e-09,  3.249699351406480e-10, -9.241405485380213e-12,  2.402352778235211e-13, -5.875676948721827e-15,  1.253918040304973e-16,
 -2.617627182936635e-18,  5.316553275985199e-20, -9.311473482845557e-22,  1.708047719315037e-23, -3.152112153173851e-25,  6.639447382376811e-09, -2.948384641580168e-10,
  1.352176947077234e-11, -4.629546179621347e-13,  1.423043843051674e-14, -4.004282510097450e-16,  1.011163232257666e-17, -2.421304722844102e-19,  5.491212689361774e-21,
 -1.150834580343284e-22,  2.353075795786241e-24, -4.624787737879130e-26,  9.220007407144456e-11, -5.685389728212191e-12,  3.137217934817144e-13, -1.320173850226931e-14,
  4.879610515271314e-16, -1.619651019183571e-17,  4.865904858172870e-19, -1.360996918868275e-20,  3.563374628326520e-22, -8.751845578663685e-24,  2.048005344972417e-25,
 -4.562580693763788e-27,  5.956515121581030e-13, -5.345327929153799e-14,  3.718678397761072e-15, -1.991073822372158e-16,  9.135599932473702e-18, -3.703190427316884e-19,
  1.353302587239025e-20, -4.543413342543131e-22,  1.415303909190976e-23, -4.123610332565456e-25,  1.132503269784477e-26, -2.943173732923943e-28,  1.504160123611993e-15,
 -2.143777934187426e-16,  2.047332791131808e-17, -1.486507307893980e-18,  8.979118565974546e-20, -4.697534272827400e-21,  2.184573621705947e-22, -9.195716642220678e-24,
  3.548189198125616e-25, -1.267122508068915e-26,  4.219898887997166e-28, -1.317301992989287e-29,  1.427099843283826e-18, -3.782447643123516e-19,  5.786724139969212e-20,
 -6.391706386590919e-21,  5.606307231325050e-22, -4.109511350853987e-23,  2.599344588896780e-24, -1.450134806695886e-25,  7.249966401007433e-27, -3.287798330698656e-28,
  1.365382297194862e-29, -5.226595177610869e-31,  1.180512297141265e-01, -5.868877744618764e-04,  3.013741047366498e-06, -1.558245390983140e-08,  1.952406287417467e-10,
  2.591578192222486e-12,  1.518345467442496e-14, -2.056171306242016e-15, -5.717204820345572e-17,  1.035599585721597e-19,  4.030686824827281e-20,  8.233065451465481e-22,
  8.410138858966869e-02, -4.540031909081025e-04,  3.392126643501803e-06, -2.737550288207172e-08,  2.391642233876191e-10, -1.180854913317027e-12,  1.515825894411207e-14,
 -4.449615457660775e-16, -8.983864621032618e-18,  7.699077421957618e-21,  6.678366899577803e-21,  1.410024928398787e-22,  4.251667468510398e-02, -2.667654099986527e-04,
  3.031848336677037e-06, -3.230997050483197e-08,  2.675501447097168e-10, -4.378210632309013e-12,  2.143117587172050e-14,  6.929477664699835e-16,  2.831348258412754e-17,
 -6.882715037347820e-20, -1.843666019005123e-20, -3.769935239160358e-22,  1.512903044328167e-02, -1.157045855924368e-04,  1.837589693076356e-06, -2.334719602027929e-08,
  2.202622172551149e-10, -4.367600097812440e-12,  2.625667711975004e-14,  5.867814583389381e-16,  2.894058367550577e-17, -7.677444995265987e-20, -1.766142458708129e-20,
 -3.724216131083026e-22,  3.740901287679665e-03, -3.591217075414684e-05,  7.334859668951230e-07, -1.075780790566902e-08,  1.225479813551492e-10, -2.501817438632397e-12,
  2.052131786377495e-14,  1.407674683574764e-16,  1.468518604885454e-17, -5.202999739224199e-20, -7.631267610640229e-21, -1.716224873076181e-22,  6.309810815828616e-04,
 -7.734796012198477e-06,  1.917988456414083e-07, -3.228712946023122e-09,  4.476406031927365e-11, -9.206581473548365e-13,  9.976091728640555e-15, -3.577817823159812e-17,
  4.859958052658017e-18, -2.675330699330219e-20, -1.763288010365574e-21, -4.725627501187727e-23,  7.076142035689653e-05, -1.119666626774420e-06,  3.254950115590592e-08,
 -6.314980204714152e-10,  1.057544011136853e-11, -2.231162019755526e-13,  3.056930119964495e-15, -3.154221728631607e-17,  1.175818853181282e-18, -1.026303899848069e-20,
 -1.768937317538982e-22, -8.729545743564695e-24,  5.094171787735900e-06, -1.050049588298761e-07,  3.514984404040197e-09, -7.926082324820124e-11,  1.588325328483995e-12,
 -3.537385811276107e-14,  5.922069040808600e-16, -8.887276972827622e-18,  2.162616100548145e-19, -2.727705844585058e-21,  1.347739664341837e-23, -1.272575489405742e-24,
  2.243193519920844e-07, -6.092115852930862e-09,  2.337268189965893e-10, -6.196054809126728e-12,  1.477562983767541e-13, -3.580419844893199e-15,  7.167606406574488e-17,
 -1.344728404542174e-18,  2.907606732235025e-20, -4.748967701622766e-22,  6.758003986866483e-24, -1.715860056071386e-25,  5.646014821925935e-09, -2.055485819275997e-10,
  9.105331241312911e-12, -2.881417525967875e-13,  8.187970124498620e-15, -2.225143452063370e-16,  5.278709829722419e-18, -1.179070819534568e-19,  2.641960523691152e-21,
 -5.217295688255225e-23,  9.802022897966593e-25, -2.007444315954155e-26,  7.363415818028765e-11, -3.697630277678097e-12,  1.932054902571417e-13, -7.460915805466086e-15,
  2.555474270977187e-16, -8.045773729067478e-18,  2.271287129091806e-19, -5.991001521207883e-21,  1.505156557560260e-22, -3.507185572244500e-24,  7.799374066470633e-26,
 -1.688636928811354e-27,  4.290931120942913e-13, -3.124261929557405e-14,  2.009228827967886e-15, -9.809564441458035e-17,  4.162632937060563e-18, -1.581289366273548e-19,
  5.422342962206331e-21, -1.718159597310892e-22,  5.084041894897967e-24, -1.408241994878789e-25,  3.691377032108387e-27, -9.199377262283044e-29,  8.882081212067825e-16,
 -1.031664548492045e-16,  8.884121792559741e-18, -5.854882276307141e-19,  3.260522431135861e-20, -1.589355010394215e-21,  6.933405549707356e-23, -2.755626472392106e-24,
  1.009286112549045e-25, -3.435893373331610e-27,  1.095211393619119e-28, -3.283995881247567e-30,  5.083562244633361e-19, -1.153920184014721e-19,  1.596265733879969e-20,
 -1.626456388580417e-21,  1.335862501865601e-22, -9.267751393216638e-24,  5.593693686401009e-25, -2.997302524409205e-26,  1.446927057272266e-27, -6.363668297437645e-29,
  2.572441458901997e-30, -9.615449170119135e-32,  1.157507943986402e-01, -5.634687423516200e-04,  2.847207179447998e-06, -1.204728024371061e-08,  2.450446242175338e-10,
  2.074499721185289e-12, -6.486836999223326e-14, -3.456007611998442e-15, -1.768827365994635e-17,  2.192250112571882e-18,  5.429534498960475e-20, -5.241897711516606e-22,
  8.233765892012840e-02, -4.281168390396887e-04,  3.085852105189711e-06, -2.372284263587463e-08,  2.180167300715825e-10, -9.966788246377162e-13, -8.541263046890697e-16,
 -6.661176595874310e-16, -2.705248825910337e-18,  3.608417308381810e-19,  9.407751974459127e-21, -7.494964160131683e-23,  4.149576130329324e-02, -2.439951616041837e-04,
  2.667036694023401e-06, -2.869338187251741e-08,  1.871995697402802e-10, -3.536738218766784e-12,  5.196911985883598e-14,  1.390222120627367e-15,  9.502832752431698e-18,
 -1.021655824746721e-18, -2.463576283509684e-20,  2.487487595497088e-22,  1.469391529992891e-02, -1.020710033354858e-04,  1.575816422603960e-06, -2.048019524488698e-08,
  1.410525773192900e-10, -3.443767152724280e-12,  5.410306073106713e-14,  1.305551871529370e-15,  1.039196516233147e-17, -1.001304069051835e-18, -2.419674546394330e-20,
  2.265515367601105e-22,  3.608213063076115e-03, -3.053094326797492e-05,  6.145982270534056e-07, -9.168321238836035e-09,  7.801435780135342e-11, -1.913071587602296e-12,
  3.026510192809147e-14,  5.093262767199253e-16,  5.879407391923068e-18, -4.605653970550722e-19, -1.086709624012471e-20,  9.314515529542713e-23,  6.028807471460644e-04,
 -6.344522990249839e-06,  1.567859392364356e-07, -2.646825814579485e-09,  2.874899034171016e-11, -6.771477484006415e-13,  1.088879329635051e-14,  8.722395685658809e-17,
  2.222064182157452e-18, -1.268365096215591e-19, -2.749576306483627e-21,  2.032267797872316e-23,  6.675919701848890e-05, -8.870204382977092e-07,  2.585177583591629e-08,
 -4.942321111489922e-10,  6.795533152787372e-12, -1.565035790767490e-13,  2.631313701713913e-15, -1.851094137284397e-18,  6.019378762125906e-19, -2.308810136777275e-20,
 -3.869195381577175e-22,  1.951450903269474e-24,  4.724912779241323e-06, -8.030669660097775e-08,  2.695288684197555e-09, -5.880688083118162e-11,  1.006483372578266e-12,
 -2.345452559837598e-14,  4.256526153724300e-16, -3.531037782856277e-18,  1.162820284682225e-19, -3.069243811077087e-21, -2.217095257891572e-23, -1.118912916049717e-25,
  2.032698765849185e-07, -4.484413746234940e-09,  1.714676133590943e-10, -4.322452532111079e-12,  9.078236491769393e-14, -2.221147699669996e-15,  4.477500284107745e-17,
 -6.486012548188814e-19,  1.530556679847534e-20, -3.245936257655712e-22,  1.570491459996058e-24, -5.856673633348890e-26,  4.950355571074906e-09, -1.446080534678415e-10,
  6.306416168863413e-12, -1.868235647998403e-13,  4.780030187006399e-15, -1.273917186276111e-16,  2.923747288211351e-18, -5.732491827840136e-20,  1.294128825875868e-21,
 -2.663017946441122e-23,  3.819172235000143e-25, -8.241100954760307e-27,  6.145202238294117e-11, -2.451154759701664e-12,  1.237210862306737e-13, -4.411855396394670e-15,
  1.379412060813196e-16, -4.161664824717692e-18,  1.114042862837483e-19, -2.713412901431635e-21,  6.612360724461236e-23, -1.492575905163311e-24,  3.020764060810697e-26,
 -6.455044543683481e-28,  3.301459395233738e-13, -1.894652032837854e-14,  1.146446339228707e-15, -5.107969652181169e-17,  1.990035370365299e-18, -7.117132348107966e-20,
  2.291978469216347e-21, -6.813778126584023e-23,  1.921094424864466e-24, -5.065847274555804e-26,  1.257515224452218e-27, -3.016919766283890e-29,  5.831343025645433e-16,
 -5.326459899818079e-17,  4.173698730411885e-18, -2.485714946229411e-19,  1.270082650012742e-20, -5.761155308424905e-22,  2.350630001920390e-23, -8.791064204089056e-25,
  3.050209361802722e-26, -9.871659104861419e-28,  3.002479222904876e-29, -8.630547692291025e-31,  2.159120351836560e-19, -3.988413091485493e-20,  4.914814579589300e-21,
 -4.551851660612470e-22,  3.460910005882715e-23, -2.251219513364517e-24,  1.285995349956549e-25, -6.571973022084654e-27,  3.044666404924794e-28, -1.291654595666298e-29,
  5.058377527932877e-31, -1.838578751738335e-32,  1.135416565125059e-01, -5.412002629141025e-04,  2.727168907366774e-06, -7.912219650161525e-09,  2.631555477042058e-10,
 -6.215220975698760e-13, -1.551810743280760e-13, -2.428426152683266e-15,  8.819145735699584e-17,  3.182869472117669e-18, -2.163335144168977e-20, -2.744639049243658e-21,
  8.067284393504670e-02, -4.045109718735199e-04,  2.821428816015104e-06, -2.040149772044711e-08,  1.963763401412181e-10, -1.236469821949893e-12, -1.831991137301822e-14,
 -4.859907502662029e-16,  1.514453304810573e-17,  5.480490920519375e-19, -3.011705674446207e-21, -4.658202116587905e-22,  4.056033797970637e-02, -2.239901011400652e-04,
  2.338609118971483e-06, -2.618294138417821e-08,  1.321017952117507e-10, -1.827892767575331e-12,  8.848844288034534e-14,  9.568285919904072e-16, -3.936837233892069e-17,
 -1.459213231534571e-18,  1.041347440205824e-20,  1.255996059404662e-21,  1.430933577133833e-02, -9.041386840608926e-05,  1.341585307796357e-06, -1.869118739364637e-08,
  8.815409168477217e-11, -1.708198437368917e-12,  8.877109649017412e-14,  9.134020422005741e-16, -3.772443932257120e-17, -1.446575048289330e-18,  9.543118492028375e-21,
  1.228577630091427e-21,  3.495252546237869e-03, -2.603564356751556e-05,  5.109466496983539e-07, -8.181709012963164e-09,  4.820674744556829e-11, -1.012276235644863e-12,
  4.415880013042062e-14,  3.650557858711922e-16, -1.620225677295723e-17, -6.666566733002422e-19,  4.055492491937811e-21,  5.534634659933040e-22,  5.798198757458057e-04,
 -5.210395904137726e-06,  1.273854943342862e-07, -2.280072555193021e-09,  1.803828912107644e-11, -3.833672923075038e-13,  1.351009363706452e-14,  6.808188735570809e-17,
 -3.758668207832344e-18, -1.804480639240123e-19,  9.994490391132323e-22,  1.430888352865575e-22,  6.358950601034553e-05, -7.022965465214776e-07,  2.048120666936217e-08,
 -4.071021901844964e-10,  4.300412346613094e-12, -9.266139241003250e-14,  2.705655285815404e-15,  1.657436173994221e-18, -4.313363722681715e-19, -3.068654169499104e-20,
  1.585795971170928e-22,  2.199122295523934e-23,  4.442685145710625e-06, -6.132553956921621e-08,  2.072469878629093e-09, -4.592823567762282e-11,  6.332598034543769e-13,
 -1.411260462573905e-14,  3.611688377695252e-16, -1.722284016975142e-18, -5.779567499158358e-21, -3.436765322520492e-21,  1.922896663187145e-23,  1.936718076068385e-24,
  1.877780509940169e-07, -3.298481649220997e-09,  1.270216931812597e-10, -3.172245392743566e-12,  5.587590625493925e-14, -1.319575357608666e-15,  3.178388609033514e-17,
 -3.361973197798067e-19,  4.513107913953220e-21, -2.710581407882339e-22,  2.150803557549529e-24,  8.137834643055738e-26,  4.460235926355128e-09, -1.019953564963248e-10,
  4.450376300213756e-12, -1.273851622040729e-13,  2.824643649049179e-15, -7.259848501889821e-17,  1.771972258655540e-18, -2.885836379944931e-20,  5.462950499018853e-22,
 -1.608741992699188e-23,  2.026390610657104e-25, -4.092267819606698e-28,  5.333732016411005e-11, -1.641129795293424e-12,  8.168358352175039e-14, -2.747484873753210e-15,
  7.634242485396452e-17, -2.203068200193889e-18,  5.836372872276765e-20, -1.269802075474924e-21,  2.874216998818936e-23, -6.989079199321091e-25,  1.261163817294193e-26,
 -2.104935462339257e-28,  2.694635492799172e-13, -1.177702686038077e-14,  6.857290076114317e-16, -2.818011491238074e-17,  9.919821979146158e-19, -3.350447481034318e-20,
  1.027219270328422e-21, -2.824494868450302e-23,  7.545386178677456e-25, -1.939545077074609e-26,  4.490309331278703e-28, -1.009442948923954e-29,  4.218945626132257e-16,
 -2.906310394783741e-17,  2.110306680367634e-18, -1.136209385652603e-19,  5.282060415695427e-21, -2.231287265897393e-22,  8.516870202059528e-24, -2.980980634068991e-25,
  9.782991063395386e-27, -3.011529170151279e-28,  8.696178458120125e-30, -2.389107658597324e-31,  1.102680131879151e-19, -1.557899531419126e-20,  1.699464954976424e-21,
 -1.410870041766682e-22,  9.815620185883437e-24, -5.933746729029179e-25,  3.181832214153291e-26, -1.539285980813921e-27,  6.800279325244042e-29, -2.766837266863690e-30,
  1.044216799693795e-31, -3.673859989900806e-33,  1.114199868777053e-01, -5.196934663710090e-04,  2.656372908745951e-06, -4.019662057771678e-09,  2.100302978170236e-10,
 -4.749014337704813e-12, -1.690334192431029e-13,  1.819155699742797e-15,  1.578533140163631e-16, -4.377461769873847e-20, -1.279801196749437e-19, -1.129529746001577e-21,
  7.909846510754816e-02, -3.828674517163752e-04,  2.594559726423459e-06, -1.748462484941348e-08,  1.665019742342154e-10, -1.768309530793485e-12, -2.258373685049545e-14,
  2.495056999727207e-16,  2.762267913242353e-17,  1.560188472608327e-20, -2.187740934471022e-20, -2.247999052197205e-22,  3.969985346625525e-02, -2.065040736016244e-04,
  2.036280425700417e-06, -2.424041041086019e-08,  1.180288530524849e-10,  4.320404128213253e-13,  9.095750265452112e-14, -9.532996361158061e-16, -7.104213721169258e-17,
  3.037255887423893e-20,  5.852930465117972e-20,  4.943779414514123e-22,  1.396775654613987e-02, -8.055619821859042e-05,  1.125018009159919e-06, -1.743260383278918e-08,
  7.647586044977332e-11,  5.500059657097551e-13,  9.077096895193112e-14, -9.451959073561583e-16, -6.974591022418036e-17, -2.621677328453452e-21,  5.752310668985620e-20,
  5.203665965778536e-22,  3.398680277391057e-03, -2.232883266739265e-05,  4.169187928358774e-07, -7.512624252189768e-09,  3.899839416142208e-11,  9.176925950434807e-14,
  4.402207499431668e-14, -4.570208627372933e-16, -3.128704036875173e-17, -1.987556859538214e-20,  2.610568160443611e-20,  2.517329402348873e-22,  5.608494795864944e-04,
 -4.296315305459070e-06,  1.015613684131293e-07, -2.034849569154634e-09,  1.367408900795832e-11, -5.524981536188740e-14,  1.288526735326317e-14, -1.355980861491211e-16,
 -7.965574068458871e-18, -1.306196272762540e-20,  6.852529188181988e-21,  7.099764585970359e-23,  6.107857381380030e-05, -5.569360878119788e-07,  1.595904077892066e-08,
 -3.496177760513890e-10,  3.088226615398794e-12, -2.965607607507985e-14,  2.413055048787182e-15, -2.659551177396805e-17, -1.176025594219572e-18, -4.269567172382573e-21,
  1.092560227480660e-21,  1.217880962218412e-23,  4.227270597364085e-06, -4.679656828388720e-08,  1.574286520658201e-09, -3.760128050587935e-11,  4.332225609198779e-13,
 -6.148705181861368e-15,  2.938594014619401e-16, -3.557023355456152e-18, -9.325175438360949e-20, -8.210324537207958e-22,  1.067507280395046e-22,  1.244758042916749e-24,
  1.763945135561617e-07, -2.421129194292953e-09,  9.357389519075209e-11, -2.450931838664003e-12,  3.639891633196783e-14, -6.616277483050610e-16,  2.309101574794347e-17,
 -3.230022289802708e-19, -2.656111555284044e-21, -9.745561019888508e-23,  6.455452720198656e-24,  6.887714205792515e-26,  4.114735817962635e-09, -7.183511009818563e-11,
  3.151811003846750e-12, -9.174146142214654e-14,  1.740640531281681e-15, -3.827061107909909e-17,  1.132983689059237e-18, -1.903142203481900e-20,  1.205993626723331e-22,
 -7.157366696841917e-24,  2.570604574904601e-25,  1.320350557819904e-27,  4.789638763157262e-11, -1.101682827583244e-12,  5.480602581745253e-14, -1.812875917407909e-15,
  4.385839395752728e-17, -1.145195591389884e-18,  3.251374526463214e-20, -6.691463864733193e-22,  1.105274235640021e-23, -3.147831391821069e-25,  7.752005529983230e-27,
 -5.162757382804259e-29,  2.315087377074107e-13, -7.417406359904918e-15,  4.243915393143142e-16, -1.655662113991716e-17,  5.161202144152556e-19, -1.615267739729749e-20,
  4.899406576922243e-22, -1.250791777307033e-23,  2.970400156362734e-25, -7.751579444962915e-27,  1.818989569668551e-28, -3.299520457076362e-30,  3.324293638951444e-16,
 -1.647662357819235e-17,  1.136182438188247e-18, -5.601221920489507e-20,  2.335109005508586e-21, -9.155302893943786e-23,  3.304311032963734e-24, -1.076232486759451e-25,
  3.302571694980343e-27, -9.761472248319911e-29,  2.686652499347718e-30, -6.904402430222772e-32,  6.726922283443763e-20, -6.776125834267236e-21,  6.600038997911164e-22,
 -4.866319149927977e-23,  3.058007696233387e-24, -1.705379149754949e-25,  8.527739508440342e-27, -3.874571953330623e-28,  1.621463801559150e-29, -6.294587809159086e-31,
  2.276681809031360e-32, -7.711381140015898e-34,  1.093834789682586e-01, -4.985868226580579e-04,  2.624522808957061e-06, -1.612225591357470e-09,  8.141980979064800e-11,
 -7.661385677693619e-12, -5.479870043408555e-14,  5.846935111453634e-15,  6.548187067498240e-17, -4.682615518705985e-18, -6.752689831357332e-20,  3.677095027724496e-21,
  7.760723959974215e-02, -3.629078075943332e-04,  2.399476646680582e-06, -1.512885432688773e-08,  1.267772260973656e-10, -2.132330741104593e-12, -4.382117853586712e-15,
  9.690188729472843e-16,  1.233240182521735e-17, -8.034478980847714e-19, -1.264522638652090e-20,  6.236517516544271e-22,  3.890462247041034e-02, -1.913439020393750e-04,
  1.757360054406671e-06, -2.217773572676432e-08,  1.450741567897533e-10,  2.055317288984266e-12,  3.587655648923421e-14, -2.754483160137056e-15, -2.865216150971536e-17,
  2.134088793228393e-18,  3.014244093088892e-20, -1.684061427379174e-21,  1.366223852533502e-02, -7.237047528981102e-05,  9.238796774901840e-07, -1.601600054901361e-08,
  1.058728637783303e-10,  2.174910935713519e-12,  3.628046036447940e-14, -2.728692923817855e-15, -2.888715827396275e-17,  2.093959966714518e-18,  3.086827961660276e-20,
 -1.648223361734478e-21,  3.315480281105986e-03, -1.934299795461582e-05,  3.307410053398381e-07, -6.822883909820686e-09,  4.980209738462477e-11,  8.883662663723730e-13,
  1.857774751048670e-14, -1.264087716761157e-15, -1.324697401277397e-17,  9.451757818824830e-19,  1.460083116655882e-20, -7.439047025544342e-22,  5.451398190599176e-04,
 -3.577761075017693e-06,  7.846910059086806e-08, -1.809897172873431e-09,  1.521045038438200e-11,  1.811569708051959e-13,  5.839450757555997e-15, -3.436026584244227e-16,
 -3.456521309954778e-18,  2.447925711314872e-19,  4.036307975834972e-21, -1.934311670246183e-22,  5.908075346552235e-05, -4.452316156507073e-07,  1.204984322074074e-08,
 -3.021329331590051e-10,  2.992483720780140e-12,  1.524113722047435e-14,  1.181128556044611e-15, -5.792372353977520e-17, -5.249207495210190e-19,  3.775024488550027e-20,
  6.867038861736357e-22, -3.028077357213034e-23,  4.062572148112262e-06, -3.589635054932338e-08,  1.161736354111014e-09, -3.131029646768636e-11,  3.709611879269067e-13,
 -6.248321033289822e-16,  1.542154336758942e-16, -6.149473066769663e-18, -4.309075339622235e-20,  3.382147214254902e-21,  7.243347490913843e-23, -2.843155460757300e-24,
  1.680337864383197e-07, -1.781108359460005e-09,  6.730899951079882e-11, -1.947569972695726e-12,  2.791902592055869e-14, -2.269517191402236e-16,  1.270250909568695e-17,
 -4.118371809667328e-19, -1.327508950442387e-21,  1.599513447907052e-22,  4.707333811837645e-24, -1.563360740955092e-25,  3.871454736725391e-09, -5.060020673960761e-11,
  2.197060695968901e-12, -6.871277305137964e-14,  1.205487821919835e-15, -1.720326942716719e-17,  6.298000416478211e-19, -1.728157966925730e-20,  4.854306989168099e-23,
  2.720228077105721e-24,  1.889544963994801e-25, -4.965703073828478e-27,  4.424363224305093e-11, -7.398175328726358e-13,  3.662750283587670e-14, -1.257740156484013e-15,
  2.740972139602747e-17, -5.581720075452691e-19,  1.742675603147753e-20, -4.414110183171619e-22,  4.733537497691484e-24, -5.481787392904197e-26,  4.860700365721634e-27,
 -9.974685323808711e-29,  2.075414832922997e-13, -4.697531245766436e-15,  2.663832254656214e-16, -1.034685325541985e-17,  2.869043141950086e-19, -7.736408557250179e-21,
  2.394509143275865e-22, -6.299376523137447e-24,  1.209276874022291e-25, -2.665810463779986e-27,  8.393472597537012e-29, -1.651687864815590e-30,  2.811880230019530e-16,
 -9.556106527348780e-18,  6.393784126771147e-19, -2.983517185205028e-20,  1.103228011136122e-21, -3.909836505561003e-23,  1.361639087874875e-24, -4.216445567397473e-26,
  1.167508864096030e-27, -3.250607793171747e-29,  9.039044992888706e-31, -2.184855549522506e-32,  4.793176832263876e-20, -3.201922061981152e-21,  2.850598159327598e-22,
 -1.875202865951891e-23,  1.047843514502513e-24, -5.340834371086809e-26,  2.487353246900154e-27, -1.055097605574199e-28,  4.142017590640668e-30, -1.526811454196539e-31,
  5.281918904702003e-33, -1.710736455866012e-34,  1.074310171894070e-01, -4.776577040457077e-04,  2.607862168552125e-06, -1.548975848452081e-09, -7.117655201778417e-11,
 -6.941081857769531e-12,  1.111966724059676e-13,  5.072044488995658e-15, -1.085974650659528e-16, -3.814533348516990e-18,  1.041035305122057e-19,  2.777334799681847e-21,
  7.619289462352695e-02, -3.444069264959235e-04,  2.228701503158708e-06, -1.343764359154192e-08,  8.538567791299744e-11, -1.896067540181421e-12,  2.357647917402308e-14,
  8.634011037021324e-16, -1.822014746255391e-17, -6.866067254322840e-19,  1.765304041444440e-20,  5.132801240548602e-22,  3.816573916155278e-02, -1.783067991523951e-04,
  1.506588351103547e-06, -1.950804187123499e-08,  1.883273229289426e-10,  1.962661789282830e-12, -4.179063718157503e-14, -2.368133106581293e-15,  5.024330594978659e-17,
  1.716930337361643e-18, -4.765375543953520e-20, -1.243317150587191e-21,  1.338636672134972e-02, -6.571592857223071e-05,  7.433667117547696e-07, -1.395365010374716e-08,
  1.516642036831015e-10,  2.098690120839081e-12, -4.093373927209344e-14, -2.365219012864960e-15,  4.932177731507485e-17,  1.721096107577464e-18, -4.659779790779420e-20,
 -1.264040997906582e-21,  3.242902633468048e-03, -1.700957622449278e-05,  2.542781706935887e-07, -5.872153714753094e-09,  6.905609413015100e-11,  8.953291857675455e-13,
 -1.724188554850631e-14, -1.102089499089610e-15,  2.245058305539172e-17,  7.945452854665664e-19, -2.098894339622213e-20, -5.928931767401829e-22,  5.319529739170224e-04,
 -3.032438028841066e-06,  5.834553099621188e-08, -1.533314526691389e-09,  1.942832340331724e-11,  2.021555445172071e-13, -3.890411478008242e-15, -3.007703153002502e-16,
  5.933900961089682e-18,  2.121116622404622e-19, -5.432151338831338e-21, -1.618708848087157e-22,  5.747085122051948e-05, -3.624909384101473e-07,  8.725023565794769e-09,
 -2.508426252569565e-10,  3.445384811717126e-12,  2.360087397619888e-14, -4.508230669422597e-16, -5.064726568556140e-17,  9.578950052387860e-19,  3.417517846845116e-20,
 -8.408041102495610e-22, -2.698610754104237e-23,  3.935337426211017e-06, -2.800439230740825e-08,  8.217008182812902e-10, -2.533355652705270e-11,  3.812522472983846e-13,
  9.799292793954021e-16, -1.660684191872463e-17, -5.305119288147447e-18,  9.526397353841953e-20,  3.283934029294381e-21, -7.665317271077866e-23, -2.744877335140698e-24,
  1.618486594920556e-07, -1.328782646048270e-09,  4.651150180397441e-11, -1.524542906264963e-12,  2.549582507381560e-14, -5.903257454002536e-17,  1.610268936146058e-18,
 -3.417823817236959e-19,  5.816540751660779e-21,  1.782582722419468e-22, -3.870896121095085e-24, -1.660394549740299e-25,  3.699418888916249e-09, -3.601565352784877e-11,
  1.479101824366541e-12, -5.151601887288751e-14,  9.748218496583441e-16, -7.588759342236125e-18,  1.898794014552215e-19, -1.321346706760882e-20,  2.180992048755870e-22,
  4.781259780791277e-24, -9.204711921359347e-26, -5.732389138736946e-27,  4.178438263611717e-11, -5.004340333915838e-13,  2.386040278409759e-14, -8.896739511021803e-16,
  1.951244016633549e-17, -2.718441416472534e-19,  7.103263746288328e-21, -2.936912457051261e-22,  5.043857372882238e-24,  3.660714583065218e-26, -3.718912177908178e-28,
 -1.088014368862104e-28,  1.923240230884324e-13, -2.995076243593368e-15,  1.655222197729385e-16, -6.735003834347170e-18,  1.773143782880587e-19, -3.737805496093212e-21,
  1.066462769790611e-22, -3.452655917287112e-24,  6.889632360274573e-26, -6.487005938421131e-28,  2.016174634134793e-29, -1.172858952626541e-30,  2.512838848774532e-16,
 -5.622709066110086e-18,  3.662730424144356e-19, -1.700086132897549e-20,  5.704322581676853e-22, -1.723662877449282e-23,  5.686648993495623e-25, -1.810192905192891e-26,
  4.646866367398423e-28, -1.053401278787962e-29,  2.896542667348562e-31, -8.427243222711876e-33,  3.857677023045605e-20, -1.600716655252419e-21,  1.336719741054314e-22,
 -8.076507710194439e-24,  3.975337024278375e-25, -1.810361911916090e-26,  7.854474655256174e-28, -3.137057945183165e-29,  1.143868490501204e-30, -3.932035260828269e-32,
  1.302200445220205e-33, -4.076138793137042e-35,  1.055619546433949e-01, -4.568979195949315e-04,  2.578442109194084e-06, -3.613459211268217e-09, -1.742565668075070e-10,
 -3.054724049296074e-12,  1.905917885588324e-13,  3.522818845765798e-16, -1.553224906765563e-16,  1.270099661399198e-18,  1.129124892415964e-19, -2.147236872693257e-21,
  7.484993416370228e-02, -3.272017435983072e-04,  2.074514064239103e-06, -1.233730343776166e-08,  5.466390277166224e-11, -1.123171156044432e-12,  3.702434405788321e-14,
  4.967462236182969e-17, -2.718823668385636e-17,  2.049291673132489e-19,  2.029162099422838e-20, -3.635126561343400e-22,  3.747521045403911e-02, -1.671367206777079e-04,
  1.291637678136826e-06, -1.625396357686110e-08,  2.133069206331769e-10,  3.877332930916416e-13, -7.933931504626220e-14, -2.052318599525714e-16,  7.083925826013124e-17,
 -5.909634505919525e-19, -5.091544514427978e-20,  9.836693263490859e-22,  1.313439828670349e-02, -6.039477084518497e-05,  5.916424191278896e-07, -1.126332778125538e-08,
  1.795608886265192e-10,  5.423500203427504e-13, -7.874585610789144e-14, -2.235198911852281e-16,  7.054217910035094e-17, -5.688580090546443e-19, -5.107759728866579e-20,
  9.616147800818691e-22,  3.178514568087176e-03, -1.523726132998349e-05,  1.909352560000398e-07, -4.655244498563351e-09,  8.083260550071152e-11,  2.121131955575851e-13,
 -3.510300352415090e-14, -1.205807475444406e-16,  3.249154416504598e-17, -2.529770212747998e-19, -2.362838316513714e-20,  4.332041603614829e-22,  5.206480273113463e-04,
 -2.633726442277069e-06,  4.192113430228476e-08, -1.197593371240026e-09,  2.199010665967138e-11,  3.448373397238021e-14, -8.861597675619989e-15, -3.970869978398303e-17,
  8.690123441686428e-18, -6.469517770842405e-20, -6.334613382947110e-21,  1.122188839252763e-22,  5.614278674943280e-05, -3.037640953876208e-07,  6.058200358660824e-09,
 -1.929361302673144e-10,  3.716072071131069e-12,  8.863759209161288e-17, -1.310819725526002e-15, -8.349717356301850e-18,  1.415755459435884e-18, -9.957051522671283e-21,
 -1.029642750873488e-21,  1.742014236306907e-23,  3.834689636237129e-06, -2.254196851560169e-08,  5.547544457994928e-10, -1.914154082463051e-11,  3.869849775821947e-13,
 -7.731169807897223e-16, -1.099282244374096e-16, -1.119325599103812e-18,  1.405838058358308e-19, -9.247502377663298e-22, -1.008490834588856e-22,  1.601866578837809e-24,
  1.571715193521040e-07, -1.023024305963570e-09,  3.062458699357513e-11, -1.126767368651804e-12,  2.405551855476317e-14, -1.096115628530851e-16, -4.665123917421033e-18,
 -9.306167671573764e-20,  8.319830988187812e-21, -5.149896986094318e-23, -5.727857219805503e-24,  8.308243036924349e-26,  3.575467150887451e-09, -2.640094336398782e-11,
  9.499801965858573e-13, -3.699536651615742e-14,  8.432748381883804e-16, -6.559087396605362e-18, -6.383660017186941e-20, -4.559813876215108e-21,  2.825509187100731e-22,
 -1.751442892900782e-24, -1.745087122042722e-25,  2.184981173338719e-27,  4.010380624956863e-11, -3.473133030186563e-13,  1.490127601762630e-14, -6.141621460087580e-16,
  1.521265554397205e-17, -1.808893361760106e-19,  1.272429959760497e-21, -1.214701801484446e-22,  5.247946934978739e-24, -3.897520037860984e-26, -2.420133396613491e-27,
  2.143156205805462e-29,  1.825417713313493e-13, -1.950872940466275e-15,  9.962832886921639e-17, -4.385582557537450e-18,  1.215318330926701e-19, -2.107459223802973e-21,
  3.793568389574123e-23, -1.549593257072950e-24,  5.030814885474771e-26, -5.720764847812194e-28, -8.146309335045262e-30, -8.183185873445648e-32,  2.335510114719995e-16,
 -3.375536772387651e-18,  2.076435253019764e-19, -1.003619522335959e-20,  3.285615707693255e-22, -8.276617770276166e-24,  2.253586512478523e-25, -7.660628887078796e-27,
  2.238235808115184e-28, -4.309402762305132e-30,  6.607308819453115e-32, -2.305336565632767e-33,  3.382209059419184e-20, -8.329767445751886e-22,  6.561903727495394e-23,
 -3.826361819648461e-24,  1.697211855895373e-25, -6.677146047505647e-27,  2.621056753958606e-28, -1.007183865552392e-29,  3.506717073439944e-31, -1.097363910519090e-32,
  3.313161562735193e-34, -1.014188404534307e-35,  1.037752723882861e-01, -4.364942767218429e-04,  2.517127468368351e-06, -6.647734206828886e-09, -1.914370835242676e-10,
  1.144230671213203e-12,  1.426830028718284e-13, -3.239171759994957e-15, -5.656808159627985e-17,  3.381411873980795e-18, -9.223048277516323e-21, -2.460870967104441e-21,
  7.357340090934436e-02, -3.111843510013320e-04,  1.931126577702602e-06, -1.159526940373903e-08,  4.073726126464524e-11, -3.047192934074264e-13,  2.824033310422176e-14,
 -5.845139145344550e-16, -1.011308712420812e-17,  5.963270372315848e-19, -1.248151065302270e-21, -4.447775322950353e-22,  3.682617632210645e-02, -1.575258650584963e-04,
  1.116993317919391e-06, -1.288018989272215e-08,  2.027517566957291e-10, -1.360469960495944e-12, -5.876859179571726e-14,  1.430373242200637e-15,  2.576846543900471e-17,
 -1.534604397339286e-18,  4.451177858325837e-21,  1.108234499060812e-21,  1.290149867487465e-02, -5.615326656768498e-05,  4.737501200485024e-07, -8.404162815575661e-09,
  1.721962972243667e-10, -1.198175009838320e-12, -5.871772974173432e-14,  1.412740502382238e-15,  2.600450697278875e-17, -1.528813734129931e-18,  4.015339270006611e-21,
  1.114939453076559e-21,  3.120297781086394e-03, -1.391121719151587e-05,  1.428255753024721e-07, -3.372956440335303e-09,  7.692791060905088e-11, -5.672229843375451e-13,
 -2.633184725270025e-14,  6.369404629989219e-16,  1.216922704700330e-17, -7.031247347834370e-19,  1.654326790132737e-21,  5.173749953570511e-22,  5.107012616083871e-04,
 -2.349882923843328e-06,  2.964662941074158e-08, -8.516449673687831e-10,  2.061075522635429e-11, -1.637260335599845e-13, -6.710666477251564e-15,  1.642655866914438e-16,
  3.325840071998927e-18, -1.873941978940579e-19,  3.768975370012253e-22,  1.392983240878867e-22,  5.501141152588767e-05, -2.635596686103138e-07,  4.094221610492045e-09,
 -1.351681707549237e-10,  3.408472202106877e-12, -2.962722540606298e-14, -1.010114885793668e-15,  2.517821668802700e-17,  5.580724037497950e-19, -3.031270438592335e-20,
  4.796350668898290e-23,  2.278403520471744e-23,  3.752088933186233e-06, -1.891959132048418e-08,  3.612234709818643e-10, -1.321897076191993e-11,  3.450100915262781e-13,
 -3.333467423249509e-15, -8.782534078743589e-17,  2.248553075717145e-18,  5.767223264883553e-20, -2.968517823387162e-21,  3.154614960353675e-24,  2.253820670683396e-24,
  1.534927461857100e-07, -8.257777944000808e-10,  1.931946557388457e-11, -7.658806322618291e-13,  2.067577381660812e-14, -2.258233277072142e-16, -4.082600343524299e-18,
  1.090725604820007e-19,  3.596373046420371e-21, -1.710138269587412e-22,  8.401849244036985e-26,  1.302814712826189e-25,  3.482561226093085e-09, -2.035816403300416e-11,
  5.823146889221145e-13, -2.466186348227177e-14,  6.913086991330314e-16, -8.701515965749089e-18, -8.245365991874702e-20,  2.405577141355852e-21,  1.301342298970528e-22,
 -5.513006539914098e-24,  2.558539117111614e-28,  4.118982023051294e-27,  3.891178442854361e-11, -2.537136381299345e-13,  8.875346786936507e-15, -3.988802642857878e-16,
  1.171514100207530e-17, -1.740744784569800e-19, -1.026050532208369e-22,  8.846074896793724e-24,  2.570304247584401e-24, -9.278956540598850e-26,  3.217682571507998e-29,
  6.325157456883685e-29,  1.760418037322133e-13, -1.334240421568006e-15,  5.740470649662534e-17, -2.740543083421130e-18,  8.582423049577599e-20, -1.556920080932043e-21,
  1.357406302097353e-23, -3.245156789957712e-25,  2.511460344371505e-26, -7.521839722155515e-28,  2.388264864833396e-30,  3.638241863752143e-31,  2.227200182608755e-16,
 -2.117737263650356e-18,  1.140725213434847e-19, -5.869656615737055e-21,  2.033697690307098e-22, -4.761411018855547e-24,  9.062605833530214e-26, -2.603792967134534e-27,
  1.013649442558626e-28, -2.703200758233618e-30,  3.158063465436379e-32,  9.122160533254661e-35,  3.130338739976757e-20, -4.538516324657016e-22,  3.248040987308146e-23,
 -1.914372766767059e-24,  8.151998008395209e-26, -2.794010087221873e-27,  9.200605590788803e-29, -3.283928509634341e-30,  1.162795153899776e-31, -3.569789357652651e-33,
  9.365420400232028e-35, -2.409552762052193e-36,  1.020689941981939e-01, -4.167256342774551e-04,  2.420244490725951e-06, -9.374729835980164e-09, -1.422586855913067e-10,
  3.381197898245526e-12,  4.342352722911197e-14, -3.340699016686679e-15,  3.918964908599457e-17,  1.598748231525048e-18, -6.081307959339024e-20,  7.536713934201475e-23,
  7.235869558807335e-02, -2.962810841417968e-04,  1.795796041200084e-06, -1.096138134967094e-08,  3.998615421177440e-11,  1.587662820446609e-13,  1.031760263454004e-14,
 -6.048660758334341e-16,  6.926503114192496e-18,  2.873552237921483e-19, -1.079269811568534e-20,  7.282598075255922e-24,  3.621304045161444e-02, -1.491555127295035e-04,
  9.807889303482386e-07, -9.915803024081712e-09,  1.649579575105291e-10, -2.244951343631754e-12, -1.477894267146797e-14,  1.480811572435028e-15, -1.759043745715210e-17,
 -7.223088573353116e-19,  2.753300744270623e-20, -3.832501408414517e-23,  1.268389007678759e-02, -5.272207525340597e-05,  3.884316443628519e-07, -5.902780867619650e-09,
  1.376254593615481e-10, -2.086416845909275e-12, -1.510451845178155e-14,  1.471438420466318e-15, -1.736719170386454e-17, -7.261262412781725e-19,  2.748553087189604e-20,
 -3.142281745153409e-23,  3.066709938781306e-03, -1.291064305494076e-05,  1.092674284037464e-07, -2.260634311159111e-09,  6.084129680338947e-11, -9.631651281062321e-13,
 -6.546121590960619e-15,  6.695936950360713e-16, -7.861944501255599e-18, -3.371646133233958e-19,  1.266001102221496e-20, -1.130579587378156e-23,  5.017188759710298e-04,
 -2.148280063813216e-06,  2.127374278228795e-08, -5.551163244430454e-10,  1.613514031040732e-11, -2.634384956293049e-13, -1.556891665449494e-15,  1.752553924753775e-16,
 -2.041530744629968e-18, -9.098586077333436e-20,  3.378486975512824e-21, -1.951070912608735e-24,  5.401364789221869e-05, -2.364191606105411e-07,  2.776311261251474e-09,
 -8.642660256263070e-11,  2.636939420054612e-12, -4.434555201942737e-14, -2.070215617805990e-16,  2.752465968332925e-17, -3.162229514270433e-19, -1.496299872640604e-20,
  5.468636707712235e-22, -9.479694311286620e-26,  3.681310510713611e-06, -1.657616509147872e-08,  2.332105709342440e-10, -8.322752482500391e-12,  2.630378700382475e-13,
 -4.570951197255792e-15, -1.397520280960843e-17,  2.565778290784388e-18, -2.871535454310931e-20, -1.497679022418975e-21,  5.349512021869194e-23,  1.804131962724605e-26,
  1.504479900346327e-07, -7.027325104836006e-10,  1.195072959640720e-11, -4.753220207333110e-13,  1.547080261572025e-14, -2.795772150613578e-16, -2.832164490710132e-19,
  1.354725849672190e-19, -1.435326098944328e-21, -8.876188331821095e-23,  3.064896467664513e-24,  2.937188070580382e-27,  3.408818618328050e-09, -1.670916475800478e-11,
  3.467246264081249e-13, -1.507160468370677e-14,  5.046245080320675e-16, -9.577189761867731e-18,  1.513898859104458e-20,  3.689664079094390e-21, -3.402859209973959e-23,
 -2.962659794683894e-24,  9.722045201708389e-26,  1.586882899096146e-28,  3.801277035924341e-11, -1.989350978131828e-13,  5.098662981978039e-15, -2.392107654627799e-16,
  8.264447813070948e-18, -1.672287120706280e-19,  8.235352554259426e-22,  4.246910501305781e-23, -2.136382162439211e-25, -5.162067379376356e-26,  1.569048213354766e-27,
  3.225216171140519e-30,  1.714450053095170e-13, -9.854659459599506e-16,  3.178190161391967e-17, -1.600525848473193e-18,  5.757545689597371e-20, -1.273025920803841e-21,
  1.196042069849970e-23,  9.126233312179940e-26,  2.905636976966943e-27, -4.204166645496150e-28,  1.148839876222195e-29,  1.161031193353775e-32,  2.156975323810172e-16,
 -1.438153610598459e-18,  6.034622121621053e-20, -3.278647272944971e-21,  1.255317451838469e-22, -3.175657949622725e-24,  5.030263159318681e-26, -6.626922099581525e-28,
  2.803389179884929e-29, -1.352143346551536e-30,  3.362707781013729e-32, -1.776329609934798e-34,  2.988870338620339e-20, -2.673213230148833e-22,  1.580835789292521e-23,
 -9.621185906067798e-25,  4.202269172760113e-26, -1.365923649014044e-27,  3.701918175552154e-29, -1.056932745408869e-30,  3.644097812318871e-32, -1.245358502649545e-33,
  3.435059435851665e-35, -7.240912044080564e-37,  1.004400555274682e-01, -3.978469981066805e-04,  2.296426312610806e-06, -1.108198548426040e-08, -7.089071587184184e-11,
  3.479706378917747e-12, -2.707228058288425e-14, -1.600343146912576e-15,  5.788112211948630e-17, -3.478120333788758e-19, -3.025638888171688e-20,  9.505616651443233e-22,
  7.120148667385917e-02, -2.824296835679803e-04,  1.668232063684916e-06, -1.028795985937633e-08,  4.442537261433838e-11,  2.348963094860853e-13, -2.524450411593454e-15,
 -2.951912162421452e-16,  1.033388820741950e-17, -6.085628039210977e-20, -5.452973382888684e-21,  1.698792462275273e-22,  3.563141618861875e-02, -1.417437643060414e-04,
  8.761264026707452e-07, -7.642222128345773e-09,  1.194664565842431e-10, -2.182457483252012e-12,  1.632583720829535e-14,  6.983819481865679e-16, -2.602549414407388e-17,
  1.571376561533466e-19,  1.364365048164275e-20, -4.294773723346081e-22,  1.247881665487700e-02, -4.986375666945409e-05,  3.294045078015900e-07, -4.041655340203987e-09,
  9.520887616980990e-11, -2.034207236858517e-12,  1.581721626115609e-14,  6.940236776013461e-16, -2.592442934695174e-17,  1.549343957026117e-19,  1.371646517614065e-20,
 -4.299745326596991e-22,  3.016665235874405e-03, -1.212995553779724e-05,  8.733318155955204e-08, -1.444063374188029e-09,  4.134334882738228e-11, -9.315797223019899e-13,
  7.516265180523811e-15,  3.145432660954325e-16, -1.187959284909166e-17,  7.012754799419964e-20,  6.363760913695416e-21, -1.985854352761846e-22,  4.934296074397668e-04,
 -2.000752926879567e-06,  1.598504709827030e-08, -3.396286620202397e-10,  1.084248911229921e-11, -2.514302358108545e-13,  2.119937904965809e-15,  8.179792979027726e-17,
 -3.142793357442163e-18,  1.820618172730793e-20,  1.714080325693417e-21, -5.316369576976874e-23,  5.310674678111878e-05, -2.177078593779147e-07,  1.962851151930514e-09,
 -5.136428333589085e-11,  1.755281007234750e-12, -4.156148119910242e-14,  3.697060016575503e-16,  1.273037302091590e-17, -5.014401227749674e-19,  2.817139824017492e-21,
  2.808445668375919e-22, -8.637098136523870e-24,  3.618196524253605e-06, -1.504538068553206e-08,  1.555744558803387e-10, -4.841660630470784e-12,  1.733882898800659e-13,
 -4.183629602910400e-15,  3.971303520500544e-17,  1.171681986036962e-18, -4.786581762540425e-20,  2.549984742733205e-22,  2.791317242711456e-23, -8.482027904260387e-25,
  1.477975319168815e-07, -6.261555117793380e-10,  7.549578214172768e-12, -2.717241925991186e-13,  1.008219538670597e-14, -2.481770114993576e-16,  2.548707432083934e-18,
  6.073515122623966e-20, -2.625169735899192e-21,  1.263072965616159e-23,  1.632552238056567e-24, -4.875423487426469e-26,  3.346559053777008e-09, -1.453581416727362e-11,
  2.081407412995388e-13, -8.478312603227078e-15,  3.241239645773932e-16, -8.169553780721300e-18,  9.233940448355916e-20,  1.606679011354899e-21, -7.655776129320994e-23,
  2.906381146275192e-25,  5.314034356016174e-26, -1.546459364817427e-27,  3.728327807380511e-11, -1.676253042461260e-13,  2.915660193105752e-15, -1.322896904549198e-16,
  5.204114734058112e-18, -1.352600444416151e-19,  1.721345071721695e-21,  1.745522332863354e-23, -1.030004177879444e-24,  1.442689731639472e-27,  8.822202060606917e-28,
 -2.468106934123647e-29,  1.679097030146104e-13, -7.942045672797037e-16,  1.731565901173486e-17, -8.664969358113164e-19,  3.519869536828679e-20, -9.556995098404695e-22,
  1.415271077453732e-23,  2.630065153125044e-26, -4.634890453214118e-27, -3.305870133631331e-29,  6.542584657712665e-30, -1.725167263220946e-31,  2.107036258819754e-16,
 -1.083040759175197e-18,  3.115611710294561e-20, -1.717624023073769e-21,  7.295337626703715e-23, -2.125923845592491e-24,  3.870905009117100e-26, -3.084253115406003e-28,
  4.736194555810428e-31, -2.874318457706006e-31,  1.771056340711729e-32, -4.358853288897373e-34,  2.901297396698598e-20, -1.774104727344730e-22,  7.529195772462301e-24,
 -4.681700187664903e-25,  2.172701437735744e-26, -7.341271474502150e-28,  1.858825353146653e-29, -3.957766506285425e-31,  1.006139791744846e-32, -3.621165805565595e-34,
  1.261954155419310e-35, -3.258335229810454e-37,  };
  int offset = -14;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 14;
    if (std::isnan(t)) {
      fill_n(rr+offset, 14, 0.5);
      fill_n(ww+offset, 14, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 14; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=14; ++j) {
        const int boxof = it*168+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
