//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_40.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot40(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[40] = {1.532566333150724e-02,1.379660017410287e-01,3.834338413928863e-01,7.521050835315969e-01,1.244547551113196e+00,
    1.861525845317158e+00,2.604007976597420e+00,3.473173911352792e+00,4.470426220642336e+00,5.597403070341604e+00,6.855993855270501e+00,8.248357856369756e+00,
    9.776946394184975e+00,1.144452906931765e+01,1.325422482860261e+01,1.520953878471803e+01,1.731440596067107e+01,1.957324344853186e+01,2.199101289125942e+01,
    2.457329575657723e+01,2.732638462934105e+01,3.025739478733612e+01,3.337440177041390e+01,3.668661269614475e+01,4.020458201618327e+01,4.394048672461555e+01,
    4.790848250650809e+01,5.212517227328459e+01,5.661023427257749e+01,6.138728263943344e+01,6.648507669810708e+01,7.193927199441563e+01,7.779504829211943e+01,
    8.411123004209786e+01,9.096710928165746e+01,9.847456447306584e+01,1.068017050462992e+02,1.162255725808030e+02,1.272766232323530e+02,1.413213000323780e+02
    };
  constexpr double aw[40] = {2.438358538072127e-01,2.157749462743306e-01,1.689379692759015e-01,1.169807338042997e-01,7.160074769184323e-02,
    3.870859991483797e-02,1.846575115442782e-02,7.764039405399679e-03,2.873197533089709e-03,9.343176869611799e-04,2.664778866933501e-04,6.651741241815240e-05,
    1.449644419112967e-05,2.750724627401225e-06,4.530535565861284e-07,6.454462950119771e-08,7.922923289150186e-09,8.343055926086519e-10,7.499719914657961e-11,
    5.723279718501904e-12,3.684849820159061e-13,1.987520834698484e-14,8.909461040666795e-16,3.289162014364627e-17,9.896528989619841e-19,2.397840275617894e-20,
    4.613471074553798e-22,6.934119819528937e-24,7.985187198172654e-26,6.883457043633996e-28,4.317817343022007e-30,1.902990610032016e-32,5.637192779477887e-35,
    1.059514692827928e-37,1.169207699819791e-40,6.792433016154473e-44,1.764205704338837e-47,1.567156493775333e-51,2.862184585732656e-56,2.955774603297982e-62
    };
  constexpr double x[15360] = {  7.520637480269354e-04, -4.640645665053360e-06,  2.146833645343528e-08, -8.823748052175707e-11,  3.397864457199843e-13,
 -1.255180670972599e-15,  4.503901553531340e-18, -1.581539150924483e-20,  5.460526077028441e-23, -1.859687033016193e-25,  6.261275518521060e-28, -2.087360301892404e-30,
  6.761952041738006e-03, -4.160105708964155e-05,  1.913071291867909e-07, -7.784702253688065e-10,  2.952769088809497e-12, -1.067664199757103e-14,  3.721568939535535e-17,
 -1.257981732888275e-19,  4.135667040919875e-22, -1.323543967693355e-24,  4.120238584655877e-27, -1.244539142775437e-29,  1.874645138004542e-02, -1.146473906185071e-04,
  5.209215631045064e-07, -2.077087736387292e-09,  7.635972584572775e-12, -2.638183231136039e-14,  8.623308735910061e-17, -2.664363997425959e-19,  7.717334865412680e-22,
 -2.054214017669827e-24,  4.793860508106729e-27, -8.487129493696544e-30,  3.663519164445441e-02, -2.220507250483620e-04,  9.907184242663919e-07, -3.828434664128463e-09,
  1.339156618088035e-11, -4.286651529684501e-14,  1.245477488822685e-16, -3.178234091905494e-19,  6.445164186468321e-22, -6.032639606892822e-25, -3.122159848356074e-27,
  2.546576534116925e-29,  6.032307814084602e-02, -3.612673961244949e-04,  1.572613503573899e-06, -5.818382167985523e-09,  1.892894531691757e-11, -5.363149940138467e-14,
  1.243483117917379e-16, -1.806504647080005e-19, -2.372951602842093e-22,  3.332893679488832e-24, -1.719551489056150e-26,  6.544111459228864e-29,  8.967084286677732e-02,
 -5.289974720195499e-04,  2.231523718613048e-06, -7.795527280444473e-09,  2.287732583093808e-11, -5.284874799439526e-14,  6.772747216927030e-17,  1.664351494750373e-19,
 -1.675599594460201e-21,  7.758838186473010e-24, -2.565886211471215e-26,  5.809157273347287e-29,  1.245057773191451e-01, -7.212607666432249e-04,  2.927236096486317e-06,
 -9.496277593484610e-09,  2.401661631694221e-11, -3.694619114755174e-14, -4.515762858396128e-17,  6.390884323650330e-19, -2.999112133638531e-21,  9.191566982275642e-24,
 -1.532831053144025e-26, -2.799024520408237e-29,  1.646226448898184e-01, -9.334887597356315e-04,  3.616557830992984e-06, -1.067146705069386e-08,  2.149145650315740e-11,
 -5.745452565878002e-15, -1.932610544946698e-16,  1.064036575199950e-18, -3.340425845320222e-21,  4.828358222376176e-24,  1.635884877751619e-26, -1.537987436926729e-28,
  2.097847703430427e-01, -1.160630439361672e-03,  4.255636687960403e-06, -1.111198781131819e-08,  1.497532902167676e-11,  3.712415841787529e-14, -3.384256420817066e-16,
  1.237841182374106e-18, -2.084032862502237e-21, -5.181262391968010e-24,  5.459225419783648e-26, -2.165472048503669e-28,  2.597253032726209e-01, -1.397269764828993e-03,
  4.802331519393919e-06, -1.067099199000991e-08,  4.758545608243480e-12,  8.466144010222721e-14, -4.350719838227873e-16,  1.007754509563532e-18,  7.299758240073016e-22,
 -1.687880732531049e-23,  7.274373960100792e-26, -1.227843452443767e-28,  3.141486517925266e-01, -1.637752172751679e-03,  5.218509092097732e-06, -9.280511818819996e-09,
 -8.255256540359881e-12,  1.277235611708313e-13, -4.432789460504298e-16,  3.441877356080881e-19,  4.264801082459234e-21, -2.390419785086438e-23,  4.895760011210584e-26,
  1.210799774268800e-28,  3.727320820162182e-01, -1.876317322144072e-03,  5.472146100579229e-06, -6.960843500759420e-09, -2.264620583228181e-11,  1.568210303666752e-13,
 -3.415716119905189e-16, -6.250446479857342e-19,  7.120470452013403e-21, -2.072709086835624e-23, -1.622319550236128e-26,  3.782985003939598e-28,  4.351274781232730e-01,
 -2.107235101725584e-03,  5.539124088468700e-06, -3.821696328476316e-09, -3.665715567086779e-11,  1.641171072360469e-13, -1.355961708624565e-16, -1.636303156344767e-18,
  7.882235150680517e-21, -6.075252938447889e-24, -9.392780423451419e-26,  4.541605259018113e-28,  5.009632569943248e-01, -2.324941809095386e-03,  5.404619720553878e-06,
 -5.486698230525282e-11, -4.843042217704070e-11,  1.452135118045683e-13,  1.401681402380871e-16, -2.365299189457716e-18,  5.764617536052813e-21,  1.542802348405123e-23,
 -1.393773382959815e-25,  2.354666551438693e-28,  5.698464305156543e-01, -2.524173361375409e-03,  5.064012808734819e-06,  4.081008658765330e-09, -5.626911319807600e-11,
  1.003332326044315e-13,  4.286680112281122e-16, -2.533283801357643e-18,  1.062179706890300e-21,  3.464056069550895e-23, -1.175708908068071e-25, -2.017126378538989e-28,
  6.413648077140975e-01, -2.700092413677216e-03,  4.523258804224107e-06,  8.282319935799438e-09, -5.888543330114448e-11,  3.462336323564063e-14,  6.632940540029039e-16,
 -2.008368641878263e-18, -4.821935998959789e-21,  4.195506985094872e-23, -2.727398374879670e-26, -6.075685228724024e-28,  7.150893278842972e-01, -2.848406347590511e-03,
  3.798699985694976e-06,  1.222701115229919e-08, -5.559934023681773e-11, -4.252496449844785e-14,  7.844674896459879e-16, -8.652091656273395e-19, -9.827291471375519e-21,
  3.215669511378009e-23,  9.264490257189793e-26, -7.070319988324548e-28,  7.905765148192169e-01, -2.965473247828691e-03,  2.916318960279206e-06,  1.560335285173141e-08,
 -4.645731764081338e-11, -1.190411513842513e-13,  7.554415406430398e-16,  6.211983013756493e-19, -1.201358284645779e-20,  7.570738413644696e-24,  1.809227226141186e-25,
 -3.897656034668373e-28,  8.673710411592630e-01, -3.048393210788937e-03,  1.910467871036169e-06,  1.813827791712639e-08, -3.225200588821856e-11, -1.823388328121167e-13,
  5.729769498228982e-16,  2.049822566299957e-18, -1.035366494410966e-20, -2.232400087645767e-23,  1.872622650880968e-25,  1.928742117389029e-28,  9.450083907460278e-01,
 -3.095082622107503e-03,  8.221353168391865e-07,  1.962260174748862e-08, -1.443749192422661e-11, -2.216604783422093e-13,  2.697819419201707e-16,  3.014260496383571e-18,
 -5.203902508073999e-21, -4.490404469218257e-23,  1.022313754783740e-25,  7.040097561009668e-28,  1.023017605716998e+00, -3.104329397630585e-03, -3.031611124031510e-07,
  1.993069690570354e-08,  5.049802297231597e-12, -2.301354106508997e-13, -9.224913144413835e-17,  3.230732022671450e-18,  1.765324096575576e-21, -5.021833876697325e-23,
 -3.474612043978429e-26,  8.312315347286259e-28,  1.100924103923770e+00, -3.075827598097967e-03, -1.417747066869228e-06,  1.903268114014210e-08,  2.404069183964323e-11,
 -2.061308114998448e-13, -4.364816990808480e-16,  2.630307878045116e-18,  8.173382636727143e-21, -3.575872306906124e-23, -1.553616711415687e-25,  4.917663295711907e-28,
  1.178252551117261e+00, -3.010190294926681e-03, -2.474302580524627e-06,  1.699786245676545e-08,  4.041856647679176e-11, -1.536112265637015e-13, -6.900227969062306e-16,
  1.383340862386444e-18,  1.183277798135707e-20, -7.753056732079776e-24, -1.995759028163087e-25, -1.095271383136395e-28,  1.254529771240429e+00, -2.908940073625297e-03,
 -3.428376568877578e-06,  1.398900462891228e-08,  5.239997556036151e-11, -8.142040546921801e-14, -8.014191842476368e-16, -1.532334238246794e-19,  1.158394514537693e-20,
  2.173110320358145e-23, -1.484196089953989e-25, -6.123863411955855e-28,  1.329287677125781e+00, -2.774477101644992e-03, -4.240766679572256e-06,  1.024785479892377e-08,
  5.877003565734522e-11, -1.619461059414625e-15, -7.528952572384604e-16, -1.548604620883866e-18,  7.717094717078125e-21,  4.045368678291636e-23, -3.322602558816359e-26,
 -7.339066785249436e-28,  1.402066202936806e+00, -2.610025246348957e-03, -4.879631667503651e-06,  6.073227141526769e-09,  5.903836781271638e-11,  7.278898727812298e-14,
 -5.638982888273315e-16, -2.432904071047090e-18,  1.810603570969636e-21,  4.160870941725882e-23,  8.373564919401347e-26, -4.424581433733514e-28,  1.472416218846188e+00,
 -2.419557292345843e-03, -5.322216189845888e-06,  1.793678356088205e-09,  5.349264391063416e-11,  1.302919811847472e-13, -2.850771634439513e-16, -2.608691852177175e-18,
 -3.936028935662026e-21,  2.660428122481451e-23,  1.450377977310206e-25,  4.218832017908010e-29,  1.539902407736719e+00, -2.207700860710196e-03, -5.556087689525214e-06,
 -2.262634124644596e-09,  4.314181697523075e-11,  1.629603612164378e-13,  1.556292594311480e-17, -2.102221945349490e-18, -7.583469537600952e-21,  3.758588407767841e-24,
  1.286728910634786e-25,  4.124044214946362e-28,  1.604106083170844e+00, -1.979627159958831e-03, -5.579810927410885e-06, -5.798011606946810e-09,  2.955751099432057e-11,
  1.677839957820925e-13,  2.704561202765920e-16, -1.139189892154908e-18, -8.173892618532755e-21, -1.621417110015458e-23,  5.598047172283963e-26,  4.769893071150353e-28,
  1.664627927528843e+00, -1.740925184222178e-03, -5.403016407863969e-06, -8.572265971747038e-09,  1.463736229507183e-11,  1.469869570532469e-13,  4.293150401175487e-16,
 -5.644575192682033e-20, -6.001103734620408e-21, -2.545383901455806e-23, -2.580591726599889e-26,  2.643034147153543e-28,  1.721090629090370e+00, -1.497464402324015e-03,
 -5.045852759647735e-06, -1.042410468935210e-08,  3.259563818376934e-13,  1.072786563453461e-13,  4.704721009158272e-16,  8.167045635874359e-19, -2.346876530293219e-21,
 -2.224339354945227e-23, -7.356533993184972e-26, -3.390215172488190e-29,  1.773141396956397e+00, -1.255249337828643e-03, -4.537848178015231e-06, -1.128472702114578e-08,
 -1.166450121101539e-11,  5.822368827137044e-14,  4.038396991606091e-16,  1.264573022378484e-18,  1.161985173662809e-21, -1.086297356617434e-23, -7.156379642782638e-26,
 -2.178953349561113e-28,  1.820454333110558e+00, -1.020269711340377e-03, -3.916240258469122e-06, -1.118226839831822e-08, -2.009159574154108e-11,  1.009978473925163e-14,
  2.650692207635485e-16,  1.242097735875920e-18,  3.264781185460086e-21,  1.531216595942089e-24, -3.490999291525471e-26, -2.118312948606498e-28,  1.862732641654634e+00,
 -7.983499911694650e-04, -3.223864896443991e-06, -1.023663725204591e-08, -2.434251019431801e-11, -2.828156265293996e-14,  1.030294564959571e-16,  8.661626353263755e-19,
  3.528171601786161e-21,  9.002137916180627e-24,  5.964800797770146e-27, -8.366142590301321e-29,  1.899710656461070e+00, -5.950022676962482e-04, -2.506721441102133e-06,
 -8.645253476858719e-09, -2.449264560256268e-11, -5.131725634978862e-14, -3.540927331892927e-17,  3.498549330684879e-19,  2.379089060932198e-21,  9.587071211623699e-24,
  2.704263971864854e-26,  3.984717565330365e-29,  1.931155670647250e+00, -4.152863220734045e-04, -1.811351261678828e-06, -6.661121496609200e-09, -2.125532979705864e-11,
 -5.754839282752114e-14, -1.186579222028790e-16, -9.080070452183842e-20,  7.446478021138267e-22,  5.407345589680106e-24,  2.372262127407640e-26,  7.920435623318879e-29,
  1.956869556489157e+00, -2.636805863242251e-04, -1.182178914037943e-06, -4.565456956031745e-09, -1.583202317673589e-11, -4.960786531902638e-14, -1.378934682818811e-16,
 -3.194553221382194e-19, -4.831902711965154e-22,  4.845413293866608e-25,  8.217681985704532e-27,  4.496241973295025e-29,  1.976690184474668e+00, -1.439673173147845e-04,
 -6.589679635379834e-07, -2.637649315486016e-09, -9.688116220121643e-12, -3.322473233150584e-14, -1.067976646701923e-16, -3.198667511104360e-19, -8.761163010983465e-22,
 -2.094917700485573e-24, -3.784775980330224e-27, -1.272812885990796e-30,  1.990492782435722e+00, -5.913412866024407e-05, -2.745340333286286e-07, -1.125609588233578e-09,
 -4.291086569443536e-12, -1.554487079340619e-14, -5.407139585972069e-17, -1.814741025914770e-19, -5.885113942326362e-22, -1.841763314785245e-24, -5.538854928483648e-27,
 -1.587243336583617e-29,  1.998193229923216e+00, -1.128198625090575e-05, -5.278881555737884e-08, -2.192936789448601e-10, -8.527664285147052e-13, -3.177750261426682e-15,
 -1.148819306689734e-17, -4.058472702466799e-20, -1.407400509086868e-22, -4.805089909493857e-25, -1.618347708682434e-27, -5.383885518094894e-30,  7.338380807112414e-04,
 -4.473043821028592e-06,  2.044129638819275e-08, -8.299600029765499e-11,  3.157288941933117e-13, -1.152209570201702e-15,  4.084560734976425e-18, -1.417048141482273e-20,
  4.833992221498415e-23, -1.626670756946742e-25,  5.411708120220366e-28, -1.782820216216345e-30,  6.598550676566685e-03, -4.010717939281567e-05,  1.822420597215419e-07,
 -7.328868246549797e-10,  2.747890250022178e-12, -9.824281096218946e-15,  3.387167612852466e-17, -1.132956330057653e-19,  3.687582559253022e-22, -1.169191840402342e-24,
  3.609176685644450e-27, -1.082347917082674e-29,  1.829604158416255e-02, -1.105776807226849e-04,  4.967125090636455e-07, -1.959023307388909e-09,  7.128441738508568e-12,
 -2.439903728303398e-14,  7.910774699940005e-17, -2.428878743850356e-19,  7.011438177477922e-22, -1.869876213454319e-24,  4.424593114676722e-27, -8.273391225545462e-30,
  3.576255433578273e-02, -2.143051641288947e-04,  9.460350246729471e-07, -3.620868821431559e-09,  1.256341846778269e-11, -3.998184829408659e-14,  1.159340122747547e-16,
 -2.975683748264437e-19,  6.208059401642549e-22, -7.073788905940526e-25, -2.122177165801975e-27,  2.016415968285648e-29,  5.890273533791449e-02, -3.489607022418372e-04,
  1.504575220032925e-06, -5.523939666476084e-09,  1.788574522750744e-11, -5.070859027811887e-14,  1.192009135443233e-16, -1.864514435368974e-19, -1.290225613577724e-22,
  2.699958994204156e-24, -1.451620427936639e-26,  5.651792472612291e-29,  8.758997357783971e-02, -5.115133246963556e-04,  2.140139024508624e-06, -7.437856071513331e-09,
  2.183695269549615e-11, -5.117317428903873e-14,  7.167759511880693e-17,  1.170919368258722e-19, -1.414144401932113e-21,  6.783081641084036e-24, -2.314399890052769e-26,
  5.603469550759596e-29,  1.216668574609134e-01, -6.982922231875424e-04,  2.815561801461692e-06, -9.117976115659545e-09,  2.326824935014858e-11, -3.782578384643724e-14,
 -2.855786613574543e-17,  5.482907346166282e-19, -2.679504918993734e-21,  8.558577328483861e-24, -1.621027677186593e-26, -1.275292850891821e-29,  1.609457519838791e-01,
 -9.050626921509324e-04,  3.490558825034728e-06, -1.032876511705682e-08,  2.133251630480377e-11, -1.003811575661800e-14, -1.649375837665316e-16,  9.600376640054626e-19,
 -3.156377484462629e-21,  5.356100492506257e-24,  1.023769109416830e-26, -1.250443112096516e-28,  2.052095000829118e-01, -1.127114594363912e-03,  4.123753570113132e-06,
 -1.086687234205547e-08,  1.563935783537125e-11,  2.941016404544982e-14, -3.047248782314857e-16,  1.168570874246743e-18, -2.233496967768407e-21, -3.182484001981500e-24,
  4.548991892185068e-26, -1.969001633371160e-28,  2.542122525145822e-01, -1.359361900917699e-03,  4.674790501011331e-06, -1.058186712941170e-08,  6.349654052901936e-12,
  7.456041595146778e-14, -4.066152355608950e-16,  1.021942218964188e-18,  1.733615690139166e-22, -1.408254156606257e-23,  6.695167564385063e-26, -1.389982777264388e-28,
  3.076804310093252e-01, -1.596451619610266e-03,  5.106432880383083e-06, -9.392734645354538e-09, -5.806315269843442e-12,  1.172151536672470e-13, -4.318576783430031e-16,
  4.672798638654214e-19,  3.440622731470171e-21, -2.185683554294656e-23,  5.299664056623285e-26,  6.425054852243119e-29,  3.653138296555923e-01, -1.832880198148981e-03,
  5.386543986728885e-06, -7.298542334662475e-09, -1.959304988526201e-11,  1.484383511393377e-13, -3.559957764538538e-16, -4.092222454404468e-19,  6.366449212064351e-21,
 -2.106251117769193e-23, -1.025415577108890e-27,  3.127663145728780e-28,  4.267868595038692e-01, -2.063115272953977e-03,  5.489852348779887e-06, -4.382143967113545e-09,
 -3.341092138837380e-11,  1.603412763876172e-13, -1.779192419849225e-16, -1.388257308276442e-18,  7.600667857310593e-21, -9.437960756964932e-24, -7.436204415379390e-26,
  4.330162050943866e-28,  4.917499411986686e-01, -2.281720436219144e-03,  5.399408368615446e-06, -8.063589324208573e-10, -4.549776631734721e-11,  1.478041267509981e-13,
  7.659825967890357e-17, -2.172999487197557e-18,  6.222341308396283e-21,  1.007847789092485e-23, -1.276844657057058e-25,  2.925349696357085e-28,  5.598310500299081e-01,
 -2.483480519669913e-03,  5.107651042702310e-06,  3.197291114573975e-09, -5.416528909067098e-11,  1.097750418004392e-13,  3.583928346537922e-16, -2.480264005608134e-18,
  2.222766804166896e-21,  2.979485588573561e-23, -1.238789083668911e-25, -8.706148360658914e-29,  6.306374171209117e-01, -2.663524750573559e-03,  4.617019242072609e-06,
  7.346538260968810e-09, -5.803841466517683e-11,  4.985155934964522e-14,  6.051247698710520e-16, -2.138765615573371e-18, -3.337373414778779e-21,  4.035815786903082e-23,
 -5.184246327015084e-26, -5.075577626398737e-28,  7.037573895195062e-01, -2.817445032225565e-03,  3.940061805959466e-06,  1.133163179761918e-08, -5.626370864870158e-11,
 -2.402289678889029e-14,  7.560177850567531e-16, -1.160505885694392e-18, -8.610443754316175e-21,  3.524069028329744e-23,  6.161697143363833e-26, -6.985643956716499e-28,
  7.787624507160090e-01, -2.941406546116223e-03,  3.099023930116821e-06,  1.484197941698666e-08, -4.865564908309906e-11, -1.007449719938968e-13,  7.675037345964425e-16,
  2.424855691117148e-19, -1.161520776685445e-20,  1.443178203277604e-23,  1.613649928134543e-25, -4.946806647606181e-28,  8.552094015672179e-01, -3.032247875232878e-03,
  2.124913141780189e-06,  1.759383760335065e-08, -3.575681552997252e-11, -1.679367750275576e-13,  6.256231114126292e-16,  1.707106092674386e-18, -1.102088602364361e-20,
 -1.471109353134076e-23,  1.922177358084002e-25,  3.299616141373204e-29,  9.326426997552467e-01, -3.087567916184023e-03,  1.056075459778346e-06,  1.935651633419292e-08,
 -1.879922096370896e-11, -2.141932015249793e-13,  3.516128357445631e-16,  2.822718900322719e-18, -6.739652580729527e-21, -4.022598611417594e-23,  1.308647050129525e-25,
  5.933314087974869e-28,  1.010596953758776e+00, -3.105796989966381e-03, -6.366016327812121e-08,  1.997458263382841e-08,  4.323074654586262e-13, -2.312591587064193e-13,
 -1.271046924194454e-18,  3.258100407844302e-18, -5.866921152223079e-23, -5.086955699933720e-23,  2.296574072623692e-27,  8.465078385731865e-28,  1.088599564876110e+00,
 -3.086249783760296e-03, -1.187184807139697e-06,  1.938380766421379e-08,  1.981943308409047e-11, -2.156942651447944e-13, -3.593732231348321e-16,  2.870104488681154e-18,
  6.779795490175088e-21, -4.149978281964255e-23, -1.307202871199049e-25,  6.249684336780026e-28,  1.166173508139425e+00, -3.029158063589313e-03, -2.266552308899227e-06,
  1.761909586976985e-08,  3.718409372668448e-11, -1.696644969987449e-13, -6.460411533238272e-16,  1.755976636569678e-18,  1.140923760006245e-20, -1.578554866172587e-23,
 -2.008665694979056e-25,  5.265676223267475e-29,  1.242840240035044e+00, -2.935681491713568e-03, -3.255535240491477e-06,  1.481333122605474e-08,  5.057909870826864e-11,
 -1.006633841585732e-13, -8.004109718218351e-16,  2.287727493585951e-19,  1.225311202499752e-20,  1.527817305890206e-23, -1.736059718907649e-25, -5.271542549287205e-28,
  1.318122717845619e+00, -2.807895361512727e-03, -4.112154786672271e-06,  1.118692025671441e-08,  5.855358922800199e-11, -2.018003847041378e-14, -7.925821916529201e-16,
 -1.278676783033058e-18,  9.141595451294899e-21,  3.846525086354948e-23, -6.648227134006086e-26, -7.731564328646270e-28,  1.391548512220438e+00, -2.648754620602681e-03,
 -4.801039662632096e-06,  7.028728915614445e-09,  6.035333393342095e-11,  5.844592592129980e-14, -6.309788886166171e-16, -2.350391975367268e-18,  3.363781286245391e-21,
  4.453216644163762e-23,  6.153714560708134e-26, -5.659276333182291e-28,  1.462652991336409e+00, -2.462034179800033e-03, -5.295472035663943e-06,  2.670010555944974e-09,
  5.602407884680517e-11,  1.225603011698492e-13, -3.597318994864818e-16, -2.718199329410756e-18, -2.873696961147173e-21,  3.241005874360403e-23,  1.444036950798090e-25,
 -7.411996990550757e-29,  1.530982551823725e+00, -2.252246186359921e-03, -5.578990120881544e-06, -1.546291605737218e-09,  4.639985040522887e-11,  1.626002644495595e-13,
 -4.666905617353923e-17, -2.341699693726497e-18, -7.351223427304230e-21,  9.259235354994981e-24,  1.460908269863563e-25,  3.754730497885096e-28,  1.596097868596430e+00,
 -2.024535655025309e-03, -5.646437696722381e-06, -5.297904700527612e-09,  3.297536171331571e-11,  1.738620952053127e-13,  2.348124716805896e-16, -1.409619697831196e-18,
 -8.712102702631708e-21, -1.354037895899864e-23,  7.805899458819105e-26,  5.249518027570747e-28,  1.657577132957100e+00, -1.784556575836149e-03, -5.504379590358107e-06,
 -8.313991373765053e-09,  1.767989326115876e-11,  1.572489990216287e-13,  4.249070265284371e-16, -2.633175865417125e-19, -6.933010369068948e-21, -2.623041426275214e-23,
 -1.243891823460515e-26,  3.444456271972860e-28,  1.715019245950184e+00, -1.538331325678806e-03, -5.170837912064465e-06, -1.040110369393431e-08,  2.586248026560715e-12,
  1.188351529291209e-13,  4.921639848589372e-16,  7.282223026432917e-19, -3.200838655238091e-21, -2.520175126526926e-23, -7.397992083568537e-26,  1.728190098994993e-29,
  1.768046932036875e+00, -1.292096870912714e-03, -4.674344527866538e-06, -1.146150453392686e-08, -1.040021775780564e-11,  6.834455776127483e-14,  4.397054748849698e-16,
  1.294928179115631e-18,  7.170714936417100e-22, -1.391828278595663e-23, -8.121319547347413e-26, -2.194408806281288e-28,  1.816309736876632e+00, -1.052141829548381e-03,
 -4.052348454107848e-06, -1.150176027664262e-08, -1.982310516431382e-11,  1.689063716236466e-14,  3.013168363750836e-16,  1.347164393847026e-18,  3.292434459785693e-21,
 -6.140117907555772e-26, -4.496655817194785e-26, -2.455457416509608e-28,  1.859486872464132e+00, -8.246389321651137e-04, -3.349059631990561e-06, -1.063049963552157e-08,
 -2.488138271038898e-11, -2.550476627691732e-14,  1.289116349223158e-16,  9.842877135787701e-19,  3.855580700669492e-21,  9.158751199687399e-24,  1.649045816143283e-27,
 -1.134406008525294e-28,  1.897289873299591e+00, -6.154777516765969e-04, -2.612849786278172e-06, -9.045389251657083e-09, -2.552664964302627e-11, -5.204059841448028e-14,
 -2.449411026552416e-17,  4.317200335469802e-19,  2.744101224256940e-21,  1.070207925194344e-23,  2.865827425056956e-26,  3.303857086994481e-29,  1.929465029214891e+00,
 -4.301027359312909e-04, -1.893363716689116e-06, -7.010570059754823e-09, -2.243496678727951e-11, -6.042381276122418e-14, -1.208361291671333e-16, -6.366722185863027e-20,
  9.572578078026540e-22,  6.428746128110852e-24,  2.741744680122255e-26,  8.881784046766272e-29,  1.955795566126105e+00, -2.733615424681366e-04, -1.238517603773257e-06,
 -4.826889470812834e-09, -1.685800839306089e-11, -5.302637427736188e-14, -1.470515887056817e-16, -3.345708443264963e-19, -4.593287138864155e-22,  8.555356848909990e-25,
  1.040231818734993e-26,  5.461624307812918e-29,  1.976103567468666e+00, -1.493683547795793e-04, -6.915722023771708e-07, -2.798117499366535e-09, -1.037898443644740e-11,
 -3.589859028065465e-14, -1.161579803036278e-16, -3.491384439003209e-19, -9.542673438810728e-22, -2.246922850260859e-24, -3.801869872195947e-27,  5.986059854784024e-31,
  1.990251766150702e+00, -6.138562145768715e-05, -2.884637855248109e-07, -1.196826428491347e-09, -4.615383967338148e-12, -1.690575047739687e-14, -5.942660441129642e-17,
 -2.014114857563109e-19, -6.589767923643321e-22, -2.077907597512711e-24, -6.284246593140768e-27, -1.805425059785813e-29,  1.998147240356889e+00, -1.171505975388717e-05,
 -5.550435220134132e-08, -2.334617581784439e-10, -9.191733458815335e-13, -3.467628721420730e-15, -1.269030931419244e-17, -4.537815426294229e-20, -1.592630351980390e-22,
 -5.502420191196928e-25, -1.875047518798172e-27, -6.310264192562375e-30,  7.162667774469716e-04, -4.313413097089483e-06,  1.947491079215119e-08, -7.812349708063618e-11,
  2.936337396608600e-13, -1.058771862459418e-15,  3.708592107238475e-18, -1.271327095445662e-20,  4.285536935257378e-23, -1.425102482355032e-25,  4.685436650014317e-28,
 -1.525520667672047e-30,  6.440983168409352e-03, -3.868368870768426e-05,  1.737048714477577e-07, -6.904493520373126e-10,  2.559283605743869e-12, -9.048132690390950e-15,
  3.085846781827396e-17, -1.021418660884124e-19,  3.291551067018751e-22, -1.033921633686922e-24,  3.164550204325781e-27, -9.420271506523222e-30,  1.786153206490188e-02,
 -1.066961112604107e-04,  4.738727843584829e-07, -1.848771196499639e-09,  6.658908825851140e-12, -2.257958734066954e-14,  7.261111860842876e-17, -2.214948697660365e-19,
  6.369270701163483e-22, -1.700081534030407e-24,  4.067588534541957e-27, -7.938014922307207e-30,  3.492019979908085e-02, -2.069073281892344e-04,  9.037647810302753e-07,
 -3.426102836492625e-09,  1.179094227954423e-11, -3.729719421368698e-14,  1.078762833513756e-16, -2.781247641475238e-19,  5.940138521744140e-22, -7.758595883328151e-25,
 -1.333347564657674e-27,  1.583796301053785e-29,  5.753055268082050e-02, -3.371844607388925e-04,  1.439972006544380e-06, -5.245727461588853e-09,  1.689975672505204e-11,
 -4.791079666106626e-14,  1.139363116824434e-16, -1.891323350391110e-19, -4.169836072690652e-23,  2.166647558511028e-24, -1.220695177031097e-26,  4.861053909578322e-29,
  8.557760550999505e-02, -4.947433671113880e-04,  2.052947630410874e-06, -7.096558043143125e-09,  2.083093190411651e-11, -4.941846329854084e-14,  7.435809654695142e-17,
  7.557247376718793e-20, -1.186030336961544e-21,  5.905809912320695e-24, -2.074129789224577e-26,  5.305942580228110e-29,  1.189180534497327e-01, -6.761991203774920e-04,
  2.708354768216001e-06, -8.751768441918276e-09,  2.250607442587005e-11, -3.833635584130564e-14, -1.436072221430161e-17,  4.673503006057719e-19, -2.383169011479819e-21,
  7.902602963117585e-24, -1.650390327605364e-26, -1.135696147944600e-30,  1.573805733401910e-01, -8.776282164425763e-04,  3.368654267825772e-06, -9.989257096785593e-09,
  2.109428811411020e-11, -1.368527783976276e-14, -1.394410956389479e-16,  8.621874344411056e-19, -2.957442583624038e-21,  5.663218388775726e-24,  5.300992330291507e-27,
 -9.994501995636095e-29,  2.007662019415460e-01, -1.094641879593638e-03,  3.994870633955413e-06, -1.061232337342688e-08,  1.615703531982357e-11,  2.248123673713398e-14,
 -2.730203166002702e-16,  1.095600459586699e-18, -2.317346300127277e-21, -1.530077474427469e-24,  3.728215827037700e-26, -1.760811782643819e-28,  2.488487999204315e-01,
 -1.322469669490603e-03,  4.548465181176422e-06, -1.046886348993217e-08,  7.745593798630326e-12,  6.514519949684369e-14, -3.779957873499537e-16,  1.019882964901583e-18,
 -2.869060958186175e-22, -1.152970011851818e-23,  6.063175637176173e-26, -1.470771727442771e-28,  3.013756116098305e-01, -1.556052412616633e-03,  4.993238208881195e-06,
 -9.467439744326802e-09, -3.564536981769749e-12,  1.070193044153912e-13, -4.173477877329747e-16,  5.652040404353086e-19,  2.692482935918201e-21, -1.969484996649759e-23,
  5.476395554846696e-26,  1.773876009680003e-29,  3.580679316474851e-01, -1.790143283004176e-03,  5.297177001842312e-06, -7.588748705727192e-09, -1.671053396071804e-11,
  1.397792746495851e-13, -3.647157264696175e-16, -2.176100029022090e-19,  5.610605843044692e-21, -2.084705084515252e-23,  1.134076478044840e-26,  2.499584653569336e-28,
  4.186218904962460e-01, -2.019415642696989e-03,  5.434164211502587e-06, -4.891308837752409e-09, -3.024980440902004e-11,  1.556319105838839e-13, -2.134403052151272e-16,
 -1.151009525935515e-18,  7.211872987101532e-21, -1.204024015467540e-23, -5.598847128082055e-26,  4.005962867225851e-28,  4.827093715301624e-01, -2.238576024681248e-03,
  5.385462094593722e-06, -1.510594927289646e-09, -4.252811098338759e-11,  1.489351577879701e-13,  1.858954950384598e-17, -1.969039149896405e-18,  6.496449633551672e-21,
  5.240760856678960e-24, -1.139337884866865e-25,  3.293111415766581e-28,  5.499790727862370e-01, -2.442480404535657e-03,  5.140892569561911e-06,  2.348654384914363e-09,
 -5.188935359334132e-11,  1.175520954045380e-13,  2.900956392676716e-16, -2.392935607405936e-18,  3.205547557958034e-21,  2.479384179506425e-23, -1.254376219949843e-25,
  1.370662070824180e-29,  6.200577265828834e-01, -2.626251668450163e-03,  4.699641415353567e-06,  6.426668397400759e-09, -5.690106098136625e-11,  6.364518775489360e-14,
  5.439595103984832e-16, -2.222757315121699e-18, -1.926905531442663e-21,  3.786894580040702e-23, -7.183995208759728e-26, -4.008048921305297e-28,  6.925514899381086e-01,
 -2.785395953347249e-03,  4.070627378305398e-06,  1.042854304993614e-08, -5.656551022378653e-11, -6.298347516757880e-15,  7.198599095551079e-16, -1.415325408158596e-18,
 -7.304747374911453e-21,  3.709921451090983e-23,  3.156648822657151e-26, -6.633209419128952e-28,  7.670475180274007e-01, -2.915915320621475e-03,  3.272393495565726e-06,
  1.404837222040829e-08, -5.048601253854798e-11, -8.228488428925785e-14,  7.691764497114790e-16, -1.196867220048983e-19, -1.098495407729209e-20,  2.042647344822295e-23,
  1.378138613438632e-25, -5.709645495534815e-28,  8.431157317478218e-01, -3.014414041633366e-03,  2.332498385756683e-06,  1.699569001233337e-08, -3.896173760874781e-11,
 -1.523885205070342e-13,  6.684156912347076e-16,  1.347448165852374e-18, -1.141215547925372e-20, -7.038973901686632e-24,  1.902782475936199e-25, -1.192951099691795e-28,
  9.203107887488773e-01, -3.078195635573086e-03,  1.286409120608173e-06,  1.902194280672458e-08, -2.299242748043084e-11, -2.048317312343215e-13,  4.274193852052166e-16,
  2.584938962284720e-18, -8.087614313621260e-21, -3.450693868716778e-23,  1.541212389299262e-25,  4.607599454757737e-28,  9.981742650073155e-01, -3.105347725089341e-03,
  1.759237781241212e-07,  1.994452742208670e-08, -4.185799657047109e-12, -2.301968439332211e-13,  8.965472226534709e-17,  3.227012545711619e-18, -1.879371647679669e-21,
 -5.003638936776233e-23,  3.920679423252172e-26,  8.252454718925911e-28,  1.076237051128281e+00, -3.094811779326244e-03, -9.528202501208973e-07,  1.966596663489189e-08,
  1.542592832050106e-11, -2.233317668094167e-13, -2.762044189321500e-16,  3.062200777689794e-18,  5.198626372521155e-21, -4.614445064566340e-23, -1.007151939349828e-25,
  7.344206502963035e-28,  1.154021964031306e+00, -3.046434914662576e-03, -2.051668145462608e-06,  1.818607006408231e-08,  3.363994725114033e-11, -1.845388010899470e-13,
 -5.918589153566729e-16,  2.110436565045148e-18,  1.069734286083725e-20, -2.372433103973892e-23, -1.948401972623248e-25,  2.217219582390567e-28,  1.231046570529634e+00,
 -2.961001135999155e-03, -3.072989483189305e-06,  1.560544990909883e-08,  4.837448221319049e-11, -1.197516133779994e-13, -7.884430640587594e-16,  6.282888315405923e-19,
  1.267282805653312e-20,  7.902101104396164e-24, -1.943502375693593e-25, -4.108623507100415e-28,  1.306826214564529e+00, -2.840239738503892e-03, -3.972307297512299e-06,
  1.211950378893486e-08,  5.795704488923393e-11, -3.959733095587559e-14, -8.240855792067457e-16, -9.645698712668742e-19,  1.047022915222803e-20,  3.512059355821495e-23,
 -1.008160580121326e-25, -7.820765065932477e-28,  1.380877234572761e+00, -2.686809059426938e-03, -4.710865147100714e-06,  8.002888672456022e-09,  6.136555603576416e-11,
  4.252636138166678e-14, -6.950387872859999e-16, -2.216676190723108e-18,  5.004925470862895e-21,  4.646069059652530e-23,  3.404286597273675e-26, -6.819906018461312e-28,
  1.452720351740301e+00, -2.504254373914387e-03, -5.257974298257008e-06,  3.585510325271719e-09,  5.838273535399647e-11,  1.130041470645029e-13, -4.369455937729958e-16,
 -2.790383284555844e-18, -1.604095894603321e-21,  3.808277883978198e-23,  1.382580959365037e-25, -2.078163209706786e-28,  1.521884203860947e+00, -2.296939461920323e-03,
 -5.592984177521179e-06, -7.779615802666124e-10,  4.963520822254525e-11,  1.606671630849540e-13, -1.154716612701477e-16, -2.570446325722441e-18, -6.908868831145188e-21,
  1.541702092573899e-23,  1.613497057462923e-25,  3.138249109141213e-28,  1.587908993345804e+00, -2.069952220535557e-03, -5.706731215617076e-06, -4.742188774320439e-09,
  3.650559695217737e-11,  1.789920316135131e-13,  1.913713791635681e-16, -1.695557736354486e-18, -9.137680206760802e-21, -9.944498949942451e-24,  1.019955397048382e-25,
  5.606416339163822e-28,  1.650350211825689e+00, -1.828985632610013e-03, -5.602344645903207e-06, -8.005402131999671e-09,  2.092612044693470e-11,  1.673323479834212e-13,
  4.142856808205655e-16, -5.003475331527262e-19, -7.882382022782840e-21, -2.639988101774830e-23,  4.592428157437904e-27,  4.304650777777940e-28,  1.708782397993553e+00,
 -1.580196393660586e-03, -5.295322348062114e-06, -1.034006160569786e-08,  5.082658600851230e-12,  1.308793383530917e-13,  5.109797837128510e-16,  6.107106859518098e-19,
 -4.161020512649629e-21, -2.812758047282996e-23, -7.183589454357476e-26,  8.260442354013315e-29,  1.762802880114480e+00, -1.330044500542221e-03, -4.812834004671781e-06,
 -1.161638714465758e-08, -8.924849038653140e-12,  7.933469209757022e-14,  4.762048071632337e-16,  1.309211757110766e-18,  1.552247622844369e-22, -1.735847268014464e-23,
 -9.074256542144736e-26, -2.120200707625113e-28,  1.812035450274462e+00, -1.085118065268061e-03, -4.192260139382739e-06, -1.181582150112561e-08, -1.940985953806211e-11,
  2.458677892662990e-14,  3.405095173871537e-16,  1.452118045848948e-18,  3.255151601742979e-21, -2.086336657028945e-24, -5.653344406205341e-26, -2.802919350773463e-28,
  1.856133914259259e+00, -8.519484785671922e-04, -3.479030502764387e-06, -1.103250479556836e-08, -2.535823353225963e-11, -2.206591972799094e-14,  1.582485895265096e-16,
  1.112944110290127e-18,  4.185189276402652e-21,  9.114819820898174e-24, -4.105820567998523e-27, -1.491758092905875e-28,  1.894785459339962e+00, -6.368217511876823e-04,
 -2.723879454252105e-06, -9.462169788879356e-09, -2.657230823529159e-11, -5.247311248823068e-14, -1.111707929747219e-17,  5.259195928056986e-19,  3.150335256937771e-21,
  1.187466692673453e-23,  2.989383984319473e-26,  2.241274173660680e-29,  1.927713782910965e+00, -4.455923482093037e-04, -1.979684705846052e-06, -7.379355449727650e-09,
 -2.367256928589414e-11, -6.334158899781952e-14, -1.221536133225297e-16, -2.911253348464930e-20,  1.209401553914719e-21,  7.606517647071351e-24,  3.154366164584646e-26,
  9.877163856942830e-29,  1.954681930249643e+00, -2.835060412330477e-04, -1.298094273555616e-06, -5.105296794860793e-09, -1.795459551890187e-11, -5.666965769306882e-14,
 -1.566201207481384e-16, -3.486913772956975e-19, -4.204314062169429e-22,  1.322924891296909e-24,  1.305062399003721e-26,  6.608279343795146e-29,  1.975494812178649e+00,
 -1.550381206890378e-04, -7.261701878297070e-07, -2.970079881647192e-09, -1.112564415765425e-11, -3.880721874477303e-14, -1.263737376060000e-16, -3.809984844279913e-19,
 -1.037881271292703e-21, -2.397768740174613e-24, -3.721642583633792e-27,  3.180583561036834e-30,  1.990001515478662e+00, -6.375206100479201e-05, -3.032801936851471e-07,
 -1.273456945547560e-09, -4.968230777905023e-12, -1.840211699582596e-14, -6.537294834081054e-17, -2.237457278954404e-19, -7.385039548560979e-22, -2.345870593035917e-24,
 -7.131901248074624e-27, -2.052588690616631e-29,  1.998099473945094e+00, -1.217055613153617e-05, -5.839647738535039e-08, -2.487403430719590e-10, -9.916775681058833e-13,
 -3.788037934490455e-15, -1.403533182083839e-17, -5.080654753988518e-20, -1.804914943178845e-22, -6.311068574401575e-25, -2.176196416514926e-27, -7.409490126220288e-30,
  6.993188969179459e-04, -4.161285448738758e-06,  1.856493421773875e-08, -7.359004304175363e-11,  2.733203120445761e-13, -9.738869602256545e-16,  3.371073508684726e-18,
 -1.142049512695104e-20,  3.804678770037706e-23, -1.250442192851139e-25,  4.063434321932392e-28, -1.307709752618398e-30,  6.288976182327008e-03, -3.732650867633014e-05,
  1.656593264217436e-07, -6.509092275429204e-10,  2.385501334884084e-12, -8.340692443479078e-15,  2.814053106325896e-17, -9.218079954286143e-20,  2.941159057116554e-22,
 -9.152592211805398e-25,  2.777413501064342e-27, -8.205706968013779e-30,  1.744219159033287e-02, -1.029920924958885e-04,  4.523121837661538e-07, -1.745748772270440e-09,
  6.224253064090132e-12, -2.090909508763719e-14,  6.668562469820411e-17, -2.020617249543638e-19,  5.785696830018482e-22, -1.544246211735101e-24,  3.727191705646901e-27,
 -7.524688856236970e-30,  3.410677479311849e-02, -1.998385115316406e-04,  8.637593098301577e-07, -3.243277249858076e-09,  1.107026890648822e-11, -3.479949152360712e-14,
  1.003506433893806e-16, -2.595722126011821e-19,  5.652808298963622e-22, -8.163450394155316e-25, -7.165296269192252e-28,  1.232022585459468e-29,  5.620446210938093e-02,
 -3.259119547389540e-04,  1.378614508867811e-06, -4.982850310865196e-09,  1.596845606913136e-11, -4.523995562316697e-14,  1.086330030628515e-16, -1.893088754855596e-19,
  2.800804074696166e-23,  1.719032325709045e-24, -1.022448186567896e-26,  4.165204352424518e-29,  8.363094776606558e-02, -4.786548293235294e-04,  1.969756403044203e-06,
 -6.771072479095011e-09,  1.986055862830495e-11, -4.761257447785978e-14,  7.597363101909082e-17,  4.086563329198735e-20, -9.878014225969404e-22,  5.121838830365855e-24,
 -1.848308503654332e-26,  4.951731723885487e-29,  1.162559340754921e-01, -6.549463038361865e-04,  2.605468779194069e-06, -8.397819496963525e-09,  2.173691724844324e-11,
 -3.853234269490468e-14, -2.300712738481351e-18,  3.955134514359393e-19, -2.110544869985128e-21,  7.244185448967909e-24, -1.635414311524111e-26,  7.499623180964606e-30,
  1.539232078305086e-01, -8.511527509372387e-04,  3.250798635010089e-06, -9.654111944552657e-09,  2.078901767083722e-11, -1.675267363065282e-14, -1.165938884954733e-16,
  7.708440075499665e-19, -2.750749261039934e-21,  5.793909280330147e-24,  1.390795150843210e-27, -7.835171866301270e-29,  1.964507520632411e-01, -1.063187879420692e-03,
  3.869087541378043e-06, -1.035055955011922e-08,  1.654357651416434e-11,  1.628845039421595e-14, -2.433879895945581e-16,  1.020837087908865e-18, -2.347396742249574e-21,
 -1.875553680847488e-25,  2.999666682033451e-26, -1.551246737219936e-28,  2.436309041526264e-01, -1.286582250820761e-03,  4.423623821953238e-06, -1.033499397787028e-08,
  8.960084964913817e-12,  5.641457672047270e-14, -3.496267334599420e-16,  1.004516219474705e-18, -6.598890115566491e-22, -9.234760269645802e-24,  5.410322269741839e-26,
 -1.487510997781437e-28,  2.952305730865494e-01, -1.516561754446402e-03,  4.879355621368624e-06, -9.507887921180619e-09, -1.522984887546960e-12,  9.720196209620113e-14,
 -4.004194111935123e-16,  6.404428626130934e-19,  2.022980389013046e-21, -1.750020132031253e-23,  5.470016489892110e-26, -1.911513464006654e-29,  3.509915304619659e-01,
 -1.748134462826757e-03,  5.204598515074280e-06, -7.834229869951738e-09, -1.400287186019111e-11,  1.309725783910283e-13, -3.684073357748548e-16, -4.997050953032975e-20,
  4.870767784932738e-21, -2.019097153326916e-23,  2.103915816169667e-26,  1.917568762906355e-28,  4.106307915069899e-01, -1.976185105076256e-03,  5.372666310893318e-06,
 -5.350693422470563e-09, -2.719086933783366e-11,  1.501482670722875e-13, -2.425056998237249e-16, -9.275631932989898e-19,  6.742258005614430e-21, -1.393860972740038e-23,
 -3.922228937217810e-26,  3.605168323935282e-28,  4.738411039874948e-01, -2.195576177679607e-03,  5.363350582341247e-06, -2.167209157695457e-09, -3.954929008336530e-11,
  1.487433445754496e-13, -3.361087889337975e-17, -1.758984883887923e-18,  6.606640143164199e-21,  9.799252317030025e-25, -9.897238843642995e-26,  3.479717769931762e-28,
  5.402915642599624e-01, -2.401254461448205e-03,  5.164173792262209e-06,  1.537588785415047e-09, -4.947405263062127e-11,  1.237227458221382e-13,  2.246568224205932e-16,
 -2.277042443074980e-18,  4.008196381071987e-21,  1.981455176616884e-23, -1.229095502125397e-25,  9.845092353542030e-29,  6.096283808817407e-01, -2.588361432889246e-03,
  4.771343179691724e-06,  5.527122704865800e-09, -5.550267889680784e-11,  7.594764088145168e-14,  4.810598541346366e-16, -2.263192973202226e-18, -6.193085691421290e-22,
  3.467445625660789e-23, -8.709933901947523e-26, -2.930776851765211e-28,  6.814758070058650e-01, -2.752345753616793e-03,  4.190338451777262e-06,  9.523411914838117e-09,
 -5.652205200097254e-11,  1.047756839252993e-14,  6.771604633828237e-16, -1.627520676224005e-18, -5.953343755289329e-21,  3.779358080069689e-23,  3.569387168160114e-27,
 -6.060755341488169e-28,  7.554372631738032e-01, -2.889075701550869e-03,  3.436076241170720e-06,  1.322843159940626e-08, -5.194758159483449e-11, -6.390386956016735e-14,
  7.610218058774678e-16, -4.584258118864729e-19, -1.015657793765313e-20,  2.542070316729691e-23,  1.115580188562702e-25, -6.176043224098069e-28,  8.310966719684150e-01,
 -2.994949084926422e-03,  2.532608619315668e-06,  1.634880374416569e-08, -4.184624631419488e-11, -1.359352496150374e-13,  7.010039003031176e-16,  9.796608969059419e-19,
 -1.153020606028596e-20,  4.253652082535053e-25,  1.819347425518568e-25, -2.570495655623639e-28,  9.080200251853009e-01, -3.066997870896919e-03,  1.512331843669239e-06,
  1.862187231311474e-08, -2.698077466534863e-11, -1.937354756761632e-13,  4.959963734988485e-16,  2.307486251382896e-18, -9.214396352084450e-21, -2.797911858117620e-23,
  1.711977915040217e-25,  3.137051661492506e-28,  9.857572026039728e-01, -3.102984485073291e-03,  4.147048028070835e-07,  1.984087062000208e-08, -8.760942677513199e-12,
 -2.269693020361847e-13,  1.789008835494981e-16,  3.138424593588182e-18, -3.643826375965058e-21, -4.775606232204694e-23,  7.439767467146450e-26,  7.687482496972430e-28,
  1.063844058973668e+00, -3.101486520734486e-03, -7.154962466123008e-07,  1.987671770520350e-08,  1.090003953738623e-11, -2.289145363220389e-13, -1.883887157348676e-16,
  3.201264888769494e-18,  3.472937460996800e-21, -4.950103085249007e-23, -6.653480394403813e-26,  8.138452150500993e-28,  1.141804792365386e+00, -3.061966463808218e-03,
 -1.830330108829438e-06,  1.869403200455254e-08,  2.981210792872635e-11, -1.979964691968964e-13, -5.281132768370681e-16,  2.437604218804387e-18,  9.705786264650722e-21,
 -3.127312447040097e-23, -1.813790153617976e-25,  3.891480089072547e-28,  1.219154602495544e+00, -2.984823021078958e-03, -2.881162482101999e-06,  1.635926004520005e-08,
  4.579188631651169e-11, -1.384171085402539e-13, -7.651416737866373e-16,  1.036837583952723e-18,  1.281338031549181e-20, -1.929481380077213e-25, -2.093532252337484e-25,
 -2.669221951448736e-28,  1.295402641943346e+00, -2.871420763598279e-03, -3.821339014330226e-06,  1.303939783973543e-08,  5.696533060506566e-11, -5.966048122208881e-14,
 -8.462187379128289e-16, -6.101384400107258e-19,  1.165373007405259e-20,  3.040465039294040e-23, -1.347946551447367e-25, -7.564358499175731e-28,  1.370055256354291e+00,
 -2.724095091867901e-03, -4.608914314930145e-06,  8.990614698986544e-09,  6.204434665253621e-11,  2.512027847337124e-14, -7.546105443001468e-16, -2.029554988904943e-18,
  6.694503717118537e-21,  4.719112899339877e-23,  1.741185944716538e-27, -7.831753813004776e-28,  1.442619501795262e+00, -2.546130015768565e-03, -5.209270767479399e-06,
  4.537118325200870e-09,  6.053159829917522e-11,  1.015753880761133e-13, -5.155813629651438e-16, -2.818731732603244e-18, -1.361591413430213e-22,  4.338772732383268e-23,
  1.259171683546245e-25, -3.549338274639247e-28,  1.512606918521860e+00, -2.341706933607187e-03, -5.597449251848884e-06,  4.173300923902370e-11,  5.281488174080615e-11,
  1.570077487881341e-13, -1.904468644264509e-16, -2.781378697316763e-18, -6.234572026330915e-21,  2.212311529940026e-23,  1.733101797188990e-25,  2.252733433118872e-28,
  1.579537530736656e+00, -2.115823492192671e-03, -5.760014046052493e-06, -4.129227689870029e-09,  4.012734912820667e-11,  1.829818940231629e-13,  1.397541576610985e-16,
 -1.992855442117591e-18, -9.416235644113563e-21, -5.364478647585337e-24,  1.271395576310994e-25,  5.789649635312846e-28,  1.642944031745706e+00, -1.874182699345586e-03,
 -5.696288388905902e-06, -7.643276087974784e-09,  2.437091015699342e-11,  1.770777089065705e-13,  3.966022415925704e-16, -7.677160291335442e-19, -8.824669195314877e-21,
 -2.581128315672598e-23,  2.548581823141050e-26,  5.194195761042529e-28,  1.702376103636170e+00, -1.623053709625680e-03, -5.418826598155269e-06, -1.023712652521886e-08,
  7.824183804740262e-12,  1.433320504397748e-13,  5.260594130967007e-16,  4.608104084430059e-19, -5.224255845094155e-21, -3.090576000427620e-23, -6.648697653318782e-26,
  1.630834622755671e-28,  1.757404810659816e+00, -1.369107062036445e-03, -4.953033029466609e-06, -1.174585774132181e-08, -7.220896392786131e-12,  9.120346100758725e-14,
  5.128332341099854e-16,  1.303461951594513e-18, -5.372222237242301e-22, -2.117007813698748e-23, -9.969897735858307e-26, -1.929246417435731e-28,  1.807626996448330e+00,
 -1.119228544970781e-03, -4.335895640045589e-06, -1.212198730981152e-08, -1.883304779263911e-11,  3.325860402332088e-14,  3.826125850056610e-16,  1.554619993941279e-18,
  3.136274152726382e-21, -4.604535924891716e-24, -6.962717519670199e-26, -3.146763233156469e-28,  1.852669607606554e+00, -8.803172124048098e-04, -3.613868816181500e-06,
 -1.144154985171147e-08, -2.575896861385123e-11, -1.787856898259222e-14,  1.913350150142338e-16,  1.252075062021492e-18,  4.508676823859470e-21,  8.807365928642785e-24,
 -1.157454517519011e-26, -1.914256683966347e-28,  1.892193860830030e+00, -6.590742784670130e-04, -2.840011098337239e-06, -9.895731698470844e-09, -2.762318521861498e-11,
 -5.255141850268705e-14,  5.085940542082224e-18,  6.338025963792014e-19,  3.599547221484280e-21,  1.308597574816916e-23,  3.055888081432097e-26,  6.916455303462201e-30,
  1.925899168513312e+00, -4.617905711716504e-04, -2.070551859880457e-06, -7.768410695998328e-09, -2.496876025287674e-11, -6.627842238954072e-14, -1.223839996236600e-16,
  1.422186481624421e-20,  1.507021868132664e-21,  8.958132580792691e-24,  3.610984258717781e-26,  1.087540217870602e-28,  1.953526741563956e+00, -2.941408207989820e-04,
 -1.361119548935927e-06, -5.401845047324993e-09, -1.912637599048560e-11, -6.054717342093729e-14, -1.665639205583298e-16, -3.612765132242452e-19, -3.626743313168147e-22,
  1.906932364528557e-24,  1.624849453614630e-26,  7.964535088228085e-29,  1.974862810895429e+00, -1.609931322771016e-04, -7.629053648909698e-07, -3.154467830180112e-09,
 -1.193300207223868e-11, -4.197203769554839e-14, -1.375198456854331e-16, -4.156202014863143e-19, -1.126838236936741e-21, -2.542880910709705e-24, -3.508537891303990e-27,
  6.675881248589361e-30,  1.989741556023427e+00, -6.624080838226230e-05, -3.190510546568978e-07, -1.355980402160471e-09, -5.352484220342256e-12, -2.004899679699012e-14,
 -7.198177734858632e-17, -2.487859480127586e-19, -8.283151421182969e-22, -2.650007120887031e-24, -8.095265030904038e-27, -2.331906347643291e-29,  1.998049838084116e+00,
 -1.264994310255990e-05, -6.147912328947565e-08, -2.652320679991296e-10, -1.070925500031621e-12, -4.142631165381958e-15, -1.554231446944667e-17, -5.696325256980293e-20,
 -2.048600975383891e-22, -7.250433197189023e-25, -2.530139921149079e-27, -8.716322666393218e-30,  6.829653042658636e-04, -4.016225406216329e-06,  1.770746363398917e-08,
 -6.936845038295238e-11,  2.546264225664904e-13, -8.966849552354666e-16,  3.067689596901012e-18, -1.027199553630012e-20,  3.382441530186736e-23, -1.098846866737872e-25,
  3.529780677111222e-28, -1.122975290100597e-30,  6.142272127356002e-03, -3.603184129524156e-05,  1.580720354753859e-07, -6.140398805329429e-10,  2.225237517396608e-12,
 -7.695258619212919e-15,  2.568642809306127e-17, -8.327552505019161e-20,  2.630822372039223e-22, -8.110631028732035e-25,  2.440050887811510e-27, -7.153845465242217e-30,
  1.703732988729444e-02, -9.945572919625838e-05,  4.319472033035456e-07, -1.649421107040481e-09,  5.821628034298713e-12, -1.937449108145246e-14,  6.127893958942422e-17,
 -1.844088467124351e-19,  5.255818087638521e-22, -1.401647623964087e-24,  3.406081803632050e-27, -7.065918451515721e-30,  3.332099858917947e-02, -1.930811553050267e-04,
  8.258801781993684e-07, -3.071592443461119e-09,  1.039778496874891e-11, -3.247627561762918e-14,  9.333141562734490e-17, -2.419579657890225e-19,  5.354990309211406e-22,
 -8.350473780904127e-25, -2.393286905698633e-28,  9.470574465501195e-30,  5.492249946831806e-02, -3.151179399162137e-04,  1.320323872496787e-06, -4.734453548915920e-09,
  1.508930028094174e-11, -4.269621560821146e-14,  1.033536630093411e-16, -1.874979158544850e-19,  8.295628317710776e-23,  1.344854745183944e-24, -8.528721560228863e-27,
  3.556500695827703e-29,  8.174733748156351e-02, -4.632164592320121e-04,  1.890379044449803e-06, -6.460822156432675e-09,  1.892661573815113e-11, -4.577888299489589e-14,
  7.670206015331178e-17,  1.206767263845101e-20, -8.162081059570165e-22,  4.424973683404539e-24, -1.638819218971108e-26,  4.567328042264535e-29,  1.136772063960877e-01,
 -6.344997950675027e-04,  2.506756258186181e-06, -8.056193364922729e-09,  2.096657681231245e-11, -3.846206253622291e-14,  7.866449542060066e-18,  3.320231799371754e-19,
 -1.861431271499652e-21,  6.598606162567590e-24, -1.587963815527307e-26,  1.371086650861368e-29,  1.505698838406217e-01, -8.256041310338224e-04,  3.136933507740472e-06,
 -9.324312966077863e-09,  2.042767935191582e-11, -1.930167712550259e-14, -9.621119614166085e-17,  6.861616575419904e-19, -2.541946398235266e-21,  5.786213506885493e-24,
 -1.642132177417088e-27, -6.002412556770762e-29,  1.922591256865306e-01, -1.032727483351171e-03,  3.746478758614742e-06, -1.008356398611230e-08,  1.681320379754368e-11,
  1.078165343548861e-14, -2.158556244452526e-16,  9.458309472771427e-19, -2.334140862940886e-21,  8.818538425097583e-25,  2.362200709988014e-26, -1.347831957675317e-28,
  2.385545712210062e-01, -1.251686819977554e-03,  4.300499845190578e-06, -1.018305268314205e-08,  1.000673074389581e-11,  4.835837383991366e-14, -3.218429842736076e-16,
  9.784854558039617e-19, -9.549582027367524e-22, -7.200897742250534e-24,  4.761331329194246e-26, -1.455580797082494e-28,  2.892416727649545e-01, -1.477983557962151e-03,
  4.765177238648685e-06, -9.517219291042359e-09,  3.264416101259184e-13,  8.781383304661072e-14, -3.816724284305872e-16,  6.955182163899090e-19,  1.432072684382106e-21,
 -1.533788971924022e-23,  5.321080133335071e-26, -4.722550747312525e-29,  3.440816656668631e-01, -1.706877330564999e-03,  5.109328366129749e-06, -8.037800777725886e-09,
 -1.147186318882728e-11,  1.221309595029114e-13, -3.677324307511225e-16,  9.444202742842153e-20,  4.160929133702867e-21, -1.919652543708389e-23,  2.830166722354449e-26,
  1.393904267797053e-28,  4.028115969519230e-01, -1.933467777661070e-03,  5.305945716794387e-06, -5.762048234392306e-09, -2.424808508286098e-11,  1.440403753230962e-13,
 -2.655343562512430e-16, -7.201121113079872e-19,  6.215934034472294e-21, -1.520313337371626e-23, -2.432869527700151e-26,  3.159643236228458e-28,  4.651444332888942e-01,
 -2.152783930743607e-03,  5.333645324516285e-06, -2.776259008062672e-09, -3.658635567438404e-11,  1.473695601950912e-13, -7.990265078294926e-17, -1.547741943562418e-18,
  6.574366966073582e-21, -2.670792590364417e-24, -8.354073335967730e-26,  3.511434307877378e-28,  5.307692713037652e-01, -2.359880533935392e-03,  5.177957896012351e-06,
  7.660711265760123e-10, -4.695076682974414e-11,  1.283645423585602e-13,  1.627958328627844e-16, -2.138306073647992e-18,  4.634264471575001e-21,  1.500599483489453e-23,
 -1.170247343699055e-25,  1.662182032138594e-28,  5.993516755465580e-01, -2.549940362881666e-03,  4.832392493480413e-06,  4.651837195751431e-09, -5.387341140444473e-11,
  8.673153390278039e-14,  4.175957279226548e-16, -2.263734129243450e-18,  5.634353077150553e-22,  3.096355253211087e-23, -9.768958256979708e-26, -1.893054673581466e-28,
  6.705341715095919e-01, -2.718381274644440e-03,  4.299203010051891e-06,  8.621602645811694e-09, -5.615377926060924e-11,  2.616230215713257e-14,  6.291272256189216e-16,
 -1.796281959343500e-18, -4.596444847181433e-21,  3.742374158701724e-23, -2.152240112547376e-26, -5.321662970057192e-28,  7.439369228804174e-01, -2.860966347357743e-03,
  3.589791477041740e-06,  1.238803303335511e-08, -5.304423957234110e-11, -4.582922841775726e-14,  7.437791429842955e-16, -7.679863804687097e-19, -9.167729660660109e-21,
  2.933227496501227e-23,  8.389175537623165e-26, -6.353266083833385e-28,  8.191586235418640e-01, -2.973915056210590e-03,  2.724690292053821e-06,  1.565843684921842e-08,
 -4.439470373495987e-11, -1.188236193953526e-13,  7.232810498854573e-16,  6.123195276908611e-19, -1.138695839608246e-20,  7.440315709494714e-24,  1.679557799105893e-25,
 -3.746515835853448e-28,  8.957776355300676e-01, -3.054012995216500e-03,  1.733078445287695e-06,  1.815985037799914e-08, -3.073138764437615e-11, -1.810904494154482e-13,
  5.563360818785354e-16,  1.997855553084867e-18, -1.009546500434089e-20, -2.090015461448676e-23,  1.816307197920292e-25,  1.600989150179005e-28,  9.733534040297320e-01,
 -3.098717211167872e-03,  6.518052367101359e-07,  1.966464335620793e-08, -1.325034931609956e-11, -2.216359126540260e-13,  2.648903534452122e-16,  2.994953784366609e-18,
 -5.301539715158939e-21, -4.412750423202038e-23,  1.063861470679867e-25,  6.803991673450377e-28,  1.051428179306375e+00, -3.106253792840756e-03, -4.760810259333441e-07,
  2.001427703382813e-08,  6.283853841586377e-12, -2.323493455684897e-13, -9.746857387587198e-17,  3.283443684337648e-18,  1.651773920555806e-21, -5.143042456325063e-23,
 -2.960828197155914e-26,  8.586461922484541e-28,  1.129529073020416e+00, -3.075703987560360e-03, -1.603272605936889e-06,  1.913868146023253e-08,  2.573113663256346e-11,
 -2.098181461496272e-13, -4.556911917208772e-16,  2.728812151584249e-18,  8.453919325708588e-21, -3.813859208414596e-23, -1.607507174770159e-25,  5.460315812196960e-28,
  1.207170472413873e+00, -3.007074837884423e-03, -2.680549898747714e-06,  1.706879644778258e-08,  4.284250090872987e-11, -1.563858628181681e-13, -7.303825133451814e-16,
  1.445118252368745e-18,  1.265329945754312e-20, -8.754456304733439e-24, -2.175113708027374e-25, -1.007948032641067e-28,  1.283856830205025e+00, -2.901350187925500e-03,
 -3.659440532879218e-06,  1.394018894538827e-08,  5.556786662560660e-11, -8.013162498000081e-14, -8.579249850534302e-16, -2.208108262883216e-19,  1.264336252444339e-20,
  2.436293724961321e-23, -1.668337930332761e-25, -6.936523446513838e-28,  1.359085840511700e+00, -2.760517949123825e-03, -4.495057341055324e-06,  9.986340612081957e-09,
  6.236117442514310e-11,  6.353470808089635e-15, -8.081838500722546e-16, -1.788204273738961e-18,  8.386102117536677e-21,  4.654655793878833e-23, -3.454270908373885e-26,
 -8.617235084590617e-28,  1.432352001662927e+00, -2.587569785740664e-03, -5.148949525500974e-06,  5.521176817616540e-09,  6.243297735390252e-11,  8.825532634869488e-14,
 -5.943252960994159e-16, -2.797158661271712e-18,  1.512284362079918e-21,  4.806681926260534e-23,  1.069084029684591e-25, -5.098331676706554e-28,  1.503150555364474e+00,
 -2.386469921884461e-03, -5.591775479728337e-06,  9.116171397629540e-10,  5.590290808900696e-11,  1.514807207709372e-13, -2.709891838749477e-16, -2.966786636115164e-18,
 -5.311257731448321e-21,  2.922151995563091e-23,  1.807620138372832e-25,  1.088471380557459e-28,  1.570981778498816e+00, -2.162090613631451e-03, -5.805591247760094e-06,
 -3.457750347850819e-09,  4.381583161430597e-11,  1.856322031531893e-13,  7.971398588537978e-17, -2.296233510954347e-18, -9.511669030761174e-21,  2.311258909678442e-25,
  1.526090771206307e-25,  5.745416653031545e-28,  1.635355589162598e+00, -1.920112982342017e-03, -5.785549569426464e-06, -7.224499816386659e-09,  2.800573916358625e-11,
  1.863054496987782e-13,  3.710147196692108e-16, -1.064729723029162e-18, -9.729779709128243e-21, -2.430866421726594e-23,  5.028551429484134e-26,  6.072613650282665e-28,
  1.695796412847844e+00, -1.666893353964292e-03, -5.540824162445041e-06, -1.008831644109514e-08,  1.081802213163105e-11,  1.560923717189973e-13,  5.364508056398179e-16,
  2.753348625838597e-19, -6.382759366480032e-21, -3.339458440091544e-23, -5.725469663906009e-26,  2.591241318306699e-28,  1.751848238613505e+00, -1.409296948492164e-03,
 -5.094614134123046e-06, -1.184611843059146e-08, -5.270804074149808e-12,  1.039467471251859e-13,  5.489693395786919e-16,  1.273291098382624e-18, -1.373096266704759e-21,
 -2.531904348596383e-23, -1.075037339321917e-25, -1.591590099176361e-28,  1.803079779506105e+00, -1.154502634202145e-03, -4.483143852591936e-06, -1.241748076917896e-08,
 -1.807246492507275e-11,  4.297482608442107e-14,  4.275180838935493e-16,  1.651763365898595e-18,  2.916953847488699e-21, -7.676227556904050e-24, -8.419141002671800e-26,
 -3.467641991913630e-28,  1.849089637372930e+00, -9.097843892606593e-04, -3.753651233762203e-06, -1.185629220292241e-08, -2.606769439528702e-11, -1.284923867555720e-14,
  2.284599329023375e-16,  1.401319106949927e-18,  4.815252226920220e-21,  8.161967930046489e-24, -2.105348616935627e-26, -2.405998246989253e-28,  1.889511360750455e+00,
 -6.822769556857583e-04, -2.961446349890551e-06, -1.034609798323228e-08, -2.867148635240042e-11, -5.220293855965199e-14,  2.451751543487291e-17,  7.567617970349752e-19,
  4.092665472751989e-21,  1.430854643576677e-23,  3.041240954834903e-26, -1.469613938195700e-29,  1.924018277277523e+00, -4.787347630458461e-04, -2.166214049311025e-06,
 -8.178674759013352e-09, -2.632363914061545e-11, -6.920510225798706e-14, -1.212601176542712e-16,  6.789474889827340e-20,  1.856693094205668e-21,  1.050109189261704e-23,
  4.110777401551528e-26,  1.183068613245964e-28,  1.952327982360090e+00, -3.052943615870118e-04, -1.427818495751830e-06, -5.717775272361307e-09, -2.037812066655927e-11,
 -6.466733976163058e-14, -1.768308853864996e-16, -3.716511391121991e-19, -2.814405112390775e-22,  2.631474212825983e-24,  2.009485006841477e-26,  9.561196156526729e-29,
  1.974206387473050e+00, -1.672511004111524e-04, -8.019328404707410e-07, -3.352294746350552e-09, -1.280641163650398e-11, -4.541632256594656e-14, -1.496759863458289e-16,
 -4.531701610965374e-19, -1.220825832539501e-21, -2.676069708127679e-24, -3.116973417249442e-27,  1.133931746939185e-29,  1.989471382822198e+00, -6.885979085081534e-05,
 -3.358502009605395e-07, -1.444924276891463e-09, -5.771319891293901e-12, -2.186323715431060e-14, -7.933366836396715e-17, -2.768829923707090e-19, -9.297994078689961e-22,
 -2.995237988612107e-24, -9.189194840102559e-27, -2.646599202150400e-29,  1.997998234068389e+00, -1.315480495109707e-05, -6.476751825527277e-08, -2.830505200975827e-10,
 -1.157641404842991e-12, -4.535551974853830e-15, -1.723313053000190e-17, -6.395670935860175e-20, -2.328797436631052e-22, -8.343577226585287e-25, -2.946912179319126e-27,
 -1.027301219254248e-29,  6.671785460686595e-04, -3.877827461824243e-06,  1.689890724981229e-08, -6.543399258228117e-11,  2.374062890262129e-13, -8.263930464427336e-16,
  2.794651246516636e-18, -9.250276570384407e-21,  3.011124368688518e-23, -9.670572610236162e-26,  3.071127407868522e-28, -9.660019090534999e-31,  6.000628087051037e-03,
 -3.479614514414460e-05,  1.509122072137412e-07, -5.796346025383778e-10,  2.077313023262831e-12, -7.105839936688984e-15,  2.346831557766763e-17, -7.530582749011298e-20,
  2.355674892034548e-22, -7.194786697038015e-25,  2.145807442496324e-27, -6.242326299609028e-30,  1.664629496708032e-02, -9.607776923879297e-05,  4.127004932726622e-07,
 -1.559296791295470e-09,  5.448436546504386e-12, -1.796390309918478e-14,  5.634355080460394e-17, -1.683718826458967e-19,  4.775012233904702e-22, -1.271481884915245e-24,
  3.105705486639571e-27, -6.585595143608319e-30,  3.256165853843408e-02, -1.866187707037373e-04,  7.899982099141022e-07, -2.910304652852613e-09,  9.770120124836515e-12,
 -3.031571097828037e-14,  8.679196820864119e-17, -2.253040600309037e-19,  5.053588756086040e-22, -8.369995069658128e-25,  1.249882641161244e-28,  7.171446956931022e-30,
  5.368279878196375e-02, -3.047785624483845e-04,  1.264931254937338e-06, -4.499723144774571e-09,  1.425975733441375e-11, -4.027838457056412e-14,  9.814771196030131e-17,
 -1.841315569716378e-19,  1.255927147468576e-22,  1.033389412306667e-24, -7.083117383038132e-27,  3.026773559564119e-29,  7.992423386376135e-02, -4.483984672341628e-04,
  1.814636243800304e-06, -6.165220842788598e-09,  1.802945929732249e-11, -4.393678745661870e-14,  7.669736213334048e-17, -1.162485731326741e-20, -6.682347920661194e-22,
  3.808478041796664e-24, -1.446537802599391e-26,  4.172289470054880e-29,  1.111787110194429e-01, -6.148267977551165e-04,  2.412069385798820e-06, -7.726868765549706e-09,
  2.019994266719201e-11, -3.816822375029080e-14,  1.636402226877124e-17,  2.761368508453962e-19, -1.635156582665604e-21,  5.976868427553492e-24, -1.517621860208292e-26,
  1.797773356796447e-29,  1.473169574093852e-01, -8.009507037873695e-04,  3.026989681318043e-06, -9.000677454837444e-09,  2.002006464778833e-11, -2.138919529736284e-14,
 -7.810626561812974e-17,  6.081346753908569e-19, -2.335418154991175e-21,  5.672431594876985e-24, -3.935163871679028e-27, -4.466898377463162e-29,  1.881873995380277e-01,
 -1.003235076558681e-03,  3.627096286701423e-06, -9.813100283638006e-09,  1.697913318786768e-11,  5.910512966752728e-15, -1.904120457638360e-16,  8.718174952658186e-19,
 -2.286763009099948e-21,  1.713873964101298e-24,  1.811892672810913e-26, -1.155763626022409e-28,  2.336158619627312e-01, -1.217768815089998e-03,  4.179294441502626e-06,
 -1.001561808456205e-08,  1.089885629364025e-11,  4.095923350427555e-14, -2.949096354730618e-16,  9.441342249736594e-19, -1.181436760769117e-21, -5.422690887419048e-24,
  4.134619389064705e-26, -1.388255297227862e-28,  2.834052583575579e-01, -1.440318747510087e-03,  4.651058308798346e-06, -9.498437004731818e-09,  1.992718974230099e-12,
  7.889207163872196e-14, -3.616364552716869e-16,  7.329162396278210e-19,  9.176592398060059e-22, -1.325754757362971e-23,  5.065769148070490e-26, -6.764797383014672e-29,
  3.373352905612393e-01, -1.666391455890915e-03,  5.011852514152969e-06, -8.202287996633627e-09, -9.117210508532191e-12,  1.133515291454540e-13, -3.633262262912027e-16,
  2.167642002628493e-19,  3.491581345714035e-21, -1.795577724923531e-23,  3.340174595161037e-26,  9.353632976765389e-29,  3.951621740316005e-01, -1.891303169061761e-03,
  5.234567249071969e-06, -6.127323850087658e-09, -2.143252504113564e-11,  1.374475581475369e-13, -2.829962218177364e-16, -5.301206634202934e-19,  5.654331441357904e-21,
 -1.591182241035277e-23, -1.144350495122521e-26,  2.696259637512033e-28,  4.566184111406556e-01, -2.110257756815231e-03,  5.296914813442530e-06, -3.338180070437726e-09,
 -3.366152898219598e-11,  1.449555170416120e-13, -1.203129866541602e-16, -1.339515392425524e-18,  6.421776191615420e-21, -5.705386049448832e-24, -6.825833452946046e-26,
  3.416610178348921e-28,  5.214126369455292e-01, -2.318432673568303e-03,  5.182728829280624e-06,  3.558942073478779e-11, -4.434916605397828e-11,  1.315703962392155e-13,
  1.050742724461219e-16, -1.982254291603795e-18,  5.092134485207126e-21,  1.048745211705622e-23, -1.085321340851489e-25,  2.170701008116869e-28,  5.892295654053002e-01,
 -2.511072453053325e-03,  4.883101640303567e-06,  3.804262702362680e-09, -5.204367709992569e-11,  9.599625672494184e-14,  3.546257034499998e-16, -2.228637906451095e-18,
  1.606043662113275e-21,  2.691828564413942e-23, -1.038751119215142e-25, -9.342691495652069e-29,  6.597300673969633e-01, -2.683589042454379e-03,  4.397291356135369e-06,
  7.728131144134108e-09, -5.548369729178791e-11,  4.064242190463706e-14,  5.769732179899377e-16, -1.922022624345696e-18, -3.270108258758098e-21,  3.611895451726025e-23,
 -4.309668829360097e-26, -4.470889417823508e-28,  7.325514151921904e-01, -2.831667881386778e-03,  3.733328499490508e-06,  1.153295451671925e-08, -5.378422604563052e-11,
 -2.826872541080070e-14,  7.183314284350188e-16, -1.043865361331780e-18, -8.058098675527899e-21,  3.212966344155230e-23,  5.604340880934547e-26, -6.263552018921472e-28,
  8.073077311249568e-01, -2.951378178723133e-03,  2.908254288388430e-06,  1.493005806095494e-08, -4.659641151327940e-11, -1.013000170583247e-13,  7.353739549654259e-16,
  2.534850633677410e-19, -1.100242220296255e-20,  1.379949970592198e-23,  1.493227220689020e-25, -4.680743120297946e-28,  8.835906807952459e-01, -3.039285324225968e-03,
  1.947929317245576e-06,  1.763991752043880e-08, -3.421533626734357e-11, -1.671042539860777e-13,  6.076502208456948e-16,  1.664175442671504e-18, -1.071581058747244e-20,
 -1.353921151898634e-23,  1.853066199969442e-25,  7.839140648880017e-30,  9.609704530524482e-01, -3.092562804990455e-03,  8.863638396788389e-07,  1.941754958671087e-08,
 -1.761280652169629e-11, -2.142928471459052e-13,  3.461413369843762e-16,  2.800765041693850e-18, -6.806606220923223e-21, -3.930543132028464e-23,  1.338791032106074e-25,
  5.653936183428949e-28,  1.038997069870173e+00, -3.109100400383564e-03, -2.354601282142767e-07,  2.007754704484885e-08,  1.620944907553754e-12, -2.335810985661408e-13,
 -5.071697288120659e-18,  3.306522198529579e-18, -2.118840321334362e-22, -5.185416564961520e-23,  8.476737614369477e-27,  8.662623984092741e-28,  1.117202068703848e+00,
 -3.087604835481647e-03, -1.371278571843931e-06,  1.951624103325235e-08,  2.143174921517150e-11, -2.198085962952832e-13, -3.757120646126636e-16,  2.976178295225627e-18,
  6.971366658128752e-21, -4.404591728536222e-23, -1.336119365580785e-25,  6.837012084194234e-28,  1.195100597622901e+00, -3.027688525507346e-03, -2.471717721529589e-06,
  1.772831688185263e-08,  3.954300438730926e-11, -1.733840804752029e-13, -6.843099099794742e-16,  1.843296529521493e-18,  1.218093828820635e-20, -1.749113208632991e-23,
 -2.180030500037589e-25,  8.021369142924848e-29,  1.272193959027469e+00, -2.929941597734905e-03, -3.486880264828087e-06,  1.481533374754319e-08,  5.375907087639178e-11,
 -1.007495357486491e-13, -8.583211302876051e-16,  1.964637264833749e-19,  1.339319220663758e-20,  1.710603318056053e-23, -1.952796006467112e-25, -5.932039170222435e-28,
  1.347972630710332e+00, -2.795982098535335e-03, -4.369233846601757e-06,  1.098406562805517e-08,  6.229038731910103e-11, -1.361191714970422e-14, -8.542470219826091e-16,
 -1.493380065002693e-18,  1.002761371413734e-20,  4.438985849621575e-23, -7.364553046417763e-26, -9.101199100453114e-28,  1.421919783081619e+00, -2.628479254706347e-03,
 -5.076646172255862e-06,  6.533423797498591e-09,  6.404913700427474e-11,  7.305876961727960e-14, -6.717024810406067e-16, -2.720300374562812e-18,  3.313838622568960e-21,
  5.184851448441184e-23,  8.104326322797678e-26, -6.652689005802634e-28,  1.493515298319382e+00, -2.431144934695285e-03, -5.575370640232922e-06,  1.829918638216430e-09,
  5.886066147853592e-11,  1.439619566449994e-13, -3.562705145272773e-16, -3.118512816441872e-18, -4.128344289019425e-21,  3.650741595222663e-23,  1.824860770671276e-25,
 -3.482526055755628e-29,  1.562240280993301e+00, -2.208689114998785e-03, -5.842755139351536e-06, -2.726914420892326e-09,  4.754222161226036e-11,  1.867394611863780e-13,
  1.116815479938477e-17, -2.599246600797760e-18, -9.387440661010806e-21,  6.833729437992246e-24,  1.772848740189734e-25,  5.420293273637893e-28,  1.627582030509588e+00,
 -1.966736251052972e-03, -5.869430516742238e-06, -6.746126094039327e-09,  3.181829167663001e-11,  1.948160774978939e-13,  3.367148653661965e-16, -1.389642509845363e-18,
 -1.056202111517184e-20, -2.173820114810045e-23,  7.883205833577179e-26,  6.887734634272817e-28,  1.689039424006006e+00, -1.711701002134512e-03, -5.660740136548941e-06,
 -9.889551584088990e-09,  1.406911816830660e-11,  1.690354974567194e-13,  5.411169611563769e-16,  5.143345120556516e-20, -7.623153720110397e-21, -3.542508957215377e-23,
 -4.346093811968420e-26,  3.702599833331573e-28,  1.746128634878642e+00, -1.450623746198821e-03, -5.237202595899991e-06, -1.191309193889572e-08, -3.057258009407328e-12,
  1.175439997588370e-13,  5.838633240918878e-16,  1.213925420991631e-18, -2.363549146265676e-21, -2.974546585793755e-23, -1.134418382775723e-25, -1.075453809842560e-28,
  1.798389088090070e+00, -1.190968670787765e-03, -4.633858365818410e-06, -1.269919084117676e-08, -1.710656452248593e-11,  5.380052096585633e-14,  4.750279004294063e-16,
  1.740004065509468e-18,  2.576236908708882e-21, -1.135750299590923e-23, -1.000709849390789e-25, -3.739827325843555e-28,  1.845389530284715e+00, -9.403898090971867e-04,
 -3.898436717129304e-06, -1.227511962244787e-08, -2.626657947648827e-11, -6.877679955328429e-15,  2.698969900893197e-16,  1.559924281286238e-18,  5.091228046345160e-21,
  7.092054200285487e-24, -3.285198685668427e-26, -2.968602997331897e-28,  1.886734072368508e+00, -7.064730169362495e-04, -3.088386318417332e-06, -1.081315478739780e-08,
 -2.970786605021896e-11, -5.134496283334533e-14,  4.761946203117937e-17,  8.962018671786919e-19,  4.629442572718009e-21,  1.550412482541269e-23,  2.915419892855743e-26,
 -4.387262042752096e-29,  1.922068046973015e+00, -4.964643180739689e-04, -2.266931401280068e-06, -8.611083153083985e-09, -2.773665340640676e-11, -7.208545773440191e-14,
 -1.184681119485970e-16,  1.336852482348046e-19,  2.265608364433160e-21,  1.225211216158600e-23,  4.650506424189065e-26,  1.267812889752057e-28,  1.951083517310189e+00,
 -3.169970054250248e-04, -1.498431535690964e-06, -6.054406120113785e-09, -2.171475464630759e-11, -6.903708019334596e-14, -1.873478058788320e-16, -3.789778324395053e-19,
 -1.711774431529706e-22,  3.524700464124280e-24,  2.470260114272915e-26,  1.143091036888554e-28,  1.973524292361257e+00, -1.738310269493188e-04, -8.434204119298698e-07,
 -3.564663516381590e-09, -1.375171131005781e-11, -4.916531576970571e-14, -1.629263291413200e-16, -4.938009920899108e-19, -1.319273138841434e-21, -2.789079960139495e-24,
 -2.488786615403053e-27,  1.749014561678924e-29,  1.989190457980470e+00, -7.161755254037297e-05, -3.537581111854684e-07, -1.540869661916846e-09, -6.228270493723195e-12,
 -2.386374226253018e-14, -8.751967177286879e-17, -3.084351087961310e-19, -1.044533992195854e-21, -3.387106465658756e-24, -1.042994977662165e-26, -2.999789785089388e-29,
  1.997944556602642e+00, -1.368685344368978e-05, -6.827832602926036e-08, -3.023215672749552e-10, -1.252637922349752e-12, -4.971507244975986e-15, -1.913293153118537e-17,
 -7.191311636363970e-20, -2.651520547001133e-22, -9.617975026240101e-25, -3.438602070447868e-27, -1.213102068539432e-29,  6.519327352911473e-04, -3.745713693829614e-06,
  1.613595649177686e-08, -6.176415676416344e-11,  2.215287141398011e-13, -7.623237612630524e-16,  2.548626402505108e-18, -8.340129020048172e-21,  2.684109039303783e-23,
 -8.523040678250045e-26,  2.676260562898115e-28, -8.323741855674565e-31,  5.863814833254371e-03, -3.361611552376538e-05,  1.441514213866999e-07, -5.475046277597155e-10,
  1.940662129492349e-12, -6.567074662331095e-15,  2.146150788998963e-17, -6.816604457947954e-20,  2.111472525657148e-22, -6.388987771729885e-25,  1.888942290456622e-27,
 -5.451888368813520e-30,  1.626847064825308e-02, -9.284955639947697e-05,  3.945003591986199e-07, -1.474924131426369e-09,  5.102307816426622e-12, -1.666654563926953e-14,
  5.183634507591356e-17, -1.538007992518510e-19,  4.338954501264422e-22, -1.152906193170387e-24,  2.826609943969427e-27, -6.101003834526857e-30,  3.182760593571099e-02,
 -1.804358675301830e-04,  7.559928380696400e-07, -2.758722180259340e-09,  9.184134314204974e-12, -2.830660632057019e-14,  8.070533574450192e-17, -2.096131405251061e-19,
  4.753876556044484e-22, -8.262625079375016e-25,  3.984208478160957e-28,  5.324728790851712e-30,  5.248358684935600e-02, -2.948712808661453e-04,  1.212277339977227e-06,
 -4.277885328679178e-09,  1.347732996953076e-11, -3.798422106080575e-14,  9.305351142017259e-17, -1.795695192119363e-19,  1.580030185849476e-22,  7.753009263164379e-25,
 -5.854722124556420e-27,  2.567857959424278e-29,  7.815921245402213e-02, -4.341724700061428e-04,  1.742355747065747e-06, -5.883679519221690e-09,  1.716909258528557e-11,
 -4.210225027420185e-14,  7.609233270680559e-17, -3.092283865416037e-20, -5.411127871495224e-22,  3.265420143389097e-24, -1.271604935290769e-26,  3.780693662169164e-29,
  1.087574173770480e-01, -5.958956958495030e-04,  2.321261040134496e-06, -7.409752735038236e-09,  1.944110210664441e-11, -3.768842329500411e-14,  2.339482469555738e-17,
  2.271389592325973e-19, -1.430717162038467e-21,  5.386542551466992e-24, -1.432023742513335e-26,  2.070685490060507e-29,  1.441609100216918e-01, -7.771614065422321e-04,
  2.920889046734724e-06, -8.683874902376561e-09,  1.957487163969040e-11, -2.306766978244963e-14, -6.209430052339728e-17,  5.366346293439747e-19, -2.134481586769843e-21,
  5.479636155352250e-24, -5.612143885874158e-27, -3.196852596499779e-29,  1.842317535066079e-01, -9.746847093430441e-04,  3.510972199043159e-06, -9.540728616152922e-09,
  1.705357936263217e-11,  1.625347382721594e-15, -1.670154090018111e-16,  7.997585230637472e-19, -2.213194705753194e-21,  2.342259750989879e-24,  1.342958967403048e-26,
 -9.783640806223558e-29,  2.288108984906107e-01, -1.184812184933260e-03,  4.060179126456861e-06, -9.835058559569864e-09,  1.164938114411499e-11,  3.419419001558020e-14,
 -2.690303012197348e-16,  9.035121732952584e-19, -1.348333501620976e-21, -3.888456699768613e-24,  3.543231531461417e-26, -1.296684086348744e-28,  2.777176793387329e-01,
 -1.403565547109338e-03,  4.537318926174264e-06, -9.454395312069394e-09,  3.485445240045698e-12,  7.046194765801220e-14, -3.407726859737587e-16,  7.550299643681620e-19,
  4.761018257618978e-22, -1.129528420687639e-23,  4.735478519332742e-26, -8.149039041740565e-29,  3.307492877262981e-01, -1.626692656255422e-03,  4.912623089472574e-06,
 -8.330498614319611e-09, -6.936823848442140e-12,  1.047165701678856e-13, -3.557878954387372e-16,  3.184174594935638e-19,  2.870104338731164e-21, -1.654939637926735e-23,
  3.663245953561812e-26,  5.442620398871141e-29,  3.876802407970323e-01, -1.849726365761641e-03,  5.159071347560471e-06, -6.448626354220996e-09, -1.875259187268488e-11,
  1.304974424536253e-13, -2.953930741534217e-16, -3.584132222375149e-19,  5.076001499348479e-21, -1.614590935476104e-23, -5.957662235742324e-28,  2.236672791787257e-28,
  4.482618644118289e-01, -2.068051607635484e-03,  5.253720274410740e-06, -3.853740876581991e-09, -3.079421264054960e-11,  1.416409414317843e-13, -1.549769274975160e-16,
 -1.137802696799329e-18,  6.170814323991699e-21, -8.140118750458230e-24, -5.361912924865799e-26,  3.223683819440181e-28,  5.122218158519165e-01, -2.276980996830167e-03,
  5.178985611927739e-06, -6.528274914889676e-10, -4.169693952193197e-11,  1.334448738688394e-13,  5.190332469685597e-17, -1.814083699666001e-18,  5.393946942967723e-21,
  6.348554882651054e-24, -9.815936645697198e-26,  2.518803306471382e-28,  5.792636745545584e-01, -2.471839042387526e-03,  4.923821397503382e-06,  2.987364600791390e-09,
 -5.004366263892112e-11,  1.037651252945135e-13,  2.930832752553553e-16, -2.162547966639525e-18,  2.499558534840813e-21,  2.270697087264189e-23, -1.060706348488275e-25,
 -8.331652536773300e-30,  6.490666340085642e-01, -2.648054786303095e-03,  4.484731705583849e-06,  6.847628652913489e-09, -5.453679048837103e-11,  5.383334346541120e-14,
  5.218844646477549e-16, -2.006231174401478e-18, -2.005355551846364e-21,  3.402816313245725e-23, -6.077992067203851e-26, -3.561415973955055e-28,  7.212853327249884e-01,
 -2.801262337817713e-03,  3.866545016479110e-06,  1.066881016010878e-08, -5.417971450005737e-11, -1.140756507184859e-14,  6.856698303996221e-16, -1.282838639761847e-18,
 -6.867651931970225e-21,  3.382814806146855e-23,  2.911630133490261e-26, -5.940917119593807e-28,  7.955498670749230e-01, -2.927408323589874e-03,  3.082877982707159e-06,
  1.416926810532979e-08, -4.844555071970172e-11, -8.360515669814648e-14,  7.376251132768432e-16, -8.953278249649014e-20, -1.040329204213361e-20,  1.933883983389374e-23,
  1.271568180077666e-25, -5.349933308399244e-28,  8.714660335341609e-01, -3.022864728993134e-03,  2.156215974714854e-06,  1.706654297596821e-08, -3.740801292618342e-11,
 -1.520006333616986e-13,  6.493833662900750e-16,  1.314899563709236e-18, -1.107011234665511e-20, -6.163167528731860e-24,  1.824491736273578e-25, -1.357306340277141e-28,
  9.486158521987825e-01, -3.084544965238334e-03,  1.117543705866916e-06,  1.910193539922438e-08, -2.180937002034306e-11, -2.050702800335908e-13,  4.213083169286136e-16,
  2.561393638671019e-18, -8.119562041237375e-21, -3.349126401864098e-23,  1.558447256579939e-25,  4.303375638091564e-28,  1.026558426954645e+00, -3.110020273184202e-03,
  5.471948015069496e-09,  2.006613401636056e-08, -3.044406343534463e-12, -2.325943147116716e-13,  8.713626237628532e-17,  3.270013590534513e-18, -2.063395772130581e-21,
 -5.075889913111229e-23,  4.606859477416268e-26,  8.363627119152567e-28,  1.104831199924550e+00, -3.097632792200673e-03, -1.135172813735098e-06,  1.982351848438839e-08,
  1.695228030018956e-11, -2.278019820018235e-13, -2.895012792986326e-16,  3.172921059675710e-18,  5.297083362785284e-21, -4.875397127811954e-23, -1.009841557058635e-25,
  7.943461381241611e-28,  1.182951658219269e+00, -3.046600821623024e-03, -2.255299064706338e-06,  1.833238949163680e-08,  3.591549394592609e-11, -1.891447661720081e-13,
 -6.273471515728724e-16,  2.221338867429593e-18,  1.139564590618760e-20, -2.608571351706653e-23, -2.103620596733687e-25,  2.673297914721811e-28,  1.260419548950094e+00,
 -2.957111041764512e-03, -3.304005502072771e-06,  1.565824245348221e-08,  5.153878117622588e-11, -1.212342873879356e-13, -8.467384511086570e-16,  6.333425436104861e-19,
  1.386245586708996e-20,  8.810455269559472e-24, -2.185062014107948e-25, -4.569211079968263e-28,  1.336719653246664e+00, -2.830391819167815e-03, -4.231457811321761e-06,
  1.197740643437347e-08,  6.180993628648195e-11, -3.457790721830356e-14, -8.913335642512759e-16, -1.147575169621691e-18,  1.156291074624075e-20,  4.063685237311876e-23,
 -1.140897119561596e-25, -9.216981453986880e-28,  1.411325160998200e+00, -2.668761293145801e-03, -4.992051058209655e-06,  7.568997833291509e-09,  6.534300348441970e-11,
  5.603761757746349e-14, -7.461015717825980e-16, -2.583827061249865e-18,  5.231277229645959e-21,  5.446053662644574e-23,  4.848358110544661e-26, -8.126108977320363e-28,
  1.483701674611185e+00, -2.475643837967170e-03, -5.547667564798002e-06,  2.794228617415409e-09,  6.164725108666900e-11,  1.343499805211257e-13, -4.452307807025097e-16,
 -3.228188600436751e-18, -2.683489668068839e-21,  4.372832213584513e-23,  1.773325793238538e-25, -2.031685076548187e-28,  1.553311851835985e+00, -2.255548832708243e-03,
 -5.870790832983208e-06, -1.936371350168845e-09,  5.127362181585827e-11,  1.861004824453532e-13, -6.576931597034979e-17, -2.894294138841074e-18, -9.008181523229341e-21,
  1.438537807231257e-23,  1.998210798102554e-25,  4.765458230904811e-28,  1.619620674523670e+00, -2.014006555759504e-03, -5.947199510796249e-06, -6.205437704183748e-09,
  3.579207271757674e-11,  2.023914222657771e-13,  2.929601311679833e-16, -1.739479224790340e-18, -1.128033660130620e-20, -1.795738389967449e-23,  1.107108523189467e-25,
  7.575864954847650e-28,  1.682101302296427e+00, -1.757457533384135e-03, -5.777950270996605e-06, -9.636694418773440e-09,  1.757966533619389e-11,  1.820108312925655e-13,
  5.389480072289485e-16, -2.132138479133708e-19, -8.925498413249667e-21, -3.680191645995486e-23, -2.447249488687648e-26,  4.948675812482367e-28,  1.740241438325196e+00,
 -1.493093843283191e-03, -5.380373119478922e-06, -1.194242827948391e-08, -5.635461170602803e-13,  1.319550309125728e-13,  6.166270915723230e-16,  1.120274584709921e-18,
 -3.517027446679827e-21, -3.435802710574992e-23, -1.166574045901246e-25, -3.489083964412863e-29,  1.793550100078628e+00, -1.228653665976108e-03, -4.787853325591674e-06,
 -1.296365162647730e-08, -1.591255463948990e-11,  6.579474139416281e-14,  5.248350053219162e-16,  1.815096598639265e-18,  2.091291150134450e-21, -1.569577507173336e-23,
 -1.169818382029817e-25, -3.930324687100362e-28,  1.841564653054584e+00, -9.721736611781388e-04, -4.048263102071824e-06, -1.269611819256832e-08, -2.633572377886607e-11,
  1.426184362626065e-16,  3.158921609104258e-16,  1.726648361659647e-18,  5.319576713592500e-21,  5.498636996098069e-24, -4.727877786747979e-26, -3.599934872284535e-28,
  1.883857932809750e+00, -7.317072970502558e-04, -3.221029793486206e-06, -1.129662490277841e-08, -3.072121531766885e-11, -4.988370818169007e-14,  7.487259266126518e-17,
  1.053495080900255e-18,  5.208021878345789e-21,  1.662111443344230e-23,  2.641590580061944e-26, -8.225995990861018e-29,  1.920045253559389e+00, -5.150207562119060e-04,
 -2.372975190811618e-06, -9.066556337819422e-09, -2.920644759304689e-11, -7.487516107531637e-14, -1.136410005479472e-16,  2.136119913969623e-19,  2.741531795531913e-21,
  1.422597550761019e-23,  5.223559989866416e-26,  1.332835829256351e-28,  1.949791085770215e+00, -3.292810821591061e-04, -1.573215391289798e-06, -6.413136046259156e-09,
 -2.314132192110551e-11, -7.366125874972573e-14, -1.980153786033578e-16, -3.822243762063020e-19, -2.523443544687785e-23,  4.619567998763878e-24,  3.019923267056927e-26,
  1.360704006166115e-28,  1.972815197231490e+00, -1.807533106943040e-04, -8.875496887754029e-07, -3.792774591805528e-09, -1.477526493574246e-11, -5.324632871734883e-14,
 -1.773590134176959e-16, -5.376418211047014e-19, -1.421266587933580e-21, -2.871026853100503e-24, -1.550079674235580e-27,  2.552706683093295e-29,  1.988898208094005e+00,
 -7.452331029241689e-05, -3.728625890386583e-07, -1.644457319957538e-09, -6.727269600081406e-12, -2.607174122916835e-14, -9.664272641435717e-17, -3.438943378877047e-19,
 -1.174307723984334e-21, -3.831832906293674e-24, -1.183510152487632e-26, -3.394276877165712e-29,  1.997888693268027e+00, -1.424793992692356e-05, -7.202980200243216e-08,
 -3.231848668163169e-10, -1.356828164231490e-12, -5.455852167493981e-15, -2.127068764620661e-17, -8.097960441156808e-20, -3.023868386259732e-22, -1.110642107154256e-24,
 -4.019803886233217e-27, -1.435316111348558e-29,  6.372034453098393e-04, -3.619531603137207e-06,  1.541556078606210e-08, -5.833842341835089e-11,  2.068754836774553e-13,
 -7.038647165427009e-16,  2.326680657113499e-18, -7.528310293833563e-21,  2.395697978487034e-23, -7.522299648355691e-26,  2.335740949696682e-28, -7.184167306872643e-31,
  5.731615915828801e-03, -3.248866631800356e-05,  1.377634240614951e-07, -5.174774152990138e-10,  1.814320655147698e-12, -6.074159497833869e-15,  1.964409620281581e-17,
 -6.176321212386268e-20,  1.894510386728781e-22, -5.679297829295195e-25,  1.664501700642708e-27, -4.765948530785622e-30,  1.590327426059928e-02, -8.976298695761855e-05,
  3.772803062747086e-07, -1.395887695511534e-09,  4.781076754945170e-12, -1.547261904299807e-14,  4.771822090723921e-17, -1.405589139964160e-19,  3.943625783663788e-22,
 -1.045069485948698e-24,  2.568697733159198e-27, -5.624387947365898e-30,  3.111775215894417e-02, -1.745178877578337e-04,  7.237515019610849e-07, -2.616201813426641e-09,
  8.636904833617667e-12, -2.643841664015771e-14,  7.504469419215182e-17, -1.948731566211307e-19,  4.459813092971772e-22, -8.060987657424007e-25,  5.990243237599773e-28,
  3.848789716756700e-30,  5.132317814420317e-02, -2.853747917644633e-04,  1.162211858536756e-06, -4.068205881665463e-09,  1.273957418387187e-11, -3.581067657923876e-14,
  8.810023635864486e-17, -1.741099109179820e-19,  1.819596655087089e-22,  5.625006096792913e-25, -4.814125601128892e-27,  2.171878741055254e-29,  7.644995961567591e-02,
 -4.205114340057222e-04,  1.673372358765966e-06, -5.615611501729960e-09,  1.634522994274472e-11, -4.028827583634344e-14,  7.500106577160967e-17, -4.645254753105751e-20,
 -4.323225843007542e-22,  2.788922451451557e-24, -1.113639943593857e-26,  3.402340025629823e-29,  1.064104190192022e-01, -5.776760447577730e-04,  2.234185583265847e-06,
 -7.104692670665351e-09,  1.869343755868057e-11, -3.705562701506449e-14,  2.914212853447771e-17,  1.843499215350856e-19, -1.246887682874074e-21,  4.832482500033123e-24,
 -1.337164229421298e-26,  2.223848111125923e-29,  1.410983461156688e-01, -7.542058313626958e-04,  2.818546262264960e-06, -8.374443782055151e-09,  1.909979357769657e-11,
 -2.438516138384295e-14, -4.799544672602787e-17,  4.714416071416724e-19, -1.941564908633489e-21,  5.230228105571314e-24, -6.782784573847912e-27, -2.160098727367568e-29,
  1.803884716791402e-01, -9.470502470578956e-04,  3.398120986983284e-06, -9.267821608110787e-09,  1.704777544774141e-11, -2.122225065083422e-15, -1.456003134349248e-16,
  7.303809835143497e-19, -2.120197048349923e-21,  2.798206098177238e-24,  9.484906803407021e-27, -8.174886876399028e-29,  2.241358696915185e-01, -1.152799616362508e-03,
  3.943298219400849e-06, -9.643539694218251e-09,  1.227072112594344e-11,  2.803604746357776e-14, -2.443551716572711e-16,  8.583883091526386e-19, -1.464153997323306e-21,
 -2.582214624396814e-24,  2.995758174863706e-26, -1.189989263755059e-28,  2.721752971950943e-01, -1.367719754382888e-03,  4.424245870338261e-06, -9.387791430012216e-09,
  4.814618506557071e-12,  6.253845201386909e-14, -3.194771185200156e-16,  7.641175286049299e-19,  1.026765663125004e-22, -9.475625789449835e-24,  4.356739604580272e-26,
 -8.984640545262826e-29,  3.243204834951472e-01, -1.587793266118480e-03,  4.812058789816501e-06, -8.425193880981685e-09, -4.927108031564769e-12,  9.629448695741707e-14,
 -3.456739247893997e-16,  4.010152232139176e-19,  2.301186397165655e-21, -1.504623395143003e-23,  3.828916021665354e-26,  2.194870793033011e-29,  3.803633834372939e-01,
 -1.808768233913230e-03,  5.079972454518607e-06, -6.728176514705683e-09, -1.621425766047901e-11,  1.233053998727720e-13, -3.032419025454986e-16, -2.052673565277438e-19,
  4.496571777367316e-21, -1.598603444383621e-23,  8.269481608226242e-27,  1.797460355880568e-28,  4.400734130785242e-01, -2.026214987099004e-03,  5.204611939239090e-06,
 -4.323998252155929e-09, -2.800105469158579e-11,  1.375612222371895e-13, -1.841177251225063e-16, -9.454119729336391e-19,  5.842516616088275e-21, -1.000854221623370e-23,
 -3.999463540679026e-26,  2.959646462741014e-28,  5.031966902757471e-01, -2.235591586030261e-03,  5.167237022354326e-06, -1.298576578810868e-09, -3.901959798715814e-11,
  1.341007106811541e-13,  3.554552748617308e-18, -1.638556306496351e-18,  5.554556247586157e-21,  2.650790586540856e-24, -8.658163316983286e-26,  2.721230153736020e-28,
  5.694553075612608e-01, -2.432318529478424e-03,  4.954935248225775e-06,  2.203630183747111e-09, -4.790287499538894e-11,  1.100822722432104e-13,  2.337687889277480e-16,
 -2.070301108554224e-18,  3.240754880955738e-21,  1.847909866878747e-23, -1.047951944109681e-25,  6.411815908220838e-29,  6.385466701616266e-01, -2.611862994337313e-03,
  4.561705399509746e-06,  5.984314661940209e-09, -5.333945421610966e-11,  6.567833998483350e-14,  4.649922380318105e-16, -2.051300576268376e-18, -8.276324482714638e-22,
  3.131071470677308e-23, -7.442194333639917e-26, -2.641401199068482e-28,  7.101429381029237e-01, -2.769832623273440e-03,  3.989364818671688e-06,  9.800990986229148e-09,
 -5.424633806263510e-11,  4.593775689905112e-15,  6.468580287084325e-16, -1.482944034093065e-18, -5.635050480113311e-21,  3.448388033032392e-23,  4.044757646931837e-27,
 -5.427552969400691e-28,  7.838906179298901e-01, -2.902078472886586e-03,  3.248206359487574e-06,  1.338172281131569e-08, -4.994101844965948e-11, -6.596917807117177e-14,
  7.305689101077213e-16, -4.103642048118412e-19, -9.621341878474303e-21,  2.394065364831017e-23,  1.026443115047005e-25, -5.747646753100990e-28,  8.594103564687663e-01,
 -3.004806207592257e-03,  2.357325776227642e-06,  1.644455325925397e-08, -4.028939895918673e-11, -1.360138108308435e-13,  6.812177513721473e-16,  9.585004456160624e-19,
 -1.116242058030272e-20,  9.762438847278662e-25,  1.735846596858143e-25, -2.642643452747879e-28,  9.362969960030957e-01, -3.074693962859515e-03,  1.344539729682276e-06,
  1.872074746254199e-08, -2.580400869057474e-11, -1.941286826699243e-13,  4.892173000012743e-16,  2.283514295512024e-18, -9.208864454479659e-21, -2.692157504585081e-23,
  1.715638739178166e-25,  2.827501183211457e-28,  1.014119956805209e+00, -3.109014503897027e-03,  2.458202337078166e-07,  1.998035302500494e-08, -7.668009217637388e-12,
 -2.294134550510237e-13,  1.775004823236760e-16,  3.175174472652368e-18, -3.848826526069286e-21, -4.819696116910903e-23,  8.155079083898028e-26,  7.708646429293413e-28,
  1.092424018628387e+00, -3.105758383363437e-03, -8.958146618574094e-07,  2.005795967218924e-08,  1.233404855209311e-11, -2.336664048779578e-13, -1.985554072195458e-16,
  3.313635772530000e-18,  3.477890324882047e-21, -5.206897224062917e-23, -6.420269688461221e-26,  8.716016630852936e-28,  1.170730576815283e+00, -3.063753783137692e-03,
 -2.031989929307207e-06,  1.887597804832197e-08,  3.198728237289146e-11, -2.034144464412071e-13, -5.601970187464891e-16,  2.569376456299448e-18,  1.030843249826341e-20,
 -3.421032970565898e-23, -1.945309844688568e-25,  4.508444254385750e-28,  1.248539450260372e+00, -2.982777663010923e-03, -3.111242442238501e-06,  1.646236825379023e-08,
  4.891257470368313e-11, -1.412928486405065e-13, -8.227590381660268e-16,  1.080292550909193e-18,  1.401788947266605e-20, -2.845826230053655e-25, -2.350227307469909e-25,
 -2.891161013636299e-28,  1.325331316584047e+00, -2.863651814007791e-03, -4.081821794640271e-06,  1.295966049514218e-08,  6.090207708902499e-11, -5.631236823688096e-14,
 -9.180722959630182e-16, -7.551150115036992e-19,  1.293396609798952e-20,  3.526793972852751e-23, -1.541347039975114e-25, -8.912751055655376e-28,  1.400570843448424e+00,
 -2.708316537682985e-03, -4.894916388921470e-06,  8.622454757014911e-09,  6.627893683153286e-11,  3.728375344129580e-14, -8.158081252873826e-16, -2.384754974163380e-18,
  7.217782889266829e-21,  5.564500382025168e-23,  9.794506673839002e-27, -9.422353102403415e-28,  1.473710572876498e+00, -2.519874087172867e-03, -5.508131979302652e-06,
  3.801469162919855e-09,  6.422002997812491e-11,  1.225715699478654e-13, -5.365759638735186e-16, -3.287524451409132e-18, -9.842359415468157e-22,  5.058866760854918e-23,
  1.643129464197106e-25, -3.913956852046554e-28,  1.544195596748747e+00, -2.302593876595400e-03, -5.888982549664740e-06, -1.086331220150837e-09,  5.497311645956003e-11,
  1.835174971011835e-13, -1.507561355305758e-16, -3.172687921657489e-18, -8.341627570034187e-21,  2.277023304236718e-23,  2.186763874203413e-25,  3.741802257021722e-28,
  1.611469035647965e+00, -2.061871967380197e-03, -6.018093955493266e-06, -5.600017194161673e-09,  3.990605323031000e-11,  2.087966455528113e-13,  2.391104128007319e-16,
 -2.109872567281142e-18, -1.183890793943939e-20, -1.284620689733048e-23,  1.452037807572035e-25,  8.063049316924330e-28,  1.674978299690856e+00, -1.804138634005297e-03,
 -5.891780559462832e-06, -9.325597878374449e-09,  2.134857389916996e-11,  1.948404391747939e-13,  5.287791353674034e-16, -5.201717096713143e-19, -1.026238499296726e-20,
 -3.730621243593785e-23,  2.415312063094068e-28,  6.298719050363261e-28,  1.734182069412283e+00, -1.536710012233303e-03, -5.523646635749522e-06, -1.192951770942618e-08,
  2.226015092455200e-12,  1.471166006698605e-13,  6.462267754031097e-16,  9.870374432144149e-19, -4.838040590779263e-21, -3.902841021560024e-23, -1.161580135450740e-25,
  6.177125707087398e-29,  1.788557888551128e+00, -1.267582971533048e-03, -4.944899061395850e-06, -1.320702354847854e-08, -1.446654602504739e-11,  7.900766085421619e-14,
  5.765030273728602e-16,  1.872040021996745e-18,  1.437819120348832e-21, -2.072396084857619e-23, -1.344774592667925e-25, -3.998204295698862e-28,  1.837610211186095e+00,
 -1.005176340008785e-03, -4.203143275657252e-06, -1.311703824473169e-08, -2.625304111468260e-11,  8.323588805358556e-15,  3.666484565292763e-16,  1.899644868993171e-18,
  5.479488379179754e-21,  3.270712402995729e-24, -6.462203306848850e-26, -4.292491926564186e-28,  1.880878696705308e+00, -7.580262047017678e-04, -3.359571107740886e-06,
 -1.179603773207242e-08, -3.169843103259171e-11, -4.771339941775240e-14,  1.067950112026727e-16,  1.229921591455210e-18,  5.824406097475261e-21,  1.759168073359567e-23,
  2.175266282102429e-26, -1.316843548233026e-28,  1.917946502506682e+00, -5.344478113585289e-04, -2.484627577460943e-06, -9.545985494801612e-09, -3.073068688743350e-11,
 -7.752037016453949e-14, -1.063517256776228e-16,  3.099499808229833e-19,  3.292701806996524e-21,  1.643394696806227e-23,  5.818738582113368e-26,  1.366103122976146e-28,
  1.948448293560958e+00, -3.421810439199721e-04, -1.652444053538976e-06, -6.795444848816093e-09, -2.466293746003842e-11, -7.854198417605772e-14, -2.087022329968704e-16,
 -3.801257352923248e-19,  1.643209655791080e-22,  5.954425013000230e-24,  3.672674525565013e-26,  1.612182987352261e-28,  1.972077689160492e+00, -1.880398627197725e-04,
 -9.345173152627241e-07, -4.037934731564542e-09, -1.588400401222655e-11, -5.768882786343881e-14, -1.930653216056451e-16, -5.847856645423775e-19, -1.525443078444718e-21,
 -2.907691524424161e-24, -2.073380786790203e-28,  3.594630409300514e-29,  1.988594021436083e+00, -7.758701523778906e-05, -3.932595194607580e-07, -1.756394486205625e-09,
 -7.272701129845169e-12, -2.851109225975035e-14, -1.068192643048036e-16, -3.837736836612250e-19, -1.321146298748628e-21, -4.336363513545665e-24, -1.342332313813096e-26,
 -3.832201959868628e-29,  1.997830523937250e+00, -1.484006875082043e-05, -7.604196877266204e-08, -3.457955818496967e-10, -1.471239646279905e-12, -5.994689334187550e-15,
 -2.367982528947146e-17, -9.132802545008964e-20, -3.454231727356719e-22, -1.284813942515861e-24, -4.708173282537603e-27, -1.701626303017408e-29,  6.229676122037324e-04,
 -3.498952141553559e-06,  1.473490483651787e-08, -5.513807018497424e-11,  1.933399558163772e-13, -6.504697038387073e-16,  2.126226095670246e-18, -6.803272221015978e-21,
  2.140978021124560e-23, -6.648247346464012e-26,  2.041608126616718e-28, -6.210639983010071e-31,  5.603826821790866e-03, -3.141091341539535e-05,  1.317239423147607e-07,
 -4.893951103332149e-10,  1.697415431249945e-12, -5.622787015437116e-15,  1.799661598527291e-17, -5.601545568487826e-20,  1.701551327303232e-22, -5.053623055109037e-25,
  1.468209543977803e-27, -4.170233196463627e-30,  1.555015451563196e-02, -8.681046978458096e-05,  3.609786233348258e-07, -1.321805174822771e-09,  4.482765184359922e-12,
 -1.437321758728769e-14,  4.395372845231384e-17, -1.285219170052860e-19,  3.585311468812177e-22, -9.471341685851665e-25,  2.331420713602306e-27, -5.164166533943041e-30,
  3.043106506498505e-02, -1.688511437507832e-04,  6.931690856978559e-07, -2.482145450990361e-09,  8.125713476441797e-12, -2.470123533270257e-14,  6.978371760574907e-17,
 -1.810611341536020e-19,  4.174305025786783e-22, -7.791160218222903e-25,  7.415768272049790e-28,  2.675904506224224e-30,  5.019997000439702e-02, -2.762689593083347e-04,
  1.114593119667325e-06, -3.869989165729824e-09,  1.204411330290431e-11, -3.375409644315245e-14,  8.330946658266246e-17, -1.679985601010642e-19,  1.989642856502397e-22,
  3.880081697908554e-25, -3.935284539633136e-27,  1.831429240662581e-29,  7.479426724754734e-02, -4.073896191902091e-04,  1.607527888088664e-06, -5.360436614585054e-09,
  1.555735163088973e-11, -3.850533182396688e-14,  7.352121126665647e-17, -5.876356014121004e-20, -3.395885833377318e-22,  2.372335587139066e-24, -9.719066973568201e-27,
  3.043731715708346e-29,  1.041349289572022e-01, -5.601385567940923e-04,  2.150699512210475e-06, -6.811486892796754e-09,  1.795971460185885e-11, -3.629862599775872e-14,
  3.377074923860694e-17,  1.471317259344743e-19, -1.082307793950903e-21,  4.317425849782075e-24, -1.237673443365676e-26,  2.285390311503390e-29,  1.381259903576540e-01,
 -7.320542768725475e-04,  2.719870232088376e-06, -8.072806932672946e-09,  1.860160511972575e-11, -2.538549636086681e-14, -3.563698012314059e-17,  4.122700771722070e-19,
 -1.758365501511477e-21,  4.942500873200963e-24, -7.542822625750004e-27, -1.325476207151808e-29,  1.766539428128386e-01, -9.203055020296400e-04,  3.288541717113952e-06,
 -8.995579803254243e-09,  1.697200415701432e-11, -5.378795681482041e-15, -1.260838676878086e-16,  6.642128954824687e-19, -2.013459503079782e-21,  3.110016247659550e-24,
  6.210196178439651e-27, -6.738776204693022e-29,  2.195870358541445e-01, -1.121712742291681e-03,  3.828771226030260e-06, -9.443032952168954e-09,  1.277471596140446e-11,
  2.245456955864556e-14, -2.209886244139654e-16,  8.102692554782660e-19, -1.536775829056167e-21, -1.485294618573117e-24,  2.497191615973134e-26, -1.075436228101346e-28,
  2.667744946101146e-01, -1.332774999444623e-03,  4.312094522345455e-06, -9.301160702589122e-09,  5.990446681394746e-12,  5.512781257198854e-14, -2.980847580000934e-16,
  7.622737341744124e-19, -2.080437952368108e-22, -7.813433218897005e-24,  3.951391949348990e-26, -9.374877943575420e-29,  3.180456613538749e-01, -1.549702401821009e-03,
  4.710545565886238e-06, -8.489067289306183e-09, -3.083229612522466e-12,  8.814088507520604e-14, -3.334938813266851e-16,  4.662835420069348e-19,  1.787247899922345e-21,
 -1.350350475790274e-23,  3.865649854286736e-26, -4.256731984267572e-30,  3.732090727370806e-01, -1.768455632181265e-03,  4.997757863626826e-06, -6.968272869135581e-09,
 -1.382131148108370e-11,  1.159743548758055e-13, -3.070608996713407e-16, -7.050644318337491e-20,  3.928822653578939e-21, -1.550932198409949e-23,  1.526966291592310e-26,
  1.390518635454053e-28,  4.320514878185390e-01, -1.984793052298014e-03,  5.150125847969646e-06, -4.750254045775214e-09, -2.529605496124008e-11,  1.328455216094758e-13,
 -2.080280355032841e-16, -7.645001744317460e-19,  5.456470986036609e-21, -1.135676161843977e-23, -2.764286804648773e-26,  2.648955166649908e-28,  4.943368863173212e-01,
 -2.194326431070641e-03,  5.147996701735070e-06, -1.901444634559217e-09, -3.634034283400865e-11,  1.336556151659506e-13, -3.982686535297796e-17, -1.459928440664227e-18,
  5.590561055072259e-21, -5.699331353795264e-25, -7.439983540662237e-26,  2.796691433135126e-28,  5.598054617114901e-01, -2.392586133617222e-03,  4.976853722841693e-06,
  1.455082691033903e-09, -4.564975741727269e-11,  1.150094064964843e-13,  1.773464945020120e-16, -1.956755375925598e-18,  3.831398467302115e-21,  1.436204457995062e-23,
 -1.006286160583465e-25,  1.230038355623010e-28,  6.281726399326968e-01, -2.575096508695643e-03,  4.628441846220535e-06,  5.141978709666910e-09, -5.191895275262880e-11,
  7.614694443018072e-14,  4.073502761347106e-16, -2.060345519916703e-18,  2.434105846380691e-22,  2.812791488443406e-23, -8.406997999837473e-26, -1.752134218107121e-28,
  6.991281615076719e-01, -2.737461999769488e-03,  4.101774786847924e-06,  8.934613614677818e-09, -5.400268037883563e-11,  1.960086989240125e-14,  6.029976772920958e-16,
 -1.643417333143400e-18, -4.396307435359994e-21,  3.418651302024424e-23, -1.843376397141050e-26, -4.770158860381549e-28,  7.723352730492460e-01, -2.875464177378432e-03,
  3.403952229559372e-06,  1.257305958736239e-08, -5.108617250373348e-11, -4.860737391331506e-14,  7.149032791279098e-16, -7.037147654235298e-19, -8.691725595515518e-21,
  2.753480817139183e-23,  7.696520606526203e-26, -5.882842335486111e-28,  8.474300829004854e-01, -2.985169422469868e-03,  2.550705764573478e-06,  1.577905737374519e-08,
 -4.284421732941421e-11, -1.193828121774696e-13,  7.030696951838037e-16,  6.031805969778272e-19, -1.100540512531406e-20,  7.653553101061712e-24,  1.594902786867352e-25,
 -3.727474787428697e-28,  9.240211452717161e-01, -3.063046358659711e-03,  1.566585513854308e-06,  1.827748180258977e-08, -2.956416690269798e-11, -1.816543535335488e-13,
  5.488940001144954e-16,  1.974669938649854e-18, -1.005192398307963e-20, -1.985493754446116e-23,  1.806583439775211e-25,  1.305179348447629e-28,  1.001689347018005e+00,
 -3.106091317836355e-03,  4.846977599502293e-07,  1.982122014231716e-08, -1.220655555017095e-11, -2.241020813095970e-13,  2.644251166115442e-16,  3.024944948106897e-18,
 -5.517263382731324e-21, -4.428302816137006e-23,  1.134380478861371e-25,  6.737749018109063e-28,  1.079988180731359e+00, -3.111959120430465e-03, -6.540900489651696e-07,
  2.021769065772090e-08,  7.620640069198468e-12, -2.373075248481682e-13, -1.045004026541595e-16,  3.394516823151381e-18,  1.566560492033724e-21, -5.385561434352672e-23,
 -2.484194886265496e-26,  9.110351179932517e-28,  1.158444496287842e+00, -3.079095268896862e-03, -1.802543965010254e-06,  1.935452287394170e-08,  2.779056112808419e-11,
 -2.159597797563054e-13, -4.838319135197963e-16,  2.878081264591916e-18,  8.942048674511468e-21, -4.154349170233357e-23, -1.708884378270999e-25,  6.207610751218148e-28,
  1.236559829359804e+00, -3.006864326333114e-03, -2.909095114341420e-06,  1.722130091105123e-08,  4.589196735331165e-11, -1.606254734615560e-13, -7.862454361537546e-16,
  1.526865107236612e-18,  1.383586178880320e-20, -9.884749277011411e-24, -2.435817894109579e-25, -9.651469848495439e-29,  1.313812408377210e+00, -2.895667852701107e-03,
 -3.920500330983005e-06,  1.392388025070348e-08,  5.955402629965006e-11, -7.855192403225699e-14, -9.332391520742972e-16, -3.221793221489616e-19,  1.408335007145916e-20,
  2.833713047572365e-23, -1.918557998603476e-25, -8.157574714412601e-28,  1.389659939459018e+00, -2.747043913446147e-03, -4.785063053447841e-06,  9.687797123482554e-09,
  6.682355206983001e-11,  1.693103189997860e-14, -8.790464874410384e-16, -2.121741857012913e-18,  9.217765181942454e-21,  5.517528308603219e-23, -3.402348326193365e-26,
 -1.044083720152984e-27,  1.463543260228003e+00, -2.563739023031965e-03, -5.456270681351727e-06,  4.847870059430382e-09,  6.653521595008261e-11,  1.085873068368422e-13,
 -6.287849687881693e-16, -3.288649606716654e-18,  9.505794868238775e-22,  5.675823682279208e-23,  1.427006131620846e-25, -5.923758850463779e-28,  1.534890936436049e+00,
 -2.349742650686341e-03, -5.896620704184209e-06, -1.776258796256220e-10,  5.859993682093133e-11,  1.788039819229478e-13, -2.431930025851908e-16, -3.424786231072751e-18,
 -7.360832486901062e-21,  3.180777364485858e-23,  2.321692660059654e-25,  2.325679741735378e-28,  1.603124848418629e+00, -2.110274346109206e-03, -6.081324421671844e-06,
 -4.927821940454131e-09,  4.413436454215012e-11,  2.137831832761296e-13,  1.746690231558370e-16, -2.494926125890052e-18, -1.218819447183445e-20, -6.320146036308271e-24,
  1.812493119108972e-25,  8.267705278302247e-28,  1.667666776514367e+00, -1.851714399757129e-03, -6.001507457828621e-06, -8.952162333272492e-09,  2.537091288096923e-11,
  2.073180124454610e-13,  5.094152171477952e-16, -8.699978744293859e-19, -1.159818109979441e-20, -3.670108494730932e-23,  3.103964166605684e-26,  7.704692720889150e-28,
  1.727945945530395e+00, -1.581470967555865e-03, -5.666487299315195e-06, -1.186951106721128e-08,  5.325584094242583e-12,  1.629388633725625e-13,  6.714788071652428e-16,
  8.088503684146870e-19, -6.325733779468893e-21, -4.358612655479328e-23, -1.108315124081852e-25,  1.848557033009869e-28,  1.783407429155662e+00, -1.307779910990454e-03,
 -5.104717503290382e-06, -1.342507739303472e-08, -1.274376248789007e-11,  9.347721078288042e-14,  6.294445322535817e-16,  1.905040727369820e-18,  5.907054400442134e-22,
 -2.645327372191686e-23, -1.519131887787629e-25, -3.894326813601189e-28,  1.833521248578280e+00, -1.039438229027635e-03, -4.363060933974983e-06, -1.353525857646688e-08,
 -2.599416252005973e-11,  1.778133629048299e-14,  4.223072476995381e-16,  2.076335322327598e-18,  5.545959318656166e-21,  2.866099172718209e-25, -8.512157682769671e-26,
 -5.031446946068611e-28,  1.877791929983307e+00, -7.854776769079788e-04, -3.504197616725033e-06, -1.231069541648935e-08, -3.262416740550882e-11, -4.471541356742859e-14,
  1.439384825076445e-16,  1.426590971831879e-18,  6.471815821633766e-21,  1.832854389950029e-23,  1.463610089735514e-26, -1.941047947737678e-28,  1.915768219768060e+00,
 -5.547915167452305e-04, -2.602181153420071e-06, -1.005021525478249e-08, -3.230585182514038e-11, -7.995619896721526e-14, -9.610578451140743e-17,  4.252433625297072e-19,
  3.927667992091912e-21,  1.888164510829542e-23,  6.418728516191371e-26,  1.351722785031475e-28,  1.947052604196398e+00, -3.557336071898712e-04, -1.736409762845076e-06,
 -7.202894318824752e-09, -2.628472385526291e-11, -8.367775727307384e-14, -2.192378082590650e-16, -3.711398240041400e-19,  4.069073293691240e-22,  7.573574354493880e-24,
  4.444058614853339e-26,  1.900359411114820e-28,  1.971310264332368e+00, -1.957142319087951e-04, -9.845363020140252e-07, -4.301566433035047e-09, -1.708547145843629e-11,
 -6.252449626553100e-14, -2.101384475691893e-16, -6.352729628917280e-19, -1.629854736743665e-21, -2.880644495844488e-24,  1.657321317155378e-27,  4.936316411548492e-29,
  1.988277244885824e+00, -8.081942076384765e-05, -4.150537113228838e-07, -1.877462512723646e-09, -7.869455312634266e-12, -3.120862785871361e-14, -1.181810277150822e-16,
 -4.286551192320464e-19, -1.487339120860153e-21, -4.908407310714569e-24, -1.521399966169367e-26, -4.314564809699987e-29,  1.997769920133055e+00, -1.546541218306731e-05,
 -8.033681371038527e-08, -3.703263374508576e-10, -1.597030364474605e-12, -6.594984482657054e-15, -2.639898087606951e-17, -1.031594844048729e-19, -3.952549113118983e-22,
 -1.489014089013182e-24, -5.525114535632633e-27, -2.021450058090277e-29,  6.092034445828757e-04, -3.383667912778865e-06,  1.409138812755656e-08, -5.214599684779312e-11,
  1.808258171037813e-13, -6.016509156614742e-16,  1.944977186901335e-18, -6.154928946241413e-21,  1.915705473284337e-23, -5.883711529668713e-26,  1.787136222012254e-28,
 -5.377540536848229e-31,  5.480254197906279e-03, -3.038015954194819e-05,  1.260105164195495e-07, -4.631131641773418e-10,  1.589154945696104e-12, -5.209090557784653e-15,
  1.650175648328253e-17, -5.085059491389095e-20,  1.529764246523395e-22, -4.501460550531187e-25,  1.296372887232132e-27, -3.652457883617278e-30,  1.520858953031339e-02,
 -8.398488961505956e-05,  3.455380027437613e-07, -1.252324531626371e-09,  4.205564808579872e-12, -1.336024589275857e-14,  4.051073662569105e-17, -1.175769076096078e-19,
  3.260593722944892e-22, -8.582910724741796e-25,  2.113926677323316e-27, -4.725878230040274e-30,  2.976656562380593e-02, -1.634227608159009e-04,  6.641473960857041e-07,
 -2.355996931928256e-09,  7.648033907088043e-12, -2.308577892900249e-14,  6.489684020200831e-17, -1.681461912314688e-19,  3.899419776897831e-22, -7.473869023542317e-25,
  8.381410232469088e-28,  1.750028609304558e-30,  4.911243809607752e-02, -2.675347484404487e-04,  1.069287554412701e-06, -3.682576959017378e-09,  1.138864839446810e-11,
 -3.181038544794703e-14,  7.869653506478161e-17, -1.614370684810375e-19,  2.102851990569318e-22,  2.458214914279817e-25, -3.195291770714383e-27,  1.539672735416918e-29,
  7.319002772145268e-02, -3.947825233514526e-04,  1.544671049925215e-06, -5.117584550459743e-09,  1.480475078843404e-11, -3.676171896751750e-14,  7.173601491496889e-17,
 -6.833640157437000e-20, -2.608686447284757e-22,  2.009353966004662e-24, -8.454405685577798e-27,  2.708868600156845e-29,  1.019282750733738e-01, -5.432550819060225e-04,
  2.070661991314818e-06, -6.529893870180161e-09,  1.724216112745382e-11, -3.544246513357570e-14,  3.742825977033711e-17,  1.148911345103665e-19, -9.355490890680964e-22,
  3.842489988006174e-24, -1.137059655049498e-26,  2.278299255080569e-29,  1.352406847323371e-01, -7.106777889808590e-04,  2.624765408482740e-06, -7.779285588293387e-09,
  1.808624517547684e-11, -2.610845708797998e-14, -2.485483803508231e-17,  3.587900160804216e-19, -1.585987855199415e-21,  4.631187457844652e-24, -7.974684208132648e-27,
 -6.637606770693976e-30,  1.730246603132914e-01, -8.944243489512399e-04,  3.182220006255673e-06, -8.725046563754787e-09,  1.683563736724523e-11, -8.188808616317929e-15,
 -1.083707957000619e-16,  6.016159362671255e-19, -1.897706934275044e-21,  3.302967107637954e-24,  3.529419271781128e-27, -5.474515849793656e-29,  2.151607325022676e-01,
 -1.091532331045783e-03,  3.716695110731291e-06, -9.235325321603369e-09,  1.317257886883900e-11,  1.741749332138093e-14, -1.989962773895924e-16,  7.604206324535549e-19,
 -1.573375757699201e-21, -5.776190382397792e-25,  2.049697394690115e-26, -9.586453637651641e-29,  2.615116836441506e-01, -1.298722988273224e-03,  4.201090821830711e-06,
 -9.196874568111303e-09,  7.023186475982460e-12,  4.822890086814392e-14, -2.768744553775480e-16,  7.514127494179807e-19, -4.618749892706247e-22, -6.315715307800658e-24,
  3.536922873821623e-26, -9.413926057136545e-29,  3.119215742956736e-01, -1.512426219990984e-03,  4.608437545074279e-06, -8.524726747873104e-09, -1.399361378668480e-12,
  8.029972735443334e-14, -3.197082124638372e-16,  5.159951259418276e-19,  1.328850109290436e-21, -1.196740968137137e-23,  3.799930019265177e-26, -2.471830937222679e-29,
  3.662146796671847e-01, -1.728811632089410e-03,  4.912886988110932e-06, -7.171258785657143e-09, -1.157560765923049e-11,  1.085948983378499e-13, -3.073579975301162e-16,
  4.641169069279918e-20,  3.382854038543516e-21, -1.478727820949155e-23,  2.056525325613034e-26,  1.023621152481426e-28,  4.241943471538818e-01, -1.943826738107333e-03,
  5.090781158435553e-06, -5.134013838229805e-09, -2.269070480251142e-11,  1.276153224506700e-13, -2.270523964570352e-16, -5.966257848475253e-19,  5.030444908682612e-21,
 -1.223914139860483e-23, -1.672111882066816e-26,  2.312855357478555e-28,  4.856417903431209e-01, -2.153243408620875e-03,  5.121778700584565e-06, -2.461570690968114e-09,
 -3.367999577298839e-11,  1.322294110131101e-13, -7.820733034951570e-17, -1.281909064128615e-18,  5.519440595718169e-21, -3.300022904861389e-24, -6.212723137289820e-26,
  2.766034520164653e-28,  5.503148401256244e-01, -2.352713700374010e-03,  4.990008943455635e-06,  7.433009640178213e-10, -4.331137052165158e-11,  1.186225571382508e-13,
  1.243460649119002e-16, -1.826643479759997e-18,  4.277415663348890e-21,  1.045943321289387e-23, -9.417267513188635e-26,  1.682227127176257e-28,  6.179466799777850e-01,
 -2.537836161805811e-03,  4.685213295373274e-06,  4.323970574591631e-09, -5.030291422774026e-11,  8.523286723272332e-14,  3.499171706167879e-16, -2.037017304371542e-18,
  1.193854401252712e-21,  2.463577920061850e-23, -8.993539966110745e-26, -9.267979993479005e-29,  6.882446002444083e-01, -2.704233593927130e-03,  4.203821333138606e-06,
  8.074477259936837e-09, -5.346974816324686e-11,  3.350585997517712e-14,  5.551962175621944e-16, -1.764589817926314e-18, -3.183727508167964e-21,  3.305103254104429e-23,
 -3.779081448562083e-26, -4.016504991997551e-28,  7.608888154210206e-01, -2.847643015982748e-03,  3.549895591291810e-06,  1.174882862846750e-08, -5.188849769103313e-11,
 -3.171663674721553e-14,  6.914583341558248e-16, -9.654463390631244e-19, -7.651285473411362e-21,  3.009717819510154e-23,  5.123036472690435e-26, -5.777542635877432e-28,
  8.355313990273113e-01, -2.964018210706309e-03,  2.735865599279526e-06,  1.507537047940644e-08, -4.506197326352019e-11, -1.023459685738784e-13,  7.150783358768936e-16,
  2.566136264119810e-19, -1.061924397291199e-20,  1.367834901508415e-23,  1.411305364851424e-25, -4.577038172111837e-28,  9.117954025832089e-01, -3.049644668249490e-03,
  1.782959611891085e-06,  1.777612433031046e-08, -3.306123133256923e-11, -1.678543665511364e-13,  5.995840369242869e-16,  1.642975178629112e-18, -1.063564851370933e-20,
 -1.255812609517437e-23,  1.830949765471086e-25, -1.864886240344009e-29,  9.892742381901267e-01, -3.101265975626537e-03,  7.212338596635390e-07,  1.959043215085573e-08,
 -1.661838381212162e-11, -2.167608877550275e-13,  3.464187509553571e-16,  2.823817191519055e-18, -7.022943650397016e-21, -3.918711302931565e-23,  1.404617130438221e-25,
  5.508686637540042e-28,  1.067531417803186e+00, -3.116219680288510e-03, -4.109031555086450e-07,  2.030154782104723e-08,  2.857129894889642e-12, -2.386711085402919e-13,
 -9.044491098718599e-18,  3.413512774097030e-18, -3.804368630843092e-22, -5.404481838011467e-23,  1.537770940833521e-26,  9.104850939133452e-28,  1.146100755686350e+00,
 -3.092579376705928e-03, -1.567766297589791e-06,  1.976401533333258e-08,  2.336193443954720e-11, -2.265738036234083e-13, -3.994735164307854e-16,  3.139034678006865e-18,
  7.330440607341389e-21, -4.778757977242236e-23, -1.402461801707914e-25,  7.675070523027253e-28,  1.224487152643835e+00, -3.029298232924981e-03, -2.698143166582996e-06,
  1.792886247989112e-08,  4.249447883344262e-11, -1.789327029530478e-13, -7.373616804819907e-16,  1.962033918087946e-18,  1.330415829954336e-20, -1.965239151054864e-23,
 -2.432802331270542e-25,  1.120250103246087e-28,  1.302168089877364e+00, -2.926347437718577e-03, -3.747752373871529e-06,  1.486295728039586e-08,  5.775854671105138e-11,
 -1.010061025921595e-13, -9.358084289604233e-16,  1.432606080371965e-19,  1.495698929815707e-20,  1.997741145254833e-23, -2.252478375682217e-25, -6.946549995842025e-28,
  1.378595964753633e+00, -2.784841209415518e-03, -4.662387019274753e-06,  1.075851706916733e-08,  6.694656944878598e-11, -4.843833914539484e-15, -9.340294919197088e-16,
 -1.795346298601045e-18,  1.116830177736325e-20,  5.287358743522521e-23, -8.153053349582861e-26, -1.108369556983510e-27,  1.453201398003330e+00, -2.607138233570646e-03,
 -5.391639933614507e-06,  5.928956326578196e-09,  6.854862095237920e-11,  9.239684467705752e-14, -7.201265813564838e-16, -3.224491258927758e-18,  3.089790206394940e-21,
  6.188471306943962e-23,  1.121338323587216e-25, -7.966825671039159e-28,  1.525397629260374e+00, -2.396907933621265e-03, -5.893009727631537e-06,  7.882315542931539e-10,
  6.210974988903379e-11,  1.717911274926431e-13, -3.421996463206417e-16, -3.640202197317133e-18, -6.046579200865656e-21,  4.124872546334262e-23,  2.385591935480600e-25,
  5.149040872865038e-29,  1.594586092706712e+00, -2.159149146079481e-03, -6.136079618069977e-06, -4.187263576848525e-09,  4.844606180353851e-11,  2.170927136965815e-13,
  9.932696376613591e-17, -2.887118408243868e-18, -1.227646478979473e-20,  1.655545844388801e-24,  2.174176367195649e-25,  8.104854240764143e-28,  1.660163224594955e+00,
 -1.900148942928545e-03, -6.106358841013906e-06, -8.512401620190818e-09,  2.963733773605229e-11,  2.192085087783934e-13,  4.796627699497283e-16, -1.261971076027029e-18,
 -1.288852414202346e-20, -3.474008960693154e-23,  6.802670079675555e-26,  9.099043677575492e-28,  1.721528498159306e+00, -1.627370900530406e-03, -5.808299780064342e-06,
 -1.175734862533528e-08,  8.747226270287256e-12,  1.793017746153818e-13,  6.910508048341700e-16,  5.804840664634018e-19, -7.972290497798717e-21, -4.781432771281437e-23,
 -9.947909372415190e-26,  3.358108749760596e-28,  1.778093609026317e+00, -1.349265373526870e-03, -5.266977429851823e-06, -1.361318228071626e-08, -1.071882380241118e-11,
  1.092251865392248e-13,  6.828985902302704e-16,  1.907500369415410e-18, -4.750505287334858e-22, -3.286457991627847e-23, -1.684105930024834e-25, -3.561693715905213e-28,
  1.829292648066078e+00, -1.074999448618292e-03, -4.527965902108784e-06, -1.394774934693739e-08, -2.553236933203696e-11,  2.863439803518063e-14,  4.829258351738937e-16,
  2.253269331034608e-18,  5.489451105525124e-21, -3.583363597299364e-24, -1.089317088139449e-25, -5.792346625584636e-28,  1.874593003885286e+00, -8.141111116741229e-04,
 -3.655086747831502e-06, -1.283963485534640e-08, -3.348057138694159e-11, -4.075754005129092e-14,  1.868822998733982e-16,  1.644341331701904e-18,  7.139928155960180e-21,
  1.872154333787862e-23,  4.450185657215828e-27, -2.715296044140482e-28,  1.913506642419586e+00, -5.761002858229826e-04, -2.725938263600382e-06, -1.058002288570752e-08,
 -3.392700060986028e-11, -8.210500749668837e-14, -8.233358786896672e-17,  5.623116246202506e-19,  4.655039507580705e-21,  2.156623206618715e-23,  6.998217250998032e-26,
  1.269077065655070e-28,  1.945601329528080e+00, -3.699779027298202e-04, -1.825423991124454e-06, -7.637127731203936e-09, -2.801172910048183e-11, -8.906243166678128e-14,
 -2.294038972126928e-16, -3.533964207112812e-19,  7.136528740856154e-22,  9.527765687183195e-24,  5.350706203436928e-26,  2.227256064772071e-28,  1.970511321216452e+00,
 -2.038017416099174e-04, -1.037837475045429e-06, -4.585218071360375e-09, -1.838786627356927e-11, -6.778725953148051e-14, -2.286717383116117e-16, -6.890702439022680e-19,
 -1.731798461613497e-21, -2.766158941356886e-24,  4.191934812593254e-27,  6.653746696955112e-29,  1.987947180570537e+00, -8.423215760589084e-05, -4.383598374643823e-07,
 -2.008525465933346e-09, -8.522992010109369e-12, -3.419454642824914e-14, -1.308771226082772e-16, -4.791984692885457e-19, -1.675467139960918e-21, -5.556452709006004e-24,
 -1.722658214030717e-26, -4.840530402397184e-29,  1.997706744323738e+00, -1.612632700221816e-05, -8.493851162053871e-08, -3.969694535123749e-10, -1.735507377651713e-12,
 -7.264701951988753e-15, -2.947289367473435e-17, -1.167097710595618e-19, -4.530616112475667e-22, -1.728888667087910e-24, -6.496631904714756e-27, -2.406355593942893e-29,
  5.958903402978541e-04, -3.273391529302329e-06,  1.348260641264870e-08, -4.934656904361821e-11,  1.692459838144076e-13, -5.569721563447046e-16,  1.780912685315020e-18,
 -5.574458663775239e-21,  1.716209014235656e-23, -5.213997692278272e-26,  1.566632086837063e-28, -4.663417039149433e-31,  5.360715131370427e-03, -2.939388037270548e-05,
  1.206023477286797e-07, -4.384990955789348e-10,  1.488821023508228e-12, -4.829595662803950e-15,  1.514410664608685e-17, -4.620493150188321e-20,  1.376670813493325e-22,
 -4.013681711994775e-25,  1.145800728129586e-27, -3.202049483293573e-30,  1.487808499182125e-02, -8.127957322683866e-05,  3.309051929327972e-07, -1.187121406511399e-09,
  3.947821777425896e-12, -1.242634300067562e-14,  3.736012677145956e-17, -1.076214631415672e-19,  2.966339352525475e-22, -7.777693116350920e-25,  1.915169344635237e-27,
 -4.312911164522971e-30,  2.912332477437700e-02, -1.582206237831483e-04,  6.365946773543644e-07, -2.237239064263627e-09,  7.201519397186058e-12, -2.158336648048916e-14,
  6.035944293095679e-17, -1.560919355618770e-19,  3.636559807507299e-22, -7.125478404419470e-25,  8.985350761087215e-28,  1.024894401630565e-30,  4.805913213766103e-02,
 -2.591541616794597e-04,  1.026169274543972e-06, -3.505347149200097e-09,  1.077096567605367e-11, -2.997514374308950e-14,  7.427166688059289e-17, -1.545897376881694e-19,
  2.169904341363257e-22,  1.307963789046861e-25, -2.574113530227204e-27,  1.290389161826361e-29,  7.163522904053521e-02, -3.826668273916197e-04,  1.484657329857198e-06,
 -4.886497535816240e-09,  1.408657346590824e-11, -3.506389437914970e-14,  6.971614903882269e-17, -7.558980292237897e-20, -1.943403151222975e-22,  1.694087138642686e-24,
 -7.331441143018639e-27,  2.399880572157455e-29,  9.978789561604556e-02, -5.269985845637121e-04,  1.993935281256418e-06, -6.259640245604540e-09,  1.654253822779570e-11,
 -3.450884169677104e-14,  4.024626658316467e-17,  8.708101008256554e-20, -8.051658819898674e-22,  3.407577772014775e-24, -1.037919399199448e-26,  2.221146311668364e-29,
  1.324393854897964e-01, -6.900481918414267e-04,  2.533132933480281e-06, -7.494112114874529e-09,  1.755889561506779e-11, -2.659000284906860e-14, -1.549461790566281e-17,
  3.106439314535610e-19, -1.425062382680288e-21,  4.307973975322027e-24, -8.148468302552905e-27, -1.482079513951670e-30,  1.694972217813996e-01, -8.693808251800590e-04,
  3.079129821661069e-06, -8.457122285432847e-09,  1.664718167396366e-11, -1.059431613565999e-14, -9.235767856305288e-17,  5.428145618159495e-19, -1.776808729224034e-21,
  3.399319595880484e-24,  1.368234855916962e-27, -4.375541748115165e-29,  2.108533735062263e-01, -1.062238458009700e-03,  3.607146448962006e-06, -9.022029615261468e-09,
  1.347486479786337e-11,  1.289138091269112e-14, -1.784114167228016e-16,  7.098900900714782e-19, -1.580397718997548e-21,  1.613047587854448e-25,  1.653288160724026e-26,
 -8.438201088765961e-29,  2.563833129723825e-01, -1.265553730373493e-03,  4.091433233939677e-06, -9.077140883841096e-09,  7.923009340057671e-12,  4.183451795901691e-14,
 -2.560740991167229e-16,  7.332598730310086e-19, -6.647688612378845e-22, -4.983283770367386e-24,  3.126909221529511e-26, -9.185174252893456e-29,  3.059449561573820e-01,
 -1.475968167768844e-03,  4.506058146399268e-06, -8.534680479336471e-09,  1.310966566646089e-13,  7.280452208557217e-14, -3.047277140236083e-16,  5.519160306584724e-19,
  9.250758136599149e-22, -1.047405515812613e-23,  3.655673838972208e-26, -4.006376118161798e-29,  3.593774900842835e-01, -1.689855742708143e-03,  4.825791000423893e-06,
 -7.339493463627305e-09, -9.477309197360210e-12,  1.012456471246640e-13, -3.046218003237365e-16,  1.463125268067595e-19,  2.866314418716542e-21, -1.388441352348053e-23,
  2.434303288451693e-26,  7.010602032236344e-29,  4.165000940549903e-01, -1.903352901350976e-03,  5.027077937016164e-06, -5.476948097675062e-09, -2.019415180985425e-11,
  1.219833775045235e-13, -2.415713253604336e-16, -4.428110800273276e-19,  4.580157084038007e-21, -1.271457091038944e-23, -7.300922711269100e-27,  1.969053183281396e-28,
  4.771105654194369e-01, -2.112396295101218e-03,  5.089093481278217e-06, -2.979407746203679e-09, -3.105698206083923e-11,  1.299415456033795e-13, -1.116492168560876e-16,
 -1.107643754778042e-18,  5.358816291011272e-21, -5.544553609916003e-24, -5.018355170324958e-26,  2.650694712009720e-28,  5.409838655654733e-01, -2.312769549798317e-03,
  4.994849432743701e-06,  6.944368491123734e-11, -4.091313783143666e-11,  1.210088999225791e-13,  7.516783990220746e-17, -1.684453441408380e-18,  4.588030861166897e-21,
  6.850934647674713e-24, -8.601849015703207e-26,  2.003354842932374e-28,  6.078706082231563e-01, -2.500160454825385e-03,  4.732329541467495e-06,  3.533198193207899e-09,
 -4.851887102011112e-11,  9.295155298004375e-14,  2.935438721304832e-16, -1.985324678693574e-18,  2.015211331186130e-21,  2.097920005518483e-23, -9.235672433670330e-26,
 -1.899828920609811e-29,  6.774955202108865e-01, -2.670229936576709e-03,  4.295606377081985e-06,  7.225029210743695e-09, -5.267044083405338e-11,  4.622724280800838e-14,
  5.045379915709820e-16, -1.847756617729954e-18, -2.025145774539253e-21,  3.120939593245952e-23, -5.370491506699520e-26, -3.212454155619820e-28,  7.495559146161040e-01,
 -2.818694063548479e-03,  3.685882200511631e-06,  1.091442998933849e-08, -5.235920874934958e-11, -1.547267967641779e-14,  6.611634805574461e-16, -1.192605282829381e-18,
 -6.536958788501747e-21,  3.164581465737974e-23,  2.643036690737170e-26, -5.463877370621343e-28,  8.237202282609748e-01, -2.941420074484173e-03,  2.912379572776187e-06,
  1.433893777268600e-08, -4.693688821767641e-11, -8.513577256858596e-14,  7.175876570797404e-16, -7.427451312696194e-20, -1.003024291768743e-20,  1.890138609321271e-23,
  1.195874432567295e-25, -5.172701479941320e-28,  8.996266892240473e-01, -3.034536980025564e-03,  1.992991015468700e-06,  1.722108473228203e-08, -3.627089257489648e-11,
 -1.529511357942656e-13,  6.407646626386296e-16,  1.296810309855122e-18, -1.095649337093866e-20, -5.292621181223244e-24,  1.791667277918182e-25, -1.577126163582041e-28,
  9.768821960902280e-01, -3.094560610616522e-03,  9.545821540323664e-07,  1.929033440742319e-08, -2.086419328102418e-11, -2.075246937418882e-13,  4.221352667170951e-16,
  2.577640585311479e-18, -8.327073366194584e-21, -3.312446831171389e-23,  1.616380744140668e-25,  4.092400361646719e-28,  1.055061508168119e+00, -3.118532016793391e-03,
 -1.671677696391533e-07,  2.030909517690844e-08, -1.910735823478516e-12, -2.377444032649795e-13,  8.607223823397979e-17,  3.370405569309037e-18, -2.305400752941222e-21,
 -5.263751199434527e-23,  5.469403834466311e-26,  8.702205424274327e-28,  1.133706864496779e+00, -3.104166827530772e-03, -1.328506511214722e-06,  2.010106390209513e-08,
  1.874183416397098e-11, -2.350815721307203e-13, -3.085624599882723e-16,  3.345068714083930e-18,  5.517585297361419e-21, -5.268558476141879e-23, -1.038147077142695e-25,
  8.826443841291374e-28,  1.212328167966565e+00, -3.050011512488787e-03, -2.479038503955613e-06,  1.857920292417178e-08,  3.874355347447577e-11, -1.959227526079399e-13,
 -6.765841423970697e-16,  2.374582490354480e-18,  1.242327147779744e-20, -2.922205119039375e-23, -2.336429455441614e-25,  3.260020237281756e-28,  1.290403887640152e+00,
 -2.955600485882079e-03, -3.563922676818834e-06,  1.576971510193805e-08,  5.551443765641693e-11, -1.233626839229707e-13, -9.250010139117840e-16,  6.315952127633482e-19,
  1.550703913508090e-20,  1.040155588137672e-23, -2.523482283422168e-25, -5.304353295049374e-28,  1.367382845058667e+00, -2.821605702641058e-03, -4.526865130951447e-06,
  1.182765284961681e-08,  6.662166993407848e-11, -2.782165958741410e-14, -9.790146802136567e-16, -1.408230863900131e-18,  1.300120824904692e-20,  4.862807873168275e-23,
 -1.308769397556488e-25, -1.126389291673968e-27,  1.442687055930754e+00, -2.649967983720189e-03, -5.313853933314793e-06,  7.039548242407970e-09,  7.021648090467431e-11,
  7.404363806271061e-14, -8.086874331955153e-16, -3.089178803746099e-18,  5.389391633064658e-21,  6.561022912979997e-23,  7.271160967321350e-26, -9.928633189016700e-28,
  1.515715793466395e+00, -2.443997024425929e-03, -5.877476571894061e-06,  1.808992874705373e-09,  6.545508160917824e-11,  1.623348015970615e-13, -4.465977990828168e-16,
 -3.808090997273749e-18, -4.389873162772131e-21,  5.077476078279782e-23,  2.361538045085555e-25, -1.665573025362916e-28,  1.585851019655704e+00, -2.208425263664192e-03,
 -6.181532335330447e-06, -3.377290514156630e-09,  5.280497759941187e-11,  2.184622141371024e-13,  1.300911874300451e-17, -3.277264271359359e-18, -1.205185600753022e-20,
  1.105097148090410e-23,  2.519081808295855e-25,  7.492067874951984e-28,  1.652464291964335e+00, -1.949400010381027e-03, -6.205515807198935e-06, -8.002518241797177e-09,
  3.413351913625136e-11,  2.302486532366970e-13,  4.383697170302199e-16, -1.693808301401863e-18, -1.408018116960545e-20, -3.117913824826032e-23,  1.109649076538019e-25,
  1.039347580534173e-27,  1.714925191927869e+00, -1.674398993840854e-03, -5.948426957870530e-06, -1.158779860389217e-08,  1.250027466064259e-11,  1.960515915930160e-13,
  7.034687081333117e-16,  2.970936333537681e-19, -9.761212695501525e-21, -5.144733106817626e-23, -8.086852620621327e-26,  5.146187790545102e-28,  1.772611237401735e+00,
 -1.392057369337452e-03, -5.431289601606672e-06, -1.376629881791085e-08, -8.366111887594177e-12,  1.262528146136669e-13,  7.359084724182522e-16,  1.872038888114444e-18,
 -1.783065787159993e-21, -3.989838524036430e-23, -1.828252610384642e-25, -2.936702823667511e-28,  1.824919133046459e+00, -1.111899564884698e-03, -4.697769003678690e-06,
 -1.435103421086116e-08, -2.483856678854655e-11,  4.100141590773548e-14,  5.484509664770772e-16,  2.425975610828484e-18,  5.275674255887313e-21, -8.472581421599152e-24,
 -1.360732424395530e-25, -6.538523203397849e-28,  1.871277089302249e+00, -8.439772751338105e-04, -3.812402567626208e-06, -1.338158538281934e-08, -3.424700499369595e-11,
 -3.569342481219990e-14,  2.362239679168407e-16,  1.883612067543403e-18,  7.813989682996621e-21,  1.863412287889818e-23, -9.508220093721992e-27, -3.658826849409393e-28,
  1.911157808988985e+00, -5.984249866437675e-04, -2.856210051993139e-06, -1.113609339423946e-08, -3.558749538933224e-11, -8.387450731609214e-14, -6.438277436536171e-17,
  7.242459725887003e-19,  5.483117788991021e-21,  2.447277053399946e-23,  7.521606335676177e-26,  1.091866473686783e-28,  1.944091619774142e+00, -3.849556333151347e-04,
 -1.919818409171136e-06, -8.099867842259161e-09, -2.984882143523675e-11, -9.468395364239629e-14, -2.389246571316897e-16, -3.246386697798899e-19,  1.097634369560672e-21,
  1.187454264015371e-23,  6.409854359532868e-26,  2.593490251650915e-28,  1.969679153174571e+00, -2.123296383843039e-04, -1.094671050762585e-06, -4.890574754987739e-09,
 -1.980008824232697e-11, -7.351326174435064e-14, -2.487562556734545e-16, -7.460426583128244e-19, -1.827601901144392e-21, -2.533868994613445e-24,  7.581685427270264e-27,
  8.840309942388311e-29,  1.987603082191999e+00, -8.783781688939890e-05, -4.633034842467253e-07, -2.150539802674674e-09, -9.239412383338948e-12, -3.750285623517272e-14,
 -1.450763333077922e-16, -5.361511872447041e-19, -1.888430738208541e-21, -6.289751355990154e-24, -1.947957675666849e-26, -5.406448483506306e-29,  1.997640849148550e+00,
 -1.682537298463761e-05, -8.987367607618426e-08, -4.259394978263959e-10, -1.888148326492304e-12, -8.012963509608007e-15, -3.295346555751470e-17, -1.322558843306189e-19,
 -5.202461066139813e-22, -2.011233214604450e-24, -7.654386509739462e-27, -2.870583830509617e-29,  5.830088094369753e-04, -3.167854110176434e-06,  1.290633497716073e-08,
 -4.672547851160557e-11,  1.585216303793473e-13, -5.160429040068374e-16,  1.632242673432258e-18, -5.054133967112685e-21,  1.539307511801863e-23, -4.626510451844915e-26,
  1.375268100791294e-28, -4.050273094006246e-31,  5.245036483699761e-03, -2.844971180297801e-05,  1.154801606548684e-07, -4.154313776765947e-10,  1.395761420259621e-12,
 -4.481177197666615e-15,  1.390993271626018e-17, -4.202219574292352e-20,  1.240099431797935e-22, -3.582345786488713e-25,  1.013734103729758e-27, -2.809906226669494e-30,
  1.455817245222770e-02, -7.868825827990112e-05,  3.170306806143813e-07, -1.125896760932107e-09,  3.708022697963200e-12, -1.156481349364471e-14,  3.447551181424777e-17,
 -9.856275146037286e-20,  2.699684836970253e-22, -7.048423294775397e-25,  1.733990076745974e-27, -3.927065446151712e-30,  2.850046048667885e-02, -1.532333273287564e-04,
  6.104251603777711e-07, -2.125390846470264e-09,  6.783991013702074e-12, -2.018589521267347e-14,  5.614798021878758e-17, -1.448583575949931e-19,  3.386604477943373e-22,
 -6.758807484646938e-25,  9.307262445066499e-28,  4.623920018362685e-31,  4.703867186971698e-02, -2.511101793838436e-04,  9.851196476000249e-07, -3.337712328657337e-09,
  1.018894146279703e-11, -2.824377758530723e-14,  7.004093836857449e-17, -1.475895060825441e-19,  2.199766097852450e-22,  3.853709530611930e-26, -2.054315054091428e-27,
  1.077984005289379e-29,  7.012795021414948e-02, -3.710203417966044e-04,  1.427348820795712e-06, -4.666632405159740e-09,  1.340185261651272e-11, -3.341675333180931e-14,
  6.752134668323947e-17, -8.088748338009231e-20, -1.383851101414804e-22,  1.421098021695163e-24, -6.338579097060658e-27,  2.117527948642152e-29,  9.771133479324538e-02,
 -5.113431175836168e-04,  1.920385078285910e-06, -6.000427789445447e-09,  1.586220342134971e-11, -3.351647302722272e-14,  4.234170209124464e-17,  6.320023631067451e-20,
 -6.897328147434543e-22,  3.011705391713558e-24, -9.421167236655916e-27,  2.128760991148148e-29,  1.297191599860273e-01, -6.701381102692538e-04,  2.444871635090941e-06,
 -7.217441524036574e-09,  1.702405535855927e-11, -2.686250929375396e-14, -7.412149873268002e-18,  2.674603702448985e-19, -1.275846504381967e-21,  3.981969964272007e-24,
 -8.123105025923458e-27,  2.451800062609923e-30,  1.660683281868641e-01, -8.451492173036795e-04,  2.979235115153688e-06, -8.192577850190321e-09,  1.641432788773877e-11,
 -1.263482630615319e-14, -7.793642966621203e-17,  4.879216624821881e-19, -1.653885595380512e-21,  3.418431279407575e-24, -3.439047261410428e-28, -3.431457164656184e-29,
  2.066614535414390e-01, -1.033810660559779e-03,  3.500183453519437e-06, -8.804595150585612e-09,  1.369145421117471e-11,  8.842325016129523e-15, -1.592407705210685e-16,
  6.595308431674969e-19, -1.563551943319132e-21,  7.516412119689345e-25,  1.306396901516822e-26, -7.339739798403884e-29,  2.513858742435056e-01, -1.233255750752378e-03,
  3.983294700320070e-06, -8.944006196804878e-09,  8.699891853025661e-12,  3.593255376536565e-14, -2.358659330714086e-16,  7.093504554713510e-19, -8.226172630306520e-22,
 -3.812219905105397e-24,  2.731509701501644e-26, -8.760562740546137e-29,  3.001125319739540e-01, -1.440329223494832e-03,  4.403701344232758e-06, -8.521326264176479e-09,
  1.515320038368974e-12,  6.567950740101859e-14, -2.889143257438570e-16,  5.757639550358814e-19,  5.738733587692220e-22, -9.050549876880884e-24,  3.453920036639311e-26,
 -5.096591531667035e-29,  3.526947185283225e-01, -1.651604136898828e-03,  4.736872796824032e-06, -7.475326760554212e-09, -7.525122019395160e-12,  9.399379452643520e-14,
 -2.993147109067572e-16,  2.302306139795368e-19,  2.384668131928806e-21, -1.285747714066708e-23,  2.680222813345732e-26,  4.243090947516375e-29,  4.089666919358215e-01,
 -1.863404480824423e-03,  4.959495399089224e-06, -5.780856118267998e-09, -1.781338188016158e-11,  1.160530184768986e-13, -2.519872431313181e-16, -3.036096638990000e-19,
  4.119172499980771e-21, -1.284334878461635e-23,  6.161770720013979e-28,  1.631668659110972e-28,  4.687421676330119e-01, -2.071834809807617e-03,  5.050444379881522e-06,
 -3.455684601098265e-09, -2.848735978258080e-11,  1.269089758515332e-13, -1.402951307728924e-16, -9.397201844965365e-19,  5.125847303693545e-21, -7.323514163794618e-24,
 -3.889523926524221e-26,  2.471464089882549e-28,  5.318126947674875e-01, -2.272818364921024e-03,  4.991835236022148e-06, -5.657228123698895e-10, -3.847865326870972e-11,
  1.222637466260105e-13,  3.009102611465343e-17, -1.534336717121771e-18,  4.774918388236792e-21,  3.593227031121431e-24, -7.672088626045259e-26,  2.204044717404937e-28,
  5.979459337576283e-01, -2.462145278433296e-03,  4.770132644814673e-06,  2.772132526069529e-09, -4.659385161886455e-11,  9.933749616558740e-14,  2.389660482520924e-16,
 -1.909467349303609e-18,  2.703942312478542e-21,  1.728761640446891e-23, -9.176195250480628e-26,  4.421589980254051e-29,  6.668838591413006e-01, -2.635532536065811e-03,
  4.377282958087282e-06,  6.390338724542671e-09, -5.162903106856835e-11,  5.770900812333991e-14,  4.520593372268994e-16, -1.895025483575272e-18, -9.434630423712953e-22,
  2.880249443544832e-23, -6.604771068708378e-26, -2.399591096958518e-28,  7.383409218438393e-01, -2.788697372984822e-03,  3.811821425113470e-06,  1.007505741245224e-08,
 -5.251280560915783e-11, -2.805035011368602e-17,  6.250144283425272e-16, -1.383402192535891e-18, -5.384355933254734e-21,  3.223533866372726e-23,  3.398154091057563e-27,
 -4.980824050148902e-28,  8.120022176087467e-01, -2.917445659055573e-03,  3.079887722775255e-06,  1.357526022064340e-08, -4.846773574646343e-11, -6.797423376699842e-14,
  7.111230367348657e-16, -3.834771341805918e-19, -9.269286058738300e-21,  2.321787112534647e-23,  9.599020388290552e-26, -5.511469363621049e-28,  8.875217237350049e-01,
 -3.017776532516222e-03,  2.196063817422014e-06,  1.661712545755311e-08, -3.917339592910645e-11, -1.371768012873968e-13,  6.721479701407916e-16,  9.445212939304787e-19,
 -1.102004423395939e-20,  1.697715834980650e-24,  1.694537062135488e-25, -2.807173179423968e-28,  9.645206846045625e-01, -3.086004004134902e-03,  1.183928086883564e-06,
  1.892387781206175e-08, -2.490768872992046e-11, -1.965585272168350e-13,  4.904084921926487e-16,  2.293374966577005e-18, -9.399238160801713e-21, -2.634318059948599e-23,
  1.763148615799223e-25,  2.567679812091793e-28,  1.042586247698815e+00, -3.118895402585834e-03,  7.620148136900844e-08,  2.024062845142910e-08, -6.637372924308506e-12,
 -2.345562836099368e-13,  1.791293389347948e-16,  3.266809511538731e-18, -4.151923031410481e-21, -4.970416175366125e-23,  9.140979161197798e-26,  7.929046429639697e-28,
  1.121270475485995e+00, -3.113825290552946e-03, -1.085650897688772e-06,  2.036295001302585e-08,  1.397382992434290e-11, -2.413449557703579e-13, -2.127190582760225e-16,
  3.490560648315509e-18,  3.555755336296395e-21, -5.603586244742181e-23, -6.313880433603186e-26,  9.595133109679920e-28,  1.200089883797784e+00, -3.068941783952661e-03,
 -2.252500790955351e-06,  1.916689327478234e-08,  3.466833159004040e-11, -2.113190255250506e-13, -6.047010356555695e-16,  2.753523336705810e-18,  1.120707782777633e-20,
 -3.821884682644988e-23, -2.146809849329821e-25,  5.339412485657749e-28,  1.278525682492638e+00, -2.983340016358620e-03, -3.369442017290378e-06,  1.663700889904197e-08,
  5.282690719922745e-11, -1.452941435334275e-13, -9.003270384225252e-16,  1.131821338984706e-18,  1.569469339644552e-20, -1.022407011641721e-25, -2.713710298143421e-25,
 -3.286628251520671e-28,  1.356024916824066e+00, -2.857234825903853e-03, -4.378560148646061e-06,  1.288785892767578e-08,  6.582732904292743e-11, -5.174258606791664e-14,
 -1.012365191519208e-15, -9.652894387337407e-19,  1.464569356126288e-20,  4.240805810239281e-23, -1.798695450436882e-25, -1.091374974968693e-27,  1.432002724441312e+00,
 -2.692121712437621e-03, -5.222593198783979e-06,  8.173775360319781e-09,  7.149637246876100e-11,  5.361886397985947e-14, -8.924114185256397e-16, -2.878454134936081e-18,
  7.792693230885893e-21,  6.759144651490691e-23,  2.507240017633869e-26, -1.167956103924423e-27,  1.505845928682083e+00, -2.490911958776644e-03, -5.849379814718226e-06,
  2.881628868830517e-09,  6.858588278418228e-11,  1.503228157818949e-13, -5.549033230427382e-16, -3.917516135621959e-18, -2.394363459013709e-21,  6.000296024034115e-23,
  2.234390645074339e-25, -4.158999187415426e-28,  1.576918178124459e+00, -2.258024937322892e-03, -6.216846390762875e-06, -2.497471932611884e-09,  5.716968782838423e-11,
  2.176301313747300e-13, -8.407947417911749e-17, -3.654550777424589e-18, -1.146496329301531e-20,  2.175719562017070e-23,  2.825770066853814e-25,  6.357083659448594e-28,
  1.644566809051775e+00, -1.999418619789020e-03, -6.298115438771357e-06, -7.418987571007385e-09,  3.883959196308632e-11,  2.401484886586030e-13,  3.844730577087150e-16,
 -2.161385120674372e-18, -1.511140247025515e-20, -2.579203476197986e-23,  1.591825577650775e-25,  1.147926554595076e-27,  1.708131545649000e+00, -1.722538919792505e-03,
 -6.086148143096480e-06, -1.135550646029225e-08,  1.659062303360231e-11,  2.129976349998697e-13,  7.071316961293424e-16, -4.547538530807133e-20, -1.166555571951931e-20,
 -5.417073664246460e-23, -5.381099565585255e-26,  7.192256938523783e-28,  1.766955058100434e+00, -1.436170545849155e-03, -5.597201850449648e-06, -1.387897884481196e-08,
 -5.660230917284624e-12,  1.445357972127548e-13,  7.873006160220900e-16,  1.790564139340502e-18, -3.353922775034162e-21, -4.744367788618816e-23, -1.937227029953504e-25,
 -1.951630525761109e-28,  1.820395270354413e+00, -1.150177255561745e-03, -4.872336475107295e-06, -1.474115243835955e-08, -2.388131087124464e-11,  5.499812294072597e-14,
  6.186881104723185e-16,  2.588808970602121e-18,  4.865565536734041e-21, -1.451160219658763e-23, -1.663737292300673e-25, -7.218339579571433e-28,  1.867839151540396e+00,
 -8.751281791201509e-04, -3.976291814312260e-06, -1.393492192639450e-08, -3.489975905948311e-11, -2.936228413386172e-14,  2.925659061412081e-16,  2.144286219996397e-18,
  8.473804880413201e-21,  1.789997438812195e-23, -2.802151710236527e-26, -4.788037305151731e-28,  1.908717549504154e+00, -6.218190073403676e-04, -2.993315181688102e-06,
 -1.171898993461474e-08, -3.727868881231934e-11, -8.515568525322357e-14, -4.151081161860784e-17,  9.143916682358353e-19,  6.419380620260644e-21,  2.756958005844390e-23,
  7.940291742492125e-26,  7.871088754088230e-29,  1.942520452902116e+00, -4.007112390831775e-04, -2.019945819024388e-06, -8.592912989474353e-09, -3.180055645129591e-11,
 -1.005228417088401e-13, -2.474548740117344e-16, -2.821567811981494e-19,  1.574124392667198e-21,  1.467833900990394e-23,  7.638553843979990e-26,  2.997436198895893e-28,
  1.968811940447288e+00, -2.213272538860143e-04, -1.155308345487467e-06, -5.219469889181377e-09, -2.133178150696777e-11, -7.974077281954574e-14, -2.704774654873040e-16,
 -8.059188374183408e-19, -1.912355768751739e-21, -2.145121079261651e-24,  1.205728833253619e-26,  1.161017004310726e-28,  1.987244151002999e+00, -9.165004205334664e-05,
 -4.900223244032329e-07, -2.304565267090556e-09, -1.002554001771634e-11, -4.117187831495587e-14, -1.609697232709745e-16, -6.003590067711218e-19, -2.129476194680606e-21,
 -7.118251850862228e-24, -2.198902037929505e-26, -6.004479130651272e-29,  1.997572076564926e+00, -1.756533353076529e-05, -9.517164356442655e-08, -4.574762103300698e-10,
 -2.056626398917018e-12, -8.850234947252238e-15, -3.690102142951613e-17, -1.501238852796862e-19, -5.984802604401776e-22, -2.344244302480915e-24, -9.037011092761735e-27,
 -3.431703893597520e-29,  5.705404030748263e-04, -3.066803906235975e-06,  1.236051348871456e-08, -4.426961797901741e-11,  1.485813290357017e-13, -4.785131093467459e-16,
  1.497380005645467e-18, -4.587176440046452e-21,  1.382240335886612e-23, -4.110435942071541e-26,  1.208943405407047e-28, -3.522983237165587e-31,  5.133054273411794e-03,
 -2.754543827225951e-05,  1.106260773237115e-07, -3.937984368854256e-10,  1.309383221749159e-12, -4.161021492678962e-15,  1.278698335072744e-17, -3.825263019148026e-20,
  1.118145437337830e-22, -3.200539371902544e-25,  8.977860170940913e-28, -2.468190698407918e-30,  1.424840774291125e-02, -7.620506458836510e-05,  3.038683999876756e-07,
 -1.068374732906227e-09,  3.484781958000107e-12, -1.076956506408539e-14,  3.183297956047121e-17, -9.031669427155402e-20,  2.458019716984415e-22, -6.388311312066044e-25,
  1.569177832227221e-27, -3.568984944911080e-30,  2.789713501541652e-02, -1.484501297744422e-04,  5.855586441200295e-07, -2.020004873823920e-09,  6.393426320366203e-12,
 -1.888581372417357e-14,  5.224005963686902e-17, -1.344033138552449e-19,  3.150025175087237e-22, -6.383802956274105e-25,  9.411588412234390e-28,  3.119932286160945e-32,
  4.604974325709826e-02, -2.433867033468137e-04,  9.460268891916596e-07, -3.179118327012872e-09,  9.640545117669368e-12, -2.661158896584411e-14,  6.600708242091676e-17,
 -1.405430222737565e-19,  2.199940746824851e-22, -3.470212607354928e-26, -1.620788209696689e-27,  8.974719222341077e-30,  6.866635684409313e-02, -3.598219545070564e-04,
  1.372614037813520e-06, -4.457462174455611e-09,  1.274953682849510e-11, -3.182387404021802e-14,  6.520185305227612e-17, -8.454441243274163e-20, -9.157188089525671e-23,
  1.185416861495947e-24, -5.464118474027473e-27,  1.861592584688837e-29,  9.569623847602590e-02, -4.962637935554032e-04,  1.849880775858861e-06, -5.751939398755875e-09,
  1.520216683351151e-11, -3.248143334543015e-14,  4.381809973225534e-17,  4.279260990802074e-20, -5.878718836713657e-22,  2.653264277529793e-24, -8.509341897050173e-27,
  2.012839630688145e-29,  1.270771834488966e-01, -6.509209847201224e-04,  2.359878892312898e-06, -6.949361840334452e-09,  1.648560956774839e-11, -2.695501744677788e-14,
 -4.737339114459075e-19,  2.288644542657072e-19, -1.138309657701480e-21,  3.660130655943524e-24, -7.947584689321512e-27,  5.375879311410007e-30,  1.627347827205528e-01,
 -8.217041352646579e-04,  2.882491300675768e-06, -7.932067266425964e-09,  1.614400279897121e-11, -1.434722584443922e-14, -6.499709861156968e-17,  4.369608807449124e-19,
 -1.531410986887033e-21,  3.376937104359834e-24, -1.672414324733533e-27, -2.629545595687924e-29,  2.025815499588013e-01, -1.006228077301300e-03,  3.395847871529798e-06,
 -8.584318583799420e-09,  1.383154964160251e-11,  5.236523538478643e-15, -1.414696269333665e-16,  6.100248488508063e-19, -1.527836941483250e-21,  1.212692975711242e-24,
  1.006352734302374e-26, -6.311449332194639e-29,  2.465159076215210e-01, -1.201816286424151e-03,  3.876824553083484e-06, -8.799359589782043e-09,  9.363528026900309e-12,
  3.050701908516951e-14, -2.163918243815194e-16,  6.810342894681714e-19, -9.411051517395055e-22, -2.795140884193564e-24,  2.357969074957953e-26, -8.200666135191942e-29,
  2.944210273911411e-01, -1.405508126822079e-03,  4.301633042945514e-06, -8.486943651815244e-09,  2.760886062227659e-12,  5.894080376238748e-14, -2.725829464042335e-16,
  5.891768964256133e-19,  2.723594838633347e-22, -7.716182751520708e-24,  3.212726391494409e-26, -5.810103798695384e-29,  3.461635211161789e-01, -1.614069876695665e-03,
  4.646507241932979e-06, -7.581077670594907e-09, -5.716516719474171e-12,  8.689580169980866e-14, -2.918680128520345e-16,  2.993442188044104e-19,  1.941480916142046e-21,
 -1.175518825462684e-23,  2.814352533597280e-26,  1.926593763078929e-29,  4.015919799833704e-01, -1.824010669712786e-03,  4.888490564343262e-06, -6.047632964613349e-09,
 -1.555341186780439e-11,  1.099177800084010e-13, -2.587123202305586e-16, -1.791756893464112e-19,  3.658898319285849e-21, -1.268469531532812e-23,  7.083146255694975e-27,
  1.311399393104191e-28,  4.605353621854594e-01, -2.031604684521288e-03,  5.006324521798378e-06, -3.891368482223961e-09, -2.598488766165824e-11,  1.232444279698972e-13,
 -1.643525706300590e-16, -7.801907890592269e-19,  4.836759849405012e-21, -8.668161642716761e-24, -2.850039324572991e-26,  2.247582711589164e-28,  5.228012331460938e-01,
 -2.232921117896957e-03,  4.981433393576733e-06, -1.161794121432919e-09, -3.602954670031022e-11,  1.224877590441548e-13, -1.071590371687656e-17, -1.380042722943365e-18,
  4.851405818652591e-21,  7.218426648699687e-25, -6.677982711849904e-26,  2.298359453982113e-28,  5.881738677577586e-01, -2.423863675513162e-03,  4.798991748282121e-06,
  2.042818516176352e-09, -4.455402763627812e-11,  1.044414275903725e-13,  1.868008655096996e-16, -1.813687144737173e-18,  3.260844950938221e-21,  1.367216108331818e-23,
 -8.863272003737196e-26,  9.612572203199653e-29,  6.564122314849256e-01, -2.600221487781020e-03,  4.449050583828465e-06,  5.574079064187528e-09, -5.037066821671899e-11,
  6.791923146310393e-14,  3.987280833905039e-16, -1.909155196257069e-18,  4.354177504563796e-23,  2.597285981809970e-23, -7.486117408981415e-26, -1.613530803900219e-28,
  7.272478670406803e-01, -2.757733477125516e-03,  3.927683469473814e-06,  9.235649546923895e-09, -5.236659678211260e-11,  1.448907513372105e-14,  5.840413768531607e-16,
 -1.537149648094167e-18, -4.226563766808043e-21,  3.195013033803031e-23, -1.721387123330172e-26, -4.370943536857067e-28,  8.003827261555988e-01, -2.892168225323643e-03,
  3.238096072176177e-06,  1.278982363215376e-08, -4.965759047351515e-11, -5.106884930783212e-14,  6.963636989893341e-16, -6.660274840439784e-19, -8.370217776915392e-21,
  2.656801371994133e-23,  7.144948503998191e-26, -5.604433498733892e-28,  8.754870022172914e-01, -2.999421257891143e-03,  2.391621002213190e-06,  1.596928759153464e-08,
 -4.175367980236703e-11, -1.207676367199260e-13,  6.936759518631172e-16,  5.941398547423567e-19, -1.084018845638162e-20,  8.197081138393587e-24,  1.547686375731624e-25,
 -3.830838157424279e-28,  9.521970396990338e-01, -3.075631302704537e-03,  1.408495883527495e-06,  1.849456613141458e-08, -2.871613905432019e-11, -1.840529641792562e-13,
  5.502793821717347e-16,  1.978806184006079e-18, -1.021833983766960e-20, -1.911038868889790e-23,  1.841933121561741e-25,  1.015483296755631e-28,  1.030113420583232e+00,
 -3.117316400789383e-03,  3.182978687609086e-07,  2.009716587292649e-08, -1.127818294113347e-11, -2.291761713051459e-13,  2.684763626638919e-16,  3.106090541867612e-18,
 -5.867320074102805e-21, -4.538011992708188e-23,  1.239937382600009e-25,  6.833683095648946e-28,  1.108799356373849e+00, -3.121529643732747e-03, -8.401141047549234e-07,
  2.054767215067462e-08,  9.103853309825676e-12, -2.452664065225691e-13, -1.136966404039775e-16,  3.571664165133893e-18,  1.503305437266448e-21, -5.770377773273709e-23,
 -2.000743034810062e-26,  9.937457215728963e-28,  1.187779546216072e+00, -3.086032675811823e-03, -2.019311863296261e-06,  1.968701393176477e-08,  3.030327165301716e-11,
 -2.248674711092636e-13, -5.227999844959320e-16,  3.088527868808048e-18,  9.682818808519819e-21, -4.627855024428214e-23, -1.869172525674003e-25,  7.241909292934551e-28,
  1.266539695752428e+00, -3.009482835568060e-03, -3.164826192629629e-06,  1.745783011999529e-08,  4.970780582330390e-11, -1.664650274041004e-13, -8.616204524693546e-16,
  1.631873291098111e-18,  1.549273963796164e-20, -1.118013620671677e-23, -2.808415818378420e-25, -9.788028185163184e-29,  1.344526925198498e+00, -2.891626872098175e-03,
 -4.217624867040271e-06,  1.393148903517694e-08,  6.454759989579968e-11, -7.630937037427081e-14, -1.032612950491750e-15, -4.736814349575721e-19,  1.603150560180402e-20,
  3.427575550426562e-23, -2.260751009999669e-25, -9.993075507563372e-28,  1.421151324859681e+00, -2.733490595991010e-03, -5.117612697389758e-06,  9.325105766486900e-09,
  7.234819786176037e-11,  3.126426046736362e-14, -9.691504184083119e-16, -2.590064943841236e-18,  1.023124409959745e-20,  6.752225435514351e-23, -2.955541867088827e-26,
 -1.308253960038872e-27,  1.495788936405812e+00, -2.537549800144729e-03, -5.808119256618613e-06,  4.002293625607110e-09,  7.145024132110248e-11,  1.356822492259450e-13,
 -6.653296458618704e-16, -3.957889589290731e-18, -7.850505464608742e-23,  6.849584441276895e-23,  1.992262745335397e-25, -6.873968608779745e-28,  1.567786441413228e+00,
 -2.307863707036916e-03, -6.241184580023571e-06, -1.548081273115455e-09,  6.149361196310700e-11,  2.143436406568530e-13, -1.914095926668003e-16, -4.006663925491742e-18,
 -1.047191935692733e-20,  3.357366170671357e-23,  3.070009457837708e-25,  4.646818953710799e-28,  1.636467816282178e+00, -2.050148722156812e-03, -6.383254625389866e-06,
 -6.758650558555598e-09,  4.372964737404118e-11,  2.485941622764052e-13,  3.170541208293041e-16, -2.658476979193826e-18, -1.591289929058758e-20, -1.838957454214415e-23,
  2.114886438434316e-25,  1.222969541666464e-27,  1.701143155386236e+00, -1.771768326855993e-03, -6.220677958505836e-06, -1.105505598547288e-08,  2.101995850112139e-11,
  2.299095181442962e-13,  7.003364601013664e-16, -4.503251627760720e-19, -1.364622894745147e-20, -5.562513249090102e-23, -1.726396189462376e-26,  9.449359240271969e-28,
  1.761119764009663e+00, -1.481615664772019e-03, -5.764194213565758e-06, -1.394537336469235e-08, -2.576571396736956e-12,  1.640188817525352e-13,  8.356663404188829e-16,
  1.654400943700578e-18, -5.203102458972815e-21, -5.532606925774577e-23, -1.993684952373051e-25, -5.386816202437301e-29,  1.815715474567525e+00, -1.189869929433909e-03,
 -5.051483930023868e-06, -1.511362198798237e-08, -2.262690314013450e-11,  7.073354109882799e-14,  6.932664759708318e-16,  2.734800799368114e-18,  4.215545054261270e-21,
 -2.181904115353051e-23, -1.993955683150867e-25, -7.762481837849236e-28,  1.864273945643719e+00, -9.076169246700208e-04, -4.146879340487134e-06, -1.449761355844827e-08,
 -3.541176482995810e-11, -2.158899430862876e-14,  3.564972676927860e-16,  2.425498606388892e-18,  9.092611681415674e-21,  1.632019406586668e-23, -5.193296499293988e-26,
 -6.113647358524365e-28,  1.906181475302594e+00, -6.463383098574566e-04, -3.137578168306846e-06, -1.232911886076176e-08, -3.898956733455406e-11, -8.582055750631633e-14,
 -1.287834978289844e-17,  1.136310965472291e-18,  7.469778388340955e-21,  3.080241764628341e-23,  8.189507379201926e-26,  3.141711891032567e-29,  1.940884623335774e+00,
 -4.172920701142767e-04, -2.126181025721188e-06, -9.118130805785420e-09, -3.387101081876208e-11, -1.065503613339027e-13, -2.545662596198079e-16, -2.227138315312567e-19,
  2.160835372320702e-21,  1.801017549570503e-23,  9.052441572086885e-26,  3.434072647403081e-28,  1.967907741464366e+00, -2.308261809852237e-04, -1.220043627854163e-06,
 -5.573897417195653e-09, -2.299337540695283e-11, -8.651000356862724e-14, -2.939108134207566e-16, -8.682461674117672e-19, -1.979580401907266e-21, -1.550959037906238e-24,
  1.790494253248476e-26,  1.510200483462206e-28,  1.986869531396565e+00, -9.568363070221695e-05, -5.186674287825909e-07, -2.471777169469492e-09, -1.088901275478433e-11,
 -4.524481546627708e-14, -1.787735455117551e-16, -6.727773889698385e-19, -2.402218507046383e-21, -8.052458921971184e-24, -2.476623897648920e-26, -6.620679969855311e-29,
  1.997500256908431e+00, -1.834923871199677e-05, -1.008647952486424e-07, -4.918478583740960e-10, -2.242839348605809e-12, -9.788545740055339e-15, -4.138581147729655e-17,
 -1.706983698551660e-19, -6.897607950182943e-22, -2.737829978753023e-24, -1.069174900371007e-26, -4.111438003281954e-29,  5.584676472867454e-04, -2.970005040735092e-06,
  1.184323226964025e-08, -4.196696901629243e-11,  1.393602869640524e-13, -4.440686333473455e-16,  1.374915527785307e-18, -4.167631820280599e-21,  1.242608165780332e-23,
 -3.656474888267614e-26,  1.064168504629180e-28, -3.068811874808245e-31,  5.024613103477495e-03, -2.667898204460425e-05,  1.060235036305977e-07, -3.734977515747620e-10,
  1.229146956232946e-12, -3.866592858251701e-15,  1.176431869989740e-17, -3.485219188836691e-20,  1.009136662768566e-22, -2.862238212946501e-25,  7.958898229613277e-28,
 -2.170151660044409e-30,  1.394836949938655e-02, -7.382446761920523e-05,  2.913754664989235e-07, -1.014300685875118e-09,  3.276830238475862e-12, -1.003505196844759e-14,
  2.941085866803771e-17, -8.280718503780341e-20,  2.238969208065775e-22, -5.791054660986522e-25,  1.419512457993610e-27, -3.238487238632521e-30,  2.731255233203266e-02,
 -1.438609101135956e-04,  5.619201071384961e-07, -1.920664921152306e-09,  6.027948631081520e-12, -1.767609373260627e-14,  4.861448484846962e-17, -1.246836781987320e-19,
  2.926978441963438e-22, -6.008092067872256e-25,  9.350267825144567e-28, -2.943718859798344e-31,  4.509109491028131e-02, -2.359685035816928e-04,  9.087856731426070e-07,
 -3.029042709805886e-09,  9.123840391340702e-12, -2.507384752773695e-14,  6.217016246007157e-17, -1.335349688273480e-19,  2.176686948690061e-22, -9.210487265110371e-26,
 -1.260490148746301e-27,  7.444443078236647e-30,  6.724869691628270e-02, -3.490515803388216e-04,  1.320327716698911e-06, -4.258477192159361e-09,  1.212851449636228e-11,
 -3.028772965100423e-14,  6.279970910507264e-17, -8.683253536914598e-20, -5.264000821672930e-23,  9.825378444320080e-25, -4.696612512773699e-27,  1.631180129517733e-29,
  9.374035001983291e-02, -4.817367544489745e-04,  1.782295659454930e-06, -5.513844249704286e-09,  1.456314094413574e-11, -3.141746042763882e-14,  4.476682724189059e-17,
  2.544500773524401e-20, -4.982710613240284e-22,  2.330227758996593e-24, -7.651986321473125e-27,  1.882483627514087e-29,  1.245107356972573e-01, -6.323710798292713e-04,
  2.278051382213135e-06, -6.689903401517476e-09,  1.594689382322513e-11, -2.689348516252483e-14,  5.443882157492757e-18,  1.944859290809698e-19, -1.012203992763353e-21,
  3.347629932562641e-24, -7.662184382025415e-27,  7.474566502012842e-30,  1.594934893730690e-01, -7.990205752574647e-04,  2.788846585160081e-06, -7.676139472320399e-09,
  1.584242186150476e-11, -1.576576312217986e-14, -5.343009462659759e-17,  3.898857964852103e-19, -1.411305210786569e-21,  3.288971494682731e-24, -2.676820371305092e-27,
 -1.955921067717440e-29,  1.986103241276621e-01, -9.794695726501660e-04,  3.294166751457505e-06, -8.362354713576710e-09,  1.390368256691920e-11,  2.040739168224121e-15,
 -1.250663157408163e-16,  5.619050079635511e-19, -1.477577496295850e-21,  1.562539332266828e-24,  7.497665306179106e-27, -5.365900078508354e-29,  2.417700065718053e-01,
 -1.171221467810836e-03,  3.772150374855419e-06, -8.644937772143311e-09,  9.923260997741834e-12,  2.553895314292568e-14, -1.977583492003463e-16,  6.494840107361656e-19,
 -1.025605669037082e-21, -1.922266774518120e-24,  2.011106559889819e-26, -7.555292640512507e-29,  2.888671771802450e-01, -1.371501597504187e-03,  4.200092529087146e-06,
 -8.433688770898085e-09,  3.875622516098647e-12,  5.259751340860042e-14, -2.560039973475193e-16,  5.936908136037394e-19,  1.707942381887340e-23, -6.483608650046218e-24,
  2.947224987578899e-26, -6.211859320034992e-29,  3.397810075392640e-01, -1.577263135757381e-03,  4.555041650739226e-06, -7.659016234592504e-09, -4.047935444391449e-12,
  7.999818622155120e-14, -2.826786534905360e-16,  3.549191892994447e-19,  1.538707888919426e-21, -1.061835203554986e-23,  2.856077469443675e-26,  3.802367160192216e-31,
  3.943736877784383e-01, -1.785197097232675e-03,  4.814497290063102e-06, -6.279239543664068e-09, -1.341748699999285e-11,  1.036612921483968e-13, -2.621582500706244e-16,
 -6.933189566046639e-20,  3.208658390514930e-21, -1.229486503219431e-23,  1.219303853347188e-26,  1.015829316105451e-28,  4.524887391627059e-01, -1.991747756019966e-03,
  4.957214178348318e-06, -4.287629008609598e-09, -2.356112405324466e-11,  1.190550161602330e-13, -1.840794151412474e-16, -6.306084454803395e-19,  4.506503319107272e-21,
 -9.617644065715369e-24, -1.915703721219826e-26,  1.996131550019430e-28,  5.139491497223773e-01, -2.193135030876209e-03,  4.964113789155710e-06, -1.718695622992496e-09,
 -3.358540257379627e-11,  1.217844317539829e-13, -4.718332424929099e-17, -1.224877660325127e-18,  4.831755470916152e-21, -1.746378476880607e-24, -5.662851082931808e-26,
  2.302362168250718e-28,  5.785553352803298e-01, -2.385385644684940e-03,  4.819298057557493e-06,  1.346891242160782e-09, -4.242441753900592e-11,  1.083274712440831e-13,
  1.375476511462192e-16, -1.702140135323715e-18,  3.690363884534897e-21,  1.022417243348421e-23, -8.347218109364138e-26,  1.365713255479754e-28,  6.460829347710705e-01,
 -2.564375121611995e-03,  4.511150409739707e-06,  4.779517229709066e-09, -4.892091440778129e-11,  7.684822974520921e-14,  3.454276154616119e-16, -1.893391982161849e-18,
  9.231547358337118e-22,  2.285841118304078e-23, -8.032887408759003e-26, -8.829073794958397e-29,  7.162804579034614e-01, -2.725882915008127e-03,  4.033496059909528e-06,
  8.400848945315795e-09, -5.194020610070724e-11,  2.797535977015489e-14,  5.392794407194378e-16, -1.654165738340658e-18, -3.093207242166832e-21,  3.089688328759876e-23,
 -3.494284363709275e-26, -3.677361505692635e-28,  7.888668156545890e-01, -2.865663123835208e-03,  3.386776044465810e-06,  1.198803235333935e-08, -5.051350332666524e-11,
 -3.460927018773705e-14,  6.741125116664426e-16, -9.180678127597952e-19, -7.368250341983521e-21,  2.893510945761820e-23,  4.700036468810322e-26, -5.474422051913023e-28,
  8.635287805196216e-01, -2.979533298734704e-03,  2.579167337263124e-06,  1.528281540115961e-08, -4.400140407064236e-11, -1.039586664652277e-13,  7.055081459268219e-16,
  2.531356596400645e-19, -1.043795266164536e-20,  1.402576280961332e-23,  1.360921295848084e-25, -4.617770667027602e-28,  9.399184446195219e-01, -3.063483682259571e-03,
  1.627554827034683e-06,  1.800639516242117e-08, -3.226083682593653e-11, -1.702189143287079e-13,  6.010148890230497e-16,  1.642239744110702e-18, -1.077302693392302e-20,
 -1.169811743672102e-23,  1.853254462470782e-25, -4.865697323119579e-29,  1.017650770343532e+00, -3.113808767471214e-03,  5.582311112800398e-07,  1.988042602092937e-08,
 -1.579034335179179e-11, -2.217117822946202e-13,  3.525798954654402e-16,  2.893211143000248e-18, -7.404827079328075e-21, -3.985718097144548e-23,  1.511679426392098e-25,
  5.482174756645172e-28,  1.096301360599684e+00, -3.127262165658506e-03, -5.928303320241656e-07,  2.065397699359179e-08,  4.179358455258554e-12, -2.467915336413783e-13,
 -1.332946118331857e-17,  3.586463707725866e-18, -5.778903514921730e-22, -5.762934265284310e-23,  2.365515610143548e-26,  9.835977407161404e-28,  1.175404613916494e+00,
 -3.101234297638832e-03, -1.780309121063291e-06,  2.013523576415799e-08,  2.568762925302955e-11, -2.363435017010984e-13, -4.322436728090447e-16,  3.370343987885800e-18,
  7.890349191588173e-21, -5.306796517455169e-23, -1.513754831201099e-25,  8.857799104936971e-28,  1.254452472731268e+00, -3.033950208985441e-03, -2.950673743370883e-06,
  1.822541359351799e-08,  4.617570512268560e-11, -1.865400366308059e-13, -8.090632450197559e-16,  2.119028988990917e-18,  1.488766756184085e-20, -2.242761863032677e-23,
 -2.797199119416474e-25,  1.507838226698404e-28,  1.332894019127712e+00, -2.924681727370280e-03, -4.044305164749842e-06,  1.495069115443304e-08,  6.277281527171730e-11,
 -1.011921925613178e-13, -1.038521345825953e-15,  5.724058600755577e-20,  1.709241836936316e-20,  2.439330060385707e-23, -2.669568955576730e-25, -8.496003724364907e-28,
  1.410136217214470e+00, -2.773964174592098e-03, -4.998749526184548e-06,  1.048639147865185e-08,  7.273521339726112e-11,  7.173619861687753e-15, -1.036725497484253e-15,
 -2.224115005833636e-18,  1.262660332851765e-20,  6.515774613500902e-23, -8.934174145539583e-26, -1.400290730373034e-27,  1.485546139172915e+00, -2.583803009224647e-03,
 -5.753145872912608e-06,  5.166301402253463e-09,  7.399523909380095e-11,  1.183865348269567e-13, -7.758044265830563e-16, -3.919474210230116e-18,  2.522748329682746e-21,
  7.577746531013491e-23,  1.628061561890826e-25, -9.684184697536703e-28,  1.558455034018438e+00, -2.357850441327134e-03, -6.253717616092207e-06, -5.301769068695517e-10,
  6.572526871170587e-11,  2.083669073446863e-13, -3.080887910224550e-16, -4.320020600233539e-18, -9.037870924666966e-21,  4.619899721049740e-23,  3.225835248572322e-25,
  2.337240300792408e-28,  1.628164592955694e+00, -2.101526899503327e-03, -6.459995046221208e-06, -6.018814047203681e-09,  4.877129442774836e-11,  2.552521211506275e-13,
  2.354005161028378e-16, -3.176543411880229e-18, -1.640956737054626e-20, -8.841771018467388e-24,  2.661038428791999e-25,  1.250515215108569e-27,  1.693955719587068e+00,
 -1.822058320411885e-03, -6.351166029714964e-06, -1.068104308639912e-08,  2.578494539377148e-11,  2.465150861790618e-13,  6.813123429915623e-16, -9.190923605204075e-19,
 -1.565051030735144e-20, -5.541444774543528e-23,  2.953942960362288e-26,  1.183821585984634e-27,  1.755100013743085e+00, -1.528399040764270e-03, -5.931674220312672e-06,
 -1.395925038975758e-08,  9.080130955563318e-13,  1.846100427685672e-13,  8.793481670925063e-16,  1.454493145504000e-18, -7.338488172229460e-21, -6.329595045055453e-23,
 -1.977402949235782e-25,  1.364071083081016e-28,  1.810874013932215e+00, -1.231013295728504e-03, -5.234969892309964e-06, -1.546340475246236e-08, -2.103957034129593e-11,
  8.830529051056023e-14,  7.716000126458031e-16,  2.855523616046170e-18,  3.278156538877728e-21, -3.048933582326335e-23, -2.343528978116302e-25, -8.081634361054900e-28,
  1.860576012419525e+00, -9.414975065227186e-04, -4.324262910973059e-06, -1.506716747330320e-08, -3.575231217116243e-11, -1.218468627746148e-14,  4.285698678519163e-16,
  2.725406501401872e-18,  9.635871178822625e-21,  1.366145315417729e-23, -8.211362210435974e-26, -7.636843090325072e-28,  1.903544968655390e+00, -6.720414685721692e-04,
 -3.289327258309575e-06, -1.296668870370531e-08, -4.070634810971432e-11, -8.571977943541584e-14,  2.245603856348570e-17,  1.393719922476681e-18,  8.637797116695689e-21,
  3.408731413058858e-23,  8.184771903812480e-26, -3.760396303313256e-29,  1.939180729958240e+00, -4.347485656368291e-04, -2.238921616393153e-06, -9.677448962838417e-09,
 -3.606357604538733e-11, -1.127263450089833e-13, -2.597315640158953e-16, -1.424640354582438e-19,  2.878142555862946e-21,  2.194675280219493e-23,  1.066392052757861e-25,
  3.893425695211207e-28,  1.966964483420166e+00, -2.408604653089729e-04, -1.289196121877386e-06, -5.956024679075228e-09, -2.479612045010680e-11, -9.386279827996601e-14,
 -3.191158876481423e-16, -9.323341529411634e-19, -2.020812215782942e-21, -6.896774279593127e-25,  2.547798949280541e-26,  1.948299913008903e-28,  1.986478306065832e+00,
 -9.995464756721551e-05, -5.494047346424641e-07, -2.653480229342053e-09, -1.183838662881864e-11, -4.977039501914433e-14, -1.987324828726798e-16, -7.544835996611320e-19,
 -2.710657308955767e-21, -9.103184112206206e-24, -2.781461127538955e-26, -7.232360248602126e-29,  1.997425207855103e+00, -1.918039106095509e-05, -1.069889219312871e-07,
 -5.293550934859223e-10, -2.448943289812040e-12, -1.084174815511437e-14, -4.648980544061872e-17, -1.944339204172424e-19, -7.964775710992849e-22, -3.203993627086399e-24,
 -1.267650158760005e-26, -4.936701445140768e-29,  5.467739819893474e-04, -2.877236354622485e-06,  1.135271984484264e-08, -3.980650139911201e-11,  1.307996689969884e-13,
 -4.124272398192790e-16,  1.263596540756989e-18, -3.790262652327792e-21,  1.118322624487219e-23, -3.256617870196619e-26,  9.379691129337741e-29, -2.677016629693950e-31,
  4.919565629895398e-03, -2.584839335883780e-05,  1.016570255696615e-07, -3.544350398084084e-10,  1.154561337042458e-12, -3.595603947924422e-15,  1.083216035379807e-17,
 -3.178185720351575e-20,  9.116036238587841e-23, -2.562188151067991e-25,  7.062548899895140e-28, -1.909970882559423e-30,  1.365765778802332e-02, -7.154127403027666e-05,
  2.795119329490364e-07, -9.634394326162224e-10,  3.083004102337976e-12, -9.356223841688548e-15,  2.718950573146109e-17, -7.596536290027719e-20,  2.040376667378381e-22,
 -5.250835437266405e-25,  1.283795276879837e-27, -2.934814393480568e-30,  2.674595572257958e-02, -1.394561280322924e-04,  5.394393470809863e-07, -1.826983692964258e-09,
  5.685816836277973e-12, -1.655020114467047e-14,  4.525127020764672e-17, -1.156562248998660e-19,  2.717381044945692e-22, -5.637436180595555e-25,  9.164995511094415e-28,
 -5.353444008829956e-31,  4.416153471344145e-02, -2.288411681538328e-04,  8.732967597303878e-07, -2.886993266391803e-09,  8.636985476041255e-12, -2.362584768448523e-14,
  5.852813465144594e-17, -1.266317373485423e-19,  2.135206652890309e-22, -1.363702067560671e-25, -9.621985008615312e-28,  6.150274643597612e-30,  6.587329679144613e-02,
 -3.386901120639374e-04,  1.270370600883008e-06, -4.069185935805232e-09,  1.153763404768075e-11, -2.880987128973790e-14,  6.034988232973012e-17, -8.798596550430366e-20,
 -2.048294893755501e-23,  8.084036995869767e-25, -4.025113218519922e-27,  1.424950768351552e-29,  9.184150621018991e-02, -4.677391398971850e-04,  1.717507044146279e-06,
 -5.285802201530605e-09,  1.394558449307077e-11, -3.033623335903191e-14,  4.526826131620392e-17,  1.078506777069851e-20, -4.196963289437799e-22,  2.040311947107855e-24,
 -6.853847935297141e-27,  1.744667268028090e-29,  1.220171978371788e-01, -6.144634874027664e-04,  2.199285721400225e-06, -6.439047172087985e-09,  1.541075329460028e-11,
 -2.670103559100824e-14,  1.045372029762897e-17,  1.639651560733807e-19, -8.971225147503328e-22,  3.048185124323661e-24, -7.299643012787724e-27,  8.906411333698260e-30,
  1.563414512821490e-01, -7.770739725306694e-04,  2.698243162822290e-06, -7.425249296186823e-09,  1.551514172430415e-11, -1.692207841945095e-14, -4.312791371076798e-17,
  3.465962336922840e-19, -1.295021107073237e-21,  3.166411482643546e-24, -3.410442961651285e-27, -1.396377159774333e-29,  1.947445223079275e-01, -9.535138477945679e-04,
  3.195154081415107e-06, -8.139727106819348e-09,  1.391572844983420e-11, -7.773413128381282e-16, -1.099860870808548e-16,  5.155759706715420e-19, -1.416473095052895e-21,
  1.817812396167012e-24,  5.328359517674292e-27, -4.509566314496445e-29,  2.371448219509279e-01, -1.141456485523840e-03,  3.669379791755370e-06, -8.482331124963600e-09,
  1.038803166837376e-11,  2.100721224936511e-14, -1.800416017065966e-16,  6.157062786671560e-19, -1.081110190449044e-21, -1.182298554978632e-24,  1.693770067091294e-26,
 -6.864410393618643e-29,  2.834477329012936e-01, -1.338304542355758e-03,  4.099293972035771e-06, -8.363591387343215e-09,  4.867477748849319e-12,  4.665275167551389e-14,
 -2.394065012851399e-16,  5.907249366972186e-19, -1.957749839854826e-22, -5.359988405279165e-24,  2.669788462028349e-26, -6.362074128161378e-29,  3.335442521803259e-01,
 -1.541191417149613e-03,  4.462796468353144e-06, -7.711348630384661e-09, -2.514982354851488e-12,  7.333837002275351e-14, -2.721074708100856e-16,  3.982619079248214e-19,
  1.176971975684342e-21, -9.480258376208409e-24,  2.823509515944722e-26, -1.456630725967817e-29,  3.873094491765648e-01, -1.746986016625018e-03,  4.737925644571183e-06,
 -6.477675839778384e-09, -1.140727814093962e-11,  9.735739573494294e-14, -2.627278846545644e-16,  2.636571702882457e-20,  2.775825678269841e-21, -1.172580597861735e-23,
  1.606614503316906e-26,  7.498251493228708e-29,  4.446007288947902e-01, -1.952302078035860e-03,  4.903578545388435e-06, -4.645803944796254e-09, -2.122555016759339e-11,
  1.144411964832211e-13, -1.997705459855484e-16, -4.920712767280984e-19,  4.148521459022618e-21, -1.021599921384410e-23, -1.095345994600265e-26,  1.731690382367378e-28,
  5.052558921453203e-01, -2.153513568526387e-03,  4.940345390348560e-06, -2.236649429541593e-09, -3.116372596508216e-11,  1.202578714736158e-13, -7.932772615600517e-17,
 -1.071684840748043e-18,  4.730541327400103e-21, -3.810480131869209e-24, -4.662737222085602e-26,  2.232878564164280e-28,  5.690909877617282e-01, -2.346777983142828e-03,
  4.831460041822902e-06,  6.855963589107429e-10, -4.022864680588949e-11,  1.110703575016723e-13,  9.159182023487868e-17, -1.578791439685704e-18,  3.999869554506655e-21,
  7.014894685641211e-24, -7.677784158025498e-26,  1.659481780775997e-28,  6.358979573064381e-01, -2.528069688349211e-03,  4.563860338545420e-06,  4.009510798038109e-09,
 -4.730532100095210e-11,  8.450638896269092e-14,  2.929454636058232e-16, -1.851311123102102e-18,  1.687466416637340e-21,  1.958742103559493e-23, -8.274420090445897e-26,
 -2.289893034112943e-29,  7.054420807615898e-01, -2.693225786503167e-03,  4.129340685637397e-06,  7.574968989830213e-09, -5.125507696958293e-11,  4.035209897135772e-14,
  4.917421568676646e-16, -1.735651890722386e-18, -2.009782454322082e-21,  2.919705313096793e-23, -4.951205061460307e-26, -2.941184119435965e-28,  7.774592432070152e-01,
 -2.838007276539730e-03,  3.525763116711881e-06,  1.117514865268793e-08, -5.104611747540693e-11, -1.876470997434060e-14,  6.452645498340047e-16, -1.136869007777845e-18,
 -6.298478950193942e-21,  3.034156501252644e-23,  2.355685143986518e-26, -5.153140522468432e-28,  8.516530583987176e-01, -2.958178505310131e-03,  2.758271359596466e-06,
  1.456308126915304e-08, -4.591087428431738e-11, -8.697865790713822e-14,  7.080029039587850e-16, -7.179018651293795e-20, -9.840099136152825e-21,  1.904547682260707e-23,
  1.145034279281349e-25, -5.153447584372854e-28,  9.276919065309738e-01, -3.049607965189309e-03,  1.840424763872815e-06,  1.746378539911887e-08, -3.551744973117334e-11,
 -1.552820578287695e-13,  6.421181392292318e-16,  1.292188771628346e-18, -1.106162296652564e-20, -4.369689737609290e-24,  1.800883480311171e-25, -1.869073245113624e-28,
  1.005205971379930e+00, -3.108393286985482e-03,  7.951355841529257e-07,  1.959279345139831e-08, -2.013354187181088e-11, -2.123058046796207e-13,  4.300653186198160e-16,
  2.634510525909039e-18, -8.725430099488085e-21, -3.337203286148194e-23,  1.719748234893360e-25,  3.953144049704705e-28,  1.083784397464357e+00, -3.131012655700293e-03,
 -3.447442352580323e-07,  2.068137678294572e-08, -7.515560924110225e-13, -2.459103869253071e-13,  8.652252666881676e-17,  3.535043284733962e-18, -2.625195035680466e-21,
 -5.583026774833003e-23,  6.590829478576829e-26,  9.300688302072911e-28,  1.162972731443921e+00, -3.114503654998292e-03, -1.536378003138558e-06,  2.050789180217237e-08,
  2.086480449573222e-11, -2.455581878668902e-13, -3.346342467637199e-16,  3.591178043558884e-18,  5.880668818681880e-21, -5.830411092761645e-23, -1.095316525699628e-25,
  1.009255091956864e-27,  1.242270863596002e+00, -3.056668509579313e-03, -2.727662389034878e-06,  1.893334458252754e-08,  4.225580994405143e-11, -2.051925497984388e-13,
 -7.431974351759101e-16,  2.580374054391744e-18,  1.388115429994229e-20, -3.340899405997554e-23, -2.675009816217729e-25,  4.042707792397425e-28,  1.321131743479020e+00,
 -2.956301623910342e-03, -3.858941850004873e-06,  1.593751288268469e-08,  6.050017871151398e-11, -1.260349298531702e-13, -1.029144290152823e-15,  6.161177846527286e-19,
  1.776986501410777e-20,  1.302368557843015e-23, -3.000369230835860e-25, -6.455623864240760e-28,  1.398961205422945e+00, -2.813431038013481e-03, -4.865929948310190e-06,
  1.164993045748996e-08,  7.262507244616239e-11, -1.840729717599954e-14, -1.092996985709323e-15, -1.783344001797194e-18,  1.489297107001445e-20,  6.033774838489184e-23,
 -1.518901171135551e-25, -1.431987543414812e-27,  1.475119298083870e+00, -2.629559893845158e-03, -5.683971956504446e-06,  6.368118307785175e-09,  7.616794535875514e-11,
  9.846197095503934e-14, -8.840009516549353e-16, -3.793929845454565e-18,  5.356940986707252e-21,  8.135558887945413e-23,  1.140968928247931e-25, -1.243154740634860e-27,
  1.548923558130358e+00, -2.407887439573240e-03, -6.253634006129580e-06,  5.543226559038318e-10,  6.980870568917814e-11,  1.994901947069059e-13, -4.328304568802062e-16,
 -4.580116160664196e-18, -7.140699403528480e-21,  5.922693204077656e-23,  3.267047079283082e-25, -5.567527377604060e-29,  1.619654687249100e+00, -2.153482107332223e-03,
 -6.527369394995691e-06, -5.197357345961113e-09,  5.392532094016768e-11,  2.597748599508741e-13,  1.390732314954174e-16, -3.704580696808530e-18, -1.652305411517612e-20,
  2.897694424704639e-24,  3.206206127150168e-25,  1.216131446003835e-27,  1.686565066292318e+00, -1.873372944785252e-03, -6.476697640583480e-06, -1.022816290643973e-08,
  3.087637731742835e-11,  2.624993425808067e-13,  6.482686621906739e-16, -1.451493222298625e-18, -1.761096076398988e-20, -5.311998076599033e-23,  8.693667075676151e-26,
  1.424224321808021e-27,  1.748890450617574e+00, -1.576521943442104e-03, -6.098972462112618e-06, -1.391402456151089e-08,  4.814410027593388e-12,  2.061744128116005e-13,
  9.164329786206233e-16,  1.181692223204348e-18, -9.757458593602781e-21, -7.101771346385298e-23, -1.865706185609170e-25,  3.804612630759860e-28,  1.805865018118432e+00,
 -1.273640880161415e-03, -5.422488932600474e-06, -1.578487548081353e-08, -1.908174748318383e-11,  1.077939199563380e-13,  8.528449770844374e-16,  2.940983815720982e-18,
  2.003210179894113e-21, -4.057700425248915e-23, -2.700199580974926e-25, -8.065021715609675e-28,  1.856739675333559e+00, -9.768245732366323e-04, -4.508507301820396e-06,
 -1.564056858441337e-08, -3.588678599086460e-11, -9.479994646987087e-16,  5.092671414916600e-16,  3.040920825021857e-18,  1.006001967513157e-20,  9.655864444312325e-24,
 -1.194097458983818e-25, -9.344226448558997e-28,  1.900803172273929e+00, -6.989896898587204e-04, -3.448891774734364e-06, -1.363166231059975e-08, -4.241202697566747e-11,
 -8.468015397851184e-14,  6.553888874649193e-17,  1.690390823895637e-18,  9.923237243761672e-21,  3.730192679269567e-23,  7.818048832616922e-26, -1.341532093231283e-28,
  1.937405163386613e+00, -4.531344389613048e-04, -2.358588606975438e-06, -1.027284224409774e-08, -3.838070463480839e-11, -1.189966027828796e-13, -2.623063057803858e-16,
 -3.686455950455989e-20,  3.749259443369649e-21,  2.656866546969253e-23,  1.247954632000882e-25,  4.358501116371600e-28,  1.965979952049834e+00, -2.514668134329538e-04,
 -1.363112167550720e-06, -6.368205788627683e-09, -2.675211659789561e-11, -1.018421665935970e-13, -3.461287965298142e-16, -9.971830444196829e-19, -2.025093254950449e-21,
  5.161269520712180e-25,  3.521034484919652e-26,  2.495286049474998e-28,  1.986069490687466e+00, -1.044805499075785e-04, -5.824166904764113e-07, -2.851124188746834e-09,
 -1.288325346408925e-11, -5.480359347582635e-14, -2.211232320505805e-16, -8.466891250014618e-19, -3.059181177037761e-21, -1.028114101436814e-23, -3.112496021294535e-26,
 -7.804439592917269e-29,  1.997346733274493e+00, -2.006239447619139e-05, -1.135836387210602e-07, -5.703353927607009e-10, -2.677392132277529e-12, -1.202582353054501e-14,
 -5.230884031151496e-17, -2.218689800450075e-19, -9.214972772092230e-22, -3.757309630123854e-24, -1.506239093984730e-26, -5.940916036191475e-29,  5.354437042081075e-04,
 -2.788290346781384e-06,  1.088733163485981e-08, -3.777808269303008e-11,  1.228459955423902e-13, -3.833350704977400e-16,  1.162308055909939e-18, -3.450455833880966e-21,
  1.007563351398730e-23, -2.903955768205319e-26,  8.278058889162699e-29, -2.338520642519092e-31,  4.817772068065897e-03, -2.505184137053400e-05,  9.751231482408876e-08,
 -3.365235266503148e-10,  1.085178563451814e-12, -3.345989499506509e-15,  9.981759479027203e-18, -2.900701555462565e-20,  8.242536880563550e-23, -2.295802527587212e-25,
  6.273285148798376e-28, -1.682631615405685e-30,  1.337589282684207e-02, -6.935059907698215e-05,  2.682405659476645e-07, -9.155736178146473e-10,  2.902236557644515e-12,
 -8.728479384067020e-15,  2.515111191479465e-17, -6.972894232671944e-20,  1.860286358193461e-22, -4.762307281529561e-25,  1.160870048382389e-27, -2.656822352284895e-30,
  2.619662553990645e-02, -1.352267867090597e-04,  5.180506462238952e-07, -1.738600731717355e-09,  5.365415809499632e-12, -1.550206704687842e-14,  4.213163376122432e-17,
 -1.072782959837510e-19,  2.520970241640854e-22, -5.276101975830281e-25,  8.889091283644481e-28, -7.088855143748933e-31,  4.325992664736716e-02, -2.219910559140941e-04,
  8.394666420421175e-07, -2.752506505421014e-09,  8.178232043986232e-12, -2.226295341493813e-14,  5.507731523431722e-17, -1.198845444726374e-19,  2.079806974477293e-22,
 -1.697809123435655e-25, -7.162861446886271e-28,  5.058360901897298e-30,  6.453855738802886e-02, -3.287193732292140e-04,  1.222629220633605e-06, -3.889115512827362e-09,
  1.097572076885102e-11, -2.739108565505724e-14,  5.788125941053679e-17, -8.820566045105762e-20,  5.867510360819292e-24,  6.593823763548888e-25, -3.439327309159623e-27,
  1.241292963278058e-29,  8.999763333713443e-02, -4.542490545778663e-04,  1.655396363355039e-06, -5.067467540945189e-09,  1.334974110708597e-11, -2.924762291265376e-14,
  4.539289276649881e-17, -1.521429900379769e-21, -3.509986155724980e-22,  1.781099079401730e-24, -6.116998645912512e-27,  1.604638547744374e-29,  1.195940489558662e-01,
 -5.971741246604218e-04,  2.123479013251834e-06, -6.196732149553691e-09,  1.487959700619415e-11, -2.639819860703877e-14,  1.465893331858770e-17,  1.369574221116222e-19,
 -7.925463611533433e-22,  2.764336373225220e-24, -6.886254099000762e-27,  9.806212467779259e-30,  1.532757688871469e-01, -7.558402451466539e-04,  2.610618282945292e-06,
 -7.179767583257871e-09,  1.516711177896673e-11, -1.784527045226142e-14, -3.398644624968813e-17,  3.069519672209189e-19, -1.183620830192179e-21,  3.019125843750632e-24,
 -3.920395742858991e-27, -9.369913967853750e-30,  1.909809761037292e-01, -9.283395390556003e-04,  3.098812301629010e-06, -7.917338431168358e-09,  1.387492807957947e-11,
 -3.248833998466440e-15, -9.617443036424428e-17,  4.713332854259675e-19, -1.347652397544652e-21,  1.993580976495365e-24,  3.515804865958533e-27, -3.744294600416594e-29,
  2.326370654575515e-01, -1.112505743104718e-03,  3.568602189405762e-06, -8.312990447826185e-09,  1.076634199667689e-11,  1.688914702656068e-14, -1.632916632257734e-16,
  5.805547239376565e-19, -1.112186816822788e-21, -5.631232141624033e-25,  1.407245257133425e-26, -6.159253593910406e-29,  2.781594697625603e-01, -1.305910250100326e-03,
  3.999427948145024e-06, -8.278553880418244e-09,  5.744410597369919e-12,  4.110460023960341e-14, -2.229814807816180e-16,  5.815734143320484e-19, -3.701868415804333e-22,
 -4.348046762219828e-24,  2.390268257395398e-26, -6.314982403720097e-29,  3.274503043710614e-01, -1.505859765024098e-03,  4.370066110959973e-06, -7.740205172940480e-09,
 -1.112596804056820e-12,  6.694555506168763e-14, -2.604786153916281e-16,  4.306808833449472e-19,  8.558242554961741e-22, -8.367274136198397e-24,  2.733103499812003e-26,
 -2.598045368638767e-29,  3.803968154289220e-01, -1.709396496929039e-03,  4.659161583020642e-06, -6.644957277242120e-09, -9.523074885008065e-12,  9.107043730877888e-14,
 -2.608086152013960e-16,  1.085681276462224e-19,  2.365994141699548e-21, -1.102429662007571e-23,  1.883899282173011e-26,  5.159735242160195e-29,  4.368696168348430e-01,
 -1.913302049375762e-03,  4.845865920434065e-06, -4.967367075843571e-09, -1.898571111094848e-11,  1.094960259962937e-13, -2.117458119745678e-16, -3.652731323632332e-19,
  3.774623847458255e-21, -1.050959038606590e-23, -3.919561702240115e-27,  1.466214959932169e-28,  4.967207016853228e-01, -2.114106459039187e-03,  4.910592887476654e-06,
 -2.716141125337492e-09, -2.877994994996897e-11,  1.180108864277900e-13, -1.072386975114993e-16, -9.228432951072238e-19,  4.562130130905232e-21, -5.482443401795762e-24,
 -3.706302285459028e-26,  2.106493579648448e-28,  5.597812160708217e-01, -2.308104166845592e-03,  4.835898900921261e-06,  5.981393585451724e-11, -3.798876265424435e-11,
  1.127527633050579e-13,  4.921142491408498e-17, -1.447333084116509e-18,  4.198944426697792e-21,  4.096154511496472e-24, -6.901997597149188e-26,  1.850770848619834e-28,
  6.258589870484064e-01, -2.491379085325335e-03,  4.607490121049863e-06,  3.266511178559136e-09, -4.554905086708066e-11,  9.092177011897977e-14,  2.419661837422737e-16,
 -1.786669552575847e-18,  2.332953372710155e-21,  1.627476973626481e-23, -8.247810989566240e-26,  3.341725594566971e-29,  6.947358031682538e-01, -2.659841338468784e-03,
  4.215348490194811e-06,  6.761968684069423e-09, -5.033398682018917e-11,  5.156442127005467e-14,  4.423986705338199e-16, -1.783553660726822e-18, -9.972565057126327e-22,
  2.697965315411444e-23, -6.081736408611791e-26, -2.199467019741888e-28,  7.661644559895265e-01, -2.809278672125690e-03,  3.654954783625065e-06,  1.035623862469244e-08,
 -5.126924000474226e-11, -3.682109365427849e-15,  6.107757509952786e-16, -1.320805325308111e-18, -5.194569491619131e-21,  3.084336403832173e-23,  1.879559085086359e-27,
 -4.678098422692903e-28,  8.398655657168748e-01, -2.935425920505568e-03,  2.928566472194927e-06,  1.381551261594039e-08, -4.748087065751734e-11, -7.004562749105074e-14,
  7.016935306162901e-16, -3.748641940610593e-19, -9.077580064457524e-21,  2.316193502505868e-23,  9.111211567501556e-26, -5.438385092522839e-28,  9.155242347711665e-01,
 -3.034056196656052e-03,  2.046480771513894e-06,  1.687150997685629e-08, -3.846625900699716e-11, -1.394771419760199e-13,  6.733299768463918e-16,  9.370718538279958e-19,
 -1.109158895321823e-20,  2.632430910520354e-24,  1.691390826095026e-25, -3.074711932142743e-28,  9.927866013016345e-01, -3.101097543489127e-03,  1.028178047447171e-06,
  1.923727315703057e-08, -2.427063481513064e-11, -2.011316544818052e-13,  4.997516598974723e-16,  2.337433314935225e-18, -9.799239781276830e-21, -2.619250845777628e-23,
  1.858195484283566e-25,  2.331843158652459e-28,  1.071256401938151e+00, -3.132778480804498e-03, -9.680170714086935e-08,  2.063015250817169e-08, -5.641037814207673e-12,
 -2.426574014375633e-13,  1.840295821199499e-16,  3.419466239099632e-18, -4.577988645726837e-21, -5.240021875559634e-23,  1.049141276790759e-25,  8.367969145769047e-28,
  1.150491700892278e+00, -3.125805000902340e-03, -1.288443667900038e-06,  2.080203754645827e-08,  1.588157487585636e-11, -2.523634769459282e-13, -2.317677810937886e-16,
  3.745019205005783e-18,  3.713807405172214e-21, -6.177074945851101e-23, -6.323047825077738e-26,  1.087417624678657e-27,  1.230002001700895e+00, -3.077569832634795e-03,
 -2.496544193376672e-06,  1.957566305747278e-08,  3.797969828124761e-11, -2.221132725129029e-13, -6.649235141331628e-16,  3.003301487894819e-18,  1.249078353581582e-20,
 -4.368023884247052e-23, -2.442810415464009e-25,  6.484671850662142e-28,  1.309246028133310e+00, -2.986391902301574e-03, -3.661971189595729e-06,  1.688401517534035e-08,
  5.773421645575165e-11, -1.504627723011368e-13, -1.003878423855517e-15,  1.189887439775686e-18,  1.801648461088244e-20,  5.249164527476736e-25, -3.230721074743781e-25,
 -3.945623921548303e-28,  1.387630539625810e+00, -2.851779564237524e-03, -4.719175585501649e-06,  1.280754519772139e-08,  7.199084927625384e-11, -4.518261333002985e-14,
 -1.135941091561738e-15, -1.273309966362633e-18,  1.694062874691323e-20,  5.300789737206074e-23, -2.143254666842490e-25, -1.393867513199288e-27,  1.464510628370335e+00,
 -2.674705140142122e-03, -5.600181260948316e-06,  7.601370876871230e-09,  7.791653161681883e-11,  7.599329335544682e-14, -9.873851437509913e-16, -3.574877673559367e-18,
  8.354012883893762e-21,  8.474941780116151e-23,  5.377032366557379e-26, -1.493305096942414e-27,  1.539192019557925e+00, -2.457870616826960e-03, -6.240150783459342e-06,
  1.702571926031165e-09,  7.368411781277382e-11,  1.875395840164844e-13, -5.639342806058067e-16, -4.771992201377061e-18, -4.774770391534131e-21,  7.214905277498981e-23,
  3.169121391423199e-25, -3.972553786618737e-28,  1.610935947139471e+00, -2.205935472100936e-03, -6.584388912430780e-06, -4.292843222240861e-09,  5.914548568247679e-11,
  2.618083184770413e-13,  2.797657214067311e-17, -4.229070973286810e-18, -1.617522513707195e-20,  1.676624308940239e-23,  3.720065149112604e-25,  1.106061842229348e-27,
  1.678967182399954e+00, -1.925668674937000e-03, -6.596295515948475e-06, -9.691310618495564e-09,  3.627832014689192e-11,  2.775046676399057e-13,  5.994551713858244e-16,
 -2.044843238531341e-18, -1.944495932392294e-20, -4.832096458309198e-23,  1.546640916882672e-25,  1.650447961548352e-27,  1.742485724090297e+00, -1.625979965596136e-03,
 -6.265338598219692e-06, -1.380280048223876e-08,  9.160329720029773e-12,  2.285281569887836e-13,  9.447546166580706e-16,  8.271447294424713e-19, -1.244363264830075e-20,
 -7.806145955324965e-23, -1.634300408312646e-25,  6.806691183028209e-28,  1.800682488022227e+00, -1.317783484669083e-03, -5.613664462948905e-06, -1.607179619304563e-08,
 -1.671448470689227e-11,  1.292561875862064e-13,  9.358550980250876e-16,  2.979560771601840e-18,  3.395593393004015e-22, -5.207714885925284e-23, -3.046361164442092e-25,
 -7.580471856322128e-28,  1.852759038463758e+00, -1.013653137129087e-03, -4.699637650139515e-06, -1.621421514802450e-08, -3.577643581975582e-11,  1.233282454394058e-14,
  5.989650171530489e-16,  3.367397771004497e-18,  1.031125949961353e-20,  4.003435304111000e-24, -1.645651066944861e-25, -1.120144866930899e-27,  1.897950978784646e+00,
 -7.272468079948576e-04, -3.616598843556978e-06, -1.432370134994935e-08, -4.408587612714634e-11, -8.250210484019416e-14,  1.175215461077046e-16,  2.030010243639092e-18,
  1.132065311027896e-20,  4.027533228590931e-23,  6.953834217187181e-26, -2.649048493720363e-28,  1.935554092497586e+00, -4.725068668942922e-04, -2.485626907635585e-06,
 -1.090631511749758e-08, -4.082359986770721e-11, -1.252898641231667e-13, -2.615079656447548e-16,  9.941702869809691e-20,  4.800327751520766e-21,  3.195737073845803e-23,
  1.449636994737020e-25,  4.802587049427804e-28,  1.964951780537125e+00, -2.626848190070895e-04, -1.442167544340829e-06, -6.812995377407082e-09, -2.887433018700190e-11,
 -1.104916065115021e-13, -3.749523024590235e-16, -1.061394325559282e-18, -1.978344509708634e-21,  2.163075378475258e-24,  4.763163092005115e-26,  3.174744791922137e-28,
  1.985642028075945e+00, -1.092803268530517e-04, -6.179040999830530e-07, -3.066321427786987e-09, -1.403437385328359e-11, -6.040645134080405e-14, -2.462584347256448e-16,
 -9.507519528546094e-19, -3.452553629146171e-21, -1.159632044790336e-23, -3.466906057676735e-26, -8.284459680897188e-29,  1.997264621960089e+00, -2.099918666862021e-05,
 -1.206928569941062e-07, -6.151681831538694e-10, -2.930983690277192e-12, -1.335924508026118e-14, -5.895519672893316e-17, -2.536426998552808e-19, -1.068266235985612e-21,
 -4.415514065799484e-24, -1.793697413583661e-26, -7.165671790601604e-29,  5.244619154097222e-04, -2.702972200543680e-06,  1.044553967835633e-08, -3.587239693093611e-11,
  1.154506067079886e-13, -3.565635404373527e-16,  1.070056456627312e-18, -3.144142866350507e-21,  9.087413541349368e-24, -2.592519606521732e-26,  7.315073049928247e-29,
 -2.045641322603199e-31,  4.719099733941005e-03, -2.428760581533936e-05,  9.357604271442664e-08, -3.196832826212987e-10,  1.020590116403271e-12, -3.115883046230319e-15,
  9.205280827825467e-18, -2.649694015986655e-20,  7.459486757484972e-23, -2.059073720681548e-25,  5.577632030796509e-28, -1.483805724551636e-30,  1.310271379322577e-02,
 -6.724784573216791e-05,  2.575266409002338e-07, -8.705022444608738e-10,  2.733548502010765e-12, -8.147624469692531e-15,  2.327952759039474e-17, -6.404159701480537e-20,
  1.696926816625982e-22, -4.320575454837849e-25,  1.049636685267295e-27, -2.403122847980048e-30,  2.566387709945123e-02, -1.311643981924981e-04,  4.976924612092407e-07,
 -1.655180474953756e-09,  5.065247391091843e-12, -1.452605906785516e-14,  3.923797407446516e-17, -9.950829570699353e-20,  2.337351949096777e-22, -4.927164606089036e-25,
  8.549043241028152e-28, -8.289826678611783e-31,  4.238518779589614e-02, -2.154052519895871e-04,  8.072072102645868e-07, -2.625146172289214e-09,  7.745923495288310e-12,
 -2.098063283288687e-14,  5.181276749989964e-17, -1.133320674621265e-19,  2.014039073606864e-22, -1.942631479618833e-25, -5.145168509542236e-28,  4.139253590668198e-30,
  6.324295055026083e-02, -3.191220727609584e-04,  1.176995667754502e-06, -3.717811916132671e-09,  1.044159070692470e-11, -2.603153030388615e-14,  5.541751487992647e-17,
 -8.766360900843141e-20,  2.725606483947734e-23,  5.322388727329999e-25, -2.929706010548155e-27,  1.078452186053490e-29,  8.820674340127611e-02, -4.412455350553905e-04,
  1.595849216225512e-06, -4.858492147141809e-09,  1.277567317840457e-11, -2.815991630581761e-14,  4.520235585615091e-17, -1.177333929414839e-20, -2.911168646241401e-22,
  1.550130390258916e-24, -5.441517668878784e-27,  1.466258333483179e-29,  1.172388628308205e-01, -5.804797284420036e-04,  2.050529311318989e-06, -5.962861940548787e-09,
  1.435544736972530e-11, -2.600314228788328e-14,  1.815326687804411e-17,  1.131358890112133e-19, -6.978827854978275e-22,  2.497684233909166e-24, -6.442859213549755e-27,
  1.028738904012984e-29,  1.502936379248147e-01, -7.352958296712288e-04,  2.525905201041586e-06, -6.939990509936209e-09,  1.480272409254359e-11, -1.856198994670804e-14,
 -2.590593389264369e-17,  2.707841155603234e-19, -1.077843720110471e-21,  2.855219523613050e-24, -4.247807286030185e-27, -5.645353437181511e-30,  1.873166025470742e-01,
 -9.039253046379201e-04,  3.005133695130536e-06, -7.695980406513857e-09,  1.378791361997572e-11, -5.403458246996268e-15, -8.356988192910045e-17,  4.293807549775497e-19,
 -1.273730341958950e-21,  2.103316244328913e-24,  2.020171813330834e-27, -3.068533196740955e-29,  2.282435124993007e-01, -1.084352996370703e-03,  3.469890344883345e-06,
 -8.138234190360186e-09,  1.106623078584178e-11,  1.316117685226394e-14, -1.475366938191667e-16,  5.447438488627025e-19, -1.122961424004478e-21, -5.236523165071591e-26,
  1.151614064904194e-26, -5.463497826978673e-29,  2.729991927251154e-01, -1.274310574004466e-03,  3.900662967225736e-06, -8.180351831965458e-09,  6.514298547068343e-12,
  3.594697660225750e-14, -2.068855162584898e-16,  5.674020814124005e-19, -5.101719884654122e-22, -3.447025983329593e-24,  2.116273494545646e-26, -6.118214784517437e-29,
  3.214961978173142e-01, -1.471270969040011e-03,  4.277119934725436e-06, -7.747630944842334e-09,  1.647910535649855e-13,  6.084160088576455e-14, -2.480799345372781e-16,
  4.534563060024932e-19,  5.739806511540684e-22, -7.299553913476369e-24,  2.599442487629805e-26, -3.430123451534716e-29,  3.736332675326491e-01, -1.672444616267316e-03,
  4.578566888522273e-06, -6.783094117020852e-09, -7.763971295143418e-12,  8.485570346019265e-14, -2.567673449654428e-16,  1.780794501743577e-19,  1.983174230387242e-21,
 -1.023148399293733e-23,  2.065528732409415e-26,  3.150223108991467e-29,  4.292935578988065e-01, -1.874778555121586e-03,  4.784506251300003e-06, -5.253898442321733e-09,
 -1.684736897164007e-11,  1.043046934073687e-13, -2.203394510070787e-16, -2.505567932361433e-19,  3.394941434446679e-21, -1.054500143779086e-23,  1.961652237322587e-27,
  1.209084896326073e-28,  4.883426280924370e-01, -2.074959740434176e-03,  4.875313729690365e-06, -3.157886913076766e-09, -2.644747807002532e-11,  1.151433868490782e-13,
 -1.310660827513354e-16, -7.802812909347778e-19,  4.340268314111706e-21, -6.784279146504144e-24, -2.815107126865900e-26,  1.938790557031175e-28,  5.506261639704280e-01,
 -2.269424265778915e-03,  4.833044334642546e-06, -5.299151566698417e-10, -3.572510021762408e-11,  1.134628345728650e-13,  1.058568857143807e-17, -1.311124157758115e-18,
  4.298707729311228e-21,  1.501786542609587e-24, -6.062574460689391e-26,  1.950765733711095e-28,  6.159674214977432e-01, -2.454374620994978e-03,  4.642376530647962e-06,
  2.552572521197181e-09, -4.367654993426413e-11,  9.613759220535839e-14,  1.930681598233736e-16, -1.703273755797726e-18,  2.859947704622026e-21,  1.301946403580523e-23,
 -7.994847703096639e-26,  7.991805920352904e-29,  6.841643780795442e-01, -2.625807584853405e-03,  4.291695906353696e-06,  5.965435057232585e-09, -4.920058270452666e-11,
  6.157998947345399e-14,  3.921549602862273e-16, -1.800412745532117e-18, -7.191496537631652e-23,  2.437475378672889e-23, -6.890605927636919e-26, -1.483789392305806e-28,
  7.549865879633706e-01, -2.779555880122053e-03,  3.774307914663881e-06,  9.536125199829371e-09, -5.119938432194857e-11,  1.051496001940656e-14,  5.716328341059114e-16,
 -1.469290540931653e-18, -4.087665555671995e-21,  3.052351071085300e-23, -1.744312476993418e-26, -4.089589650878214e-28,  8.281717507118047e-01, -2.911347259463950e-03,
  3.089751182691845e-06,  1.304552224423196e-08, -4.871439323651313e-11, -5.336296721187262e-14,  6.872606723252150e-16, -6.513491163027008e-19, -8.183947379384696e-21,
  2.632478070973162e-23,  6.699550020795126e-26, -5.486381208612269e-28,  9.034220208683255e-01, -3.016885187086942e-03,  2.245156942245059e-06,  1.623461971324194e-08,
 -4.109228411333488e-11, -1.230423400156003e-13,  6.946223505263689e-16,  5.849347074903052e-19, -1.087858452011830e-20,  9.096688403209474e-24,  1.533552083105882e-25,
 -4.060903610720632e-28,  9.804001142916704e-01, -3.091955632989050e-03,  1.256564767691687e-06,  1.881743521565082e-08, -2.816821284482430e-11, -1.883884906377757e-13,
  5.606783090019248e-16,  2.010222467981002e-18, -1.060634601766682e-20, -1.860267283388186e-23,  1.924857063903509e-25,  7.040342719189527e-29,  1.058725304428925e+00,
 -3.132564548623338e-03,  1.500592949651228e-07,  2.050134292695810e-08, -1.044235623278176e-11, -2.371100171555016e-13,  2.774462894381300e-16,  3.243667969368305e-18,
 -6.380301317510638e-21, -4.750246126906197e-23,  1.390474556354520e-25,  7.097423471288849e-28,  1.137969452335368e+00, -3.135110118033072e-03, -1.037462027097036e-06,
  2.101549823069514e-08,  1.078723540130435e-11, -2.566562179735141e-13, -1.255806950953901e-16,  3.827887331539903e-18,  1.456181880786627e-21, -6.333097114715348e-23,
 -1.457312916024116e-26,  1.115884380667156e-27,  1.217653279545824e+00, -3.096592566977342e-03, -2.258139509012670e-06,  2.014696243088054e-08,  3.338488969652719e-11,
 -2.370186798247650e-13, -5.754847008914543e-16,  3.376020761227894e-18,  1.074990392157185e-20, -5.281368561840951e-23, -2.107818821911869e-25,  8.692294559220217e-28,
  1.297243174027996e+00, -3.014861772530322e-03, -3.453924034752487e-06,  1.778239203675042e-08,  5.448706529167652e-11, -1.740909771463343e-13, -9.625053042365191e-16,
  1.764194104198292e-18,  1.779933067306039e-20, -1.266292792287711e-23, -3.342301192100252e-25, -1.078399305882255e-28,  1.376148915474676e+00, -2.888898703597938e-03,
 -4.558608570758677e-06,  1.395067730298114e-08,  7.081200712459855e-11, -7.281007320593198e-14, -1.163729973952817e-15, -7.024502908939282e-19,  1.868006201822070e-20,
  4.323614376977372e-23, -2.734345979529375e-25, -1.280219561487057e-27,  1.453722812675276e+00, -2.719120424152970e-03, -5.501438930134256e-06,  8.858873306316215e-09,
  7.919148535312964e-11,  5.112792980797751e-14, -1.083278261255379e-15, -3.258450939862469e-18,  1.142727782997858e-20,  8.552163855219510e-23, -1.666091234960620e-26,
 -1.699162197174504e-27,  1.529260852737784e+00, -2.507689777506319e-03, -6.212524975777924e-06,  2.910743065769813e-09,  7.728866365629091e-11,  1.723869928021369e-13,
 -6.992814759389236e-16, -4.880821163236035e-18, -1.954437581422373e-21,  8.436591675156762e-23,  2.911461072014316e-25, -7.793529547994890e-28,  1.602006552008963e+00,
 -2.258800154321411e-03, -6.630052265331024e-06, -3.304630943797137e-09,  6.437847536179221e-11,  2.610009614399682e-13, -9.757216482410762e-17, -4.734056691402343e-18,
 -1.529252364488415e-20,  3.256840552444727e-23,  4.166649517926597e-25,  9.086823450746622e-28,  1.671158244925611e+00, -1.978893927487372e-03, -6.708922895736757e-06,
 -9.065695811835625e-09,  4.196727499516047e-11,  2.911326503767933e-13,  5.332360592373710e-16, -2.693575124542826e-18, -2.105510462067240e-20, -4.062219281299877e-23,
  2.316778882021876e-25,  1.842760548815363e-27,  1.735880513783168e+00, -1.676762361792908e-03, -6.429937973632849e-06, -1.361843171037993e-08,  1.395926620731025e-11,
  2.514325520573533e-13,  9.619088262891799e-16,  3.827879355702952e-19, -1.536338730274692e-20, -8.389900406390874e-23, -1.258603135007755e-25,  1.035747846238221e-27,
  1.795320307846460e+00, -1.363468588390975e-03, -5.808041268154166e-06, -1.631729823880836e-08, -1.389799940447339e-11,  1.527172522407737e-13,  1.019135943136799e-15,
  2.958014750643079e-18, -1.762353116848559e-21, -6.490222946895223e-23, -3.358160130473074e-25, -6.476831957769525e-28,  1.848627985725642e+00, -1.052038227865641e-03,
 -4.897632010851711e-06, -1.678385108915492e-08, -3.537819737798263e-11,  2.787680142035996e-14,  6.978836328840649e-16,  3.698293811339448e-18,  1.032450118142841e-20,
 -3.621771882628653e-24, -2.181123270042220e-25, -1.314550595819959e-27,  1.894983020276931e+00, -7.568792520749766e-04, -3.792769404227413e-06, -1.504210237714715e-08,
 -4.570289167624791e-11, -7.895721051360871e-14,  1.796551373869648e-16,  2.415980993089408e-18,  1.281739725718486e-20,  4.277629775009353e-23,  5.425535123516202e-26,
 -4.372848504174854e-28,  1.933623450189411e+00, -4.929266819502539e-04, -2.620505547184499e-06, -1.157987882727270e-08, -4.339183921555069e-11, -1.315141891138737e-13,
 -2.563925669557724e-16,  2.725961372503553e-19,  6.060368871759582e-21,  3.819043583625270e-23,  1.669693213679422e-25,  5.185801454273390e-28,  1.963877437479507e+00,
 -2.745572081322653e-04, -1.526769960743021e-06, -7.293162487364448e-09, -3.117659472799123e-11, -1.198541581565891e-13, -4.055431487031991e-16, -1.123058999519427e-18,
 -1.862601242852992e-21,  4.371162222941558e-24,  6.338370232059449e-26,  4.014133560230262e-28,  1.985194781749566e+00, -1.143746543811116e-04, -6.560881907425560e-07,
 -3.300866843456241e-09, -1.530382740349711e-11, -6.664898635104238e-14, -2.744909425309288e-16, -1.068187991504557e-18, -3.895871381003414e-21, -1.305705708344308e-23,
 -3.839057156675961e-26, -8.595778518909934e-29,  1.997178646222007e+00, -2.199507564272627e-05, -1.283653225239817e-07, -6.642807650941662e-10, -3.212913706311693e-12,
 -1.486340858524577e-14, -6.656069653794349e-17, -2.905154426813167e-19, -1.240936977082997e-21, -5.200239824096818e-24, -2.140828231349187e-26, -8.662832346761637e-29,
  5.138144725699554e-04, -2.621098888661794e-06,  1.002592328102486e-08, -3.408087138835744e-11,  1.085691847710505e-13, -3.319066000068029e-16,  9.859552370280027e-19,
 -2.867730959886597e-21,  8.204676701385101e-24, -2.317145004634935e-26,  6.472134002386160e-29, -1.791865405698317e-31,  4.623422617192710e-03, -2.355406933006614e-05,
  8.983580169669679e-08, -3.038406258443001e-10,  9.604229933315342e-13, -2.903596241673434e-15,  8.495700608740461e-18, -2.422432561425874e-20,  6.756854221293433e-23,
 -1.848496825981576e-25,  4.963885529756831e-28, -1.309756906268388e-30,  1.283777771198051e-02, -6.522868537765530e-05,  2.473377538838000e-07, -8.280393306576032e-10,
  2.576040964164723e-12, -7.609834262680570e-15,  2.156010349469154e-17, -5.885239577989969e-20,  1.548695020420024e-22, -3.921172561717007e-25,  9.490595657890942e-28,
 -2.172188724981710e-30,  2.514705870870235e-02, -1.272609511701594e-04,  4.783071352492998e-07, -1.576410452149643e-09,  4.783921938044957e-12, -1.361695344651708e-14,
  3.655383521331854e-17, -9.230604722634887e-20,  2.166039041303427e-22, -4.592754711493400e-25,  8.165779446408733e-28, -9.070056552836662e-31,  4.153628552512884e-02,
 -2.090715258894573e-04,  7.764354335754886e-07, -2.504501799671875e-09,  7.338492601626802e-12, -1.977448430645411e-14,  4.872862088265981e-17, -1.070026682131171e-19,
  1.940816980589041e-22, -2.114383461234208e-25, -3.498619014497277e-28,  3.367437852337306e-30,  6.198501559418546e-02, -3.098817613807887e-04,  1.133367368466799e-06,
 -3.554840077796508e-09,  9.934062064970655e-12, -2.473084944320011e-14,  5.297786901631325e-17, -8.650656089825596e-20,  4.441763669726412e-23,  4.241044945922093e-25,
 -2.487486274356365e-27,  9.346244446846097e-30,  8.646693045301863e-02, -4.287085163862943e-04,  1.538755380124499e-06, -4.658528149399464e-09,  1.222329148880798e-11,
 -2.708001819341635e-14,  4.475037899644591e-17, -2.023697436310816e-20, -2.390782143312427e-22,  1.344974485163992e-24, -4.826037533627314e-27,  1.332284198236716e-29,
  1.149493046691076e-01, -5.643578460087288e-04,  1.980336008421270e-06, -5.737310580840305e-09,  1.383998520433878e-11, -2.553189244155954e-14,  2.102158828483424e-17,
  9.219345691115968e-20, -6.124952772426826e-22,  2.249089657643267e-24, -5.985734824264593e-27,  1.044442951848796e-29,  1.473923472968543e-01, -7.154177096876020e-04,
  2.444034022972675e-06, -6.706148115235477e-09,  1.442586126383163e-11, -1.909655258758121e-14, -1.879163653010189e-17,  2.379045004855333e-19, -9.781655725334286e-22,
  2.681266074377424e-24, -4.428188250097615e-27, -2.667337703829352e-30,  1.837484038559965e-01, -8.802499007251836e-04,  2.914101661649804e-06, -7.476343311297832e-09,
  1.366073801417407e-11, -7.269398829616399e-15, -7.210637240498576e-17,  3.898459577748304e-19, -1.196865345749667e-21,  2.158917542576610e-24,  8.028724247848116e-28,
 -2.478339049930187e-29,  2.239610045278017e-01, -1.056981480057492e-03,  3.373301969930216e-06, -7.959255984425042e-09,  1.129526001333230e-11,  9.799270827769354e-15,
 -1.327866289663484e-16,  5.088632431712599e-19, -1.117116109356470e-21,  3.621949890326251e-25,  9.260614924063561e-27, -4.794425425472277e-29,  2.679637419011870e-01,
 -1.243496102352042e-03,  3.803146983699081e-06, -8.070635950603252e-09,  7.184862423324881e-12,  3.117041757921410e-14, -1.912443357987116e-16,  5.492492500570068e-19,
 -6.196690695588627e-22, -2.653523940615783e-24,  1.853466199057432e-26, -5.812652978167253e-29,  3.156789592227431e-01, -1.437425760625320e-03,  4.184203302773962e-06,
 -7.735578776873053e-09,  1.323122047955777e-12,  5.504188357679776e-14, -2.351641067535492e-16,  4.678167546150386e-19,  3.295318289300726e-22, -6.291808775604925e-24,
  2.435157024403703e-26, -3.997334017774858e-29,  3.670162278085998e-01, -1.636143654662685e-03,  4.496479342986093e-06, -6.894073749775750e-09, -6.128041866251744e-12,
  7.875995845650959e-14, -2.509468800825432e-16,  2.358095453989859e-19,  1.629998949219631e-21, -9.382745812012579e-24,  2.165875574704505e-26,  1.462998189241547e-29,
  4.218705902193314e-01, -1.836759118055320e-03,  4.719910026959075e-06, -5.507057086491137e-09, -1.481466287558774e-11,  9.894428563098625e-14, -2.258910109103951e-16,
 -1.479674745317961e-19,  3.017949672164432e-21, -1.036738337680740e-23,  6.743077320161282e-27,  9.672753008571791e-29,  4.801205442244434e-01, -2.036115829010702e-03,
  4.834955550227496e-06, -3.562801679353773e-09, -2.417775574456345e-11,  1.117510877244073e-13, -1.510076896251533e-16, -6.455014210016721e-19,  4.077770828923336e-21,
 -7.745293196834169e-24, -2.004177498347798e-26,  1.743821808201117e-28,  5.416257418520944e-01, -2.230794891764195e-03,  4.823330639895703e-06, -1.083361104648741e-09,
 -3.345619610386029e-11,  1.132919311482296e-13, -2.419507830855744e-17, -1.173151643298956e-18,  4.311201613780362e-21, -7.504155757575319e-25, -5.196872491800623e-26,
  1.972454956218859e-28,  6.062243784565929e-01, -2.417124817605275e-03,  4.668878674593406e-06,  1.869365474103909e-09, -4.171126955197676e-11,  1.002096808264575e-13,
  1.467238555055095e-16, -1.604865841786905e-18,  3.272038669698014e-21,  9.903322223729866e-24, -7.559262560592197e-26,  1.164433712411446e-28,  6.737302494821604e-01,
 -2.591200962439482e-03,  4.358600123535138e-06,  5.188572767930853e-09, -4.787894703421788e-11,  7.038730128261720e-14,  3.418392410551120e-16, -1.789217685931753e-18,
  7.545732528825299e-22,  2.150793698057062e-23, -7.395068669136373e-26, -8.194258606845931e-29,  7.439294584815552e-01, -2.748917588272552e-03,  3.883835591786553e-06,
  8.719348612872833e-09, -5.085529769431992e-11,  2.372669508652112e-14,  5.288254596640211e-16, -1.582683020667582e-18, -3.005541883651612e-21,  2.948497908988996e-23,
 -3.400111645838470e-26, -3.427946584983685e-28,  8.165767703465905e-01, -2.886016390571798e-03,  3.241588533102902e-06,  1.225844334373875e-08, -4.961833644131045e-11,
 -3.711626454023147e-14,  6.655023731281177e-16, -8.976021963951535e-19, -7.193807938191889e-21,  2.852519711916781e-23,  4.314538668367767e-26, -5.322053375064881e-28,
  8.913916204435811e-01, -2.998156028018754e-03,  2.435949259190412e-06,  1.555836704571611e-08, -4.338529678125373e-11, -1.062138584758055e-13,  7.061843788234916e-16,
  2.432071984311350e-19, -1.044521256010479e-20,  1.484990898949125e-23,  1.337665852267206e-25, -4.801108310998894e-28,  9.680538157330455e-01, -3.081007821219316e-03,
  1.479547924360377e-06,  1.833735121605568e-08, -3.179706132231617e-11, -1.742956945931496e-13,  6.121228331605163e-16,  1.661593506194388e-18, -1.113713089362842e-20,
 -1.088781543214119e-23,  1.921246560090148e-25, -8.497710929759355e-29,  1.046199000803326e+00, -3.130383208029166e-03,  3.949177065437814e-07,  2.029671985924474e-08,
 -1.511073862329442e-11, -2.293860452191765e-13,  3.651615286516547e-16,  3.013268870619539e-18, -7.983142343244312e-21, -4.135944444757967e-23,  1.669876391614831e-25,
  5.566949852216591e-28,  1.125414013275507e+00, -3.142398527206904e-03, -7.844102975467553e-07,  2.114690175423496e-08,  5.632671590068288e-12, -2.583808272458312e-13,
 -1.809047383202865e-17,  3.837989940075416e-18, -8.224131379173043e-22, -6.293485956972463e-23,  3.421484883424243e-26,  1.093418331227778e-27,  1.205232322553784e+00,
 -3.113681913144339e-03, -2.013329784156949e-06,  2.064248006121175e-08,  2.851424982041917e-11, -2.496589110725827e-13, -4.764371412295207e-16,  3.688048062223160e-18,
  8.706592430166090e-21, -6.042275403905358e-23, -1.683284083437657e-25,  1.053464297520188e-27,  1.285129836179104e+00, -3.041625062193385e-03, -3.235423489046671e-06,
  1.862509336493696e-08,  5.077857617798282e-11, -1.965344864504780e-13, -9.052207244978275e-16,  2.323894644424998e-18,  1.710249020505431e-20, -2.603739341740037e-23,
 -3.322486619645769e-25,  2.000569517401067e-28,  1.364521470208073e+00, -2.924678799346161e-03, -4.384455475990696e-06,  1.507049684695545e-08,  6.907527222201926e-11,
 -1.009067087125541e-13, -1.174811594111579e-15, -8.200246734019989e-20,  2.002656478969501e-20,  3.122265718822200e-23, -3.258543462838056e-25, -1.090076684088638e-27,
  1.442759011730399e+00, -2.762685101205266e-03, -5.387500982088122e-06,  1.013267470520094e-08,  7.994689259614397e-11,  2.407856957638905e-14, -1.168934402452120e-15,
 -2.843795358302974e-18,  1.447560557637434e-20,  8.331289024429443e-23, -9.481206074240849e-26, -1.841055846837696e-27,  1.519130944461185e+00, -2.557228983256031e-03,
 -6.170065652813387e-06,  4.173985184223624e-09,  8.055748192686662e-11,  1.539600991380710e-13, -8.363478666665923e-16, -4.892594882190025e-18,  1.283021189305202e-21,
  9.520761676940035e-23,  2.479842756080597e-25, -1.184659171072998e-27,  1.592865044646542e+00, -2.311981288116972e-03, -6.663355780036760e-06, -2.232988466353105e-09,
  6.956405966582899e-11,  2.570144888813977e-13, -2.367771787748598e-16, -5.201367783161566e-18, -1.381113369452087e-20,  4.995561776459343e-23,  4.505656941007225e-25,
  6.162013915865580e-28,  1.663134654160840e+00, -2.032988602047162e-03, -6.813488060540000e-06, -8.346969877273384e-09,  4.791139666235524e-11,  3.029478559654962e-13,
  4.481771054278021e-16, -3.388786936574839e-18, -2.233073879992078e-20, -2.968868315279810e-23,  3.159844069490275e-25,  1.977834508427151e-27,  1.729069556202120e+00,
 -1.728851363042982e-03, -6.591849048541871e-06, -1.335359730502739e-08,  1.921934445693760e-11,  2.745886034044585e-13,  9.652836521194400e-16, -1.580419289735865e-19,
 -1.846234092265508e-20, -8.790634129087819e-23, -7.156533759417399e-26,  1.439374202553158e-27,  1.789772259698199e+00, -1.410719688203923e-03, -6.005077880140308e-06,
 -1.651387449857172e-08, -1.059239539390499e-11,  1.781617822388486e-13,  1.100800778696370e-15,  2.861590358095702e-18, -4.347050995861774e-21, -7.885554549348013e-23,
 -3.604773036083224e-25, -4.589724208338007e-28,  1.844340181607624e+00, -1.092034483211696e-03, -5.102413086508138e-06, -1.734449604144681e-08, -3.464458934273256e-11,
  4.590578518621729e-14,  8.060289580132109e-16,  4.024791306064436e-18,  1.002261414127215e-20, -1.356041814064570e-23, -2.802276205960120e-25, -1.507585214023031e-27,
  1.891893658052303e+00, -7.879559777847172e-04, -3.977713398357882e-06, -1.578572367500059e-08, -4.723319358766013e-11, -7.378593300629334e-14,  2.532790551027210e-16,
  2.851154464314456e-18,  1.439121807181736e-20,  4.450025218380393e-23,  3.032706642124199e-26, -6.591922255586260e-28,  1.931608918373325e+00, -5.144585651508878e-04,
 -2.763717583967174e-06, -1.229552185477805e-08, -4.608292014744751e-11, -1.375527865578838e-13, -2.458286919911045e-16,  4.898598182958719e-19,  7.561024303533278e-21,
  4.533445425904813e-23,  1.904255031281669e-25,  5.450766042758231e-28,  1.962754213830863e+00, -2.871301053190163e-04, -1.617361709944210e-06, -7.811704307237475e-09,
 -3.367358946933935e-11, -1.299711129321270e-13, -4.377958922759280e-16, -1.179618882739266e-18, -1.655086612489291e-21,  7.288588213247068e-24,  8.323787734629344e-26,
  5.044823953306919e-28,  1.984726528841883e+00, -1.197860678400741e-04, -6.972129364836820e-07, -3.556760284184702e-09, -1.670518229539826e-11, -7.361021271757139e-14,
 -3.062183774584774e-16, -1.200680538708735e-18, -4.394481691189911e-21, -1.466866680356710e-23, -4.219246330415963e-26, -8.628321130026067e-29,  1.997088560324665e+00,
 -2.305478078252072e-05, -1.366552301791489e-07, -7.181551736293023e-10, -3.526839281015427e-12, -1.656314479878034e-14, -7.528043536831814e-17, -3.333937935974149e-19,
 -1.444524419775928e-21, -6.137933381576572e-24, -2.560990566156595e-26, -1.049720636430760e-28,  5.034879426773646e-04, -2.542498349700404e-06,  9.627160499089814e-09,
 -3.239561057912656e-11,  1.021613281360428e-13, -3.091783170955225e-16,  9.092125363691370e-19, -2.618043427489663e-21,  7.415265258129917e-24, -2.073357265504257e-26,
  5.733285663345441e-29, -1.571662077419919e-31,  4.530620983884941e-03, -2.284971037409698e-05,  8.628003368653433e-08, -2.889275812533329e-10,  9.043363329920744e-13,
 -2.707600487193153e-15,  7.846716474127327e-18, -2.216488348105809e-20,  6.125788940083601e-23, -1.661003773981063e-25,  4.421870869968608e-28, -1.157257722783622e-30,
  1.258075841771927e-02, -6.328903993834634e-05,  2.376436489207583e-07, -7.880126847021634e-10,  2.428888066307047e-12, -7.111618961669325e-15,  1.997954698341032e-17,
 -5.411528764870358e-20,  1.414141481197645e-22, -3.560031786964457e-25,  8.581718569583085e-28, -1.962431167494140e-30,  2.464554982111384e-02, -1.235088809554923e-04,
  4.598406311761160e-07, -1.501999612346889e-09,  4.520150423329518e-12, -1.276990804745637e-14,  3.406386332871656e-17, -8.563304000838504e-20,  2.006481612783003e-22,
 -4.274259223574368e-25,  7.755713823846214e-28, -9.521734706406945e-31,  4.071223482523846e-02, -2.029782920866437e-04,  7.470730591860776e-07, -2.390187299543436e-09,
  6.954458699281817e-12, -1.864025562526754e-14,  4.581833283179539e-17, -1.009162655401711e-19,  1.862519008025535e-22, -2.226681865686723e-25, -2.163370042707670e-28,
  2.720882822074700e-30,  6.076335602439148e-02, -3.009827898380458e-04,  1.091646856666493e-06, -3.399783758005435e-09,  9.451964455294627e-12, -2.348827273676459e-14,
  5.057774729899568e-17, -8.485933460193648e-20,  5.798999325284532e-23,  3.324452038053589e-25, -2.104697102009589e-27,  8.080225353471771e-30,  8.477636706536801e-02,
 -4.166187987447046e-04,  1.484008793965603e-06, -4.467230141644636e-09,  1.169238103563759e-11, -2.601362979253669e-14,  4.408365657955907e-17, -2.714890520160917e-20,
 -1.939960811015358e-22,  1.163276224364103e-24, -4.268176153690895e-27,  1.204605569983265e-29,  1.127231278892212e-01, -5.487868229994462e-04,  1.912800160081254e-06,
 -5.519927669433125e-09,  1.333459049667182e-11, -2.499853892026244e-14,  2.334045501761831e-17,  7.384377236869414e-20, -5.357270948638775e-22,  2.018840650530251e-24,
 -5.527372112996460e-27,  1.035529049030683e-29,  1.445692768362888e-01, -6.961834379540610e-04,  2.364932451208248e-06, -6.478412085376734e-09,  1.403994188077136e-11,
 -1.947106503628388e-14, -1.255426251747762e-17,  2.081132409098230e-19, -8.848498299166339e-22,  2.502523485116439e-24, -4.491886188771153e-27, -3.240931896953456e-31,
  1.802734669079986e-01, -8.572922478324464e-04,  2.825691880338291e-06, -7.259024999201688e-09,  1.349890661720337e-11, -8.873219405844718e-15, -6.171516489931321e-17,
  3.527939627448084e-19, -1.118814767045651e-21,  2.170780581103177e-24, -1.725718485979979e-28, -1.968185077480244e-29,  2.197864508912653e-01, -1.030374022480899e-03,
  3.278881162768409e-06, -7.777132322761891e-09,  1.146050992421716e-11,  6.779344794419907e-15, -1.190364796114635e-16,  4.733916311658022e-19, -1.097900615172255e-21,
  6.923153046979116e-25,  7.291323656498532e-27, -4.164027506245592e-29,  2.630499972946289e-01, -1.213456316940894e-03,  3.707008877931668e-06, -7.950935080172741e-09,
  7.763605894915563e-12,  2.676277727089857e-14, -1.761563379281627e-16,  5.280295584691585e-19, -7.024576435857546e-22, -1.962213936795231e-24,  1.605854933270060e-26,
 -5.432627451436066e-29,  3.099956161449993e-01, -1.404323000401680e-03,  4.091538723692801e-06, -7.705904304290160e-09,  2.368586636634375e-12,  4.955612037531004e-14,
 -2.219503386097825e-16,  4.749221726018981e-19,  1.201251053399976e-22, -5.354085990184095e-24,  2.250945825152839e-26, -4.342746933857204e-29,  3.605430707118347e-01,
 -1.600504284685495e-03,  4.413213093923127e-06, -6.979845714004424e-09, -4.612505973445219e-12,  7.282205331464900e-14, -2.436635545973595e-16,  2.827332544534919e-19,
  1.307930169665793e-21, -8.507803015893489e-24,  2.198775289613281e-26,  8.094478462146610e-31,  4.145986482782384e-01, -1.799268057692747e-03,  4.652467479964118e-06,
 -5.728556385389082e-09, -1.289027165237318e-11,  9.348375440287348e-14, -2.287377496520946e-16, -5.730471951267303e-20,  2.650543458990159e-21, -1.001922294236824e-23,
  1.050346401264799e-26,  7.456098009989693e-29,  4.720531603623201e-01, -1.997613606886181e-03,  4.789953967225714e-06, -3.931968394499127e-09, -2.198036473968984e-11,
  1.079244971090430e-13, -1.672978235699028e-16, -5.196141219519834e-19,  3.786303855053326e-21, -8.399617933739870e-24, -1.282755591034512e-26,  1.533786241749584e-28,
  5.327796406193653e-01, -2.192269176118949e-03,  4.807193152446668e-06, -1.600575972100191e-09, -3.119874459669343e-11,  1.123326207357337e-13, -5.511872947825172e-17,
 -1.036009695753170e-18,  4.248853884377389e-21, -2.656428436417262e-24, -4.336328265887705e-26,  1.929610831866306e-28,  5.966307075019085e-01, -2.379695250644303e-03,
  4.687373495332029e-06,  1.218194976671034e-09, -3.967543957524094e-11,  1.032039589455104e-13,  1.033029820748152e-16, -1.495029316893472e-18,  3.575445775697218e-21,
  6.990676895482692e-24, -6.984404446595626e-26,  1.433097620734595e-28,  6.634355593249952e-01, -2.556096023231508e-03,  4.416314470979455e-06,  4.434200366656810e-09,
 -4.639320047382350e-11,  7.799368933699237e-14,  2.921914899043870e-16, -1.753259630802134e-18,  1.474910908842537e-21,  1.849585204906618e-23, -7.622052373375966e-26,
 -2.250624757801912e-29,  7.329965726930937e-01, -2.717442166976584e-03,  3.983603518327644e-06,  7.910134459168895e-09, -5.025748724941210e-11,  3.587682727975204e-14,
  4.833213887046095e-16, -1.662167787664995e-18, -1.972013214318128e-21,  2.784364919278210e-23, -4.755753938037309e-26, -2.731227669758518e-28,  8.050854827217532e-01,
 -2.859508824036856e-03,  3.383904782828531e-06,  1.145947017253235e-08, -5.020310729598310e-11, -2.147085508690407e-14,  6.373031759549238e-16, -1.111085746215104e-18,
 -6.141400370175021e-21,  2.979161792280451e-23,  2.042670560185022e-26, -4.977960718556477e-28,  8.794391370902893e-01, -2.977933588581273e-03,  2.618417561729250e-06,
  1.484813058677899e-08, -4.533973107879364e-11, -8.922095580784693e-14,  7.084022110885118e-16, -8.149569783340895e-20, -9.819544923681039e-21,  1.976197224662082e-23,
  1.114843137566302e-25, -5.284839873542320e-28,  9.557548383009151e-01, -3.068300153434717e-03,  1.696431212982650e-06,  1.780152422165180e-08, -3.513250671533044e-11,
 -1.590870324178146e-13,  6.536096113016024e-16,  1.300407243316497e-18, -1.139205493852767e-20, -3.320353881220027e-24,  1.852211992511338e-25, -2.259243888346138e-28,
  1.033685322947078e+00, -3.126254079377368e-03,  6.368779386927387e-07,  2.001875059448108e-08, -1.960414152257936e-11, -2.196399057918017e-13,  4.457422261129359e-16,
  2.735319410063371e-18, -9.346393676218868e-21, -3.423918362753696e-23,  1.877858354998896e-25,  3.866555549735976e-28,  1.112833477411631e+00, -3.147657618927433e-03,
 -5.302772481367237e-07,  2.119569643480098e-08,  4.693936815749651e-13, -2.575304895530046e-13,  8.866662341124882e-17,  3.775779496334004e-18, -3.051992899458551e-21,
 -6.062165862904646e-23,  8.092441931778596e-26,  1.021995634955074e-27,  1.192746960897431e+00, -3.128790339840104e-03, -1.763049345551474e-06,  2.105817700899021e-08,
  2.341524519601907e-11, -2.598247893419736e-13, -3.696069763088528e-16,  3.930649388036308e-18,  6.421754959148028e-21, -6.618484025439883e-23, -1.187793584293548e-25,
  1.190160409767329e-27,  1.272913003757198e+00, -3.066600940138656e-03, -3.007181098666220e-06,  1.940494788223628e-08,  4.663621967184391e-11, -2.174180699162437e-13,
 -8.326488333335348e-16,  2.853634569313504e-18,  1.592888589286372e-20, -3.905911840272810e-23, -3.165621346077598e-25,  5.121851834184626e-28,  1.352753775390984e+00,
 -2.959012434161130e-03, -4.197049847495357e-06,  1.615802470937970e-08,  6.677537561248507e-11, -1.290563773357083e-13, -1.167985242916233e-15,  5.742266695141528e-19,
  2.090505470819993e-20,  1.730142904502827e-23, -3.682961826171434e-25, -8.278740282725282e-28,  1.431622872128368e+00, -2.805276968555584e-03, -5.258223101288408e-06,
  1.141412717140693e-08,  8.014175217540907e-11, -4.876286335250128e-15, -1.241630855863722e-15, -2.333479719992850e-18,  1.738685121427590e-20,  7.787612705446851e-23,
 -1.774648771526286e-25, -1.901069185521508e-27,  1.508803655933992e+00, -2.606367018851561e-03, -6.112146358381098e-06,  5.486401460471938e-09,  8.342490167341419e-11,
  1.322517106363886e-13, -9.722374431683558e-16, -4.794893344720615e-18,  4.875385692150592e-21,  1.039642034326834e-22,  1.868860135056830e-25, -1.590501029935242e-27,
  1.583510363319296e+00, -2.365376007972785e-03, -6.683304999901206e-06, -1.079200343926670e-09,  7.463547562429148e-11,  2.495360232373616e-13, -3.883074293422715e-16,
 -5.611024538074203e-18, -1.168275832822651e-20,  6.841278098944088e-23,  4.694533990344076e-25,  2.264791888573293e-28,  1.654893068583637e+00, -2.087883665074111e-03,
 -6.908850457974772e-06, -7.531365176533459e-09,  5.406980934190190e-11,  3.124838300262085e-13,  3.431446100862905e-16, -4.117860181386284e-18, -2.315083540363537e-20,
 -1.528658514395590e-23,  4.045017418006431e-25,  2.029748626350732e-27,  1.722047674232566e+00, -1.782221474900184e-03, -6.750061860382347e-06, -1.300089763055132e-08,
  2.494206866805642e-11,  2.976326084801167e-13,  9.521084159774325e-16, -7.998919193234012e-19, -2.166207774773979e-20, -8.937498733067847e-23,  1.335589174442408e-27,
  1.878758777552757e-27,  1.784032040946307e+00, -1.459555578086649e-03, -6.204138933842609e-06, -1.665338457053861e-08, -6.758570209201024e-12,  2.055240529082325e-13,
  1.178531015714964e-15,  2.674245959778087e-18, -7.449581490543120e-21, -9.360245647911801e-23, -3.748030548015367e-25, -1.751721776891693e-28,  1.839889073681004e+00,
 -1.133695670243727e-03, -5.313839110849557e-06, -1.789037452205703e-08, -3.352371336613511e-11,  6.663852013831341e-14,  9.231236654853219e-16,  4.335407798400684e-18,
  9.316195619717590e-21, -2.615004733570956e-23, -3.505445503897833e-25, -1.684475770714194e-27,  1.888676972729249e+00, -8.205483570068486e-04, -4.171724021447834e-06,
 -1.655290214754312e-08, -4.864138360595948e-11, -6.669572200082860e-14,  3.398007994123926e-16,  3.337478407701749e-18,  1.600737201141720e-20,  4.505545891307649e-23,
 -4.600149382429499e-27, -9.384939434322690e-28,  1.929505912197627e+00, -5.371712365636115e-04, -2.915779615808632e-06, -1.305517240840763e-08, -4.889171586779015e-11,
 -1.432591798720645e-13, -2.284691741038239e-16,  7.594424928411031e-19,  9.335987900161655e-21,  5.343486833791906e-23,  2.146449306170479e-25,  5.517320245884573e-28,
  1.961579208736840e+00, -3.004533213429308e-04, -1.714422487340699e-06, -8.371859336965385e-09, -3.638078793194005e-11, -1.408802845495268e-13, -4.715224109138015e-16,
 -1.227695337902665e-18, -1.327098931497814e-21,  1.109727700868326e-23,  1.081115979712074e-25,  6.301766444965727e-28,  1.984235952284114e+00, -1.255391541749063e-04,
 -7.415476655352608e-07, -3.836231866440859e-09, -1.825368634144792e-11, -8.137927265053165e-14, -3.418879122541811e-16, -1.350086215359858e-18, -4.953840537071969e-21,
 -1.643149077852482e-23, -4.591968798005663e-26, -8.226057113289380e-29,  1.996994098749737e+00, -2.418347920247701e-05, -1.456229273981176e-07, -7.773361415509449e-10,
 -3.876953506765281e-12, -1.848733043381141e-14, -8.529729073295759e-17, -3.833611380214677e-19, -1.685099021894186e-21, -7.261000482585830e-24, -3.070740631049516e-26,
 -1.274994104501381e-28,  4.934695604000556e-04, -2.467008729504234e-06,  9.248020375507603e-09, -3.080933669658342e-11,  9.619017078674745e-14, -2.882107394007405e-16,
  8.391202281345996e-19, -2.392268041204346e-21,  6.708523114721906e-24, -1.857273801580866e-26,  5.084818443236766e-29, -1.380327452872369e-31,  4.440581006352966e-03,
 -2.217309669912930e-05,  8.289796456055889e-08, -2.748813909792056e-10,  8.520183870243135e-13, -2.526510589671983e-15,  7.252668109089247e-18, -2.029698829418043e-20,
  5.558475128409264e-23, -1.493906421181643e-25,  3.942734654015413e-28, -1.023518509932905e-30,  1.233134558603606e-02, -6.142506534120691e-05,  2.284160592979629e-07,
 -7.502627874729155e-10,  2.291330638222255e-12, -6.649792826503154e-15,  1.852579205098925e-17, -4.978863308900431e-20,  1.291956323742782e-22, -3.233459015319106e-25,
  7.760769331220680e-28, -1.772255464213392e-30,  2.415875930592568e-02, -1.199010415322271e-04,  4.422422838185837e-07, -1.431676773936601e-09,  4.272737063996689e-12,
 -1.198043649112897e-14,  3.175375756606484e-17, -7.945259119321442e-20,  1.858090719037985e-22, -3.972484195999893e-25,  7.331604730110263e-28, -9.719412911909440e-31,
  3.991209580524439e-02, -1.971145729405034e-04,  7.190463279985391e-07, -2.281839602850399e-09,  6.592424557611094e-12, -1.757385747658711e-14,  4.307490256736118e-17,
 -9.508590762607068e-20,  1.781074099889703e-22, -2.290934331489098e-25, -1.088583381773000e-28,  2.180622541264486e-30,  5.957663641419909e-02, -2.924102689484412e-04,
  1.051741549340553e-06, -3.252245300928341e-09,  8.994146327522574e-12, -2.230269935181508e-14,  4.822935272519480e-17, -8.282773964588771e-20,  6.852522742573154e-23,
  2.550302307349217e-25, -1.774141524659845e-27,  6.969213781870015e-30,  8.313330093981372e-02, -4.049580142807103e-04,  1.431507517323470e-06, -4.284257011347057e-09,
  1.118262347824478e-11, -2.496540801416460e-14,  4.324264361834754e-17, -3.271866790278024e-20, -1.550667703987518e-22,  1.002790264283025e-24, -3.764874939746922e-27,
  1.084436708633318e-29,  1.105581709559207e-01, -5.337457890350010e-04,  1.847824750128903e-06, -5.310542882774601e-09,  1.284037917296484e-11, -2.441542803038468e-14,
  2.517870178759458e-17,  5.782157357476002e-20, -4.669193355789179e-22,  1.806789815589086e-24, -5.077153932117953e-27,  1.008366290751080e-29,  1.418218949965688e-01,
 -6.775711529530739e-04,  2.288526441949322e-06, -6.256902831721356e-09,  1.364796337052887e-11, -1.970555890064195e-14, -7.110208062203622e-18,  1.812048293238818e-19,
 -7.979913429044966e-22,  2.323130815415342e-24, -4.464584431040847e-27,  1.484573972212488e-30,  1.768889624660138e-01, -8.350314882808642e-04,  2.739873367377136e-06,
 -7.044539398269524e-09,  1.330741012392227e-11, -1.023981810536848e-14, -5.232643360363469e-17,  3.182393146255685e-19, -1.040987366961794e-21,  2.147893770676985e-24,
 -9.399783250951367e-28, -1.531593269603099e-29,  2.157168302510676e-01, -1.004513148953333e-03,  3.186659767548070e-06, -7.592830256799423e-09,  1.156858130442511e-11,
  4.077583818053085e-15, -1.062692455259159e-16,  4.387103960714305e-19, -1.068153027286217e-21,  9.490792869535561e-25,  5.589416317311593e-27, -3.580009727196264e-29,
  2.582548829308537e-01, -1.184179739888692e-03,  3.612359896107490e-06, -7.822660069006390e-09,  8.257768101535661e-12,  2.270984205220726e-14, -1.616959736766177e-16,
  5.045400481728858e-19, -7.621001188538717e-22, -1.366449569057839e-24,  1.376074264571043e-26, -5.006347046785433e-29,  3.044432041207510e-01, -1.371959856295768e-03,
  3.999327038247286e-06, -7.660362835232149e-09,  3.307519597824516e-12,  4.438914849225224e-14, -2.086264609616603e-16,  4.758522195800143e-19, -5.688137590060723e-23,
 -4.492525025018963e-24,  2.055669365787777e-26, -4.506667625527834e-29,  3.542111328864707e-01, -1.565534758491108e-03,  4.329059185653457e-06, -7.042309245179865e-09,
 -3.213879657466675e-12,  6.707357891636459e-14, -2.352059054114592e-16,  3.198561310397475e-19,  1.017457395525968e-21, -7.631016073276908e-24,  2.177143122092711e-26,
 -1.020149348565963e-29,  4.074755753918951e-01, -1.762326654558005e-03,  4.582548069265703e-06, -5.920141982493827e-09, -1.107557546120302e-11,  8.798404816237292e-14,
 -2.292084488769671e-16,  2.182873897022116e-20,  2.298149464871952e-21, -9.539489172918981e-24,  1.333859706331868e-26,  5.470589673356785e-29,  4.641390381426594e-01,
 -1.959488525686203e-03,  4.740730742047688e-06, -4.266609171173764e-09, -1.986313519906593e-11,  1.037481676476048e-13, -1.801968450203950e-16, -4.033767849175408e-19,
  3.476250668418390e-21, -8.784067453734063e-24, -6.551536799713489e-27,  1.318881941792267e-28,  5.240873456057049e-01, -2.153896774373796e-03,  4.785065041722375e-06,
 -2.081864128797575e-09, -2.896759136170420e-11,  1.106769359027681e-13, -8.224018221375710e-17, -9.018947709495203e-19,  4.124025494031264e-21, -4.223587427098921e-24,
 -3.506303232449810e-26,  1.835953142610431e-28,  5.871870020305442e-01, -2.342148423366837e-03,  4.698251505494921e-06,  6.000212867034202e-10, -3.758989067162020e-11,
  1.051940430493443e-13,  6.307802348076671e-17, -1.377114919835368e-18,  3.778396819257251e-21,  4.328915682111063e-24, -6.311382051272284e-26,  1.612007657529892e-28,
  6.532821556071609e-01, -2.520565163853197e-03,  4.465123792827637e-06,  3.704752579664935e-09, -4.476714702513355e-11,  8.442311731484905e-14,  2.438568781759766e-16,
 -1.695998278843986e-18,  2.085788190020970e-21,  1.544292424493625e-23, -7.605282017632486e-26,  2.870290061247790e-29,  7.221911236297832e-01, -2.685207263864019e-03,
  4.073726089797754e-06,  7.112369266233365e-09, -4.942775633936861e-11,  4.691183393791825e-14,  4.360451709252417e-16, -1.709623682418497e-18, -1.006591445477319e-21,
  2.572163534051890e-23, -5.803459334496053e-26, -2.033434128456766e-28,  7.937024415075787e-01, -2.831901213741691e-03,  3.516587417967201e-06,  1.065360519799118e-08,
 -5.048220212603197e-11, -6.570115398611896e-15,  6.036035399111715e-16, -1.290334949345775e-18, -5.059353026652278e-21,  3.018404191316449e-23, -4.508075270404859e-28,
 -4.491593572725620e-28,  8.675704082931732e-01, -2.956285999846813e-03,  2.792186617408420e-06,  1.410934188712465e-08, -4.695449910626152e-11, -7.228150577447831e-14,
  7.018339971296767e-16, -3.835236136107908e-19, -9.033530808535309e-21,  2.374767376172033e-23,  8.763221785482152e-26, -5.516530461586011e-28,  9.435101196997785e-01,
 -3.053884022826502e-03,  1.906574578443427e-06,  1.721481413379158e-08, -3.815464491224609e-11, -1.430047184325542e-13,  6.849094745751014e-16,  9.353571688199344e-19,
 -1.138096556726511e-20,  3.852487781760191e-24,  1.725400484718080e-25, -3.467989644226914e-28,  1.021192010138396e+00, -3.120203818115350e-03,  8.750779383742995e-07,
  1.967054861118689e-08, -2.388393710694751e-11, -2.080579079380097e-13,  5.179691959711082e-16,  2.417992918429453e-18, -1.044017158154259e-20, -2.643952139665722e-23,
  2.009033710981561e-25,  2.091528864573540e-28,  1.100235973038199e+00, -3.150882706326173e-03, -2.760533270392438e-07,  2.116215319793649e-08, -4.651438156455946e-12,
 -2.541468567245499e-13,  1.926980268401295e-16,  3.643908544780761e-18, -5.165546660071569e-21, -5.651632458227875e-23,  1.235009733254537e-25,  9.066053361823396e-28,
  1.180205199637044e+00, -3.141877971039005e-03, -1.508276300298000e-06,  2.139080480739427e-08,  1.813906900391824e-11, -2.673536693001891e-13, -2.570359751576686e-16,
  4.097210294864816e-18,  3.966463404862805e-21, -6.986056498031366e-23, -6.441562805955906e-26,  1.271267471419266e-27,  1.260599977338990e+00, -3.089714603768532e-03,
 -2.769991583340398e-06,  2.011528291710353e-08,  4.209478644791105e-11, -2.363866072947684e-13, -7.458394542587874e-16,  3.338466465704075e-18,  1.430108077716365e-20,
 -5.118147381249235e-23, -2.873814950845401e-25,  8.104061844360272e-28,  1.340851826237348e+00, -2.991795290881054e-03, -3.996833207477981e-06,  1.720426547904519e-08,
  6.391562669381249e-11, -1.568190181302877e-13, -1.142468453648274e-15,  1.250244935354749e-18,  2.125477875145746e-20,  1.932433012454899e-24, -3.977905451467228e-25,
 -5.036707536262272e-28,  1.420318530909471e+00, -2.846773094741706e-03, -5.113568487924586e-06,  1.269397486281807e-08,  7.974127843800917e-11, -3.539406776945769e-14,
 -1.298768228287505e-15, -1.733777417430906e-18,  2.004247513093114e-20,  6.910787498733081e-23, -2.606852403004808e-25, -1.864885284661471e-27,  1.498280842772907e+00,
 -2.654977958314630e-03, -6.038217694760343e-06,  6.841047077878410e-09,  8.582583004462006e-11,  1.073280635612086e-13, -1.103738170386582e-15, -4.577698652450368e-18,
  8.734741584746283e-21,  1.099254544313371e-22,  1.084108370426687e-25, -1.969749882175161e-27,  1.573941873543802e+00, -2.418873573002299e-03, -6.688927492521046e-06,
  1.543325303238072e-10,  7.952006830485519e-11,  2.382915014261746e-13, -5.502538296308208e-16, -5.941831354447458e-18, -8.880712151667361e-21,  8.725475882602420e-23,
  4.691354985109090e-25, -2.552192347123892e-28,  1.646430441324701e+00, -2.143500789596462e-03, -6.993828560377020e-06, -6.615844067198673e-09,  6.039206696187808e-11,
  3.192515937000253e-13,  2.174134939159064e-16, -4.864194872110811e-18, -2.338844725639827e-20,  2.671445853677552e-24,  4.929796263925317e-25,  1.971648113560549e-27,
  1.714809809459297e+00, -1.836838768202667e-03, -6.903477758411550e-06, -1.255297082738779e-08,  3.112099528056567e-11,  3.201331482555531e-13,  9.195241832255253e-16,
 -1.544378411239367e-18, -2.485747798992946e-20, -8.753468551356711e-23,  9.399377906816010e-26,  2.333343250303561e-27,  1.778093284583099e+00, -1.509989567842512e-03,
 -6.404487679132480e-06, -1.672707610768694e-08, -2.359329325377353e-12,  2.346771889417275e-13,  1.249545227753812e-15,  2.379042060184774e-18, -1.109002093417508e-20,
 -1.086411478072554e-22, -3.742605932192102e-25,  2.192004888198046e-28,  1.835267897176334e+00, -1.177074130239035e-03, -5.531693886694401e-06, -1.841484615239522e-08,
 -3.195939053301930e-11,  9.028290224456790e-14,  1.048527068228015e-15,  4.615609712989611e-18,  8.104126246252294e-21, -4.169894202128672e-23, -4.279251373909039e-25,
 -1.824774065260010e-27,  1.885326754888190e+00, -8.547300172745205e-04, -4.375070914539265e-06, -1.734135966718151e-08, -4.988587095884117e-11, -5.735973206149126e-14,
  4.406645888768605e-16,  3.875544302165250e-18,  1.761523647355944e-20,  4.394929092013870e-23, -5.321103843971332e-26, -1.282207710730496e-27,  1.927309563520515e+00,
 -5.611376399635024e-04, -3.077230784277760e-06, -1.386065139426608e-08, -5.180982741830959e-11, -1.484516705673843e-13, -2.027209841356807e-16,  1.090676916682668e-18,
  1.142000231432179e-20,  6.250176749420619e-23,  2.385261300999163e-25,  5.276261101940794e-28,  1.960349314172711e+00, -3.145806642552776e-04, -1.818472359855933e-06,
 -8.977119423592199e-09, -3.931436653581942e-11, -1.526137264661607e-13, -5.064260853170976e-16, -1.262879096862089e-18, -8.426888348223841e-22,  1.601901244204537e-23,
  1.390823506346196e-25,  7.822531962195109e-28,  1.983721632174916e+00, -1.316607662895754e-04, -7.893899921856045e-07, -4.141770535589131e-09, -1.996648183242737e-11,
 -9.005668402444641e-14, -3.820011418129043e-16, -1.518435088910129e-18, -5.579286465503477e-21, -1.833812423770435e-23, -4.933542594283002e-26, -7.170112927904463e-29,
  1.996894974261810e+00, -2.538685812976658e-05, -1.553357208100334e-07, -8.424403605981564e-10, -4.268073476109450e-12, -2.066961835730304e-14, -9.682737941495072e-17,
 -4.417151330735929e-19, -1.970026173357244e-21, -8.609240749529046e-24, -3.690641893596295e-26, -1.552283698894034e-28,  4.837471886667284e-04, -2.394477682017775e-06,
  8.887355855705907e-09, -2.931533581526066e-11,  9.062204198697560e-14, -2.688520020252831e-16,  7.750443570675914e-19, -2.187912223664436e-21,  6.075097988477661e-24,
 -1.665521153336708e-26,  4.514934769056628e-29, -1.213854941119445e-31,  4.353194418191884e-03, -2.152287932020690e-05,  7.967954425284666e-08, -2.616440706757459e-10,
  8.031838000774641e-13, -2.359070211308860e-15,  6.708467104511370e-18, -1.860136740351763e-20,  5.048003840700785e-23, -1.344847361242617e-25,  3.518765982602166e-28,
 -9.061264768588845e-31,  1.208924382838781e-02, -5.963313619174244e-05,  2.196285617040721e-07, -7.146417721992733e-10,  2.162670420698462e-12, -6.221446171883928e-15,
  1.718788186705670e-17, -4.583477817334352e-20,  1.180956373750617e-22, -2.938104823137069e-25,  7.019477159203905e-28, -1.600100475833664e-30,  2.368612382595964e-02,
 -1.164306795072983e-04,  4.254645702912890e-07, -1.365189188319299e-09,  4.040572454569370e-12, -1.124438350836697e-14,  2.961021743653581e-17, -7.372993973708444e-20,
  1.720256834112266e-22, -3.687786492813233e-25,  6.903258360121583e-28, -9.723208001389874e-31,  3.913497133164782e-02, -1.914699638297524e-04,  6.922857062786238e-07,
 -2.179117351180666e-09,  6.251073025895479e-12, -1.657137228965740e-14,  4.049104447377276e-17, -8.951908944870997e-20,  1.698035192275651e-22, -2.316673712814882e-25,
 -2.311628407488369e-29,  1.730371534475499e-30,  5.842357944211944e-02, -2.841500314157605e-04,  1.013563525572512e-06, -3.111845284466470e-09,  8.559480846688812e-12,
 -2.117276921154106e-14,  4.594216127768893e-17, -8.050114941570688e-20,  7.650012558774634e-23,  1.899017565102802e-25, -1.489362287965777e-27,  5.996874885028430e-30,
  8.153605164399148e-02, -3.937085943877356e-04,  1.381153669654404e-06, -4.109273433722704e-09,  1.069361658644205e-11, -2.393910642076621e-14,  4.226227619231956e-17,
 -3.713134909462895e-20, -1.215651041234273e-22,  8.614026622216549e-25, -3.312660147648573e-27,  9.724736274786405e-30,  1.084523542765726e-01, -5.192146414047324e-04,
  1.785314905541133e-06, -5.108969930623315e-09,  1.235823616433104e-11, -2.379334079798680e-14,  2.659802988024329e-17,  4.388253152850103e-20, -4.054245173916082e-22,
  1.612466760035775e-24, -4.641935914021642e-27,  9.681056655213753e-30,  1.391477564844748e-01, -6.595595905116954e-04,  2.214740781340507e-06, -6.041695904794875e-09,
  1.325254212571948e-11, -1.981812856016019e-14, -2.381645039146312e-18,  1.569729172387239e-19, -7.175534167345551e-22,  2.146284538534416e-24, -4.367813322770385e-27,
  2.847281753849387e-30,  1.735921441907586e-01, -8.134470356104740e-04,  2.656609434779999e-06, -6.833324478025040e-09,  1.309075803268550e-11, -1.139241715572367e-14,
 -4.387052976501772e-17,  2.861563997362666e-19, -9.644919695185557e-22,  2.097951514335718e-24, -1.530196270376783e-27, -1.161619548185083e-29,  2.117491916058331e-01,
 -9.793811746930912e-04,  3.096658641841094e-06, -7.407215010161830e-09,  1.162560353474064e-11,  1.670699215566790e-15, -9.445846030172411e-17,  4.051163349919463e-19,
 -1.030326714879130e-21,  1.142759271196520e-24,  4.133428636824781e-27, -3.046684361888748e-29,  2.535753704222681e-01, -1.155654069117506e-03,  3.519295039512671e-06,
 -7.687108303106723e-09,  8.674287784209895e-12,  1.899586662538078e-14, -1.479169355853273e-16,  4.794677720782559e-19, -8.019035019622438e-22, -8.587620634494017e-25,
  1.165641908129673e-26, -4.556471146516121e-29,  2.990187730974487e-01, -1.340331972034059e-03,  3.907748634070620e-06, -7.600607782259507e-09,  4.146309773080297e-12,
  3.954165023010223e-14, -1.953512862951723e-16,  4.715991293730313e-19, -2.042908784427408e-22, -3.710065636420976e-24,  1.856492227377861e-26, -4.525769461877370e-29,
  3.480177224817683e-01, -1.531241090050365e-03,  4.244286225788986e-06, -7.083303147543304e-09, -1.928114103847116e-12,  6.153954011864945e-14, -2.258342194805641e-16,
  3.481863366620951e-19,  7.582834400581772e-22, -6.771806990232153e-24,  2.112724669082717e-26, -1.868825965974475e-29,  4.004991355328356e-01, -1.725953317580040e-03,
  4.510500212445725e-06, -6.083572276693218e-09, -9.370813403078810e-12,  8.249837642470329e-14, -2.276185410961281e-16,  8.998213747124098e-20,  1.964863152226910e-21,
 -8.963105870782026e-24,  1.535383333092235e-26,  3.730552436765824e-29,  4.563766040480126e-01, -1.921772723610384e-03,  4.687692273697240e-06, -4.568058221974722e-09,
 -1.783227022891866e-11,  9.930018516240302e-14, -1.899818707760573e-16, -2.972359898229383e-19,  3.156648461245644e-21, -8.936342796894820e-24, -1.216406253892772e-27,
  1.107298341212823e-28,  5.155481504245166e-01, -2.115723895212390e-03,  4.757374459982902e-06, -2.527752841674811e-09, -2.677575934511312e-11,  1.084148975790476e-13,
 -1.056703698259820e-16, -7.726138401378711e-19,  3.948645125082174e-21, -5.468181660208551e-24, -2.726255550667556e-26,  1.704504605607561e-28,  5.778936117396684e-01,
 -2.304543674386120e-03,  4.701912790714769e-06,  1.548347393719973e-11, -3.547392322222721e-11,  1.062589946074691e-13,  2.623156324359288e-17, -1.254185914156915e-18,
  3.890537594831367e-21,  1.949668137769200e-24, -5.577688413691819e-26,  1.710590769308688e-28,  6.432716014747342e-01, -2.484678391741236e-03,  4.505339883202371e-06,
  3.002287911564919e-09, -4.302396446930758e-11,  8.971386195771951e-14,  1.973827688806317e-16, -1.620941792251840e-18,  2.587400389488896e-21,  1.243918695731770e-23,
 -7.382563013916175e-26,  7.104621024777950e-29,  7.115159958501357e-01, -2.652289430851452e-03,  4.154362215444394e-06,  6.329583330831019e-09, -4.838876148618527e-11,
  5.679968382355016e-14,  3.878606706721023e-16, -1.727483271578356e-18, -1.243710604249853e-22,  2.324132012101320e-23, -6.549281576291041e-26, -1.363290688549537e-28,
  7.824318923333281e-01, -2.803270877442553e-03,  3.639582567955703e-06,  9.845613244246664e-09, -5.047175635610545e-11,  7.465525374258302e-15,  5.653706833431562e-16,
 -1.434889385995969e-18, -3.977663813419081e-21,  2.978747802873910e-23, -1.894786118177614e-26, -3.902479793097938e-28,  8.557909934217333e-01, -2.933284134063150e-03,
  2.956946335524308e-06,  1.334741582354726e-08, -4.823272427619985e-11, -5.559820607325567e-14,  6.871813841995697e-16, -6.582890195362718e-19, -8.121385955283672e-21,
  2.676597583469841e-23,  6.328542777488229e-26, -5.513482911187927e-28,  9.313263821969963e-01, -3.037815704707359e-03,  2.109398034633480e-06,  1.658236034850405e-08,
 -4.084845158966734e-11, -1.262935896074287e-13,  7.060309669828313e-16,  5.746856150685280e-19, -1.112200409948326e-20,  1.041856918213242e-23,  1.550587845718434e-25,
 -4.435915526977087e-28,  1.008726681491927e+00, -3.112265816454209e-03,  1.108696594667261e-06,  1.925581411341830e-08, -2.791549728554358e-11, -1.948527769199231e-13,
  5.808638567328625e-16,  2.070244111268184e-18, -1.124560134676960e-20, -1.827145911636517e-23,  2.062198499148290e-25,  3.356151581151710e-29,  1.087629631390107e+00,
 -3.152076999280071e-03, -2.272085577145474e-08,  2.104735229881753e-08, -9.679967761044842e-12, -2.483182734113601e-13,  2.921146720950767e-16,  3.447086615026022e-18,
 -7.101981202708180e-21, -5.082081185765963e-23,  1.601679478471220e-25,  7.548058875474640e-28,  1.167615187460368e+00, -3.152912897344456e-03, -1.250022723994037e-06,
  2.163795738302798e-08,  1.273966366487429e-11, -2.721338662111775e-13, -1.409181047578329e-16,  4.183510281131305e-18,  1.418688946802903e-21, -7.130784667407797e-23,
 -7.794974031911190e-27,  1.292332220079542e-27,  1.248198343503000e+00, -3.110897918538226e-03, -2.524726165392100e-06,  2.075003775845869e-08,  3.719588422591726e-11,
 -2.531150967583372e-13, -6.462478924380418e-16,  3.764476601486471e-18,  1.226097168365669e-20, -6.188227993536824e-23, -2.457169046991209e-25,  1.076767334435398e-27,
  1.328822027483902e+00, -3.022927014726617e-03, -3.784354412055901e-06,  1.820034796920200e-08,  6.050828653694484e-11, -1.837413679098432e-13, -1.097951110773272e-15,
  1.928402956333611e-18,  2.103355965691272e-20, -1.431603559609291e-23, -4.119298053330493e-25, -1.328571473606503e-28,  1.408850616712555e+00, -2.887050707102649e-03,
 -4.953614514819886e-06,  1.396246350023794e-08,  7.871814453466663e-11, -6.707235795815765e-14, -1.337976224002978e-15, -1.054783193281944e-18,  2.232318393846081e-20,
  5.707316104311864e-23, -3.400215073129995e-25, -1.723576802017922e-27,  1.487564872536274e+00, -2.702931831413305e-03, -5.947819793414040e-06,  8.229950609832116e-09,
  8.769729078101711e-11,  7.933550772218703e-14, -1.227400696833989e-15, -4.234208538374327e-18,  1.274830623269504e-20,  1.124283847125769e-22,  1.438209914251768e-26,
 -2.292403272727899e-27,  1.564159399148210e+00, -2.472355598264149e-03, -6.679286783347161e-06,  1.464005626894065e-09,  8.414020816385680e-11,  2.230598727345913e-13,
 -7.201057962046551e-16, -6.172165101227896e-18, -5.405914753570185e-21,  1.056358617777580e-22,  4.458414440286121e-25, -8.147768098436979e-28,  1.637744057937567e+00,
 -2.199752065084213e-03, -7.067209556533637e-06, -5.598255059807651e-09,  6.681780988318399e-11,  3.227508045367379e-13,  7.078057501839056e-17, -5.607113515184365e-18,
 -2.291682602215768e-20,  2.407933649557198e-23,  5.760077314834374e-25,  1.778103447888602e-27,  1.707351057318294e+00, -1.892660173646053e-03, -7.050910664991312e-06,
 -1.200263089624818e-08,  3.774036461774869e-11,  3.415900521746186e-13,  8.646780753865752e-16, -2.389303310033308e-18, -2.791510447364500e-20, -8.158973281498543e-23,
  2.064666666991034e-25,  2.773851194437418e-27,  1.771949582828858e+00, -1.562028643261494e-03, -6.605278862972401e-06, -1.672562573996789e-08,  2.639278015592872e-12,
  2.654218145066711e-13,  1.310581661094880e-15,  1.958722044513886e-18, -1.526695991801211e-20, -1.232757077546428e-22, -3.537028123715251e-25,  7.361750539340224e-28,
  1.830469681944862e+00, -1.222220140568770e-03, -5.755676005031251e-06, -1.891033940839531e-08, -2.989147266784658e-11,  1.170261921591813e-13,  1.181144642523500e-15,
  4.847460739179010e-18,  6.275241492336452e-21, -6.045001168067587e-23, -5.101914047903141e-25, -1.901542660933870e-27,  1.881836496474933e+00, -8.905766220773498e-04,
 -4.587992166603557e-06, -1.814809847331461e-08, -5.091818102967497e-11, -4.541645796371416e-14,  5.573057073139609e-16,  4.464018648386875e-18,  1.914445128549114e-20,
  4.057606231439633e-23, -1.184587226013330e-25, -1.695272538515147e-27,  1.925014703664038e+00, -5.864351170870367e-04, -3.248631148618541e-06, -1.471361409494830e-08,
 -5.482481772775853e-11, -1.529070660123948e-13, -1.667142228131663e-16,  1.494003919349066e-18,  1.384725545460503e-20,  7.249056214523694e-23,  2.604102982816211e-25,
  4.582230378590828e-28,  1.959061198288824e+00, -3.295702746973478e-04, -1.930074869296034e-06, -9.631239934231552e-09, -4.249106087706206e-11, -1.651947540863361e-13,
 -5.420694698773482e-16, -1.279474120133935e-18, -1.571067292784759e-22,  2.232202243623609e-23,  1.773953664575200e-25,  9.645372459534515e-28,  1.983182036243554e+00,
 -1.381802622915694e-04, -8.410691122414817e-07, -4.476156270255818e-09, -2.186284650204383e-11, -9.975570408157624e-14, -4.271188403205810e-16, -1.707921764946756e-18,
 -6.275695643095474e-21, -2.036953059042658e-23, -5.208868570625229e-26, -5.156092120835365e-29,  1.996790875750869e+00, -2.667117420909333e-05, -1.658688029445110e-07,
 -9.141672751161579e-10, -4.705744293525983e-12, -2.314931226795447e-14, -1.101266795333900e-16, -5.100137323044780e-19, -2.308263554926458e-21, -1.023164754090073e-23,
 -4.446289803184147e-26, -1.894383787961255e-28,  4.743092819350585e-04, -2.324761724286536e-06,  8.544097317443752e-09, -2.790740924662906e-11,  8.542616163225626e-14,
 -2.509646502195803e-16,  7.164167465274881e-19, -2.002764116808122e-21,  5.506771182467242e-24, -1.495164312062668e-26,  4.013466789044331e-29, -1.068827026484150e-31,
  4.268358192435270e-03, -2.089778694540157e-05,  7.661539192369441e-08, -2.491620071245519e-10,  7.575711647903165e-13, -2.204138902704629e-15,  6.209534967966377e-18,
 -1.706082898609843e-20,  4.588261746858971e-23, -1.211757382141664e-25,  3.143242397102777e-28, -8.029935561295767e-31,  1.185417184601190e-02, -5.790983156993900e-05,
  2.112564420711785e-07, -6.810124926451910e-10,  2.042264801824904e-12, -5.823920041642095e-15,  1.595586267296031e-17, -4.221966845686350e-20,  1.080073245296397e-22,
 -2.670937042688159e-25,  6.350245605075159e-28, -1.444465830218065e-30,  2.322710631603468e-02, -1.130914098343447e-04,  4.094628968762773e-07, -1.302301209556959e-09,
  3.822627180531377e-12, -1.055790158335701e-14,  2.762088831171523e-17, -6.843228855951796e-20,  1.592364041428776e-22, -3.420179988561375e-25,  6.478103783934803e-28,
 -9.581450550684983e-31,  3.838000480234061e-02, -1.860346003701493e-04,  6.667256327012091e-07, -2.081699643284407e-09,  5.929163542056358e-12, -1.562905933582241e-14,
  3.805932771771646e-17, -8.421885377122108e-20,  1.614641405997961e-22, -2.311845223439449e-25,  4.453472319009111e-29,  1.356176556951524e-30,  5.730296307752004e-02,
 -2.761885954032160e-04,  9.770293102703597e-07, -2.978222086732178e-09,  8.146870459541099e-12, -2.009692318432050e-14,  4.372334983639376e-17, -7.795475937412907e-20,
  8.232547146192239e-23,  1.353461897056885e-25, -1.244597312136083e-27,  5.147965595532662e-30,  7.998300747919769e-02, -3.828537375227891e-04,  1.332853353363531e-06,
 -3.941951076399639e-09,  1.022489103693249e-11, -2.293769974510846e-14,  4.117262158882045e-17, -4.055001999624945e-20, -9.283944261403606e-23,  7.371433144726481e-25,
 -2.907842079584961e-27,  8.690205255119754e-30,  1.064036771658947e-01, -5.051740272154068e-04,  1.725178066870034e-06, -4.915010010629835e-09,  1.188884504756000e-11,
 -2.314165718896034e-14,  2.765358654258593e-17,  3.180271702260717e-20, -3.506165113098639e-22,  1.435169032923038e-24, -4.226540351101768e-27,  9.188678417078868e-30,
  1.365444998552848e-01, -6.421280911094433e-04,  2.143499588474895e-06, -5.832827788414572e-09,  1.285595086323595e-11, -1.982506961917409e-14,  1.703509515864160e-18,
  1.352140127791478e-19, -6.433988760962836e-22,  1.974394572551809e-24, -4.219451570917194e-27,  3.841490712237958e-30,  1.703803474701816e-01, -7.925186166958663e-04,
  2.575858556804790e-06, -6.625749681065473e-09,  1.285301203523977e-11, -1.235257958249964e-14, -3.627897858778924e-17,  2.564883218600176e-19, -8.901818700774361e-22,
  2.027475885561582e-24, -1.970985391709024e-27, -8.512151970091124e-30,  2.078806549635842e-01, -9.549602879566011e-04,  3.008888833705046e-06, -7.221057425387635e-09,
  1.163724720293950e-11, -4.638713142134650e-16, -8.357039192791686e-17,  3.728334851701559e-19, -9.865210786878616e-22,  1.282739308324332e-24,  2.900601418655124e-27,
 -2.565742687175769e-29,  2.490084820136423e-01, -1.127866302950663e-03,  3.427894396319106e-06, -7.545468731553757e-09,  9.019777389300571e-12,  1.560403621547577e-14,
 -1.348551191051685e-16,  4.533983594659731e-19, -8.248972622363611e-22, -4.312600467903729e-25,  9.751888648260987e-27, -4.100755115376017e-29,  2.937193932106329e-01,
 -1.309433625868261e-03,  3.816964670978934e-06, -7.528190425128315e-09,  4.891323732662233e-12,  3.501081956685576e-14, -1.822571125572918e-16,  4.630642603153594e-19,
 -3.249646936038324e-22, -3.007092626924476e-24,  1.659054505112318e-26, -4.432624398975714e-29,  3.419601277506799e-01, -1.497627231598690e-03,  4.159141160406827e-06,
 -7.104597773371133e-09, -7.507205915160440e-13,  5.623903194494532e-14, -2.157807871697481e-16,  3.687122174851564e-19,  5.294933940767344e-22, -5.945158313320134e-24,
  2.015956432100480e-26, -2.495721629074267e-29,  3.936670244789325e-01, -1.690163752737094e-03,  4.436651237146513e-06, -6.220601384812111e-09, -7.775234775118829e-12,
  7.707257654512657e-14, -2.242664285789289e-16,  1.478164745769830e-19,  1.653599749351819e-21, -8.320694861795881e-24,  1.665802023431067e-26,  2.238025238452114e-29,
  4.487641624068875e-01, -1.884495153279436e-03,  4.631228405484695e-06, -4.837736880506982e-09, -1.589247857633580e-11,  9.465186604704630e-14, -1.969386770068267e-16,
 -2.013707959599694e-19,  2.835183413568977e-21, -8.893589140625488e-24,  3.206924063433345e-27,  9.053128771775597e-29,  5.071611706600117e-01, -2.077793350815546e-03,
  4.724542040982365e-06, -2.938963502547402e-09, -2.463450157631465e-11,  1.056332996937956e-13, -1.255655749972962e-16, -6.496029311708091e-19,  3.733928482465177e-21,
 -6.413168816681523e-24, -2.010154332180835e-26,  1.547131416881875e-28,  5.687506554146847e-01, -2.266937116083111e-03,  4.698763305498164e-06, -5.350753385875451e-10,
 -3.334521932186621e-11,  1.064812636672361e-13, -7.135114150239409e-18, -1.128981489330641e-18,  3.922393109888113e-21, -1.295499801617311e-25, -4.816283268687114e-26,
  1.739871525378226e-28,  6.334051851803799e-01, -2.448503127412811e-03,  4.537297040698237e-06,  2.328500827160230e-09, -4.118594162608932e-11,  9.391616157241638e-14,
  1.532188501600113e-16, -1.531543188659369e-18,  2.982906468288607e-21,  9.559146047418482e-24, -6.993355245390100e-26,  1.043960359855122e-28,  7.009737705070920e-01,
 -2.618763785331313e-03,  4.225710975492962e-06,  5.564940422767716e-09, -4.716359829111606e-11,  6.552821056773300e-14,  3.395575357175268e-16, -1.718592357231495e-18,
  6.638867436186596e-22,  2.052030882530806e-23, -7.010619564397539e-26, -7.435732727087208e-29,  7.712777710510080e-01, -2.773695339712319e-03,  3.752891915729291e-06,
  9.039982963693752e-09, -5.019008136531094e-11,  2.053890051840525e-14,  5.235717650675956e-16, -1.545195781498470e-18, -2.922923984066003e-21,  2.870502702494178e-23,
 -3.469875670822370e-26, -3.249606270550818e-28,  8.441061638049598e-01, -2.909001085441120e-03,  3.112451173344443e-06,  1.256768582298950e-08, -4.918140579939370e-11,
 -3.935549825431060e-14,  6.652589778409345e-16, -9.023147961780153e-19, -7.118050675292451e-21,  2.881700232199455e-23,  3.941946188411148e-26, -5.303195126326158e-28,
  9.192101140747742e-01, -3.020155863872918e-03,  2.304384549186031e-06,  1.590950356541791e-08, -4.320377878739070e-11, -1.091955808106221e-13,  7.172041980742867e-16,
  2.259400611487350e-19, -1.064020712984999e-20,  1.620787615797200e-23,  1.338935721687506e-25, -5.140158880928214e-28,  9.962968097097760e-01, -3.102479848794979e-03,
  1.336960379099212e-06,  1.877876612891706e-08, -3.166866271424450e-11, -1.802576572787045e-13,  6.337051296688048e-16,  1.701452425161658e-18, -1.175499320801995e-20,
 -1.004275090840868e-23,  2.040123631140226e-25, -1.315203079946286e-28,  1.075022555246645e+00, -3.151251500975138e-03,  2.287555272482599e-07,  2.085315514146223e-08,
 -1.456854744499198e-11, -2.401766256852742e-13,  3.851855446036150e-16,  3.191848867401207e-18, -8.808666909325424e-21, -4.380086581565148e-23,  1.895264439347399e-25,
  5.760875262138289e-28,  1.154985184337580e+00, -3.161871406632842e-03, -9.893243222982955e-07,  2.179810671479920e-08,  7.272670644775744e-12, -2.741074826791932e-13,
 -2.352994876620797e-17,  4.187885700918983e-18, -1.140360728836929e-21, -7.048969006027701e-23,  4.841467648566059e-26,  1.252826744856801e-27,  1.235715946982372e+00,
 -3.130089998797336e-03, -2.272324593336975e-06,  2.130386739179832e-08,  3.198724078810500e-11, -2.673179702651742e-13, -5.356975061711252e-16,  4.119383395328221e-18,
  9.868339438379934e-21, -7.069518843293734e-23, -1.933379828272875e-25,  1.294932965056476e-27,  1.316671175836213e+00, -3.052312063558648e-03, -3.560267294526166e-06,
  1.913766992621822e-08,  5.657471516982231e-11, -2.093687838837779e-13, -1.034632976600976e-15,  2.590046201301019e-18,  2.022123618697346e-20, -3.079432222219214e-23,
 -4.090864526544305e-25,  2.646779702455560e-28,  1.397224247278155e+00, -2.925988126967075e-03, -4.778557954199409e-06,  1.520946894860738e-08,  7.705361571191610e-11,
 -9.945567282572409e-14, -1.357220042684934e-15, -3.103367020378358e-19,  2.411530761370632e-20,  4.202099727400914e-23, -4.107764335001934e-25, -1.475123681195505e-27,
  1.476658639391582e+00, -2.750095388473410e-03, -5.840594377325741e-06,  9.644160980637955e-09,  8.898007569200394e-11,  4.850503361854514e-14, -1.339639206798989e-15,
 -3.761594975076997e-18,  1.678106420722620e-20,  1.109097183905572e-22, -9.203328381871556e-26, -2.527806497663787e-27,  1.554163252179857e+00, -2.525696401466934e-03,
 -6.653497239347930e-06,  2.844940454690072e-09,  8.841449608441025e-11,  2.036875733600893e-13, -8.947524864748559e-16, -6.280946916924507e-18, -1.292270016290079e-21,
  1.225748246058703e-22,  3.966338789871266e-25, -1.428358119839927e-27,  1.628831575162197e+00, -2.256539792425218e-03, -7.127760942410003e-06, -4.477492533830635e-09,
  7.327667209870546e-11,  3.224836446055512e-13, -9.632245967338100e-17, -6.321987665407281e-18, -2.161719778911811e-20,  4.859328998711503e-23,  6.471424692776616e-25,
  1.428121808577749e-27,  1.699666705039050e+00, -1.949632793447818e-03, -7.191090125505282e-06, -1.134302771016851e-08,  4.477373649205044e-11,  3.614359280851453e-13,
  7.848428346191244e-16, -3.327742441988041e-18, -3.067316804585435e-20, -7.077055445740048e-23,  3.373245675480077e-25,  3.161982159987146e-27,  1.765594514205931e+00,
 -1.615672571684408e-03, -6.805552238425177e-06, -1.663920320254494e-08,  8.266393226011285e-12,  2.974745031484181e-13,  1.357900063336063e-15,  1.396515922031314e-18,
 -1.995011715572635e-20, -1.365953817468649e-22, -3.075805400482109e-25,  1.381474102442761e-27,  1.825487262149793e+00, -1.269181187264044e-03, -5.985387305850463e-06,
 -1.936829203881957e-08, -2.725637185658934e-11,  1.470229459764462e-13,  1.319328665518880e-15,  5.009346638974999e-18,  3.711504327948116e-21, -8.253331085343674e-23,
 -5.938278333997598e-25, -1.880886106228636e-27,  1.878199383219089e+00, -9.281655819775548e-04, -4.810684995311883e-06, -1.896928551656752e-08, -5.168226905698608e-11,
 -3.047067112159267e-14,  6.910871365009123e-16,  5.098944379235271e-18,  2.050068163396409e-20,  3.420859594374588e-23, -2.034368332120202e-25, -2.178799205074660e-27,
  1.922615845501797e+00, -6.131455658597269e-04, -3.430559282024777e-06, -1.561547854914245e-08, -5.791931278579522e-11, -1.563536662242645e-13, -1.182716716739053e-16,
  1.980918530173820e-18,  1.664897040498933e-20,  8.327628652968646e-23,  2.779055484529832e-25,  3.246099659349653e-28,  1.957711287364414e+00, -3.454849864860365e-04,
 -2.049840241874678e-06, -1.033824710831483e-08, -4.592795407885487e-11, -1.786340991618230e-13, -5.778340599801464e-16, -1.270187941988732e-18,  7.849899119891223e-22,
  3.032766065775254e-23,  2.244597229652154e-25,  1.180578867178480e-27,  1.982615509300813e+00, -1.451297727143551e-04, -8.969495090919322e-07, -4.842496366415588e-09,
 -2.396446288008382e-11, -1.106038029274068e-13, -4.778652914902207e-16, -1.920882931234658e-18, -7.046971093425048e-21, -2.248963898517063e-23, -5.367032017763226e-26,
 -1.763757874619085e-29,  1.996681465821870e+00, -2.804332076898143e-05, -1.773063190570061e-07, -9.933116889451338e-10, -5.196362280237349e-12, -2.597241690587557e-14,
 -1.254990848516968e-16, -5.901318466988562e-19, -2.710731289298627e-21, -1.218867015382088e-23, -5.369609673641879e-26, -2.317401633588630e-28,  4.651448519401335e-04,
 -2.257725640964872e-06,  8.217246656228912e-09, -2.657982951143893e-11,  8.057436721766223e-14, -2.344241510589880e-16,  6.627276233352436e-19, -1.834858711697197e-21,
  4.996310878086782e-24, -1.343646436848484e-26,  3.571637665824791e-29, -9.423248145152659e-32,  4.185974241167433e-03, -2.029662082547553e-05,  7.369674573070792e-08,
 -2.373855929636763e-10,  7.149408218286040e-13, -2.060680536182057e-15,  5.751748274223782e-18, -1.566002331317478e-20,  4.173834167251759e-23, -1.092818649672611e-25,
  2.810297072759903e-28, -7.123117725795052e-31,  1.162586163858228e-02, -5.625192185613817e-05,  2.032765721091998e-07, -6.492476715945341e-10,  1.929522035193062e-12,
 -5.454783303970923e-15,  1.482068797075417e-17, -3.891249941343869e-20,  9.883423981534800e-23, -2.429214382375825e-25,  5.746121561609882e-28, -1.303929983519600e-30,
  2.278119455517707e-02, -1.098771931799992e-04,  3.941954012710746e-07, -1.242793062543500e-09,  3.617945885805245e-12, -9.917428914115149e-15,  2.577430631944031e-17,
 -6.352880697490719e-20,  1.473800788663780e-22, -3.169420956132090e-25,  6.061661870676727e-28, -9.332873877929578e-31,  3.764637804768987e-02, -1.807991275966037e-04,
  6.423042800996433e-07, -1.989284838099512e-09,  5.625528570494348e-12, -1.474335682617979e-14,  3.577228767505405e-17, -7.918470883426458e-20,  1.531870659114521e-22,
 -2.283052480000187e-25,  9.717181049280478e-29,  1.046104083401217e-30,  5.621361790857908e-02, -2.685131298130128e-04,  9.420596634970704e-07, -2.851031388559999e-09,
  7.755250354808036e-12, -1.907345372913751e-14,  4.157816487506652e-17, -7.525156374157756e-20,  8.635434965776154e-23,  8.986735148766952e-26, -1.034729447772363e-27,
  4.408422557182431e-30,  7.847262247530658e-02, -3.723773776956152e-04,  1.286516563948946e-06, -3.781969554439049e-09,  9.775924869970758e-12, -2.196349360517230e-14,
  3.999946257774601e-17, -4.311800544750061e-20, -6.830638961529871e-23,  6.281914604382646e-25, -2.546664442435445e-27,  7.740906762576412e-30,  1.044102148845796e-01,
 -4.916053243347290e-04,  1.667324119955701e-06, -4.728454814190015e-09,  1.143271453918864e-11, -2.246850663601207e-14,  2.839452546228948e-17,  2.137779852286276e-20,
 -3.018975360632591e-22,  1.274034897007500e-24, -3.834172170485686e-27,  8.639094695112086e-30,  1.340098450863322e-01, -6.252566034303033e-04,  2.074726752364705e-06,
 -5.630301118155287e-09,  1.246015322916243e-11, -1.974101549273280e-14,  5.211714345146199e-18,  1.157302702467501e-19, -5.753158685796193e-22,  1.809220714100857e-24,
 -4.034202825795727e-27,  4.534189914425294e-30,  1.672509880937606e-01, -7.722263072782316e-04,  2.497575150376696e-06, -6.422122824307537e-09,  1.259781885267723e-11,
 -1.314024700939618e-14, -2.948524684203542e-17,  2.291544277894212e-19, -8.186948113348869e-22,  1.941940298107655e-24, -2.287030431818977e-27, -5.934876189493629e-30,
  2.041084116996354e-01, -9.312326241078700e-04,  2.923352670720329e-06, -7.035041179592404e-09,  1.160874021664111e-11, -2.347812513277921e-15, -7.356592635498315e-17,
  3.420239314631533e-19, -9.385142021189793e-22,  1.377484422012741e-24,  1.867885584000087e-27, -2.136909650836215e-29,  2.445512931500088e-01, -1.100802854302921e-03,
  3.338224410869977e-06, -7.398827236075892e-09,  9.300505725474487e-12,  1.251686063748154e-14, -1.225313362986392e-16,  4.268250762461976e-19, -8.338240003340990e-22,
 -7.594303917603140e-26,  8.046605240492245e-27, -3.652717450322251e-29,  2.885421599459347e-01, -1.279257879506621e-03,  3.727118302234229e-06, -7.444560791555752e-09,
  5.548842165692547e-12,  3.079096784183888e-14, -1.694522806570694e-16,  4.510575959038617e-19, -4.217406969408371e-22, -2.382008875253727e-24,  1.467656803951676e-26,
 -4.255540549154050e-29,  3.360356249555658e-01, -1.464695243531767e-03,  4.073850133921074e-06, -7.107888893762077e-09,  3.231179738374515e-13,  5.118590275570217e-14,
 -2.052507105255708e-16,  3.823849918124916e-19,  3.297048491604660e-22, -5.162149747801847e-24,  1.895913549628782e-26, -2.931832418283925e-29,  3.869768802884522e-01,
 -1.654971131312510e-03,  4.361307522685807e-06, -6.332964461099363e-09, -6.287242194469191e-12,  7.174555587287892e-14, -2.194308593451839e-16,  1.960692382503270e-19,
  1.366250411489908e-21, -7.638535793399347e-24,  1.735873520546794e-26,  9.856498248975122e-30,  4.412999078651127e-01, -1.847681717966405e-03,  4.571711518535610e-06,
 -5.077130783578422e-09, -1.404711151449080e-11,  8.986763447007982e-14, -2.013548092655884e-16, -1.157354250749544e-19,  2.518231596793444e-21, -8.691288432490778e-24,
  6.771257124750888e-27,  7.174597176405699e-29,  4.989253573188432e-01, -2.040144625851140e-03,  4.686978738070503e-06, -3.316383881416584e-09, -2.255337576464762e-11,
  1.024147426427534e-13, -1.421173959100579e-16, -5.339533716799957e-19,  3.490176429332478e-21, -7.086091033196552e-24, -1.367058406125426e-26,  1.374251319894655e-28,
  5.597580339061988e-01, -2.229381601416286e-03,  4.689211479122345e-06, -1.051581642650835e-09, -3.121979376975927e-11,  1.059448492884910e-13, -3.699262910360920e-17,
 -1.003896393374279e-18,  3.884893578756776e-21, -1.903409331544280e-24, -4.055085888851430e-26,  1.711605705481648e-28,  6.236839307637969e-01, -2.412104041644593e-03,
  4.561347792728270e-06,  1.684737762024317e-09, -3.927426238622170e-11,  9.708990055935645e-14,  1.117199223591155e-16, -1.431114532926317e-18,  3.277863332693353e-21,
  6.861541425447199e-24, -6.476723222418952e-26,  1.290439128201346e-28,  6.905667317008685e-01, -2.584703706487222e-03,  4.288007193458871e-06,  4.821233837568395e-09,
 -4.577542280630155e-11,  7.310320810544358e-14,  2.918415361803198e-16, -1.686074887535006e-18,  1.351506780657568e-21,  1.766742354201169e-23, -7.213543392546109e-26,
 -1.909267549635130e-29,  7.602437037751820e-01, -2.743251901325292e-03,  3.856569190099126e-06,  8.240895735224761e-09, -4.965720124412188e-11,  3.257581240067943e-14,
  4.791500988935675e-16, -1.622489904004640e-18, -1.917790638857230e-21,  2.705105154928990e-23, -4.750414991538258e-26, -2.569293477206266e-28,  8.325208948686086e-01,
 -2.883511658706006e-03,  3.258518799129884e-06,  1.177534490745083e-08, -4.981102897817978e-11, -2.371723109954471e-14,  6.369631426017680e-16, -1.113234562812834e-18,
 -6.057789776284122e-21,  2.993724405593519e-23,  1.687191362930683e-26, -4.920354667911097e-28,  9.071675530929251e-01, -3.000969042629356e-03,  2.491081993821249e-06,
  1.520170851216290e-08, -4.521524538934828e-11, -9.194466420345031e-14,  7.188585327272955e-16, -1.042223296463382e-19, -9.965908462594696e-21,  2.109655105615448e-23,
  1.102238177718054e-25, -5.574663736076207e-28,  9.839096963517419e-01, -3.090891667409847e-03,  1.559149130151342e-06,  1.824406808117996e-08, -3.511808862548189e-11,
 -1.645198302908404e-13,  6.760363591620099e-16,  1.321068961814074e-18, -1.197144896428856e-20, -2.042847423641707e-24,  1.949095911412485e-25, -2.787829007582703e-28,
  1.062422788099627e+00, -3.148424829611977e-03,  4.774380004490731e-07,  2.058216219939118e-08, -1.927256691959704e-11, -2.298929670504640e-13,  4.703846819978902e-16,
  2.886251583111477e-18, -1.024344380680698e-20, -3.576943457576633e-23,  2.106237298607600e-25,  3.811077390788265e-28,  1.142323528421386e+00, -3.168738130567691e-03,
 -7.272297669764149e-07,  2.187062132944190e-08,  1.794340724349132e-12, -2.732715241598822e-13,  9.284176157426289e-17,  4.111272291591917e-18, -3.630061990954195e-21,
 -6.747511690997494e-23,  1.016089484017028e-25,  1.156137691763401e-27,  1.223160860629529e+00, -3.147237720044276e-03, -2.013785993534257e-06,  2.177223364752434e-08,
  2.652183099805714e-11, -2.787573158263777e-13, -4.163263376729262e-16,  4.393071846393345e-18,  7.198312980022913e-21, -7.723823285571877e-23, -1.326726755122424e-25,
  1.451519546779843e-27,  1.304406439062410e+00, -3.079860532314125e-03, -3.325326565934068e-06,  2.000804316064348e-08,  5.214527494119131e-11, -2.332577363667066e-13,
 -9.532415772730565e-16,  3.216259968668434e-18,  1.882198588054644e-20, -4.680621763188443e-23, -3.885833616031151e-25,  6.658808809209555e-28,  1.385445023137444e+00,
 -2.963465740186892e-03, -4.588718557608355e-06,  1.642464270861390e-08,  7.473852177715881e-11, -1.320447446620100e-13, -1.354901711971700e-15,  4.822646931772018e-19,
  2.531752333233815e-20,  2.438778113352348e-23, -4.683358759743481e-25, -1.125442266881256e-27,  1.465565575534931e+00, -2.796332958979320e-03, -5.716296098721506e-06,
  1.107382143584317e-08,  8.962046080741536e-11,  1.515413553027892e-14, -1.436852045668787e-15, -3.161647808894938e-18,  2.068032411175934e-20,  1.049594317010010e-22,
 -2.063547363385368e-25, -2.647384668508365e-27,  1.543954261183080e+00, -2.578763471769209e-03, -6.610739671369923e-06,  4.290935821117507e-09,  9.225925530777136e-11,
  1.801026262257670e-13, -1.070513498213628e-15, -6.248768524282006e-18,  3.389156899172974e-21,  1.369967594939626e-22,  3.198399921149993e-25, -2.062402423215948e-27,
  1.619691060311086e+00, -2.313756379296652e-03, -7.174244027739333e-06, -3.253655570775363e-09,  7.968849286939293e-11,  3.179713478489900e-13, -2.827233412184726e-16,
 -6.980637571674864e-18, -1.938800893108949e-20,  7.559536335122041e-23,  6.991779110697970e-25,  9.086485665275494e-28,  1.691752272278751e+00, -2.007693245459313e-03,
 -7.322666407864146e-06, -1.056782844750746e-08,  5.218268716545397e-11,  3.790408663187754e-13,  6.775616278849294e-16, -4.347165592832858e-18, -3.294363371086880e-20,
 -5.440101575372147e-23,  4.832641382087167e-25,  3.451077999892441e-27,  1.759021674288934e+00, -1.670912959160671e-03, -7.004227001090877e-06, -1.645756235078389e-08,
  1.454455419423564e-11,  3.304565689713257e-13,  1.387309424898961e-15,  6.771904790594505e-19, -2.507239136112492e-20, -1.474650174606380e-22, -2.302941100654116e-25,
  2.151058348724832e-27,  1.820313289056205e+00, -1.318001142572010e-03, -6.220320683221564e-06, -1.977910201895319e-08, -2.398785575837143e-11,  1.803804819549987e-13,
  1.460772842247044e-15,  5.075831257757497e-18,  2.931050047715156e-22, -1.079064036439406e-22, -6.736757592831225e-25, -1.722105925144100e-27,  1.874408288366175e+00,
 -9.675756854360964e-04, -5.043294974956108e-06, -1.980012606160627e-08, -5.211386943527015e-11, -1.209612711916008e-14,  8.432146924860358e-16,  5.772902975030343e-18,
  2.156118964060779e-20,  2.399662172305149e-23, -3.111613110860598e-25, -2.727698618246856e-27,  1.920107164957984e+00, -6.413555757007811e-04, -3.623608917427206e-06,
 -1.656733838887725e-08, -6.106995541594525e-11, -1.584635476034624e-13, -5.488108130615163e-17,  2.563822757712488e-18,  1.984993561259031e-20,  9.462020075052625e-23,
  2.876777734894623e-25,  1.027567592168561e-28,  1.956295746267263e+00, -3.623927131647633e-04, -2.178428662930274e-06, -1.110244135262924e-08, -4.964217783795806e-11,
 -1.929249878607864e-13, -6.128705500796156e-16, -1.225760863388168e-18,  2.051562821057261e-21,  4.041657117574366e-23,  2.818247860965866e-25,  1.433088785642048e-27,
  1.982020261558870e+00, -1.525444992055214e-04, -9.574351220291520e-07, -5.244266272284896e-09, -2.629571809344864e-11, -1.227442313671588e-13, -5.349317293915044e-16,
 -2.159755078285362e-18, -7.895302315949313e-21, -2.463788821025931e-23, -5.335360026326958e-26,  3.583279031027317e-29,  1.996566378097175e+00, -2.951090426297575e-05,
 -1.897425977932076e-07, -1.080778522686930e-09, -5.747321252009917e-12, -2.919290202121231e-14, -1.433062244154641e-16, -6.843312600608539e-19, -3.190773664449565e-21,
 -1.455506192517058e-23, -6.500502129383813e-26, -2.841646102572131e-28,  4.562434357334702e-04, -2.193241934099209e-06,  7.905871873808140e-09, -2.532730045174859e-11,
  7.604086887621107e-14, -2.191175712555219e-16,  6.135191283944334e-19, -1.682448343421031e-21,  4.537345502570853e-24, -1.208737369307098e-26,  3.181859320284059e-29,
 -8.318523567887872e-32,  4.105949134960322e-03, -1.971824998842348e-05,  7.091541677935812e-08, -2.262688948343549e-10,  6.750728786159205e-13, -1.927752978666712e-15,
  5.331390085093377e-18, -1.438523302428410e-20,  3.799920450958546e-23, -9.864328302119940e-26,  2.514804190840485e-28, -6.325150843984502e-31,  1.140405776364946e-02,
 -5.465635650503069e-05,  1.956672956141128e-07, -6.192291223021499e-10,  1.823896893971183e-12, -5.111811932541631e-15,  1.377413202383989e-17, -3.588540039426534e-20,
  9.048931207489766e-23, -2.210461424407454e-25,  5.200757870060845e-28, -1.177161602343460e-30,  2.234789982629280e-02, -1.067823148146479e-04,  3.796227690634547e-07,
 -1.186459702641108e-09,  3.425641767808963e-12, -9.319668692661171e-15,  2.405984360963478e-17, -5.899060328296831e-20,  1.363967884147756e-22, -2.935076506890720e-25,
  5.657926511888057e-28, -9.008423589265422e-31,  3.693330935117189e-02, -1.757546709948061e-04,  6.189633312358805e-07, -1.901589414970331e-09,  5.339070022730960e-12,
 -1.391088162510199e-14,  3.362251389133572e-17, -7.441339114846977e-20,  1.450484078114886e-22, -2.235767947375114e-25,  1.373862880447952e-28,  7.899618160173305e-31,
  5.515442460578979e-02, -2.611114212265238e-04,  9.085793760712774e-07, -2.729945628294201e-09,  7.383590994713653e-12, -1.810054732729627e-14,  3.951023938861962e-17,
 -7.244408151473761e-20,  8.888952079179298e-23,  5.216172754268507e-26, -8.552338466937267e-28,  3.765386027514735e-30,  7.700341351022584e-02, -3.622641537187619e-04,
  1.242057090003433e-06, -3.629017170863458e-09,  9.346155886905189e-12, -2.101822093957603e-14,  3.876482054765014e-17, -4.496098139748815e-20, -4.744539653890145e-23,
  5.328760348210552e-25, -2.225414131713331e-27,  6.874860809585026e-30,  1.024701157560338e-01, -4.784906214184491e-04,  1.611665494015242e-06, -4.549089131754666e-09,
  1.099020211160757e-11, -2.178090540664566e-14,  2.886454202552115e-17,  1.242205506136110e-20, -2.587028154732978e-22,  1.128100862265697e-24, -3.466766419234937e-27,
  8.057683173337183e-30,  1.315415911429637e-01, -6.089256846602482e-04,  2.008346309522834e-06, -5.434089367807722e-09,  1.206683570685939e-11, -1.957907024154711e-14,
  8.203992168605165e-18,  9.833152894154398e-20, -5.130390918802244e-22,  1.651990665303570e-24, -3.824038308469178e-27,  4.982738538979386e-30,  1.642015607966467e-01,
 -7.525505615764140e-04,  2.421710275820498e-06, -6.222696481837970e-09,  1.232844214749983e-11, -1.377379349275000e-14, -2.342531699879875e-17,  2.040566245522872e-19,
 -7.504885430544345e-22,  1.845890547968974e-24, -2.500052111273556e-27, -3.818806401256704e-30,  2.004297246350913e-01, -9.081803313173950e-04,  2.840044764078324e-06,
 -6.849769720492873e-09,  1.154488651154834e-11, -4.001822080236275e-15, -6.440216319194010e-17,  3.127975584896484e-19, -8.877959518571920e-22,  1.434544638487840e-24,
  1.012683803951950e-27, -1.758488036530364e-29,  2.402009346076958e-01, -1.074449654978240e-03,  3.250339087114330e-06, -7.248172218510520e-09,  9.522387871404462e-12,
  9.716506302690844e-15, -1.109537732633990e-16,  4.001580182021119e-19, -8.311400252288095e-22,  2.150596455115710e-25,  6.534886307175479e-27, -3.222292038433709e-29,
  2.834841987248018e-01, -1.249796717333797e-03,  3.638335879520535e-06, -7.351069462168083e-09,  6.125007770536938e-12,  2.687406816966461e-14, -1.570237124606502e-16,
  4.362995359511610e-19, -4.973711913750479e-22, -1.831733659949007e-24,  1.285447125089570e-26, -4.018626438368361e-29,  3.302414856085111e-01, -1.432445457157369e-03,
  3.988619412231772e-06, -7.094793249060093e-09,  1.298448559295905e-12,  4.638939272864764e-14, -1.944231319235124e-16,  3.901059329920549e-19,  1.571985978336320e-22,
 -4.430501772269656e-24,  1.760323819743785e-26, -3.207226487994330e-29,  3.804262931054131e-01, -1.620386256351189e-03,  4.284754804399984e-06, -6.422365232856696e-09,
 -4.904525326453401e-12,  6.654978559443801e-14, -2.133692208618996e-16,  2.355241191698442e-19,  1.103836700258371e-21, -6.938691782529571e-24,  1.755873143888600e-26,
 -4.074648839519499e-31,  4.339819372994533e-01, -1.811355414021955e-03,  4.509495885919137e-06, -5.287769254624483e-09, -1.229830062609022e-11,  8.500505077936333e-14,
 -2.035138637440713e-16, -4.010005839507823e-20,  2.210934130353669e-21, -8.362458187402819e-24,  9.545896525313344e-27,  5.467423686837730e-29,  4.908395099732693e-01,
 -2.002813962449027e-03,  4.645083987497098e-06, -3.661041715144990e-09, -2.054033588170017e-11,  9.883689808812716e-14, -1.555435266718873e-16, -4.264433383892816e-19,
  3.226643714544009e-21, -7.517243576050008e-24, -8.017910435170545e-27,  1.194685020764274e-28,  5.509154431874560e-01, -2.191926716609715e-03,  4.673665141045370e-06,
 -1.534204710745063e-09, -2.911197955937313e-11,  1.047336906324608e-13, -6.337374416416621e-17, -8.809745915404528e-19,  3.788972574294406e-21, -3.376708646524095e-24,
 -3.316816342871036e-26,  1.637565514434785e-28,  6.141086093163344e-01, -2.375542926033183e-03,  4.577858831216024e-06,  1.072016222497078e-09, -3.730883520037099e-11,
  9.930238761405740e-14,  7.315083407630662e-17, -1.322759219179767e-18,  3.479665292801267e-21,  4.389845616867805e-24, -5.869704771086235e-26,  1.456035007589569e-28,
  6.802968739755408e-01, -2.550180567120302e-03,  4.341516996145792e-06,  4.100888191148953e-09, -4.424711301512655e-11,  7.954633861500856e-14,  2.453285549662804e-16,
 -1.633207880316708e-18,  1.935527718056579e-21,  1.477977023895259e-23, -7.190133011945911e-26,  2.839106268245364e-29,  7.493330085869343e-01, -2.712017238070504e-03,
  3.950716329088922e-06,  7.452201897555032e-09, -4.889440085017985e-11,  4.352420962473810e-14,  4.330048748658689e-16, -1.668665442909938e-18, -9.806977732871194e-22,
  2.494480757339583e-23, -5.731560748445383e-26, -1.893598864368847e-28,  8.210398602925508e-01, -2.856891871065303e-03,  3.395028086518931e-06,  1.097539330746415e-08,
 -5.013513623046202e-11, -8.825068001877757e-15,  6.032413928720382e-16, -1.289751235171472e-18, -4.972989457179819e-21,  3.019349958302372e-23, -3.682434355008715e-27,
 -4.403784441046170e-28,  8.952046720249069e-01, -2.980323136890195e-03,  2.669104181138321e-06,  1.446448919992508e-08, -4.688203215985468e-11, -7.476238386403467e-14,
  7.115955416085071e-16, -4.101772886140460e-19, -9.133049424587357e-21,  2.500798229859418e-23,  8.522131511390188e-26, -5.748605243753564e-28,  9.715724488096024e-01,
 -3.077552555504333e-03,  1.774600915595023e-06,  1.765674883915291e-08, -3.824346413760991e-11, -1.478943820532481e-13,  7.076626024422832e-16,  9.382842968334342e-19,
 -1.190796468153367e-20,  5.469914112659959e-24,  1.798264378222267e-25, -4.025735348241677e-28,  1.049838284177325e+00, -3.143622969279568e-03,  7.224241114050088e-07,
  2.023765843163145e-08, -2.375118418273847e-11, -2.176721253969279e-13,  5.464288447057378e-16,  2.539513477418338e-18, -1.137598941986695e-20, -2.706803396374527e-23,
  2.229867168386054e-25,  1.808766010307940e-28,  1.129638602532681e+00, -3.173506105211917e-03, -4.647899150441406e-07,  2.185576727752808e-08, -3.639560623677445e-12,
 -2.696772747222513e-13,  2.059721001745868e-16,  3.957126241521996e-18, -5.974105278299740e-21, -6.243325716358796e-23,  1.494128489848113e-25,  1.009222399447812e-27,
  1.210541353484778e+00, -3.162296153868253e-03, -1.750158717051636e-06,  2.215148114051589e-08,  2.085685334357862e-11, -2.872496494319597e-13, -2.905200641986195e-16,
  4.578031262812642e-18,  4.337892099351471e-21, -8.123721875430892e-23, -6.665208686670515e-26,  1.537195066992292e-27,  1.292035331865734e+00, -3.105488937725811e-03,
 -3.080381991647007e-06,  2.080383511716478e-08,  4.725898146555312e-11, -2.549884732386150e-13, -8.550283855567502e-16,  3.788667461953159e-18,  1.686528755811817e-20,
 -6.164927301582453e-23, -3.507961515965011e-25,  1.046263799682724e-27,  1.373519017373172e+00, -2.999366989077045e-03, -4.384540803121016e-06,  1.759757135338875e-08,
  7.177402034761502e-11, -1.643081169429652e-13, -1.329950366214902e-15,  1.302767629881492e-18,  2.584745581636075e-20,  4.786829010032735e-24, -5.085285034565898e-25,
 -6.887388817583935e-28,  1.454289659000980e+00, -2.841507396857371e-03, -5.574802823693178e-06,  1.250827110597988e-08,  8.957192947374381e-11, -2.031441841512636e-14,
 -1.515558038816545e-15, -2.441242207397724e-18,  2.428215148303272e-20,  9.437059274337165e-23, -3.229453446920665e-25, -2.627656835855819e-27,  1.533533797349080e+00,
 -2.631418065310950e-03, -6.550277369005825e-06,  5.794445168036079e-09,  9.559029536693043e-11,  1.523276119754615e-13, -1.243202726461650e-15, -6.059124730938277e-18,
  8.527780753387898e-21,  1.477920614376094e-22,  2.154597752169652e-25, -2.674713615077402e-27,  1.610321030845802e+00, -2.371284351129624e-03, -7.205429316949519e-06,
 -1.928200623309929e-09,  8.596388319455321e-11,  3.087730957098257e-13, -4.864190181531040e-16, -7.552046271497620e-18, -1.615525019898490e-20,  1.041710454036156e-22,
  7.245763098015086e-25,  2.182593836206476e-28,  1.683603554284146e+00, -2.066767057128624e-03, -7.444217900559796e-06, -9.671418923890474e-09,  5.991563709096258e-11,
  3.937209047781568e-13,  5.408161613592779e-16, -5.428665619776858e-18, -3.451701799487731e-20, -3.198024884241362e-23,  6.387786599074080e-25,  3.588091044168422e-27,
  1.752224710307716e+00, -1.727732267971062e-03, -7.200097497216849e-06, -1.617016262881278e-08,  2.148768611929533e-11,  3.638839054210109e-13,  1.394228716174147e-15,
 -2.116437447183105e-19, -3.052186022714665e-20, -1.545327535627746e-22, -1.167069926391373e-25,  3.027259763944287e-27,  1.814940247309260e+00, -1.368719342837643e-03,
 -6.459847388204864e-06, -2.013209369302839e-08, -2.001815909467844e-11,  2.171417904184467e-13,  1.602405525067618e-15,  5.017712408975204e-18, -4.094076211736401e-21,
 -1.362829006016343e-22, -7.426547226255009e-25, -1.378835306336802e-27,  1.870455768068623e+00, -1.008886637223007e-03, -5.285903687304281e-06, -2.063472743089752e-08,
 -5.213992151678979e-11,  1.015939249958414e-14,  1.014626721775890e-15,  6.474035847210685e-18,  2.217053235087876e-20,  8.976190789922782e-24, -4.442327516796760e-25,
 -3.327616012564747e-27,  1.917482482025929e+00, -6.711565315137191e-04, -3.828384441684409e-06, -1.756985766804002e-08, -6.424619847610405e-11, -1.588442447693684e-13,
  2.632667113796412e-17,  3.255746421399894e-18,  2.346367459174113e-20,  1.061274077832508e-22,  2.852115946157455e-25, -2.370770322993395e-28,  1.954810457314626e+00,
 -3.803668608210544e-04, -2.316553559015497e-06, -1.192839489706260e-08, -5.365050221479291e-11, -2.080368929150696e-13, -6.460377696445215e-16, -1.134526988802307e-18,
  3.725417422247396e-21,  5.303332846409124e-23,  3.511252132394501e-25,  1.723054798850893e-27,  1.981394355686488e+00, -1.604630486055207e-04, -1.022974034417082e-06,
 -5.685355474918643e-09, -2.888403573887819e-11, -1.363376541737818e-13, -5.990782199311537e-16, -2.427003737455865e-18, -8.820109102152702e-21, -2.671900303503370e-23,
 -5.011432064787944e-26,  1.167082540933613e-28,  1.996445214192347e+00, -3.108233130630175e-05, -2.032835738608918e-07, -1.177600127153223e-09, -6.367186600655007e-12,
 -3.287422727471893e-14, -1.639794630389421e-16, -7.953470951219863e-19, -3.764736238356023e-21, -1.742347139914792e-23, -7.888930515288147e-26, -3.492757172219951e-28,
  4.475950658392539e-04, -2.131190314353406e-06,  7.609102122642716e-09, -2.414492105897773e-11,  7.180202936820241e-14, -2.049424012422930e-16,  5.683795994023521e-19,
 -1.543976956670854e-21,  4.124254251723417e-24, -1.088489610528795e-26,  2.837560677918412e-29, -7.352733163373160e-32,  4.028193840659939e-03, -1.916160682700468e-05,
  6.826374687219074e-08, -2.157693516371091e-10,  6.377654234080676e-13, -1.804498862980661e-15,  4.945106879129024e-18, -1.322418872945638e-20,  3.462260043399390e-23,
 -8.911934798429044e-26,  2.252279841624727e-28, -5.622468145544295e-31,  1.118851664322316e-02, -5.312025269296532e-05,  1.884083237148841e-07, -5.908470362745736e-10,
  1.724886719295063e-12, -4.792970260953257e-15,  1.280871177132388e-17, -3.311314923061229e-20,  8.289393852143768e-23, -2.012445203119891e-25,  4.708372025153616e-28,
 -1.062926202982341e-30,  2.192675565742505e-02, -1.038013649181201e-04,  3.657080633755407e-07, -1.133109760151554e-09,  3.244891473849206e-12, -8.761569686929283e-15,
  2.246765471082130e-17, -5.479067543354925e-20,  1.262284285598259e-22, -2.716579278046330e-25,  5.269673303993322e-28, -8.632755668286196e-31,  3.624005158237695e-02,
 -1.708928092729607e-04,  5.966477679049123e-07, -1.818346890982611e-09,  5.068755703240465e-12, -1.312842709362208e-14,  3.160271856426422e-17, -6.989949767828492e-20,
  1.371063399284815e-22, -2.174512691489562e-25,  1.673547197813068e-28,  5.790516451654991e-31,  5.412431151447605e-02, -2.539718424528628e-04,  8.765170719268039e-07,
 -2.614653422463880e-09,  7.030899870140039e-12, -1.717631986196179e-14,  3.752186466493582e-17, -6.957586032870792e-20,  9.018994368841881e-23,  2.109583154707023e-26,
 -7.021253479338454e-28,  3.207177857255629e-30,  7.557395755070030e-02, -3.524993792899518e-04,  1.199392405458524e-06, -3.482791473591375e-09,  8.934992239907813e-12,
 -2.010312657299409e-14,  3.748742232571040e-17, -4.618890030879554e-20, -2.979342514066074e-23,  4.496722752805870e-25, -1.940499951838725e-27,  6.088595720973806e-30,
  1.005815983643876e-01, -4.658126972715924e-04,  1.558117230646795e-06, -4.376693101572102e-09,  1.056153498795162e-11, -2.108488147164297e-14,  2.910237914226256e-17,
  4.767270671881111e-21, -2.205033999657314e-22,  9.963465370202857e-25, -3.125276365551947e-27,  7.463882735684423e-30,  1.291376135490047e-01, -5.931164979805761e-04,
  1.944282768283272e-06, -5.244141046297476e-09,  1.167743691776099e-11, -1.935093627805873e-14,  1.073616607521667e-17,  8.283673735356468e-20, -4.562670815512836e-22,
  1.503501122758444e-24, -3.598600554933971e-27,  5.235780014696421e-30,  1.612296376961022e-01, -7.334722365898907e-04,  2.348212264024448e-06, -6.027673866475381e-09,
  1.204779323488072e-11, -1.427009113731003e-14, -1.803809976558113e-17,  1.810846274464803e-19, -6.858721214705507e-22,  1.743060027996997e-24, -2.628982973999981e-27,
 -2.102918896525066e-30,  1.968419278680955e-01, -8.857856285560540e-04,  2.758952931299000e-06, -6.665772887571866e-09,  1.145008658790456e-11, -5.445536325493827e-15,
 -5.603375311234215e-17,  2.852207511543315e-19, -8.356004543571681e-22,  1.460584195887317e-24,  3.133751406003631e-28, -1.427802507964767e-29,  2.359545942269956e-01,
 -1.048792250610530e-03,  3.164281124232262e-06, -7.094400299737477e-09,  9.690981154624095e-12,  7.185072326263236e-15, -1.001201916049802e-16,  3.737331608836111e-19,
 -8.190233617163588e-22,  4.493131474992376e-25,  5.207353472987957e-27, -2.816441163108784e-29,  2.785426689524677e-01, -1.221041176090938e-03,  3.550728131606818e-06,
 -7.248970125384951e-09,  6.625783429502114e-12,  2.325023975283350e-14, -1.450393733822592e-16,  4.194244040653126e-19, -5.544773559470895e-22, -1.352127306385074e-24,
  1.114601206907660e-26, -3.742014130599038e-29,  3.245749830757066e-01, -1.400876629874264e-03,  3.903636350228665e-06, -7.066845574843847e-09,  2.180461952271531e-12,
  4.185473899956818e-14, -1.834527659686349e-16,  3.927174237242302e-19,  1.002999024044324e-23, -3.755103498842602e-24,  1.615629633401376e-26, -3.350143252893213e-29,
  3.740128143048860e-01, -1.586417726118632e-03,  4.207258615054236e-06, -6.490465594756357e-09, -3.624184392168166e-12,  6.151182590524196e-14, -2.063166134227733e-16,
  2.669855697606672e-19,  8.666582452474189e-22, -6.239255534248512e-24,  1.735344249024121e-26, -8.599260618877877e-30,  4.268082611527059e-01, -1.775536477514410e-03,
  4.444917260989939e-06, -5.471206880049226e-09, -1.064709373725226e-11,  8.011496374497941e-14, -2.036908732254076e-16,  2.591117903719589e-20,  1.917296220219879e-21,
 -7.937119376922253e-24,  1.161042087347500e-26,  3.948669349292444e-29,  4.829022895369994e-01, -1.965834458627731e-03,  4.599244179413241e-06, -3.974079867367015e-09,
 -1.860183630867311e-11,  9.497198401210488e-14, -1.660794703983397e-16, -3.275726054512960e-19,  2.951468645632899e-21, -7.738122861312351e-24, -3.156535087023961e-27,
  1.015623694992530e-28,  5.422223873938762e-01, -2.154618797148243e-03,  4.652528768698009e-06, -1.983329774464554e-09, -2.703444319624574e-11,  1.029302931028659e-13,
 -8.636359255823061e-17, -7.619145921622276e-19,  3.645239707619554e-21, -4.562311101212806e-24, -2.619116231478126e-26,  1.528984122119181e-28,  6.046797506998488e-01,
 -2.338878595110180e-03,  4.587207192412797e-06,  4.910462654158675e-10, -3.530816567617399e-11,  1.006262731410315e-13,  3.769306674134698e-17, -1.209321785422043e-18,
  3.597012186340716e-21,  2.173329601192883e-24, -5.206104404921725e-26,  1.549156646015062e-28,  6.701659108175446e-01, -2.515263500820501e-03,  4.386533426274895e-06,
  3.405966289401591e-09, -4.260097331975200e-11,  8.489293681780843e-14,  2.005418991988667e-16, -1.563309742167404e-18,  2.416243166391486e-21,  1.194084079128733e-23,
 -6.975987388876425e-26,  6.755732182843975e-29,  7.385486987795592e-01, -2.680067031277616e-03,  4.035479400832870e-06,  6.677404056821767e-09, -4.792379488596373e-11,
  5.335292239197927e-14,  3.859746478208690e-16, -1.686137177129952e-18, -1.257839298001286e-22,  2.250481790885492e-23, -6.421434587026149e-26, -1.249268025497625e-28,
  8.096674281243496e-01, -2.829218472617119e-03,  3.521916522377357e-06,  1.017259315456334e-08, -5.016987349191491e-11,  5.202389102834342e-15,  5.650634490834538e-16,
 -1.431560739997446e-18, -3.893187049446576e-21,  2.967608519386707e-23, -2.174339933670498e-26, -3.793579085676127e-28,  8.833271663004671e-01, -2.958288867504188e-03,
  2.838131026980151e-06,  1.370333813636258e-08, -4.820759425592490e-11, -5.785408137943703e-14,  6.961587184912095e-16, -6.874218545924694e-19, -8.177499040491765e-21,
  2.791122634450278e-23,  5.998835685725570e-26, -5.683939799847726e-28,  9.592919591408783e-01, -3.062518845220472e-03,  1.982715930530149e-06,  1.702212126444862e-08,
 -4.102960631134007e-11, -1.306380445790521e-13,  7.286390855146163e-16,  5.617318469653727e-19, -1.158612278453156e-20,  1.227822772574299e-23,  1.598859626535238e-25,
 -4.991040716371012e-28,  1.037276879597335e+00, -3.136878955221010e-03,  9.628546076680342e-07,  1.982354791302545e-08, -2.796794034148648e-11, -2.037465306973458e-13,
  6.123046328021587e-16,  2.161624163683256e-18, -1.218850028519330e-20, -1.804748783570736e-23,  2.266199109088186e-25, -1.403105275290228e-29,  1.116938800575906e+00,
 -3.176176745642540e-03, -2.030471205688626e-07,  2.175469178822772e-08, -8.974818351719308e-12, -2.634279857123637e-13,  3.137660585973413e-16,  3.731230546020733e-18,
 -8.103897468160409e-21, -5.562119928899859e-23,  1.898248522060439e-25,  8.219739441551114e-28,  1.197865857272947e+00, -3.175228918309164e-03, -1.482529377682582e-06,
  2.243889584224222e-08,  1.505258805743395e-11, -2.926709440338792e-13, -1.608343681106702e-16,  4.669669532009870e-18,  1.381750649921109e-21, -8.254203596574766e-23,
  1.485673591957982e-27,  1.547426180321440e-27,  1.279565688721984e+00, -3.129120949773254e-03, -2.826370910919716e-06,  2.151810284598833e-08,  4.196290401727987e-11,
 -2.741773225237702e-13, -7.417424492514813e-16,  4.290234807939207e-18,  1.440537791536941e-20, -7.465760347433387e-23, -2.971735196052798e-25,  1.381872145430223e-27,
  1.361452761397277e+00, -3.033579370490787e-03, -4.166593664057350e-06,  1.871794620949268e-08,  6.817210779534740e-11, -1.956957138480187e-13, -1.281895596966489e-15,
  2.128666844142097e-18,  2.564764022379568e-20, -1.601656044465584e-23, -5.279837531495585e-25, -1.870625094344877e-28,  1.442835417535579e+00, -2.885481102695567e-03,
 -5.416124534038177e-06,  1.393617376128721e-08,  8.879683720206574e-11, -5.741722002226224e-14, -1.572542757514574e-15, -1.612573021671034e-18,  2.741945050460301e-20,
  7.918024040194612e-23, -4.353023426917476e-25, -2.453217007324595e-27,  1.522903798026089e+00, -2.683515929612939e-03, -6.471472229834520e-06,  7.346584110880457e-09,
  9.832491728377339e-11,  1.204906868228459e-13, -1.408227446577733e-15, -5.699684445582717e-18,  1.397353715235836e-20,  1.538903254784046e-22,  8.549929402052082e-26,
 -3.216792320240826e-27,  1.600720493652246e+00, -2.428996492265795e-03, -7.220113654906381e-06, -5.040819874173405e-10,  9.200519002759325e-11,  2.945067996835119e-13,
 -7.045101716336974e-16, -8.003413331678460e-18, -1.188323915126592e-20,  1.331072677983915e-22,  7.160574324860529e-25, -6.293965460838410e-28,  1.675216667343453e+00,
 -2.126768128616333e-03, -7.554261032923345e-06, -8.649122099663972e-09,  6.790688995013842e-11,  4.047507676328629e-13,  3.732137706015674e-16, -6.546390561025842e-18,
 -3.517034456125592e-20, -3.275489332309248e-24,  7.959487298229898e-25,  3.517124988864830e-27,  1.745197359738868e+00, -1.786102806207211e-03, -7.391830588724927e-06,
 -1.576632421836347e-08,  2.909890681018392e-11,  3.971587494279920e-13,  1.373787732633593e-15, -1.277978177437992e-18, -3.613446750261357e-20, -1.562617036981089e-22,
  3.716770168684503e-26,  3.974866984367829e-27,  1.809360475106145e+00, -1.421369563512853e-03, -6.703204043902916e-06, -2.041550457308491e-08, -1.527946229132086e-11,
  2.572659291363167e-13,  1.740288242605185e-15,  4.802359760435966e-18, -9.548248442368578e-21, -1.670512277526257e-22, -7.915629070193785e-25, -8.015720091966395e-28,
  1.866334058831287e+00, -1.052178491346726e-03, -5.538514686077831e-06, -2.146595452141107e-08, -5.167812502029464e-11,  3.676604719109014e-14,  1.205854540087858e-15,
  7.184936363269067e-18,  2.213687615630386e-20, -1.190449767676162e-23, -6.043483266769822e-25, -3.951166827551830e-27,  1.914735241451237e+00, -7.026446762412195e-04,
 -4.045495006288992e-06, -1.862314502570466e-08, -6.740892718320404e-11, -1.570300209200997e-13,  1.285892009363904e-16,  4.069887109409165e-18,  2.748591218264389e-20,
  1.171944720006718e-22,  2.645520364842104e-25, -7.305836597855084e-28,  1.953250997430728e+00, -3.994867669267055e-04, -2.464984808082335e-06, -1.282094180338004e-08,
 -5.796878477336930e-11, -2.239076645576558e-13, -6.758283099554885e-16, -9.819019145197847e-19,  5.906544300296219e-21,  6.868797804972490e-23,  4.339777023122326e-25,
  2.048407193179427e-27,  1.980735692449272e+00, -1.689278068270798e-04, -1.094063745442825e-06, -6.170118959799791e-09, -3.176024069083657e-11, -1.515638005530022e-13,
 -6.711330278231916e-16, -2.725012367015460e-18, -9.816553714612495e-21, -2.858906011360014e-23, -4.252396536647872e-26,  2.356395075117512e-28,  1.996317540319654e+00,
 -3.276690797471957e-05, -2.180484362344444e-07, -1.284956642612719e-09, -7.065902961076905e-12, -3.709118641489642e-14, -1.880346020284984e-16, -9.264949868772120e-19,
 -4.452688528748983e-21, -2.090897628803534e-23, -9.597569539141824e-26, -4.303138897481134e-28,  4.391902423690549e-04, -2.071457230200146e-06,  7.326123164078933e-09,
 -2.302815264120208e-11,  6.783616627309721e-14, -1.918055082077980e-16,  5.269385273702708e-19, -1.418057633747500e-21,  3.752072288561157e-24, -9.812006426219851e-27,
  2.533041439272801e-29, -6.507579898998932e-32,  3.952623476168880e-03, -1.862568301026991e-05,  6.573456971342743e-08, -2.058474999405192e-10,  6.028329140094337e-13,
 -1.690137333449843e-15,  4.589870327667008e-18, -1.216590675318285e-20,  3.157067813562312e-23, -8.058621255355256e-26,  2.018796165002191e-28, -5.003319390361912e-31,
  1.097900591414218e-02, -5.164088477014262e-05,  1.814806382997259e-07, -5.639993313763599e-10,  1.632027825459802e-12, -4.496394018574532e-15,  1.191761633624937e-17,
 -3.057291478370801e-20,  7.597715152766849e-23, -1.833153483118564e-25,  4.263702711479631e-28, -9.600896001268876e-31,  2.151731663914161e-02, -1.009292201989188e-04,
  3.524165666968954e-07, -1.082564563407758e-09,  3.074930373123880e-12, -8.240308091626372e-15,  2.098862449938423e-17, -5.090384609159748e-20,  1.168191127195245e-22,
 -2.513271012519982e-25,  4.898708085972936e-28, -8.225481087648531e-31,  3.556589043563398e-02, -1.662055487696760e-04,  5.753056726916785e-07, -1.739306794736534e-09,
  4.813615813483465e-12, -1.239295948870870e-14,  2.970578890710148e-17, -6.563600816730231e-20,  1.294042385266031e-22, -2.103009792105259e-25,  1.888997594851124e-28,
  4.059509460355892e-31,  5.312225236999597e-02, -2.470833226303475e-04,  8.458050175703513e-07, -2.504858963695687e-09,  6.696222610132393e-12, -1.629884595762900e-14,
  3.561422275086203e-17, -6.668278424372061e-20,  9.047652021803463e-23, -4.314356578754576e-27, -5.719075887218333e-28,  2.723246980140562e-30,  7.418288901102359e-02,
 -3.430690139604759e-04,  1.158443556108069e-06, -3.342999655875985e-09,  8.541821438165123e-12, -1.921904120566607e-14,  3.618311545509992e-17, -4.689774827835523e-20,
 -1.493978282495709e-23,  3.771956831970946e-25, -1.688507292470405e-27,  5.377624649322906e-30,  9.874294883600197e-02, -4.535549997600727e-04,  1.506597027783835e-06,
 -4.211044141842491e-09,  1.014682875846469e-11, -2.038558761399494e-14,  2.914230107926078e-17, -1.738437748824917e-21, -1.868075681334991e-22,  8.777289988543666e-25,
 -2.809910770874600e-27,  6.872256408841327e-30,  1.267958619721311e-01, -5.778108076603600e-04,  1.882461385488102e-06, -5.060383445903570e-09,  1.129317442770594e-11,
 -1.906703597984491e-14,  1.285912857229180e-17,  6.907487933595284e-20, -4.046761404809397e-22,  1.364203528469410e-24, -3.365566489643770e-27,  5.334168136137363e-30,
  1.583328666403263e-01, -7.149726116585032e-04,  2.277027275928775e-06, -5.837214230940410e-09,  1.175846039393533e-11, -1.464458395892205e-14, -1.326571308568084e-17,
  1.601202714081620e-19, -6.250331986263875e-22,  1.636477027056525e-24, -2.690183819747968e-27, -7.314215592367500e-31,  1.933424263873711e-01, -8.640308565193846e-04,
  2.680059041509688e-06, -6.483513194427978e-09,  1.132835923200012e-11, -6.697485117123386e-15, -4.841400601025244e-17,  2.593240764333943e-19, -7.829371876838043e-22,
  1.461428100035067e-24, -2.503358554457059e-28, -1.141555542815174e-29,  2.318095182828068e-01, -1.023815886793645e-03,  3.080082983660029e-06, -6.938322041558783e-09,
  9.811486144532459e-12,  4.904816805791043e-15, -9.001988097472917e-17,  3.478210626304295e-19, -7.993871113960466e-22,  6.339536902322879e-25,  4.052114914096246e-27,
 -2.439714594018067e-29,  2.737147675658506e-01, -1.192981465259743e-03,  3.464391308645389e-06, -7.139422727193535e-09,  7.056919487511597e-12,  1.990817442174425e-14,
 -1.335506185589465e-16,  4.009851818818126e-19, -5.955177102387825e-22, -9.383460017139342e-25,  9.564905914649364e-27, -3.442185918916398e-29,  3.190333985767886e-01,
 -1.369986092490827e-03,  3.819070387114746e-06, -7.025496910008471e-09,  2.974418424942118e-12,  3.758374141701779e-14, -1.724716348063278e-16,  3.909972752320051e-19,
 -1.138781798553972e-22, -3.138508828727224e-24,  1.467082214911782e-26, -3.386415183300199e-29,  3.677339649922639e-01, -1.553072093562001e-03,  4.129064839614083e-06,
 -6.538877094277229e-09, -2.442843005233624e-12,  5.665286539724958e-14, -1.984855711810051e-16,  2.912579292165728e-19,  6.544299745498034e-22, -5.554676800331757e-24,
  1.682938332398032e-26, -1.493391363622902e-29,  4.197768141769959e-01, -1.740242533315434e-03,  4.378292673883347e-06, -5.629007230487819e-09, -9.093586783384312e-12,
  7.524176115069902e-14, -2.021487096799825e-16,  8.278566371710325e-20,  1.640301120231316e-21, -7.441992627056085e-24,  1.304949576045537e-26,  2.624779077154030e-29,
  4.751122306247175e-01, -1.929236177789858e-03,  4.549831416643166e-06, -4.256733228277023e-09, -1.674294457372455e-11,  9.088642677629795e-14, -1.739712487497110e-16,
 -2.375987045030368e-19,  2.671653486886293e-21, -7.780159952621737e-24,  9.286755051603991e-28,  8.426850342822762e-29,  5.336781917566011e-01, -2.117500964509065e-03,
  4.626201054798798e-06, -2.399531655126888e-09, -2.499822516574486e-11,  1.006145860973436e-13, -1.060901914122896e-16, -6.480840719235587e-19,  3.463726182133903e-21,
 -5.479173254587155e-24, -1.974879508458034e-26,  1.396154510622137e-28,  5.953976555976560e-01, -2.302166817956135e-03,  4.589776705356845e-06, -5.774630789010208e-11,
 -3.328926914266577e-11,  1.011376396751635e-13,  5.452492489532380e-18, -1.093354049163647e-18,  3.639423570634335e-21,  2.285296828367086e-25, -4.515689216481659e-26,
  1.579611804691186e-28,  6.601752840159236e-01, -2.480019203830132e-03,  4.423372164460612e-06,  2.738180372194310e-09, -4.085848334343644e-11,  8.918978556130239e-14,
  1.579125241939295e-16, -1.479644178619586e-18,  2.796691745993255e-21,  9.219557452341772e-24, -6.608018438292848e-26,  9.833236534329984e-29,  7.278934875157743e-01,
 -2.647475631661710e-03,  4.111044364632439e-06,  5.919647066371963e-09, -4.676792592107262e-11,  6.205004764380175e-14,  3.388246604099891e-16, -1.677704896865343e-18,
  6.369938743643295e-22,  1.984417283339936e-23, -6.838651565363362e-26, -6.572053491558192e-29,  7.984076587664597e-01, -2.800568489546068e-03,  3.639177114961706e-06,
  9.371430534530167e-09, -4.993352585315792e-11,  1.826981006452415e-14,  5.233948273212542e-16, -1.539248659286854e-18, -2.844350736824850e-21,  2.849181550631179e-23,
 -3.698535458389900e-26, -3.128614966431361e-28,  8.715404437603119e-01, -2.934939253598395e-03,  2.997907893313029e-06,  1.292366070200774e-08, -4.919930568869002e-11,
 -4.140587192370150e-14,  6.734014627533179e-16, -9.326103969899735e-19, -7.135472803953931e-21,  2.981718847770063e-23,  3.550797045867037e-26, -5.412397306667251e-28,
  9.470748848867383e-01, -3.045851408381743e-03,  2.182959412969281e-06,  1.634570022129761e-08, -4.346643444566923e-11, -1.130034085823225e-13,  7.392519886020700e-16,
  1.992381853714411e-19, -1.103448508149918e-20,  1.821247889414477e-23,  1.363357379250505e-25, -5.664981235608315e-28,  1.024746264898473e+00, -3.128232499747973e-03,
  1.197920428319876e-06,  1.934427964654345e-08, -3.189124537863728e-11, -1.883695252815027e-13,  6.672844382699599e-16,  1.762941820234684e-18, -1.267568974015564e-20,
 -9.049420097521606e-24,  2.219705718041834e-25, -1.941682116295228e-28,  1.104232494225303e+00, -3.176759736130029e-03,  5.697515694235272e-08,  2.156939033876748e-08,
 -1.415977088166767e-11, -2.546750066419841e-13,  4.143197856055120e-16,  3.441400539014833e-18, -9.961430503327379e-21, -4.736670661056922e-23,  2.213279162664328e-25,
  6.063668826837511e-28,  1.185142931677986e+00, -3.186008438027718e-03, -1.212011299702439e-06,  2.263274468211202e-08,  9.171173921842794e-12, -2.949597054784563e-13,
 -2.991046468717916e-17,  4.666485269255603e-18, -1.572399437489583e-21, -8.113458972001945e-23,  6.841526209420942e-26,  1.482795692047690e-27,  1.267005633920772e+00,
 -3.150688057041217e-03, -2.564309214352573e-06,  2.214471545411337e-08,  3.631132801191207e-11, -2.904880949554454e-13, -6.155819543144877e-16,  4.706034045223218e-18,
  1.151917367732764e-20, -8.524374751888168e-23, -2.301694412795108e-25,  1.651288244985035e-27,  1.349253226752966e+00, -3.065995423782217e-03, -3.935568301723500e-06,
  1.977573895332955e-08,  6.395584290227241e-11, -2.256539129775104e-13, -1.210918571713318e-15,  2.936083007295617e-18,  2.469033658419815e-20, -3.714372029338232e-23,
 -5.244516253759232e-25,  3.509802556195720e-28,  1.431207928247513e+00, -2.928117110553226e-03, -5.240410527898143e-06,  1.534567227017587e-08,  8.726794836151287e-11,
 -9.559841343817704e-14, -1.605007522597914e-15, -6.931094817009398e-19,  2.993127738093536e-20,  5.969611162114932e-23, -5.364712631005907e-25, -2.119310631569297e-27,
  1.512066787075231e+00, -2.734908156086920e-03, -6.373800598872533e-06,  8.937171682522277e-09,  1.003841124721445e-10,  8.483379803927102e-14, -1.560722550295991e-15,
 -5.163515458406681e-18,  1.953979632510481e-20,  1.543451707532093e-22, -6.582632207158676e-26, -3.637411729667713e-27,  1.590888983466675e+00, -2.486756130728240e-03,
 -7.217138951794069e-06,  1.014126552770206e-09,  9.770788926812728e-11,  2.748710625646957e-13, -9.331700425105669e-16, -8.301549937185524e-18, -6.585015042413316e-21,
  1.609168257914767e-22,  6.673238545331349e-25, -1.602958762649733e-27,  1.666588096210143e+00, -2.187598286002102e-03, -7.651262900513744e-06, -7.497429675743301e-09,
  7.607597249221239e-11,  4.113812530853085e-13,  1.741863355026419e-16, -7.667285080253037e-18, -3.467855056506455e-20,  3.158032975042959e-23,  9.444261605366163e-25,
  3.184682368459707e-27,  1.737933492968441e+00, -1.845985704326992e-03, -7.577965095684163e-06, -1.523541947380242e-08,  3.736819512743066e-11,  4.295644132635756e-13,
  1.320974524754816e-15, -2.523641803979417e-18, -4.168838561052903e-20, -1.509924402378970e-22,  2.333175260298412e-25,  4.937734312528654e-27,  1.803566188676137e+00,
 -1.475978890085191e-03, -6.949479657405144e-06, -2.061649906124253e-08, -9.705785596856701e-12,  3.006061366382031e-13,  1.869528717529485e-15,  4.394427861543187e-18,
 -1.613845304109108e-20, -1.991881521017327e-22, -8.090279280780623e-25,  5.794905357682298e-29,  1.862035077460948e+00, -1.097530964656576e-03, -5.801037690869114e-06,
 -2.228527968591118e-08, -5.063669217283332e-11,  6.820017029811325e-14,  1.416850365232780e-15,  7.881442912660408e-18,  2.122963401769391e-20, -3.973624931812177e-23,
 -7.916346036614071e-25, -4.553593161202811e-27,  1.911858493269049e+00, -7.359211198773860e-04, -4.275546989979264e-06, -1.972660439958826e-08, -7.050890522965251e-11,
 -1.524730393507103e-13,  2.555081287143633e-16,  5.018908879584955e-18,  3.188596800827750e-20,  1.269466603756792e-22,  2.180487958190834e-25, -1.418986077527996e-27,
  1.951612613498524e+00, -4.198381642173949e-04, -2.624551771368450e-06, -1.378515779917703e-08, -6.261124328460950e-11, -2.404336958800612e-13, -7.002787552555500e-16,
 -7.497955243930949e-19,  8.714426122003052e-21,  8.795210343293565e-23,  5.318060298946526e-25,  2.402061990708479e-27,  1.980041994766007e+00, -1.779853574804080e-04,
 -1.171257095488194e-06, -6.703434769443260e-09, -3.495895648488169e-11, -1.686230562068728e-13, -7.519881241689324e-16, -3.055914713614250e-18, -1.087346658808476e-20,
 -3.003660775896957e-23, -2.860771595157211e-26,  4.069770798898083e-28,  1.996182883466371e+00, -3.457495332567659e-05, -2.341715418885456e-07, -1.404199996018524e-09,
 -7.855042547279665e-12, -4.193214305442616e-14, -2.160899305945759e-16, -1.081804210984044e-18, -5.279330610440113e-21, -2.515481356565268e-23, -1.170516493249961e-25,
 -5.313772104351375e-28,  4.310199069495314e-04, -2.013935431923261e-06,  7.056173202191752e-09, -2.197278899423230e-11,  6.412337395952285e-14, -1.796222029537930e-16,
  4.888621018497038e-19, -1.303452950033855e-21,  3.416408507066238e-24, -8.853806600474132e-27,  2.263347182489117e-29, -5.767390860977560e-32,  3.879157080982315e-03,
 -1.810952569269717e-05,  6.332117525926911e-08, -1.964667238981742e-10,  5.701047227597149e-13, -1.583956656629793e-15,  4.262943336784952e-18, -1.120054625992453e-20,
  2.880977402019219e-23, -7.293475497683975e-26,  1.810906727669878e-28, -4.457536358193482e-31,  1.077530381913858e-02, -5.021567445506040e-05,  1.748664029308807e-07,
 -5.385910548286047e-10,  1.544892228045315e-12, -4.220374974626800e-15,  1.109464338066825e-17, -2.824402494000715e-20,  6.967486045375412e-23, -1.670774799837118e-25,
  3.861965284672985e-28, -8.676194500974383e-31,  2.111915731298704e-02, -9.816102673315384e-05,  3.397156339983845e-07, -1.034657234676672e-09,  2.915048179374329e-12,
 -7.753270604691979e-15,  1.961431814514876e-17, -4.730668714414209e-20,  1.081154344112700e-22, -2.324437229286751e-25,  4.546065358829383e-28, -7.802207010922527e-31,
  3.491014276790820e-02, -1.616852993994880e-04,  5.548880427096716e-07, -1.664233695415603e-09,  4.572739539394162e-12, -1.170161327045429e-14,  2.792482621464245e-17,
 -6.161471531587779e-20,  1.219733134278771e-22, -2.024315269995591e-25,  2.035419236638157e-28,  2.643187122069901e-31,  5.214726412953732e-02, -2.404353188231421e-04,
  8.163789388523304e-07, -2.400281405277730e-09,  6.378643557544964e-12, -1.546618315972118e-14,  3.378758476535371e-17, -6.379420915288485e-20,  8.993713590666143e-23,
 -2.492197214145656e-26, -4.615250460964187e-28,  2.304092015367285e-30,  7.282889722603349e-02, -3.339596350282815e-04,  1.119135042144002e-06, -3.209358823957983e-09,
  8.166017970055704e-12, -1.836644600818087e-14,  3.486523655129127e-17, -4.717114074998250e-20, -2.521210012934389e-24,  3.141941800094969e-25, -1.466234539802176e-27,
  4.736803059806971e-30,  9.695251820589182e-02, -4.417016244585181e-04,  1.457025262178117e-06, -4.051918602501154e-09,  9.746103845725989e-12, -1.968740356366846e-14,
  2.901453401866560e-17, -7.231819375478889e-21, -1.571611509827411e-22,  7.712085584730024e-25, -2.520328217399934e-27,  6.293383091183839e-30,  1.245143578330253e-01,
 -5.629909721082066e-04,  1.822808400690182e-06, -4.882725980675031e-09,  1.091506918742410e-11, -1.873662658226149e-14,  1.461913077174336e-17,  5.688550120373447e-20,
 -3.579314329834856e-22,  1.234276106259085e-24, -3.130970307033016e-27,  5.311861903070024e-30,  1.555089694875941e-01, -6.970334037976805e-04,  2.208099799964193e-06,
 -5.651437812188072e-09,  1.146273664406194e-11, -1.491136708974783e-14, -9.053652076362811e-18,  1.410410092019117e-19, -5.680616110846694e-22,  1.528562874455294e-24,
 -2.697682421737774e-27,  3.459080020433350e-31,  1.899286954951212e-01, -8.428985220852174e-04,  2.603339787446167e-06, -6.303391757746405e-09,  1.118336388965217e-11,
 -7.775070952190992e-15, -4.149579772589507e-17,  2.351089994400216e-19, -7.306201816135313e-22,  1.442119743395936e-24, -6.972095814706565e-28, -8.961078200819789e-30,
  2.277630125273947e-01, -9.995055869492261e-04,  2.997767887689255e-06, -6.780667618949899e-09,  9.888751721833491e-12,  2.858339111067961e-15, -8.063537451416158e-17,
  3.226350776395246e-19, -7.738964613753752e-22,  7.756077613325717e-25,  3.055715032903335e-27, -2.094747552417696e-29,  2.689977321179733e-01, -1.165607078451606e-03,
  3.379408285803516e-06, -7.023497079229931e-09,  7.423929009777944e-12,  1.683550855989906e-14, -1.225943941683430e-16,  3.814590607414668e-19, -6.227681786107478e-22,
 -5.851324627251420e-25,  8.118348569379598e-27, -3.132361115946259e-29,  3.136140266109304e-01, -1.339769888519225e-03,  3.735074055262537e-06, -6.972114006006681e-09,
  3.685584286089206e-12,  3.357528506045324e-14, -1.615909235140466e-16,  3.856557407211529e-19, -2.166599182863927e-22, -2.581390634038601e-24,  1.318855352506205e-26,
 -3.339150234541973e-29,  3.615872438741699e-01, -1.520354020954195e-03,  4.050400361715980e-06, -6.569154136053096e-09, -1.356750198667836e-12,  5.198926061265033e-14,
 -1.900663080535306e-16,  3.091287404651603e-19,  4.664065916963286e-22, -4.896138612202399e-24,  1.606328381728130e-26, -1.963902149447409e-29,  4.128854655786619e-01,
 -1.705488745067828e-03,  4.309920410875956e-06, -5.762728647458840e-09, -7.637049876056624e-12,  7.042369553359320e-14, -1.991354019664003e-16,  1.310915027485030e-19,
  1.382031542958389e-21, -6.900381424003182e-24,  1.394870349065688e-26,  1.493831710319382e-29,  4.674677534554753e-01, -1.893046267069645e-03,  4.497202539642641e-06,
 -4.510307463123800e-09, -1.496745918062001e-11,  8.664068597183056e-14, -1.794691262626857e-16, -1.565730364811286e-19,  2.393085436478873e-21, -7.673730059018128e-24,
  4.274320550937484e-27,  6.800319818718488e-29,  5.252820153521806e-01, -2.080613181101715e-03,  4.595072786502507e-06, -2.783549212422343e-09, -2.301280100662192e-11,
  9.786300267195844e-14, -1.227154680072863e-16, -5.405415368036780e-19,  3.253698537465670e-21, -6.150537361569847e-24, -1.392728318321753e-26,  1.248168583587132e-28,
  5.862624077839946e-01, -2.265460277092575e-03,  4.585954725827590e-06, -5.741956537610759e-10, -3.126761947645009e-11,  1.009142881646444e-13, -2.353212906523571e-17,
 -9.770958892493369e-19,  3.616810613787902e-21, -1.439037699975611e-24, -3.823745066388862e-26,  1.557847141876179e-28,  6.503261737476224e-01, -2.444511770526924e-03,
  4.452367408764639e-06,  2.098907021799866e-09, -3.904009095915419e-11,  9.249292719384810e-14,  1.177817155037672e-16, -1.385340808936224e-18,  3.082127810474475e-21,
  6.670130162840545e-24, -6.122601424974419e-26,  1.210191284107916e-28,  7.173697937611229e-01, -2.614315757453818e-03,  4.177632749244662e-06,  5.181714164571953e-09,
 -4.544939744827976e-11,  6.962107511735142e-14,  2.922379012236383e-16, -1.646423483383502e-18,  1.301595270217149e-21,  1.706685194483315e-23, -7.009718839314555e-26,
 -1.324009738985436e-29,  7.872643047384703e-01, -2.771018793748897e-03,  3.746854891330451e-06,  8.576084970687627e-09, -4.944605508196646e-11,  3.030475009742301e-14,
  4.791736077163066e-16, -1.614167847790713e-18, -1.848409427032255e-21,  2.675719106086841e-23, -4.924728255599752e-26, -2.444553309034657e-28,  8.598496165020445e-01,
 -2.910349094227130e-03,  3.148244179614681e-06,  1.213071565712132e-08, -4.986805104331123e-11, -2.558239528208417e-14,  6.442547383653856e-16, -1.143542597052043e-18,
 -6.042121492471260e-21,  3.077308701410576e-23,  1.260802770706275e-26, -4.972233505146617e-28,  9.349276319673633e-01, -3.027615127833245e-03,  2.374863581740958e-06,
  1.563312189639321e-08, -4.554883377639424e-11, -9.523367529701915e-14,  7.399929917724176e-16, -1.423720307080193e-19, -1.028680633866795e-20,  2.315406181222769e-23,
  1.104654030757424e-25, -6.046930688698421e-28,  1.012253959175075e+00, -3.117729565905605e-03,  1.426868763110152e-06,  1.880476669066698e-08, -3.549472720607052e-11,
 -1.718084258277924e-13,  7.109312308371035e-16,  1.353801262365835e-18, -1.284415149211915e-20, -3.897094399183300e-25,  2.098664997817228e-25, -3.517601074868235e-28,
  1.091528000213856e+00, -3.175272839031848e-03,  3.142822555001762e-07,  2.130265837111210e-08, -1.914622178842110e-11, -2.436125550386717e-13,  5.059723956631991e-16,
  3.097108364781235e-18, -1.150145735176310e-20, -3.804728932690704e-23,  2.429597514776056e-25,  3.754754120943747e-28,  1.172381228764256e+00, -3.194616110493422e-03,
 -9.397326095046620e-07,  2.273229519703160e-08,  3.275344130552063e-12, -2.941179802306317e-13,  9.961208259958971e-17,  4.570088762286092e-18, -4.428569282134835e-21,
 -7.712779605807669e-23,  1.309477714229917e-25,  1.348861963693412e-27,  1.254363549098669e+00, -3.170130154264794e-03, -2.295280939638018e-06,  2.267846140216895e-08,
  3.036470274681182e-11, -3.036420765744620e-13, -4.791255770042596e-16,  5.023916204564874e-18,  8.302756564493146e-21, -9.293608826930657e-23, -1.530903522571792e-25,
  1.837457095459458e-27,  1.336927803015258e+00, -3.096513691844590e-03, -3.692273639664831e-06,  2.076137831639948e-08,  5.915925886747022e-11, -2.536415339273352e-13,
 -1.117876642186176e-15,  3.700770038956934e-18,  2.298073966050461e-20, -5.765265504128067e-23, -4.970485575167576e-25,  8.922800141335078e-28,  1.419412812810100e+00,
 -2.969280224557467e-03, -5.047954625407158e-06,  1.672456614074937e-08,  8.496977354379515e-11, -1.342414139817020e-13, -1.610712846581435e-15,  2.947601238401334e-19,
  3.167279219590732e-20,  3.650473968929160e-23, -6.195575095342138e-25, -1.633625629496246e-27,  1.501025891566908e+00, -2.785442156672273e-03, -6.256868397180545e-06,
  1.055480788758166e-08,  1.016948910228151e-10,  4.571727965584215e-14, -1.695717301905363e-15, -4.450165882931764e-18,  2.500943574202188e-20,  1.484237049141739e-22,
 -2.320716074845879e-25, -3.887255119007309e-27,  1.580826599854384e+00, -2.544417578217841e-03, -7.195412219418038e-06,  2.620135908514607e-09,  1.029624221063883e-10,
  2.496673825239334e-13, -1.167656804504370e-15, -8.414586745310159e-18, -3.313077045375780e-22,  1.858937581476358e-22,  5.738732460142740e-25, -2.652142141502751e-27,
  1.657714743094058e+00, -2.249146946762413e-03, -7.733656720711027e-06, -6.214241208929417e-09,  8.432737022758727e-11,  4.128614374856047e-13, -5.580920156268771e-17,
 -8.751252771547233e-18, -3.282935784034755e-20,  7.199544910678412e-23,  1.071685127327508e-24,  2.546526086754241e-27,  1.730427160041895e+00, -1.907329897079442e-03,
 -7.756913762641058e-06, -1.456710229561579e-08,  4.626999354231085e-11,  4.602641656209317e-13,  1.230834370469677e-15, -3.942399182756267e-18, -4.690127260325171e-20,
 -1.370421284164783e-22,  4.707573909881227e-25,  5.836700387210267e-27,  1.797549511482941e+00, -1.532566486309947e-03, -7.197602993027025e-06, -2.072121608547562e-08,
 -3.235339933344512e-12,  3.468861483497272e-13,  1.984220256649028e-15,  3.757043175013027e-18, -2.388821000211486e-20, -2.311748184224328e-22, -7.816978689842817e-25,
  1.240153364191305e-27,  1.857550424025777e+00, -1.145022616742856e-03, -6.073270964364897e-06, -2.308263076725188e-08, -4.891437926384251e-11,  1.049279600694863e-13,
  1.646780700601923e-15,  8.531390031328276e-18,  1.917938865749344e-20, -7.556940893449080e-23, -1.003781846600920e-24, -5.068156522443329e-27,  1.908844873437816e+00,
 -7.710917805791492e-04, -4.519134514951384e-06, -2.087875947792851e-08, -7.348504716753096e-11, -1.445349115761171e-13,  4.110207478210625e-16,  6.113927480545472e-18,
  3.659571352274357e-20,  1.341656142584286e-22,  1.361415774539365e-25, -2.347505357545506e-27,  1.949890195809259e+00, -4.415136676458568e-04, -2.796146006584817e-06,
 -1.482632677874609e-08, -6.758950881815025e-11, -2.574577282784177e-13, -7.168624706372316e-16, -4.159547620568577e-19,  1.229005418758929e-20,  1.114459433858864e-22,
  6.455624435667114e-25,  2.769127585179899e-27,  1.979310789991151e+00, -1.876869507746520e-04, -1.255168921380387e-06, -7.290768167266484e-09, -3.851903304234191e-11,
 -1.877378830827982e-13, -8.425889604041867e-16, -3.421348742679466e-18, -1.197047983887320e-20, -3.075723567553396e-23, -5.657069574143009e-27,  6.499355432410789e-28,
  1.996040727086460e+00, -3.651792945230161e-05, -2.518046428943100e-07, -1.536882254203784e-09, -8.748102855963052e-12, -4.750174789016757e-14, -2.488884439689923e-16,
 -1.266183399549613e-18, -6.275132226148778e-21, -3.033962608028566e-23, -1.431079062807137e-25, -6.576497424893193e-28,  4.230754183296656e-04, -1.958523567564558e-06,
  6.798539059082157e-09, -2.097492927749729e-11,  6.064536319203615e-14, -1.683154073541454e-16,  4.538492710433808e-19, -1.199057784435043e-21,  3.113374058194290e-24,
 -7.997249305493115e-27,  2.024162236022342e-29, -5.118749896155128e-32,  3.807717401335480e-03, -1.761223399690588e-05,  6.101727693425163e-08, -1.875930273065070e-10,
  5.394238214699283e-13, -1.485307601000179e-15,  3.961849846757412e-18, -1.031928337070960e-20,  2.630991513011883e-23, -6.606878651606795e-26,  1.625581368962033e-28,
 -3.976336312510747e-31,  1.057719863574284e-02, -4.884218171385201e-05,  1.685488806191950e-07, -5.145338361813442e-10,  1.463084664397709e-12, -3.963347034467995e-15,
  1.033414162774072e-17, -2.610775775278154e-20,  6.392916211044630e-23, -1.523680291348217e-25,  3.498806784507915e-28, -7.845860129055418e-31,  2.073187112629615e-02,
 -9.549218393633295e-05,  3.275745562859417e-07, -9.892318534564779e-10,  2.764584900170949e-12, -7.298038678859731e-15,  1.833693327062160e-17, -4.397743766126305e-20,
  1.000666181198936e-22, -2.149334823292898e-25,  4.212164546159282e-28, -7.375418834175439e-31,  3.427215503000920e-02, -1.573248520427891e-04,  5.353486146663667e-07,
 -1.592906285657859e-09,  4.345271741171407e-12, -1.105168560712792e-14,  2.625317399476595e-17, -5.782657792724900e-20,  1.148348028767635e-22, -1.940929946260462e-25,
  2.125433110489402e-28,  1.487227004188375e-31,  5.119840491464141e-02, -2.340177890540705e-04,  7.881778451630388e-07, -2.300654240133782e-09,  6.077285906206707e-12,
 -1.467639171854794e-14,  3.204147958143215e-17, -6.093394723009202e-20,  8.873106527369463e-23, -4.146600214205631e-26, -3.683188650077227e-28,  1.941167361337787e-30,
  7.151072403463794e-02, -3.251584103816410e-04,  1.081394698170899e-06, -3.081596152633265e-09,  7.806949718309291e-12, -1.754552889437511e-14,  3.354493713498354e-17,
 -4.708176579281240e-20,  7.782727413349719e-24,  2.595390913375136e-25, -1.270715994127117e-27,  4.160587547431499e-30,  9.520871986979831e-02, -4.302372931931917e-04,
  1.409324993576309e-06, -3.899093169336751e-09,  9.359300030193117e-12, -1.899402796217500e-14,  2.874567303040885e-17, -1.183568535090307e-20, -1.311470595686067e-22,
  6.757674882988273e-25, -2.255795676764712e-27,  5.734593706405212e-30,  1.222911919458265e-01, -5.486399352041619e-04,  1.765251232566520e-06, -4.711063151801090e-09,
  1.054396774557281e-11, -1.836790799131742e-14,  1.605808173749615e-17,  4.611892289808548e-20, -3.156957087106398e-22,  1.113683754059806e-24, -2.899488247164814e-27,
  5.196758567489187e-30,  1.527557403316489e-01, -6.796367792840471e-04,  2.141373092772062e-06, -5.470430344181292e-09,  1.116264590389949e-11, -1.508326896870714e-14,
 -5.350871067573254e-18,  1.237227094362724e-19, -5.149696101514285e-22,  1.421220319106014e-24, -2.663421240115826e-27,  1.173636174523893e-30,  1.865982800640069e-01,
 -8.223713368737810e-04,  2.528767388464109e-06, -6.125753866065800e-09,  1.101842325533851e-11, -8.694567636518130e-15, -3.523230148108986e-17,  2.125536996635015e-19,
 -6.792950205113971e-22,  1.406984633835197e-24, -1.044370858865848e-27, -6.876954799370549e-30,  2.238124429372284e-01, -9.758462224763750e-04,  2.917350750599066e-06,
 -6.622092384193486e-09,  9.927283400363021e-12,  1.028723698843680e-15, -7.194394234087954e-17,  2.983389851161369e-19, -7.439879698134961e-22,  8.803450835366399e-25,
  2.203878857565000e-27, -1.782695922632981e-29,  2.643888434342023e-01, -1.138906896147074e-03,  3.295849621459106e-06, -6.902176806046232e-09,  7.732069962587063e-12,
  1.401914412567743e-14, -1.121952758594805e-16,  3.612534753009778e-19, -6.383115643807084e-22, -2.870492153362659e-25,  6.808361290851171e-27, -2.822910171088699e-29,
  3.083141798419201e-01, -1.310222905386885e-03,  3.651783990405418e-06, -6.907979670100716e-09,  4.319178432584263e-12,  2.982581748463872e-14, -1.509028875711712e-16,
  3.773347004630799e-19, -3.004457775968302e-22, -2.082947291898494e-24,  1.174168421917563e-26, -3.228618209847379e-29,  3.555701345216102e-01, -1.488266429066891e-03,
  3.971473782245825e-06, -6.582788732793870e-09, -3.618717552688680e-13,  4.753306452775800e-14, -1.812273770613385e-16,  3.213558282097333e-19,  3.014930321767495e-22,
 -4.271956151902444e-24,  1.512179849393746e-26, -2.294333817047598e-29,  4.061320285639722e-01, -1.671287964669971e-03,  4.240080152429514e-06, -5.873911991755519e-09,
 -6.276046278839034e-12,  6.569326440159253e-14, -1.948822603127728e-16,  1.714506850471805e-19,  1.143792506422493e-21, -6.332202861380567e-24,  1.439132178802290e-26,
  5.475917020208062e-30,  4.599671752686638e-01, -1.857289082493030e-03,  4.441698395073858e-06, -4.736159666145927e-09, -1.327802951559682e-11,  8.228921785888403e-14,
 -1.828223314158240e-16, -8.437579210856573e-20,  2.120588590000098e-21, -7.447417477214214e-24,  6.932402156492754e-27,  5.305312789459523e-29,  5.170328636004797e-01,
 -2.043992320966344e-03,  4.559525024731628e-06, -3.136260906009675e-09, -2.108615868993430e-11,  9.474776668279741e-14, -1.364269664726609e-16, -4.400629407429498e-19,
  3.023533801466494e-21, -6.602333274838295e-24, -8.775763169495670e-27,  1.092776854908373e-28,  5.772738865075279e-01, -2.228808552324706e-03,  4.576129165691854e-06,
 -1.058371032545895e-09, -2.925713012715318e-11,  1.000342331438318e-13, -4.928029825322393e-17, -8.624687114909107e-19,  3.539112142788991e-21, -2.833046733293744e-24,
 -3.150938563241503e-26,  1.494320487943799e-28,  6.406195092561275e-01, -2.408802561102058e-03,  4.473867951589144e-06,  1.489205036905485e-09, -3.716504827687418e-11,
  9.486556406831893e-14,  8.040575683352144e-17, -1.283332664669918e-18,  3.279499421197072e-21,  4.332576264504352e-24, -5.554115206210437e-26,  1.362073750306503e-28,
  7.069797493555483e-01, -2.580658227193642e-03,  4.235497318779519e-06,  4.466028673446878e-09, -4.399054627530574e-11,  7.608684137647264e-14,  2.468096635421783e-16,
 -1.595483382731073e-18,  1.865517947027384e-21,  1.426508137811197e-23, -6.966487205215574e-26,  3.157711018548572e-29,  7.762408121026595e-01, -2.740645701820605e-03,
  3.845043072602606e-06,  7.790406215909310e-09, -4.872865016409935e-11,  4.125674839703043e-14,  4.332908039382251e-16, -1.658304837333229e-18, -9.230187359386564e-22,
  2.459214352632320e-23, -5.851524278413629e-26, -1.772393824489797e-28,  8.482594947726089e-01, -2.884594464031268e-03,  3.289011240887696e-06,  1.132956249889548e-08,
 -5.022777992840612e-11, -1.052533411178570e-14,  6.096956698412421e-16, -1.319109708874891e-18, -4.930341659876516e-21,  3.085576820139375e-23, -8.060366021702761e-27,
 -4.405030636228724e-28,  9.228563397168876e-01, -3.007878357106455e-03,  2.558028622667578e-06,  1.489006610433716e-08, -4.727642072870807e-11, -7.755807819764616e-14,
  7.315291723331665e-16, -4.574126817203006e-19, -9.380186413716501e-21,  2.703552213749102e-23,  8.353124749174758e-26, -6.152237017188143e-28,  9.998072860073131e-01,
 -3.105421896630576e-03,  1.649008112203201e-06,  1.821030081455775e-08, -3.875744168406566e-11, -1.543375993490149e-13,  7.430927408132910e-16,  9.441513861025412e-19,
 -1.271117765757620e-20,  7.655139981304440e-24,  1.914337741188866e-25, -4.810673862657842e-28,  1.078833548541079e+00, -3.171741627019557e-03,  5.679175503296366e-07,
  2.095802932238401e-08, -2.389023533572312e-11, -2.304713762241933e-13,  5.873464044499136e-16,  2.709050330392138e-18, -1.269287453116826e-20, -2.806734529497878e-23,
  2.543389112153423e-25,  1.424636074476940e-28,  1.159589456924610e+00, -3.201042376307097e-03, -6.668242130966128e-07,  2.273781490710006e-08, -2.572837120352395e-12,
 -2.902102807490474e-13,  2.251810179075863e-16,  4.385072845212778e-18, -7.097059664289351e-21, -7.075588543621103e-23,  1.862384816012111e-25,  1.155583962552559e-27,
  1.241648038596368e+00, -3.187396041791050e-03, -2.020426687050067e-06,  2.311513746196570e-08,  2.418840722107157e-11, -3.134261615333487e-13, -3.352467577387407e-16,
  5.235051684845621e-18,  4.866639619148316e-21, -9.740865310127501e-23, -6.986964936337932e-26,  1.929133848387433e-27,  1.324484271931545e+00, -3.125039638309196e-03,
 -3.437629836532979e-06,  2.166592280218426e-08,  5.382695197428351e-11, -2.791460691267583e-13, -1.004298593151994e-15,  4.399194603163504e-18,  2.055823390974528e-20,
 -7.659591574728092e-23, -4.463989702428820e-25,  1.401875021317757e-27,  1.407456228047101e+00, -3.008838188278124e-03, -4.839198123784240e-06,  1.806050840212841e-08,
  8.189963911749327e-11, -1.726839140853807e-13, -1.588107453512260e-15,  1.324402806410387e-18,  3.252511774950836e-20,  1.045782141342435e-23, -6.782931830461092e-25,
 -1.016965206325503e-27,  1.489784854335374e+00, -2.834962757140114e-03, -6.120425094001127e-06,  1.218698901729832e-08,  1.021926595544023e-10,  3.620107582977393e-15,
 -1.808329171299495e-15, -3.566499992091606e-18,  3.014409740100436e-20,  1.356925241521406e-22, -4.047602173101719e-25, -3.924231976092038e-27,  1.570534042101288e+00,
 -2.601826734466245e-03, -7.153926566459766e-06,  4.305878771226940e-09,  1.076564684472282e-10,  2.188214560260483e-13, -1.402377430486749e-15, -8.313930502284441e-18,
  6.743079991038797e-21,  2.062017324865410e-22,  4.338216507201230e-25, -3.708540484125995e-27,  1.648593977725120e+00, -2.311290920407037e-03, -7.799860167571711e-06,
 -4.799103644546951e-09,  9.255075466912944e-11,  4.084655805599591e-13, -3.151020110621243e-16, -9.751845430678017e-18, -2.944123945418267e-20,  1.168426358144818e-22,
  1.163603950027166e-24,  1.575750589522247e-27,  1.722672641436541e+00, -1.970071132822281e-03, -7.926968207434140e-06, -1.375157576427375e-08,  5.576084042104107e-11,
  4.883055334500949e-13,  1.098722641071160e-15, -5.518025445184955e-18, -5.143181551042243e-20, -1.128438292800379e-22,  7.445109885263544e-25,  6.569781734939265e-27,
  1.791302508551564e+00, -1.591142264390556e-03, -7.446330758714090e-06, -2.071485820505364e-08,  4.186637038661378e-12,  3.956755187933632e-13,  2.077422144696739e-15,
  2.853560700794574e-18, -3.275635573561200e-20, -2.609269519911897e-22, -6.947764389141649e-25,  2.768572303703312e-27,  1.852871388388663e+00, -1.194729881595563e-03,
 -6.354881880679670e-06, -2.384624252826036e-08, -4.640089678856997e-11,  1.473837948757651e-13,  1.893785195736821e-15,  9.093409918665217e-18,  1.568134836400038e-20,
 -1.202957567131592e-22, -1.234980232571325e-24, -5.401869343478038e-27,  1.905686584874384e+00, -8.082672409985904e-04, -4.776827685212549e-06, -2.207704920456422e-08,
 -7.626253107338504e-11, -1.324793087954380e-13,  5.993379282920297e-16,  7.363099038411686e-18,  4.149579101510927e-20,  1.372102406812947e-22,  7.248286113001637e-27,
 -3.562101883854328e-27,  1.948078249523748e+00, -4.646132811555613e-04, -2.980723479691914e-06, -1.594989005609746e-08, -7.291140768600000e-11, -2.747538562001661e-13,
 -7.223631706713255e-16,  4.674829711921019e-20,  1.679724827422400e-20,  1.398116051256046e-22,  7.753031143389534e-25,  3.123019543184722e-27,  1.978539390210201e+00,
 -1.980890288596224e-04, -1.346483523557654e-06, -7.938242856339428e-09, -4.248399972027962e-11, -2.091538997524681e-13, -9.439159195622444e-16, -3.822102641371639e-18,
 -1.307409724117299e-20, -3.031953820974093e-23,  3.001533559238029e-26,  9.900641172304426e-28,  1.995890506234117e+00, -3.860859080042346e-05, -2.711194842250321e-07,
 -1.684789205717414e-09, -9.760864445065005e-12, -5.392424921080577e-14, -2.873252535661952e-16, -1.485627231765126e-18, -7.477765993274847e-21, -3.668662905263372e-23,
 -1.753923280958278e-25, -8.156872412242533e-28,  4.153485295450184e-04, -1.905125808208702e-06,  6.552552660799454e-09, -2.003095332799121e-11,  5.738531648082435e-14,
 -1.578149108448738e-16,  4.216282526421811e-19, -1.103884265751346e-21,  2.839520091772988e-24, -7.230901376840305e-27,  1.811717251928923e-29, -4.550195395720015e-32,
  3.738230688912615e-03, -1.713295574804677e-05,  5.881698146090635e-08, -1.791948256826193e-10,  5.106455917928657e-13, -1.393597500915145e-15,  3.684347942907362e-18,
 -9.514200202432290e-21,  2.404438210450107e-23, -5.990350327231263e-26,  1.460148921480815e-28, -3.552160170712483e-31,  1.038448814039656e-02, -4.751809627196037e-05,
  1.625123578859296e-07, -4.917453858066651e-10,  1.386239878851331e-12, -3.723873647603992e-15,  9.630958932542482e-18, -2.414715363719784e-20,  5.868771338062513e-23,
 -1.390407336427289e-25,  3.170260588104201e-28, -7.101632043700128e-31,  2.035506944899905e-02, -9.291832958763920e-05,  3.159644338160910e-07, -9.461426821270806e-10,
  2.622927089874280e-12, -6.872373893374040e-15,  1.714925446079361e-17, -4.089591850576515e-20,  9.262458115632450e-23, -1.987214153388329e-25,  3.896930195825131e-28,
 -6.955243719395376e-31,  3.365130178550865e-02, -1.531173572921045e-04,  5.166437006201509e-07, -1.525116516477802e-09,  4.130409758958832e-12, -1.044063031615164e-14,
  2.468443713697708e-17, -5.426200993812402e-20,  1.080017954048102e-22, -1.854895282299089e-25,  2.169441022493951e-28,  5.448337786436666e-32,  5.027477205883026e-02,
 -2.278211667140428e-04,  7.611438610819465e-07, -2.205724680557388e-09,  5.791311480738726e-12, -1.392755064028587e-14,  3.037483682899724e-17, -5.812111971463530e-20,
  8.699280542820582e-23, -5.458634148884280e-26, -2.899871117302026e-28,  1.626776308324096e-30,  7.022716147003724e-02, -3.166530723085109e-04,  1.045153571933764e-06,
 -2.959448946770300e-09,  7.463983324719207e-12, -1.675623344282768e-14,  3.223147106748437e-17, -4.669268528728630e-20,  1.625390710555237e-23,  2.122154167149994e-25,
 -1.099235277067811e-27,  3.643211462273634e-30,  9.351002712205513e-02, -4.191473326150833e-04,  1.363421953382642e-06, -3.752346049895746e-09,  8.986289231426255e-12,
 -1.830856095933472e-14,  2.835905586408331e-17, -1.566007994268395e-20, -1.083842451546003e-22,  5.904230135220835e-25, -2.015317849853855e-27,  5.200565723834419e-30,
  1.201245221961797e-01, -5.347412161967674e-04,  1.709718641809769e-06, -4.545277174431044e-09,  1.018056237768330e-11, -1.796812337089065e-14,  1.721385014605615e-17,
  3.663620235525866e-20, -2.776360668542890e-22,  1.002227255019918e-24, -2.674688488700773e-27,  5.011443093048214e-30,  1.500710436874699e-01, -6.627653619248931e-04,
  2.076789568227996e-06, -5.294247165353190e-09,  1.085996749276727e-11, -1.517193463099671e-14, -2.109795894711668e-18,  1.080418562021389e-19, -4.657090892114101e-22,
  1.315911978777696e-24, -2.597504997124507e-27,  1.790752987567960e-30,  1.833487936507200e-01, -8.024322504448758e-04,  2.456310228891817e-06, -5.950894187807921e-09,
  1.083654572488726e-11, -9.471134660137273e-15, -2.957756820788354e-17,  1.916180604227872e-19, -6.294635011691232e-22,  1.359696391666468e-24, -1.307292311160654e-27,
 -5.125961414924639e-30,  2.199552361936988e-01, -9.528225757168826e-04,  2.838839043906317e-06, -6.463182276729714e-09,  9.931254183710846e-12, -6.003494237932809e-16,
 -6.391888027384905e-17,  2.750539795817709e-19, -7.108900530458472e-22,  9.536577121453494e-25,  1.482078363090984e-27, -1.503611166396824e-29,  2.598854278741526e-01,
 -1.112869280163575e-03,  3.213774566521967e-06, -6.776363528721669e-09,  7.986333339143937e-12,  1.144552280972738e-14, -1.023673347174945e-16,  3.407123496268987e-19,
 -6.440344977535332e-22, -3.866173935637318e-26,  5.632952157660080e-27, -2.521772712209788e-29,  3.031311934745108e-01, -1.281338997596728e-03,  3.569321932885785e-06,
 -6.834293889922730e-09,  4.880327987191831e-12,  2.632978011565468e-14, -1.404827582852842e-16,  3.666085503717036e-19, -3.673163460679533e-22, -1.641259496908812e-24,
  1.035410846898510e-26, -3.072291583966600e-29,  3.496801120482969e-01, -1.456810640367054e-03,  3.892476192484375e-06, -6.581206633911272e-09,  5.460288461400102e-13,
  4.329253525704469e-14, -1.721166441693456e-16,  3.286576805158269e-19,  1.583404641814451e-22, -3.687978114580810e-24,  1.406164995465815e-26, -2.506841322586432e-29,
  3.995142692899977e-01, -1.637650880099611e-03,  4.169033247090611e-06, -5.964070232417497e-09, -5.008543387266798e-12,  6.107762688464464e-14, -1.896026978626690e-16,
  2.045161227838955e-19,  9.262309656780008e-22, -5.754129900861793e-24,  1.445595092695254e-26, -2.266926481112500e-30,  4.526087212290672e-01, -1.821986319093141e-03,
  4.383643325019302e-06, -4.935680932311699e-09, -1.167627529662414e-11,  7.788055397809831e-14, -1.842747285364477e-16, -2.074883154923720e-20,  1.857998175869323e-21,
 -7.127508361375662e-24,  8.965011675425431e-27,  3.959325782928055e-29,  5.089296004524905e-01, -2.007672253886357e-03,  4.519927568904192e-06, -3.458661698678400e-09,
 -1.922488832722669e-11,  9.133636962316379e-14, -1.474303474021608e-16, -3.471714234501110e-19,  2.780647997165568e-21, -6.861814966784994e-24, -4.312313041992367e-27,
  9.363462652824060e-29,  5.684317788938378e-01, -2.192258127153430e-03,  4.560685821359907e-06, -1.510551880537666e-09, -2.727016310652416e-11,  9.857441130856117e-14,
 -7.186089291408220e-17, -7.510795016214616e-19,  3.415996909452015e-21, -3.964528948024754e-24, -2.513424812091910e-26,  1.399011401713241e-28,  6.310559799980447e-01,
 -2.372950099723633e-03,  4.488233485438907e-06,  9.098356015549821e-10, -3.525128836838148e-11,  9.637609020968005e-14,  4.596211770190112e-17, -1.176309988707241e-18,
  3.396954591881965e-21,  2.233745455391300e-24, -4.933873757935182e-26,  1.446866040155064e-28,  6.967252070847043e-01, -2.546571727027592e-03,  4.284917789061103e-06,
  3.774660605713579e-09, -4.241315687820964e-11,  8.148139196358482e-14,  2.030452682970086e-16, -1.528104522935821e-18,  2.329341873291285e-21,  1.151767534291631e-23,
 -6.743798068850709e-26,  6.829787320424722e-29,  7.653403234308163e-01, -2.709524605631754e-03,  3.933879013194224e-06,  7.017898067440459e-09, -4.780330027660474e-11,
  5.109600115633818e-14,  3.865745453879427e-16, -1.674142208573931e-18, -8.153813717485511e-23,  2.211459305132012e-23, -6.489969983696549e-26, -1.137581149543467e-28,
  8.367745828409567e-01, -2.857752227957130e-03,  3.420139717579127e-06,  1.052501614417924e-08, -5.029503918451494e-11,  3.647336230027066e-15,  5.707181385680452e-16,
 -1.459206746477413e-18, -3.829839019356816e-21,  3.016443136218114e-23, -2.603095677544575e-26, -3.752782543483700e-28,  9.108668680896541e-01, -2.986712375853365e-03,
  2.732122767835622e-06,  1.412218304113390e-08, -4.865322410421361e-11, -6.018806642102957e-14,  7.146699013991633e-16, -7.414141555211571e-19, -8.353269001783719e-21,
  2.983790091090399e-23,  5.669230202029731e-26, -6.009213927232191e-28,  9.874133513492784e-01, -3.091366507574380e-03,  1.863712306161132e-06,  1.756646488980518e-08,
 -4.166394635480365e-11, -1.362317959050692e-13,  7.638860889403146e-16,  5.432376222773669e-19, -1.230314870971121e-20,  1.485807448315273e-23,  1.680027536102520e-25,
 -5.785562720624904e-28,  1.066157251894740e+00, -3.166199144569302e-03,  8.169708779042316e-07,  2.053970098967390e-08, -2.835279650687992e-11, -2.155115822439312e-13,
  6.573755555222213e-16,  2.288683299468547e-18, -1.351927351441927e-20, -1.783513245249815e-23,  2.556476120806398e-25, -8.035689154280039e-29,  1.146776344739008e+00,
 -3.205286693714642e-03, -3.944079013073092e-07,  2.265055075887079e-08, -8.313196368363385e-12, -2.833605146420475e-13,  3.444114510678854e-16,  4.118744773449402e-18,
 -9.498536126005348e-21, -6.235701566466072e-23,  2.319609961188639e-25,  9.163835634268857e-28,  1.228867893009626e+00, -3.202443828441917e-03, -1.740931090916735e-06,
  2.345161674252880e-08,  1.785137500675339e-11, -3.196987639498305e-13, -1.870151132976439e-16,  5.334303843609307e-18,  1.330137118675088e-21, -9.850076804661696e-23,
  1.521015291867643e-26,  1.921794096738721e-27,  1.311930778010739e+00, -3.151486504373222e-03, -3.172659736502289e-06,  2.248122424130132e-08,  4.801334924440679e-11,
 -3.016994353570366e-13, -8.723494227436765e-16,  5.009621570107047e-18,  1.749549225441034e-20, -9.308168541922674e-23, -3.746518169842225e-25,  1.845932745513913e-27,
  1.395344851809188e+00, -3.046662868026052e-03, -4.614730297602557e-06,  1.934121703650534e-08,  7.806842740993819e-11, -2.102357240906875e-13, -1.536434105219516e-15,
  2.365918455597169e-18,  3.240429583508535e-20, -1.736429700701814e-23, -7.076045186349202e-25, -3.025774062230652e-28,  1.478348041946217e+00, -2.883313395993900e-03,
 -5.964376067514915e-06,  1.382026079075930e-08,  1.018235559359735e-10, -4.086474183559344e-14, -1.893976471397334e-15, -2.527190288080656e-18,  3.469634033259419e-20,
  1.160909776612792e-22, -5.738230660053009e-25, -3.718904230539818e-27,  1.560012641348306e+00, -2.658821861920674e-03, -7.091782716727383e-06,  6.061486378189505e-09,
  1.116776265209919e-10,  1.824022706203986e-13, -1.631008680317718e-15, -7.976367743583359e-18,  1.443664944927449e-20,  2.199939534690240e-22,  2.486383408708862e-25,
 -4.688898355640792e-27,  1.639223687903055e+00, -2.373894367187648e-03, -7.848296540726463e-06, -3.253442669919328e-09,  1.006217920867456e-10,  3.975242634974658e-13,
 -6.006462789491099e-16, -1.061756620591237e-17, -2.438363918331329e-20,  1.644131070855039e-22,  1.205415072198514e-24,  2.712870308584412e-28,  1.714664502696293e+00,
 -2.034131035911610e-03, -8.086307304958631e-06, -1.277989662135336e-08,  6.577715334986809e-11,  5.126313088806208e-13,  9.206100660978161e-16, -7.222518715014898e-18,
 -5.488701183780670e-20, -7.712547335013076e-23,  1.044670034399959e-24,  7.015687932567269e-27,  1.784817226295565e+00, -1.651705465736304e-03, -7.694237150294854e-06,
 -2.058183004903810e-08,  1.260455094501727e-11,  4.463651349102965e-13,  2.141198151824288e-15,  1.649969040691191e-18, -4.261585599410138e-20, -2.857551486325010e-22,
 -5.330093183100808e-25,  4.638443943294466e-27,  1.847988960935909e+00, -1.246725936825021e-03, -6.645385765582375e-06, -2.456251843905801e-08, -4.297781379645644e-11,
  1.959423751154556e-13,  2.154704197350763e-15,  9.515921131158887e-18,  1.040386310180755e-20, -1.744844002031533e-22, -1.474693012201812e-24, -5.432550636700073e-27,
  1.902375379268220e+00, -8.475625001823436e-04, -5.049158185235770e-06, -2.331759199982613e-08, -7.875078181500281e-11, -1.154665903492425e-13,  8.248358976801039e-16,
  8.769721641765313e-18,  4.639894482027812e-20,  1.339366773353234e-22, -1.821511424874675e-25, -5.103695907006040e-27,  1.946170864075519e+00, -4.892449193575408e-04,
 -3.179306040329141e-06, -1.716137355812036e-08, -7.857941150251869e-11, -2.920092545743689e-13, -7.127281331448207e-16,  6.710515454269888e-19,  2.242266182698147e-20,
  1.736654932476047e-22,  9.195634739058198e-25,  3.420202773754934e-27,  1.977724870308630e+00, -2.092538144480421e-04, -1.445963031977587e-06, -8.652719591966193e-09,
 -4.690253463596549e-11, -2.331403822640206e-13, -1.056953896505599e-15, -4.257613430371751e-18, -1.413234585514628e-20, -2.811987654313313e-23,  8.339313499041093e-26,
  1.461065133849197e-27,  1.995731602055798e+00, -4.086115598255386e-05, -2.923108411970246e-07, -1.849980234605573e-09, -1.091182199780394e-11, -6.134753619930270e-14,
 -3.324814792794029e-16, -1.747474708441332e-18, -8.933912574314365e-21, -4.447520098496148e-23, -2.154777786181835e-25, -1.013771432551570e-27,  4.078313665264408e-04,
 -1.853651500234032e-06,  6.317587806086129e-09, -1.913749917407417e-11,  5.432775749721657e-14, -1.480567058135870e-16,  3.919534395029216e-19, -1.017048581929164e-21,
  2.591783380059058e-24, -6.544741720213089e-27,  1.622708774787916e-29, -4.051976362830349e-32,  3.670626512150967e-03, -1.667088443988914e-05,  5.671476107408940e-08,
 -1.712427564604461e-10,  4.836367481048478e-13, -1.308284930140800e-15,  3.428405885634624e-18, -8.778187043569173e-21,  2.198932391197310e-23, -5.436415386442948e-26,
  1.312246323863277e-28, -3.178543633428654e-31,  1.019697910534045e-02, -4.624122970996505e-05,  1.567420745901301e-07, -4.701490348795113e-10,  1.314020147742030e-12,
 -3.500636401113550e-15,  8.980395338949105e-18, -2.234684673417502e-20,  5.390315946480480e-23, -1.269645019077008e-25,  2.872700329743042e-28, -6.436310788493982e-31,
  1.998838064835816e-02, -9.043532583231268e-05,  3.048580582534137e-07, -9.052534492711856e-10,  2.489504384438655e-12, -6.474204388627015e-15,  1.604461018025458e-17,
 -3.804344614925329e-20,  8.574392386886096e-23, -1.837336967982571e-25,  3.599880466848267e-28, -6.550135249978802e-31,  3.304698431210956e-02, -1.490563054716477e-04,
  4.987320338156104e-07, -1.460668782305618e-09,  3.927400343683095e-12, -9.866051435867348e-15,  2.321249375435211e-17, -5.091111640139579e-20,  1.014807313326292e-22,
 -1.767875954071505e-25,  2.175924763386595e-28, -2.247010585397589e-32,  4.937550025494931e-02, -2.218363362885967e-04,  7.352220654390218e-07, -2.115253043858458e-09,
  5.519920227808214e-12, -1.321777057905508e-14,  2.878610765777095e-17, -5.537089539569389e-20,  8.483539509337770e-23, -6.483735695834871e-26, -2.245499963079226e-28,
  1.353951960159496e-30,  6.897704955276558e-02, -3.084318922776335e-04,  1.010345802791522e-06, -2.842664624456838e-09,  7.136488642536717e-12, -1.599830134199388e-14,
  3.093244741207676e-17, -4.605850519765994e-20,  2.313956096205652e-23,  1.713116956199266e-25, -9.493326375726223e-28,  3.178787950559382e-30,  9.185497077889554e-02,
 -4.084176529172689e-04,  1.319244520264743e-06, -3.611457967626433e-09,  8.626886724452024e-12, -1.763357822838633e-14,  2.787510447775693e-17, -1.880341189178300e-20,
 -8.852627887211661e-23,  5.142356135959694e-25, -1.797743256472008e-27,  4.693786932632767e-30,  1.180125712621099e-01, -5.212788984177473e-04,  1.656140864365151e-06,
 -4.385240298132324e-09,  9.825409275560651e-12, -1.754365252495215e-14,  1.812056217198850e-17,  2.830890990026883e-20, -2.434291209817863e-22,  8.995831240015650e-25,
 -2.459250217287287e-27,  4.773837281036085e-30,  1.474528126498839e-01, -6.464022384060776e-04,  2.014291139473089e-06, -5.122916947368849e-09,  1.055625896804164e-11,
 -1.518790861330996e-14,  7.137180916164636e-19,  9.387724072079256e-20, -4.201861639959106e-22,  1.213728988857870e-24, -2.508442445622812e-27,  2.230845372996854e-30,
  1.801779174865931e-01, -7.830644786321325e-04,  2.385933436030234e-06, -5.779061623075127e-09,  1.064044743224325e-11, -1.011884391114440e-14, -2.448697786189118e-17,
  1.722479072766594e-19, -5.815059192272914e-22,  1.303342076339970e-24, -1.499841589810133e-27, -3.672548998376816e-30,  2.161888799254127e-01, -9.304193962550152e-04,
  2.762233597807494e-06, -6.304459043241776e-09,  9.904517337285151e-12, -2.044522891324147e-15, -5.653061209205922e-17,  2.528649976136894e-19, -6.756438556833901e-22,
  1.000458652328256e-24,  8.759461412317956e-28, -1.256760376659668e-29,  2.554848592315503e-01, -1.087482160252238e-03,  3.133232022585040e-06, -6.646881196968645e-09,
  8.191436334933097e-12,  9.100857513147175e-15, -9.311582789970559e-17,  3.201223440715567e-19, -6.416301849126273e-22,  1.653211867445678e-25,  4.587095563184539e-27,
 -2.234864174153947e-29,  2.980624291540470e-01, -1.253111101942821e-03,  3.487795711426414e-06, -6.752175601280327e-09,  5.374032109825906e-12,  2.307999437189472e-14,
 -1.303906043642581e-16,  3.539863829586568e-19, -4.192676935354210e-22, -1.253598008977110e-24,  9.042621381189575e-27, -2.884999576760710e-29,  3.439146492288197e-01,
 -1.425986515863709e-03,  3.813581986269722e-06, -6.565764669247187e-09,  1.371319404747284e-12,  3.927261848707509e-14, -1.628624905938708e-16,  3.317066730144010e-19,
  3.542802478226411e-23, -3.147975787533679e-24,  1.293008027217360e-26, -2.622288735580838e-29,  3.930299152293226e-01, -1.604586160576262e-03,  4.097023099948029e-06,
 -6.034679743392004e-09, -3.832015142810970e-12,  5.659904138193221e-14, -1.834916423575012e-16,  2.309524222765415e-19,  7.294487978403376e-22, -5.179813537408436e-24,
  1.421487090460110e-26, -8.447716521935406e-30,  4.453905348045598e-01, -1.787157144307852e-03,  4.323344853936941e-06, -5.110280822333532e-09, -1.016290348480991e-11,
  7.345747287252398e-14, -1.840613746187052e-16,  3.467406417254904e-20,  1.608249417604110e-21, -6.737680026637169e-24,  1.043982036281853e-26,  2.770526843503239e-29,
  5.009709602188468e-01, -1.971683940699717e-03,  4.476637689897250e-06, -3.751841469054719e-09, -1.743428061047144e-11,  8.769121726325437e-14, -1.559427451110679e-16,
 -2.621685973644689e-19,  2.531469373182224e-21, -6.956439439916009e-24, -5.299906134368446e-28,  7.838931492209787e-29,  5.597355922814142e-01, -2.155852415367484e-03,
  4.540005999700355e-06, -1.931203220837463e-09, -2.531756168874376e-11,  9.660960089207735e-14, -9.138352299044877e-17, -6.442333620611789e-19,  3.256630596041086e-21,
 -4.850122123484588e-24, -1.923140871801586e-26,  1.281064907578576e-28,  6.216360471394897e-01, -2.337010001255331e-03,  4.495831161273352e-06,  3.612841200374270e-10,
 -3.331533977799733e-11,  9.709628526138304e-14,  1.455671961850744e-17, -1.066689169012195e-18,  3.443391217945672e-21,  3.886974026443662e-25, -4.289425915338867e-26,
  1.473664056459939e-28,  6.866077496141411e-01, -2.512122611884377e-03,  4.326196649277347e-06,  3.109337498113872e-09, -4.073821882636459e-11,  8.584982284954627e-14,
  1.613605454500282e-16, -1.447445595073270e-18,  2.696230089957179e-21,  8.889262323403421e-24, -6.377426385051703e-26,  9.691756959550743e-29,  7.545656821827117e-01,
 -2.677729636054773e-03,  4.013539985888242e-06,  6.261708782511773e-09, -4.669239778525230e-11,  5.981170110577752e-14,  3.397780950501203e-16, -1.664523184737955e-18,
  6.668130827243389e-22,  1.943597565753906e-23, -6.861006603107529e-26, -5.596225910800363e-29,  8.253990767658561e-01, -2.829899579383094e-03,  3.541616366974114e-06,
  9.721609179447585e-09, -5.008849693037795e-11,  1.684142481845722e-14,  5.283062178279868e-16, -1.564618927498296e-18, -2.766456562586088e-21,  2.881327474610080e-23,
 -4.101855421964750e-26, -3.055435400478670e-28,  8.989647870405639e-01, -2.964190848070045e-03,  2.896881528891228e-06,  1.333502570555200e-08, -4.968729802480732e-11,
 -4.331430246029351e-14,  6.903323465327906e-16, -9.911456732966940e-19, -7.244578666878021e-21,  3.158580365357887e-23,  3.096085570965820e-26, -5.655652479306060e-28,
  9.750790235034269e-01, -3.075625151982028e-03,  2.070423471876914e-06,  1.687904514624686e-08, -4.420424520773712e-11, -1.177599507637991e-13,  7.736742955488710e-16,
  1.593409790480033e-19, -1.165362966821219e-20,  2.104771265843263e-23,  1.410107165727020e-25, -6.428840210861103e-28,  1.053507076555568e+00, -3.158685505762957e-03,
  1.060586017826540e-06,  2.005245251197752e-08, -3.250032219420419e-11, -1.990149799627130e-13,  7.153195421914409e-16,  1.847756493310095e-18, -1.397868516411878e-20,
 -7.741219300895510e-24,  2.475760899901306e-25, -2.823213784147416e-28,  1.133950605123374e+00, -3.207357419276146e-03, -1.235848166053512e-07,  2.247268961375931e-08,
 -1.388859267130027e-11, -2.737470966319073e-13,  4.551566856706054e-16,  3.780738968821563e-18, -1.156736347962687e-20, -5.234982818939593e-23,  2.664340859969740e-25,
  6.469538456270526e-28,  1.216032051333839e+00, -3.215241231265795e-03, -1.458009610268996e-06,  2.368589389991532e-08,  1.142462528372869e-11, -3.223932590604988e-13,
 -3.759000144465422e-17,  5.320413316408372e-18, -2.184765015814463e-21, -9.622497921583742e-23,  9.782160920864854e-26,  1.817911253688123e-27,  1.299275795834009e+00,
 -3.175776089603093e-03, -2.898478437548824e-06,  2.320007716505552e-08,  4.178167195069049e-11, -3.208925205717731e-13, -7.247654636198482e-16,  5.513135584282696e-18,
  1.389539576858159e-20, -1.063328757339678e-22, -2.853645431921764e-25,  2.194739063951075e-27,  1.383085864125530e+00, -3.082631429831481e-03, -4.375286303011677e-06,
  2.055469527145606e-08,  7.350093705368947e-11, -2.461987933904690e-13, -1.455804271357503e-15,  3.387378687849246e-18,  3.126853135343585e-20, -4.571082521248237e-23,
 -7.041187111763273e-25,  4.659254948719434e-28,  1.466720447682987e+00, -2.930337414279136e-03, -5.788792907741052e-06,  1.544040782791384e-08,  1.005466392687057e-10,
 -8.704015565425396e-14, -1.948598959480955e-15, -1.354782334976943e-18,  3.842405862467436e-20,  8.998225147512463e-23, -7.282649299864118e-25, -3.259322759517696e-27,
  1.549264389282002e+00, -2.715234532933234e-03, -7.008210536939798e-06,  7.875311028985333e-09,  1.149164405105500e-10,  1.406375818797399e-13, -1.846677479723953e-15,
 -7.386178008029273e-18,  2.248338768053533e-20,  2.255588071567699e-22,  2.367841303479681e-26, -5.501034645727967e-27,  1.629602329856387e+00, -2.436808936993981e-03,
 -7.877418611684497e-06, -1.580775949344104e-09,  1.084036103481628e-10,  3.794588811487225e-13, -9.079058487157305e-16, -1.129383825134775e-17, -1.759807645429313e-20,
  2.124158216777860e-22,  1.183018264864909e-24, -1.334310488822575e-27,  1.706397652658755e+00, -2.099416251360368e-03, -8.233009428906172e-06, -1.164431304182167e-08,
  7.623330975415834e-11,  5.320984505944196e-13,  6.934337700773289e-16, -9.014655514156988e-18, -5.683652340168173e-20, -2.912217399473909e-23,  1.355699226137836e-24,
  7.041613233552093e-27,  1.778085738176727e+00, -1.714243165661627e-03, -7.939705392605970e-06, -2.030593387774731e-08,  2.204864608629654e-11,  4.981445393000352e-13,
  2.166732029479033e-15,  1.179876912380724e-19, -5.323202560157452e-20, -3.023752216775897e-22, -2.822132063776420e-25,  6.803602816490547e-27,  1.842893848177693e+00,
 -1.301079397260805e-03, -6.944123184550412e-06, -2.521591175552434e-08, -3.852008689922537e-11,  2.508840231441518e-13,  2.424782755945099e-15,  9.736494003082890e-18,
  3.003756943707878e-21, -2.381666959860321e-22, -1.706354976058939e-24, -5.008655162526616e-27,  1.898902540137163e+00, -8.890965983871344e-04, -5.336601852622923e-06,
 -2.459491701455825e-08, -8.084137748822062e-11, -9.255173020447513e-14,  1.091886973263671e-15,  1.032975862518963e-17,  5.103060142813105e-20,  1.216276460869741e-22,
 -4.471038422248870e-25, -6.998912502472462e-27,  1.944161680469812e+00, -5.155249370652860e-04, -3.392981862068924e-06, -1.846628709670719e-08, -8.458868490437888e-11,
 -3.088021381260911e-13, -6.829011222817269e-16,  1.496005405002538e-18,  2.937356487766397e-20,  2.135206601138161e-22,  1.074466991693369e-24,  3.593293148591529e-27,
  1.976864043546321e+00, -2.212499702665994e-04, -1.554456760619705e-06, -9.441882338785857e-09, -5.182893546383546e-11, -2.599898455172195e-13, -1.182645179981590e-15,
 -4.725265757427488e-18, -1.506755029572867e-20, -2.332273673919563e-23,  1.611616856986946e-25,  2.106976198059302e-27,  1.995563335543179e+00, -4.329150592903353e-05,
 -3.156000795967353e-07, -2.034835784923094e-09, -1.222270500812968e-11, -6.994808936327069e-14, -3.856662488293332e-16, -2.060732424220019e-18, -1.070153595451928e-20,
 -5.405552411902358e-23, -2.653472989265404e-25, -1.262343505075664e-27,  4.005164080497431e-04, -1.804014842368617e-06,  6.093057192846893e-09, -1.829144253619997e-11,
  5.145843306769759e-14, -1.389823930106854e-16,  3.646026513570711e-19, -9.377594189645408e-22,  2.367438661747953e-24, -5.929989411175451e-27,  1.454228338203499e-29,
 -3.615862902289806e-32,  3.604837579249902e-03, -1.622525641436784e-05,  5.470542791297035e-08, -1.637095055989282e-10,  4.582743613787855e-13, -1.228874919153266e-15,
  3.192180713861150e-18, -8.104856129260436e-21,  2.012341701112735e-23, -4.938490028109722e-26,  1.179772680762876e-28, -2.850021378411012e-31,  1.001448682603041e-02,
 -4.500950809936561e-05,  1.512241590459634e-07, -4.496733131928711e-10,  1.246113021657560e-12, -3.292424685066675e-15,  8.378160609797925e-18, -2.069291376897040e-20,
  4.953261110395294e-23, -1.160221465232149e-25,  2.602792168788657e-28, -5.843811094539197e-31,  1.963144921786326e-02, -8.803924609329425e-05,  2.942298031042757e-07,
 -8.664366863234291e-10,  2.363786297378245e-12, -6.101612305919548e-15,  1.501683208982454e-17, -3.540274777145514e-20,  7.938186098051009e-23, -1.698991379636280e-25,
  3.320186465857874e-28, -6.167521104415001e-31,  3.245862928053155e-02, -1.451355078519016e-04,  4.815746240079920e-07, -1.399379154091192e-09,  3.735536718790577e-12,
 -9.325696587224484e-15,  2.183150104752679e-17, -4.776388595836329e-20,  9.527262703907233e-23, -1.681231704013550e-25,  2.151683521873718e-28, -8.573762921757535e-32,
  4.849975979707561e-02, -2.160546103426178e-04,  7.103603376914432e-07, -2.029012148061869e-09,  5.262349476909243e-12, -1.254520406725616e-14,  2.727336623804393e-17,
 -5.269513044287505e-20,  8.235326906987089e-23, -7.270016879902910e-26, -1.703206363152108e-28,  1.116323810992057e-30,  6.775927418266676e-02, -3.004836566898934e-04,
  9.769085007931998e-07, -2.731000635380687e-09,  6.823842398066881e-12, -1.527130914607617e-14,  2.965405222455336e-17, -4.522642658759666e-20,  2.865581666806254e-23,
  1.360096519663407e-25, -8.188092113976175e-28,  2.761345818838428e-30,  9.024213688642835e-02, -3.980347267922004e-04,  1.276723684859074e-06, -3.476212987968879e-09,
  8.280860955253801e-12, -1.697119715915480e-14,  2.731163556464741e-17, -2.135353630990372e-20, -7.125970432930148e-23,  4.463134513788142e-25, -1.601852668732504e-27,
  4.214894802136549e-30,  1.159536243820007e-01, -5.082376170373731e-04,  1.604449718507676e-06, -4.230816850873338e-09,  9.478944939929169e-12, -1.710009822375185e-14,
  1.880889094647821e-17,  2.101875868014210e-20, -2.127648805408104e-22,  8.053352296742090e-25, -2.255156619464607e-27,  4.497733239117105e-30,  1.448990470359830e-01,
 -6.305309610765739e-04,  1.953819518337900e-06, -4.956445071683930e-09,  1.025287731807963e-11, -1.514071633340209e-14,  3.160469208342901e-18,  8.111122411439330e-20,
 -3.782734536021371e-22,  1.115450146161567e-24, -2.403379627726608e-27,  2.522300759532711e-30,  1.770833993637597e-01, -7.642515274802037e-04,  2.317599402027499e-06,
 -5.610463807683422e-09,  1.043257365284751e-11, -1.065071587539616e-14, -1.991758169412102e-17,  1.543785704293040e-19, -5.357010503304667e-22,  1.240484609342983e-24,
 -1.634377199635329e-27, -2.483809621890344e-30,  2.125109227377188e-01, -9.086214510527429e-04,  2.687529341255206e-06, -6.146385241677541e-09,  9.850620545955899e-12,
 -3.318704575536567e-15, -4.974762398054682e-17,  2.318263788716807e-19, -6.391239052533558e-22,  1.025094351821452e-24,  3.715589371963798e-28, -1.040899172858459e-29,
  2.511845603027059e-01, -1.062733113238942e-03,  3.054261447580988e-06, -6.514480495541886e-09,  8.351819760987775e-12,  6.971325335003998e-15, -8.443871629841368e-17,
  2.997189405543635e-19, -6.326055469192067e-22,  3.299427968671944e-25,  3.663536961736979e-27, -1.966462617443174e-29,  2.931052784208222e-01, -1.225531344949997e-03,
  3.407300202461082e-06, -6.662664975607226e-09,  5.805133089998867e-12,  2.006800395517202e-14, -1.206731185416320e-16,  3.399151058781143e-19, -4.581870505759166e-22,
 -9.166849996952106e-25,  7.818032743593194e-27, -2.679162983266025e-29,  3.382712220826004e-01, -1.395792585348505e-03,  3.734949697529698e-06, -6.537749153655144e-09,
  2.118437318020590e-12,  3.547539906114540e-14, -1.535751702928249e-16,  3.311246884869918e-19, -6.886907159690822e-23, -2.654009746422577e-24,  1.176550228817621e-26,
 -2.659904699846288e-29,  3.866766629609422e-01, -1.572100598225377e-03,  4.024275655989263e-06, -6.087173168203659e-09, -2.743535594241243e-12,  5.227531126847489e-14,
 -1.767254369021031e-16,  2.514201310087829e-19,  5.531067595396944e-22, -4.620158170197640e-24,  1.373300301897179e-26, -1.324164330590752e-29,  4.383106876063409e-01,
 -1.752818333167531e-03,  4.261093550938847e-06, -5.261373666581542e-09, -8.737821001915221e-12,  6.905724461191918e-14, -1.824058819286347e-16,  8.233993107392657e-20,
  1.373474528818054e-21, -6.298854536370006e-24,  1.142636960960410e-26,  1.739530828979764e-29,  4.931555589984256e-01, -1.936055537737609e-03,  4.429999112401678e-06,
 -4.016965047521129e-09, -1.571843079626394e-11,  8.386942514207964e-14, -1.621870071839894e-16, -1.851660917238794e-19,  2.281447696628832e-21, -6.912982551112928e-24,
  2.597397922864022e-27,  6.391694424267051e-29,  5.511846664151453e-01, -2.119631805458465e-03,  4.514464435208380e-06, -2.320951759182987e-09, -2.340870268086039e-11,
  9.421154353322569e-14, -1.079903312337347e-16, -5.429525213719078e-19,  3.069503403157167e-21, -5.510464270890443e-24, -1.388228932074532e-26,  1.148555500816772e-28,
  6.123599552922273e-01, -2.301034924439630e-03,  4.497032415923645e-06, -1.562168596221186e-10, -3.137227534824054e-11,  9.709969167841410e-14, -1.376812171311608e-17,
 -9.565952337492587e-19,  3.428060823463193e-21, -1.197707710719043e-24, -3.644183320188881e-26,  1.452072863565173e-28,  6.766286991528483e-01, -2.477374739494679e-03,
  4.359655135496623e-06,  2.471458782038811e-09, -3.898572706657273e-11,  8.924616209282786e-14,  1.220846287642421e-16, -1.356529602574427e-18,  2.971415624138285e-21,
  6.430264187719339e-24, -5.902380100917978e-26,  1.177750379913623e-28,  7.439194383616465e-01, -2.645333360764386e-03,  4.084238888860947e-06,  5.524627565973056e-09,
 -4.541837702330057e-11,  6.741013427251300e-14,  2.935715660636306e-16, -1.632523593132920e-18,  1.316657465751809e-21,  1.665780903948174e-23, -6.992855835965274e-26,
 -5.214491134882201e-30,  8.141368639578075e-01, -2.801113605277716e-03,  3.653480487222450e-06,  8.923561704852047e-09, -4.962847117309374e-11,  2.898600507499774e-14,
  4.834110489249162e-16, -1.636890803228657e-18, -1.761762237055673e-21,  2.692449339288278e-23, -5.290562633357324e-26, -2.348986823629169e-28,  8.871553680552832e-01,
 -2.940389289588068e-03,  3.052106158384955e-06,  1.253398894866119e-08, -5.039028313010971e-11, -2.710448946061525e-14,  6.595070650346915e-16, -1.204587592258378e-18,
 -6.091067253538556e-21,  3.234080334335266e-23,  7.168726673707587e-27, -5.135203406856152e-28,  9.628109152763210e-01, -3.058263766030761e-03,  2.268653954864699e-06,
  1.615394527020733e-08, -4.637361568147230e-11, -9.917963095943446e-14,  7.730363641485720e-16, -2.004191572741014e-19, -1.080131179625801e-20,  2.611073489458790e-23,
  1.119087720235306e-25, -6.747245545989379e-28,  1.040890815023979e+00, -3.149247436346360e-03,  1.297967134531413e-06,  1.950155441537167e-08, -3.630501647124330e-11,
 -1.812772015264399e-13,  7.607658475099869e-16,  1.397863388044551e-18, -1.408259635888799e-20,  1.860196850515244e-24,  2.312363548673533e-25, -4.550012229496023e-28,
  1.121120900136877e+00, -3.207271598468674e-03,  1.445754998472264e-07,  2.220730133841538e-08, -1.924594557178181e-11, -2.615965020079783e-13,  5.555668434041816e-16,
  3.382537437705499e-18, -1.325401808959715e-20, -4.120602550945944e-23,  2.886928890946952e-25,  3.639439091721446e-28,  1.203149562123833e+00, -3.225765767848145e-03,
 -1.172894919810349e-06,  2.381710643314971e-08,  4.979750898610694e-12, -3.215188303378806e-13,  1.098883032881683e-16,  5.195983987098399e-18, -5.559603787996264e-21,
 -9.076275604388757e-23,  1.738943011673244e-25,  1.626581061149515e-27,  1.286528094420141e+00, -3.197839442417550e-03, -2.616281176050321e-06,  2.381634936180673e-08,
  3.520262601560643e-11, -3.363878434440860e-13, -5.647625921702232e-16,  5.894531172054699e-18,  9.885940503552470e-21, -1.157390250787152e-22, -1.832616123886993e-25,
  2.425355809942184e-27,  1.370686923697843e+00, -3.116627489015116e-03, -4.121742417354863e-06,  2.168945434928217e-08,  6.823582792573150e-11, -2.798885832756815e-13,
 -1.347235208068831e-15,  4.356260270901143e-18,  2.912300180532370e-20, -7.323678124690030e-23, -6.665500468887355e-25,  1.237936400852557e-27,  1.454907689224961e+00,
 -2.975879418142763e-03, -5.593921242964538e-06,  1.703267629675829e-08,  9.833582977550740e-11, -1.341200107319131e-13, -1.968873557113523e-15, -7.927433346337152e-20,
  4.110621021398743e-20,  5.817387073968735e-23, -8.570172282552110e-25, -2.554533991734878e-27,  1.538291962694941e+00, -2.770890747246295e-03, -6.902589994263126e-06,
  9.733999265143848e-09,  1.172696896952241e-10,  9.392436407200564e-14, -2.042198677571890e-15, -6.537089801823501e-18,  3.056050559569967e-20,  2.214808449856949e-22,
 -2.316007562048303e-25, -6.052220497928583e-27,  1.619728977648729e+00, -2.499874108803407e-03, -7.885734864943367e-06,  2.131027594515002e-10,  1.157489784315445e-10,
  3.538181653871447e-13, -1.230803368568760e-15, -1.172563836783997e-17, -9.118253322616455e-21,  2.580356242016796e-22,  1.084594241563977e-24, -3.169253846405091e-27,
  1.697867404881439e+00, -2.165817704134073e-03, -8.365068917039705e-06, -1.033862962171531e-08,  8.702019277124775e-11,  5.455058363245276e-13,  4.154811443893175e-16,
 -1.083913239496881e-17, -5.683507845066517e-20,  3.119192647792030e-23,  1.656190333995644e-24,  6.515917454194279e-27,  1.771100196464898e+00, -1.778728720869556e-03,
 -8.180922006992523e-06, -1.987062946478867e-08,  3.253078243850023e-11,  5.499831440144720e-13,  2.144539341269616e-15, -1.761157603181992e-18, -6.424236291096328e-20,
 -3.069914774929448e-22,  6.860416930200301e-26,  9.163023151475606e-27,  1.837576493945901e+00, -1.357852821618023e-03, -7.250235974716211e-06, -2.578883700482559e-08,
 -3.289835543983001e-11,  3.123527290985720e-13,  2.697364968515957e-15,  9.681840581914877e-18, -6.849668699107524e-21, -3.105701906354617e-22, -1.906159246323463e-24,
 -3.953817967890644e-27,  1.895258867683981e+00, -9.329920890057715e-04, -5.639557824247969e-06, -2.590166180096139e-08, -8.240596099730113e-11, -6.268721048094103e-14,
  1.404611891332914e-15,  1.202870376611866e-17,  5.500731157861805e-20,  9.694763949048090e-23, -8.032704113191415e-25, -9.246316989792848e-27,  1.942043856465852e+00,
 -5.435786569507679e-04, -3.622904471247005e-06, -1.986998865351060e-08, -9.092465081831480e-11, -3.245754856483522e-13, -6.266371063604766e-16,  2.567552211894902e-18,
  3.787211195896382e-20,  2.596669091102058e-22,  1.232490776694404e-24,  3.542341419133443e-27,  1.975953434337798e+00, -2.341533376055494e-04, -1.672911640574988e-06,
 -1.031433182503074e-08, -5.732356881743206e-11, -2.900162299737553e-13, -1.321819117553724e-15, -5.219421789754167e-18, -1.576664390354806e-20, -1.478284890616354e-23,
  2.722169185559094e-25,  2.984674073235077e-27,  1.995384960432736e+00, -4.591741294801459e-05, -3.412393388212737e-07, -2.242114006280193e-09, -1.371910833248257e-11,
 -7.993705630804310e-14, -4.484688522048804e-16, -2.436479777932783e-18, -1.285275192728457e-20, -6.586703853372280e-23, -3.275002460587916e-25, -1.574524243424457e-27,
  3.933964669310768e-04, -1.756134585581814e-06,  5.878409679661532e-09, -1.748987812408210e-11,  4.876420642546094e-14, -1.305386492018216e-16,  3.393746897724782e-19,
 -8.653078311039228e-22,  2.164056682546196e-24, -5.378958646599321e-27,  1.303698716615969e-29, -3.235010759254426e-32,  3.540799572064908e-03, -1.579534823793008e-05,
  5.278411040308297e-08, -1.565696490700856e-10,  4.344449737654505e-13, -1.154914658178289e-15,  2.973999115994575e-18, -7.488465701810140e-21,  1.842756230493265e-23,
 -4.490785508198261e-26,  1.060846769175232e-28, -2.562066888029778e-31,  9.836834677003496e-03, -4.382096513776013e-05,  1.459455679961730e-07, -4.302515614974011e-10,
  1.182229264520037e-12, -3.098126328285163e-15,  7.820335761393010e-18, -1.917273894660258e-20,  4.553716388676034e-23, -1.061093147261531e-25,  2.357443796807205e-28,
 -5.319260814512167e-31,  1.928393495677614e-02, -8.572636282841133e-05,  2.840555218112991e-07, -8.295731135266593e-10,  2.245279257364947e-12, -5.752822175393223e-15,
  1.406021670183325e-17, -3.295787937904200e-20,  7.349810260428840e-23, -1.571505035718865e-25,  3.056703023155438e-28, -5.814462499907615e-31,  3.188568750628003e-02,
 -1.413490789855815e-04,  4.651346217127456e-07, -1.341074658352310e-09,  3.554155775743045e-12, -8.817450255208401e-15,  2.053589629028688e-17, -4.481034810154801e-20,
  8.937405620092975e-23, -1.596080905062652e-25,  2.102010800338588e-28, -1.385867476084649e-31,  4.764675491207461e-02, -2.104677077052547e-04,  6.865092114746216e-07,
 -1.946786720943989e-09,  5.017873019497484e-12, -1.190805351495127e-14,  2.583439456003948e-17, -5.010292375422170e-20,  7.962469014890710e-23, -7.859388565070489e-26,
 -1.258821046638963e-28,  9.079642301579735e-31,  6.657276512593724e-02, -2.927976435922043e-04,  9.447816270617062e-07, -2.624224326226470e-09,  6.525431168057751e-12,
 -1.457470004860261e-14,  2.840124244565784e-17, -4.423718930222136e-20,  3.299086357198470e-23,  1.055736800897581e-25, -7.057311803141007e-28,  2.384797536744519e-30,
  8.867016451216075e-02, -3.879855687084334e-04,  1.235793005463174e-06, -3.346399197593185e-09,  7.947942104502654e-12, -1.632313595601586e-14,  2.668414154396335e-17,
 -2.338878196482959e-20, -5.630229117524085e-23,  3.858135271873014e-25, -1.426435338703715e-27,  3.762891219272577e-30,  1.139460271731148e-01, -4.956025460569919e-04,
  1.554578688909513e-06, -4.081865034162490e-09,  9.141500915117500e-12, -1.664236572020946e-14,  1.930633408987907e-17,  1.465712765709739e-20, -1.853496276095419e-22,
  7.189991284711519e-25, -2.063867267647894e-27,  4.193193270338807e-30,  1.424078115209458e-01, -6.151355484940590e-04,  1.895316476228919e-06, -4.794816679917545e-09,
  9.950998550157704e-12, -1.503894309148316e-14,  5.268022785705466e-18,  6.963063946727626e-20, -3.398203981542700e-22,  1.021591897255718e-24, -2.288324603935801e-27,
  2.688481298272972e-30,  1.740630524335824e-01, -7.459772132173920e-04,  2.251268253734573e-06, -5.445271280947053e-09,  1.021511940859240e-11, -1.107876292396647e-14,
 -1.582835339490432e-17,  1.379378428755088e-19, -4.922439627097300e-22,  1.173220576982285e-24, -1.721882300911294e-27, -1.530253650639501e-30,  2.089189740531594e-01,
 -8.874135689006164e-04,  2.614715983379634e-06, -5.989369010730195e-09,  9.772821007971690e-12, -4.437030780059939e-15, -4.353724963905880e-17,  2.119668753333614e-19,
 -6.020581408062230e-22,  1.031366251649256e-24, -4.439025289607232e-29, -8.545071056497759e-30,  2.469820041525791e-01, -1.038609435132056e-03,  2.976893708434668e-06,
 -6.379843263078850e-09,  8.471648966324357e-12,  5.043226151517415e-15, -7.632801553823537e-17,  2.796922449811335e-19, -6.182915884213824e-22,  4.599224994364674e-25,
  2.853432291744040e-27, -1.719573489445818e-29,  2.882571657498425e-01, -1.198591142755970e-03,  3.327918259459099e-06, -6.566726117466774e-09,  6.178293863794021e-12,
  1.728437539020068e-14, -1.113653073413372e-16,  3.247831965874566e-19, -4.858371208069198e-22, -6.269130950950180e-25,  6.686164239790049e-27, -2.465086191281994e-29,
  3.327473149503839e-01, -1.366226170875546e-03,  3.656722851330254e-06, -6.498375208011580e-09,  2.791836599156194e-12,  3.190051874660710e-14, -1.443482615420914e-16,
  3.274807099940522e-19, -1.562241256591177e-22, -2.206768050891409e-24,  1.059825952088720e-26, -2.637127826720739e-29,  3.804521854027464e-01, -1.540199245557941e-03,
  3.950999960393305e-06, -6.122933710306929e-09, -1.739863554865341e-12,  4.812022805684472e-14, -1.694621367824235e-16,  2.665631456652783e-19,  3.965179061525708e-22,
 -4.083628523238737e-24,  1.306735029903353e-26, -1.683209972906629e-29,  4.313671886872131e-01, -1.718984403957414e-03,  4.197163045773813e-06, -5.390366630167485e-09,
 -7.400241984408787e-12,  6.471192980907777e-14, -1.795184998972786e-16,  1.227525211546499e-19,  1.155102492757458e-21, -5.829185457238691e-24,  1.199311106892758e-26,
  8.610206460385331e-30,  4.854819056743860e-01, -1.900812508474534e-03,  4.380341226752000e-06, -4.255253941392162e-09, -1.408034546892035e-11,  7.992274177287179e-14,
 -1.663868086210319e-16, -1.161163336964064e-19,  2.035091324814685e-21, -6.756876873992344e-24,  5.109988932024659e-27,  5.047822619800787e-29,  5.427781854306164e-01,
 -2.083633720566575e-03,  4.484427488460626e-06, -2.680562946104922e-09, -2.155156433414498e-11,  9.144825596929299e-14, -1.218483949672372e-16, -4.479999703427031e-19,
  2.862312186059380e-21, -5.968774501523172e-24, -9.135401053329328e-27,  1.008353458653648e-28,  6.032277443880754e-01, -2.265074549349819e-03,  4.492210078467308e-06,
 -6.426641525333669e-10, -2.943569156297542e-11,  9.646018703579433e-14, -3.902543279789601e-17, -8.478560873740182e-19,  3.360231544441336e-21, -2.529127231267209e-24,
 -3.017326702148476e-26,  1.391634628421846e-28,  6.667891277174608e-01, -2.442389335881784e-03,  4.385629394420109e-06,  1.862113014992380e-09, -3.717452374397259e-11,
  9.173134173710964e-14,  8.546460611119233e-17, -1.258185717449246e-18,  3.161698980765583e-21,  4.177479461362232e-24, -5.351581530215708e-26,  1.314651717877612e-28,
  7.334038553099783e-01, -2.612406516455127e-03,  4.146219943949401e-06,  4.809086523344603e-09, -4.400339283874436e-11,  7.391261977244947e-14,  2.485370725518164e-16,
 -1.581335151572860e-18,  1.866056054404737e-21,  1.386928812519125e-23, -6.918510795345274e-26,  3.766996299381283e-29,  8.029915244210009e-01, -2.771470881285869e-03,
  3.755820024309703e-06,  8.134758608411349e-09, -4.893647406617981e-11,  4.003238494312491e-14,  4.369315293224960e-16, -1.678186108745726e-18, -8.328771918556125e-22,
  2.462196299313302e-23, -6.172184031870304e-26, -1.664182046556835e-28,  8.754435777814060e-01, -2.915384550678439e-03,  3.197661423125645e-06,  1.172425584733226e-08,
 -5.077693248940172e-11, -1.170200994151711e-14,  6.232249865867169e-16, -1.380861222799937e-18, -4.926918265277312e-21,  3.219380941652926e-23, -1.405083632330100e-26,
 -4.493935214377233e-28,  9.506153683773269e-01, -3.039351902858501e-03,  2.457987230870925e-06,  1.539710411850360e-08, -4.817233218529539e-11, -8.073225860676262e-14,
  7.627327734681690e-16, -5.302156805726496e-19, -9.787933087638713e-21,  2.999074199550117e-23,  8.207930196843379e-26, -6.764708514598172e-28,  1.028316060574670e+00,
 -3.137937768656437e-03,  1.528384110615320e-06,  1.889267423116580e-08, -3.974506902801677e-11, -1.625999370742756e-13,  7.936195740142285e-16,  9.500351279596243e-19,
 -1.385436180236398e-20,  1.066607155021362e-23,  2.080551529439699e-25, -5.925570927962104e-28,  1.108295806797339e+00, -3.205054671666457e-03,  4.090452840304998e-07,
  2.185826655084646e-08, -2.433712118975948e-11, -2.471755820289874e-13,  6.441331310715225e-16,  2.936929227466927e-18, -1.452647569777710e-20, -2.942126419883523e-23,
  2.985020153108818e-25,  8.365512373720065e-29,  1.190229544103183e+00, -3.234004839139259e-03, -8.868231905822389e-07,  2.384553179493612e-08, -1.412584547519429e-12,
 -3.171587317146076e-13,  2.524043054499306e-16,  4.967275494663821e-18, -8.685267251333348e-21, -8.244862863617578e-23,  2.398868271363023e-25,  1.362550281942715e-27,
  1.273696699032209e+00, -3.217617447755462e-03, -2.327329778376769e-06,  2.432508958200155e-08,  2.835286316507806e-11, -3.479297309296813e-13, -3.959220627548519e-16,
  6.143012057627155e-18,  5.613476534849824e-21, -1.208963668240211e-22, -7.388915488521629e-26,  2.523639296196014e-27,  1.358156139889179e+00, -3.148542211030942e-03,
 -3.855108625064841e-06,  2.273473196129967e-08,  6.232513306061477e-11, -3.106558332838080e-13, -1.212645178266728e-15,  5.240985858983812e-18,  2.602168233505249e-20,
 -9.859140791111136e-23, -5.959148204279231e-25,  1.960200682508875e-27,  1.442916000767080e+00, -3.019786692814056e-03, -5.380185719049182e-06,  1.858202490226319e-08,
  9.518149563921030e-11, -1.812492788385259e-13, -1.952411189223004e-15,  1.262811581511466e-18,  4.255863744504508e-20,  2.190154869909111e-23, -9.499033657224735e-25,
 -1.636093349084134e-27,  1.527098743247616e+00, -2.825612212717118e-03, -6.774470914089896e-06,  1.162261902011303e-08,  1.186438252777704e-10,  4.283293083146824e-14,
 -2.210363224576474e-15, -5.433895297063514e-18,  3.830203321573438e-20,  2.068024588704125e-22, -5.038346194555649e-25, -6.259363697824156e-27,  1.609603370794332e+00,
 -2.562917748248341e-03, -7.871837715014371e-06,  2.119980244755717e-09,  1.225032222710197e-10,  3.203149737182709e-13, -1.561751782469150e-15, -1.186072769332154e-17,
  9.131442112066123e-22,  2.980598789551840e-22,  9.023881001976334e-25, -5.120672437183299e-27,  1.689069541739118e+00, -2.233210008038230e-03, -8.480417035959999e-06,
 -8.858590684270651e-09,  9.800438579775938e-11,  5.516314279327119e-13,  8.678645574068445e-17, -1.262655870305175e-17, -5.445324950090981e-20,  1.028745934362264e-22,
  1.919282709596528e-24,  5.325660670617822e-27,  1.763852890278220e+00, -1.845120184724734e-03, -8.415874614203496e-06, -1.925936423943341e-08,  4.403989669443375e-11,
  6.006178663463840e-13,  2.064793463886992e-15, -3.992379672846518e-18, -7.514104828249811e-20, -2.954762674058312e-22,  5.245640314540079e-25,  1.154927042808046e-26,
  1.832027106954549e+00, -1.417101023861123e-03, -7.562642463953468e-06, -2.626162530330953e-08, -2.598214863818595e-11,  3.803069535328892e-13,  2.963600296783487e-15,
  9.268734781693506e-18, -1.944024538319959e-20, -3.898099324225403e-22, -2.042190489746201e-24, -2.078468199688993e-27,  1.891434666122659e+00, -9.793743285890853e-04,
 -5.958323857002873e-06, -2.722823738591179e-08, -8.329427646472793e-11, -2.473299152967451e-14,  1.766534519108234e-15,  1.383773914495580e-17,  5.781439676176976e-20,
  5.594830677983901e-23, -1.265288895621636e-24, -1.179721346536639e-26,  1.939810029675329e+00, -5.735408822129884e-04, -3.870289895336847e-06, -2.137750525817171e-08,
 -9.755998455784345e-11, -3.386061478991910e-13, -5.363040418777216e-16,  3.938842800935611e-18,  4.814430765226125e-20,  3.119933168995653e-22,  1.380808030517800e-24,
  3.124353873242758e-27,  1.974989247904053e+00, -2.480477629424664e-04, -1.802383817406503e-06, -1.127968589515213e-08, -6.345326409234427e-11, -3.235510365984470e-13,
 -1.475089826157295e-15, -5.730092056497521e-18, -1.606828265661320e-20, -9.446831958527307e-25,  4.282888769655377e-25,  4.166544619268165e-27,  1.995195655117597e+00,
 -4.875880615076047e-05, -3.695164595397844e-07, -2.475018532402775e-09, -1.543125774941837e-11, -9.156772638373429e-14, -5.228236330576259e-16, -2.888377469754537e-18,
 -1.547744309731002e-20, -8.046162523436699e-23, -4.050832295533247e-25, -1.966719793999248e-27,  };
  constexpr double w[15360] = {  7.752705267573286e-02, -2.534137294754843e-04,  8.704741649558953e-07, -3.103417682645463e-09,  1.133990966340630e-11,
 -4.203502530048043e-14,  1.569064861021942e-16, -5.869716629549832e-19,  2.194096922612237e-21, -8.181438044286415e-24,  3.040498608935787e-26, -1.125693360667038e-28,
  7.718333154162280e-02, -3.647127890611929e-04,  2.006265043944457e-06, -1.107815656077442e-08,  5.938617767590113e-11, -3.086839295159401e-13,  1.562546290094926e-15,
 -7.735044477264056e-18,  3.756817945755180e-20, -1.794650363176910e-22,  8.448360767083052e-25, -3.925085571584852e-27,  7.650235431466899e-02, -5.837247908415225e-04,
  4.713878658200779e-06, -3.498823697497675e-08,  2.423769674766881e-10, -1.593691219281545e-12,  1.005404671104913e-14, -6.129349594441000e-17,  3.629509870406341e-19,
 -2.095625990583543e-21,  1.183352492264908e-23, -6.550539495587001e-26,  7.549678741453436e-02, -9.034492631811679e-04,  9.822810397999668e-06, -9.318123080058151e-08,
  8.054521562879561e-10, -6.497178883330387e-12,  4.961680907625239e-14, -3.622018823524973e-16,  2.545083757881713e-18, -1.730367718432812e-20,  1.142891037188279e-22,
 -7.356485874979565e-25,  7.418498853614029e-02, -1.313802658748820e-03,  1.847506766839321e-05, -2.186815314442548e-07,  2.308354965389012e-09, -2.238096288762893e-11,
  2.029332037153680e-13, -1.741669489379178e-15,  1.427088080435181e-17, -1.123542161395837e-19,  8.541312466853842e-22, -6.294065809188072e-24,  7.259028295385164e-02,
 -1.802085853494383e-03,  3.201371076807648e-05, -4.643185977952264e-07,  5.886412399030834e-09, -6.755498920809055e-11,  7.169702466064697e-13, -7.137770358571262e-15,
  6.733307589666707e-17, -6.063967522445168e-19,  5.243884975577655e-21, -4.373910519236249e-23,  7.074007170605193e-02, -2.353555772108631e-03,  5.185153425978054e-05,
 -9.073889262775312e-07,  1.362854497631459e-08, -1.828639427678304e-10,  2.245884406316751e-12, -2.565969333240071e-14,  2.758651238870015e-16, -2.814589530941840e-18,
  2.743104892998520e-20, -2.566755756589916e-22,  6.866482571845990e-02, -2.952063261700634e-03,  7.933209843126193e-05, -1.652498614862251e-06,  2.906314306581349e-08,
 -4.511761270774816e-10,  6.351045322542892e-12, -8.253056897577901e-14,  1.002679403802782e-15, -1.149665690811745e-17,  1.253086295949256e-19, -1.305648603141936e-21,
  6.639702390098860e-02, -3.580716966122643e-03,  1.155955449573358e-04, -2.831422921138796e-06,  5.771008512156538e-08, -1.027020150129091e-09,  1.643103324068995e-11,
 -2.409611624639433e-13,  3.284025086006246e-15, -4.202250276909165e-17,  5.088443120320054e-19, -5.866242478859674e-21,  6.397009256561767e-02, -4.222534003841759e-03,
  1.614605685465202e-04, -4.599212337324679e-06,  1.076209493169888e-07, -2.177402034368970e-09,  3.929445124113561e-11, -6.457898069435397e-13,  9.808878250861057e-15,
 -1.392104085856627e-16,  1.861688946994928e-18, -2.361335619340531e-20,  6.141739859070813e-02, -4.861042358626295e-03,  2.173317750583318e-04, -7.126303619787605e-06,
  1.897990293449326e-07, -4.332511135718657e-09,  8.758678735348449e-11, -1.602906550969625e-12,  2.697232329118859e-14, -4.221892747229802e-16,  6.202340794895684e-18,
 -8.611192402491412e-20,  5.877134042228349e-02, -5.480806397210105e-03,  2.831387609078694e-04, -1.058697148560979e-05,  3.183752747357884e-07, -8.141739165489939e-09,
  1.832067659408261e-10, -3.711583920088158e-12,  6.881167004188927e-14, -1.181781790983534e-15,  1.897859014912944e-17, -2.870714187757136e-19,  5.606257033577224e-02,
 -6.067854988320353e-03,  3.583099850578699e-04, -1.514499158868034e-05,  5.104222880195868e-07, -1.452670711578312e-08,  3.616722095617170e-10, -8.066509520700029e-12,
  1.639263367933620e-13, -3.074046097459829e-15,  5.371869331177093e-17, -8.813973727808810e-19,  5.331936956961605e-02, -6.610000404700607e-03,  4.417812636909105e-04,
 -2.093779946524853e-05,  7.853182768557337e-07, -2.471964000223864e-08,  6.771158773026531e-10, -1.653973350991427e-11,  3.666468671996097e-13, -7.473396180482733e-15,
  1.414974054240918e-16, -2.508013411188091e-18,  5.056718613118706e-02, -7.097044685063798e-03,  5.320358405510754e-04, -2.806066917673844e-05,  1.163623688918137e-06,
 -4.027340694534073e-08,  1.207235909221104e-09, -3.213750897259628e-11,  7.735567600805508e-13, -1.706451082684712e-14,  3.486286057349296e-16, -6.649464050683956e-18,
  4.782833424925508e-02, -7.520877698980489e-03,  6.271707281449448e-04, -3.655247585102840e-05,  1.665498027324058e-06, -6.302971323930786e-08,  2.057157492331844e-09,
 -5.940237974354225e-11,  1.545757083835684e-12, -3.675224330027294e-14,  8.070419174496613e-16, -1.650237130455693e-17,  4.512184534383799e-02, -7.875477279207337e-03,
  7.249825246609678e-04, -4.638445586121521e-05,  2.308752968076963e-06, -9.503481133333746e-08,  3.360875228310746e-09, -1.047989835713561e-10,  2.935824287305930e-12,
 -7.493719847777529e-14,  1.762084000036539e-15, -3.849050143346562e-17,  4.246345345688291e-02, -8.156826174332653e-03,  8.230652274834313e-04, -5.745307094853810e-05,
  3.106699362053989e-06, -1.383976934611357e-07,  5.278842774307731e-09, -1.769885251125859e-10,  5.316233136229735e-12, -1.451261145656628e-13,  3.641044788115460e-15,
 -8.467134809848416e-17,  3.986569350649152e-02, -8.362763160215093e-03,  9.189126293581031e-04, -6.957767002402524e-05,  4.065990162260681e-06, -1.950934686931960e-07,
  7.990445005503905e-09, -2.868705193933787e-10,  9.203350029766850e-12, -2.677129555836768e-13,  7.141492136048398e-15, -1.762135877134705e-16,  3.733808841686417e-02,
 -8.492786547415520e-03,  1.010018568279953e-03, -8.250318429001929e-05,  5.184681833504449e-06, -2.667234379182527e-07,  1.168057250268565e-08, -4.472615727908669e-10,
  1.526851157061313e-11, -4.715875335548568e-13,  1.333080985959254e-14, -3.478944232405714e-16,  3.488740086967877e-02, -8.547827785875414e-03,  1.093969434558799e-03,
 -9.590764542229782e-05,  6.450730370240901e-06, -3.542518760006974e-07,  1.652029978013890e-08, -6.720989963574343e-10,  2.432602006448541e-11, -7.950358745959058e-13,
  2.373745031746001e-14, -6.531387256446939e-16,  3.251792673166300e-02, -8.530011230823828e-03,  1.168524731544164e-03, -1.094139309003298e-04,  7.841105810601197e-06,
 -4.577462737426777e-07,  2.264265880953670e-08, -9.751072461391207e-10,  3.728804402934730e-11, -1.285247081689476e-12,  4.040215395382276e-14, -1.168508261568540e-15,
  3.023180969277114e-02, -8.442413757286287e-03,  1.231682963752604e-03, -1.226048486458083e-04,  9.321655842143707e-06, -5.761515643783005e-07,  3.011554963980691e-08,
 -1.367946268894206e-09,  5.507917903225680e-11, -1.995707482235509e-12,  6.584733993371474e-14, -1.995855605102216e-15,  2.802935985545105e-02, -8.288835141599801e-03,
  1.281731539404647e-03, -1.350404919762679e-04,  1.084778202628879e-05, -7.071288808431503e-07,  3.891475677548227e-08, -1.857963644115979e-09,  7.850911416933867e-11,
 -2.980913725571914e-12,  1.029199473119511e-13, -3.259801431566601e-15,  2.590936254752652e-02, -8.073587267581325e-03,  1.317280613782860e-03, -1.462767269770710e-04,
  1.236591977882446e-05, -8.469854511219717e-07,  4.890065943612019e-08, -2.445780540522854e-09,  1.081100727477894e-10, -4.288213168394861e-12,  1.544722107463317e-13,
 -5.098079524683762e-15,  2.386936715988809e-02, -7.801307498313397e-03,  1.337281796933181e-03, -1.558837064905571e-04,  1.381574382672248e-05, -9.907147192358987e-07,
  5.980238780843650e-08, -3.123033849660635e-09,  1.439552678576815e-10, -5.947170092473302e-12,  2.228694179971839e-13, -7.642930269610270e-15,  2.190594908986260e-02,
 -7.476799146627838e-03,  1.341033374358295e-03, -1.634634179951260e-04,  1.513296144639105e-05, -1.132155565125851e-06,  7.121280420965538e-08, -3.870651729313482e-09,
  1.854836725475436e-10, -7.957579534121167e-12,  3.093530843330662e-13, -1.099329972053365e-14,  2.001494074032963e-02, -7.104899974883956e-03,  1.328174144991033e-03,
 -1.686654421365241e-04,  1.625251141193098e-05, -1.264267821065586e-06,  8.259678032317006e-08, -4.658039613616036e-09,  2.313627441123923e-10, -1.027796091454750e-11,
  4.133365461844747e-13, -1.518005119803298e-14,  1.819162989765335e-02, -6.690378095432122e-03,  1.298668193036998e-03, -1.712002993035695e-04,  1.711195997355730e-05,
 -1.379509526713948e-06,  9.331388853584702e-08, -5.443489321036638e-09,  2.794223026065228e-10, -1.281687455361998e-11,  5.317570066089803e-13, -2.012930915131862e-14,
  1.643092566478397e-02, -6.237853519261293e-03,  1.252782920164259e-03, -1.708499704257243e-04,  1.765487683317752e-05, -1.470290859753024e-06,  1.026549893957376e-07,
 -6.175997149482690e-09,  3.266881655798982e-10, -1.542953117620372e-11,  6.586396224957572e-13, -2.563168943551164e-14,  1.472749348252405e-02, -5.751742871787285e-03,
  1.191062519679644e-03, -1.674753763994088e-04,  1.783398258231192e-05, -1.529471535777650e-06,  1.098904886474959e-07, -6.798501480261799e-09,  3.695331261350797e-10,
 -1.792177778609679e-11,  7.850316567103686e-13, -3.132660166293418e-14,  1.307586168655760e-02, -5.236224402657157e-03,  1.114298822803474e-03, -1.610207747696806e-04,
  1.761388164584144e-05, -1.550863467498398e-06,  1.143264819872526e-07, -7.252350147781928e-09,  4.039465169727401e-10, -2.006261416254869e-11,  8.994290040978787e-13,
 -3.671019538056801e-14,  1.147050259433264e-02, -4.695220294449240e-03,  1.023501132889321e-03, -1.515151744506918e-04,  1.697322787782567e-05, -1.529698999183451e-06,
  1.153638116197300e-07, -7.482612701509916e-09,  4.259042926090791e-10, -2.160502217255439e-11,  9.887430295364766e-13, -4.117241634416837e-14,  9.905891381561314e-03,
 -4.132393359801209e-03,  9.198663240634829e-04, -1.390709762852918e-04,  1.590620979663490e-05, -1.463027092824921e-06,  1.125543874318042e-07, -7.443694013228469e-09,
  4.318025569827956e-10, -2.231329881118495e-11,  1.039752676500000e-12, -4.406324939489065e-14,  8.376546105131544e-03, -3.551155461516479e-03,  8.047501484524935e-04,
 -1.238801204571982e-04,  1.442328549229378e-05, -1.350005110193678e-06,  1.056490721734657e-07, -7.104610761522681e-09,  4.189023442166593e-10, -2.199358420838459e-11,
  1.040875016859220e-12, -4.478150264343202e-14,  6.877052378892381e-03, -2.954685409217585e-03,  6.796404070519158e-04, -1.062080673824973e-04,  1.255114070249426e-05,
 -1.192061744773605e-06,  9.463201468098396e-08, -6.453279846603064e-09,  3.857254111977164e-10, -2.052320175106857e-11,  9.839925250759186e-13, -4.287298954243024e-14,
  5.402077242350734e-03, -2.345954976707374e-03,  5.461324871780720e-04, -8.638597527582846e-05,  1.033188660734504e-05, -9.929165997163961e-07,  7.973749244317378e-08,
 -5.499245204662318e-09,  3.323419802723368e-10, -1.787406111798652e-11,  8.660229169276867e-13, -3.812048498506530e-14,  3.946383896529284e-03, -1.727765297251317e-03,
  4.059083036474924e-04, -6.480155908243521e-05,  7.821565523283815e-06, -7.584540827432172e-07,  6.144705634043609e-08, -4.274436168848960e-09,  2.605027010535953e-10,
 -1.412589082185380e-11,  6.899266059240025e-13, -3.060692678727678e-14,  2.504925701778093e-03, -1.102825830759512e-03,  2.607265145421729e-04, -4.189023411388071e-05,
  5.088202365770870e-06, -4.964736781175599e-07,  4.046776994131632e-08, -2.831849765160234e-09,  1.735912291868328e-10, -9.466657690195580e-12,  4.649334100714017e-13,
 -2.073721414786789e-14,  1.074493150607875e-03, -4.745252292626861e-04,  1.125782088640943e-04, -1.815176620185505e-05,  2.212549774803061e-06, -2.166315048266524e-07,
  1.771744383936064e-08, -1.243931137885210e-09,  7.649897651844227e-11, -4.184982589325917e-12,  2.061696015267027e-13, -9.223283974161315e-15,  7.652709375665481e-02,
 -2.465958783402771e-04,  8.342946888159984e-07, -2.928505574656983e-09,  1.053557534056254e-11, -3.845882224721577e-14,  1.414115760716509e-16, -5.212476917051554e-19,
  1.920314438368676e-21, -7.058706920763421e-24,  2.586366223620164e-26, -9.442197562675442e-29,  7.575576088811341e-02, -3.491787235018289e-04,  1.878830911591249e-06,
 -1.017540085413544e-08,  5.357064467897897e-11, -2.736516915965088e-13,  1.361868939841616e-15, -6.630035635819025e-18,  3.167630887794246e-20, -1.488855674194465e-22,
  6.897468029665691e-25, -3.154194374532015e-27,  7.424030808669747e-02, -5.476296104524139e-04,  4.316277096056395e-06, -3.135264637720621e-08,  2.127835991317479e-10,
 -1.371742859077835e-12,  8.489709422933049e-15, -5.080014056657546e-17,  2.953772980499989e-19, -1.675232121549726e-21,  9.294813605204873e-24, -5.056930004275291e-26,
  7.203337033732722e-02, -8.291298679187247e-04,  8.777871440235093e-06, -8.127213426484966e-08,  6.866403689728759e-10, -5.419417818417485e-12,  4.052764848958800e-14,
 -2.899034164393615e-16,  1.997196924679946e-18, -1.331907615102134e-20,  8.632400228992038e-23, -5.454342083988667e-25,  6.920960281394083e-02, -1.175903336880990e-03,
  1.605853395273569e-05, -1.850798790997034e-07,  1.905741222196261e-09, -1.804767778775791e-11,  1.599958030759523e-13, -1.343629274679275e-15,  1.077975730795990e-17,
 -8.314490781713531e-20,  6.195415719530662e-22, -4.476762592223246e-24,  6.586100296123203e-02, -1.566759285707821e-03,  2.696524971507591e-05, -3.800736844545383e-07,
  4.692374720995854e-09, -5.252132954366679e-11,  5.442642772330169e-13, -5.295399284792164e-15,  4.885647563518108e-17, -4.306154063005406e-19,  3.646444677017382e-21,
 -2.979801835857726e-23,  6.209140108077597e-02, -1.978851272158642e-03,  4.215937714391857e-05, -7.158892666218805e-07,  1.045686617626671e-08, -1.366734119683918e-10,
  1.637158864321778e-12, -1.826172207171928e-14,  1.918407110936689e-16, -1.913932375390938e-18,  1.825135205469280e-20, -1.671943977787859e-22,  5.801061576056366e-02,
 -2.389456866337865e-03,  6.201922755866159e-05, -1.252119782532011e-06,  2.139392487660323e-08, -3.232060520177005e-10,  4.433466419947866e-12, -5.620173520603852e-14,
  6.666989853657642e-16, -7.469858460269557e-18,  7.961455251102099e-20, -8.116600430362728e-22,  5.372876156832768e-02, -2.777596209755998e-03,  8.654441942172750e-05,
 -2.053055636090527e-06,  4.062254427802649e-08, -7.030322220168736e-10,  1.095326867874967e-11, -1.566040246096591e-13,  2.082845847923128e-15, -2.603083105385837e-17,
  3.080797186066860e-19, -3.473714404719012e-21,  4.935113343465124e-02, -3.125343620485311e-03,  1.153151439688068e-04, -3.179985931891007e-06,  7.220430489157307e-08,
 -1.420014734779385e-09,  2.494509028588502e-11, -3.995325404433712e-13,  5.919968716907947e-15, -8.203248467281110e-17,  1.071928958078309e-18, -1.329410592244933e-20,
  4.497398911548211e-02, -3.418737987900081e-03,  1.475095158081438e-04, -4.682177110671463e-06,  1.209843988483219e-07, -2.683971969061790e-09,  5.280685825947287e-11,
 -9.416407360804335e-13,  1.545467236283652e-14, -2.361546781181165e-16,  3.389476707905880e-18, -4.600823956442491e-20,  4.068142628375533e-02, -3.648255029304590e-03,
  1.819726743398793e-04, -6.588057866042359e-06,  1.922286577864798e-07, -4.777671796818020e-09,  1.046311389929592e-10, -2.065415883890744e-12,  3.734899287868379e-14,
 -6.261944488427304e-16,  9.825059937724245e-18, -1.453028031026438e-19,  3.654342302001744e-02, -3.808858434522850e-03,  2.173239584842768e-04, -8.898193900195366e-06,
  2.910726805909159e-07, -8.053277352747956e-09,  1.951803166993139e-10, -4.242485393668217e-12,  8.410697096104245e-14, -1.540021657930812e-15,  2.629780088504526e-17,
 -4.219478184562143e-19,  3.261499607578421e-02, -3.899690278084950e-03,  2.520843407765182e-04, -1.158133465451148e-05,  4.218448919113780e-07, -1.291471261856474e-08,
  3.445074230728764e-10, -8.204269873263231e-12,  1.774843143374063e-13, -3.533530925916686e-15,  6.539714691594564e-17, -1.133897003318931e-18,  2.893634187335293e-02,
 -3.923489517872028e-03,  2.848056340114649e-04, -1.457425009955681e-05,  5.873614304916332e-07, -1.978468838775773e-08,  5.778959525395711e-10, -1.500649499846985e-11,
  3.526788196403159e-13, -7.602726577693243e-15,  1.519008284460119e-16, -2.835402517502751e-18,  2.553376672180806e-02, -3.885839746137500e-03,  3.141853248115991e-04,
 -1.778539678357773e-05,  7.883070586096924e-07, -2.905824963470709e-08,  9.248285870786965e-10, -2.606793640013041e-11,  6.627446882962487e-13, -1.540798829038660e-14,
  3.310840236925070e-16, -6.629342420819507e-18,  2.242118568440238e-02, -3.794345152037961e-03,  3.391553112141089e-04, -2.110181577469896e-05,  1.022808256142304e-06,
 -4.104792718106058e-08,  1.416822584802353e-09, -4.316069270978105e-11,  1.182231806309499e-12, -2.952910047514959e-14,  6.799386099579989e-16, -1.455388831642306e-17,
  1.960197012958635e-02, -3.657820306028630e-03,  3.589381944140010e-04, -2.439819707753703e-05,  1.286274405428401e-06, -5.592805391571034e-08,  2.084173324400452e-09,
 -6.833145323479233e-11,  2.008680882160207e-12, -5.370377658865753e-14,  1.320483158743516e-15, -3.011417743798604e-17,  1.707094570855331e-02, -3.485559173687034e-03,
  3.730700339837059e-04, -2.754681565821987e-05,  1.571538127789082e-06, -7.368685910286264e-08,  2.951885267838103e-09, -1.037416944338065e-10,  3.260467021770929e-12,
 -9.297605944731582e-14,  2.432973156720915e-15, -5.892516447470995e-17,  1.481637770646545e-02, -3.286725959472277e-03,  3.813928143645224e-04, -3.042706125164006e-05,
  1.869276984604732e-06, -9.409427667803431e-08,  4.035283971901298e-09, -1.514287555591856e-10,  5.069715496012321e-12, -1.536632926929171e-13,  4.265267527357128e-15,
 -1.093630367181322e-16,  1.282182208489662e-02, -3.069888508791954e-03,  3.840228291508646e-04, -3.293350371584929e-05,  2.168656338989378e-06, -1.166911390296059e-07,
  5.335937835430027e-09, -2.130066979734304e-10,  7.569670635912692e-12, -2.430513871949585e-13,  7.133346192015409e-15, -1.930402561333011e-16,  1.106776198715436e-02,
 -2.842696522442092e-03,  3.813026540712054e-04, -3.498178255538793e-05,  2.458104893831065e-06, -1.408021064498890e-07,  6.838536559293761e-09, -2.893418728033435e-10,
  1.087691698845272e-11, -3.687551735588735e-13,  1.140760820215327e-14, -3.248471003352036e-16,  9.532986660389851e-03, -2.611693070705628e-03,  3.737445086473887e-04,
 -3.651199965284533e-05,  2.726123844369856e-06, -1.655710478400420e-07,  8.509266640896730e-09, -3.802491615754527e-10,  1.507004244168495e-11, -5.377347680977183e-13,
  1.748065364946886e-14, -5.222735163435220e-16,  8.195700100723256e-03, -2.382239131829307e-03,  3.619719290260684e-04, -3.748965524869514e-05,  2.962037046445925e-06,
 -1.900143864830833e-07,  1.029601511767213e-08, -4.842578850072189e-10,  2.016742534692070e-11, -7.550328268001537e-13,  2.571501363548090e-14, -8.037719560800469e-16,
  7.034369268378756e-03, -2.158526669290100e-03,  3.466651832951779e-04, -3.790444836121138e-05,  3.156609182773691e-06, -2.130857225904036e-07,  1.213046669250307e-08,
 -5.984902636018614e-10,  2.610754258573001e-11, -1.022376442209824e-12,  3.637351091179486e-14, -1.186063778109164e-15,  6.028336663231705e-03, -1.943655204820917e-03,
  3.285141274872436e-04, -3.776744006263661e-05,  3.302485951754546e-06, -2.337441239219007e-07,  1.393189138125708e-08, -7.186811104332198e-10,  3.273532585683316e-11,
 -1.336852183503103e-12,  4.953985285311777e-14, -1.680521868094429e-15,  5.158230382912838e-03, -1.739748865701462e-03,  3.081805215810991e-04, -3.710715089034905e-05,
  3.394438973480515e-06, -2.510188192701359e-07,  1.561220020655725e-08, -8.393480151501327e-10,  3.979756396055410e-11, -1.689895323271280e-12,  6.504152853831964e-14,
 -2.289041609801440e-15,  4.406207877211542e-03, -1.548094444396575e-03,  2.862703973189133e-04, -3.596514873611027e-05,  3.429423601826164e-06, -2.640643794397186e-07,
  1.708170967375954e-08, -9.541005005307937e-10,  4.694923672861598e-11, -2.066822807417901e-12,  8.238984992154289e-14, -3.000075473934977e-15,  3.756068919941717e-03,
 -1.369285228460597e-03,  2.633159933285762e-04, -3.439160646444717e-05,  3.406477039016539e-06, -2.722024318619138e-07,  1.825501511999235e-08, -1.056058339993080e-09,
  5.377117776524415e-11, -2.447081959705561e-12,  1.007520455857801e-13, -3.785676080933299e-15,  3.193270180327778e-03, -1.203359583623039e-03,  2.397660677191225e-04,
 -3.244119685105516e-05,  3.326495779969774e-06, -2.749481056035970e-07,  1.905642144315769e-08, -1.138336364446653e-09,  5.979787717993172e-11, -2.805291747005916e-12,
  1.189672511029053e-13, -4.600402131365201e-15,  2.704869298071085e-03, -1.049927076214837e-03,  2.159830283784785e-04, -3.016957057120714e-05,  3.191935724552685e-06,
 -2.720213809065797e-07,  1.942449501295426e-08, -1.194547194160545e-09,  6.455283359314053e-11, -3.113037513138465e-12,  1.356123319680608e-13, -5.382756903034632e-15,
  2.279421387805737e-03, -9.082780749902328e-04,  1.922452201509614e-04, -2.763054918876039e-05,  3.006476597004698e-06, -2.633450717629659e-07,  1.931545295742298e-08,
 -1.219274429656223e-09,  6.758786918285573e-11, -3.341264424952542e-12,  1.491156937659028e-13, -6.059462003079164e-15,  1.906845998071200e-03, -7.774752032340967e-04,
  1.687527989426700e-04, -2.487407076824547e-05,  2.774686430145577e-06, -2.490321795076079e-07,  1.870526550412160e-08, -1.208475704323674e-09,  6.852235650478601e-11,
 -3.463019738687666e-12,  1.579090078322621e-13, -6.552378875582230e-15,  1.578278084097990e-03, -6.564267515573546e-04,  1.456358326070901e-04, -2.194485594553715e-05,
  2.501713693344281e-06, -2.293658121121727e-07,  1.759048902740017e-08, -1.159785661387798e-09,  6.707838730445378e-11, -3.456234751843686e-12,  1.605996640530381e-13,
 -6.787371469642912e-15,  1.285912709830852e-03, -5.439433048781196e-04,  1.229635367985076e-04, -1.888171732461217e-05,  2.193025799832016e-06, -2.047748432857498e-07,
  1.598795582640087e-08, -1.072701174288704e-09,  6.310846565627605e-11, -3.306221910589449e-12,  1.561420957577284e-13, -6.703963181318562e-15,  1.022850052178571e-03,
 -4.387795132111793e-04,  1.007538376693688e-04, -1.571741226474760e-05,  1.854204459337315e-06, -1.758081125248307e-07,  1.393351470965081e-08, -9.486430453508765e-10,
  5.661319599901942e-11, -3.007591075364486e-12,  1.439847679734577e-13, -6.264375918429883e-15,  7.829449245414835e-04, -3.396633161244980e-04,  7.898273352637158e-05,
 -1.247893561710099e-05,  1.490801597812144e-06, -1.431093976127013e-07,  1.148004679138501e-08, -7.908986938185498e-10,  4.774751043427916e-11, -2.565355095909627e-12,
  1.241718444648201e-13, -5.460512574659636e-15,  5.606641162200409e-04, -2.453154447741799e-04,  5.759326263905937e-05, -9.188171751597903e-06,  1.108256145101586e-06,
 -1.073948933461144e-07,  8.694991901821652e-09, -6.044590503210028e-10,  3.681514292080194e-11, -1.995090237307746e-12,  9.738412456351193e-14, -4.317678793310163e-15,
  3.509626843998736e-04, -1.544660446612414e-04,  3.650504536207843e-05, -5.862995026429393e-06,  7.118872140757279e-07, -6.943610484482543e-08,  5.657745280060349e-09,
 -3.957785048576912e-10,  2.425272763712880e-11, -1.322157660100843e-12,  6.491334708414934e-14, -2.894367152378106e-15,  1.493828935915383e-04, -6.596066523587580e-05,
  1.564582875469223e-05, -2.522201683488159e-06,  3.073765182163829e-07, -3.008961527509816e-08,  2.460449138807926e-09, -1.727145877056423e-10,  1.061961464273170e-11,
 -5.808558378606468e-13,  2.861027463763744e-14, -1.279696592060674e-15,  7.555384036196024e-02, -2.400592807043501e-04,  8.001392383882404e-07, -2.765910220360872e-09,
  9.799190399933178e-12, -3.523336764713803e-14,  1.276401177064358e-16, -4.636716225900809e-19,  1.683864099240036e-21, -6.102622564463469e-24,  2.204996064935919e-26,
 -7.939170853148833e-29,  7.438835399511770e-02, -3.346223289527695e-04,  1.761693858014286e-06, -9.360340051642970e-09,  4.840999409486603e-11, -2.430847561409055e-13,
  1.189649608304936e-15, -5.697086871950193e-18,  2.678134894611958e-20, -1.238812743971175e-22,  5.649132860258235e-25, -2.543285675708159e-27,  7.211654632499415e-02,
 -5.145484590208097e-04,  3.959601798629171e-06, -2.815698215802452e-08,  1.872763500426143e-10, -1.184043859023739e-12,  7.191055617457400e-15, -4.224537882808242e-17,
  2.412578832869027e-19, -1.344371423491708e-21,  7.330859270414689e-24, -3.920903533224295e-26,  6.885137335229048e-02, -7.626291000193569e-04,  7.865110437387215e-06,
 -7.110278255836138e-08,  5.873566740176650e-10, -4.537360270074266e-12,  3.323750695292519e-14, -2.330427239391987e-16,  1.574486530603669e-18, -1.030205895269492e-20,
  6.553652566823752e-23, -4.065805905579427e-25,  6.474955720922744e-02, -1.055826675604424e-03,  1.400925757946472e-05, -1.572791373395651e-07,  1.580329617083329e-09,
 -1.462286215339804e-11,  1.267855264231962e-13, -1.042145888451645e-15,  8.188908926238385e-18, -6.189547592836022e-20,  4.521750950981820e-22, -3.204765748286801e-24,
  5.999822635084499e-02, -1.368079958312152e-03,  2.282233789572182e-05, -3.127367888632917e-07,  3.761417307983022e-09, -4.107495358761093e-11,  4.157370779410566e-13,
 -3.954254147751504e-15,  3.569180121572114e-17, -3.079584242357656e-19,  2.554277072857113e-21, -2.045475178354115e-23,  5.479989646181458e-02, -1.673289360904062e-03,
  3.448882933974312e-05, -5.684744383180127e-07,  8.078230696820333e-09, -1.028828039214008e-10,  1.202344042160880e-12, -1.309757443159757e-14,  1.344811917404383e-16,
 -1.312281721252228e-18,  1.224739280577779e-20, -1.098644343334766e-22,  4.935754666746171e-02, -1.948041851330018e-03,  4.885165388123549e-05, -9.562433597159346e-07,
  1.587784989328067e-08, -2.335039739787257e-10,  3.122080222147565e-12, -3.861904658569228e-14,  4.474278741183139e-16, -4.899840361997130e-18,  5.107765745404656e-20,
 -5.096155971965072e-22,  4.386135387320724e-02, -2.173720893283559e-03,  6.538601136560862e-05, -1.502662698811999e-06,  2.887104363657182e-08, -4.860288702711509e-10,
  7.375961121489190e-12, -1.028383374277238e-13,  1.335055458033009e-15, -1.629957223155759e-17,  1.885860039829328e-19, -2.080071318220265e-21,  3.847824798753693e-02,
 -2.337786742562208e-03,  8.324554806508962e-05, -2.222841684151460e-06,  4.898473794706917e-08, -9.366278215033161e-10,  1.601933691710553e-11, -2.500925711354949e-13,
  3.615642085293913e-15, -4.892608802037938e-17,  6.247930443181498e-19, -7.577727889693746e-21,  3.334493705608486e-02, -2.434171609635025e-03,  1.013672514211019e-04,
 -3.115053238481653e-06,  7.810156272813785e-08, -1.684124017306543e-09,  3.225241114401500e-11, -5.604578818451710e-13,  8.973052370790785e-15, -1.338691424834955e-16,
  1.877401343681067e-18, -2.491754992140074e-20,  2.856452625204194e-02, -2.462878446419592e-03,  1.186102204571112e-04, -4.157863200499274e-06,  1.177208825473884e-07,
 -2.843848802424799e-09,  6.061886922689576e-11, -1.166056845255291e-12,  2.056815976229323e-14, -3.366784294467815e-16,  5.161469603664775e-18, -7.463725536539017e-20,
  2.420640551085235e-02, -2.428976092083866e-03,  1.338994035837748e-04, -5.310548356186147e-06,  1.686066637827026e-07, -4.535071567291430e-09,  1.069969978020270e-10,
 -2.266629320675432e-12,  4.383815202923476e-14, -7.837757370572367e-16,  1.307895337111362e-17, -2.052179336187000e-19,  2.030876438248726e-02, -2.341235108487517e-03,
  1.463483489935691e-04, -6.516836419854035e-06,  2.305019015882702e-07, -6.863031135112671e-09,  1.782801320793838e-10, -4.139083046868996e-12,  8.737980816682758e-14,
 -1.699129915356708e-15,  3.073861415729848e-17, -5.213398028745278e-19,  1.688293076973879e-02, -2.210649128246353e-03,  1.553430319239079e-04, -7.711229337588782e-06,
  3.019809150660706e-07, -9.898400794090245e-09,  2.816980327421482e-10, -7.134771792078813e-12,  1.637047283844762e-13, -3.448284461651317e-15,  6.737221344616335e-17,
 -1.230644920435283e-18,  1.391871204715851e-02, -2.049047367228162e-03,  1.605790790189692e-04, -8.826645503820671e-06,  3.804816485405071e-07, -1.365825834154860e-08,
  4.238193305617729e-10, -1.165912972404486e-11,  2.895635353182543e-13, -6.581735081381545e-15,  1.383742962725635e-16, -2.712778725600115e-18,  1.139000987301880e-02,
 -1.867941753639247e-03,  1.620544408897326e-04, -9.801949524995917e-06,  4.625193585274577e-07, -1.809282297559247e-08,  6.093729741387213e-10, -1.813135892189452e-11,
  4.855097828072817e-13, -1.186431838303226e-14,  2.674690788736239e-16, -5.609049332174584e-18,  9.260140925758593e-03, -1.677683764708590e-03,  1.600267795637063e-04,
 -1.058812088635038e-05,  5.440431545698941e-07, -2.308123486459943e-08,  8.401014245548456e-10, -2.692663536248354e-11,  7.744509942085819e-13, -2.027384520346945e-14,
  4.884414622947902e-16, -1.092151684383456e-17,  7.486482612211652e-03, -1.486944964097011e-03,  1.549486304213751e-04, -1.115224086954865e-05,  6.208688331982234e-07,
 -2.843776607053675e-08,  1.113882771737384e-09, -3.830849265007665e-11,  1.179121525874808e-12, -3.295299202843698e-14,  8.456492236613190e-16, -2.009805276995221e-17,
  6.024241519879466e-03, -1.302489562109506e-03,  1.473938769563370e-04, -1.147900181768848e-05,  6.891114530603595e-07, -3.392762458373591e-08,  1.424321554262486e-09,
 -5.236301352396526e-11,  1.718675085750700e-12, -5.110484901090204e-14,  1.392474068197481e-15, -3.506847447877685e-17,  4.829290805485186e-03, -1.129179907098067e-03,
  1.379870494579648e-04, -1.156992409159145e-05,  7.455492402842777e-07, -3.928957694036194e-08,  1.760917840573601e-09, -6.894780536901613e-11,  2.404862731492867e-12,
 -7.583409229495979e-14,  2.187064903407630e-15, -5.819145906055833e-17,  3.860130473353669e-03, -9.701452938284460e-04,  1.273435325157017e-04, -1.144080805015208e-05,
  7.878718059597690e-07, -4.426145175408080e-08,  2.109806743399040e-09, -8.766685227417611e-11,  3.238451043984079e-12, -1.079499921969550e-13,  3.285202230793215e-15,
 -9.207761198393778e-17,  3.079090879265024e-03, -8.270469491162926e-04,  1.160249984376909e-04, -1.111811317314569e-05,  8.147929039022899e-07, -4.860439819842203e-08,
  2.454948528170144e-09, -1.078776454173745e-10,  4.206578963356230e-12, -1.477604157691729e-13,  4.730792534506330e-15, -1.392733106860024e-16,  2.452930453308645e-03,
 -7.003827308839188e-04,  1.045110614771591e-04, -1.063495710293048e-05,  8.260337949665201e-07, -5.212246587874384e-08,  2.779570990406453e-09, -1.287307754028744e-10,
  5.281627634929112e-12, -1.948935353092968e-13,  6.545218688262008e-15, -2.018208313986244e-16,  1.952982357600453e-03, -5.897894820723748e-04,  9.318570863271372e-05,
 -1.002730947539773e-05,  8.222025185897153e-07, -5.467533937645621e-08,  3.067636373922013e-09, -1.492360868533901e-10,  6.421914202638816e-12, -2.481833842345537e-13,
  8.717316833719108e-15, -2.807460861944291e-16,  1.554990922070762e-03, -4.943156692543553e-04,  8.233562494144315e-05, -9.330775922593787e-06,  8.046046740432371e-07,
 -5.618351469375240e-08,  3.305125069784973e-09, -1.683450315115336e-10,  7.574186976422336e-12, -3.056463570603881e-13,  1.119594161305222e-14, -3.755562018005180e-16,
  1.238755451967118e-03, -4.126497136636870e-04,  7.215698531050984e-05, -8.578178096067763e-06,  7.750229892950114e-07, -5.662650067417345e-08,  3.480985386786110e-09,
 -1.850368922626461e-10,  8.677580901110170e-12, -3.645603747707047e-13,  1.388683441096229e-14, -4.838453494593775e-16,  9.876726576890295e-04, -3.432992421767943e-04,
  6.276740130413371e-05, -7.797972460159577e-06,  7.354980797107641e-07, -5.603554165498923e-08,  3.587673906923942e-09, -1.983972019826579e-10,  9.668462443575329e-12,
 -4.216405942295736e-13,  1.665486340194917e-14, -6.011023370874226e-16,  7.882437149040870e-04, -2.847231653338874e-04,  5.422023081899475e-05, -7.013432829527619e-06,
  6.881341744658609e-07, -5.448280704139897e-08,  3.621285284613282e-09, -2.076794022359226e-10,  1.048549417371886e-11, -4.732895160105740e-13,  1.933181114723343e-14,
 -7.207869114561618e-16,  6.295901767405315e-04, -2.354223873637847e-04,  4.651915339654612e-05, -6.242452963021046e-06,  6.349438756514758e-07, -5.206901930308373e-08,
  3.581329476409489e-09, -2.123446497318886e-10,  1.107428539851706e-11, -5.158885567391529e-13,  2.172895682621385e-14, -8.346989209002062e-16,  5.030055864226849e-04,
 -1.939966842243018e-04,  3.963161677869306e-05, -5.497799571216134e-06,  5.777372036247405e-07, -4.891120902857353e-08,  3.470250894342777e-09, -2.120786950947453e-10,
  1.139113764973937e-11, -5.460943121328495e-13,  2.365294150173430e-14, -9.336151311324503e-16,  4.015566996167053e-04, -1.591755143436454e-04,  3.350036956019087e-05,
 -4.787651430430162e-06,  5.180534135392362e-07, -4.513183436527662e-08,  3.292797146403622e-09, -2.067881368605023e-10,  1.140559540180096e-11, -5.611056652017350e-13,
  2.492295945039806e-14, -1.008123460635419e-15,  3.197392095399825e-04, -1.298298428894528e-04,  2.805276460546235e-05, -4.116284630953235e-06,  4.571297152636638e-07,
 -4.085000947315135e-08,  3.055338985854849e-09, -1.965806316360023e-10,  1.110172295436774e-11, -5.588759088752871e-13,  2.538723840225020e-14, -1.049552735738958e-15,
  2.531870305255355e-04, -1.049709231078743e-04,  2.320784232003046e-05, -3.484796763302760e-06,  3.958989137011909e-07, -3.617514475739537e-08,  2.765224376307211e-09,
 -1.817346981660064e-10,  1.047820736260030e-11, -5.382546907715389e-13,  2.493701903406952e-14, -1.050882803708264e-15,  1.984307584787203e-04, -8.374070680736407e-05,
  1.888139966873282e-05, -2.891796409123756e-06,  3.350076266918597e-07, -3.120296220127833e-08,  2.430224988042890e-09, -1.626647337584008e-10,  9.547510276244582e-12,
 -4.990553643891952e-13,  2.351671880355791e-14, -1.007525405403893e-15,  1.526991894898417e-04, -6.539734788548672e-05,  1.498934859029610e-05, -2.334014043161760e-06,
  2.748475592973145e-07, -2.601362844898621e-08,  2.058108594393136e-09, -1.398860655831215e-10,  8.334351329705122e-12, -4.420523162166989e-13,  2.112954146266949e-14,
 -9.178871502666963e-16,  1.137571785166771e-04, -4.929822632148634e-05,  1.144969760468410e-05, -1.806814474297384e-06,  2.155938114429769e-07, -2.067163993142749e-08,
  1.656349675265950e-09, -1.139836423072998e-10,  6.873809498104392e-12, -3.689189825436708e-13,  1.783835728781010e-14, -7.836566352646712e-16,  7.977331609421509e-05,
 -3.488213621050706e-05,  8.183489762805918e-06, -1.304610579460126e-06,  1.572461572580485e-07, -1.522709499032614e-08,  1.231976495603643e-09, -8.558674931629596e-11,
  5.209298089677570e-12, -2.821207012028362e-13,  1.376216584434582e-14, -6.097928564482652e-16,  4.921260162554801e-05, -2.165220209944088e-05,  5.115127312794288e-06,
 -8.212114393286186e-07,  9.967350041537217e-08, -9.718277708064191e-09,  7.915633007831926e-10, -5.535231993984109e-11,  3.390694803172561e-12, -1.847817025959538e-13,
  9.069021214098811e-15, -4.042352693290000e-16,  2.077670884887715e-05, -9.172485818941823e-06,  2.175286398178772e-06, -3.505997999315499e-07,  4.271855726519888e-08,
 -4.180972136433656e-09,  3.418147180202490e-10, -2.398955633144276e-11,  1.474755200696416e-12, -8.064894564465236e-14,  3.971665787684170e-15, -1.776149109325937e-16,
  7.460619895139771e-02, -2.337883176028634e-04,  7.678663113486384e-07, -2.614598377221657e-09,  9.124135696262636e-12, -3.231990671131184e-14,  1.153798312028518e-16,
 -4.131394558272359e-19,  1.479239073482517e-21, -5.286647264836881e-24,  1.883965092168574e-26, -6.691123832156889e-29,  7.307735850986265e-02, -3.209652665652278e-04,
  1.653861581857957e-06, -8.623174949282442e-09,  4.382137743916958e-11, -2.163545154873819e-13,  1.041488645263660e-15, -4.907287872078779e-18,  2.270278190553469e-20,
 -1.033717664811113e-22,  4.640975769673469e-25, -2.057441639176456e-27,  7.011963580272151e-02, -4.841739813670633e-04,  3.638944386094073e-06, -2.534101747247341e-08,
  1.652298396612304e-10, -1.024823359232996e-12,  6.109377572103836e-15, -3.524609831989467e-17,  1.977480732308224e-19, -1.082916902744741e-21,  5.805007486411942e-24,
 -3.052941105361372e-26,  6.592151170158832e-02, -7.029680148804202e-04,  7.065403200281572e-06, -6.238983206286588e-08,  5.040859623876903e-10, -3.812594543739647e-12,
  2.736534015006087e-14, -1.881202125076605e-16,  1.246785517059544e-18, -8.006103467418543e-21,  5.000242053831086e-23, -3.046573445814770e-25,  6.073902425147044e-02,
 -9.508933637089564e-04,  1.226447814665223e-05, -1.341776067696075e-07,  1.316082044380627e-09, -1.190250003047482e-11,  1.009624718282167e-13, -8.125200080578893e-16,
  6.254905978086028e-18, -4.634211041266325e-20,  3.320074508492724e-22, -2.308557688680581e-24,  5.486866221759543e-02, -1.199548605207852e-03,  1.940514155357498e-05,
 -2.586194304920285e-07,  3.031352858733628e-09, -3.230641172438286e-11,  3.194722311320317e-13, -2.971416373745120e-15,  2.624635910990523e-17, -2.217504284977638e-19,
  1.801967006253103e-21, -1.414449908670008e-23,  4.861826421051926e-02, -1.422615001435708e-03,  2.837950148779831e-05, -4.542326068711356e-07,  6.281771435556988e-09,
 -7.798153940782940e-11,  8.893804997041257e-13, -9.464208904466139e-15,  9.500437877679477e-17, -9.069852249654523e-19,  8.286500370674157e-21, -7.280698029756268e-23,
  4.227999160725112e-02, -1.599139716074370e-03,  3.875914341909720e-05, -7.358277071546701e-07,  1.187719961357264e-08, -1.700820539982862e-10,  2.217252869021678e-12,
 -2.676939094516225e-14,  3.029772900479505e-16, -3.243759145386861e-18,  3.307996253625208e-20, -3.230729642947927e-22,  3.610862977882962e-02, -1.715588493227050e-03,
  4.983357603888596e-05, -1.109770999743427e-06,  2.071028450738140e-08, -3.392261748279972e-10,  5.015806619714106e-12, -6.821124445784760e-14,  8.645432502816397e-16,
 -1.031338671181692e-17,  1.166755781845856e-19, -1.259126806568563e-21,  3.030718455925869e-02, -1.766493801238778e-03,  6.071749254897919e-05, -1.570222044072822e-06,
  3.359085506808092e-08, -6.245905868564798e-10,  1.040271080349717e-11, -1.583348545458883e-13,  2.233876677805360e-15, -2.952430004793706e-17,  3.685223623460062e-19,
 -4.371652301373277e-21,  2.502031311556623e-02, -1.753823456999609e-03,  7.049578660280941e-05, -2.097635072925055e-06,  5.103906389482246e-08, -1.069916865227315e-09,
  1.994712221951668e-11, -3.378401252544528e-13,  5.277069858913628e-15, -7.687685034107444e-17,  1.053583138541542e-18, -1.367462101335061e-20,  2.033486979313828e-02,
 -1.685413260170379e-03,  7.836878334499844e-05, -2.660191262343168e-06,  7.308939051553048e-08, -1.716335682317642e-09,  3.561244411956279e-11, -6.676062136749513e-13,
  1.148790177796440e-14, -1.836068284648350e-16,  2.750526644681343e-18, -3.889343796395353e-20,  1.628597039258811e-02, -1.572909609615999e-03,  8.376511377201616e-05,
 -3.217957100020519e-06,  9.916427406017193e-08, -2.593068088148148e-09,  5.955801803061539e-11, -1.229674591435227e-12,  2.320272534047321e-14, -4.050792656701663e-16,
  6.605804485452330e-18, -1.013644741912071e-19,  1.286656606008578e-02, -1.429656189783582e-03,  8.640254096305493e-05, -3.728781721382816e-06,  1.280618455694302e-07,
 -3.708103821364816e-09,  9.379915735765121e-11, -2.123001855064966e-12,  4.373575711096339e-14, -8.306387938897985e-16,  1.468830214062062e-17, -2.436821262484165e-19,
  1.003853482114935e-02, -1.268862656555561e-03,  8.629257028945919e-05, -4.154522836585746e-06,  1.580714743677980e-07, -5.041410427254715e-09,  1.397745147911243e-10,
 -3.452668108778619e-12,  7.733647488686186e-14, -1.591650941445398e-15,  3.040771724545305e-17, -5.435071276096911e-19,  7.743628541650648e-03, -1.102255922882687e-03,
  8.369796365210066e-05, -4.466227118405199e-06,  1.871950316589465e-07, -6.542831009503903e-09,  1.979137754813878e-10, -5.312991402176456e-12,  1.288835574419171e-13,
 -2.863762377404376e-15,  5.890111495312224e-17, -1.130471877758778e-18,  5.913107931835161e-03, -9.392772768945532e-04,  7.906030670577244e-05, -4.647308212729301e-06,
  2.134237906529412e-07, -8.135671508326253e-09,  2.673177632321752e-10, -7.767152920372485e-12,  2.032831847844518e-13, -4.859221708348693e-15,  1.072347939776911e-16,
 -2.202862674897665e-18,  4.475421336906837e-03, -7.867801752161927e-04,  7.291682618531819e-05, -4.694371055392822e-06,  2.350095358721352e-07, -9.725464205785369e-09,
  3.456465133185045e-10, -1.082767806556148e-11,  3.046245387020198e-13, -7.806513158540931e-15,  1.842418009315686e-16, -4.038321256832402e-18,  3.361735460333996e-03,
 -6.491174036169330e-04,  6.582286201817970e-05, -4.615911851008315e-06,  2.506754891353144e-07, -1.121205448271575e-08,  4.292621576755877e-10, -1.444268835208223e-11,
  4.352355553052093e-13, -1.191757164960175e-14,  2.998471439507676e-16, -6.991265824771716e-18,  2.509455423951932e-03, -5.284817612560961e-04,  5.829086526672380e-05,
 -4.429523548613141e-06,  2.597332417248950e-07, -1.250242225608063e-08,  5.136088854416585e-10, -1.849189023591291e-11,  5.948430951326434e-13, -1.734672738154950e-14,
  4.638338401176106e-16, -1.147027205182151e-17,  1.864066665371301e-03, -4.253719439198907e-04,  5.075066648033000e-05, -4.158395216986269e-06,  2.620976326152406e-07,
 -1.352168739777525e-08,  5.937536308108292e-10, -2.279403863573193e-11,  7.800466653163245e-13, -2.414896865984137e-14,  6.841556523606373e-16, -1.789197260129011e-17,
  1.379709655145702e-03, -3.390818902844158e-04,  4.353062223392182e-05, -3.827835069828821e-06,  2.582142176679135e-07, -1.422044402107658e-08,  6.649766973341369e-10,
 -2.712483177287838e-11,  9.842566069735560e-13, -3.224676733277314e-14,  9.650616216567399e-16, -2.661379549702640e-17,  1.018892003303870e-03, -2.681454147746249e-04,
  3.685588916199650e-05, -3.462348140253887e-06,  2.489282956913142e-07, -1.457761436811213e-08,  7.232992337701456e-10, -3.124176029064205e-11,  1.198142900528585e-12,
 -4.141378840026252e-14,  1.305406505914957e-15, -3.785457518670349e-17,  7.516852825013307e-04, -2.106996704085466e-04,  3.085857500574956e-05, -3.083550580637263e-06,
  2.353288697168139e-07, -1.459905640411115e-08,  7.658606853353285e-10, -3.491105928078331e-11,  1.410522737611260e-12, -5.128043307205004e-14,  1.697535150346573e-15,
 -5.161752578267867e-17,  5.546747369463999e-04, -1.647559648388324e-04,  2.559449769487631e-05, -2.708975931556416e-06,  2.185970718984298e-07, -1.431292936794142e-08,
  7.911021530647136e-10, -3.793188061083435e-11,  1.609519912306166e-12, -6.136135183690885e-14,  2.127034558395031e-15, -6.763219629317803e-17,  4.098494794038984e-04,
 -1.283831305427455e-04,  2.106218581846999e-05, -2.351666188070568e-06,  1.998798054757595e-07, -1.376319388294181e-08,  7.987565601854383e-10, -4.015393648070475e-11,
  1.783782319153491e-12, -7.110028230041325e-14,  2.573469896767708e-15, -8.532978298620748e-17,  3.035507801811770e-04, -9.981769907495650e-05,  1.722104277929035e-05,
 -2.020353389761619e-06,  1.801991725685745e-07, -1.300261553885826e-08,  7.896818984879138e-10, -4.148666867559160e-11,  1.923552575654471e-12, -7.992417558764007e-14,
  3.012012628026269e-15, -1.038599859579852e-16,  2.255417030398343e-04, -7.751833636421603e-05,  1.400687785906417e-05, -1.720015548787358e-06,  1.603993273923368e-07,
 -1.208636434418839e-08,  7.655934611392663e-10, -4.189988743491249e-11,  2.021440515889441e-12, -8.729736049101305e-14,  3.415690304905097e-15, -1.221492156623522e-16,
  1.682230588598591e-04, -6.018140262039122e-05,  1.134405426544831e-05, -1.452613413458198e-06,  1.411261410290484e-07, -1.106690015840391e-08,  7.287545336891165e-10,
 -4.141732747286925e-11,  2.072823680587457e-12, -9.276748899888123e-14,  3.757883838092872e-15, -1.389917641402331e-16,  1.259962555889553e-04, -4.673188726702859e-05,
  9.154234563246472e-06, -1.217860073837231e-06,  1.228317726136055e-07, -9.990431488260480e-09,  6.816763204653492e-10, -4.010543677668809e-11,  2.075879736749461e-12,
 -9.599761340821057e-14,  4.014687275840980e-15, -1.531597029285700e-16,  9.475993134036326e-05, -3.630064012519646e-05,  7.362131704431659e-06, -1.013926319377016e-06,
  1.057954416736056e-07, -8.894913392047458e-09,  6.268624952871854e-10, -3.805992580366924e-11,  2.031315209156942e-12, -9.678204922583806e-14,  4.166816541497833e-15,
 -1.635149913632139e-16,  7.152105314501044e-05, -2.819558725034240e-05,  5.898862398560021e-06, -8.380298570717876e-07,  9.015257854566198e-08, -7.809343496968078e-09,
  5.666169520657405e-10, -3.539230430804820e-11,  1.941889193644855e-12, -9.504678813458367e-14,  4.200876367148583e-15, -1.691086481554040e-16,  5.409972353460508e-05,
 -2.187189532431679e-05,  4.703525659999459e-06, -6.868907972624908e-07,  7.592627381188325e-08, -6.754019873704498e-09,  5.029188479509879e-10, -3.221803713203782e-11,
  1.811838787026377e-12, -9.083751677849541e-14,  4.109931271118317e-15, -1.692559502150573e-16,  4.090820187341576e-05, -1.690396742570230e-05,  3.723562180586494e-06,
 -5.570583271348365e-07,  6.305690742691275e-08, -5.741415847175382e-09,  4.373587807480937e-10, -2.864726941065461e-11,  1.646300780936390e-12, -8.429950512895544e-14,
  3.893444538459604e-15, -1.635820508228563e-16,  3.078719889687615e-05, -1.296068739100730e-05,  2.914341904586393e-06, -4.451258344683661e-07,  5.142760310492345e-08,
 -4.777372867041577e-09,  3.711242482315689e-10, -2.477846147156352e-11,  1.450800247975491e-12, -7.565380810622442e-14,  3.556728870327204e-15, -1.520377192619153e-16,
  2.288544851538571e-05, -9.784374856947156e-06,  2.238311876320110e-06, -3.478565540096204e-07,  4.088452839452859e-08, -3.862384322919251e-09,  3.050207098936704e-10,
 -2.069481973435578e-11,  1.230849155236758e-12, -6.517363676415372e-14,  3.110087709892021e-15, -1.348890313124702e-16,  1.657139556246878e-05, -7.173342605493177e-06,
  1.663933089831737e-06, -2.622417943287992e-07,  3.125201005874746e-08, -2.992819654316879e-09,  2.395154974627032e-10, -1.646313704813742e-11,  9.916732109839318e-13,
 -5.316374168691471e-14,  2.567822695537967e-15, -1.126872708498833e-16,  1.136832775149795e-05, -4.967650306865537e-06,  1.164553060630272e-06, -1.855114120960068e-07,
  2.234303861117684e-08, -2.162009198030232e-09,  1.747945542320882e-10, -1.213455996227547e-11,  7.380670756679500e-13, -3.994456947443631e-14,  1.947254322118657e-15,
 -8.622613603688974e-17,  6.906478753476863e-06, -3.037591428971995e-06,  7.173163270674603e-07, -1.151154447160322e-07,  1.396638196396336e-08, -1.361199138784872e-09,
  1.108279305297670e-10, -7.747005560695425e-12,  4.743779824132303e-13, -2.584258078426512e-14,  1.267890376158013e-15, -5.649415665771115e-17,  2.890927546924923e-06,
 -1.276060158438196e-06,  3.025614479521010e-07, -4.875508873515493e-08,  5.939311316819535e-09, -5.811774724809891e-10,  4.750455775096608e-11, -3.333350009025318e-12,
  2.048773901035416e-13, -1.120184138547451e-14,  5.515454218554593e-16, -2.466081041380264e-17,  7.368313627259816e-02, -2.277684542371753e-04,  7.373461935550605e-07,
 -2.473636774911784e-09,  8.504518637505854e-12, -2.968442748523483e-14,  1.044470187475414e-16, -3.687090368253901e-19,  1.301804145148806e-21, -4.588747155873821e-24,
  1.613097891464490e-26, -5.652214776695378e-29,  7.181932027228874e-02, -3.081366871547267e-04,  1.554451815781978e-06, -7.955336814781242e-09,  3.973352480621876e-11,
 -1.929288581783995e-13,  9.137205377072311e-16, -4.236927890992718e-18,  1.929483986349929e-20, -8.649795317346931e-23,  3.824145416632513e-25, -1.669727429539598e-27,
  6.823929852784373e-02, -4.562353601886391e-04,  3.350062776797073e-06, -2.285366827126623e-08,  1.461232332311980e-10, -8.893604121060208e-13,  5.205522129415126e-15,
 -2.949960538736311e-17,  1.626381860564290e-19, -8.754941531736051e-22,  4.614585398322150e-24, -2.386875485999122e-26,  6.321813067618494e-02, -6.493079617132954e-04,
  6.362712041408710e-06, -5.490050046171671e-08,  4.339973145754467e-10, -3.214779531096228e-12,  2.261581255711181e-14, -1.524733352569333e-16,  9.915566854633621e-19,
 -6.250308342177029e-21,  3.833433661543416e-23, -2.294398050587232e-25,  5.712196750429845e-02, -8.588773626068000e-04,  1.077324136009665e-05, -1.149003861519372e-07,
  1.100530910413026e-09, -9.731244263186736e-12,  8.078049060080829e-14, -6.366791939354113e-16,  4.803032276152030e-18, -3.489044527324320e-20,  2.451953206610056e-22,
 -1.673068243582253e-24,  5.036239752840763e-02, -1.055943210462453e-03,  1.657267210224256e-05, -2.148968890504424e-07,  2.455619696831967e-09, -2.554947473983321e-11,
  2.469233801497874e-13, -2.246482011133225e-15,  1.942359527573993e-17, -1.607351115860049e-19,  1.279996152376195e-21, -9.850734349975796e-24,  4.334961945012487e-02,
 -1.215784933432134e-03,  2.348381708569835e-05, -3.651258417893066e-07,  4.915782413331817e-09, -5.950087463702877e-11,  6.624582132948800e-13, -6.888300659048068e-15,
  6.762013425683536e-17, -6.317337812371769e-19,  5.651514480850130e-21, -4.864698654391028e-23,  3.645189834192712e-02, -1.321396630242518e-03,  3.096588189528572e-05,
 -5.703507757065347e-07,  8.952221571167122e-09, -1.248663486780360e-10,  1.587559962464372e-12, -1.871258015851567e-14,  2.069492987705551e-16, -2.166633115920643e-18,
  2.162059116513576e-20, -2.067382911189412e-22,  2.996659321938258e-02, -1.365031835248356e-03,  3.830016094169872e-05, -8.267392484142441e-07,  1.498966147839084e-08,
 -2.389529602677778e-10,  3.443235420602574e-12, -4.568390504139964e-14,  5.654287445136494e-16, -6.592084485629998e-18,  7.293483356228774e-20, -7.702454804546723e-22,
  2.410510211629380e-02, -1.347855986446307e-03,  4.472746704199515e-05, -1.120511390471764e-06,  2.327451215559694e-08, -4.209373205583887e-10,  6.828619844215434e-12,
 -1.013499390935561e-13,  1.395683423055079e-15, -1.801986124926239e-17,  2.198867875883400e-19, -2.551708080374436e-21,  1.899118143691444e-02, -1.278132982922090e-03,
  4.959399979044507e-05, -1.429088743751466e-06,  3.375055307785347e-08, -6.879114727447064e-10,  1.248748294094241e-11, -2.061692090572834e-13,  3.142351491113265e-15,
 -4.470766024931860e-17,  5.988398958005588e-19, -7.601710744793804e-21,  1.466991444095685e-02, -1.168607750422136e-03,  5.246499161409350e-05, -1.724615720155182e-06,
  4.598682096082232e-08, -1.049836207784252e-09,  2.120633968828139e-11, -3.874689384945480e-13,  6.504986842778733e-15, -1.015232612366699e-16,  1.486285548793397e-18,
 -2.055319445583874e-20,  1.112346299941460e-02, -1.033767383498464e-03,  5.318085098446452e-05, -1.978909213840871e-06,  5.919037338934524e-08, -1.504791667674427e-09,
  3.364822669352584e-11, -6.771348177677253e-13,  1.246588563727932e-14, -2.125236154627441e-16,  3.387022344906349e-18, -5.082941247550680e-20,  8.289630376481191e-03,
 -8.875161177605570e-04,  5.185088338891719e-05, -2.168458209499402e-06,  7.230993255090424e-08, -2.036145918969949e-09,  5.015445552211318e-11, -1.106643665358847e-12,
  2.224701274161614e-14, -4.126733303753816e-16,  7.132909643584597e-18, -1.157532234245759e-19,  6.079932572477293e-03, -7.415674032481917e-04,  4.879720587967531e-05,
 -2.278181106606920e-06,  8.420630167786889e-08, -2.612851887958468e-09,  7.056895962121238e-11, -1.699971717665799e-12,  3.717006833281374e-14, -7.474019042234343e-16,
  1.396128966940305e-17, -2.441710180278058e-19,  4.394952101082668e-03, -6.046233017641436e-04,  4.447129023416929e-05, -2.303152572598559e-06,  9.384447062746725e-08,
 -3.193151244963070e-09,  9.414409249450899e-11, -2.465917077668600e-12,  5.842068088498686e-14, -1.268823975492492e-15,  2.552784747144442e-17, -4.796054378368238e-19,
  3.135880794028782e-03, -4.822356412352441e-04,  3.936670120260861e-05, -2.248183839527191e-06,  1.004581586013080e-07, -3.730884943587059e-09,  1.195682099455759e-10,
 -3.392001122748056e-12,  8.675461517661401e-14, -2.028185738876212e-15,  4.380743502206171e-17, -8.813957815478160e-19,  2.212100089569898e-03, -3.771486368200042e-04,
  3.394618510746478e-05, -2.125718394535889e-06,  1.036499399923838e-07, -4.182820347248625e-09,  1.451200019334215e-10, -4.442001908067517e-12,  1.222160385390205e-13,
 -3.065335631559021e-15,  7.085585803218737e-17, -1.522110280639034e-18,  1.545280313076263e-03, -2.899032196810221e-04,  2.859285406711264e-05, -1.952823032299689e-06,
  1.034122445647969e-07, -4.515188935604348e-09,  1.689161671612722e-10, -5.558277591470977e-12,  1.639496931299340e-13, -4.397324977403323e-15,  1.084451354658668e-16,
 -2.480018931446955e-18,  1.070797641284138e-03, -2.195160452945538e-04,  2.358709146269780e-05, -1.748080310128627e-06,  1.000771591867050e-07, -4.708006254721818e-09,
  1.891924889985729e-10, -6.668671736897428e-12,  2.101720828356577e-13, -6.009058311992657e-15,  1.576327641240429e-16, -3.826657089068016e-18,  7.373316991380814e-04,
 -1.641037426298220e-04,  1.910503073048642e-05, -1.528997065698092e-06,  9.421867726648538e-08, -4.756502697328838e-09,  2.045525921526295e-10, -7.696475677112951e-12,
  2.583256122199051e-13, -7.848802781149558e-15,  2.183631873157798e-16, -5.611183301194329e-18,  5.054082318515773e-04, -1.213828918955873e-04,  1.523166409305255e-05,
 -1.310255602438484e-06,  8.653668039309078e-08, -4.669813694144803e-09,  2.141333837748404e-10, -8.571135195012920e-12,  3.053888668123813e-13, -9.830270454982822e-15,
  2.892093233873777e-16, -7.844736947784149e-18,  3.454755019514985e-04, -8.902473025070318e-05,  1.198138742335298e-05, -1.102859639873374e-06,  7.774855429750348e-08,
 -4.467690505224957e-09,  2.176635120488748e-10, -9.237359663733073e-12,  3.482744486600589e-13, -1.184126555394638e-14,  3.673362383521464e-16, -1.048868393245463e-17,
  2.359137995646037e-04, -6.487547491108140e-05,  9.320141948427287e-06, -9.140334546493148e-07,  6.850555074644801e-08, -4.176264282391860e-09,  2.154201863614780e-10,
 -9.660937848157314e-12,  3.842268299660095e-13, -1.375715526643508e-14,  4.487149176849039e-16, -1.345012257795508e-17,  1.612127193074282e-04, -4.706927500981401e-05,
  7.185307371941627e-06, -7.476391160872683e-07,  5.934090029334930e-08, -3.823839839811277e-09,  2.081113029965301e-10, -9.830574664024019e-12,  4.111404293007779e-13,
 -1.545626869957314e-14,  5.285501909644987e-16, -1.658639638689413e-17,  1.104266586136919e-04, -3.406509391906918e-05,  5.501422051737336e-06, -6.048677765190750e-07,
  5.064832121894900e-08, -3.437422729205560e-09,  1.967196060084324e-10, -9.756063886856837e-12,  4.277463768793547e-13, -1.683407731771425e-14,  6.018348994603692e-16,
 -1.971815605105367e-17,  7.593642586534098e-05, -2.463591851938137e-05,  4.191273453492109e-06, -4.850050942598339e-07,  4.268441060569636e-08, -3.040333489523264e-09,
  1.823440880894240e-10, -9.463818645751098e-12,  4.336532142424308e-13, -1.781362653743113e-14,  6.639180670800544e-16, -2.264846652517861e-17,  5.249707335855170e-05,
 -1.783251627729630e-05,  3.182813857507233e-06, -3.861363162048550e-07,  3.558647563606669e-08, -2.650949966388490e-09,  1.660647306969081e-10, -8.991075110174384e-12,
  4.292598749254910e-13, -1.835085199586652e-14,  7.109824266558278e-16, -2.518419719991727e-17,  3.652956346428226e-05, -1.293719353244423e-05,  2.412782902478391e-06,
 -3.057201460470368e-07,  2.939784600806725e-08, -2.282404695258595e-09,  1.488446842122896e-10, -8.380002727195056e-12,  4.155806205645257e-13, -1.843469438196040e-14,
  7.403592632642266e-16, -2.715575918119428e-17,  2.560758375858690e-05, -9.417117985089184e-06,  1.828003141294027e-06, -2.410098674617701e-07,  2.409451891989288e-08,
 -1.942962076666742e-09,  1.314729594095396e-10, -7.672629812610078e-12,  3.940287271849992e-13, -1.808295610599520e-14,  7.506526877163221e-16, -2.843206441382858e-17,
  1.809360322371582e-05, -6.882317463393278e-06,  1.385203529199865e-06, -1.893317837419547e-07,  1.960918814860263e-08, -1.636788860090994e-09,  1.145428414094850e-10,
 -6.907081663018286e-12,  3.662009263443611e-13, -1.733542172937003e-14,  7.416871493564490e-16, -2.892899100830587e-17,  1.288516732749597e-05, -5.050464196926138e-06,
  1.050032930074039e-06, -1.482468997821908e-07,  1.585068352389307e-08, -1.364877128889388e-09,  9.845710823720689e-11, -6.115253529451056e-12,  3.336926983679620e-13,
 -1.624587436828194e-14,  7.143213949280077e-16, -2.861116556600601e-17,  9.240438334276539e-06, -3.718742574786629e-06,  7.957246144577368e-07, -1.156262851091949e-07,
  1.271830978736025e-08, -1.125948661107274e-09,  8.345017370445743e-11, -5.321771951882812e-12,  2.979605152779055e-13, -1.487439505848687e-14,  6.701853855347729e-16,
 -2.748811554395097e-17,  6.659484971656459e-06, -2.742148104463496e-06,  6.017011086947589e-07, -8.966827856806156e-08,  1.011147985575557e-08, -9.172393582190602e-10,
  6.961841075773017e-11, -4.543952303641456e-12,  2.602348028053767e-13, -1.328089838195786e-14,  6.113954434046435e-16, -2.560658309814710e-17,  4.804121727015112e-06,
 -2.017173752886202e-06,  4.522796196421287e-07, -6.888027076235769e-08,  7.935478093471785e-09, -7.351191910886767e-10,  5.695206396950488e-11, -3.792419956666342e-12,
  2.214787062594104e-13, -1.152039133550699e-14,  5.402918240036866e-16, -2.304099857749687e-17,  3.444037031125075e-06, -1.469773435957009e-06,  3.355502857889731e-07,
 -5.204164854340009e-08,  6.104304345223954e-09, -5.755423785078927e-10,  4.536450137686392e-11, -3.072093538886234e-12,  1.823830908612650e-13, -9.640050935432657e-15,
  4.592274962340145e-16, -1.988389791076979e-17,  2.420644381670750e-06, -1.046590483166180e-06,  2.424449709366854e-07, -3.815893933256018e-08,  4.541473885299592e-09,
 -4.343454771452429e-10,  3.471659519238508e-11, -2.383297114104746e-12,  1.433869573865791e-13, -7.677950597970185e-15,  3.704217600370367e-16, -1.623760825684030e-17,
  1.622759871765652e-06, -7.086021254838177e-07,  1.659841379055091e-07, -2.641982711366504e-08,  3.179489460417834e-09, -3.074218682526397e-10,  2.483558293572133e-11,
 -1.722849067875587e-12,  1.047136594183643e-13, -5.663136837227401e-15,  2.758806049430866e-16, -1.220800426963674e-17,  9.701048295855802e-07, -4.265118632241241e-07,
  1.006772757434507e-07, -1.614992938770305e-08,  1.958567907940753e-09, -1.908081025081542e-10,  1.552916343906290e-11, -1.085075252629054e-12,  6.641729649377018e-14,
 -3.616818779055497e-15,  1.773822839856026e-16, -7.900846445300980e-18,  4.024282192877556e-07, -1.776001779157365e-07,  4.210134142758597e-08, -6.782822495903979e-09,
  8.261042617857786e-10, -8.081958727705890e-11,  6.604703350419386e-12, -4.633512699422669e-13,  2.847319176808647e-14, -1.556487064338054e-15,  7.662185378359042e-17,
 -3.425275660559214e-18,  7.278367520569283e-02, -2.219861502774051e-04,  7.084598261162203e-07, -2.342181213528770e-09,  7.935084836427301e-12, -2.729702625312758e-14,
  9.468240014608096e-17, -3.295745941302077e-19,  1.147648667044436e-21, -3.990582136754645e-24,  1.384037788628829e-26, -4.785295147824357e-29,  7.061105502768149e-02,
 -2.960724069829381e-04,  1.462678611627534e-06, -7.349316659756866e-09,  3.608497996476447e-11, -1.723561780713085e-13,  8.032827628447878e-16, -3.666501431714949e-18,
  1.643943290056386e-20, -7.257435590150615e-23,  3.160245045970753e-25, -1.359286147444383e-27,  6.646627559567560e-02, -4.304933976110427e-04,  3.089280855522812e-06,
 -2.065147682114750e-08,  1.295213654763410e-10, -7.737795465397955e-13,  4.447899485425140e-15, -2.476579953613438e-17,  1.342046114470856e-19, -7.103074246600503e-22,
  3.682095185802001e-24, -1.873563308302626e-26,  6.071869022938031e-02, -6.009281439517994e-04,  5.743539736310019e-06, -4.844280673584350e-08,  3.748013944030000e-10,
 -2.719843399866068e-12,  1.875895078661796e-14, -1.240664247285837e-16,  7.918761038169324e-19, -4.901209738829289e-21,  2.952639763346181e-23, -1.736409387407055e-25,
  5.385050141559207e-02, -7.779214418452756e-04,  9.493990448997514e-06, -9.874931585359871e-08,  9.239344240218191e-10, -7.990165252609154e-12,  6.492911003650655e-14,
 -5.013212637206394e-16,  3.707112538622213e-18, -2.641036955404495e-20,  1.821046996764891e-22, -1.219648449573939e-24,  4.638834954498821e-02, -9.330458003014529e-04,
  1.421377373922570e-05, -1.793930898228037e-07,  1.999138313705316e-09, -2.031290915617779e-11,  1.919195855405556e-13, -1.708418296247409e-15,  1.446304333294956e-17,
 -1.172570231376408e-19,  9.152924255936040e-22, -6.907840009279267e-24,  3.883624633949787e-02, -1.044188481911779e-03,  1.953758059561689e-05, -2.951910497203034e-07,
  3.870312102323202e-09, -4.569138396124497e-11,  4.967490612048196e-13, -5.048573437111275e-15,  4.847883280598473e-17, -4.433238906853859e-19,  3.884330730182641e-21,
 -3.276397291296571e-23,  3.162162261882976e-02, -1.098788587876527e-03,  2.490492367672038e-05, -4.451892163373915e-07,  6.797050887399501e-09, -9.237052391912644e-11,
  1.145689511379173e-12, -1.318757685286599e-14,  1.425484082376324e-16, -1.459720714971036e-18,  1.425660160091261e-20, -1.334998958125664e-22,  2.506174771940668e-02,
 -1.094572900117755e-03,  2.967402720317126e-05, -6.210479084919931e-07,  1.094307225667142e-08, -1.698211880200809e-10,  2.385382257516569e-12, -3.088440166799306e-14,
  3.733670327646411e-16, -4.255048751650073e-18,  4.605102101494218e-20, -4.760173276294271e-22,  1.935232007580772e-02, -1.038076548601206e-03,  3.326427561532135e-05,
 -8.074458217851921e-07,  1.628851647927879e-08, -2.866009819999103e-10,  4.529503241360368e-12, -6.556778029873929e-14,  8.814938107957376e-16, -1.112009291578971e-17,
  1.326771664300456e-19, -1.506436905272681e-21,  1.457524669637074e-02, -9.417459009888982e-04,  3.527880424394020e-05, -9.846378966494404e-07,  2.257469492057733e-08,
 -4.474587387043073e-10,  7.910081310866129e-12, -1.273264520673063e-13,  1.893942706322224e-15, -2.631983962795937e-17,  3.446110719594541e-19, -4.279001277096734e-21,
  1.071961344553691e-02, -8.205937811113712e-04,  3.557187448878344e-05, -1.132452369440448e-06,  2.930943759729329e-08, -6.505583620630167e-10,  1.279457929723011e-11,
 -2.278766961538598e-13,  3.732907023764566e-15, -5.689628059206655e-17,  8.140940369030065e-19, -1.101057845164570e-20,  7.708927135199936e-03, -6.892396508970171e-04,
  3.424934193825144e-05, -1.234470107830867e-06,  3.584042198280084e-08, -8.859074626774515e-10,  1.928678462492915e-11, -3.783231802680627e-13,  6.795746595948813e-15,
 -1.131437426927737e-16,  1.762347965815068e-18, -2.586718517384061e-20,  5.428541611159389e-03, -5.598437591880389e-04,  3.161348450766990e-05, -1.281127427917184e-06,
  4.147816541301293e-08, -1.135806082385985e-09,  2.724320638047728e-11, -5.860112148228312e-13,  1.149612326077333e-14, -2.082810262977752e-16,  3.518968244005142e-18,
 -5.585984986518558e-20,  3.749041215025068e-03, -4.410835371152706e-04,  2.807741443703396e-05, -1.270964557401773e-06,  4.563193569134405e-08, -1.377452401822036e-09,
  3.623858174061902e-11, -8.512897382722489e-13,  1.816900313442614e-14, -3.569201063618278e-16,  6.518691712860497e-18, -1.115473509309004e-19,  2.543476137311312e-03,
 -3.380374082141215e-04,  2.407666515992907e-05, -1.209934907476771e-06,  4.791870617912742e-08, -1.587056273194136e-09,  4.560102817592514e-11, -1.165289121575811e-12,
  2.695920793185928e-14, -5.722630916401423e-16,  1.126148188994523e-17, -2.070909617884073e-19,  1.698147417707100e-03, -2.526882728199772e-04,  1.999883273155044e-05,
 -1.109284519774548e-06,  4.821741161963063e-08, -1.744278131861741e-09,  5.451398827132329e-11, -1.509664778232285e-12,  3.772642215934997e-14, -8.624745162865136e-16,
  1.823040451076468e-17, -3.591964466597424e-19,  1.117835575670829e-03, -1.847309531457206e-04,  1.614137283284708e-05, -9.828077941389539e-07,  4.666116635487714e-08,
 -1.835751638617905e-09,  6.215869221396892e-11, -1.858675478672168e-12,  5.000130521854117e-14, -1.227163261890159e-15,  2.777694278557363e-17, -5.847004051658614e-19,
  7.269276328650628e-04, -1.324248910144997e-04,  1.269755865043667e-05, -8.442559551689202e-07,  4.357946316287853e-08, -1.856843734130674e-09,  6.785766742802792e-11,
 -2.183187425309472e-12,  6.301476160169969e-14, -1.655113118986716e-15,  3.999967409544217e-17, -8.969997530901011e-19,  4.679593770154902e-04, -9.332691245929041e-05,
  9.764016505079038e-06, -7.054219593442235e-07,  3.941379640927951e-08, -1.811438021098403e-09,  7.118172448172433e-11, -2.455556949226889e-12,  7.579973480289297e-14,
 -2.124171093440397e-15,  5.465182206545599e-17, -1.302039356461907e-18,  2.988503056124471e-04, -6.483033705432159e-05,  7.360792234038534e-06, -5.751013236833049e-07,
  3.463160709416586e-08, -1.710118422055236e-09,  7.199747570575825e-11, -2.654105463955103e-12,  8.734149031357190e-14, -2.603588643401410e-15,  7.111025322866033e-17,
 -1.794934145804613e-18,  1.897483511452009e-04, -4.450473586248839e-05,  5.455638383921980e-06, -4.588574148572711e-07,  2.965721455022218e-08, -1.567478773386162e-09,
  7.045240366297931e-11, -2.766120723564859e-12,  9.673783594906639e-14, -3.058352330293568e-15,  8.842263937014885e-17, -2.358310090183207e-18,  1.200462621905229e-04,
 -3.026960754962933e-05,  3.986638014900544e-06, -3.593635115728319e-07,  2.482882387836630e-08, -1.399332604757328e-09,  6.691166298603646e-11, -2.788857282428902e-12,
  1.033301601728486e-13, -3.454443035291602e-15,  1.054264932501032e-16, -2.963050237352903e-18,  7.584743359239091e-05, -2.044959120187910e-05,  2.880040527170081e-06,
 -2.770533170278782e-07,  2.038181604813675e-08, -1.220414037827586e-09,  6.186996997241126e-11, -2.728621284234188e-12,  1.067782125254032e-13, -3.763747491667619e-15,
  1.209126459641793e-16, -3.571459769154600e-18,  4.796517392998994e-05, -1.375704126949841e-05,  2.062434877171709e-06, -2.108513875448904e-07,  1.645269255544612e-08,
 -1.042873503837439e-09,  5.586219966869373e-11, -2.598488318305572e-12,  1.070700493553822e-13, -3.967553469914798e-15,  1.337943411465187e-16, -4.142173476853654e-18,
  3.042684753797046e-05, -9.238098651363358e-06,  1.467811226717749e-06, -1.588310277371313e-07,  1.309574715789228e-08, -8.756003278566903e-10,  4.939014608097990e-11,
 -2.415404393668866e-12,  1.044761088934210e-13, -4.058059496203689e-15,  1.432446887871513e-16, -4.635675084003101e-18,  1.940218418323921e-05, -6.206773090074643e-06,
  1.040716040228722e-06, -1.187245395638160e-07,  1.030499027802171e-08, -7.242194478971521e-10,  4.287414821750518e-11, -2.197368158178280e-12,  9.946759287545859e-14,
 -4.037904968055943e-15,  1.487775292884974e-16, -5.019220166585869e-18,  1.246137395434282e-05, -4.181356478565025e-06,  7.368115745254240e-07, -8.826990690453489e-08,
  8.035799955270252e-09, -5.915289149483835e-10,  3.663029178057602e-11, -1.961178060388140e-12,  9.262243584856941e-14, -3.918180635445903e-15,  1.502640176315708e-16,
 -5.270232627972610e-18,  8.075615808418161e-06, -2.829996429196672e-06,  5.219554272136607e-07, -6.541358288629259e-08,  6.223090550285365e-09, -4.781480053145759e-10,
  3.086854975812458e-11, -1.720963854015646e-12,  8.453854874624044e-14, -3.715606613208191e-15,  1.478931315251310e-16, -5.377733396314908e-18,  5.288462667682807e-06,
 -1.927490300147036e-06,  3.706118152573876e-07, -4.840422205627884e-08,  4.794761495654032e-09, -3.831973196029010e-10,  2.570490115118265e-11, -1.487495751194408e-12,
  7.576680526927839e-14, -3.449562794760194e-15,  1.420945026092190e-16, -5.341870865855100e-18,  3.503509812133037e-06, -1.322748931749058e-06,  2.641109069377501e-07,
 -3.581359413599095e-08,  3.680521860210454e-09, -3.048990965314732e-10,  2.118053658524060e-11, -1.268120565126717e-12,  6.676851584851448e-14, -3.139494223849921e-15,
  1.334451287721027e-16, -5.172004232278471e-18,  2.349239975899415e-06, -9.152333412380168e-07,  1.890392161419324e-07, -2.651507179572071e-08,  2.816889663730790e-09,
 -2.410460521498070e-10,  1.728271300370348e-11, -1.067115990973694e-12,  5.789603575133242e-14, -2.802985612674618e-15,  1.225788564283801e-16, -4.883972410520197e-18,
  1.593954675688841e-06, -6.383886713742732e-07,  1.358842349984752e-07, -1.964182599050458e-08,  2.149392536730463e-09, -1.893302597923667e-10,  1.396373193955327e-11,
 -8.862609167018562e-13,  4.939154747641505e-14, -2.454584287859025e-15,  1.101115412983815e-16, -4.497172276152913e-18,  1.092672782319162e-06, -4.482588131320643e-07,
  9.796014107540584e-08, -1.453901930797502e-08,  1.632935293954106e-09, -1.475486855821816e-10,  1.115626685823933e-11, -7.254627281717288e-13,  4.139780352632263e-14,
 -2.105295591957965e-15,  9.658807693286246e-17, -4.031931514319898e-18,  7.541644517122440e-07, -3.157942739554632e-07,  7.059136614548397e-08, -1.071810051191071e-08,
  1.231105796665149e-09, -1.137125356606016e-10,  8.784561816295462e-12, -5.833370690884347e-13,  3.397503780024421e-14, -1.762591817255609e-15,  8.245185371265842e-17,
 -3.507469130608024e-18,  5.205409402772471e-07, -2.217187117850755e-07,  5.051044180767622e-08, -7.817007539870642e-09,  9.149664513460657e-10, -8.608856247025737e-11,
  6.771817120256874e-12, -4.576851745236121e-13,  2.711956281787495e-14, -1.430754689877955e-15,  6.803353204473306e-17, -2.940553402409630e-18,  3.546150851236308e-07,
 -1.531291231339940e-07,  3.542296574366780e-08, -5.567416861787370e-09,  6.616800560818380e-10, -6.319643217083677e-11,  5.044454122409617e-12, -3.458511934033763e-13,
  2.078112545253553e-14, -1.111391719962980e-15,  5.355432957017403e-17, -2.344829932626984e-18,  2.320425218948130e-07, -1.012495876521814e-07,  2.369710152921060e-08,
 -3.768708722600332e-09,  4.531667920141444e-10, -4.378045269488459e-11,  3.534047037391801e-12, -2.449659293044813e-13,  1.487751318191016e-14, -8.040084429892102e-16,
  3.913894590740430e-17, -1.730715187439799e-18,  1.363892011647934e-07, -5.994108257667823e-08,  1.414279988991357e-08, -2.267682824800803e-09,  2.748904142587892e-10,
 -2.676886737748073e-11,  2.177694471234261e-12, -1.520996242135159e-13,  9.306205129982167e-15, -5.065765237240584e-16,  2.483471188406222e-17, -1.105750615318486e-18,
  5.604500777443103e-08, -2.472920604556337e-08,  5.860972753798805e-09, -9.440374826084435e-10,  1.149526042670507e-10, -1.124363177493755e-11,  9.186508834134727e-13,
 -6.443413813145207e-14,  3.958691420730611e-15, -2.163576258513520e-16,  1.064858507777383e-17, -4.759364299930678e-19,  7.190689094938998e-02, -2.164287787282594e-04,
  6.810977952025040e-07, -2.219466979048623e-09,  7.411141509775147e-12, -2.513136483780127e-14,  8.594759967061754e-17, -2.950455475790759e-19,  1.013465807948147e-21,
 -3.476849481142762e-24,  1.189903924391664e-26, -4.060177861212321e-29,  6.944962322906655e-02, -2.847141855200695e-04,  1.377840514911657e-06, -6.798520353781860e-09,
  3.282262592558169e-11, -1.542522209518401e-13,  7.076095559476290e-16, -3.179914975381498e-18,  1.404059148354005e-20, -6.105218710074090e-23,  2.618987930344931e-25,
 -1.109906860083814e-27,  6.479220921831329e-02, -4.067363314412646e-04,  2.853404654350200e-06, -1.869736697255998e-08,  1.150595129170649e-10, -6.748886335494449e-13,
  3.810930278692828e-15, -2.085349986090544e-17,  1.110974337050405e-19, -5.782679461375357e-22,  2.948778745839888e-24, -1.476333692388291e-26,  5.840333130249799e-02,
 -5.572071157031608e-04,  5.196488022904537e-06, -4.285782930435687e-08,  3.246394272202633e-10, -2.308606715061282e-12,  1.561486859270552e-14, -1.013356829322286e-16,
  6.349714671832462e-19, -3.859826737926136e-21,  2.284533049876213e-23, -1.320378747668150e-25,  5.088355399107246e-02, -7.064697929752823e-04,  8.392684631553871e-06,
 -8.516466613584982e-08,  7.786428343147016e-10, -6.587736369866811e-12,  5.241941469903549e-14, -3.965987945341437e-16,  2.875479509890680e-18, -2.009584687204343e-20,
  1.359876282982587e-22, -8.941833052356736e-25,  4.287068176489154e-02, -8.274320398485124e-04,  1.224033580918545e-05, -1.504220499462610e-07,  1.635320747059957e-09,
 -1.623223106512505e-11,  1.499758548494644e-13, -1.306629248767244e-15,  1.083359347252486e-17, -8.607170184897501e-20,  6.587346220555338e-22, -4.876600249448437e-24,
  3.495105884079198e-02, -9.010697515192171e-04,  1.633865579218155e-05, -2.399740041784146e-07,  3.065101118963204e-09, -3.530416820214675e-11,  3.749067587725579e-13,
 -3.725227437785067e-15,  3.500012315784599e-17, -3.133702931242746e-19,  2.689804725121087e-21, -2.223768163894179e-23,  2.759354913196452e-02, -9.192007676019852e-04,
  2.015872281835241e-05, -3.498385642901721e-07,  5.197167829710631e-09, -6.883443444325056e-11,  8.331218518586596e-13, -9.367312522730363e-15,  9.898912881826973e-17,
 -9.917076612076136e-19,  9.481826220407389e-21, -8.696851911851636e-23,  2.111492651865688e-02, -8.842537526995131e-04,  2.316923249721569e-05, -4.702910291811819e-07,
  8.055514496870134e-09, -1.217288525264520e-10,  1.667174713221251e-12, -2.106934634464846e-14,  2.488449074786212e-16, -2.772777322844735e-18,  2.936038316321157e-20,
 -2.971117619839589e-22,  1.567660167015862e-02, -8.066894076944640e-04,  2.496702215130051e-05, -5.873505032951116e-07,  1.150989730050697e-08, -1.970724482439557e-10,
  3.034947060494610e-12, -4.285790363980816e-14,  5.626149880730499e-16, -6.935969106112423e-18,  8.093066928688209e-20, -8.992182070342890e-22,  1.130574108751674e-02,
 -7.012564459557064e-04,  2.536537149042094e-05, -6.858207113502966e-07,  1.526716123413933e-08, -2.943387534418995e-10,  5.068011454027405e-12, -7.954956815937453e-14,
  1.154978395585443e-15, -1.568002745917085e-17,  2.007123563102897e-19, -2.438151552126272e-21,  7.930397531996234e-03, -5.832946469343264e-04,  2.441543615147756e-05,
 -7.528553166473235e-07,  1.891462304286225e-08, -4.082461715902102e-10,  7.818306387493494e-12, -1.357511174569995e-13,  2.170104583792329e-15, -3.230613500724605e-17,
  4.518324377431278e-19, -5.977458774896149e-21,  5.418311620864612e-03, -4.659503069471312e-04,  2.236427661648095e-05, -7.808219415545867e-07,  2.200570102599683e-08,
 -5.288949861351766e-10,  1.121135377314809e-11, -2.143795870652954e-13,  3.757643526342922e-15, -6.110108598934861e-17,  9.302284320745605e-19, -1.335473158681248e-20,
  3.611528355927295e-03, -3.586685006862346e-04,  1.957368356634384e-05, -7.685916038676322e-07,  2.415996788396463e-08, -6.433630828816825e-10,  1.502690445480289e-11,
 -3.151192868128265e-13,  6.032696078551395e-15, -1.067537083858253e-16,  1.763044399926008e-18, -2.737626526805385e-20,  2.352457471677794e-03, -2.668812619575327e-04,
  1.643086098260783e-05, -7.210492326777416e-07,  2.514444413095809e-08, -7.383464561882993e-10,  1.892037902750304e-11, -4.334087609904909e-13,  9.028993955911361e-15,
 -1.732789389411442e-16,  3.094151159729245e-18, -5.180348105630666e-20,  1.500245501037624e-03, -1.925417834682651e-04,  1.327623773321158e-05, -6.472569937126258e-07,
  2.491203226164612e-08, -8.030030370643661e-10,  2.248333231776330e-11, -5.604687870071795e-13,  1.266111854527944e-14, -2.626510660550091e-16,  5.055131918247911e-18,
 -9.098324826860605e-20,  9.385952799913741e-04, -1.350801173801039e-04,  1.036125987966115e-05, -5.580453310994105e-07,  2.359070418720548e-08, -8.311020085871710e-10,
  2.532566130135964e-11, -6.845394476058096e-13,  1.671206158086966e-14, -3.735579823075880e-16,  7.726143446308830e-18, -1.490589063905600e-19,  5.772894589442453e-04,
 -9.242288887096646e-05,  7.836590495317383e-06, -4.637924704395024e-07,  2.143432035678498e-08, -8.218943057506912e-10,  2.715402140800118e-11, -7.930389320550659e-13,
  2.085524280934463e-14, -5.007569794468776e-16,  1.109729165760228e-17, -2.288606117098182e-19,  3.498546069733881e-04, -6.185129762194002e-05,  5.762963562039736e-06,
 -3.728876992619715e-07,  1.875575547828110e-08, -7.796193772655987e-10,  2.782344975242239e-11, -8.750071841833316e-13,  2.470793446333409e-14, -6.353715098613476e-16,
  1.504412970092654e-17, -3.307508980841109e-19,  2.094074596624988e-04, -4.060359211116462e-05,  4.134084053221772e-06, -2.910321415408646e-07,  1.586330497742421e-08,
 -7.120081573122046e-10,  2.735036162451026e-11, -9.231136961973221e-13,  2.790148629931265e-14, -7.661585450687094e-16,  1.932829479595053e-17, -4.518025491329826e-19,
  1.241043517490713e-04, -2.622418658276667e-05,  2.902207475390423e-06, -2.212577471040315e-07,  1.301467722547992e-08, -6.283673589859962e-10,  2.588896412173993e-11,
 -9.347076580923415e-13,  3.014808837818584e-14, -8.814329394061945e-16,  2.362659209465267e-17, -5.856416925684106e-19,  7.301192411590390e-05, -1.671278447466183e-05,
  2.000268922029198e-06, -1.644065268092186e-07,  1.039378041102927e-08, -5.378054171635659e-10,  2.368368383017250e-11, -9.117523035427782e-13,  3.128616027123304e-14,
 -9.711128600698079e-16,  2.758219836950023e-17, -7.230985607490478e-19,  4.275316808941855e-05, -1.054149085769788e-05,  1.357839665738452e-06, -1.197994061069618e-07,
  8.107916632867296e-09, -4.479657406529166e-10,  2.101419441648907e-11, -8.598418349424047e-13,  3.129497029249594e-14, -1.028338034463994e-15,  3.086431754601145e-17,
 -8.535463320357104e-19,  2.498565827097846e-05, -6.600303210592810e-06,  9.107296605443029e-07, -8.588925903702672e-08,  6.198830782784635e-09, -3.643890746441523e-10,
  1.814734857778599e-11, -7.867160880203353e-13,  3.027947933875677e-14, -1.050294517298389e-15,  3.322055219714302e-17, -9.665864886832135e-19,  1.461348431695284e-05,
 -4.114652659436818e-06,  6.054479444723685e-07, -6.078285063516707e-08,  4.660292553018109e-09, -2.904309014551556e-10,  1.530441309241624e-11, -7.007220708408891e-13,
  2.843443876225189e-14, -1.038157716175019e-15,  3.450979709390671e-17, -1.053646485935925e-18,  8.577223925232865e-06, -2.561493371420533e-06,  4.001751761556422e-07,
 -4.259484177756330e-08,  3.456348762785250e-09, -2.275558040250322e-10,  1.264559914680517e-11, -6.095625358047936e-13,  2.600016203060751e-14, -9.963199226508872e-16,
  3.471050329348036e-17, -1.109116835743218e-18,  5.065672951505394e-06, -1.596964734382127e-06,  2.637595837526552e-07, -2.964793523838977e-08,  2.536689654267938e-09,
 -1.758137656095036e-10,  1.026916044713710e-11, -5.194999164151423e-13,  2.322124420155810e-14, -9.312163772907639e-16,  3.390655150846367e-17, -1.130826826309274e-18,
  3.018188517291295e-06, -9.998540987324132e-07,  1.738554135503507e-07, -2.055669491415268e-08,  1.847710800192961e-09, -1.343422870749438e-10,  8.220077780623863e-12,
 -4.350240629324831e-13,  2.031555199502527e-14, -8.500837506772959e-16,  3.225811823258188e-17, -1.119861370299056e-18,  1.818524146170636e-06, -6.302764539234896e-07,
  1.149046100592195e-07, -1.423633919231119e-08,  1.339335812224914e-09, -1.017980073504356e-10,  6.503221798249325e-12, -3.588873904767869e-13,  1.745618306736263e-14,
 -7.599078201677677e-16,  2.996671617512367e-17, -1.079881610894285e-18,  1.110409478865482e-06, -4.009316555524933e-07,  7.632655094803783e-08, -9.871020143654865e-09,
  9.684330245689707e-10, -7.667697128333154e-11,  5.097028194570712e-12, -2.923697417935504e-13,  1.476538729080831e-14, -6.666972282093766e-16,  2.724243630580823e-17,
 -1.016188860203424e-18,  6.883281571649503e-07, -2.578519153872257e-07,  5.105545330412850e-08, -6.865824526268080e-09,  6.998786521479144e-10, -5.752176814418620e-11,
  3.965275501843887e-12, -2.356427942250253e-13,  1.231734537590609e-14, -5.751067098534092e-16,  2.427857341716820e-17, -9.347651385055392e-19,  4.336762050434906e-07,
 -1.678785503846680e-07,  3.443662680023110e-08, -4.797110136453645e-09,  5.062160628193552e-10, -4.303483140211543e-11,  3.065946040837444e-12, -1.881374511400147e-13,
  1.014613238059947e-14, -4.883548445103454e-16,  2.123565087959803e-17, -8.414613455930855e-19,  2.778055581015479e-07, -1.106988186085399e-07,  2.343286899791256e-08,
 -3.368531489199584e-09,  3.666252559984841e-10, -3.212420851430472e-11,  2.357117398781154e-12, -1.488574614516640e-13,  8.255664510540388e-15, -4.083450792031957e-16,
  1.823433824314686e-17, -7.414215569357879e-19,  1.807693026347550e-07, -7.386914714140471e-08,  1.607384265398439e-08, -2.375416076613932e-09,  2.656688681754868e-10,
 -2.390658241648392e-11,  1.800355190355524e-12, -1.166162050946152e-13,  6.629373059695063e-15, -3.358964781523324e-16,  1.535527859714448e-17, -6.387579248720453e-19,
  1.191403654459033e-07, -4.974385067296517e-08,  1.108405096345744e-08, -1.677536262174325e-09,  1.920787483353816e-10, -1.768696288063848e-11,  1.362259833129033e-12,
 -9.019635714520144e-14,  5.238336274184231e-15, -2.710085318931163e-16,  1.264335607891223e-17, -5.364405369567200e-19,  7.903496626740584e-08, -3.359577073619770e-08,
  7.636314469793284e-09, -1.179120308072361e-09,  1.377058758547305e-10, -1.292836420599629e-11,  1.014793012612167e-12, -6.844427804328561e-14,  4.047388676807004e-15,
 -2.131095054780157e-16,  1.011414161748103e-17, -4.363430187533570e-19,  5.210799656553880e-08, -2.247135856781828e-08,  5.190553833843812e-09, -8.145819923750978e-10,
  9.666965824947493e-11, -9.219533466338128e-12,  7.348852711359756e-13, -5.031515955782432e-14,  3.019243207753638e-15, -1.612614999214066e-16,  7.760815591700380e-18,
 -3.393823535850792e-19,  3.324113536419475e-08, -1.449311241100815e-08,  3.389083010691171e-09, -5.385105752631084e-10,  6.469622411732184e-11, -6.244929195120204e-12,
  5.036794434435237e-13, -3.488436119256862e-14,  2.116933580520650e-15, -1.143135788015650e-16,  5.560515175981876e-18, -2.457023553438587e-19,  1.919373365270994e-08,
 -8.431951275921487e-09,  1.988567415636030e-09, -3.187027983827295e-10,  3.861566332055579e-11, -3.758697703157640e-12,  3.056409717384972e-13, -2.133801025968392e-14,
  1.305009123763286e-15, -7.100764521593510e-17,  3.479703366166659e-18, -1.548701400872051e-19,  7.808895194410415e-09, -3.444912508204116e-09,  8.162843089295028e-10,
 -1.314506371143140e-10,  1.600273335526081e-11, -1.564893525934105e-12,  1.278299834694070e-13, -8.964037778475642e-15,  5.506125947756235e-16, -3.008672882934752e-17,
  1.480486247981537e-18, -6.615654528466030e-20,  7.105190751612542e-02, -2.110845524363519e-04,  6.551594298615504e-07, -2.104800401947445e-09,  6.928490934197320e-12,
 -2.316420551144079e-14,  7.812217555385658e-17, -2.645288275160435e-19,  8.964531340818579e-22, -3.034750505165490e-24,  1.025016258360596e-26, -3.452266659136342e-29,
  6.833230754981753e-02, -2.740090912386876e-04,  1.299310344659625e-06, -6.297145356146549e-09,  2.990044978134583e-11, -1.382892331105032e-13,  6.245455875478864e-16,
 -2.763851981006664e-18,  1.202008338358928e-20, -5.149065835923264e-23,  2.176401858531400e-25, -9.089437970164963e-28,  6.320954023700652e-02, -3.847762661352517e-04,
  2.639652109226434e-06, -1.695961903052900e-08,  1.024310652040871e-10, -5.900498064762604e-13,  3.273829579263927e-15, -1.760991145956111e-17,  9.225524719556421e-20,
 -4.723436347885787e-22,  2.369892033460843e-24, -1.167697885236884e-26,  5.625450964911215e-02, -5.176074668226557e-04,  4.711899193068591e-06, -3.801353874613013e-08,
  2.819963756518629e-10, -1.965724959418098e-12,  1.304224186769588e-14, -8.307425263794227e-17,  5.111568976533756e-19, -3.052379377434039e-21,  1.775375616445721e-23,
 -1.008665761672182e-25,  4.818577159310984e-02, -6.432140163221777e-04,  7.441321979649732e-06, -7.369566044941470e-08,  6.586203114968307e-10, -5.453162632630826e-12,
  4.250116625990564e-14, -3.151812063877215e-16,  2.241148806121208e-18, -1.536850491207920e-20,  1.020879718058962e-22, -6.591968940474673e-25,  3.974596386493127e-02,
 -7.363082659412348e-04,  1.058214985907534e-05, -1.266702757295665e-07,  1.343897834645577e-09, -1.303535484662652e-11,  1.178118295164209e-13, -1.004837970952899e-15,
  8.161781560018337e-18, -6.356096125339034e-20,  4.770611841795092e-22, -3.465016886158945e-24,  3.159107034916249e-02, -7.810962032674604e-04,  1.373140860797015e-05,
 -1.961254885359679e-07,  2.441158968209590e-09, -2.744124826726645e-11,  2.847221432479872e-13, -2.766732961832759e-15,  2.544074759649691e-17, -2.230717776052761e-19,
  1.876194800623188e-21, -1.520664044020878e-23,  2.421456404475237e-02, -7.734075945981488e-04,  1.641744750566758e-05, -2.766941327759723e-07,  4.000902210970024e-09,
 -5.165952744782500e-11,  6.102986268404488e-13, -6.704566292448446e-15,  6.928287279173748e-17, -6.792242697496592e-19,  6.358889374281988e-21, -5.714126403819298e-23,
  1.791574313414951e-02, -7.194545996762095e-04,  1.822525913105305e-05, -3.588909155093450e-07,  5.977560716327070e-09, -8.798085748536872e-11,  1.175188317303775e-12,
 -1.450008864525943e-14,  1.673510772039589e-16, -1.823588375582071e-18,  1.889624415653442e-20, -1.872380026670380e-22,  1.280873270767737e-02, -6.322910872420247e-04,
  1.890548531051989e-05, -4.311403226714193e-07,  8.209244585114317e-09, -1.368097163759567e-10,  2.053482729787035e-12, -2.829455243176515e-14,  3.627625463949969e-16,
 -4.371278034128669e-18,  4.988983490955293e-20, -5.425463151684982e-22,  8.859761447851456e-03, -5.275081353453779e-04,  1.842641221820900e-05, -4.827199930683219e-07,
  1.043584761380580e-08, -1.957297010339238e-10,  3.283133256446779e-12, -5.026060062569548e-14,  7.124011054747259e-16, -9.449824793012415e-18,  1.182765574768823e-19,
 -1.405793872966935e-21,  5.937170252838060e-03, -4.195236200265776e-04,  1.695733917234731e-05, -5.065094679272859e-07,  1.235462063121313e-08, -2.593336747672692e-10,
  4.836815554089454e-12, -8.188509693846569e-14,  1.277579203955242e-15, -1.857860735448197e-17,  2.540142619014985e-19, -3.287373584762476e-21,  3.860495012239843e-03,
 -3.192481572091145e-04,  1.480020660502194e-05, -5.005544704234648e-07,  1.369476235622199e-08, -3.200679765347183e-10,  6.606697959480223e-12, -1.231597640965927e-13,
  2.106662717650676e-15, -3.345824816651605e-17,  4.979167341627324e-19, -6.992326642667627e-21,  2.439752391324592e-03, -2.332639662249519e-04,  1.230145271871862e-05,
 -4.680237236517036e-07,  1.428374384817806e-08, -3.699003033917699e-10,  8.413355817720674e-12, -1.720070754380756e-13,  3.213574363945246e-15, -5.554534654993167e-17,
  8.967195634942858e-19, -1.362094227526638e-20,  1.501381785939536e-03, -1.641857736315903e-04,  9.774742338389254e-06, -4.158062760185234e-07,  1.408249781517059e-08,
 -4.022426642635989e-10,  1.003965304924491e-11, -2.242527551971539e-13,  4.559940937207558e-15, -8.549193202609905e-17,  1.492521989413279e-18, -2.444838696346311e-20,
  9.014748553263711e-04, -1.116777257066799e-04,  7.452881227109801e-06, -3.524382613852198e-07,  1.318088440241026e-08, -4.134518542381839e-10,  1.127947716989567e-11,
 -2.742685507467294e-13,  6.049396305628179e-15, -1.226332467370361e-16,  2.308273800725672e-18, -4.065862969919846e-20,  5.292723269723434e-04, -7.363669226211825e-05,
  5.472373424754858e-06, -2.861157824257711e-07,  1.176072555402796e-08, -4.034342501240956e-10,  1.198467748410903e-11, -3.161321550168203e-13,  7.538953112717644e-15,
 -1.647458023344196e-16,  3.333684500406043e-18, -6.296969855837180e-20,  3.045686988105557e-04, -4.721392935970579e-05,  3.883250078447843e-06, -2.233172658503211e-07,
  1.004360817558482e-08, -3.752672364209271e-10,  1.209473113973066e-11, -3.449293863678488e-13,  8.865737840247406e-15, -2.082298856927405e-16,  4.517210189123719e-18,
 -9.125603253065877e-20,  1.722105254830019e-04, -2.952959179361810e-05,  2.672432061035308e-06, -1.682104606733663e-07,  8.241660547411276e-09, -3.341094934264699e-10,
  1.164138716510489e-11, -3.577713160974933e-13,  9.881035693825703e-15, -2.487160989177283e-16,  5.768496348873183e-18, -1.243103094487325e-19,  9.593093451045666e-05,
 -1.807343393235096e-05,  1.789916332983960e-06, -1.227293103517084e-07,  6.523603287267253e-09, -2.858534072523543e-10,  1.073037671767155e-11, -3.542319148374769e-13,
  1.048074302927148e-14, -2.819272875944479e-16,  6.972064299372198e-18, -1.598623725219624e-19,  5.279629833655797e-05, -1.086003850975188e-05,  1.170857112666727e-06,
 -8.705970467858807e-08,  5.000018658782831e-09, -2.359428331001486e-10,  9.509516111387729e-12, -3.361479461245073e-13,  1.062319380068108e-14, -3.045289209733871e-16,
  8.008747498794310e-18, -1.948890890335401e-19,  2.879223924427492e-05, -6.427918885723976e-06,  7.506927528639452e-07, -6.026547634089500e-08,  3.724956458355129e-09,
 -1.886099393230852e-10,  8.134716931408941e-12, -3.069422083085524e-13,  1.033059319598971e-14, -3.147166234957980e-16,  8.778480933692351e-18, -2.261424826349630e-19,
  1.560662988566572e-05, -3.760338827015027e-06,  4.734372162864569e-07, -4.086139213794666e-08,  2.707595560980145e-09, -1.465845945379562e-10,  6.743012362226025e-12,
 -2.707461239054219e-13,  9.676171467251231e-15, -3.124017300031214e-16,  9.217822532108453e-18, -2.507443359286156e-19,  8.434959908713449e-06, -2.181696280473889e-06,
  2.947603987865256e-07, -2.723714371593383e-08,  1.927520847507421e-09, -1.111821651923925e-10,  5.436999653419000e-12, -2.315886472730750e-13,  8.763132118304368e-15,
 -2.990031200043273e-16,  9.307905675562091e-18, -2.666785635443132e-19,  4.560446662229864e-06, -1.259740833505232e-06,  1.818237975288576e-07, -1.791508625487403e-08,
  1.348943904755284e-09, -8.261197087654908e-11,  4.280556563837460e-12, -1.928243135898800e-13,  7.702422378205317e-15, -2.769701649482020e-16,  9.072072784047767e-18,
 -2.730599206051535e-19,  2.474620300493581e-06, -7.264402750890118e-07,  1.115239491020319e-07, -1.167010403576567e-08,  9.314783910084258e-10, -6.035621019025017e-11,
  3.302824254217949e-12, -1.568549435145887e-13,  6.594774035434825e-15, -2.492098279280543e-16,  8.565595394889084e-18, -2.701411771339998e-19,  1.352100567375906e-06,
 -4.198058545523349e-07,  6.825886953754291e-08, -7.555929995115476e-09,  6.369474558604731e-10, -4.351512128611999e-11,  2.506554387194960e-12, -1.251059887053332e-13,
  5.519691300009357e-15, -2.185715143559897e-16,  7.861552183043631e-18, -2.591020184499174e-19,  7.462793445658704e-07, -2.439424425729396e-07,  4.183269127778000e-08,
 -4.879388329805147e-09,  4.328094748920092e-10, -3.106731532416129e-11,  1.877462058905673e-12, -9.817096493062266e-14,  4.531438721806085e-15, -1.874833325193007e-16,
  7.036909418294212e-18, -2.417124826409511e-19,  4.173649162196937e-07, -1.429907494287114e-07,  2.575460175954883e-08, -3.153063047601865e-09,  2.932084937465120e-10,
 -2.203577863822187e-11,  1.392418347279756e-12, -7.603222237114678e-14,  3.660395870646485e-15, -1.577662661964009e-16,  6.161638703721483e-18, -2.199726477962042e-19,
  2.371792599856045e-07, -8.479896887028597e-08,  1.597629840631911e-08, -2.045002744088765e-09,  1.986286141536396e-10, -1.557403550921599e-11,  1.025517481015510e-12,
 -5.828703476746492e-14,  2.917546299508151e-15, -1.306021669813624e-16,  5.292091869387157e-18, -1.958074616893518e-19,  1.372915609486108e-07, -5.100905954580132e-08,
  1.001167829020284e-08, -1.334677718416358e-09,  1.348997725612870e-10, -1.099577797578927e-11,  7.519276188682004e-13, -4.433722006099775e-14,  2.300080805279653e-15,
 -1.066062924104527e-16,  4.468473982174366e-18, -1.708584866324340e-19,  8.110211352937694e-08, -3.118467670529697e-08,  6.350697270385615e-09, -8.783177104686934e-10,
  9.203329492876949e-11, -7.770450867317572e-12,  5.499095642257335e-13, -3.352633597549181e-14,  1.796706422842116e-15, -8.595222996535635e-17,  3.715428641363475e-18,
 -1.463790679005863e-19,  4.894311265518317e-08, -1.939844896917280e-08,  4.082467826420724e-09, -5.834683053004156e-10,  6.314336196177477e-11, -5.502099041696628e-12,
  4.015443076449152e-13, -2.522581140434729e-14,  1.391918385079825e-15, -6.850771855701537e-17,  3.044485686324329e-18, -1.232154409422363e-19,  3.016604901466997e-08,
 -1.227615114135513e-08,  2.659222468930086e-09, -3.912100751987746e-10,  4.355941311878207e-11, -3.902800575299809e-12,  2.926742097307500e-13, -1.888004569294353e-14,
  1.069016394670341e-15, -5.395527235689539e-17,  2.457254081746342e-18, -1.018456743984638e-19,  1.894665659509023e-08, -7.886501471686906e-09,  1.751374049640692e-09,
 -2.641701995025183e-10,  3.014722782455158e-11, -2.767011210059620e-12,  2.124435322360669e-13, -1.402282331014133e-14,  8.119690110506057e-16, -4.188559120214262e-17,
  1.948564229835174e-18, -8.244832625570391e-20,  1.205772892949499e-08, -5.114445835207861e-09,  1.159747844634755e-09, -1.786481682358419e-10,  2.081467619593524e-11,
 -1.949665884299958e-12,  1.526927676642140e-13, -1.027609499070762e-14,  6.063750532218800e-16, -3.186175828662591e-17,  1.509110063710333e-18, -6.497870096264030e-20,
  7.681453580266495e-09, -3.307959662339302e-09,  7.628973244845185e-10, -1.195374086861607e-10,  1.416398416272747e-11, -1.348790749016536e-12,  1.073522995014087e-13,
 -7.339443391224106e-15,  4.397958458726989e-16, -2.345786777694308e-17,  1.127419997068076e-18, -4.923852895702465e-20,  4.771126971534153e-09, -2.078491949091371e-09,
  4.855868503279662e-10, -7.708556644847701e-11,  9.252451368273837e-12, -8.923026994212787e-13,  7.190424492322844e-14, -4.975719001818876e-15,  3.016937195800787e-16,
 -1.627795792901444e-17,  7.911687392703133e-19, -3.493213222115989e-20,  2.703816049420411e-09, -1.187301824739477e-09,  2.798756602716863e-10, -4.483319032034060e-11,
  5.429603147088594e-12, -5.282459875690914e-13,  4.293471462035083e-14, -2.996079460497854e-15,  1.831553502635768e-16, -9.961438521816940e-18,  4.879487726011506e-19,
 -2.170797828964835e-20,  1.088563187930666e-09, -4.801252456278604e-10,  1.137412690331218e-10, -1.831207439978672e-11,  2.228781382904784e-12, -2.179001575001130e-13,
  1.779533778090898e-14, -1.247611514866363e-15,  7.661706777698320e-17, -4.185617715815792e-18,  2.059186488319589e-19, -9.199677547736404e-21,  7.021789450736544e-02,
 -2.059424574272304e-04,  6.305519950369974e-07, -1.997551409825578e-09,  6.483372529335157e-12, -2.137501160027584e-14,  7.110110274713264e-17, -2.375140883043438e-19,
  7.942305477808813e-22, -2.653556054200952e-24,  8.846744153172582e-27, -2.941468013120941e-29,  6.725659277848094e-02, -2.639089435721784e-04,  1.226526340693999e-06,
 -5.840075580749078e-09,  2.727850521965509e-11, -1.241869832483009e-13,  5.522756029346484e-16, -2.407262915535222e-18,  1.031394492242095e-20, -4.353460213464952e-23,
  1.813448822118241e-25, -7.464973166713633e-28,  6.171141886018773e-02, -3.644461196736107e-04,  2.445594014855899e-06, -1.541102272211614e-08,  9.137750859085922e-11,
 -5.170763138093674e-13,  2.819650930159095e-15, -1.491247701205228e-17,  7.684030216213374e-20, -3.870717455470750e-22,  1.911218291215064e-24, -9.269587136239202e-27,
  5.425668562181633e-02, -4.816631013275471e-04,  4.281564008514012e-06, -3.379986451272531e-08,  2.456327409234109e-10, -1.678872600825101e-12,  1.092957072854940e-14,
 -6.834657239344388e-17,  4.130525363437233e-19, -2.423601395651565e-21,  1.385583139211476e-23, -7.739984646164707e-26,  4.572661822745118e-02, -5.870496305256405e-04,
  6.616774180487357e-06, -6.397768097185429e-08,  5.590823192771662e-10, -4.531415917221617e-12,  3.460225956419890e-14, -2.515819945294299e-16,  1.754896525763669e-18,
 -1.181089642908138e-20,  7.703307330320678e-23, -4.885726870609445e-25,  3.696090939371487e-02, -6.573845611565957e-04,  9.182990129180520e-06, -1.071090014499444e-07,
  1.109330616457475e-09, -1.051797313389101e-11,  9.301347904573844e-14, -7.768679279296089e-16,  6.183255153400637e-18, -4.721147374750137e-20,  3.475902282145029e-22,
 -2.477549303367545e-24,  2.867236783621651e-02, -6.800343855056126e-04,  1.159527726733588e-05, -1.611110415065643e-07,  1.954838102369415e-09, -2.145247841676186e-11,
  2.175399635001399e-13, -2.067848623399565e-15,  1.861394766189776e-17, -1.598769358236462e-19,  1.317925647927505e-21, -1.047442156587814e-23,  2.136402304051600e-02,
 -6.543347390901820e-04,  1.344952299052851e-05, -2.202089856216480e-07,  3.100182278826953e-09, -3.903552090259135e-11,  4.502569735106853e-13, -4.834185906199977e-15,
  4.886166604606686e-17, -4.688658330309183e-19,  4.299061210092549e-21, -3.785590414446161e-23,  1.530438399726743e-02, -5.893778124305580e-04,  1.443895803770976e-05,
 -2.759223179629912e-07,  4.469990393643670e-09, -6.409904339399143e-11,  8.352434739351357e-13, -1.006408588894851e-14,  1.135303222314371e-16, -1.210087918598286e-18,
  1.227319965065654e-20, -1.191030189019943e-22,  1.055218803354865e-02, -4.997008269265464e-04,  1.443758542300179e-05, -3.192517222927866e-07,  5.907923007528621e-09,
 -9.585406120660978e-11,  1.402592755495641e-12, -1.886117398432953e-14,  2.362198818654539e-16, -2.782769093742170e-18,  3.107127239922274e-20, -3.307754677685748e-22,
  7.011512255515668e-03, -4.007007415099349e-04,  1.351909603264699e-05, -3.432178399089761e-07,  7.207303901552542e-09, -1.315304808155989e-10,  2.149719852516969e-12,
 -3.210248906410645e-14,  4.442953313017721e-16, -5.759289256487953e-18,  7.049523781776167e-20, -8.199437796444937e-22,  4.496170220971895e-03, -3.051736721701123e-04,
  1.191259372391350e-05, -3.447254280007993e-07,  8.164554861078794e-09, -1.666980791242714e-10,  3.028336964351573e-12, -4.999486141386219e-14,  7.614001900964239e-16,
 -1.081722020947363e-17,  1.445995350714639e-19, -1.830882984984729e-21,  2.786944939937073e-03, -2.215839850620274e-04,  9.922009671696789e-06, -3.250824578218780e-07,
  8.634786880228566e-09, -1.962603077448862e-10,  3.945204812464941e-12, -7.170577863243978e-14,  1.197056271275058e-15, -1.857104619454585e-17,  2.701716482993316e-19,
 -3.711583031272006e-21,  1.672774441414989e-03, -1.539306314067143e-04,  7.843793144152045e-06, -2.891467433998702e-07,  8.567861881870199e-09, -2.157802579199302e-10,
  4.779526906586658e-12, -9.526923545938203e-14,  1.737080253270263e-15, -2.932826098951317e-17,  4.628523926657398e-19, -6.877806077605011e-21,  9.741303954685344e-04,
 -1.026519591335264e-04,  5.908722976553892e-06, -2.436244164725903e-07,  8.013052592265604e-09, -2.226297873324621e-10,  5.412114638814838e-12, -1.178780234279934e-13,
  2.339545299624648e-15, -4.285043538108352e-17,  7.313906123227797e-19, -1.172166460566866e-20,  5.515639252754483e-04, -6.593092771566416e-05,  4.257463817409351e-06,
 -1.952520661960620e-07,  7.094690379152458e-09, -2.165433729968898e-10,  5.755665921081138e-12, -1.365054345703136e-13,  2.939514777980170e-15, -5.822873979637744e-17,
  1.071815658204333e-18, -1.847568184904056e-20,  3.043581661479924e-04, -4.091719951950900e-05,  2.945191035105751e-06, -1.494468647040668e-07,  5.971972954020387e-09,
 -1.994401439772035e-10,  5.775015047545746e-12, -1.486436103526615e-13,  3.462184261050519e-15, -7.395761321643097e-17,  1.464046715940053e-18, -2.707273495911067e-20,
  1.640892438218325e-04, -2.461747050752467e-05,  1.963285669135765e-06, -1.096755668083150e-07,  4.798973534680475e-09, -1.746817911258944e-10,  5.491039621328208e-12,
 -1.528916444252955e-13,  3.840251885192770e-15, -8.821370379611261e-17,  1.872991301772490e-18, -3.705971118275307e-20,  8.666866337567718e-05, -1.440635074592233e-05,
  1.265804760949070e-06, -7.747639278682766e-08,  3.696573539588358e-09, -1.461091715644155e-10,  4.969013587646691e-12, -1.492000493495127e-13,  4.029421344922751e-15,
 -9.925772296554451e-17,  2.254534517866583e-18, -4.761347359561520e-20,  4.497761348418327e-05, -8.228618769519460e-06,  7.922909530433279e-07, -5.288983679800325e-08,
  2.740544047958164e-09, -1.171956193148904e-10,  4.297764642758735e-12, -1.387303763706165e-13,  4.016904115225609e-15, -1.058229326884677e-16,  2.564768904844673e-18,
 -5.767158437728646e-20,  2.300549294559050e-05, -4.603584008009633e-06,  4.832633473155698e-07, -3.502979023293083e-08,  1.963490963444629e-09, -9.052155992051738e-11,
  3.567792792798655e-12, -1.234349215101914e-13,  3.820912969431285e-15, -1.073631689808898e-16,  2.769442664851214e-18, -6.614378406081797e-20,  1.163578275343732e-05,
 -2.531881371589427e-06,  2.883640888484664e-07, -2.259972265754665e-08,  1.365064796435361e-09, -6.760880584477581e-11,  2.854712576084824e-12, -1.055360973237890e-13,
  3.482648735719677e-15, -1.040963202307539e-16,  2.850600852641291e-18, -7.213728159486360e-20,  5.839702681473491e-06, -1.374039732977244e-06,  1.689920408442246e-07,
 -1.426028704709388e-08,  9.246985619431850e-10, -4.903137310216419e-11,  2.210803946279234e-12, -8.707319543837312e-14,  3.054525449652882e-15, -9.685960577105225e-17,
  2.808660599977132e-18, -7.512560924267680e-20,  2.918669594019084e-06, -7.386514738149386e-07,  9.765616765970799e-08, -8.836758964191999e-09,  6.128756906438275e-10,
 -3.467198051611315e-11,  1.664106775197100e-12, -6.961532711408048e-14,  2.588692902732937e-15, -8.685214591499692e-17,  2.659956566807835e-18, -7.501646541011067e-20,
  1.458144512952620e-06, -3.948913324816531e-07,  5.587367204733756e-08, -5.399990407355545e-09,  3.990989473836433e-10, -2.400670373239595e-11,  1.222555058516034e-12,
 -5.415867369560770e-14,  2.128702671102234e-15, -7.535821609034923e-17,  2.431246142244057e-18, -7.211344372288372e-20,  7.309688684907842e-07, -2.107911600716553e-07,
  3.178111804284583e-08, -3.267606227548898e-09,  2.564094934237112e-10, -1.634344605403955e-11,  8.802618655878877e-13, -4.116813872116590e-14,  1.705369554557005e-15,
 -6.352518544061250e-17,  2.153255916579763e-18, -6.700071771865126e-20,  3.691130981396856e-07, -1.128004431672608e-07,  1.804530009421980e-08, -1.966052444725599e-09,
  1.632022440174668e-10, -1.098494666621726e-11,  6.237123979176843e-13, -3.070010086060181e-14,  1.336367025061815e-15, -5.223222541823775e-17,  1.855079296553442e-18,
 -6.039612885415728e-20,  1.884748202911052e-07, -6.075513228765171e-08,  1.026941267841437e-08, -1.180997776750667e-09,  1.033265491295372e-10, -7.318774697338676e-12,
  4.366273011170909e-13, -2.254793924490917e-14,  1.028288922748695e-15, -4.204942737481402e-17,  1.560461561923828e-18, -5.301517575800195e-20,  9.768050385323630e-08,
 -3.306351410510931e-08,  5.880445691812436e-09, -7.110309480741157e-10,  6.532485099422768e-11, -4.852157254889256e-12,  3.031372818893499e-13, -1.637135603803525e-14,
  7.797954586201083e-16, -3.326400013349998e-17,  1.286174701711238e-18, -4.547299039171236e-20,  5.156565140741727e-08, -1.824711336471652e-08,  3.400587234085470e-09,
 -4.306300725468291e-10,  4.139064795397374e-11, -3.212499963475013e-12,  2.094594553697885e-13, -1.179164909737747e-14,  5.847799885872761e-16, -2.594292351537463e-17,
  1.042092721133745e-18, -3.823296411752593e-20,  2.781611110422354e-08, -1.024584252551438e-08,  1.992561848236920e-09, -2.632222796146647e-10,  2.636885569696563e-11,
 -2.130821664214012e-12,  1.444935313702036e-13, -8.450859623081147e-15,  4.349521008614623e-16, -2.000549507799012e-17,  8.323235907347959e-19, -3.159638490213627e-20,
  1.537313073932005e-08, -5.869445694139836e-09,  1.186243186393261e-09, -1.628248688357792e-10,  1.693566061180302e-11, -1.419635903604246e-12,  9.976647440152323e-14,
 -6.041303553911290e-15,  3.216322086079886e-16, -1.528837737751222e-17,  6.567742203337220e-19, -2.572013528691643e-20,  8.720485802440825e-09, -3.436868399927796e-09,
  7.188853976749191e-10, -1.021183551116338e-10,  1.098543637973680e-11, -9.516724331635575e-13,  6.906087537784714e-14, -4.314728910872901e-15,  2.368104787341354e-16,
 -1.159504844019142e-17,  5.126936515572595e-19, -2.064847822121888e-20,  5.079887562346560e-09, -2.058273480082572e-09,  4.437364436817546e-10, -6.496974514767854e-11,
  7.200332150713204e-12, -6.421938508553195e-13,  4.794538691573228e-14, -3.079582547346330e-15,  1.736411880110093e-16, -8.728381549908500e-18,  3.959421374606876e-19,
 -1.634779135462900e-20,  3.034134147296699e-09, -1.258874148195881e-09,  2.785678861778067e-10, -4.186847284322799e-11,  4.761333786473757e-12, -4.355179226953948e-13,
  3.332662793461666e-14, -2.192681675553556e-15,  1.265642396015349e-16, -6.508876037051488e-18,  3.019000642027719e-19, -1.273728904323499e-20,  1.848862149575585e-09,
 -7.824413157441727e-10,  1.769800760988742e-10, -2.719332086916828e-11,  3.160484729388218e-12, -2.953173679118481e-13,  2.307378112802634e-14, -1.549270590787103e-15,
  9.121506725983026e-17, -4.782421210361726e-18,  2.260361576112532e-19, -9.712583260986657e-21,  1.136186934518102e-09, -4.885664567241157e-10,  1.124897348129477e-10,
 -1.759661940879494e-11,  2.081612465210508e-12, -1.979079851846878e-13,  1.572719658139660e-14, -1.073598133611358e-15,  6.423708451339915e-17, -3.421341796811415e-18,
  1.642039752342593e-19, -7.161615778365941e-21,  6.861951426784109e-10, -2.986735154224966e-10,  6.970940011862430e-11, -1.105527764898873e-11,  1.325656291368951e-12,
 -1.277239186899560e-13,  1.028276475442028e-14, -7.109128339451216e-16,  4.306671521064216e-17, -2.321667848156554e-18,  1.127466108479827e-19, -4.973979711345896e-21,
  3.812890818025159e-10, -1.673572346563569e-10,  3.943028897177780e-11, -6.313106295796881e-12,  7.641739504630395e-13, -7.430955978015727e-14,  6.036784371047394e-15,
 -4.210595245128054e-16,  2.572808142574614e-17, -1.398659451224586e-18,  6.848110031431345e-20, -3.045280909159953e-21,  1.518227012964606e-10, -6.694939723118334e-11,
  1.585648187991659e-11, -2.552236195657868e-12,  3.105600691176607e-13, -3.035509358059099e-14,  2.478435047359342e-15, -1.737198628047329e-16,  1.066586316807020e-17,
 -5.825484017180736e-19,  2.865310556773836e-20, -1.279835199554705e-21,  6.940406414319485e-02, -2.009921923559470e-04,  6.071899686490553e-07, -1.897146945945864e-09,
  6.072412356746936e-12, -1.974560381766667e-14,  6.479263517173143e-17, -2.135613137006420e-19,  7.047723853455840e-22, -2.324251567573645e-24,  7.649793358601062e-27,
 -2.511324776885918e-29,  6.622014781173281e-02, -2.543698209175330e-04,  1.158984478587317e-06, -5.422791511393684e-09,  2.492203880623085e-11, -1.117053135196829e-13,
  4.892669007105151e-16, -2.100954393019172e-18,  8.869726568898016e-21, -3.689695576957476e-23,  1.514959928220672e-25, -6.147908149614645e-28,  6.029162673000191e-02,
 -3.455970047160806e-04,  2.269104246634400e-06, -1.402817509778304e-08,  8.168026025358189e-11, -4.541497963574747e-13,  2.434531946899714e-15, -1.266254796593293e-17,
  6.418891917532834e-20, -3.181920099359104e-22,  1.546483435123033e-24, -7.384653815830975e-27,  5.239606052227871e-02, -4.489686330662153e-04,  3.898482772756614e-06,
 -3.012473289784835e-08,  2.145307662905842e-10, -1.438110706623760e-12,  9.188523437590373e-15, -5.642423856101581e-17,  3.350098379456687e-19, -1.931896497780112e-21,
  1.085851439127623e-23, -5.965144696607597e-26,  4.347963175044479e-02, -5.370409014233528e-04,  5.899863057020351e-06, -5.571455478838929e-08,  4.762191578034217e-10,
 -3.779520143860567e-12,  2.828424512864616e-14, -2.016733132169530e-16,  1.380352243870601e-18, -9.120007948180377e-21,  5.841718642661184e-23, -3.639989703633726e-25,
  3.447056456171965e-02, -5.887753687252855e-04,  7.997609596019159e-06, -9.092831044651847e-08,  9.196416739144716e-10, -8.525798138988016e-12,  7.379373089069346e-14,
 -6.037137373237371e-16,  4.709692432180529e-18, -3.526577310787800e-20,  2.547481573111550e-22, -1.782324000464358e-24,  2.612622016638939e-02, -5.945046392067894e-04,
  9.836318464599413e-06, -1.330008959780098e-07,  1.573634790819442e-09, -1.686398391129694e-11,  1.671816299725129e-13, -1.554954713352572e-15,  1.370580572407094e-17,
 -1.153424863262511e-19,  9.321085425771906e-22, -7.265835707261876e-24,  1.894625735305501e-02, -5.565210725433280e-04,  1.108065259523338e-05, -1.763076488114803e-07,
  2.417420619753437e-09, -2.969144192889194e-11,  3.344712963918367e-13, -3.510495704697574e-15,  3.471438357306891e-17, -3.261249640397775e-19,  2.929292454417317e-21,
 -2.528171930157013e-23,  1.315852236926700e-02, -4.859853837336961e-04,  1.151798693098133e-05, -2.136580695285403e-07,  3.367605023201009e-09, -4.706130961715470e-11,
  5.983821116249282e-13, -7.042759475587207e-15,  7.767114960399410e-17, -8.099652179126737e-19,  8.042477489404595e-21, -7.645177415239909e-23,  8.762213463881568e-03,
 -3.980519194777499e-04,  1.111593018547942e-05, -2.383979203868837e-07,  4.288737680683684e-09, -6.775966424048838e-11,  9.668043252334646e-13, -1.269099203394211e-14,
  1.552963757088455e-16, -1.788884758032427e-18,  1.954447461452250e-20, -2.037161331953737e-22,  5.601455509939273e-03, -3.072451646830868e-04,  1.001388296435697e-05,
 -2.464216067359907e-07,  5.027374256992093e-09, -8.929080373517034e-11,  1.422231414365748e-12, -2.072171380245434e-14,  2.800735489707335e-16, -3.548467648485545e-18,
  4.248326262210180e-20, -4.836266104880665e-22,  3.442708684726054e-03, -2.244288856808528e-04,  8.461266272033157e-06, -2.372459539949290e-07,  5.456841649824014e-09,
 -1.083865390858054e-10,  1.918175445230282e-12, -3.088514997842272e-14,  4.592020999086267e-16, -6.374455755064916e-18,  8.332149155700641e-20, -1.032302554862279e-21,
  2.037615657731077e-03, -1.557311937474733e-04,  6.735398819964233e-06, -2.137949703956995e-07,  5.513798476394027e-09, -1.218903717287340e-10,  2.386420850603509e-12,
 -4.229384591657103e-14,  6.891535066615672e-16, -1.044464919203537e-17,  1.485551428423379e-19, -1.996640603806759e-21,  1.163481105338248e-03, -1.030204490445052e-04,
  5.072089674301765e-06, -1.811585935859278e-07,  5.212017333590841e-09, -1.276618957578370e-10,  2.753886031620183e-12, -5.352153969837414e-14,  9.524567978255835e-16,
 -1.570878569827010e-17,  2.423644370199957e-19, -3.523341028393792e-21,  6.422291658595728e-04, -6.519415393888102e-05,  3.627672106139382e-06, -1.449653942277001e-07,
  4.630351915614808e-09, -1.251322315298495e-10,  2.962813913394607e-12, -6.292428882711153e-14,  1.218981164974496e-15, -2.181133222742883e-17,  3.639808166503233e-19,
 -5.707316628251409e-21,  3.434652773776610e-04, -3.959969769112162e-05,  2.473783365043741e-06, -1.100090547590537e-07,  3.883265660297352e-09, -1.153201764022234e-10,
  2.986175907560761e-12, -6.907396643617173e-14,  1.452145260723442e-15, -2.810732498938598e-17,  5.059284716864483e-19, -8.534305362775738e-21,  1.784020606712307e-04,
 -2.316517637260615e-05,  1.614515381340859e-06, -7.949290375556746e-08,  3.087616808926923e-09, -1.003719372932797e-10,  2.832608322938630e-12, -7.113497953961343e-14,
  1.618101403123975e-15, -3.378531123724696e-17,  6.542205152023296e-19, -1.184227344829229e-20,  9.024019339843594e-05, -1.309561598240148e-05,  1.012336054479785e-06,
 -5.491952334149030e-08,  2.337400028939522e-09, -8.286890127087103e-11,  2.540216617305736e-12, -6.904358165281656e-14,  1.694432285149602e-15, -3.806156013469813e-17,
  7.908603858935611e-19, -1.532443443502229e-20,  4.458015783726358e-05, -7.179417305603545e-06,  6.121849004824608e-07, -3.642422739490678e-08,  1.691836127380600e-09,
 -6.518162278634183e-11,  2.163169000144421e-12, -6.344413107690354e-14,  1.675146238686908e-15, -4.037481444226730e-17,  8.979603189033644e-19, -1.858155065341421e-20,
  2.157664761170597e-05, -3.830935365796049e-06,  3.584442144115663e-07, -2.328652814074880e-08,  1.175815914319681e-09, -4.905609028892968e-11,  1.756936095146003e-12,
 -5.543991870600158e-14,  1.570532592525929e-15, -4.051106211945122e-17,  9.620250105613718e-19, -2.120962252154381e-20,  1.026568288232724e-05, -1.997167181544823e-06,
  2.040281795680230e-07, -1.441072370626017e-08,  7.880184541422295e-10, -3.548015709149742e-11,  1.367034840785921e-12, -4.627483643922212e-14,  1.402643153818737e-15,
 -3.862119681895731e-17,  9.768889855898017e-19, -2.289295441454702e-20,  4.818523049621974e-06, -1.021239241503359e-06,  1.133671212235282e-07, -8.669369950451705e-09,
  5.114912993188575e-10, -2.476929311470518e-11,  1.023494317479317e-12, -3.705872585060359e-14,  1.198642998051616e-15, -3.514026666413086e-17,  9.444350332903023e-19,
 -2.347070569309814e-20,  2.239851999179025e-06, -5.143084166959868e-07,  6.175401584055604e-08, -5.092213938748722e-09,  3.229737272576048e-10, -1.676537201186991e-11,
  7.406541429552867e-13, -2.860236451578778e-14,  9.844974585596049e-16, -3.065109491841429e-17,  8.731613628745926e-19, -2.295754867934228e-20,  1.035263520725658e-06,
 -2.561833081777239e-07,  3.312310301983431e-08, -2.933478837461784e-09,  1.992874678016046e-10, -1.105215900392440e-11,  5.203927739677890e-13, -2.137148300436929e-14,
  7.806695704628000e-16, -2.574438322939488e-17,  7.754129436302567e-19, -2.151821548855997e-20,  4.777881550780712e-07, -1.267708643805713e-07,  1.757278025481090e-08,
 -1.664928907837185e-09,  1.207159076844469e-10, -7.128564305236559e-12,  3.566247945135427e-13, -1.552940115691812e-14,  6.003410356657895e-16, -2.091446565418799e-17,
  6.643554643209493e-19, -1.941158518114975e-20,  2.211385835293003e-07, -6.260240846102975e-08,  9.263798791913211e-09, -9.353074725410247e-10,  7.211593069940738e-11,
 -4.519396340380746e-12,  2.394662758126634e-13, -1.102380427082886e-14,  4.497329258590677e-16, -1.650680048818570e-17,  5.515640767621017e-19, -1.692634540965574e-20,
  1.031038701453209e-07, -3.099280950862582e-08,  4.875240620959774e-09, -5.224970162104212e-10,  4.268728521713833e-11, -2.829346396664925e-12,  1.582754002362109e-13,
 -7.679349659546169e-15,  3.296625402158846e-16, -1.271259894989032e-17,  4.456488359142950e-19, -1.432701041974763e-20,  4.864303707413497e-08, -1.545372943668195e-08,
  2.573240599315834e-09, -2.916090526833059e-10,  2.515189152449869e-11, -1.757126112628868e-12,  1.034372206972641e-13, -5.273055235915093e-15,  2.374868765928650e-16,
 -9.594542929241375e-18,  3.519000821812765e-19, -1.182038180844057e-20,  2.332578468999232e-08, -7.796260807181482e-09,  1.368446459677253e-09, -1.633363811397010e-10,
  1.481855094219503e-11, -1.087335027641645e-12,  6.713309149950676e-14, -3.584373480990558e-15,  1.688482697625523e-16, -7.125688174702565e-18,  2.726660426620674e-19,
 -9.543492516279454e-21,  1.141794316027205e-08, -3.996916407904317e-09,  7.364519932258169e-10, -9.221918726154621e-11,  8.767416287776072e-12, -6.732945317135835e-13,
  4.345060469472350e-14, -2.421823540588686e-15,  1.189504167007418e-16, -5.227884702970299e-18,  2.080989043136729e-19, -7.568030599048169e-21,  5.728053230210460e-09,
 -2.090817487756868e-09,  4.027106878892612e-10, -5.269383547191783e-11,  5.229787291978276e-12, -4.188030764077777e-13,  2.815128461932947e-14, -1.632499631604041e-15,
  8.333127023397327e-17, -3.802228456160730e-18,  1.569665965952027e-19, -5.914053136867247e-21,  2.955281902049076e-09, -1.119946176797406e-09,  2.245452597826709e-10,
 -3.057776140815007e-11,  3.155868937754886e-12, -2.625530769595496e-13,  1.831651654539645e-14, -1.101288699601540e-15,  5.822831328178906e-17, -2.749344614626424e-18,
  1.173445135648854e-19, -4.566544231982364e-21,  1.572207074590776e-09, -6.159489482088401e-10,  1.280096794907331e-10, -1.806757542243157e-11,  1.931453158114246e-12,
 -1.663015584999293e-13,  1.199658487144958e-14, -7.451961255142061e-16,  4.067081519512278e-17, -1.980572350262589e-18,  8.711265268848853e-20, -3.490506265678263e-21,
  8.636213156637822e-10, -3.483140619739663e-10,  7.471537787957524e-11, -1.088468741042690e-11,  1.200381281402372e-12, -1.065487287645053e-13,  7.917743304108224e-15,
 -5.062631895644819e-16,  2.841998048450054e-17, -1.422481024223043e-18,  6.425985936276854e-20, -2.642522246058103e-21,  4.894647975784217e-10, -2.023877131277065e-10,
  4.461703779359460e-11, -6.680709643187455e-12,  7.569357736030181e-13, -6.898743158171029e-14,  5.260542045724363e-15, -3.449309216458833e-16,  1.984388861038545e-17,
 -1.017236390375816e-18,  4.703476622277881e-20, -1.978402821734460e-21,  2.850059833075445e-10, -1.203256387028609e-10,  2.714415577945465e-11, -4.159637597497962e-12,
  4.821778629959048e-13, -4.493959431069295e-14,  3.502468141947422e-15, -2.345995909149011e-16,  1.377971404322279e-17, -7.208147198434146e-19,  3.399255223099618e-20,
 -1.457472120224176e-21,  1.686568174496537e-10, -7.240984184489824e-11,  1.664291631944536e-11, -2.598865265412315e-12,  3.069048690215708e-13, -2.912949895726408e-14,
  2.311026806545585e-15, -1.575063476175846e-16,  9.409432117498619e-18, -5.003958145771086e-19,  2.398050920741649e-20, -1.044389440059576e-21,  9.890164989767986e-11,
 -4.300837687647604e-11,  1.002767513352419e-11, -1.588646429368354e-12,  1.903018914791584e-13, -1.831673162458440e-14,  1.473192027047728e-15, -1.017536551547260e-16,
  6.158431800461655e-18, -3.316909202034089e-19,  1.609356555094082e-20, -7.093802123200656e-22,  5.382870275852251e-11, -2.361567106482130e-11,  5.561042907228773e-12,
 -8.898913809098473e-13,  1.076604034923168e-13, -1.046362760440389e-14,  8.496139364332639e-16, -5.923012250078146e-17,  3.617383489261176e-18, -1.965585589166604e-19,
  9.619406138604158e-21, -4.275704292882821e-22,  2.118589732087343e-11, -9.340335063150155e-12,  2.211644983983484e-12, -3.558935496560522e-13,  4.329481236575825e-14,
 -4.230716830688687e-15,  3.453452846755315e-16, -2.420029645709208e-17,  1.485470754497522e-18, -8.111453591073521e-20,  3.988766609702433e-21, -1.781243051241883e-22,
  6.860966852301709e-02, -1.962241134383045e-04,  5.849943930226202e-07, -1.803065143476327e-09,  5.692579006000446e-12, -1.825986397276582e-14,  5.911648642647157e-17,
 -1.922904037114255e-19,  6.263510953058410e-22, -2.039246403298345e-24,  6.626890552031139e-27, -2.148324418360291e-29,  6.522080949887377e-02, -2.453516260308427e-04,
  1.096231784038008e-06, -5.041293175993215e-09,  2.280075232484012e-11, -1.006379424462976e-13,  4.342221707093165e-16, -1.837257136955918e-18,  7.644298603971251e-21,
 -3.134500393398835e-23,  1.268810562095640e-25, -5.076948939631935e-28,  5.894450871815130e-02, -3.280959763812268e-04,  2.108317675429400e-06, -1.279089677454683e-08,
  7.315398948806915e-11, -3.997537113263094e-13,  2.107096760957379e-15, -1.078044968953001e-17,  5.377342104461016e-20, -2.623692814040053e-22,  1.255431525633181e-24,
 -5.903334045770410e-27,  5.066035182742851e-02, -4.191705163590220e-04,  3.556669173822335e-06, -2.691087267458590e-08,  1.878518260946928e-10, -1.235394680561625e-12,
  7.748842939454132e-15, -4.673774322719534e-17,  2.726862290123838e-19, -1.545811639192277e-21,  8.543814210405850e-24, -4.616747311857294e-26,  4.142180723214416e-02,
 -4.923922784128031e-04,  5.274625390142625e-06, -4.866472269340095e-08,  4.069841436803402e-10, -3.163757127191933e-12,  2.320947529683421e-14, -1.623337375838023e-16,
  1.090500012596277e-18, -7.074674467550821e-21,  4.451442001357671e-23, -2.725600560175016e-25,  3.223685109962205e-02, -5.289212696956325e-04,  6.989425151629818e-06,
 -7.748739966386684e-08,  7.655502649131613e-10, -6.941672551241278e-12,  5.882201081300742e-14, -4.714937395135506e-16,  3.606098540076044e-18, -2.648700216500415e-20,
  1.877706757391821e-22, -1.289793329062734e-24,  2.389604681590870e-02, -5.217943927619402e-04,  8.380914195203413e-06, -1.103169301565306e-07,  1.273192808760670e-09,
 -1.332812353554885e-11,  1.292067621250586e-13, -1.176192185345139e-15,  1.015408526767525e-17, -8.374647498481562e-20,  6.636130607399138e-22, -5.074684331817511e-24,
  1.688493628851511e-02, -4.757235350740768e-04,  9.178763477661172e-06, -1.419746919713186e-07,  1.896508575998093e-09, -2.272822064299297e-11,  2.501139201025063e-13,
 -2.566879286682264e-15,  2.483980423919769e-17, -2.285165243962337e-19,  2.011157138222673e-21, -1.701632063131013e-23,  1.138383546457243e-02, -4.032478642364367e-04,
  9.248675536859558e-06, -1.665882269924662e-07,  2.555362335597380e-09, -3.481052279980885e-11,  4.320052513431730e-13, -4.967767519921378e-15,  5.357437909795248e-17,
 -5.467140255945321e-19,  5.315654804369971e-21, -4.950779598627974e-23,  7.331263144175438e-03, -3.194964067358880e-04,  8.625929001427338e-06, -1.794703785618576e-07,
  3.139462265366379e-09, -4.831349749444022e-11,  6.723299161730733e-13, -8.616972552993706e-15,  1.030455514845973e-16, -1.160905897813752e-18,  1.241311461658799e-20,
 -1.267032717397044e-22,  4.515734575666717e-03, -2.377194754816400e-04,  7.486028954545943e-06, -1.785960118890135e-07,  3.540669609459240e-09, -6.121426438982097e-11,
  9.504094561898522e-13, -1.351286756116139e-14,  1.783965092961251e-16, -2.209540935180016e-18,  2.587837261328015e-20, -2.883803108119993e-22,  2.664239755426304e-03,
 -1.667921443386010e-04,  6.074001908420078e-06, -1.650436918327414e-07,  3.687184414120570e-09, -7.125833037944769e-11,  1.228733122624121e-12, -1.929862984660776e-14,
  2.801636490733578e-16, -3.800575405803447e-18,  4.858305943209109e-20, -5.890430336741399e-22,  1.508105106911647e-03, -1.107772953903907e-04,  4.627815247330600e-06,
 -1.423266434297700e-07,  3.564350871984953e-09, -7.664534171502303e-11,  1.461685256852231e-12, -2.526264306055727e-14,  4.018312820843604e-16, -5.950091402099162e-18,
  8.274690368167752e-20, -1.088173901713665e-21,  8.205568506016839e-04, -6.989468996271061e-05,  3.324659355472846e-06, -1.150548042435719e-07,  3.214128803523497e-09,
 -7.657024289066184e-11,  1.608733631419122e-12, -3.048671185773768e-14,  5.295483109502753e-16, -8.532216871283015e-18,  1.287019595946098e-19, -1.830520917639533e-21,
  4.300335656456322e-04, -4.203944180723334e-05,  2.261064472663246e-06, -8.756554210033416e-08,  2.716102065546111e-09, -7.139545647790699e-11,  1.646498969732454e-12,
 -3.409811296735261e-14,  6.447587102459789e-16, -1.127073831636884e-17,  1.838904622052991e-19, -2.821200318208646e-21,  2.175747048974976e-04, -2.418652372085777e-05,
  1.461377553248784e-06, -6.300790644412686e-08,  2.160510346982187e-09, -6.242144671129721e-11,  1.574644639445419e-12, -3.552300249832620e-14,  7.290568502326898e-16,
 -1.378815824499802e-17,  2.426897018155853e-19, -4.006063991457336e-21,  1.065432262867156e-04, -1.335642808739907e-05,  9.011060766335418e-07, -4.304156204528989e-08,
  1.624724612090095e-09, -5.140531542850120e-11,  1.413739733901569e-12, -3.463609784894748e-14,  7.693665451556623e-16, -1.570040925325018e-17,  2.973714950257757e-19,
 -5.268816557897407e-21,  5.063631896299772e-05, -7.104597867767140e-06,  5.321664736510945e-07, -2.802907035791751e-08,  1.160077224202880e-09, -4.005185884707831e-11,
  1.197021140559205e-12, -3.175503266655218e-14,  7.613396160955173e-16, -1.672132723265434e-17,  3.399729860043781e-19, -6.450544549344767e-21,  2.342814054915982e-05,
 -3.653480394039891e-06,  3.022066680155526e-07, -1.747319308673619e-08,  7.898685947737521e-10, -2.965527852956249e-11,  9.601571455452818e-13, -2.750148971860744e-14,
  7.097772297785558e-16, -1.673547499315225e-17,  3.643884502476219e-19, -7.387035041328403e-21,  1.058742937361034e-05, -1.823251776900942e-06,  1.656993305717015e-07,
 -1.047198730661784e-08,  5.150917942978890e-10, -2.095963520221183e-11,  7.329204251960454e-13, -2.260209063452069e-14,  6.262853367442594e-16, -1.581386314042358e-17,
  3.678752374795036e-19, -7.950409067703545e-21,  4.690051601294753e-06, -8.865303173511621e-07,  8.809146961238274e-08, -6.060072286012224e-09,  3.231581552615794e-10,
 -1.420475400581823e-11,  5.348476440656002e-13, -1.770875800226193e-14,  5.254574449499884e-16, -1.417382630361076e-17,  3.514595459366341e-19, -8.079470674488997e-21,
  2.044454020625254e-06, -4.217646572145091e-07,  4.560893272035347e-08, -3.401536900107489e-09,  1.959446621348136e-10, -9.273787323067201e-12,  3.748671948662352e-13,
 -1.328908768739246e-14,  4.211533799766739e-16, -1.210618800257416e-17,  3.192340556786524e-19, -7.788755499482286e-21,  8.806181910640508e-07, -1.971930479169913e-07,
  2.310211614399874e-08, -1.860555923604300e-09,  1.153670581273504e-10, -5.860107912247915e-12,  2.535435517723807e-13, -9.596673290587797e-15,  3.239853647838143e-16,
 -9.900012960083259e-18,  2.769680309573942e-19, -7.155866664670853e-21,  3.764627789785859e-07, -9.102616906224252e-08,  1.150272032271243e-08, -9.964812224288075e-10,
  6.627664624600362e-11, -3.601476497212101e-12,  1.662842770776761e-13, -6.701162061608731e-15,  2.403614935626368e-16, -7.788052255968780e-18,  2.306092634917664e-19,
 -6.294891758790950e-21,  1.604728591806224e-07, -4.168616158489246e-08,  5.657612020758674e-09, -5.251800947889666e-10,  3.733586251024615e-11, -2.163375507653472e-12,
  1.062698290324075e-13, -4.546766187612188e-15,  1.728055433808521e-16, -5.921931186377062e-18,  1.851415196106311e-19, -5.326911929977503e-21,  6.853966401550933e-08,
 -1.903470227265695e-08,  2.762829094012398e-09, -2.737611155450299e-10,  2.072930450051194e-11, -1.276589090714202e-12,  6.651203230770392e-14, -3.012486988003539e-15,
  1.209828217000238e-16, -4.373514142012665e-18,  1.440032769805880e-19, -4.356676464678984e-21,  2.948045779368137e-08, -8.711039290968748e-09,  1.346543189875676e-09,
 -1.418779098746360e-10,  1.140191060195587e-11, -7.438033639794498e-13,  4.097460396114952e-14, -1.958754142633056e-15,  8.288805020105547e-17, -3.152277843755174e-18,
  1.090286777883885e-19, -3.459791851192144e-21,  1.283563816720530e-08, -4.016461995784174e-09,  6.584434376664755e-10, -7.348749609602851e-11,  6.245395640355311e-12,
 -4.301101445256196e-13,  2.497163978754881e-14, -1.256098169669202e-15,  5.584445114266289e-17, -2.228037464011224e-18,  8.073185686377981e-20, -2.680119432363710e-21,
  5.686450661107162e-09, -1.875645692674027e-09,  3.247359693925317e-10, -3.824121868443634e-11,  3.424269112437535e-12, -2.480947174339445e-13,  1.513072837755027e-14,
 -7.983194756099695e-16,  3.717614757820314e-17, -1.551512922419527e-18,  5.873130233013333e-20, -2.034259642669759e-21,  2.576406645152597e-09, -8.917213988495890e-10,
  1.623622721645516e-10, -2.009436708655254e-11,  1.888741464837368e-12, -1.434507789723453e-13,  9.158837516535757e-15, -5.052191039715280e-16,  2.456612638619944e-17,
 -1.069215016363668e-18,  4.216054624308951e-20, -1.519315326674555e-21,  1.199595455219409e-09, -4.337128096585698e-10,  8.269739209146701e-11, -1.071323785779333e-11,
  1.052967064257173e-12, -8.352809360952131e-14,  5.563360637232619e-15, -3.197647599694122e-16,  1.618238231713402e-17, -7.322234674165619e-19,  2.998424712322250e-20,
 -1.120892075546128e-21,  5.764908125092293e-10, -2.167619211559082e-10,  4.309679983779256e-11, -5.820116877214350e-12,  5.958174116248188e-13, -4.917873839409318e-14,
  3.404631908937679e-15, -2.031868077728428e-16,  1.066579006037490e-17, -5.000883267184249e-19,  2.119970477323740e-20, -8.195923615470335e-22,  2.869652128411054e-10,
 -1.117210450228282e-10,  2.306147055598856e-11, -3.233053356920670e-12,  3.433434089008354e-13, -2.937302510957491e-14,  2.105705443625490e-15, -1.300103340842830e-16,
  7.054000276953074e-18, -3.415578951032840e-19,  1.493994658687383e-20, -5.954242509966787e-22,  1.482952128265543e-10, -5.951963238505092e-11,  1.269979885280387e-11,
 -1.840371122981946e-12,  2.019095515640529e-13, -1.783165471595900e-14,  1.318595239657935e-15, -8.391014462147634e-17,  4.688676434067518e-18, -2.336254255206746e-19,
  1.050793759199490e-20, -4.302888670697454e-22,  7.957143942085864e-11, -3.278303072598164e-11,  7.198494572706725e-12, -1.073590415943012e-12,  1.211662972707980e-13,
 -1.100122621638001e-14,  8.357849458240883e-16, -5.460523427628159e-17,  3.130485280551920e-18, -1.599311783316283e-19,  7.370534628187757e-21, -3.090353581864870e-22,
  4.418132110618893e-11, -1.860538577107630e-11,  4.185392521372816e-12, -6.395742677184080e-13,  7.393313646401834e-14, -6.872039874640594e-15,  5.341781878507796e-16,
 -3.568831135426234e-17,  2.091013653844308e-18, -1.091160737215566e-19,  5.133658684492723e-21, -2.196105220484589e-22,  2.512993616365385e-11, -1.077122427110848e-11,
  2.471131639829682e-12, -3.851632191285630e-13,  4.540167131887116e-14, -4.301558150053999e-15,  3.406763649375874e-16, -2.317924778632462e-17,  1.382448289157679e-18,
 -7.340116714187620e-20,  3.512130615574568e-21, -1.527278210858065e-22,  1.428695253895615e-11, -6.206786120853311e-12,  1.445577611142871e-12, -2.287662698367291e-13,
  2.737397482360511e-14, -2.631979328869777e-15,  2.114679074487453e-16, -1.459140095549966e-17,  8.822470939544464e-19, -4.747204263273538e-20,  2.301185972853533e-21,
 -1.013410395460357e-22,  7.608167614396884e-12, -3.336200537204616e-12,  7.851756999695698e-13, -1.255750774034685e-13,  1.518381131070714e-14, -1.474924037503710e-15,
  1.196951313241402e-16, -8.340077695625354e-18,  5.090961364660005e-19, -2.764904435929542e-20,  1.352459878323195e-21, -6.008655407258428e-23,  2.957962091453900e-12,
 -1.303797702928452e-12,  3.086397810917915e-13, -4.965273543627926e-14,  6.038733629562841e-15, -5.899458389467491e-16,  4.814392036390745e-17, -3.372873509599704e-18,
  2.069839580653175e-19, -1.129968306928602e-20,  5.555241782839089e-22, -2.480197941155815e-23,  6.783399709657889e-02, -1.916291843026050e-04,  5.638922921776704e-07,
 -1.714830160425526e-09,  5.341144992566219e-12, -1.690347903775590e-14,  5.400227832824410e-17, -1.733724068806683e-19,  5.574904120041800e-22, -1.792135193133741e-24,
  5.751017697206213e-27, -1.841345105151750e-29,  6.425656812335458e-02, -2.368177014021579e-04,  1.037860504639670e-06, -4.692033990274549e-09,  2.088817845395910e-11,
 -9.080729565494082e-14,  3.860407160488656e-16, -1.609756834956929e-18,  6.602097392455354e-21, -2.668953666193289e-23,  1.065279345571227e-25, -4.203626391379794e-28,
  5.766491309918607e-02, -3.118240904078438e-04,  1.961594487815983e-06, -1.168174512243529e-08,  6.564113752960794e-11, -3.526195685781423e-13,  1.827980985584427e-15,
 -9.201618869002535e-18,  4.517278968204615e-20, -2.169829677346704e-22,  1.022385449500237e-24, -4.735014131789053e-27,  4.903860098190597e-02, -3.919596034510250e-04,
  3.250988673226620e-06, -2.409322995432666e-08,  1.649025396289777e-10, -1.064189454756595e-12,  6.554431840735274e-15, -3.883998913611049e-17,  2.227287795734876e-19,
 -1.241456217158821e-21,  6.748804605384586e-24, -3.587845349165143e-26,  3.953308378621998e-02, -4.524251019685454e-04,  4.727725094548371e-06, -4.263038975031815e-08,
  3.489305258683295e-10, -2.657554209914471e-12,  1.911670718742170e-14, -1.311912484102435e-16,  8.651689962375771e-19, -5.512604542922571e-21,  3.407970949612602e-23,
 -2.050935584550303e-25,  3.022738844274793e-02, -4.765271083661812e-04,  6.128724417995882e-06, -6.627682394897315e-08,  6.398285809199843e-10, -5.676158393435224e-12,
  4.710209658780383e-14, -3.700096395552084e-16,  2.775119743601759e-18, -1.999923996029133e-20,  1.391694361217425e-22, -9.387444594702534e-25,  2.193504329593772e-02,
 -4.597152005392282e-04,  7.171057671510215e-06, -9.192043008937738e-08,  1.035150929166657e-09, -1.058825748299463e-11,  1.004033185875240e-13, -8.947832529802052e-16,
  7.567689044855137e-18, -6.118321505884422e-20,  4.754992289739794e-22, -3.567901943807595e-24,  1.511879752793448e-02, -4.086249051450753e-04,  7.643124771350825e-06,
 -1.149638343907520e-07,  1.496583682318986e-09, -1.750521775602224e-11,  1.882355560493717e-13, -1.889459814714764e-15,  1.789727460998108e-17, -1.612690501434688e-19,
  1.390991576733834e-21, -1.154014389409195e-23,  9.907077949837221e-03, -3.366091097364789e-04,  7.473660130194637e-06, -1.307528055233321e-07,  1.952495291702050e-09,
 -2.593465941302433e-11,  3.142198859929068e-13, -3.531170951465141e-15,  3.724716163708965e-17, -3.720381207157464e-19,  3.542806746416482e-21, -3.233476690815593e-23,
  6.178768074771039e-03, -2.583177413631210e-04,  6.744416827205770e-06, -1.361682164787794e-07,  2.316781708919524e-09, -3.473571169502849e-11,  4.715611223308087e-13,
 -5.902306205270118e-15,  6.899164914319226e-17, -7.603229388575479e-19,  7.958055212109476e-21, -7.956073421307463e-23,  3.672306200400061e-03, -1.855263786996535e-04,
  5.646068729673547e-06, -1.306181589547052e-07,  2.516881555472317e-09, -4.236660455049198e-11,  6.413051659209279e-13, -8.899536365217962e-15,  1.147834381766527e-16,
 -1.390012477998089e-18,  1.592886088171312e-20, -1.737878341278816e-22,  2.082997047987750e-03, -1.252180583072357e-04,  4.405145575403779e-06, -1.160147993870117e-07,
  2.517888767865560e-09, -4.735417312291155e-11,  7.957224751826351e-13, -1.219292908216068e-14,  1.728588557424682e-16, -2.291878834482146e-18,  2.865562488970670e-20,
 -3.400496647245397e-22,  1.129453517922633e-03, -7.972216239039308e-05,  3.217062129298758e-06, -9.587093297812751e-08,  2.331698636531019e-09, -4.877733002318445e-11,
  9.062133517395265e-13, -1.527576722716832e-14,  2.372167496673730e-16, -3.432230146803215e-18,  4.667515020611957e-20, -6.006356874742914e-22,  5.865248183935903e-04,
 -4.804987291268929e-05,  2.208099628579210e-06, -7.404129130649467e-08,  2.008485818496744e-09, -4.654116514315862e-11,  9.524313163034671e-13, -1.760100280917462e-14,
  2.984309283591673e-16, -4.697764187028234e-18,  6.928548351664079e-20, -9.641944289114246e-22,  2.923135467407186e-04, -2.751132077231247e-05,  1.430062034478978e-06,
 -5.367116280599469e-08,  1.616643670648812e-09, -4.133458482653931e-11,  9.284747375395113e-13, -1.875020882896839e-14,  3.460782741812884e-16, -5.910343823862802e-18,
  9.428509683741952e-20, -1.415308363561217e-21,  1.401415583447845e-04, -1.501526909325996e-05,  8.773233561146355e-07, -3.666986305989663e-08,  1.221327322398093e-09,
 -3.432875607970113e-11,  8.435891368673537e-13, -1.855989876565109e-14,  3.718563027936394e-16, -6.871451722889515e-18,  1.182667849715785e-19, -1.910339346844345e-21,
  6.479823918422425e-05, -7.839262988411204e-06,  5.118314341732154e-07, -2.371294908647800e-08,  8.697892474830876e-10, -2.678143872764833e-11,  7.176997692353123e-13,
 -1.715263120142153e-14,  3.720370714951884e-16, -7.419782780659096e-18,  1.374501375470764e-19, -2.383615218566195e-21,  2.897874546259654e-05, -3.929180023534891e-06,
  2.850863799381545e-07, -1.457429499137480e-08,  5.864744636171326e-10, -1.971456692745010e-11,  5.743821872687055e-13, -1.487001031804342e-14,  3.482478219237882e-16,
 -7.477572544432861e-18,  1.487467216218071e-19, -2.763256700040832e-21,  1.257430262626287e-05, -1.897771983156538e-06,  1.522209652893484e-07, -8.549987680898901e-09,
  3.760506373009339e-10, -1.375536898967542e-11,  4.344069655102909e-13, -1.214900667269818e-14,  3.064322480992486e-16, -7.067024911612616e-18,  1.506172989440475e-19,
 -2.990856953806100e-21,  5.312224563843674e-06, -8.867803730404237e-07,  7.824402986125113e-08, -4.808619482204721e-09,  2.303319435769885e-10, -9.138431555164885e-12,
  3.119173007786558e-13, -9.398316639888701e-15,  2.546676250045150e-16, -6.293395201770299e-18,  1.433865950586931e-19, -3.037068432535958e-21,  2.193285797445085e-06,
 -4.025595573912898e-07,  3.888800966119516e-08, -2.604470468339878e-09,  1.353868464300273e-10, -5.807825937616054e-12,  2.136356793071092e-13, -6.916651230868502e-15,
  2.008499929326301e-16, -5.306135413198962e-18,  1.289515981796505e-19, -2.907241433688489e-21,  8.886285093495072e-07, -1.783227097504720e-07,  1.877446803918636e-08,
 -1.364922520002195e-09,  7.673351876529745e-11, -3.548008890339846e-12,  1.402471155658578e-13, -4.866035706260558e-15,  1.510517606817543e-16, -4.256099381441011e-18,
  1.100833054280618e-19, -2.636109475231317e-21,  3.548747344560185e-07, -7.744292835979919e-08,  8.847199484272660e-09, -6.955346934549914e-10,  4.214337223951037e-11,
 -2.093822399427396e-12,  8.868569362919711e-14, -3.288791441961186e-15,  1.088617222815936e-16, -3.263732700843331e-18,  8.964182130927341e-20, -2.275136891585543e-21,
  1.403543531404294e-07, -3.313682663033904e-08,  4.090091253944308e-09, -3.463992292353849e-10,  2.254451172430634e-11, -1.199796747179957e-12,  5.429648218932696e-14,
 -2.146269157844713e-15,  7.556291174569234e-17, -2.404679444776478e-18,  6.997541856082467e-20, -1.878212639686784e-21,  5.525558864499075e-08, -1.404325212109699e-08,
  1.864901445947314e-09, -1.695119504314922e-10,  1.180959525854219e-11, -6.711067940889092e-13,  3.235444088635449e-14, -1.359510751425819e-15,  5.077684535150638e-17,
 -1.711012353096033e-18,  5.262749531956294e-20, -1.490509240973621e-21,  2.176990785376108e-08, -5.927027231058635e-09,  8.432948501352408e-10, -8.195861980641645e-11,
  6.091237627773074e-12, -3.684386527683125e-13,  1.886634920988251e-14, -8.403301257147352e-16,  3.320723141861970e-17, -1.181831409609532e-18,  3.832933241812715e-20,
 -1.142778248847846e-21,  8.631917877704919e-09, -2.505535005824553e-09,  3.803592180583378e-10, -3.937683326620315e-11,  3.111090212073835e-12, -1.996457927064453e-13,
  1.082510125536397e-14, -5.096212761773736e-16,  2.124868269436266e-17, -7.966112952249930e-19,  2.717329242763040e-20, -8.507983973210539e-22,  3.464592884918019e-09,
 -1.067121496354207e-09,  1.721285102556825e-10, -1.890921822957990e-11,  1.582566318797939e-12, -1.073856438768369e-13,  6.146036031524132e-15, -3.049021905041835e-16,
  1.337528195551943e-17, -5.267664981592940e-19,  1.884908980014481e-20, -6.181957531314929e-22,  1.415993219242312e-09, -4.606499855906331e-10,  7.862103556989126e-11,
 -9.129534684145739e-12,  8.064405262116723e-13, -5.766323852889601e-14,  3.472205499853829e-15, -1.809533886912450e-16,  8.326666365174968e-18, -3.435129912582955e-19,
  1.285862911571852e-20, -4.405811182681445e-22,  5.927851101045267e-10, -2.027467029113393e-10,  3.645982197799484e-11, -4.457529560225452e-12,  4.140268106098407e-13,
 -3.108519232893041e-14,  1.962656793820319e-15, -1.071004772841711e-16,  5.153524045173822e-18, -2.220397044753822e-19,  8.669727402529434e-21, -3.094698156234991e-22,
  2.556487083727188e-10, -9.150821968260685e-11,  1.726445563569443e-11, -2.213310336691004e-12,  2.153340807384222e-13, -1.691364767441080e-14,  1.115785600825366e-15,
 -6.353930668175862e-17,  3.186749387621832e-18, -1.429430656029113e-19,  5.804195869951485e-21, -2.152088728523870e-22,  1.141827724382520e-10, -4.257975273425707e-11,
  8.391447502259012e-12, -1.123389448093016e-12,  1.140272586021886e-13, -9.334141672178225e-15,  6.410268758035855e-16, -3.795918963237257e-17,  1.977575942211257e-18,
 -9.204609326879497e-20,  3.874386857334753e-21, -1.487594219347447e-22,  5.305651296215781e-11, -2.051940847858908e-11,  4.205476320061856e-12, -5.854071660585788e-13,
  6.173889315254111e-14, -5.246208646182707e-15,  3.736340778299135e-16, -2.292258411726568e-17,  1.236064055380028e-18, -5.949357284624850e-20,  2.587215532727185e-21,
 -1.025341318486782e-22,  2.573214360356165e-11, -1.027481830104136e-11,  2.180127292862454e-12, -3.141730028581700e-13,  3.428059054763794e-14, -3.011430593315847e-15,
  2.215377605626928e-16, -1.402720827890358e-17,  7.799951084244795e-19, -3.868201911950752e-20,  1.731866895388577e-21, -7.060385748484873e-23,  1.304114358560454e-11,
 -5.352357266288367e-12,  1.170350415598414e-12, -1.738167110436693e-13,  1.953655149315898e-14, -1.766709060885130e-15,  1.336977781267793e-16, -8.701977326850649e-18,
  4.970465427000713e-19, -2.530269606523272e-20,  1.162053479227010e-21, -4.855973392716828e-23,  6.889555115062759e-12, -2.893486842816546e-12,  6.489746004465799e-13,
 -9.887536618436799e-14,  1.139631602367329e-14, -1.056257333306457e-15,  8.187700924336149e-17, -5.455407237788755e-18,  3.187988212426794e-19, -1.659357038655829e-20,
  7.787554736924766e-22, -3.323409707894102e-23,  3.759270138511456e-12, -1.608475647966786e-12,  3.682965325553770e-13, -5.729210149827585e-14,  6.740367110913320e-15,
 -6.374092643456290e-16,  5.038907843521915e-17, -3.422291986613709e-18,  2.037564198982984e-19, -1.080018126600059e-20,  5.159229962208316e-22, -2.239960538683306e-23,
  2.068760783018375e-12, -8.978229161954683e-13,  2.088650712268874e-13, -3.301513717979228e-14,  3.946051355008554e-15, -3.789846165838325e-16,  3.041651921746225e-17,
 -2.096524989774217e-18,  1.266319701121961e-19, -6.806957096220784e-21,  3.296403834870476e-22, -1.450307739596799e-23,  1.076660547999374e-12, -4.718731584291212e-13,
  1.109905924599027e-13, -1.774050799134436e-14,  2.143825416123514e-15, -2.081272122885758e-16,  1.688074269744325e-17, -1.175564613050913e-18,  7.172046346733549e-20,
 -3.893101920046629e-21,  1.903346190761015e-22, -8.451899903991998e-24,  4.132215305361287e-13, -1.820952972740627e-13,  4.309479834387879e-14, -6.931039427233978e-15,
  8.427208433773728e-16, -8.230647285564158e-17,  6.715045380588503e-18, -4.703217021587488e-19,  2.885499389537936e-20, -1.574859371204940e-21,  7.740545554488679e-23,
 -3.455017082404727e-24,  6.707637432664272e-02, -1.871989302652765e-04,  5.438161475572182e-07, -1.632007593204956e-09,  5.015652921058382e-12, -1.566371966586030e-14,
  4.938821520010776e-17, -1.565221221345946e-19,  4.969263340852471e-22, -1.577501436388477e-24,  4.999607822202868e-27, -1.581210961832712e-29,  6.332555433434872e-02,
 -2.287344882429645e-04,  9.835030188455108e-07, -4.371863811689292e-09,  1.916115110108686e-11, -8.206018285118711e-14,  3.437864809049643e-16, -1.413075332861440e-18,
  5.713719433893518e-21, -2.277627706593600e-23,  8.965482183379531e-26, -3.489490499469316e-28,  5.644813895526942e-02, -2.966747248001567e-04,  1.827489855551649e-06,
 -1.068560711612155e-08,  5.900740687978354e-11, -3.116833693553080e-13,  1.589452753639079e-15, -7.873568946324221e-18,  3.804995991732976e-20, -1.799665141483716e-22,
  8.351658797472940e-25, -3.810330771982129e-27,  4.752100855911508e-02, -3.670648794297319e-04,  2.977024901915962e-06, -2.161686843191639e-08,  1.451077187424997e-10,
 -9.191674463794599e-13,  5.560330193265439e-15, -3.237858298645892e-17,  1.825378362091452e-19, -1.000604164362834e-21,  5.351156240632614e-24, -2.799394076317966e-26,
  3.779591593053682e-02, -4.165585343227060e-04,  4.247981229221128e-06, -3.744897673945265e-08,  3.000853326862624e-10, -2.239879429790138e-12,  1.580289202693872e-14,
 -1.064346884155487e-16,  6.892237776265723e-19, -4.314087497046004e-21,  2.620999422885663e-23, -1.550631743900320e-25,  2.841453736269445e-02, -4.305128126929288e-04,
  5.391269561146939e-06, -5.688968097462482e-08,  5.368199065117284e-10, -4.660625232633729e-12,  3.788406073032341e-14, -2.917268536833717e-16,  2.146135765502388e-18,
 -1.517840075048171e-20,  1.037022836789034e-22, -6.870619939064446e-25,  2.020431076514429e-02, -4.064926426714274e-04,  6.160800708984228e-06, -7.692926133875953e-08,
  8.455864507484015e-10, -8.453771421010992e-12,  7.843308365151428e-14, -6.844743400353713e-16,  5.672719816438441e-18, -4.496810776526153e-20,  3.428372214210543e-22,
 -2.524717956488513e-24,  1.359839216528410e-02, -3.526161982650569e-04,  6.396425966984592e-06, -9.359075959890663e-08,  1.187683588959575e-09, -1.356271011751134e-11,
  1.425470416708041e-13, -1.399819719123323e-15,  1.298170668149525e-17, -1.146013188331395e-19,  9.689531637379841e-22, -7.884010257484366e-24,  8.670983805848057e-03,
 -2.826018008306244e-04,  6.076190054396177e-06, -1.032840266329728e-07,  1.501853091372339e-09, -1.945663221129193e-11,  2.302003410833758e-13, -2.528765163954171e-15,
  2.609521168870895e-17, -2.551765893899620e-19,  2.380425241380872e-21, -2.129455099183561e-23,  5.243883740720417e-03, -2.103173815280218e-04,  5.311732186073605e-06,
 -1.040945125396675e-07,  1.723045191622910e-09, -2.517519910693198e-11,  3.334912459984514e-13, -4.077335305370607e-15,  4.659544596917264e-17, -5.024194314622828e-19,
  5.148537727241334e-21, -5.042433278509831e-23,  3.011498750009143e-03, -1.460022650429801e-04,  4.294803636404164e-06, -9.636825683277032e-08,  1.805242316013032e-09,
 -2.959265268339846e-11,  4.368154560089495e-13, -5.917694172657822e-15,  7.457948413966167e-17, -8.832034460153798e-19,  9.904495626964522e-21, -1.058142002631973e-22,
  1.644669830669123e-03, -9.492650909523227e-05,  3.226500606310361e-06, -8.237335993032208e-08,  1.737058643511602e-09, -3.179759703811478e-11,  5.207800025233037e-13,
 -7.786650373412708e-15,  1.078206479308125e-16, -1.397432029142166e-18,  1.709207723318914e-20, -1.985444341175870e-22,  8.555581538853378e-04, -5.802037624736683e-05,
  2.261725653223084e-06, -6.531776339996717e-08,  1.542989531731832e-09, -3.140555265583665e-11,  5.684872896407589e-13, -9.347538728510216e-15,  1.417331139426643e-16,
 -2.004036786132807e-18,  2.665299455190686e-20, -3.356584140276072e-22,  4.247150090692566e-04, -3.345618275958478e-05,  1.485309554522826e-06, -4.826010957747434e-08,
  1.271304477332929e-09, -2.865663977226730e-11,  5.712569153181242e-13, -1.029556803367406e-14,  1.704140072486626e-16, -2.621076474258499e-18,  3.780009666825983e-20,
 -5.147314218311720e-22,  2.016171320495985e-04, -1.826307855953665e-05,  9.174083716829881e-07, -3.336593840033459e-08,  9.759795657340291e-10, -2.427315040597416e-11,
  5.310845490534448e-13, -1.045885463148026e-14,  1.884393895623877e-16, -3.144207776698190e-18,  4.904359495244347e-20, -7.203438454161196e-22,  9.173898021599954e-05,
 -9.470455696023682e-06,  5.350084217367013e-07, -2.167632164096595e-08,  7.012060225969796e-10, -1.917369878028090e-11,  4.589809597293082e-13, -9.848090040704245e-15,
  1.926178787643114e-16, -3.477736842038817e-18,  5.853004956371687e-20, -9.251375204754841e-22,  4.011541126566195e-05, -4.681600175998204e-06,  2.957375008399017e-07,
 -1.328738556500499e-08,  4.735349382103527e-10, -1.418804914369503e-11,  3.704639077483717e-13, -8.636428927842630e-15,  1.829009954704100e-16, -3.564723396024676e-18,
  6.458391598714314e-20, -1.096155568550894e-21,  1.690682995055797e-05, -2.214254818164891e-06,  1.555724858182918e-07, -7.717771297696620e-09,  3.018947444982728e-10,
 -9.879347780152842e-12,  2.805549976654153e-13, -7.087218003690808e-15,  1.621125971294493e-16, -3.402709165084896e-18,  6.621907323927410e-20, -1.204311404947981e-21,
  6.889810042535682e-06, -1.005848342725838e-06,  7.820450281202997e-08, -4.265940838838276e-09,  1.825091704966465e-10, -6.502716662823036e-12,  2.002716984715131e-13,
 -5.467860173983539e-15,  1.347623351497291e-16, -3.039421325814138e-18,  6.339840506641969e-20, -1.232975383884132e-21,  2.724544101580348e-06, -4.406245994280527e-07,
  3.772889665065682e-08, -2.253959724673497e-09,  1.051046781016839e-10, -4.064783819995940e-12,  1.353913908927085e-13, -3.984927557316787e-15,  1.055725443908541e-16,
 -2.552819667102764e-18,  5.695363199216036e-20, -1.182074253854244e-21,  1.049602024742966e-06, -1.869435590382622e-07,  1.754796141064426e-08, -1.143686598126068e-09,
  5.793254094911997e-11, -2.424561456732099e-12,  8.710129119522127e-14, -2.756689761764255e-15,  7.832047319140623e-17, -2.025956564730846e-18,  4.824311712698615e-20,
 -1.066442577543589e-21,  3.956078640922339e-07, -7.717210174767751e-08,  7.906184725424345e-09, -5.600371548698546e-10,  3.071346816259379e-11, -1.386873414670454e-12,
  5.358959079235480e-14, -1.819203645876221e-15,  5.529701565996571e-17, -1.526786054712740e-18,  3.872340494956401e-20, -9.098743804396586e-22,  1.465708703241651e-07,
 -3.115012369752590e-08,  3.468125092714401e-09, -2.660143274757029e-10,  1.574284276795646e-11, -7.647036156009230e-13,  3.169564291368597e-14, -1.151155062700010e-15,
  3.734676002396425e-17, -1.098184192670976e-18,  2.960288756986405e-20, -7.378388318480492e-22,  5.365081190721510e-08, -1.235937489747948e-08,  1.489155771593816e-09,
 -1.232308233547835e-10,  7.843967270426874e-12, -4.086443727112073e-13,  1.811808881751544e-14, -7.021971834387196e-16,  2.425624320673677e-17, -7.578706697939659e-19,
  2.166554337066889e-20, -5.716215662176452e-22,  1.950846190146535e-08, -4.847375630165250e-09,  6.294581085829022e-10, -5.599245821615043e-11,  3.820751720629301e-12,
 -2.128333851152701e-13,  1.006567172835671e-14, -4.151981797349900e-16,  1.523295418116140e-17, -5.045212859809500e-19,  1.526131377638018e-20, -4.253090938482432e-22,
  7.087971335241555e-09, -1.890477130445867e-09,  2.634934430439747e-10, -2.510297181358071e-11,  1.830181724763403e-12, -1.086731251536528e-13,  5.466460779455328e-15,
 -2.393339563812716e-16,  9.302077790737130e-18, -3.257888863685034e-19,  1.040329887670983e-20, -3.055496295816302e-22,  2.589135526497861e-09, -7.377440938545075e-10,
  1.099170709840808e-10, -1.117392929240487e-11,  8.674496927637659e-13, -5.473061923618928e-14,  2.919449408479354e-15, -1.352886383605168e-16,  5.555488122405739e-18,
 -2.052254254053198e-19,  6.901236938579072e-21, -2.131150283741933e-22,  9.570331816762139e-10, -2.899595140737512e-10,  4.599071399662577e-11, -4.970070198682308e-12,
  4.094047402261837e-13, -2.735738928604128e-14,  1.542727789802933e-15, -7.544633739849670e-17,  3.264151079542662e-18, -1.268441132170707e-19,  4.480351963237981e-21,
 -1.451112551581828e-22,  3.603556287018244e-10, -1.155507756971984e-10,  1.942990645623306e-11, -2.223538110079399e-12,  1.936528223084139e-13, -1.365862785022786e-14,
  8.116475387715365e-16, -4.176116823095291e-17,  1.898025381227100e-18, -7.736974021450785e-20,  2.862749828774436e-21, -9.699279430785360e-23,  1.391536157081916e-10,
 -4.700529078760277e-11,  8.343951576690941e-12, -1.007191775159203e-12,  9.239819248035880e-14, -6.854478551761968e-15,  4.277786649332342e-16, -2.308250809354911e-17,
  1.098674590969980e-18, -4.684011947985662e-20,  1.810330691168339e-21, -6.398526819070926e-23,  5.547554880619142e-11, -1.964932762119335e-11,  3.666276317239962e-12,
 -4.649057235020363e-13,  4.475180622561644e-14, -3.478959169689651e-15,  2.272204360666180e-16, -1.281447711226976e-17,  6.366936849001327e-19, -2.830069203612573e-20,
  1.139066543932299e-21, -4.187591847956872e-23,  2.297674465057735e-11, -8.494011443232677e-12,  1.658538730380137e-12, -2.200083894833489e-13,  2.213273775398970e-14,
 -1.796099382082124e-15,  1.223140394507190e-16, -7.184127437859158e-18,  3.713273279229886e-19, -1.715147328184019e-20,  7.165936406770726e-22, -2.731697830935112e-23,
  9.942296351387874e-12, -3.818334827120682e-12,  7.767094392157991e-13, -1.073145130288832e-13,  1.123543802366952e-14, -9.479713232851959e-16,  6.705105392687574e-17,
 -4.086228103532048e-18,  2.189213666314359e-19, -1.047106315202238e-20,  4.525944779829832e-22, -1.783143250624619e-23,  4.514298612653636e-12, -1.792773996371014e-12,
  3.781553480887547e-13, -5.417566919974113e-14,  5.877390828481598e-15, -5.134242981033862e-16,  3.756543913627636e-17, -2.366023374630811e-18,  1.308926712933735e-19,
 -6.459142963615507e-21,  2.877975139293784e-22, -1.167817287882658e-23,  2.155658739803571e-12, -8.811485520992610e-13,  1.918201164244254e-13, -2.836259400827079e-14,
  3.174066890139893e-15, -2.858216294759288e-16,  2.154107822231614e-17, -1.396452316280431e-18,  7.945497725619156e-20, -4.029548925128676e-21,  1.843866749402583e-22,
 -7.677928807246014e-24,  1.081065557577160e-12, -4.527335616576182e-13,  1.012236675992446e-13, -1.537352270604056e-14,  1.766466307253104e-15, -1.632296578887977e-16,
  1.261581351951877e-17, -8.381860950975459e-19,  4.884562058117128e-20, -2.535591556088834e-21,  1.186875087415826e-22, -5.052287621163023e-24,  5.647258935610664e-13,
 -2.411793505099065e-13,  5.510939381381969e-14, -8.555025726772061e-15,  1.004438860993148e-15, -9.479650652253630e-17,  7.479403153507878e-18, -5.070224690355034e-19,
  3.013172384550883e-20, -1.594295185611878e-21,  7.602728833403785e-23, -3.295301995467366e-24,  3.003127558133434e-13, -1.301910718906495e-13,  3.025017992564368e-14,
 -4.775767466940504e-15,  5.701228340207285e-16, -5.469079595423287e-17,  4.384314734239594e-18, -3.018594395324694e-19,  1.821266640715556e-20, -9.779606384034029e-22,
  4.731070473791066e-23, -2.079424638106516e-24,  1.525590053732489e-13, -6.682617652467625e-14,  1.570870060597061e-14, -2.509284894654327e-15,  3.030443446179906e-16,
 -2.940244342076678e-17,  2.383359410250196e-18, -1.658799184295425e-19,  1.011452846656824e-20, -5.487309243243530e-22,  2.681317937446830e-23, -1.190030307198606e-24,
  5.776003025063226e-14, -2.544704250894348e-14,  6.020649086649652e-15, -9.680426247633711e-16,  1.176678977083145e-16, -1.148914757861885e-17,  9.370960370389980e-19,
 -6.561655502186271e-20,  4.024617697085696e-21, -2.196001621721046e-22,  1.079075070221156e-23, -4.815282552658491e-25,  6.633615752650428e-02, -1.829253965894038e-04,
  5.247034256849514e-07, -1.554200397803231e-09,  4.713885776021010e-12, -1.452924817548135e-14,  4.521994883886217e-17, -1.414918431567045e-19,  4.435745338924682e-22,
 -1.390755471587283e-24,  4.353770364248441e-27, -1.360334031869799e-29,  6.242602736505133e-02, -2.210712236062917e-04,  9.328273801615600e-07, -4.077979815987934e-09,
  1.759935499539095e-11, -7.426417341965433e-14,  3.066616187604535e-16, -1.242692244605119e-18,  4.954790811318368e-21, -1.947908192922841e-23,  7.563112639423038e-26,
 -2.903944462448341e-28,  5.528988983836813e-02, -2.825521257378661e-04,  1.704728085032093e-06, -9.789357854214520e-09,  5.313803738758354e-11, -2.760501975333646e-13,
  1.385109363300664e-15, -6.753497477117725e-18,  3.213418234747971e-20, -1.496845531123116e-22,  6.842759513062698e-25, -3.075982061855881e-27,  4.609879249470805e-02,
 -3.442481721105881e-04,  2.730968843505689e-06, -1.943525783402877e-08,  1.279886896539917e-10, -7.959705334359947e-13,  4.730372697489021e-15, -2.707470248332089e-17,
  1.500895922042912e-19, -8.092915577907562e-22,  4.258611415031439e-24, -2.192699867620915e-26,  3.619491427745501e-02, -3.842938877511682e-04,  3.825987466764414e-06,
 -3.298635534343370e-08,  2.588513408791899e-10, -1.894016429912484e-12,  1.310951402694645e-14, -8.667472573944862e-17,  5.512521616228655e-19, -3.390374222650457e-21,
  2.024682429591519e-23, -1.177805417847299e-25,  2.677461999623461e-02, -3.899741223153145e-04,  4.757204844233261e-06, -4.899950550925199e-08,  4.520760041108798e-10,
 -3.842145240672042e-12,  3.060041495857544e-14, -2.310482759786884e-16,  1.667626924707137e-18, -1.157720227409238e-20,  7.767706330830803e-23, -5.055870407264408e-25,
  1.867137494508148e-02, -3.606810581926548e-04,  5.313560728235769e-06, -6.465637023256008e-08,  6.938825669412256e-10, -6.782254542292159e-12,  6.158349542751442e-14,
 -5.264051858957767e-16,  4.276095895919119e-18, -3.324333757084456e-20,  2.486848070215726e-22, -1.797743078652401e-24,  1.228358762527824e-02, -3.056335676075481e-04,
  5.378970725806011e-06, -7.658450251933011e-08,  9.476932335053397e-10, -1.056853923470777e-11,  1.085973157812649e-13, -1.043564670614721e-15,  9.477471292524083e-18,
 -8.198646003848340e-20,  6.796554674611956e-22, -5.424762728632957e-24,  7.630486096622446e-03, -2.385691464402025e-04,  4.969028704165100e-06, -8.208973587059330e-08,
  1.162687191737100e-09, -1.469500268912634e-11,  1.698256743106091e-13, -1.824011727421733e-15,  1.841860923623641e-17, -1.763668038320931e-19,  1.612034132228817e-21,
 -1.413727968469349e-23,  4.480305282763428e-03, -1.723870144168744e-04,  4.212704206708110e-06, -8.015493454896799e-08,  1.291136417693181e-09, -1.838829668037011e-11,
  2.377416010413338e-13, -2.839897288818576e-15,  3.173615702690600e-17, -3.348780283374644e-19,  3.360443817836245e-21, -3.224759890792139e-23,  2.489520812551774e-03,
 -1.158200277195009e-04,  3.293858753005018e-06, -7.170143254352260e-08,  1.306081989077666e-09, -2.085460243705775e-11,  3.002482987306655e-13, -3.971680144414337e-15,
  4.891919917930387e-17, -5.666330649655037e-19,  6.219488864517943e-21, -6.507515858383202e-23,  1.310935877437854e-03, -7.264020734478150e-05,  2.385804405153778e-06,
 -5.905660669714145e-08,  1.210267388051524e-09, -2.156746983791812e-11,  3.443447520925478e-13, -5.024750108650791e-15,  6.796806061686433e-17, -8.612527250213619e-19,
  1.030637066574283e-20, -1.172089947445983e-22,  6.552352501289775e-04, -4.268545784090699e-05,  1.607490433966858e-06, -4.499406664503586e-08,  1.032505694139726e-09,
 -2.045008686595654e-11,  3.607217774613947e-13, -5.786450763688456e-15,  8.567919566438176e-17, -1.184044406341895e-18,  1.540251916969449e-20, -1.898537709609780e-22,
  3.114237681079754e-04, -2.358356034030057e-05,  1.011489710862273e-06, -3.184733083963079e-08,  8.147724521439062e-10, -1.786732343236713e-11,  3.469903327035163e-13,
 -6.099485121643586e-15,  9.856838955652683e-17, -1.481421426288975e-18,  2.089256976862430e-20, -2.784074827649361e-22,  1.410387924497575e-04, -1.229275484357014e-05,
  5.966889501836475e-07, -2.102996208373431e-08,  5.973786706862387e-10, -1.445234427352310e-11,  3.080189574681229e-13, -5.915678271968264e-15,  1.040480686761654e-16,
 -1.696277678668568e-18,  2.587201168702245e-20, -3.718411876571667e-22,  6.100511653089323e-05, -6.065798526422196e-06,  3.312634912059474e-07, -1.300886599924686e-08,
  4.087138058443679e-10, -1.087191218054199e-11,  2.535176390733900e-13, -5.304922334606347e-15,  1.012910719346228e-16, -1.786904542628750e-18,  2.940728166582287e-20,
 -4.548466721279900e-22,  2.526788162994341e-05, -2.843485090946283e-06,  1.737499552300093e-07, -7.569509889552282e-09,  2.620708629213104e-10, -7.640225828458910e-12,
  1.943645467871408e-13, -4.419607913505937e-15,  9.138461754551645e-17, -1.740486650926663e-18,  3.083883798937222e-20, -5.122563724383134e-22,  1.005118051881841e-05,
 -1.270949005116183e-06,  8.644401954084531e-08, -4.160519742854965e-09,  1.581755665967901e-10, -5.038323013964697e-12,  1.394440418604478e-13, -3.436842233048763e-15,
  7.677558382757505e-17, -1.575175186795718e-18,  2.998628506124137e-20, -5.338578826706997e-22,  3.852389146466155e-06, -5.437492643929528e-07,  4.096460799242815e-08,
 -2.169503123627322e-09,  9.026452552213757e-11, -3.132016106210710e-12,  9.405280720287620e-14, -2.506419217872179e-15,  6.035290002269935e-17, -1.331008507510835e-18,
  2.716819347287653e-20, -5.174134779641686e-22,  1.427865998771239e-06, -2.235902608633701e-07,  1.857134670952561e-08, -1.078119287522633e-09,  4.892777969731332e-11,
 -1.843975243274574e-12,  5.992281102604684e-14, -1.722450222239957e-15,  4.460639891729864e-17, -1.055218721200643e-18,  2.304857117308636e-20, -4.686734474791494e-22,
  5.138544771428451e-07, -8.875882578086380e-08,  8.091859934349470e-09, -5.130124621440187e-10,  2.531318630157904e-11, -1.033218217961715e-12,  3.623999427505013e-14,
 -1.120922850562715e-15,  3.115052397044998e-17, -7.887974032506946e-19,  1.840049937369980e-20, -3.987361549363134e-22,  1.803524094449416e-07, -3.417772908851857e-08,
  3.405363151357292e-09, -2.349210112137382e-10,  1.256289939345675e-11, -5.537885408270556e-13,  2.091089876081095e-14, -6.943113120213279e-16,  2.065922973014878e-17,
 -5.588018247040874e-19,  1.389381205678202e-20, -3.202452597184859e-22,  6.203808179238106e-08, -1.283153205711016e-08,  1.391469175199841e-09, -1.040781741040065e-10,
  6.013197667733925e-12, -2.854510564837014e-13,  1.157339898756954e-14, -4.115170253365477e-16,  1.308089372609154e-17, -3.771382285275760e-19,  9.974402178689035e-21,
 -2.440703948417773e-22,  2.102680820271573e-08, -4.723037140796486e-09,  5.551633500969403e-10, -4.486388729132724e-11,  2.791567500972442e-12, -1.422982646116855e-13,
  6.178480353541304e-15, -2.346854987017365e-16,  7.951040434408789e-18, -2.438148467616534e-19,  6.844938812128362e-21, -1.774611640635903e-22,  7.063049610731619e-09,
 -1.714571123237463e-09,  2.175762044024222e-10, -1.892959039416447e-11,  1.264484675810084e-12, -6.901179924451349e-14,  3.200258678625832e-15, -1.295302272986853e-16,
  4.666215335344119e-18, -1.518434391097109e-19,  4.515407131535618e-21, -1.237777874292513e-22,  2.366133201737812e-09, -6.177963873406868e-10,  8.429810177237521e-11,
 -7.867813752847987e-12,  5.623936979984479e-13, -3.276507506422850e-14,  1.618244903983758e-15, -6.961091312988845e-17,  2.659835889786300e-18, -9.163520522064445e-20,
  2.879929808250512e-21, -8.329237765787307e-23,  7.958421256930080e-10, -2.224482215635524e-10,  3.250664869589295e-11, -3.242984057889743e-12,  2.472318831755092e-13,
 -1.532844901260437e-14,  8.039875855138662e-16, -3.665619137127703e-17,  1.481792401880017e-18, -5.391409412846783e-20,  1.786559698176077e-21, -5.439188625248806e-23,
  2.706677465646853e-10, -8.061210649296664e-11,  1.256464239651334e-11, -1.334917985492599e-12,  1.081689336124732e-13, -7.114277100847416e-15,  3.950863483619603e-16,
 -1.903775412326992e-17,  8.119671272933818e-19, -3.111952585194925e-20,  1.084580593708867e-21, -3.467598903513710e-23,  9.377416058595797e-11, -2.961952108703137e-11,
  4.903884172380734e-12, -5.527473827205486e-13,  4.743768736801188e-14, -3.298658942300006e-15,  1.933467527155701e-16, -9.817047321228115e-18,  4.404932031496106e-19,
 -1.773445084263807e-20,  6.483516941617407e-22, -2.171293842337810e-23,  3.334755610622742e-11, -1.111874144795593e-11,  1.947132771480197e-12, -2.319311060479372e-13,
  2.100396256918288e-14, -1.538801610077864e-15,  9.488022617291468e-17, -5.060110434897670e-18,  2.381393778627283e-19, -1.004205033869394e-20,  3.840203892959400e-22,
 -1.343443017837456e-23,  1.226537164546652e-11, -4.296614261485474e-12,  7.924295683626890e-13, -9.934176016871245e-14,  9.456787514618553e-15, -7.272719454756248e-16,
  4.700655064114196e-17, -2.624343614551490e-18,  1.291216769268099e-19, -5.685237880195318e-21,  2.267315546797104e-22, -8.261690002555009e-24,  4.700326284719026e-12,
 -1.721764702051838e-12,  3.329380796585788e-13, -4.374232612486298e-14,  4.359411130203519e-15, -3.505685167121640e-16,  2.366414234992754e-17, -1.378098898740674e-18,
  7.064337225955593e-20, -3.236950078227299e-21,  1.341945868605565e-22, -5.077292731171799e-24,  1.889430756425911e-12, -7.202957943738995e-13,  1.453639015916199e-13,
 -1.992714523706922e-14,  2.070356777433757e-15, -1.733856100466364e-16,  1.217540315449301e-17, -7.368118155075973e-19,  3.920777693566974e-20, -1.863012066098029e-21,
  8.001332949069555e-23, -3.132980640926162e-24,  8.011257484517646e-13, -3.163274750185555e-13,  6.630961257579059e-14, -9.441010355330888e-15,  1.018040877364652e-15,
 -8.840868860964575e-17,  6.431609988889130e-18, -4.028447151432820e-19,  2.216636804174197e-20, -1.088142238603416e-21,  4.823896287301877e-23, -1.947857954222050e-24,
  3.595367982573924e-13, -1.463348439285051e-13,  3.170707751385099e-14, -4.666327718655285e-15,  5.198206254744922e-16, -4.660070985218881e-17,  3.496873723893775e-18,
 -2.257402902478653e-19,  1.279172260019812e-20, -6.461634526129714e-22,  2.945404506999775e-23, -1.221920045542056e-24,  1.707538485147743e-13, -7.129293656240699e-14,
  1.588687300591409e-14, -2.404810970842538e-15,  2.754171785654255e-16, -2.536870671091539e-17,  1.954637703484577e-18, -1.294737930549451e-19,  7.523079777304010e-21,
 -3.894173347622395e-22,  1.817787908121079e-23, -7.717323418468481e-25,  8.521140833553177e-14, -3.631971790374537e-14,  8.280886456858237e-15, -1.282678898060345e-15,
  1.502732844744099e-16, -1.415254423557803e-17,  1.114339004976020e-18, -7.538944758709641e-20,  4.471619941012989e-21, -2.361518141526202e-22,  1.124079851939706e-23,
 -4.863544625159544e-25,  4.371117012143822e-14, -1.892773721853067e-14,  4.392240432438224e-15, -6.925296541634339e-16,  8.256750200054158e-17, -7.910659747194616e-18,
  6.333904204188818e-19, -4.355718104072018e-20,  2.624990076420508e-21, -1.407953464028746e-22,  6.803814681909626e-24, -2.987285064879947e-25,  2.164646185438150e-14,
 -9.476435011049369e-15,  2.226163145319673e-15, -3.553711135833050e-16,  4.289010254335749e-17, -4.158707842693386e-18,  3.368950934492979e-19, -2.343340701201762e-20,
  1.428006181547706e-21, -7.742709806120734e-23,  3.781264994126071e-24, -1.677292406459075e-25,  8.078600266452563e-15, -3.558244803733347e-15,  8.416215939203665e-16,
 -1.352822503579704e-16,  1.643908673636837e-17, -1.604657578850211e-18,  1.308444864851526e-19, -9.159326898454698e-21,  5.616369562130343e-22, -3.063703427434305e-23,
  1.505049699610592e-24, -6.714419572467232e-26,  6.561273485721748e-02, -1.788011103340138e-04,  5.064961520387906e-07, -1.481045257007737e-09,  4.433840794224745e-12,
 -1.348995178589092e-14,  4.144960487551054e-17, -1.280660580190575e-19,  3.965030781239580e-22, -1.228000498268898e-24,  3.797658293211541e-27, -1.172425293222212e-29,
  6.155636439477225e-02, -2.137996709125680e-04,  8.855334098668270e-07, -3.807884033247193e-09,  1.618494180911070e-11, -6.730455031945698e-14,  2.739845838396974e-16,
 -1.094799107551428e-18,  4.305055409609000e-21, -1.669453171804292e-23,  6.394676227858763e-26, -2.422566880548498e-28,  5.418623285978456e-02, -2.693701448610187e-04,
  1.592180529167283e-06, -8.981573369745332e-09,  4.793472281387532e-11, -2.449653473532214e-13,  1.209633638772209e-15, -5.806392988844752e-18,  2.720727293483960e-20,
 -1.248385175540759e-22,  5.622838483977839e-25, -2.490854069365730e-27,  4.476406582966638e-02, -3.232996718556487e-04,  2.509526622754614e-06, -1.750887399943363e-08,
  1.131458577804686e-10, -6.910217546865247e-13,  4.035365185833488e-15, -2.270690853904459e-17,  1.238023038236820e-19, -6.567755430295225e-22,  3.401289860749315e-24,
 -1.723983397121098e-26,  3.471654330129591e-02, -3.552016973057862e-04,  3.453804083813702e-06, -2.913147238434643e-08,  2.239305601710034e-10, -1.606624903366007e-12,
  1.091229230674943e-14, -7.084080468170154e-17,  4.426086878364169e-19, -2.675345586282626e-21,  1.570764559559486e-23, -8.986493010893492e-26,  2.528728103334664e-02,
 -3.541510864629815e-04,  4.210197755592672e-06, -4.234322556094670e-08,  3.820827865677741e-10, -3.179702057544199e-12,  2.481954028022807e-14, -1.837939651576505e-16,
  1.301800150983938e-18, -8.873237836025245e-21,  5.847787090605225e-23, -3.740073961533769e-25,  1.730900728726504e-02, -3.210971531686553e-04,  4.600067799775763e-06,
 -5.456385171878613e-08,  5.718990854038834e-10, -5.466701242568017e-12,  4.859276939292269e-14, -4.069431200923012e-16,  3.240835896783693e-18, -2.471476102932795e-20,
  1.814498082034254e-22, -1.287890186062109e-24,  1.114164030077447e-02, -2.660352764405381e-04,  4.544392991529234e-06, -6.298011750227616e-08,  7.601851897879354e-10,
 -8.281121396554939e-12,  8.321456966866265e-14, -7.826965959014498e-16,  6.962768667061877e-18, -5.903650904320273e-20,  4.799475894330023e-22, -3.758567577318274e-24,
  6.749893886063901e-03, -2.024619524452999e-04,  4.086543768723592e-06, -6.563272589528412e-08,  9.057292814393709e-10, -1.117090285129734e-11,  1.261325310608640e-13,
 -1.324881303333467e-15,  1.309428062444331e-17, -1.228048550813059e-19,  1.100034297642834e-21, -9.459348652638894e-24,  3.852530046564712e-03, -1.422076908888206e-04,
  3.363592837723623e-06, -6.215396954901557e-08,  9.745365658342918e-10, -1.353222203171306e-11,  1.707999531380825e-13, -1.993830209736381e-15,  2.179300924476242e-17,
 -2.250852918185126e-19,  2.212247824205482e-21, -2.080459889909255e-23,  2.073955865534432e-03, -9.258490303062432e-05,  2.546233499682219e-06, -5.378418680148425e-08,
  9.528818127392131e-10, -1.482349697911515e-11,  2.082028367385707e-13, -2.689725660894398e-15,  3.238437490070522e-17, -3.669607002830525e-19,  3.943029629554022e-21,
 -4.041219888304589e-23,  1.054484543151701e-03, -5.608938248651202e-05,  1.780409968855616e-06, -4.273785281737308e-08,  8.513228241072214e-10, -1.477177466847659e-11,
  2.299540619906542e-13, -3.275392878467854e-15,  4.328787837710748e-17, -5.363632486640986e-19,  6.280755926133685e-21, -6.993957065845394e-23,  5.071527580436940e-04,
 -3.173268860212484e-05,  1.154570690956653e-06, -3.132558696032673e-08,  6.984018244482720e-10, -1.346270290517416e-11,  2.314390059293488e-13, -3.622448508077453e-15,
  5.238590609017201e-17, -7.076570465588855e-19,  9.005025628322681e-21, -1.086527077923059e-22,  2.311334116742581e-04, -1.682317932999177e-05,  6.970686553744749e-07,
 -2.126950142636390e-08,  5.285222038627393e-10, -1.127661329570148e-11,  2.133704416258484e-13, -3.658581263519048e-15,  5.772862721628251e-17, -8.478942049965303e-19,
  1.169488595758609e-20, -1.525194627795652e-22,  1.000199263479712e-04, -8.385806869531472e-06,  3.933012520034120e-07, -1.343282832178080e-08,  3.705682530118964e-10,
 -8.721323547223541e-12,  1.810709589252084e-13, -3.391637291241224e-15,  5.823817463892648e-17, -9.277275107276125e-19,  1.383697847953175e-20, -1.946087209337813e-22,
  4.119105209933841e-05, -3.943549903758084e-06,  2.081653785352020e-07, -7.922965901825502e-09,  2.417556414545331e-10, -6.255872057569592e-12,  1.421042107060181e-13,
 -2.899996592361626e-15,  5.405610854326305e-17, -9.317795100784930e-19,  1.499498751275374e-20, -2.269585045643757e-22,  1.618582755243211e-05, -1.755692220794261e-06,
  1.037509704313784e-07, -4.382156165190347e-09,  1.473800970300175e-10, -4.180380394043714e-12,  1.036081532034855e-13, -2.297857178807053e-15,  4.638810577228910e-17,
 -8.633372866120546e-19,  1.495980543375269e-20, -2.431904307387398e-22,  6.086243691427073e-06, -7.426991820241829e-07,  4.888766399526033e-08, -2.282329293787239e-09,
  8.432019998176434e-11, -2.613956978476062e-12,  7.050038861413905e-14, -1.695171912715086e-15,  3.697980710504451e-17, -7.415418508450277e-19,  1.380812107667338e-20,
 -2.406332368345381e-22,  2.197204795914309e-06, -2.996847320202023e-07,  2.186926431773562e-08, -1.124184483250777e-09,  4.547644911952318e-11, -1.536419346562927e-12,
  4.497904264493535e-14, -1.169804101872290e-15,  2.751648929990386e-17, -5.933106139075357e-19,  1.184959815206344e-20, -2.209696589337018e-22,  7.643550096488791e-07,
 -1.158270475251807e-07,  9.328385275376320e-09, -5.260614659922111e-10,  2.322819996231075e-11, -8.528888205653064e-13,  2.703444158192845e-14, -7.587694733678088e-16,
  1.920434646555954e-17, -4.443706055285725e-19,  9.501131574903444e-21, -1.892500148994959e-22,  2.572804230877218e-07, -4.307260447919580e-08,  3.812006847406385e-09,
 -2.349962514884136e-10,  1.129104992989364e-11, -4.493468113404052e-13,  1.538374752686193e-14, -4.649039847415770e-16,  1.263431866352803e-17, -3.131121646602287e-19,
  7.153697860245499e-21, -1.519329491650280e-22,  8.417646359522872e-08, -1.548660768069234e-08,  1.499898902765912e-09, -1.007239860985279e-10,  5.250291373126623e-12,
 -2.258535428877592e-13,  8.330998749381752e-15, -2.704742438308193e-16,  7.875902197499264e-18, -2.086378516962661e-19,  5.084082748069438e-21, -1.149263573665585e-22,
  2.690588379657046e-08, -5.412256234893803e-09,  5.713276315015527e-10, -4.165136454977667e-11,  2.348264294201675e-12, -1.088956603606008e-13,  4.317152892794910e-15,
 -1.502320684546863e-16,  4.677325236647006e-18, -1.321794804095955e-19,  3.428836260440859e-21, -8.234745477539106e-23,  8.448961590532618e-09, -1.849142545322747e-09,
  2.119145733889835e-10, -1.671465898466355e-11,  1.016175283994010e-12, -5.065983483668668e-14,  2.153162132808060e-15, -8.012468059222567e-17,  2.661423647620228e-18,
 -8.006815248129549e-20,  2.206766016852824e-21, -5.620086676072973e-23,  2.622528470664411e-09, -6.215088624253348e-10,  7.702326106650112e-11, -6.550403949881451e-12,
  4.281176300186529e-13, -2.288115020032593e-14,  1.039915754103949e-15, -4.128279040841620e-17,  1.459651285554908e-18, -4.664943751918084e-20,  1.363243746343528e-21,
 -3.674487634907554e-23,  8.100212563348723e-10, -2.068910987529352e-10,  2.761873622162997e-11, -2.523831775786988e-12,  1.767756977480449e-13, -1.009974544200101e-14,
  4.895311841206401e-16, -2.067987564657509e-17,  7.764918793280848e-19, -2.630354031012599e-20,  8.132891628394014e-22, -2.315338937533241e-23,  2.507626264840113e-10,
 -6.870721087140529e-11,  9.841081630542605e-12, -9.629016291814572e-13,  7.204687192266044e-14, -4.387163578653797e-15,  2.261495859853856e-16, -1.013965373805937e-17,
  4.033147200323613e-19, -1.444693872965586e-20,  4.715517823789530e-22, -1.414821464732103e-23,  7.840920592820210e-11, -2.293931590333236e-11,  3.511271167608067e-12,
 -3.665357334824867e-13,  2.919935792633423e-14, -1.889180018188250e-15,  1.032663628386975e-16, -4.900564064835674e-18,  2.059481780769499e-19, -7.781338760169263e-21,
  2.674765228581671e-22, -8.438273759755122e-24,  2.496568278388582e-11, -7.762533693573595e-12,  1.264609437189633e-12, -1.403128809618637e-13,  1.185954736957791e-14,
 -8.126089883236516e-16,  4.695702154457072e-17, -2.351657740556705e-18,  1.041265578394398e-19, -4.138644628485484e-21,  1.494335845737415e-22, -4.944608223811381e-24,
  8.163246144274638e-12, -2.684892920895645e-12,  4.635787420582761e-13, -5.445834339170059e-14,  4.865913090927525e-15, -3.518797831774972e-16,  2.142517154090775e-17,
 -1.128826164327133e-18,  5.250374015499875e-20, -2.188963742863755e-21,  8.279131037706766e-23, -2.865642365117695e-24,  2.764749719454826e-12, -9.573266749359856e-13,
  1.744270178858594e-13, -2.160672265320065e-14,  2.033057521412385e-15, -1.546002159145651e-16,  9.884100610647435e-18, -5.460329864097785e-19,  2.659283840973107e-20,
 -1.159372747577282e-21,  4.579631330778865e-23, -1.653364285047450e-24,  9.781320329385270e-13, -3.548573061454482e-13,  6.792167718545092e-14, -8.834198480391094e-15,
  8.718208572856256e-16, -6.944399024526881e-17,  4.644563209915047e-18, -2.680737703275213e-19,  1.362349263888364e-20, -6.190341749575985e-22,  2.545591956813709e-23,
 -9.556022841034443e-25,  3.643664153564113e-13, -1.378263941761533e-13,  2.758396565937671e-14, -3.750219025964587e-15,  3.865047270597938e-16, -3.211601973099984e-17,
  2.238179610206769e-18, -1.344540084884087e-19,  7.103867032018682e-21, -3.352278417614072e-22,  1.430148961735715e-23, -5.563736995074439e-25,  1.438958390702461e-13,
 -5.647297629731095e-14,  1.176046521044399e-14, -1.663517073593854e-15,  1.782372205022636e-16, -1.538258632716700e-17,  1.112334696585718e-18, -6.926513139660773e-20,
  3.789752026341177e-21, -1.850192124690396e-22,  8.158626051986596e-24, -3.277479285455132e-25,  6.053537829118439e-14, -2.452660521808083e-14,  5.287999871462551e-15,
 -7.743937256826979e-16,  8.584916227797548e-17, -7.659968065539343e-18,  5.721703767285125e-19, -3.677264141356180e-20,  2.074786464180454e-21, -1.043691374324720e-22,
  4.738216135327221e-24, -1.957988995182039e-25,  2.715845148241779e-14, -1.130279933534699e-14,  2.509829815918718e-15, -3.785758187005257e-16,  4.320742872011617e-17,
 -3.966427354502135e-18,  3.046086858904788e-19, -2.011287775113087e-20,  1.165051974008736e-21, -6.012598136773697e-23,  2.798505533574777e-24, -1.184749462640636e-25,
  1.291797698537185e-14, -5.494507033591012e-15,  1.249840417643455e-15, -1.931453300983305e-16,  2.257637954616556e-17, -2.121472379787796e-18,  1.666773919115664e-19,
 -1.125260446802567e-20,  6.660654419498642e-22, -3.510578366612480e-23,  1.667804205269483e-24, -7.202577712730195e-26,  6.380180705528513e-15, -2.759356386277617e-15,
  6.394440974247802e-16, -1.006836130380722e-16,  1.198789045308583e-17, -1.147024711803819e-18,  9.172181102002037e-20, -6.299657537369330e-21,  3.791890722151746e-22,
 -2.031431032265262e-23,  9.805419954524478e-25, -4.300367958391375e-26,  3.075798161007426e-15, -1.345709316892438e-15,  3.159120275139016e-16, -5.039544457296681e-17,
  6.078128676123358e-18, -5.889529987059935e-19,  4.767962903574776e-20, -3.314334657105965e-21,  2.018461912047343e-22, -1.093754182758815e-23,  5.338346008143360e-25,
 -2.366619303441184e-26,  1.130628129644606e-15, -4.978571033955432e-16,  1.177214686911543e-16, -1.891678127545060e-17,  2.298012475393094e-18, -2.242471696801531e-19,
  1.827982138012119e-20, -1.279246326164667e-21,  7.841923964373965e-23, -4.276537080690300e-24,  2.100279773553049e-25, -9.367379356704056e-27,  6.490552347087061e-02,
 -1.748190454448594e-04,  4.891405261156156e-07, -1.412209340208126e-09,  4.173706450105870e-12, -1.253679753370025e-14,  3.803494601654565e-17, -1.160569492286506e-19,
  3.549095451001596e-22, -1.085921542100475e-24,  3.317949809122867e-27, -1.012260820717415e-29,  6.071505092949486e-02, -2.068938797954075e-04,  8.413492643703196e-07,
 -3.559346565815614e-09,  1.490220225746574e-11, -6.108174390659972e-14,  2.451719253843542e-16, -9.661798220303041e-19,  3.747637454183176e-21, -1.433761302126990e-23,
  5.418796463567439e-26, -2.025807721821906e-28,  5.313356249783701e-02, -2.570511402715594e-04,  1.488846667595625e-06, -8.252288456598286e-09,  4.331305041721583e-11,
 -2.177907091450357e-13,  1.058597617450309e-15, -5.003531936941368e-18,  2.309285423104653e-20, -1.043938489772101e-22,  4.633534170072036e-25, -2.023117539174353e-27,
  4.350973099878037e-02, -3.040341263591743e-04,  2.309842536276574e-06, -1.580405002603234e-08,  1.002446352768095e-10, -6.013757860090181e-13,  3.451659665801856e-15,
 -1.909869390849159e-17,  1.024349776342384e-19, -5.347579800335740e-22,  2.726037592456086e-24, -1.360446074884796e-26,  3.334886626767961e-02, -3.289110190533779e-04,
  3.124707694265343e-06, -2.579206048569056e-08,  1.942642543367657e-10, -1.367016766579583e-12,  9.113381250961055e-15, -5.810439224356985e-17,  3.567138495646204e-19,
 -2.119506410812656e-21,  1.223705136626494e-23, -6.886593394330100e-26,  2.393496236878558e-02, -3.224026839587408e-04,  3.736760645834494e-06, -3.670795728080097e-08,
  3.240517222176425e-10, -2.641360334971100e-12,  2.021153517812166e-14, -1.468262189260314e-16,  1.020782846891540e-18, -6.832816984412211e-21,  4.424063002581553e-23,
 -2.780890927878283e-25,  1.609428205674420e-02, -2.867680352222624e-04,  3.996791024498722e-06, -4.622844690019154e-08,  4.733616282524044e-10, -4.426263445519918e-12,
  3.852588022434023e-14, -3.161750545640626e-16,  2.469155632787860e-18, -1.847510658278273e-20,  1.331482366404409e-22, -9.280918757684904e-25,  1.014569915474409e-02,
 -2.325083253247083e-04,  3.856475996486941e-06, -5.204064430162562e-08,  6.128813474344421e-10, -6.523619317779247e-12,  6.412353425215966e-14, -5.904887516464355e-16,
  5.146553688904720e-18, -4.277997196119228e-20,  3.411396213237461e-22, -2.621715583751155e-24,  6.000769376619324e-03, -1.726895852839316e-04,  3.379028536340036e-06,
 -5.277573552244066e-08,  7.098066165438645e-10, -8.545333667969833e-12,  9.429360930907166e-14, -9.688599735983828e-16,  9.374308260339600e-18, -8.612721771624291e-20,
  7.562295063492844e-22, -6.377601213076736e-24,  3.333141884554372e-03, -1.180364755337098e-04,  2.703042257569486e-06, -4.852147060386198e-08,  7.407396916575172e-10,
 -1.003106479671794e-11,  1.236299359648355e-13, -1.410667712410443e-15,  1.508425616703986e-17, -1.525245614758159e-19,  1.468545594837549e-21, -1.353687291689626e-23,
  1.740606668057302e-03, -7.455837905033910e-05,  1.983330638550005e-06, -4.066198648962712e-08,  7.008373597413777e-10, -1.062447340879897e-11,  1.456111406154191e-13,
 -1.837523849830730e-15,  2.163057677908879e-17, -2.398251368026328e-19,  2.523133484395895e-21, -2.533484873815440e-23,  8.556650792745196e-04, -4.368660890489963e-05,
  1.340425794132375e-06, -3.120888966544735e-08,  6.043868324998159e-10, -1.021312648417446e-11,  1.550469226789976e-13, -2.156082083865883e-15,  2.784554395895986e-17,
 -3.374325622914775e-19,  3.867104666962851e-21, -4.217138405204612e-23,  3.965578736141681e-04, -2.382844685691898e-05,  8.377158020271583e-07, -2.203475023622516e-08,
  4.773648711907656e-10, -8.957149532344637e-12,  1.500957428944423e-13, -2.292582090749826e-15,  3.238536762578479e-17, -4.276937100617069e-19,  5.324643033966165e-21,
 -6.289680719779725e-23,  1.735597479645969e-04, -1.213929972454948e-05,  4.859446266704316e-07, -1.437057524121193e-08,  3.468711171898988e-10, -7.201533569637302e-12,
  1.327786267450429e-13, -2.221051134300559e-15,  3.422307345997012e-17, -4.912753912925082e-19,  6.627725282859567e-21, -8.460107187888807e-23,  7.187519838970359e-05,
 -5.795246608181350e-06,  2.626107393058786e-07, -8.691891908529105e-09,  2.328766612627045e-10, -5.332039817540574e-12,  1.078493277792245e-13, -1.970347557505228e-15,
  3.303248080255388e-17, -5.142022181441445e-19,  7.500176552818924e-21, -1.032318819392127e-22,  2.822701546148710e-05, -2.601200770188886e-06,  1.327019418610489e-07,
 -4.894962397111454e-09,  1.450583432392509e-10, -3.651596383567895e-12,  8.080302286491021e-14, -1.608233918514327e-15,  2.926605292514335e-17, -4.929279980684720e-19,
  7.757260040923910e-21, -1.148975111975532e-22,  1.053923330980013e-05, -1.101514490207488e-06,  6.293894046191757e-08, -2.577019215419529e-09,  8.418546426222164e-11,
 -2.323179874019230e-12,  5.609369494790506e-14, -1.213375956852883e-15,  2.391473148758698e-17, -4.349199131367309e-19,  7.369995748767012e-21, -1.172501364632749e-22,
  3.751998302675032e-06, -4.416618601466157e-07,  2.812810930726064e-08, -1.273521152060244e-09,  4.571530002321602e-11, -1.379119267945113e-12,  3.624394984908845e-14,
 -8.501339973006060e-16,  1.810908092295547e-17, -3.549000312981739e-19,  6.463758027218272e-21, -1.102554577631228e-22,  1.277740378631252e-06, -1.683249819039765e-07,
  1.189413149300416e-08, -5.933061514374716e-10,  2.333094834433822e-11, -7.673590542730187e-13,  2.189717929417115e-14, -5.557192780647053e-16,  1.276789146957400e-17,
 -2.691328705886650e-19,  5.258775208105626e-21, -9.601128896580795e-23,  4.177808882763689e-07, -6.123157568747028e-08,  4.779745555413923e-09, -2.617601148744711e-10,
  1.124236079629547e-11, -4.020793277354333e-13,  1.242898816540526e-14, -3.405536346120338e-16,  8.422479272809945e-18, -1.905972060377064e-19,  3.988495195841296e-21,
 -7.781094893876237e-23,  1.316985474461136e-07, -2.135692566451510e-08,  1.834033899609129e-09, -1.098947693924913e-10,  5.139993324421495e-12, -1.993820285227440e-13,
  6.660964093461723e-15, -1.966288471034791e-16,  5.224412797323854e-18, -1.266899488205471e-19,  2.834344115376376e-21, -5.898698753468545e-23,  4.021237377607876e-08,
 -7.177779830148348e-09,  6.753942577027111e-10, -4.413162852381292e-11,  2.241378006904195e-12, -9.405830858949348e-14,  3.388214482378353e-15, -1.075274678285970e-16,
  3.063295761946276e-18, -7.945443325558478e-20,  1.897083471579212e-21, -4.204715488932100e-23,  1.195478977074230e-08, -2.337154596839911e-09,  2.400273535919753e-10,
 -1.704703396434637e-11,  9.374482692495064e-13, -4.244967879586625e-14,  1.644972016033587e-15, -5.600318067757533e-17,  1.707232110426862e-18, -4.727478301087221e-20,
  1.202491962949537e-21, -2.833607332632986e-23,  3.480477367333982e-09, -7.416775896219681e-10,  8.281960677831795e-11, -6.372306902981791e-12,  3.783344898548054e-13,
 -1.843827401293164e-14,  7.668025784748079e-16, -2.794403115878518e-17,  9.096771908602629e-19, -2.684055319598178e-20,  7.259902810932746e-22, -1.815650767672158e-23,
  9.986863431240532e-10, -2.308881039374338e-10,  2.792655704095878e-11, -2.320224687433136e-12,  1.482924205283753e-13, -7.757589937701774e-15,  3.453884954058959e-16,
 -1.344242285414231e-17,  4.663028400871790e-19, -1.463066678141217e-20,  4.200081928511058e-22, -1.112770077817187e-23,  2.844252882264115e-10, -7.101181965571029e-11,
  9.268201766327366e-12, -8.287257107637905e-13,  5.684693594151066e-14, -3.183367642361072e-15,  1.513499039720613e-16, -6.276024241557895e-18,  2.314705853008365e-19,
 -7.706596431860263e-21,  2.343324146614770e-22, -6.564218086919564e-24,  8.101950697116909e-11, -2.174435225704846e-11,  3.050657819317140e-12, -2.925706864225251e-13,
  2.147275624912298e-14, -1.283504226871301e-15,  6.499042863127817e-17, -2.864158589501824e-18,  1.120470049155121e-19, -3.949656290155479e-21,  1.269316416726369e-22,
 -3.751663614928740e-24,  2.327531768839661e-11, -6.684156862784987e-12,  1.004096777281479e-12, -1.029214049269816e-13,  8.055995802601571e-15, -5.124520291155781e-16,
  2.755738398278702e-17, -1.287285758811852e-18,  5.328100556878607e-20, -1.983700705411694e-21,  6.722390646138962e-23, -2.091769883982856e-24,  6.803507399466425e-12,
 -2.080943634761248e-12,  3.333671370395569e-13, -3.638765928472109e-14,  3.027255471521559e-15, -2.042801649685281e-16,  1.163162963468808e-17, -5.742889572913215e-19,
  2.508091759019226e-20, -9.837018160282415e-22,  3.506421675385174e-23, -1.145894046895430e-24,  2.042425893620484e-12, -6.622244645007703e-13,  1.126655515808768e-13,
 -1.304536240108997e-14,  1.149406088844687e-15, -8.200187749439539e-17,  4.928030830876718e-18, -2.563818952462519e-19,  1.177997377096839e-20, -4.853555786166649e-22,
  1.814840547637628e-23, -6.212597549089652e-25,  6.357759586658298e-13, -2.174778620764589e-13,  3.912376447165005e-14, -4.786117949621059e-15,  4.449057034218079e-16,
 -3.343651306764813e-17,  2.113531288496792e-18, -1.154819146082541e-19,  5.564673259966433e-21, -2.401193952856812e-22,  9.390878942456226e-24, -3.357837890902709e-25,
  2.071959861225938e-13, -7.440909687584592e-14,  1.409041057608311e-14, -1.813380796364887e-15,  1.771245368745515e-16, -1.396860077943266e-17,  9.252697926826150e-19,
 -5.290765558817487e-20,  2.664551040744810e-21, -1.200181747168514e-22,  4.893708165222822e-24, -1.822072468153969e-25,  7.134845447052180e-14, -2.676726233053886e-14,
  5.310244939654784e-15, -7.157139322963299e-16,  7.314027814513918e-17, -6.027688994366974e-18,  4.167372918119596e-19, -2.484213481702973e-20,  1.302758533299688e-21,
 -6.103311005160158e-23,  2.585600199480933e-24, -9.990847715817301e-26,  2.617487637741565e-14, -1.020655941384285e-14,  2.110803646383013e-15, -2.965211539659828e-16,
  3.155739126249566e-17, -2.705758316984569e-18,  1.944186611403510e-19, -1.203220688045462e-20,  6.544144461470795e-22, -3.176515500711445e-23,  1.392903254801307e-24,
 -5.565369811212288e-26,  1.029419107063944e-14, -4.150735830221051e-15,  8.902234999501440e-16, -1.296873492713374e-16,  1.430370826297737e-17, -1.269920790465193e-18,
  9.440079301708032e-20, -6.038642155808471e-21,  3.391676727124335e-22, -1.698635991801929e-23,  7.678720799701824e-25, -3.160029120727835e-26,  4.351346699421200e-15,
 -1.804777228288442e-15,  3.992601947546445e-16, -5.999841403834402e-17,  6.822642281039674e-18, -6.240830084767771e-19,  4.776150521005196e-20, -3.143021699940456e-21,
  1.814679119499227e-22, -9.335571840251664e-24,  4.331822468121727e-25, -1.828438241823506e-26,  1.968096276002077e-15, -8.352439162701365e-16,  1.895261143614410e-16,
 -2.921636907823237e-17,  3.406773584612815e-18, -3.193738568098744e-19,  2.503455577155686e-20, -1.686343747969180e-21,  9.960202697569323e-23, -5.238608090410970e-24,
  2.483677651207590e-25, -1.070482414896685e-26,  9.340431923190297e-16, -4.034388564743965e-16,  9.335640779919466e-17, -1.467806186018639e-17,  1.745143807687138e-18,
 -1.667454949176720e-19,  1.331565698611665e-20, -9.133383554381517e-22,  5.490493663648068e-23, -2.937745987375560e-24,  1.416283805591849e-25, -6.204088790264307e-27,
  4.377082227095119e-16, -1.913808590916737e-16,  4.489517952154186e-17, -7.156624821406437e-18,  8.625302054891536e-19, -8.351774556596803e-20,  6.756654903570343e-21,
 -4.693569656220511e-22,  2.856556490272628e-23, -1.546908212070010e-24,  7.545380684173817e-26, -3.343028681855381e-27,  1.583396937692112e-16, -6.970357680183146e-17,
  1.647670987917755e-17, -2.646818759588139e-18,  3.214343017097546e-19, -3.135677880910839e-20,  2.555307737886960e-21, -1.787699623417964e-22,  1.095555739365045e-23,
 -5.972799702035493e-25,  2.932507085765347e-26, -1.307551845580152e-27,  6.421396778757804e-02, -1.709725907752034e-04,  4.725865732612846e-07, -1.347387409269159e-09,
  3.931842151847303e-12, -1.166170583874328e-14,  3.493865160599121e-17, -1.053005658735301e-19,  3.181017896443878e-22, -9.616932314187402e-25,  2.903422859670164e-27,
 -8.754921077906606e-30,  5.990067209080395e-02, -2.003299717284403e-04,  8.000284140940842e-07, -3.330373664720450e-09,  1.373728541071049e-11, -5.550916505088546e-14,
  2.197231213372015e-16, -8.541123787556446e-19,  3.268443368783842e-21, -1.233826262077589e-23,  4.601818383546114e-26, -1.697971478120493e-28,  5.212856851628447e-02,
 -2.455250179309726e-04,  1.393837861974868e-06, -7.592791926637670e-09,  3.920036892777013e-11, -1.939853981433062e-13,  9.283038718845645e-16, -4.321281401373020e-18,
  1.964790783932360e-20, -8.752365331177613e-23,  3.828859408775891e-25, -1.648043019279212e-27,  4.232938819067179e-02, -2.862875996545346e-04,  2.129434611506654e-06,
 -1.429203039935965e-08,  8.900404350894936e-11, -5.245997740712618e-13,  2.960036522356024e-15, -1.610886710164893e-17,  8.501032320623438e-20, -4.368039432646188e-22,
  2.192257257594559e-24, -1.077410525050363e-26,  3.208132926996765e-02, -3.051005398373411e-04,  2.832987143256923e-06, -2.289120206811649e-08,  1.689857286756877e-10,
 -1.166596081868918e-12,  7.635436012511074e-15, -4.782153628606365e-17,  2.885380969451842e-19, -1.685633479664969e-21,  9.572013009227140e-24, -5.299853339622849e-26,
  2.270246934865155e-02, -2.941862889883238e-04,  3.325712534001329e-06, -3.192072571001987e-08,  2.757604366291033e-10, -2.202141592668292e-12,  1.652303569366284e-14,
 -1.177779010980677e-16,  8.039115768084171e-19, -5.285635827258510e-21,  3.362955602648967e-23, -2.077996733170711e-25,  1.500781850458919e-02, -2.568903339613536e-04,
  3.484725923319991e-06, -3.931548212939228e-08,  3.934091490228130e-10, -3.599528361855313e-12,  3.068606377963118e-14, -2.468506980016337e-16,  1.890831234623126e-18,
 -1.388436158844996e-20,  9.824588452732206e-23, -6.726532209717544e-25,  9.273637305371205e-03, -2.039971638092080e-04,  3.286775551490900e-06, -4.320000872576088e-08,
  4.965498467164413e-10, -5.165782951475373e-12,  4.968152610535403e-14, -4.480168694049742e-16,  3.826621151923641e-18, -3.119033017129532e-20,  2.440176709599256e-22,
 -1.840716623754153e-24,  5.360320930330386e-03, -1.480097583871035e-04,  2.808595711218368e-06, -4.267177261356299e-08,  5.594967833164393e-10, -6.576595531666365e-12,
  7.093774626744999e-14, -7.131612488399154e-16,  6.756736720053794e-18, -6.082727399287338e-20,  5.236279103929404e-22, -4.331717934637274e-24,  2.900822611138967e-03,
 -9.855394959407815e-05,  2.185762864650150e-06, -3.812590191635925e-08,  5.668519392142890e-10, -7.488081343769844e-12,  9.013807158238219e-14, -1.005559403002117e-15,
  1.052131179008819e-17, -1.041741963798010e-19,  9.827728845226606e-22, -8.881166806063716e-24,  1.471265415678549e-03, -6.046787858222834e-05,  1.556225476134899e-06,
 -3.097480931230485e-08,  5.194998134529927e-10, -7.676329438732267e-12,  1.026802259237295e-13, -1.265996304721617e-15,  1.457340357009019e-17, -1.581291539674074e-19,
  1.629185454418549e-21, -1.602945196866383e-23,  7.002067368001490e-04, -3.431114144898194e-05,  1.017802491782934e-06, -2.298946771390624e-08,  4.329219334304929e-10,
 -7.125994900914248e-12,  1.055187593517004e-13, -1.432820470220447e-15,  1.808615436220930e-17, -2.143823823300015e-19,  2.404936938512658e-21, -2.568755919287041e-23,
  3.131397351781980e-04, -1.806698885457483e-05,  6.137931793212820e-07, -1.565421865475715e-08,  3.295950794635146e-10, -6.020934723037507e-12,  9.836183766837991e-14,
 -1.466363334754972e-15,  2.023681284115621e-17, -2.613147192350676e-19,  3.183290464137774e-21, -3.681741093121694e-23,  1.318055649980135e-04, -8.857099418567164e-06,
  3.425523583954869e-07, -9.818850051422017e-09,  2.302463113191957e-10, -4.652047036766068e-12,  8.358887510153304e-14, -1.364216988039780e-15,  2.052942858415193e-17,
 -2.880629961642769e-19,  3.801535259588290e-21, -4.750037565839671e-23,  5.231518621404373e-05, -4.055505156490280e-06,  1.775540855320848e-07, -5.695165263116859e-09,
  1.482025706792390e-10, -3.301482261231229e-12,  6.506173263612830e-14, -1.159448135959878e-15,  1.897949892949641e-17, -2.887298012751576e-19,  4.118874313168527e-21,
 -5.548469558692373e-23,  1.962258898041902e-05, -1.740022373374557e-06,  8.578158307148467e-08, -3.066514392184435e-09,  8.825608687083094e-11, -2.161341972614988e-12,
  4.659167466358502e-14, -9.044349930559841e-16,  1.606856595048171e-17, -2.644628100746845e-19,  4.070034552797046e-21, -5.899538502556815e-23,  6.972552040347701e-06,
 -7.019090680678817e-07,  3.877197091306056e-08, -1.538777048133382e-09,  4.882462039015255e-11, -1.310807762032398e-12,  3.083295140685345e-14, -6.504952750083858e-16,
  1.251694628017798e-17, -2.224389434977958e-19,  3.686213223545187e-21, -5.739197747320949e-23,  2.353746863517071e-06, -2.671565142501155e-07,  1.645782452928715e-08,
 -7.225238612445251e-10,  2.519749858051636e-11, -7.396584233580965e-13,  1.893971797607780e-14, -4.333393949306318e-16,  9.013053360482934e-18, -1.726231550127828e-19,
  3.074953580144546e-21, -5.133677582472129e-23,  7.572818400154564e-07, -9.630873091553743e-08,  6.587585366841967e-09, -3.187961909325214e-10,  1.218403023724339e-11,
 -3.900622656631817e-13,  1.084815351028926e-14, -2.686193588914937e-16,  6.027530590457317e-18, -1.241948002338349e-19,  2.373985509152398e-21, -4.243131248544782e-23,
  2.330634147219640e-07, -3.302015964919882e-08,  2.497321416219606e-09, -1.327733388639323e-10,  5.545384256355959e-12, -1.931391561931336e-13,  5.821184675414234e-15,
 -1.556841259159154e-16,  3.761797029037484e-18, -8.324134445528071e-20,  1.704645201085960e-21, -3.256709697014788e-23,  6.889878274188943e-08, -1.081623375465685e-08,
  9.008792985589899e-10, -5.244930940486037e-11,  2.387271403023155e-12, -9.023647100478452e-14,  2.941010389782287e-15, -8.478472169491485e-17,  2.202005944537970e-18,
 -5.223892540914935e-20,  1.144203784594600e-21, -2.332983596028234e-23,  1.965655936275271e-08, -3.401929203859195e-09,  3.108383774050080e-10, -1.975439023691375e-11,
  9.771957646313356e-13, -3.999055473860352e-14,  1.406380809773604e-15, -4.361636357050516e-17,  1.215347462130349e-18, -3.085737631916484e-20,  7.217294048747298e-22,
 -1.568087619765826e-23,  5.440738378275815e-09, -1.033051795561586e-09,  1.031619872130869e-10, -7.134153191482111e-12,  3.825035146996941e-13, -1.690663928813305e-14,
  6.401526600743580e-16, -2.131486241191298e-17,  6.360219762035802e-19, -1.725248877159573e-20,  4.301824636259598e-22, -9.943694045266218e-24,  1.469734166185583e-09,
 -3.047291524573935e-10,  3.313583655661588e-11, -2.485750381210046e-12,  1.440578133873239e-13, -6.860248343270221e-15,  2.790468059453940e-16, -9.954823757182934e-18,
  3.174878395135306e-19, -9.184223933172816e-21,  2.437162478536223e-22, -5.983654019255225e-24,  3.900559693934712e-10, -8.790706040200775e-11,  1.037059112942706e-11,
 -8.412674229560209e-13,  5.255210877910383e-14, -2.689563632557181e-15,  1.172542405536464e-16, -4.472124681975177e-18,  1.521394455113159e-19, -4.684598020937033e-21,
  1.320613591295153e-22, -3.437934705143404e-24,  1.024507533991707e-10, -2.498435493546178e-11,  3.186011197938918e-12, -2.785859911781441e-13,  1.870459208156031e-14,
 -1.026113519630824e-15,  4.783061059993018e-17, -1.946010213053812e-18,  7.046780887549864e-20, -2.304986842504349e-21,  6.889799008273375e-23, -1.898342938779755e-24,
  2.684860741307933e-11, -7.052930868136213e-12,  9.685647348020246e-13, -9.098996835525130e-14,  6.546707403060433e-15, -3.839176890178917e-16,  1.908574332692459e-17,
 -8.263571939884902e-19,  3.178004539774175e-20, -1.101923492445384e-21,  3.485282312805311e-23, -1.014378503378220e-24,  7.082537507973558e-12, -1.995066512731016e-12,
  2.939250875235870e-13, -2.956455064092481e-14,  2.272403202209916e-15, -1.420406378590482e-16,  7.510506096629622e-18, -3.451757398134985e-19,  1.406429557883230e-20,
 -5.157427367293732e-22,  1.722302434446506e-23, -5.283745530637324e-25,  1.898738883266200e-12, -5.708902638355332e-13,  8.987440049154763e-14, -9.644660353057993e-15,
  7.893172477370114e-16, -5.242660460639689e-17,  2.939905961231185e-18, -1.430285549947100e-19,  6.158209007703068e-21, -2.382320512859573e-22,  8.379576123844287e-24,
 -2.703443559083052e-25,  5.225965313919932e-13, -1.669290055232068e-13,  2.796604041645242e-14, -3.189766763721872e-15,  2.769788130694468e-16, -1.948420760235797e-17,
  1.155125222487951e-18, -5.931188169969442e-20,  2.690850145950389e-21, -1.095161971500549e-22,  4.046717065927233e-24, -1.369482234331140e-25,  1.492464884136514e-13,
 -5.040320330869787e-14,  8.947433185248366e-15, -1.080347815635470e-15,  9.916049872259793e-17, -7.361430358107142e-18,  4.598315910728339e-19, -2.483850455411496e-20,
  1.183688874626828e-21, -5.053228939709029e-23,  1.955877810326863e-24, -6.923727722149655e-26,  4.470637830685952e-14, -1.588433511926943e-14,  2.974248120774639e-15,
 -3.785523096712392e-16,  3.657900441601390e-17, -2.854756482794046e-18,  1.871953606238701e-19, -1.059984688160659e-20,  5.288080273168997e-22, -2.360188400767945e-23,
  9.538724052547362e-25, -3.521270002057578e-26,  1.419561677536239e-14, -5.279578253163992e-15,  1.037751885794223e-15, -1.385949613674039e-16,  1.403768453488404e-17,
 -1.146930003372338e-18,  7.863470318004146e-20, -4.649681764666188e-21,  2.419321909008546e-22, -1.124862373831963e-23,  4.730464255021122e-25, -1.814930754272483e-26,
  4.824724038116100e-15, -1.868554666302567e-15,  3.836099197159126e-16, -5.349806711639111e-17,  5.653262972689587e-18, -4.813841275554584e-19,  3.435875562625705e-20,
 -2.112675171395930e-21,  1.141871339900551e-22, -5.509066928955226e-24,  2.401560458049139e-25, -9.541077870870572e-27,  1.768960254881917e-15, -7.096241882500181e-16,
  1.513521574571981e-16, -2.192725835197540e-17,  2.405390326894620e-18, -2.124363409128504e-19,  1.571127158527214e-20, -1.000061458428864e-21,  5.590109703873448e-23,
 -2.786695266471786e-24,  1.254076116277805e-25, -5.138507575729054e-27,  7.025949413629317e-16, -2.903564562160915e-16,  6.397929388240037e-17, -9.576376733955180e-18,
  1.084743833959833e-18, -9.884958418056489e-20,  7.537303370976078e-21, -4.942410148008624e-22,  2.843752579434618e-23, -1.458073326367756e-24,  6.743727836407869e-26,
 -2.837573806741322e-27,  3.014252621852549e-16, -1.276198833239112e-16,  2.888270736128739e-17, -4.440759067482919e-18,  5.164848972011763e-19, -4.829757587361984e-20,
  3.776660161778252e-21, -2.537973126525965e-22,  1.495589752996080e-23, -7.848621771334988e-25,  3.713084611809107e-26, -1.597025244367518e-27,  1.371737798092999e-16,
 -5.916742863296142e-17,  1.367043254914302e-17, -2.146035885806819e-18,  2.547655975332447e-19, -2.430639317114609e-20,  1.938219146112121e-21, -1.327587743701036e-22,
  7.969874151723445e-24, -4.258726751151025e-25,  2.050490588978317e-26, -8.971085351331315e-28,  6.238844494976196e-17, -2.725977032954852e-17,  6.389867923426897e-18,
 -1.017808423352931e-18,  1.225750763287897e-19, -1.185996652738218e-20,  9.587842165492407e-22, -6.655561397419752e-23,  4.047849785394964e-24, -2.190554188890451e-25,
  1.067790537159057e-26, -4.727903969039422e-28,  2.219004955260958e-17, -9.765594471373296e-18,  2.307665104229576e-18, -3.705807028438164e-19,  4.498916787619570e-20,
 -4.387389785047209e-21,  3.574203953142244e-22, -2.499737951313659e-23,  1.531442703765233e-24, -8.346667069650482e-26,  4.096807651859905e-27, -1.826163331448947e-28,
  6.353753789503053e-02, -1.672555207583796e-04,  4.567878293615032e-07, -1.286299229941023e-09,  3.706760301571537e-12, -1.085744014091194e-14,  3.212769622662556e-17,
 -9.565356130019073e-20,  2.854817407620068e-22, -8.529030339094013e-25,  2.544605035526120e-27, -7.584918435111119e-30,  5.911190471629107e-02, -1.940859483619222e-04,
  7.613469798618667e-07, -3.119179969259198e-09,  1.267795791610787e-11, -5.051137127781274e-14,  1.972079133910585e-16, -7.562878753476622e-19,  2.855675304841713e-21,
 -1.063859325015660e-23,  3.916294585214004e-26, -1.426421733621471e-28,  5.116820747202454e-02, -2.347283937396947e-04,  1.306363375657582e-06, -6.995453075906644e-09,
  3.553400842742259e-11, -1.730898180474565e-13,  8.156568579925093e-16, -3.740142237946813e-18,  1.675611895566553e-20, -7.356493177350316e-23,  3.172457297897550e-25,
 -1.346350205791406e-27,  4.121725570846935e-02, -2.699147041755800e-04,  1.966140496129584e-06, -1.294818978574054e-08,  7.918745102970445e-11, -4.586780264932308e-13,
  2.544824384645124e-15, -1.362409674526979e-17,  7.075591818452665e-20, -3.579042994100349e-22,  1.768817843846892e-24, -8.562321929558736e-27,  3.090457780503188e-02,
 -2.834911669974030e-04,  2.573776446797218e-06, -2.036456635674303e-08,  1.473830159702216e-10, -9.984238375885702e-13,  6.417076984388000e-15, -3.948967599258982e-17,
  2.342200560507153e-19, -1.345606164241279e-21,  7.516951984998534e-24, -4.095605278277664e-26,  2.157661126679467e-02, -2.690409893454911e-04,  2.967750264772753e-06,
 -2.784042645051909e-08,  2.354303228953969e-10, -1.842422129979562e-12,  1.355855334088912e-14, -9.485451685700810e-17,  6.357897892442596e-19, -4.106930310179378e-21,
  2.568220975684042e-23, -1.560280976571208e-25,  1.403316897636094e-02, -2.307978849265671e-04,  3.048455207935287e-06, -3.355907832390867e-08,  3.282568500365726e-10,
 -2.939603519412413e-12,  2.455128428483233e-14, -1.936373533230332e-16,  1.455136165077105e-18, -1.048831226780346e-20,  7.288268553956978e-23, -4.902407343159860e-25,
  8.507134686741405e-03, -1.796489495542258e-04,  2.812833587829905e-06, -3.602098057201547e-08,  4.042089941191262e-10, -4.111096818258324e-12,  3.869514400744028e-14,
 -3.417945515577415e-16,  2.861549135450127e-18, -2.287601730447465e-20,  1.756230458085555e-22, -1.300606392967376e-24,  4.810178758683514e-03, -1.274464821058293e-04,
  2.346187672632103e-06, -3.468595083648124e-08,  4.434906639433463e-10, -5.091166993378566e-12,  5.369384870990810e-14, -5.282852669412474e-16,  4.902139384031268e-18,
 -4.325132885948800e-20,  3.651096317207366e-22, -2.963321145901768e-24,  2.538885022222646e-03, -8.275436936853706e-05,  1.778083836709871e-06, -3.014575416710762e-08,
  4.366256884908811e-10, -5.627802308045696e-12,  6.618213074176613e-14, -7.219984522080049e-16,  7.393569893641867e-18, -7.169802270548231e-20,  6.628722895510442e-22,
 -5.873720206420039e-24,  1.252124555193649e-03, -4.937441599145087e-05,  1.229736302950415e-06, -2.376829739422713e-08,  3.879967602656566e-10, -5.589523629176903e-12,
  7.298768555379666e-14, -8.794138749066450e-16,  9.901517308730928e-18, -1.051621390228178e-19,  1.061230177091011e-21, -1.023299504672966e-23,  5.776528217176615e-04,
 -2.716446199699697e-05,  7.791973144063793e-07, -1.707782855712734e-08,  3.127868858184241e-10, -5.016091166129809e-12,  7.246272069007588e-14, -9.609886967408919e-16,
  1.185808691423065e-17, -1.375128615517922e-19,  1.510234582376547e-21, -1.580222642183433e-23,  2.496182197213195e-04, -1.382677887430838e-05,  4.539901461400409e-07,
 -1.122852963176417e-08,  2.298017777628659e-10, -4.087658705766113e-12,  6.511393416931106e-14, -9.475828719075262e-16,  1.277795389470442e-17, -1.613559045027439e-19,
  1.923592873746570e-21, -2.178648737242530e-23,  1.011916837687420e-04, -6.531780754700471e-06,  2.440800126471685e-07, -6.782001647169550e-09,  1.545191677045367e-10,
 -3.038682471972969e-12,  5.321669762513495e-14, -8.475069711197692e-16,  1.245729064202155e-17, -1.708797597955333e-19,  2.206194280044934e-21, -2.698705619122197e-23,
  3.855212503958415e-05, -2.872646536658898e-06,  1.215079568449930e-07, -3.777236716825843e-09,  9.547583507336642e-11, -2.069520901295174e-12,  3.973912720217024e-14,
 -6.908500993223266e-16,  1.104310234296476e-17, -1.641911101050636e-19,  2.290983567974257e-21, -3.020669031911639e-23,  1.383195846624782e-05, -1.179886120925521e-06,
  5.620507718048697e-08, -1.947143589395312e-09,  5.442666969329222e-11, -1.296715892195951e-12,  2.723259468821177e-14, -5.156162738822115e-16,  8.944022171246403e-18,
 -1.438500282349712e-19,  2.165074328016928e-21, -3.071355188660545e-23,  4.684737187927383e-06, -4.540732522627616e-07,  2.424376639539853e-08, -9.325702664764949e-10,
  2.873891481302807e-11, -7.506141705432093e-13,  1.720027352639680e-14, -3.539264732523537e-16,  6.648966801337156e-18, -1.154619446000308e-19,  1.871216441817003e-21,
 -2.851168411733035e-23,  1.501907463654171e-06, -1.643034993647698e-07,  9.788319184689791e-09, -4.166168725153564e-10,  1.411388976633254e-11, -4.031074575243702e-13,
  1.005648212471117e-14, -2.244309485357589e-16,  4.557677364052000e-18, -8.530460374975795e-20,  1.486133944871814e-21, -2.428337229319441e-23,  4.572187468925838e-07,
 -5.610846737057934e-08,  3.713932399918903e-09, -1.743279299243700e-10,  6.474349086439809e-12, -2.017235379567822e-13,  5.467146618276758e-15, -1.320725746542103e-16,
  2.894101857193800e-18, -5.828516258522888e-20,  1.089821679038143e-21, -1.906785864731670e-23,  1.326457270813243e-07, -1.815709326125979e-08,  1.329985541888606e-09,
 -6.862735309305402e-11,  2.786658110790341e-12, -9.449764844842143e-14,  2.776539605939331e-15, -7.246904117798379e-17,  1.710559852895276e-18, -3.700765228802014e-20,
  7.415397422367024e-22, -1.387205456064819e-23,  3.682475957987488e-08, -5.593165849713577e-09,  4.516288488925892e-10, -2.553912726595750e-11,  1.130878067946738e-12,
 -4.164285743891895e-14,  1.323786113788344e-15, -3.726131109370490e-17,  9.457685136128129e-19, -2.194583923472150e-20,  4.705272864388353e-22, -9.397789942072428e-24,
  9.828855289233333e-09, -1.648287156824749e-09,  1.461738694415909e-10, -9.031413112697915e-12,  4.349815452550342e-13, -1.735409818279955e-14,  5.956536496852407e-16,
 -1.804773818462888e-17,  4.917536730149939e-19, -1.221895756111222e-20,  2.798984555811048e-22, -5.960053086292095e-24,  2.535704938394087e-09, -4.672907683278149e-10,
  4.534930380910646e-11, -3.052272643910276e-12,  1.594886966724575e-13, -6.878334649561295e-15,  2.543912656604435e-16, -8.281467551156110e-18,  2.418113790175547e-19,
 -6.423569141477886e-21,  1.569672683785045e-22, -3.558198004594675e-24,  6.361344689406485e-10, -1.282366823119031e-10,  1.357071366630028e-11, -9.920440890063573e-13,
  5.609269531087842e-14, -2.609047033831263e-15,  1.037578958013941e-16, -3.622166158818711e-18,  1.131374512879654e-19, -3.207674131149572e-21,  8.348319304148133e-23,
 -2.011552566028652e-24,  1.562454366735329e-10, -3.430090381300825e-11,  3.944322432706175e-12, -3.122296531458828e-13,  1.905343270195548e-14, -9.535476186399542e-16,
  4.068768389430130e-17, -1.520142029778640e-18,  5.069671929332304e-20, -1.531383024126141e-21,  4.237830585233995e-23, -1.083658959528963e-24,  3.786025253167770e-11,
 -9.011489864200081e-12,  1.122018982827346e-12, -9.588412998658011e-14,  6.297785443913010e-15, -3.382823644348387e-16,  1.545241779712299e-17, -6.165609943528820e-19,
  2.191141294564431e-20, -7.038535904316698e-22,  2.067379515636748e-23, -5.600725266977511e-25,  9.127680992415622e-12, -2.345130281276774e-12,  3.150214765649608e-13,
 -2.897076246226849e-14,  2.042252060667471e-15, -1.174341996956410e-16,  5.728791962885628e-18, -2.435700013892969e-19,  9.204404028200590e-21, -3.137917998329447e-22,
  9.763904929738335e-24, -2.797181709828545e-25,  2.210051176089782e-12, -6.101832817239091e-13,  8.810283461106613e-14, -8.690631415768396e-15,  6.555517793919510e-16,
 -4.024244296326897e-17,  2.091141404985591e-18, -9.450858830790027e-20,  3.788983211160261e-21, -1.367893099680181e-22,  4.499545604979536e-24, -1.360387777491533e-25,
  5.429331945384796e-13, -1.603528421112720e-13,  2.479048678251486e-14, -2.613840346791886e-15,  2.103070084544279e-16, -1.374143203492302e-17,  7.584888186180559e-19,
 -3.634273925428153e-20,  1.541907120766530e-21, -5.880703150164343e-23,  2.040236007824039e-24, -6.495409782901083e-26,  1.368270014876792e-13, -4.302729646074138e-14,
  7.093678356228390e-15, -7.965143889466022e-16,  6.812361122529031e-17, -4.722579874242292e-18,  2.760539502376073e-19, -1.398259751079604e-20,  6.260643579776511e-22,
 -2.515836905072354e-23,  9.182539839092386e-25, -3.070808696827654e-26,  3.578779474676340e-14, -1.192495372979962e-14,  2.087586486277008e-15, -2.486438882732519e-16,
  2.252174569432614e-17, -1.650694027258868e-18,  1.018435474343406e-19, -5.435918839419809e-21,  2.560779425762149e-22, -1.081076819848994e-23,  4.139425007919791e-25,
 -1.450131764142853e-26,  9.832336067576282e-15, -3.454344092549577e-15,  6.392064761034479e-16, -8.041557722704781e-17,  7.683164004893936e-18, -5.931004117861806e-19,
  3.848241260402697e-20, -2.156888109055725e-21,  1.065451552980511e-22, -4.710103213928641e-24,  1.886063043570217e-25, -6.900542195802782e-27,  2.871710020607523e-15,
 -1.058278314671357e-15,  2.059987655878499e-16, -2.724843681949459e-17,  2.734155503292921e-18, -2.213721961453501e-19,  1.504477115129593e-20, -8.820719926981305e-22,
  4.552019561955512e-23, -2.099689149566893e-24,  8.762241388588304e-26, -3.336878096542219e-27,  9.017482948692850e-16, -3.467234490437097e-16,  7.063235618499948e-17,
 -9.775033769635997e-18,  1.025244789285476e-18, -8.666907636829046e-20,  6.142604128663580e-21, -3.751354486577296e-22,  2.014223787841718e-23, -9.655957653684458e-25,
  4.183364058485083e-26, -1.652095043820181e-27,  3.073438040506141e-16, -1.226242383731986e-16,  2.600041970261521e-17, -3.744845591177768e-18,  4.084612456087334e-19,
 -3.587402204572077e-20,  2.638893957135544e-21, -1.670974336431651e-22,  9.293245754994906e-24, -4.610094940645531e-25,  2.064830671334385e-26, -8.421840320015178e-28,
  1.143769186224231e-16, -4.708605747426728e-17,  1.033166463114197e-17, -1.539948823275347e-18,  1.737180204754588e-19, -1.576716385369467e-20,  1.197587045885882e-21,
 -7.823368058801154e-23,  4.484988195589096e-24, -2.291461788144988e-25,  1.056196430266644e-26, -4.429482359230803e-28,  4.642260260991485e-17, -1.960533158866927e-17,
  4.424727964575902e-18, -6.784187262122096e-19,  7.868890199672762e-20, -7.338833477694834e-21,  5.723850876847927e-22, -3.836890170460915e-23,  2.255535111752789e-24,
 -1.180884170506244e-25,  5.573867111466416e-27, -2.392071112994157e-28,  2.021286061535742e-17, -8.705672410668436e-18,  2.008138271780451e-18, -3.147294276152938e-19,
  3.730288495925655e-20, -3.553368917963683e-21,  2.829171027639012e-22, -1.934972757759204e-23,  1.159943909679878e-24, -6.189526515247899e-26,  2.976084717530929e-27,
 -1.300352691808446e-28,  8.907494266014426e-18, -3.889201469684503e-18,  9.109182703442702e-19, -1.449773162261317e-19,  1.744566690414072e-20, -1.686660217431079e-21,
  1.362485697136729e-22, -9.450856440618696e-24,  5.743739136318971e-25, -3.106107538124094e-26,  1.513034563597573e-27, -6.694844225822188e-29,  3.111989278695002e-18,
 -1.369140824157914e-18,  3.234258327030266e-19, -5.192001681796016e-20,  6.301022469839397e-21, -6.142743408389027e-22,  5.002545435534156e-23, -3.497553674141650e-24,
  2.142059551940423e-25, -1.167098332206560e-26,  5.726722743016108e-28, -2.551933927924463e-29,  6.287572806050040e-02, -1.636619684832927e-04,  4.417010549438468e-07,
 -1.228687253428715e-09,  3.497110420767818e-12, -1.011751041054942e-14,  2.957281278451425e-17, -8.699040762503189e-20,  2.565317262635460e-22, -7.574872288138091e-25,
  2.233484821441984e-27, -6.582282319970345e-30,  5.834751018601646e-02, -1.881415198985435e-04,  7.251013804568658e-07, -2.924164321396895e-09,  1.171339703243315e-11,
 -4.602251132966129e-14,  1.772557058551803e-16, -6.707436123119314e-19,  2.499434437080522e-21, -9.190660300536868e-24,  3.339781992644538e-26, -1.200956997797482e-28,
  5.024967736332406e-02, -2.246038595905169e-04,  1.225718314879253e-06, -6.453574241981838e-09,  3.225979013391691e-11, -1.547125134066695e-13,  7.180582959519306e-16,
 -3.243981977380325e-18,  1.432261536459744e-20, -6.198446147616407e-23,  2.635491427812217e-25, -1.102956130262138e-27,  4.016810059246669e-02, -2.547862305861764e-04,
  1.818071892207866e-06, -1.175138584862520e-08,  7.059502238802201e-11, -4.019355191206443e-13,  2.193204599672522e-15, -1.155310887526812e-17,  5.905910064966132e-20,
 -2.941452882969690e-22,  1.431754366719286e-24, -6.827672316065882e-27,  2.981030051366338e-02, -2.638398314730471e-04,  2.342917574313927e-06, -1.815817930467002e-08,
  1.288692695580246e-10, -8.568783508731173e-13,  5.409408409117609e-15, -3.271502118013347e-17,  1.907827194040354e-19, -1.078086986139964e-21,  5.925776527714131e-24,
 -3.177741957721011e-26,  2.054590229369248e-02, -2.465739805837673e-04,  2.655105359619498e-06, -2.435151180699401e-08,  2.016321297601195e-10, -1.546718794671615e-12,
  1.116657342949128e-14, -7.668925520897966e-17,  5.048888305560867e-19, -3.204830656086904e-21,  1.970146746435599e-23, -1.177063520467862e-25,  1.315632264098634e-02,
 -2.079360621408305e-04,  2.675417673577529e-06, -2.874704345247031e-08,  2.749437014914884e-10, -2.410502838830618e-12,  1.972835640409705e-14, -1.525912417888621e-16,
  1.125219534730586e-18, -7.962709094538549e-21,  5.434992343320698e-23, -3.592342802762605e-25,  7.830954003141320e-03, -1.587712795455028e-04,  2.416827545823702e-06,
 -3.016403070275241e-08,  3.305491178283516e-10, -3.287624077160578e-12,  3.029212025722158e-14, -2.621502752921940e-16,  2.151785445471203e-18, -1.687508602336265e-20,
  1.271557520755912e-22, -9.246655151649063e-25,  4.335456342521432e-03, -1.102285843186214e-04,  1.969384986587434e-06, -2.833939799920800e-08,  3.534415504458437e-10,
 -3.963636248200874e-12,  4.088265295346768e-14, -3.937475981773484e-16,  3.579308356786472e-18, -3.095686467300724e-20,  2.563113055310449e-22, -2.041385816570712e-24,
  2.234182861862509e-03, -6.986595852398898e-05,  1.454798370653662e-06, -2.398031129259234e-08,  3.384445398002033e-10, -4.257501284977927e-12,  4.892421563012246e-14,
 -5.220510137105418e-16,  5.233343201191991e-18, -4.971450618071582e-20,  4.505258189105638e-22, -3.915165189636449e-24,  1.072634802009996e-03, -4.057978554395517e-05,
  9.783622206608119e-07, -1.836726702251537e-08,  2.919000173966412e-10, -4.100723973629845e-12,  5.228451598767374e-14, -6.157526380041210e-16,  6.782370469236371e-18,
 -7.052265543594985e-20,  6.971872214130182e-22, -6.589659979555518e-24,  4.802749951533732e-04, -2.167259425267027e-05,  6.012631148913677e-07, -1.278975349494231e-08,
  2.278802026251472e-10, -3.561187983779898e-12,  5.019909767996976e-14, -6.503152660551194e-16,  7.845871893411260e-18, -8.902891586918529e-20,  9.573936569296173e-22,
 -9.814940394448925e-24,  2.008022745689343e-04, -1.067702427412756e-05,  3.388631601922818e-07, -8.129071586726334e-09,  1.617446419905280e-10, -2.801986469097833e-12,
  4.352879776884814e-14, -6.184722243694627e-16,  8.150360924988531e-18, -1.006625776879530e-19,  1.174559752542277e-21, -1.302885110941274e-23,  7.850817739688811e-05,
 -4.866852465365228e-06,  1.757288478304542e-07, -4.733814672259699e-09,  1.048061067325988e-10, -2.006326690311965e-12,  3.425174382211319e-14, -5.323498751729093e-16,
  7.644006680259506e-18, -1.025177025175551e-19,  1.295046990923184e-21, -1.551030886298577e-23,  2.875149910465700e-05, -2.058759778908403e-06,  8.413238871440693e-08,
 -2.534849561764149e-09,  6.224126794712216e-11, -1.312863877503151e-12,  2.456650595081244e-14, -4.166697254886597e-16,  6.504521909067575e-18, -9.452930507409117e-20,
  1.290218830426396e-21, -1.665207104170384e-23,  9.882277021749130e-06, -8.106668384088271e-07,  3.731137807676280e-08, -1.252662810404581e-09,  3.400758024023655e-11,
 -7.882860998205083e-13,  1.612915733800856e-14, -2.978814904667775e-16,  5.045244229081685e-18, -7.930021285690766e-20,  1.167323344587831e-21, -1.620723721154747e-23,
  3.195165685842235e-06, -2.980798496741392e-07,  1.538084461598965e-08, -5.733981233173220e-10,  1.716165188330019e-11, -4.360634119845665e-13,  9.734507654991313e-15,
 -1.953649020285614e-16,  3.583292484646935e-18, -6.080615648329099e-20,  9.637326300601231e-22, -1.437114272368732e-23,  9.743512848109172e-07, -1.026926208163812e-07,
  5.915081768904128e-09, -2.440509422742860e-10,  8.030762220544537e-12, -2.231539705911191e-13,  5.423671690989295e-15, -1.180584589527699e-16,  2.340792326508374e-18,
 -4.281373791115761e-20,  7.294661502518852e-22, -1.166562542156173e-23,  2.810923220943177e-07, -3.326958360550726e-08,  2.130459429242213e-09, -9.697617224372210e-11,
  3.499288117499521e-12, -1.060975546585504e-13,  2.801872354948557e-15, -6.602877739286568e-17,  1.412863279107227e-18, -2.780955582695466e-20,  5.086109694045628e-22,
 -8.710496101698053e-24,  7.698808248642538e-08, -1.017648687409113e-08,  7.216882084833240e-10, -3.613242970291265e-11,  1.426118098441612e-12, -4.707742442380848e-14,
  1.348245661833654e-15, -3.433779382471346e-17,  7.916574171946894e-19, -1.674358525564753e-20,  3.282393828949505e-22, -6.011900136200479e-24,  2.010023257017482e-08,
 -2.952036562057431e-09,  2.309917758951298e-10, -1.268313419907201e-11,  5.462132863900202e-13, -1.958961864823672e-14,  6.072567895862958e-16, -1.668579442693241e-17,
  4.138290196964873e-19, -9.390883655110540e-21,  1.970575672051481e-22, -3.854785227660807e-24,  5.025809102321554e-09, -8.161599916137674e-10,  7.021503151305916e-11,
 -4.215991111119786e-12,  1.976345392443367e-13, -7.684534201198341e-15,  2.573573043220446e-16, -7.616205923164381e-18,  2.028783787033959e-19, -4.932361164550783e-21,
  1.106322309772899e-22, -2.308332644757624e-24,  1.209921348665566e-09, -2.162602422035326e-10,  2.038503206442776e-11, -1.334733350929848e-12,  6.794216580399816e-14,
 -2.858030849482842e-15,  1.032130784470512e-16, -3.284074849667765e-18,  9.380760691398829e-20, -2.439723375824710e-21,  5.841087793051005e-23, -1.298177786920412e-24,
  2.821641645509158e-10, -5.526403374322544e-11,  5.688301636910528e-12, -4.050010207360871e-13,  2.233201663652707e-14, -1.014132726637163e-15,  3.941568532252981e-17,
 -1.346020119319036e-18,  4.116121036705113e-20, -1.143411254224698e-21,  2.917741211585613e-23, -6.897691227940427e-25,  6.418739672668667e-11, -1.371591268683148e-11,
  1.536394680903977e-12, -1.186127208954706e-13,  7.067278969843890e-15, -3.456972959290876e-16,  1.443119296429783e-17, -5.279383691189885e-19,  1.725364204445062e-20,
 -5.110942265137479e-22,  1.387929019239299e-23, -3.484977640796607e-25,  1.435505503957456e-11, -3.332299677692865e-12,  4.048380774117899e-13, -3.379098393627265e-14,
  2.169975812330717e-15, -1.140694758809476e-16,  5.103717752243300e-18, -1.996239657963547e-19,  6.959408834274326e-21, -2.194544555251486e-22,  6.331635862431675e-24,
 -1.685919337893696e-25,  3.184145068184512e-12, -7.995030166124867e-13,  1.049800367906724e-13, -9.445115067368015e-15,  6.519640495734754e-16, -3.674035395184274e-17,
  1.757876449335883e-18, -7.335719645499888e-20,  2.722715682208263e-21, -9.122403424473096e-23,  2.791304369995788e-24, -7.868055769974039e-26,  7.074232539655986e-13,
 -1.912895135794180e-13,  2.704992284821170e-14, -2.615008340735715e-15,  1.934677879107071e-16, -1.165711403786138e-17,  5.949791781190145e-19, -2.642944623201915e-20,
  1.042091135860006e-21, -3.702131090206146e-23,  1.199000797621919e-24, -3.571033652815785e-26,  1.591376758303229e-13, -4.613384058630892e-14,  6.999228458537544e-15,
 -7.246113348058943e-16,  5.728297205322376e-17, -3.679875068624536e-18,  1.998253136942434e-19, -9.424860559761287e-21,  3.938328232210004e-22, -1.480148979550369e-23,
  5.062812190848183e-25, -1.589874387423193e-26,  3.667797238550079e-14, -1.134681905367924e-14,  1.839653685901185e-15, -2.032245561728769e-16,  1.710945882496261e-17,
 -1.168199899983187e-18,  6.729249196047994e-20, -3.360621562730408e-21,  1.484301777424686e-22, -5.886510292397389e-24,  2.121290756136209e-25, -7.007136744045931e-27,
  8.771524384869028e-15, -2.881889057392567e-15,  4.972044910890072e-16, -5.838124923275734e-17,  5.215517224272128e-18, -3.771951901724280e-19,  2.297408163394268e-20,
 -1.211087906849318e-21,  5.637114473014298e-23, -2.352328420743634e-24,  8.906437879402760e-26, -3.086457409139709e-27,  2.205677059094418e-15, -7.657768360127182e-16,
  1.399558690705848e-16, -1.739392022031826e-17,  1.642327984851030e-18, -1.253367587231240e-19,  8.042855728482692e-21, -4.460007145865267e-22,  2.180505394469438e-23,
 -9.543725724336505e-25,  3.784856469906584e-26, -1.371908438548283e-27,  5.910781331816076e-16, -2.157224197254179e-16,  4.156291726466948e-17, -5.442392332244177e-18,
  5.407520394948722e-19, -4.336693724941052e-20,  2.920232590557663e-21, -1.696932392220901e-22,  8.682026701550185e-24, -3.971468689024221e-25,  1.644022953882774e-26,
 -6.212251592391756e-28,  1.710046253604855e-16, -6.525071234540275e-17,  1.318416293147580e-17, -1.809878531691428e-18,  1.883346182754705e-19, -1.579942804237653e-20,
  1.111501758016547e-21, -6.739544223341050e-23,  3.593653908866210e-24, -1.711226986549551e-25,  7.365724065489430e-27, -2.890670256716768e-28,  5.402083450231157e-17,
 -2.142936954545232e-17,  4.515497239448989e-18, -6.463516029977257e-19,  7.007428016775167e-20, -6.118382232491098e-21,  4.475135135782229e-22, -2.818124419641879e-23,
  1.558980138341018e-24, -7.693783125660804e-26,  3.428805632748178e-27, -1.391770549956820e-28,  1.878126185556763e-17, -7.700160989805101e-18,  1.682034220238356e-18,
 -2.495939396338267e-19,  2.803353590392948e-20, -2.533636421286985e-21,  1.916508910809739e-22, -1.246998706934951e-23,  7.121253242498667e-25, -3.624795172902868e-26,
  1.664724416520861e-27, -6.957138084860162e-29,  7.191842927206440e-18, -3.029145516453754e-18,  6.816305328420208e-19, -1.042021952827163e-19,  1.205132136925997e-20,
 -1.120788205325842e-21,  8.717574755465245e-23, -5.828186469277835e-24,  3.417320437853539e-25, -1.784678138542797e-26,  8.403478583101264e-28, -3.598002720635351e-29,
  2.988996834762430e-18, -1.285351952781788e-18,  2.959786908859543e-19, -4.630724212567540e-20,  5.479137342077877e-21, -5.210586319338685e-22,  4.141922188051484e-23,
 -2.828357339701694e-24,  1.692907244140415e-25, -9.020071488698408e-27,  4.330851551074129e-28, -1.889664961086564e-29,  1.274034547031222e-18, -5.558456444675429e-19,
  1.300773802618439e-19, -2.068465619020246e-20,  2.486950377926566e-21, -2.402406064289298e-22,  1.939094184949542e-23, -1.343987965728233e-24,  8.161787530426470e-26,
 -4.410444676615829e-27,  2.146835605508427e-28, -9.492570846309193e-30,  4.367601448883215e-19, -1.920952978813870e-19,  4.536168892610608e-20, -7.279353692587105e-21,
  8.831074992660643e-22, -8.606204713410417e-23,  7.006316298618981e-24, -4.896833114428240e-25,  2.998040825498400e-26, -1.632944403094164e-27,  8.009969845610031e-29,
 -3.568273225857838e-30,  6.222805534614065e-02, -1.601864009499918e-04,  4.272859756384743e-07, -1.174314537190746e-09,  3.301665082722424e-12, -9.436088656287792e-15,
  2.724802779188343e-17, -7.920101310318583e-20,  2.308029071597509e-22, -6.736773944947132e-25,  1.963272900480832e-27, -5.721623507299997e-30,  5.760632789959031e-02,
 -1.824779511818846e-04,  6.911062515215235e-07, -2.743888655952962e-09,  1.083401237361235e-11, -4.198500303742044e-14,  1.595466715648571e-16, -5.958076849530914e-19,
  2.191396618001713e-21, -7.954659049708743e-24,  2.853882804209706e-26, -1.013319440113029e-28,  4.937039503155377e-02, -2.150993392014409e-04,  1.151273204452078e-06,
 -5.961265230612054e-09,  2.933077567479337e-11, -1.385192930619085e-13,  6.333218466268192e-16, -2.819417950510383e-18,  1.226979523411593e-20, -5.235210777042688e-23,
  2.195018042823309e-25, -9.060222879747778e-28,  3.917717804084080e-02, -2.407871130151829e-04,  1.683576079291033e-06, -1.068342149966402e-08,  6.305754222843701e-11,
 -3.529762989426435e-13,  1.894659642420963e-15, -9.822153870547044e-18,  4.943225096865236e-20, -2.424579146427643e-22,  1.162548327070833e-24, -5.462435381027004e-27,
  2.879109567185043e-02, -2.459342891678072e-04,  2.136847360089094e-06, -1.622661713848415e-08,  1.129591818054812e-10, -7.373892169898726e-13,  4.573334847436679e-15,
 -2.718780551929621e-17,  1.559214975074569e-19, -8.668160827852934e-22,  4.688873170739181e-24, -2.475247728589935e-26,  1.960031178423095e-02, -2.264494262394339e-04,
  2.381268316947520e-06, -2.135901007567925e-08,  1.732128022661854e-10, -1.302764352379798e-12,  9.229148356115560e-15, -6.223627896152322e-17,  4.025349178116473e-19,
 -2.511351824129713e-21,  1.517977290885322e-23, -8.920317117205782e-26,  1.236530124971952e-02, -1.878412979029191e-04,  2.355336348093117e-06, -2.470928162308116e-08,
  2.311423297009457e-10, -1.984474750144462e-12,  1.591962728527753e-14, -1.207802272634667e-16,  8.741626748496273e-19, -6.074756306346827e-21,  4.073558901765003e-23,
 -2.646251179129738e-25,  7.232366310640442e-03, -1.407993756920373e-04,  2.084543517639313e-06, -2.536412628828332e-08,  2.715101406213033e-10, -2.641442937732323e-12,
  2.383114785689633e-14, -2.021059443992922e-16,  1.626809667703656e-18, -1.251824985536282e-20,  9.259993411731732e-23, -6.613451779946281e-25,  3.924026563895585e-03,
 -9.574335550556647e-05,  1.660789578786451e-06, -2.326873215997518e-08,  2.831504073148761e-10, -3.102772114008743e-12,  3.130686317946004e-14, -2.952254181122340e-16,
  2.629628285023194e-18, -2.229909144674147e-20,  1.811222559934181e-22, -1.415840384032675e-24,  1.976295222307340e-03, -5.929264986345710e-05,  1.196909212119456e-06,
 -1.918725116990610e-08,  2.639435247730684e-10, -3.241342695876798e-12,  3.640524332997550e-14, -3.800526773556406e-16,  3.730360187807527e-18, -3.472110570243520e-20,
  3.084806654551801e-22, -2.629575708722725e-24,  9.246779393392437e-04, -3.356093734681753e-05,  7.834767732972597e-07, -1.429025256113572e-08,  2.211547471642065e-10,
 -3.030430025057783e-12,  3.773559624417291e-14, -4.344758338911267e-16,  4.682684366546554e-18, -4.767762618890458e-20,  4.618333187613919e-22, -4.279519228311756e-24,
  4.023136766621106e-04, -1.741943059288579e-05,  4.675084642177785e-07, -9.653716775543423e-09,  1.673642671706307e-10, -2.549261612304375e-12,  3.507157125044909e-14,
 -4.439066154521011e-16,  5.237328642926400e-18, -5.816171209553357e-20,  6.125306194107516e-22, -6.153434703005463e-24,  1.629551046533755e-04, -8.316237347388765e-06,
  2.551614425121624e-07, -5.938111129332336e-09,  1.148883309879446e-10, -1.938680292719598e-12,  2.937683527018764e-14, -4.075891808756512e-16,  5.250038581416549e-18,
 -6.342914765203691e-20,  7.245012609201428e-22, -7.872061617650120e-24,  6.152922114572848e-05, -3.662520244709675e-06,  1.277922226943026e-07, -3.337876051319945e-09,
  7.182220493845641e-11, -1.338596863919448e-12,  2.227986108862397e-14, -3.379928407994357e-16,  4.741701146760048e-18, -6.218412048626888e-20,  7.686947161227122e-22,
 -9.014954964190477e-24,  2.169143936429520e-05, -1.492249353718856e-06,  5.891673338062070e-08, -1.720593343572011e-09,  4.104434924156282e-11, -8.425692668297961e-13,
  1.536567633590727e-14, -2.542904737817521e-16,  3.877174021020220e-18, -5.508113747807750e-20,  7.354726213402697e-22, -9.292555026625892e-24,  7.153024952638834e-06,
 -5.641279699267322e-07,  2.508498659920199e-08, -8.161733615918952e-10,  2.152142369260868e-11, -4.853780344352183e-13,  9.676549000363241e-15, -1.743318017129949e-16,
  2.883219609341846e-18, -4.429087632123171e-20,  6.376954020140188e-22, -8.665995841190975e-24,  2.211171404939182e-06, -1.984769485639846e-07,  9.896330080300392e-09,
 -3.575383154950139e-10,  1.039283784848818e-11, -2.569050453342381e-13,  5.587163854110953e-15, -1.093679593912818e-16,  1.958542164183878e-18, -3.247817783686997e-20,
  5.034277449806980e-22, -7.347163060784249e-24,  6.423625965996281e-07, -6.520030850769301e-08,  3.630311096197014e-09, -1.451789902765413e-10,  4.639969226332562e-12,
 -1.254343713060841e-13,  2.969993428255012e-15, -6.305463872583450e-17,  1.220621559724807e-18, -2.181661549884686e-20,  3.635308865244950e-22, -5.689728353528878e-24,
  1.758887535963191e-07, -2.006927368256589e-08,  1.242968141919175e-09, -5.485681071259769e-11,  1.922968483828997e-12, -5.673063536869135e-14,  1.459696457114191e-15,
 -3.355437891529049e-17,  7.010586563387478e-19, -1.348568777400317e-20,  2.412325046225655e-22, -4.043723189253190e-24,  4.554900029945587e-08, -5.811005141107530e-09,
  3.988471181641465e-10, -1.937054450815266e-11,  7.429944099091550e-13, -2.387212068225166e-14,  6.662838087192752e-16, -1.655628422996327e-17,  3.727842294284629e-19,
 -7.706921563823047e-21,  1.478017365914727e-22, -2.650172689763455e-24,  1.120015948134619e-08, -1.589646046135374e-09,  1.204895590770892e-10, -6.421649454713309e-12,
  2.689017217527835e-13, -9.390698306435637e-15,  2.838092154020290e-16, -7.611263049913203e-18,  1.844191275662507e-19, -4.092063076038462e-21,  8.402710598164768e-23,
 -1.609651119528135e-24,  2.627049983573837e-09, -4.128637262486346e-10,  3.444095142817376e-11, -2.008914036387437e-12,  9.162839956351840e-14, -3.471227982317843e-15,
  1.134009894397758e-16, -3.277097881353053e-18,  8.532246777767219e-20, -2.029203566847012e-21,  4.455825215057786e-23, -9.108165277436481e-25,  5.909014615282767e-10,
 -1.023703163127551e-10,  9.367631336309778e-12, -5.964158954182548e-13,  2.956398840218158e-14, -1.212588329745773e-15,  4.274570822669860e-17, -1.328975878253385e-18,
  3.712609333854016e-20, -9.450898650490823e-22,  2.216362770892645e-23, -4.828357584749807e-25,  1.282382362721249e-10, -2.438513469604003e-11,  2.439837742513258e-12,
 -1.691065448089042e-13,  9.089375988761363e-15, -4.028246275456497e-16,  1.529549687421401e-17, -5.107767276082751e-19,  1.528711190382663e-20, -4.159462791677443e-22,
  1.040376685492915e-23, -2.412410598415264e-25,  2.704079447220433e-11, -5.620114152014442e-12,  6.128582182349081e-13, -4.611832750345397e-14,  2.681629497143021e-15,
 -1.281498557528314e-16,  5.231496607174685e-18, -1.873246070756242e-19,  5.996978643699963e-21, -1.741468974221411e-22,  4.639195962239541e-24, -1.143456272119747e-25,
  5.584650413114425e-12, -1.263351149560531e-12,  1.496593700360273e-13, -1.219370721266828e-14,  7.651830551033503e-16, -3.934449861249388e-17,  1.723445332176665e-18,
 -6.605090418164056e-20,  2.257996583535628e-21, -6.986894001823801e-23,  1.979365749609263e-24, -5.178301752253851e-26,  1.139965311294686e-12, -2.795094420635709e-13,
  3.585034567188825e-14, -3.153548687275417e-15,  2.130246303186238e-16, -1.175841668037255e-17,  5.515061643327964e-19, -2.257829578172260e-20,  8.227014423321147e-22,
 -2.707844985986510e-23,  8.144411138691963e-25, -2.257940609610182e-26,  2.323540825778807e-13, -6.148554684161902e-14,  8.509099815573538e-15, -8.056602574916517e-16,
  5.842566596858259e-17, -3.453381468782883e-18,  1.730354661991428e-19, -7.550936227152893e-21,  2.926690632153667e-22, -1.022684235740621e-23,  3.259652381982312e-25,
 -9.559715113020488e-27,  4.783343961623928e-14, -1.360061898151787e-14,  2.023493703657218e-15, -2.055561187441257e-16,  1.595614654046750e-17, -1.007192516733447e-18,
  5.377642760186007e-20, -2.495436794654098e-21,  1.026514949864881e-22, -3.799937940791571e-24,  1.280861868615005e-25, -3.965796867239099e-27,  1.007172616865323e-14,
 -3.063006025270491e-15,  4.880248576005899e-16, -5.300496908659012e-17,  4.390016219492058e-18, -2.950492839875728e-19,  1.673941884551573e-20, -8.238078593580247e-22,
  3.587435915396375e-23, -1.403414286056780e-24,  4.991060308633188e-26, -1.627775568182826e-27,  2.198879523346867e-15, -7.118434120379458e-16,  1.209552262745568e-16,
 -1.399252018091036e-17,  1.232146365907349e-18, -8.788025439420639e-20,  5.281247928899320e-21, -2.748218970076234e-22,  1.263292105336036e-23, -5.208349441298632e-25,
  1.949107642682819e-26, -6.678760173487300e-28,  5.050418132370278e-16, -1.731682783073192e-16,  3.123958372160895e-17, -3.833238680076864e-18,  3.574786609877196e-19,
 -2.695691330344595e-20,  1.709942787929447e-21, -9.376885892074325e-23,  4.535203662465986e-24, -1.964405743853526e-25,  7.712333317728057e-27, -2.768440471739258e-28,
  1.238729126941622e-16, -4.474885566654997e-17,  8.529090954217157e-18, -1.105010926933832e-18,  1.086637950648745e-19, -8.627784879065534e-21,  5.753824568986449e-22,
 -3.312405550488949e-23,  1.679483858909379e-24, -7.615735347334190e-26,  3.126072353147506e-27, -1.171647557103461e-28,  3.292576130205398e-17, -1.246223835788994e-17,
  2.496372899738949e-18, -3.397771873392511e-19,  3.506387024589208e-20, -2.917877974498983e-21,  2.036786349892710e-22, -1.225708092986943e-23,  6.488168935988451e-25,
 -3.067799546128551e-26,  1.311499439427857e-27, -5.113128390626357e-29,  9.611498988953070e-18, -3.789484994649039e-18,  7.932443532267891e-19, -1.128034574112363e-19,
  1.215159809302447e-20, -1.054422144127552e-21,  7.666059202993726e-23, -4.799528008352543e-24,  2.640179132040880e-25, -1.295885188500831e-26,  5.744861830880040e-28,
 -2.320028061171435e-29,  3.112270396928375e-18, -1.270454827848094e-18,  2.762042336016287e-19, -4.079191362286552e-20,  4.560458415102884e-21, -4.103196504991470e-22,
  3.090266857125414e-23, -2.002248436243466e-24,  1.138763886080124e-25, -5.773547620267777e-27,  2.641425918175846e-28, -1.099816963850957e-29,  1.121156095788320e-18,
 -4.708742770231762e-19,  1.056253845869192e-19, -1.609651116652259e-20,  1.855894273871596e-21, -1.720845322760857e-22,  1.334603001629289e-23, -8.897473047199650e-25,
  5.202760792916698e-26, -2.709942357427300e-27,  1.272761856289844e-28, -5.435944596147529e-30,  4.436691418945787e-19, -1.904731323636209e-19,  4.377952486985714e-20,
 -6.836857503128291e-21,  8.074797255454920e-22, -7.665452401435790e-23,  6.082840792339147e-24, -4.146808658877959e-25,  2.478048135788058e-26, -1.318270604895593e-27,
  6.319845303899408e-29, -2.753456418934976e-30,  1.825688571213849e-19, -7.958799574466797e-20,  1.860807466600861e-20, -2.956321372346530e-21,  3.551240689988839e-22,
 -3.427502083713076e-23,  2.764127917397224e-24, -1.914222366687087e-25,  1.161528521568864e-26, -6.271684428969517e-28,  3.050473334962667e-29, -1.347810947493866e-30,
  6.134619961603870e-20, -2.697234986007301e-20,  6.366930718231104e-21, -1.021339563974527e-21,  1.238592727829292e-22, -1.206609190469126e-23,  9.819458521397250e-25,
 -6.860550440375208e-26,  4.198847696908639e-27, -2.286209107188559e-28,  1.121064021712329e-29, -4.992476039876899e-31,  6.159405831926184e-02, -1.568235963054595e-04,
  4.135050462926360e-07, -1.122962877884245e-09,  3.119307428455066e-12, -8.807934825637675e-15,  2.513025845924108e-17, -7.218868053144846e-20,  2.079054769964196e-22,
 -5.999555983327692e-25,  1.728204376066600e-27, -4.981641568483732e-30,  5.688726933714109e-02, -1.770779234669506e-04,  6.591926014988890e-07, -2.577059542440119e-09,
  1.003129208018956e-11, -3.834840714918245e-14,  1.438042731628871e-16, -5.300529859571148e-19,  1.924546518096002e-21, -6.897465514143709e-24,  2.443477903213975e-26,
 -8.568070818835089e-29,  4.852797598188702e-02, -2.061675216398236e-04,  1.082464957102921e-06, -5.513336119374474e-09,  2.670621473953938e-11, -1.242242083257207e-13,
  5.596033272671636e-16, -2.455319730988201e-18,  1.053400791262615e-20, -4.431988026081595e-23,  1.832725680768300e-25, -7.462266867357163e-28,  3.824017839241537e-02,
 -2.278146778852929e-04,  1.561203336062416e-06, -9.728596786932964e-09,  5.643134861650755e-11, -3.106337197124423e-13,  1.640534165092936e-15, -8.371452377607733e-18,
  4.148596858015962e-20, -2.004271181855633e-22,  9.468369936760480e-25, -4.384252831287085e-27,  2.784035679592333e-02, -2.295887463436593e-04,  1.952503993192145e-06,
 -1.453153791691627e-08,  9.925013193974807e-11, -6.362280615966443e-13,  3.877484162847224e-15, -2.266343252081012e-17,  1.278452282420336e-19, -6.993512605013686e-22,
  3.723640988875246e-24, -1.935410608601566e-26,  1.873105508558419e-02, -2.083793031565129e-04,  2.140766226402560e-06, -1.878458005856570e-08,  1.492385416922358e-10,
 -1.100800145592023e-12,  7.654069814562668e-15, -5.069177835115206e-17,  3.221717919464033e-19, -1.975940109248317e-21,  1.174573090687161e-23, -6.790318831977581e-26,
  1.164982847923981e-02, -1.701246689391907e-04,  2.079769113170501e-06, -2.130885655390857e-08,  1.950151337584971e-10, -1.640016245711499e-12,  1.289864601507459e-14,
 -9.601303940442179e-17,  6.821965690595967e-19, -4.656388112417303e-21,  3.068229147345601e-23, -1.959324096784351e-25,  6.700693040168645e-03, -1.252704770905796e-04,
  1.804591272548653e-06, -2.141334239899521e-08,  2.239711046036681e-10, -2.131912632644362e-12,  1.883802846360038e-14, -1.565969467391546e-16,  1.236360726997403e-18,
 -9.336902355010517e-21,  6.781628579177545e-23, -4.757776029495616e-25,  3.565960181174221e-03, -8.350138538032925e-05,  1.406824355196748e-06, -1.919659353593248e-08,
  2.279852085998046e-10, -2.441789026669434e-12,  2.410724745403507e-14, -2.226367017883183e-16,  1.943530498613935e-18, -1.616252662844442e-20,  1.288112960090994e-22,
 -9.884715364074978e-25,  1.756912165551854e-03, -5.057120702571457e-05,  9.900059336279223e-07, -1.543868658429390e-08,  2.070570746258215e-10, -2.482900677529861e-12,
  2.726281150315540e-14, -2.785083191787823e-16,  2.677181664684457e-18, -2.442008206677728e-20,  2.127468115603674e-22, -1.779213950407403e-24,  8.019629886414178e-04,
 -2.792320711454216e-05,  6.313732994635426e-07, -1.119128889395179e-08,  1.686985150863746e-10, -2.255294046971752e-12,  2.743351844754755e-14, -3.088653232529668e-16,
  3.257916221175332e-18, -3.248744477392297e-20,  3.084008552137466e-22, -2.802188662951527e-24,  3.394419166552646e-04, -1.410081563326664e-05,  3.661856846117400e-07,
 -7.341945516359339e-09,  1.238796731519229e-10, -1.839536218384464e-12,  2.470461367213565e-14, -3.055679012567248e-16,  3.526206858584600e-18, -3.833096380627427e-20,
  3.954076721702735e-22, -3.893119598046287e-24,  1.333619654703661e-04, -6.531441394312787e-06,  1.937681122370289e-07, -4.375343172178701e-09,  8.233059036389379e-11,
 -1.353527594756264e-12,  2.000934422224609e-14, -2.711441062736386e-16,  3.414251250540087e-18, -4.035766419617145e-20,  4.513207835173400e-22, -4.804141050643467e-24,
  4.869525401157009e-05, -2.782725594222393e-06,  9.383517479484188e-08, -2.376777097271309e-09,  4.971141688909153e-11, -9.021738770908838e-13,  1.464200440678515e-14,
 -2.168403322433719e-16,  2.972562769185274e-18, -3.812437897294146e-20,  4.612338734185183e-22, -5.297356358673016e-24,  1.654856756917422e-05, -1.093501501634430e-06,
  4.171262481392515e-08, -1.180848226033651e-09,  2.736935724599003e-11, -5.468621870287605e-13,  9.720691404507839e-15, -1.569840581114960e-16,  2.338036176035786e-18,
 -3.247298762555900e-20,  4.242261603945128e-22, -5.247742588504847e-24,  5.243229269404178e-06, -3.974339045891657e-07,  1.707336604378842e-08, -5.383621916071084e-10,
  1.378906613847518e-11, -3.026047684045708e-13,  5.878440642904534e-15, -1.033181680447416e-16,  1.668683963552071e-18, -2.505462977122353e-20,  3.528587484788855e-22,
 -4.693788866629540e-24,  1.551961879590811e-06, -1.339891522805563e-07,  6.455059762834003e-09, -2.259984094188828e-10,  6.380086332769191e-12, -1.534342713294582e-13,
  3.250944112098178e-15, -6.207125469887282e-17,  1.085319307147791e-18, -1.758842177556782e-20,  2.666401773330727e-22, -3.808656055937646e-24,  4.301715258219040e-07,
 -4.203252532329530e-08,  2.261891345335500e-09, -8.766537888186831e-11,  2.721133591314762e-12, -7.156342229987856e-14,  1.650717405783388e-15, -3.418128963481356e-17,
  6.460247697663797e-19, -1.128343318952037e-20,  1.838769489758435e-22, -2.816597903299940e-24,  1.119686066278975e-07, -1.231089086348886e-08,  7.372405644404782e-10,
 -3.154175550335160e-11,  1.073996762006657e-12, -3.082688597361194e-14,  7.727624932609203e-16, -1.732643712776502e-17,  3.534524646358116e-19, -6.644391149464179e-21,
  1.162441271203647e-22, -1.907162875571960e-24,  2.745810399776190e-08, -3.379255032418100e-09,  2.244081155434913e-10, -1.056962632056082e-11,  3.939213854972673e-13,
 -1.231682305962083e-14,  3.349840374409352e-16, -8.120447907273499e-18,  1.785505469009487e-19, -3.607921036969292e-21,  6.768222684293845e-23, -1.187974380715277e-24,
  6.368444004078148e-09, -8.730133479084476e-10,  6.407278605475937e-11, -3.313648062633163e-12,  1.348830245159962e-13, -4.585755642302842e-15,  1.350957615359108e-16,
 -3.535540760419806e-18,  8.367860900951378e-20, -1.815266495180202e-21,  3.647120636558178e-23, -6.840887991202412e-25,  1.403246859840439e-09, -2.132916141186446e-10,
  1.724475391223931e-11, -9.767859158018396e-13,  4.333493670200615e-14, -1.599084024303397e-15,  5.094646560033469e-17, -1.437344113988627e-18,  3.656980296436827e-20,
 -8.506375542223547e-22,  1.828285100574367e-23, -3.660641919886796e-25,  2.952870568330391e-10, -4.955105474569161e-11,  4.399506738771138e-12, -2.722521774807284e-13,
  1.313684266961785e-14, -5.251934056140979e-16,  1.806668294979802e-17, -5.486918636861320e-19,  1.498702364648899e-20, -3.733316787566406e-22,  8.573870621887131e-24,
 -1.830449483320164e-25,  5.970403721822805e-11, -1.101458814550698e-11,  1.070654328753612e-12, -7.220381201519631e-14,  3.781344150899314e-15, -1.634829975513358e-16,
  6.062298127596308e-18, -1.978997100049679e-19,  5.795112470119710e-21, -1.543986179188243e-22,  3.784290798950421e-24, -8.604639265792866e-26,  1.168066851925024e-11,
 -2.359484608659321e-12,  2.503203876245982e-13, -1.835085797945485e-14,  1.040811770499103e-15, -4.857049007566234e-17,  1.938216542594152e-18, -6.790342927632028e-20,
  2.128689172423442e-21, -6.057728355068081e-23,  1.582544596548441e-24, -3.827731622320565e-26,  2.229249721348388e-12, -4.910612846842756e-13,  5.668484340179714e-14,
 -4.505594368510365e-15,  2.761354385528130e-16, -1.388125819808842e-17,  5.950286912265079e-19, -2.233502441583635e-20,  7.484082941422932e-22, -2.271539486147110e-23,
  6.316442039252661e-25, -1.623009477858105e-26,  4.189040653379492e-13, -1.002187523977283e-13,  1.254731980993562e-14, -1.078418310682880e-15,  7.124900238678127e-17,
 -3.850021039355395e-18,  1.769304268760743e-19, -7.102711267343343e-21,  2.539641601418512e-22, -8.208123748371196e-24,  2.425725481833532e-25, -6.611780658667664e-27,
  7.833068733779167e-14, -2.026821905081861e-14,  2.743141158740853e-15, -2.542089400216713e-16,  1.805898318106869e-17, -1.046514352237158e-18,  5.144975609226963e-20,
 -2.204495283883721e-21,  8.395291504237713e-23, -2.884173915415023e-24,  9.043247517425287e-26, -2.610456357495664e-27,  1.475018528416280e-14, -4.110171978193609e-15,
  5.992387762427324e-16, -5.969113965524199e-17,  4.546867677100356e-18, -2.818501836503888e-19,  1.478832810843398e-20, -6.748014876753101e-22,  2.731240722055163e-23,
 -9.953654862924267e-25,  3.304841025392535e-26, -1.008432867356840e-27,  2.834633680303929e-15, -8.468053222109555e-16,  1.324948561942968e-16, -1.413897023794931e-17,
  1.151288669239227e-18, -7.612080482444016e-20,  4.251112257215171e-21, -2.060582798513358e-22,  8.842689741608886e-24, -3.410693199877520e-25,  1.196502996365386e-26,
 -3.851099819572632e-28,  5.641416038527400e-16, -1.798208413497244e-16,  3.007216904041452e-17, -3.425217205241263e-18,  2.971198205526185e-19, -2.088670094788674e-20,
  1.237798950703798e-21, -6.354999356749758e-23,  2.883520877963992e-24, -1.174000138858443e-25,  4.340460165944864e-27, -1.469975587078632e-28,  1.181183888579615e-16,
 -3.997194794406967e-17,  7.113174771208218e-18, -8.612218979593091e-19,  7.928138402542031e-20, -5.904121106922627e-21,  3.700157989454043e-22, -2.005550609876768e-23,
  9.591412430588489e-25, -4.109545046963724e-26,  1.596551388153423e-27, -5.673163171519574e-29,  2.645156364486640e-17, -9.452856467515089e-18,  1.781336823922100e-18,
 -2.282191469718621e-19,  2.220002761041469e-20, -1.744237241676529e-21,  1.151476727120103e-22, -6.564245096402464e-24,  3.296889806364030e-25, -1.481378379942324e-26,
  6.027131747600785e-28, -2.239750882692847e-29,  6.441337285703608e-18, -2.417186049999431e-18,  4.797966548923833e-19, -6.471792566920327e-20,  6.620311941611809e-21,
 -5.462528718276777e-22,  3.781828556485040e-23, -2.257837116724301e-24,  1.186021044213309e-25, -5.566380371821235e-27,  2.362631404280484e-28, -9.147554538987565e-30,
  1.732166324413785e-18, -6.785059034269588e-19,  1.410389309103957e-19, -1.991769793295151e-20,  2.131131363447585e-21, -1.837130774763990e-22,  1.327204643734670e-23,
 -8.258380560768132e-25,  4.515942316131119e-26, -2.203865355459894e-27,  9.715905753252536e-29, -3.902708107916536e-30,  5.207414150311389e-19, -2.115866005844093e-19,
  4.576840438170093e-20, -6.725539402030100e-21,  7.482204788533853e-22, -6.699973198647722e-23,  5.022742058735501e-24, -3.239823213187147e-25,  1.834671809069369e-26,
 -9.262959018961670e-28,  4.220719470566936e-29, -1.750533498030353e-30,  1.759430653995230e-19, -7.366949156935285e-20,  1.647013315814956e-20, -2.501549801543470e-21,
  2.874815936872850e-22, -2.657157081044991e-23,  2.054412526229552e-24, -1.365539274723849e-25,  7.961857616216043e-27, -4.135457670218482e-28,  1.937011945278141e-29,
 -8.251295208144046e-31,  6.611977669586161e-20, -2.833583375109288e-20,  6.500103323128021e-21, -1.013097595286743e-21,  1.194230714446850e-22, -1.131560926621898e-23,
  8.963002501118002e-25, -6.099463817966622e-26,  3.638659235546698e-27, -1.932471195823083e-28,  9.249406638279571e-30, -4.023536199789996e-31,  2.621447452714938e-20,
 -1.141794660752597e-20,  2.667006586130691e-21, -4.233055980520217e-22,  5.080059474649301e-23, -4.898489412431060e-24,  3.946832905636488e-25, -2.730862267148080e-26,
  1.655635346122787e-27, -8.932166331500337e-29,  4.340979681040712e-30, -1.916497358829376e-31,  8.623582980953767e-21, -3.790264292751404e-21,  8.943595830941406e-22,
 -1.434105423515893e-22,  1.738479882753815e-23, -1.692936132023573e-24,  1.377201028415958e-25, -9.618510900120829e-27,  5.884659757922847e-28, -3.202969474245547e-29,
  1.570059413138818e-30, -6.989628062284468e-32,  6.097329585002901e-02, -1.535686228801516e-04,  4.003232363386228e-07, -1.074431132705756e-09,  2.949020072398934e-12,
 -8.228331723391787e-15,  2.319896279354917e-17, -6.586835491928263e-20,  1.875003404288227e-22, -5.350168054412489e-25,  1.523374507250874e-27, -4.344436318600404e-30,
  5.618931264504273e-02, -1.719254100973737e-04,  6.292061750172166e-07, -2.422512017303402e-09,  9.297669818886372e-12, -3.506846610749583e-14,  1.297889606971098e-16,
 -4.722589310145285e-19,  1.692959163933168e-21, -5.991452332525687e-24,  2.096112411795892e-26, -7.259667724187401e-29,  4.772021633317127e-02, -1.977653622194874e-04,
  1.018789033814091e-06, -5.105205541874559e-09,  2.435065748917722e-11, -1.115820501448454e-13,  4.953434785688268e-16, -2.142406642355343e-18,  9.062905189364979e-21,
 -3.760544312770316e-23,  1.533956025384334e-25, -6.162057561125521e-28,  3.735318062506134e-02, -2.157771331653870e-04,  1.449679284005228e-06, -8.873334427875256e-09,
  5.059416388872036e-11, -2.739301092010802e-13,  1.423684509350223e-15, -7.152398947038391e-18,  3.490827164555169e-20, -1.661459008491763e-22,  7.734406636417202e-25,
 -3.529920445317930e-27,  2.695217435472120e-02, -2.146401674372444e-04,  1.787249448697770e-06, -1.304048378331609e-08,  8.740706031040263e-11, -5.503433418957370e-13,
  3.296593520589008e-15, -1.894805109806187e-17,  1.051563927120273e-19, -5.661330073060041e-22,  2.967571390513983e-24, -1.518932487008686e-26,  1.793041768495359e-02,
 -1.921158509893068e-04,  1.928982698482275e-06, -1.656337294529849e-08,  1.289502997706548e-10, -9.330325590779429e-13,  6.368953356649896e-15, -4.143528120784848e-17,
  2.588213244856408e-19, -1.560826550600762e-21,  9.126249838922244e-24, -5.191317687396278e-26,  1.100105836774249e-02, -1.544586849437520e-04,  1.841753965701977e-06,
 -1.843506874550361e-08,  1.651048474767362e-10, -1.360389120666679e-12,  1.049230051046123e-14, -7.664384926111951e-17,  5.347270997698167e-19, -3.585613917434475e-21,
  2.322099139301254e-23, -1.457950053876512e-25,  6.226939103084263e-03, -1.118037552043181e-04,  1.567801011197274e-06, -1.814776012915680e-08,  1.855206690997774e-10,
 -1.728238673781351e-12,  1.496018046235961e-14, -1.219262841903798e-16,  9.444033968292544e-19, -7.000928973902411e-21,  4.993867197493541e-23, -3.442247436867507e-25,
  3.253087786228882e-03, -7.310973236653822e-05,  1.196836559841169e-06, -1.591008020715207e-08,  1.844643896891286e-10, -1.931497288233939e-12,  1.866327573362975e-14,
 -1.688381711425285e-16,  1.444817292767802e-18, -1.178542485060775e-20,  9.217972893598754e-23, -6.945368462121005e-25,  1.569368902090540e-03, -4.333945251743841e-05,
  8.230887705645477e-07, -1.248997388003512e-08,  1.633572653561118e-10, -1.913248477071378e-12,  2.054267327225572e-14, -2.054038700104215e-16,  1.934071726213425e-18,
 -1.729241280411383e-20,  1.477530353672591e-22, -1.212519295093732e-24,  6.995821315813097e-04, -2.336672600287557e-05,  5.118927227040418e-07, -8.819927891766187e-09,
  1.295327619823014e-10, -1.689888880219232e-12,  2.008468668665225e-14, -2.211658631352086e-16,  2.283588984552726e-18, -2.230657580130034e-20,  2.075591737548289e-22,
 -1.849574751591886e-24,  2.883837676648844e-04, -1.149264863191624e-05,  2.888576156301146e-07, -5.624676649800426e-09,  9.238588748607365e-11, -1.337719204198041e-12,
  1.754097096702440e-14, -2.120617239431273e-16,  2.394009209272034e-18, -2.547769692755018e-20,  2.574746520111136e-22, -2.484968175511623e-24,  1.100330650071053e-04,
 -5.170818860323131e-06,  1.483523686045105e-07, -3.250901176738168e-09,  5.950585782415343e-11, -9.532892339601303e-13,  1.375111263930367e-14, -1.820253716625421e-16,
  2.241074838198743e-18, -2.592157468101355e-20,  2.838551836909992e-22, -2.960549224518296e-24,  3.890250523577013e-05, -2.133864764534815e-06,  6.954735071202533e-08,
 -1.708535085495352e-09,  3.474082603147559e-11, -6.140266470681969e-13,  9.718822395244118e-15, -1.405283527791180e-16,  1.882707591788118e-18, -2.361793728704511e-20,
  2.796807558526352e-22, -3.146185491314028e-24,  1.276172839105665e-05, -8.097924763398550e-07,  2.984629021291064e-08, -8.191158299400145e-10,  1.844854208089555e-11,
 -3.588312801477526e-13,  6.217803335946918e-15, -9.800057204399270e-17,  1.425891090188612e-18, -1.936379171670782e-20,  2.475281883299070e-22, -2.998136197321427e-24,
  3.890497827745894e-06, -2.833523692354644e-07,  1.175943379365004e-08, -3.593732314355442e-10,  8.941443640084168e-12, -1.909483121423525e-13,  3.614813095449997e-15,
 -6.198647319484464e-17,  9.777506865116403e-19, -1.435012787136898e-20,  1.977049385306475e-22, -2.574488012704976e-24,  1.104284248616075e-06, -9.166956339950999e-08,
  4.266572872201711e-09, -1.447544216929551e-10,  3.968893661892669e-12, -9.286188575695373e-14,  1.916955079072426e-15, -3.570229446250414e-17,  6.095492378636252e-19,
 -9.654061613582430e-21,  1.431471452953050e-22, -2.001299540150532e-24,  2.924864513244801e-07, -2.750143608242567e-08,  1.430078876408660e-09, -5.371258372329982e-11,
  1.619161540405921e-12, -4.142509561752494e-14,  9.308637589591817e-16, -1.879999315939205e-17,  3.469115162555364e-19, -5.921081240209211e-21,  9.436780249882129e-23,
 -1.414728560747059e-24,  7.248170554597521e-08, -7.675887994924586e-09,  4.443606522855664e-10, -1.842692516835574e-11,  6.093980840412638e-13, -1.701676694199315e-14,
  4.155667072951483e-16, -9.087854261489602e-18,  1.810021183017112e-19, -3.325057962158666e-21,  5.689253722177924e-23, -9.135469300638956e-25,  1.685806248380614e-08,
 -2.000410598316299e-09,  1.284886366294143e-10, -5.867819313001485e-12,  2.124520774431045e-13, -6.463627042356773e-15,  1.712816328696976e-16, -4.050207853329640e-18,
  8.695767307856883e-20, -1.717284167402174e-21,  3.150989640268197e-23, -5.413607106768247e-25,  3.693584643630897e-09, -4.887712085128597e-10,  3.472145565302564e-11,
 -1.741975146317482e-12,  6.891229609765209e-14, -2.280423627228769e-15,  6.547499464801887e-17, -1.671892178203106e-18,  3.864708796201579e-20, -8.195531164375492e-22,
  1.610896049503714e-23, -2.958217828897595e-25,  7.656678404896102e-10, -1.124905881774493e-10,  8.810916790047742e-12, -4.844689809921534e-13,  2.089999980571096e-14,
 -7.510143904438102e-16,  2.332927723901549e-17, -6.424398535690955e-19,  1.596980304297785e-20, -3.632486130572022e-22,  7.640594739995760e-24, -1.498239543603848e-25,
  1.509411672397956e-10, -2.451757978227913e-11,  2.111072603442382e-12, -1.269217934082454e-13,  5.959434432077920e-15, -2.321522455189823e-16,  7.790894400117800e-18,
 -2.310726552642868e-19,  6.169555787001478e-21, -1.503554503357150e-22,  3.380812503636033e-24, -7.071861869331565e-26,  2.846795973422982e-11, -5.091768302480737e-12,
  4.805604896832754e-13, -3.151815058683615e-14,  1.607590580785274e-15, -6.777686603702119e-17,  2.453652298333653e-18, -7.827487217583447e-20,  2.241979987619798e-21,
 -5.847372852385139e-23,  1.404020980356837e-24, -3.129668642210612e-26,  5.172876865682536e-12, -1.014793519791567e-12,  1.046768455729798e-13, -7.471755224610406e-15,
  4.131614557087523e-16, -1.881963245262625e-17,  7.338178037105412e-19, -2.514407971556221e-20,  7.715903319176876e-22, -2.151070464970983e-23,  5.509131051332585e-25,
 -1.307212981587654e-26,  9.130191901302922e-13, -1.956876012669287e-13,  2.199659256902967e-14, -1.704656141899188e-15,  1.019800286712991e-16, -5.009530898297090e-18,
  2.100412430675632e-19, -7.718557004001332e-21,  2.534092426731350e-22, -7.541550945726509e-24,  2.057627736032654e-25, -5.191022372757717e-27,  1.580171057946596e-13,
 -3.685662710721392e-14,  4.501073035755248e-15, -3.777521524717496e-16,  2.439540972987434e-17, -1.289808574627133e-18,  5.804781952625587e-20, -2.283941587150464e-21,
  8.010107618685245e-23, -2.541074669999708e-24,  7.375700510338721e-26, -1.975775906124700e-27,  2.710980748894390e-14, -6.853530222620521e-15,  9.064659228398837e-16,
 -8.216359898025355e-17,  5.714341377902386e-18, -3.244749560829677e-19,  1.564352504213579e-20, -6.578120253772953e-22,  2.460207762544602e-23, -8.305797471038471e-25,
  2.560763909815910e-26, -7.272770773679970e-28,  4.668029724686013e-15, -1.273730846670614e-15,  1.818412623891526e-16, -1.774954524494460e-17,  1.325924597027597e-18,
 -8.066560051056596e-20,  4.156881590255559e-21, -1.864221154606960e-22,  7.420425386034871e-24, -2.661064088130452e-25,  8.698961034954990e-27, -2.614823010220392e-28,
  8.180974924263291e-16, -2.398783239816358e-16,  3.683059939212217e-17, -3.858998361523295e-18,  3.087307104347621e-19, -2.006910687898954e-20,  1.102639386293266e-21,
 -5.261246448946871e-23,  2.223802612701726e-24, -8.452759753765754e-26,  2.923685855918068e-27, -9.282744053958242e-29,  1.482194640810578e-16, -4.648377921497896e-17,
  7.645444480441382e-18, -8.568179348705042e-19,  7.317055466306194e-20, -5.066708836608741e-21,  2.959353457604665e-22, -1.498237303869808e-23,  6.706903421519327e-25,
 -2.695283905872846e-26,  9.840153914121052e-28, -3.292281058626320e-29,  2.823698697582576e-17, -9.424438123262982e-18,  1.653280519072369e-18, -1.973856040180347e-19,
  1.792603665541067e-20, -1.317608353497113e-21,  8.154007919155914e-23, -4.366144407821111e-24,  2.063694010621118e-25, -8.742388884184561e-27,  3.359381608537031e-28,
 -1.181159022613788e-29,  5.759607364218388e-18, -2.034922636159472e-18,  3.789071516922974e-19, -4.797687827640333e-20,  4.614019026596702e-21, -3.585446069973999e-22,
  2.341908288708780e-23, -1.321407797679269e-24,  6.571243654855959e-26, -2.924468346925554e-27,  1.178878952568074e-28, -4.341871705099121e-30,  1.281286359968888e-18,
 -4.764660912714640e-19,  9.366736007341989e-20, -1.251473447807589e-20,  1.268400725225761e-21, -1.037246115755463e-22,  7.119190204263213e-24, -4.214924815586966e-25,
  2.196248146726101e-26, -1.022755858358388e-27,  4.308422902477363e-29, -1.656020809674332e-30,  3.164067244040597e-19, -1.230856080302582e-19,  2.539615979171672e-20,
 -3.560204194370116e-21,  3.782118129314225e-22, -3.237799180893042e-23,  2.323438417190970e-24, -1.436378105818161e-25,  7.805436983889903e-27, -3.786166834486590e-28,
  1.659400133334162e-29, -6.627909375898158e-31,  8.802353275648858e-20, -3.558910412121695e-20,  7.657065278842670e-21, -1.119194346259270e-21,  1.238639988503002e-22,
 -1.103551314041030e-23,  8.232542401454051e-25, -5.285150676777081e-26,  2.979237237668474e-27, -1.497519774064728e-28,  6.794359501994668e-30, -2.806317922389494e-31,
  2.780576706748814e-20, -1.160481382818346e-20,  2.585226423195249e-21, -3.912601515846143e-22,  4.480798193943252e-23, -4.127566180485181e-24,  3.180833937896091e-25,
 -2.107556575188662e-26,  1.225054727261680e-27, -6.344154649013924e-29,  2.963010487613001e-30, -1.258684975124563e-31,  9.895825450027681e-21, -4.232871021912886e-21,
  9.689693831711474e-22, -1.507061764508322e-22,  1.772866171681330e-23, -1.676475600116888e-24,  1.325347481137049e-25, -9.002237897675554e-27,  5.360534431567753e-28,
 -2.841922755348760e-29,  1.357905501747550e-30, -5.897189946301673e-32,  3.772051373280333e-21, -1.641446502003559e-21,  3.830178162487275e-22, -6.072992435703899e-23,
  7.280792616606620e-24, -7.013639783464588e-25,  5.645634054866878e-26, -3.902635659048216e-27,  2.363897151981430e-28, -1.274199947279753e-29,  6.187231181431287e-31,
 -2.729331246402685e-32,  1.213277141983766e-21, -5.330711048573255e-22,  1.257335227351745e-22, -2.015305113665550e-23,  2.442034020141585e-24, -2.377101475608262e-25,
  1.933004547643244e-26, -1.349507277125653e-27,  8.253232957946068e-29, -4.490496730548869e-30,  2.200391391074488e-31, -9.792283800556332e-33,  6.036534598970171e-02,
 -1.504168198639398e-04,  3.877078342820926e-07, -1.028533708268211e-09,  2.789875229560142e-12, -7.693027767773606e-15,  2.143583522834392e-17, -6.016511700404177e-20,
  1.692920337627460e-22, -4.777372901657732e-25,  1.344601936807112e-27, -3.794942563341476e-30,  5.551149769392661e-02, -1.670055645342545e-04,  6.010059981284016e-07,
 -2.279195398238301e-09,  8.626409576922421e-12, -3.210628197639005e-14,  1.172928491145094e-16, -4.213795380869673e-19,  1.491619987816311e-21, -5.213525384174598e-24,
  1.801501858900187e-26, -6.163504357211289e-29,  4.694507664542084e-02, -1.898536419432323e-04,  9.597926242652147e-07, -4.732822043904126e-09,  2.223320415228116e-11,
 -1.003820936709745e-13,  4.392208990188336e-16, -1.872921237077210e-18,  7.813321229186436e-21, -3.197909140663108e-23,  1.286940710028195e-25, -5.101250034732220e-28,
  3.651261148152243e-02, -2.045922619746834e-04,  1.347881349643704e-06, -8.105866027113464e-09,  4.544165401334794e-11, -2.420439791968590e-13,  1.238197937043193e-15,
 -6.125354264214224e-18,  2.944840897540211e-20, -1.381033990826404e-22,  6.336266830295834e-25, -2.850755350682049e-27,  2.612125109492837e-02, -2.009451498105864e-04,
  1.638804942374206e-06, -1.172590077287428e-08,  7.715028986920761e-11, -4.772294410504873e-13,  2.810250309886710e-15, -1.588747515030480e-17,  8.676048673384161e-20,
 -4.597875933849711e-22,  2.373165753629923e-24, -1.196389993026221e-26,  1.719160690060649e-02, -1.774453229652500e-04,  1.742011514202820e-06, -1.464152651027001e-08,
  1.117288475397365e-10, -7.932135418099623e-13,  5.316747821804425e-15, -3.398581597873599e-17,  2.086869984197756e-19, -1.237664286449121e-21,  7.119565229138048e-24,
 -3.985589243392509e-26,  1.041135140795481e-02, -1.405666103864297e-04,  1.635527755643096e-06, -1.599806781447599e-08,  1.402508981646505e-10, -1.132505828618789e-12,
  8.567634069413400e-15, -6.143046322279205e-17,  4.209257339713304e-19, -2.773420876076897e-21,  1.765612815282462e-23, -1.090138107091567e-25,  5.803497598136892e-03,
 -1.000844836822353e-04,  1.366757398266919e-06, -1.543754168781624e-08,  1.542865188455245e-10, -1.406966406147454e-12,  1.193403432639173e-14, -9.538017250903499e-17,
  7.249522691776122e-19, -5.276387516425199e-21,  3.697030835249704e-23, -2.504233878579682e-25,  2.978656229108873e-03, -6.425133479928898e-05,  1.022424048209305e-06,
 -1.324487075407092e-08,  1.499561304010778e-10, -1.535451829713199e-12,  1.452404963892049e-14, -1.287365493738505e-16,  1.080151460169714e-18, -8.644101896775783e-21,
  6.636516914820030e-23, -4.910558532670131e-25,  1.408290377348755e-03, -3.731257124475326e-05,  6.877103543552034e-07, -1.015742635230721e-08,  1.295905250395932e-10,
 -1.482783291194105e-12,  1.557180800499488e-14, -1.524301201809734e-16,  1.406209846158415e-18, -1.232632701425588e-20,  1.033147431323917e-22, -8.321105942678919e-25,
  6.136817529362385e-04, -1.966211620360927e-05,  4.174528292109941e-07, -6.993561397125709e-09,  1.000934286328134e-10, -1.274599097786838e-12,  1.480493108606049e-14,
 -1.594839626875037e-16,  1.612254332530401e-18, -1.543019056948994e-20,  1.407566659151260e-22, -1.230334527458863e-24,  2.466403906408779e-04, -9.428537376776329e-06,
  2.294165758352781e-07, -4.339537375000965e-09,  6.940176609971243e-11, -9.801132858770505e-13,  1.255089550684189e-14, -1.483367499504397e-16,  1.638543572320627e-18,
 -1.707509399198614e-20,  1.690795749006071e-22, -1.599862174676936e-24,  9.149743575623518e-05, -4.125198122103353e-06,  1.144786241300349e-07, -2.434999684781542e-09,
  4.336599512555736e-11, -6.771091151848796e-13,  9.532377904481985e-15, -1.232822588977253e-16,  1.484325191617512e-18, -1.680273733311825e-20,  1.802020969129108e-22,
 -1.841812365640733e-24,  3.136216126478601e-05, -1.650903298159464e-06,  5.201246260465199e-08, -1.239477489813040e-09,  2.450620336044376e-11, -4.218992117614421e-13,
  6.513616335848294e-15, -9.197115914900190e-17,  1.204381677621322e-18, -1.477996258050733e-20,  1.713389438375450e-22, -1.888072483043914e-24,  9.944272594127175e-06,
 -6.058187392314991e-07,  2.157505302621213e-08, -5.740919740922655e-10,  1.256606741611248e-11, -2.379578562415846e-13,  4.020051247579988e-15, -6.184614200728616e-17,
  8.791980640935832e-19, -1.167551222632064e-20,  1.460559119142380e-22, -1.732387044111760e-24,  2.921013069316880e-06, -2.043570491618585e-07,  8.193105084935664e-09,
 -2.426802673493647e-10,  5.865876218809761e-12, -1.219125086666519e-13,  2.249280608896667e-15, -3.763509573735288e-17,  5.798277556889333e-19, -8.319170573117173e-21,
  1.121317660616973e-22, -1.429515557246928e-24,  7.962263613716918e-07, -6.353210277635274e-08,  2.856500497355332e-09, -9.391430238509533e-11,  2.500912154376099e-12,
 -5.693231277331760e-14,  1.145102481062197e-15, -2.080448859031235e-17,  3.468494651441481e-19, -5.369075370366908e-21,  7.787005179454019e-23, -1.065629651290274e-24,
  2.018275052232920e-07, -1.825448196231828e-08,  9.171190581901919e-10, -3.337886392744437e-11,  9.771618154671682e-13, -2.432037285501494e-14,  5.323994924720464e-16,
 -1.048749918715472e-17,  1.889477451516389e-19, -3.151543457117879e-21,  4.912380600807155e-23, -7.207780740548975e-25,  4.769134782014629e-08, -4.862469903078497e-09,
  2.720532000318566e-10, -1.093335706360026e-11,  3.511522086596042e-13, -9.538834110967156e-15,  2.269281240793411e-16, -4.840084071855277e-18,  9.411637974220399e-20,
 -1.689519935956099e-21,  2.827168929018406e-23, -4.443022184146319e-25,  1.053653165377108e-08, -1.204914238871361e-09,  7.483452828618312e-11, -3.312970502112160e-12,
  1.165122359010300e-13, -3.448755939478763e-15,  8.903579472791055e-17, -2.053555677303928e-18,  4.304823128442315e-20, -8.308060664341851e-22,  1.490957507303340e-23,
 -2.507188947699556e-25,  2.184158615646863e-09, -2.788516664439324e-10,  1.916670185636131e-11, -9.325789771848712e-13,  3.584689411330352e-14, -1.154406116739359e-15,
  3.229843705518623e-17, -8.045894991306316e-19,  1.816266681154834e-20, -3.764654875648183e-22,  7.238524269107918e-24, -1.301273995212349e-25,  4.265974868955438e-10,
 -6.054348654691277e-11,  4.592051969743899e-12, -2.450233165894186e-13,  1.027561803561953e-14, -3.594799807613727e-16,  1.088544311953457e-17, -2.925356965096254e-19,
  7.103542057906022e-21, -1.579758689059108e-22,  3.251402189076702e-24, -6.243116032463990e-26,  7.889667994521582e-11, -1.239663458411137e-11,  1.034637258598869e-12,
 -6.041027606900827e-14,  2.759173482046610e-15, -1.047019849161853e-16,  3.426940568120183e-18, -9.923642408330684e-20,  2.589375173831113e-21, -6.172376429501295e-23,
  1.358580811421289e-24, -2.783846336251196e-26,  1.389825509120758e-11, -2.408307879044854e-12,  2.205703234759094e-13, -1.406233326110952e-14,  6.982693011776007e-16,
 -2.869789169538318e-17,  1.013921313921033e-18, -3.159964987640871e-20,  8.850350795653032e-22, -2.259022503655409e-23,  5.312446908959796e-25, -1.160620732313457e-26,
  2.348210709950602e-12, -4.470443752341155e-13,  4.480740533137418e-14, -3.112454658555132e-15,  1.677170165935990e-16, -7.453749482198137e-18,  2.838767300679459e-19,
 -9.509949668412065e-21,  2.855699788812825e-22, -7.796717610426332e-24,  1.956999012906140e-25, -4.554129470457590e-27,  3.836467386869966e-13, -7.994232773891870e-14,
  8.744604234730048e-15, -6.603333880487211e-16,  3.854083031824492e-17, -1.849137874863228e-18,  7.580226422052837e-20, -2.725941974492737e-21,  8.765320176826735e-23,
 -2.556832643716371e-24,  6.842423152991007e-26, -1.694290085467295e-27,  6.119093312255509e-14, -1.390333620003163e-14,  1.655047244775175e-15, -1.355442242034693e-16,
  8.551489424985556e-18, -4.421416279932788e-19,  1.947731500712039e-20, -7.507664854706243e-22,  2.581511078331921e-23, -8.034912575071451e-25,  2.289729008027965e-26,
 -6.025769117626501e-28,  9.634316184109143e-15, -2.377661518590207e-15,  3.070938720637330e-16, -2.720782591158119e-17,  1.851389519196180e-18, -1.029504242664385e-19,
  4.864802627634329e-21, -2.006576770459936e-22,  7.366530221309962e-24, -2.442871204295448e-25,  7.402650356844103e-27, -2.067650731442436e-28,  1.516665364583759e-15,
 -4.049046693695784e-16,  5.656072475547653e-17, -5.406224712020431e-18,  3.958004921294806e-19, -2.361833886832453e-20,  1.194711004713123e-21, -5.263017720437877e-23,
  2.059183073027572e-24, -7.263021745271966e-26,  2.336548581303093e-27, -6.915730572204915e-29,  2.422361497250486e-16, -6.965783515311624e-17,  1.048728717599521e-17,
 -1.078133732400167e-18,  8.469023811473790e-20, -5.409344633847450e-21,  2.922170063249489e-22, -1.371799779204502e-23,  5.708025287599234e-25, -2.137061939478179e-26,
  7.284585114728462e-28, -2.280491229181238e-29,  3.990409961471477e-17, -1.230327548959593e-17,  1.988751808340165e-18, -2.191445638873967e-19,  1.841206586872390e-20,
 -1.255102218844705e-21,  7.220883916874755e-23, -3.602922464208581e-24,  1.590391573005781e-25, -6.305334840669385e-27,  2.272107747060940e-28, -7.506664589844924e-30,
  6.904558491632430e-18, -2.271229108928746e-18,  3.924956398748217e-19, -4.617821396838951e-20,  4.134757487852402e-21, -2.997890243965985e-22,  1.830959612263706e-23,
 -9.680315714121693e-25,  4.519765216234584e-26, -1.892191177458590e-27,  7.188429167586394e-29, -2.499757579532908e-30,  1.279763538593020e-18, -4.467359770520166e-19,
  8.214190451691684e-20, -1.027298185339268e-20,  9.762074929285532e-22, -7.498634098021021e-23,  4.843526498857187e-24, -2.703660914857096e-25,  1.330607158980008e-26,
 -5.862620807295542e-28,  2.340479337517303e-29, -8.539891998124451e-31,  2.593430744691069e-19, -9.551605847964630e-20,  1.858679239883697e-20, -2.458528981536669e-21,
  2.467589466479483e-22, -1.998941584253953e-23,  1.359536558381583e-24, -7.978639838341662e-26,  4.122216984524118e-27, -1.903960459396417e-28,  7.957217987349779e-30,
 -3.035204454593817e-31,  5.862220754593954e-20, -2.263766287820735e-20,  4.634178387361949e-21, -6.446102307663698e-22,  6.796182416617719e-23, -5.775521690845760e-24,
  4.115190306882122e-25, -2.526675025625040e-26,  1.363957548743460e-27, -6.573909676609523e-29,  2.863444704628424e-30, -1.136902999578296e-31,  1.504046440829216e-20,
 -6.049087754986415e-21,  1.294059052559270e-21, -1.880761724088302e-22,  2.070001070354607e-23, -1.834373512154633e-24,  1.361364130039852e-25, -8.695960446411816e-27,
  4.878181878500391e-28, -2.440554934304501e-29,  1.102288843376109e-30, -4.532986813748027e-32,  4.427341522394229e-21, -1.841357461701246e-21,  4.086457426416893e-22,
 -6.161242139109557e-23,  7.029907168539674e-24, -6.452472640260962e-25,  4.955185200200713e-26, -3.272154336617361e-27,  1.895804532322137e-28, -9.786824631349732e-30,
  4.556968753085428e-31, -1.930106586633201e-32,  1.487783611548590e-21, -6.351043851034450e-22,  1.450608119116543e-22, -2.251132356194770e-23,  2.642382532486286e-24,
 -2.493403130638336e-25,  1.967107552229211e-26, -1.333459149770428e-27,  7.924932582885852e-29, -4.193577455029483e-30,  2.000104424395535e-31, -8.670936248743398e-33,
  5.439929826151818e-22, -2.364934000649484e-22,  5.512381095899031e-23, -8.730695650363265e-24,  1.045583427387165e-24, -1.006163656583588e-25,  8.090871163976282e-27,
 -5.587408885733356e-28,  3.381141092000169e-29, -1.820818644855067e-30,  8.833475921804621e-32, -3.893231433461398e-33,  1.708529300891120e-22, -7.503832962384683e-23,
  1.769146211216436e-23, -2.834429187177900e-24,  3.433130865620203e-25, -3.340436697529505e-26,  2.715243685029049e-27, -1.894852010144856e-28,  1.158382680461073e-29,
 -6.300194373701205e-31,  3.085991861487477e-32, -1.372834433207202e-33,  5.976980492315324e-02, -1.473637794762149e-04,  3.756282694126137e-07, -9.850991986673411e-10,
  2.641025917794163e-12, -7.198186569869414e-15,  1.982454142753355e-17, -5.501288612302811e-20,  1.530226899135002e-22, -4.271480521779090e-25,  1.188314499636599e-27,
 -3.320465668867304e-30,  5.485292156233759e-02, -1.623046193723109e-04,  5.744630832357414e-07, -2.146160816916057e-09,  8.011505689558501e-12, -2.942761200314253e-14,
  1.061352138718003e-16, -3.765167462975046e-19,  1.316276247785644e-21, -4.544338039973515e-24,  1.551134233417247e-26, -5.243210175974100e-29,  4.620066740612733e-02,
 -1.823965779218951e-04,  9.050687029003971e-07, -4.392596503592184e-09,  2.032686913651648e-11, -9.044286994930126e-14,  3.901132385269723e-16, -1.640363670117462e-18,
  6.749570680164500e-21, -2.725343300115449e-23,  1.082204523246272e-25, -4.233476019414053e-28,  3.571520946680902e-02, -1.941862903157062e-04,  1.254818682379563e-06,
 -7.415968444200307e-09,  4.088458108648023e-11, -2.142832871633875e-13,  1.079166993665640e-15, -5.257896233597221e-18,  2.490421717576582e-20, -1.150986863604674e-22,
  5.205504667734310e-25, -2.309125442762674e-27,  2.534282890475071e-02, -1.883772709387991e-04,  1.505197059900899e-06, -1.056433407323895e-08,  6.824568711309875e-11,
 -4.148225633097428e-13,  2.401906224887621e-15, -1.335863822301365e-17,  7.179716823274109e-20, -3.746053997891005e-22,  1.904186168941635e-24, -9.456611125393701e-27,
  1.650862640608080e-02, -1.641827960716262e-04,  1.576537249978651e-06, -1.297415655439453e-08,  9.706724848153768e-11, -6.763155023369019e-13,  4.452311372105492e-15,
 -2.796901819462433e-17,  1.688610269191897e-19, -9.850830355896171e-22,  5.575918605201983e-24, -3.072462871004731e-26,  9.874089232170067e-03, -1.282137989721379e-04,
  1.456302229438480e-06, -1.392464075126756e-08,  1.195251812816393e-10, -9.460887834805953e-13,  7.022066126584736e-15, -4.943088132423741e-17,  3.327182565512338e-19,
 -2.154526446806624e-21,  1.348579484149720e-23, -8.189668177079903e-26,  5.423911077157075e-03, -8.985150237180247e-05,  1.195437843148524e-06, -1.317937303888112e-08,
  1.288078753589796e-10, -1.150141711619038e-12,  9.561528825815158e-15, -7.495572584679790e-17,  5.591635066469346e-19, -3.996526497777092e-21,  2.751173685077157e-23,
 -1.831627414698703e-25,  2.737057718521427e-03, -5.666912479284452e-05,  8.769261518337034e-07, -1.107346441178963e-08,  1.224599204215690e-10, -1.226494505555715e-12,
  1.135997403103811e-14, -9.867783302778828e-17,  8.119602646997828e-19, -6.376179306543537e-21,  4.806122476646221e-23, -3.492985321978374e-25,  1.269318442720351e-03,
 -3.226532500858820e-05,  5.773453111673376e-07, -8.302282277447319e-09,  1.033510193581738e-10, -1.155574749363285e-12,  1.187233357591033e-14, -1.138002772893255e-16,
  1.028794445163973e-18, -8.842986749886937e-21,  7.272066419025718e-23, -5.749393535064588e-25,  5.412170535919380e-04, -1.663277820123192e-05,  3.423564526005162e-07,
 -5.578116376611724e-09,  7.782100574372363e-11, -9.675143406101618e-13,  1.098533622578242e-14, -1.157907117484597e-16,  1.146289942316110e-18, -1.075074002995298e-20,
  9.616217898106753e-23, -8.246296020190430e-25,  2.122919135197314e-04, -7.784015326715105e-06,  1.834072201696408e-07, -3.370873285580591e-09,  5.250365800485615e-11,
 -7.233324826310251e-13,  9.047688715052183e-15, -1.045596257838846e-16,  1.130320684035140e-18, -1.153602931262838e-20,  1.119472247115909e-22, -1.038679678161367e-24,
  7.665863195756151e-05, -3.315407468887634e-06,  8.901214714031309e-08, -1.838134782251870e-09,  3.185751588368075e-11, -4.849004149243372e-13,  6.663585833103007e-15,
 -8.421554404326138e-17,  9.917467755452990e-19, -1.098930563238737e-20,  1.154419370355349e-22, -1.156445683772834e-24,  2.550517664848461e-05, -1.288222982203706e-06,
  3.923817168636395e-08, -9.071914293217967e-10,  1.744347777590247e-11, -2.925677689768604e-13,  4.406563490315017e-15, -6.076857245245345e-17,  7.779514142608708e-19,
 -9.340630658870216e-21,  1.060187300550249e-22, -1.144575998311963e-24,  7.826955593373624e-06, -4.576871044476522e-07,  1.575073916007046e-08, -4.064021891077140e-10,
  8.646373678281269e-12, -1.594292194966830e-13,  2.626302413178239e-15, -3.944337099121496e-17,  5.479252352064157e-19, -7.116233533305068e-21,  8.712733535239607e-23,
 -1.012112815650929e-24,  2.218261041900047e-06, -1.490332311197900e-07,  5.772209377082527e-09, -1.657230147346249e-10,  3.891862147282220e-12, -7.872708522336705e-14,
  1.415762489568584e-15, -2.311656896181893e-17,  3.478951224112291e-19, -4.880063256446508e-21,  6.435790622107940e-23, -8.033188206515659e-25,  5.815218512184718e-07,
 -4.458547201898589e-08,  1.936386577602569e-09, -6.169325129351583e-11,  1.595701500346359e-12, -3.534513039425712e-14,  6.927150302645067e-16, -1.227793679904823e-17,
  1.998988724804926e-19, -3.024510084185740e-21,  4.290938914885110e-23, -5.748058659948269e-25,  1.412783125367112e-07, -1.228683347534255e-08,  5.963317419586050e-10,
 -2.103005506091792e-11,  5.978756340646693e-13, -1.447601732609179e-14,  3.087240716105314e-16, -5.931703338628299e-18,  1.043448653077508e-19, -1.700847820702196e-21,
  2.592945280345059e-23, -3.723709380987188e-25,  3.188128066432036e-08, -3.128114713422683e-09,  1.691138510870306e-10, -6.585825673328534e-12,  2.054069693000539e-13,
 -5.427752838619796e-15,  1.257854631797671e-16, -2.616563414777677e-18,  4.967391104033835e-20, -8.713752398529934e-22,  1.426011141118018e-23, -2.193298601782836e-25,
  6.701114859489619e-09, -7.381438680517054e-10,  4.431659159150613e-11, -1.901539684524087e-12,  6.494888585063419e-14, -1.870228224602342e-15,  4.703591257117442e-17,
 -1.058077821677174e-18,  2.165505900238312e-20, -4.084050054413395e-22,  7.167973273015456e-24, -1.179722916844452e-25,  1.316298398826613e-09, -1.620462841041821e-10,
  1.077317776261515e-11, -5.082373390395813e-13,  1.897834451431746e-14, -5.946808444726593e-16,  1.621102560712435e-17, -3.939230165013750e-19,  8.682933085783140e-21,
 -1.758952150366417e-22,  3.308055816298386e-24, -5.821151234204584e-26,  2.426013389766114e-10, -3.323956897025859e-11,  2.440326964758399e-12, -1.263178547664279e-13,
  5.148391246566688e-15, -1.753098165658399e-16,  5.173818054388381e-18, -1.356654563062192e-19,  3.217544854085395e-21, -6.994986806669776e-23,  1.408518028080563e-24,
 -2.647959154977887e-26,  4.215442910972587e-11, -6.402935957346932e-12,  5.177401109412993e-13, -2.934639696136158e-14,  1.303405098531018e-15, -4.816581092053878e-17,
  1.537151211786211e-18, -4.344934594192106e-20,  1.107725467963888e-21, -2.582225733257936e-23,  5.562572824907077e-25, -1.116358103446507e-26,  6.945279512564439e-12,
 -1.165128086532136e-12,  1.034965775118533e-13, -6.411143455350960e-15,  3.097992558431379e-16, -1.240727050439088e-17,  4.276766598417254e-19, -1.301774413124543e-20,
  3.564225006089103e-22, -8.901139768383696e-24,  2.049633087597124e-25, -4.387757896159468e-27,  1.092430607941468e-12, -2.016727533012007e-13,  1.962944584919226e-14,
 -1.326222636480181e-15,  6.960946805620494e-17, -3.017123902574289e-18,  1.121921031682051e-19, -3.673331163724553e-21,  1.079036225097136e-22, -2.884251379139113e-24,
  7.093089897494869e-26, -1.618380140151734e-27,  1.653753465274940e-13, -3.347584905524896e-14,  3.561050430012724e-15, -2.618734472303054e-16,  1.490403279773220e-17,
 -6.980936395817345e-19,  2.796683716268448e-20, -9.837961609751512e-22,  3.097108021928256e-23, -8.851796371268439e-25,  2.322696480996817e-26, -5.643135158791280e-28,
  2.432621756672941e-14, -5.379806606960483e-15,  6.237935221785971e-16, -4.982158255389107e-17,  3.068950685388599e-18, -1.550902171550709e-19,  6.684176624654008e-21,
 -2.522916276038473e-22,  8.501618521520034e-24, -2.595138677293623e-25,  7.257929903125877e-27, -1.875748634272832e-28,  3.516306669776626e-15, -8.464243143032628e-16,
  1.066767821901747e-16, -9.231998467865789e-18,  6.142567585963567e-19, -3.343093882454797e-20,  1.547528963371296e-21, -6.258008755103829e-23,  2.254114729643875e-24,
 -7.339179171506650e-26,  2.184980548784026e-27, -5.999569024316987e-29,  5.060593943442622e-16, -1.320725414617801e-16,  1.803804838742838e-17, -1.687132192825458e-18,
  1.209765498949300e-19, -7.076460910972167e-21,  3.511709518715941e-22, -1.518803216910974e-23,  5.838098175169219e-25, -2.024330451336526e-26,  6.405980995202135e-28,
 -1.866152503032014e-29,  7.362039317058506e-17, -2.074480159152346e-17,  3.060154370779768e-18, -3.084517212188026e-19,  2.377471703457249e-20, -1.491144929173319e-21,
  7.915565216954221e-23, -3.653902286126350e-24,  1.495930885849214e-25, -5.513843676015613e-27,  1.851357346908188e-28, -5.712065983374099e-30,  1.101496263367045e-17,
 -3.336132538738378e-18,  5.295825662313204e-19, -5.733788386051908e-20,  4.736418819669970e-21, -3.176457246000700e-22,  1.799031873095977e-23, -8.841819222988242e-25,
  3.846518242989035e-26, -1.503742760126127e-27,  5.345735919058698e-29, -1.743200980574033e-30,  1.728125078569416e-18, -5.598381588408449e-19,  9.523733721117488e-20,
 -1.103439655192018e-20,  9.734818243854412e-22, -6.958160591288151e-23,  4.191665520828378e-24, -2.186977850524495e-25,  1.008148051445887e-26, -4.168909317547023e-28,
  1.565039390043109e-29, -5.380305435004003e-31,  2.903993374242797e-19, -1.000900657193696e-19,  1.816133218161285e-20, -2.242020976858849e-21,  2.103899775161179e-22,
 -1.596599068072240e-23,  1.019283173344131e-24, -5.625831070886066e-26,  2.738792898589274e-27, -1.194101142396755e-28,  4.719010505699447e-30, -1.705111295609615e-31,
  5.345643823852495e-20, -1.948800480873128e-20,  3.751599597078917e-21, -4.910029757347303e-22,  4.877696798250160e-23, -3.912236215152683e-24,  2.635416802575045e-25,
 -1.532381923272987e-26,  7.846741222299625e-28, -3.593115086420438e-29,  1.489214982722641e-30, -5.635036948882778e-32,  1.102441618811733e-20, -4.224060335733492e-21,
  8.575196740326274e-22, -1.183001312405435e-22,  1.237280689375091e-23, -1.043330403189921e-24,  7.378401890107746e-26, -4.497547001417878e-27,  2.410957895800664e-28,
 -1.154194997605871e-29,  4.994715590171786e-31, -1.970669113566862e-32,  2.599431169769036e-21, -1.039596422755187e-21,  2.210489501959479e-22, -3.193369787048155e-23,
  3.494086732965530e-24, -3.078770951096825e-25,  2.272332550015902e-26, -1.443789213389500e-27,  8.057704883238257e-29, -4.011296910980722e-30,  1.803047892002667e-31,
 -7.380516410966945e-33,  7.105563359374354e-22, -2.944296895227320e-22,  6.507713426289750e-23, -9.772271858630832e-24,  1.110615487170106e-24, -1.015494799882965e-25,
  7.769656660137248e-27, -5.112331861282532e-28,  2.951711419007644e-29, -1.518683822285943e-30,  7.048475278984637e-32, -2.976076390628548e-33,  2.247617728945848e-22,
 -9.573909129642290e-23,  2.181516263944914e-23, -3.377336818980802e-24,  3.955085872217456e-25, -3.723640502696828e-26,  2.931219483934790e-27, -1.982782599724950e-28,
  1.175968719261563e-29, -6.210384907813888e-31,  2.956297088138986e-32, -1.279240199276928e-33,  7.864121176064953e-23, -3.415266782576644e-23,  7.951375200521516e-24,
 -1.257903718921136e-24,  1.504740879835606e-25, -1.446399904552332e-26,  1.161836721738793e-27, -8.015006446257909e-29,  4.845222693928263e-30, -2.606677377744238e-31,
  1.263383206343563e-32, -5.563012719400694e-34,  2.408209494259511e-23, -1.057261039577252e-23,  2.491541601682648e-24, -3.990000130630456e-25,  4.830614970041723e-26,
 -4.698112036938657e-27,  3.817163901474581e-28, -2.662705665129410e-29,  1.627120893811749e-30, -8.845972992539252e-32,  4.331259974771415e-33, -1.926059860585393e-34,
  5.918628598995712e-02, -1.444053304992508e-04,  3.640559490450193e-07, -9.439691565782241e-10,  2.501698107679282e-12, -6.740342462903155e-15,  1.835048684289095e-17,
 -5.035330173767384e-20,  1.384668828575805e-22, -3.824124170923039e-25,  1.051453585073322e-27, -2.910299997107056e-30,  5.421273440451467e-02, -1.578097951443366e-04,
  5.494592744782118e-07, -2.022550244187215e-09,  7.447595933194061e-12, -2.700226383272537e-14,  9.615867109599415e-17, -3.368980659151831e-19,  1.163314063910238e-21,
 -3.967648735647477e-24,  1.337948470206030e-26, -4.468975872894652e-29,  4.548523598469295e-02, -1.753614782663684e-04,  8.542508382016874e-07, -4.081343937422529e-09,
  1.860804096491358e-11, -8.160778553604890e-14,  3.470651198638210e-16, -1.439275023545219e-18,  5.842078557442864e-21, -2.327518969951295e-23,  9.120972634091592e-26,
 -3.521777298064402e-28,  3.495799307233945e-02, -1.844929035459246e-04,  1.169614979292885e-06, -6.794741721665847e-09,  3.684644018402408e-11, -1.900635685355187e-13,
  9.425076148329686e-16, -4.523430017890879e-18,  2.111221272892936e-20, -9.617415284031749e-23,  4.288293628428127e-25, -1.875839302712219e-27,  2.461262548448905e-02,
 -1.768248304625107e-04,  1.384712663165961e-06, -9.535765261817986e-09,  6.049668666825855e-11, -3.614176525563714e-13,  2.058102398226014e-15, -1.126297783395188e-17,
  5.958773780203183e-20, -3.061487804839022e-22,  1.532877588356201e-24, -7.500455924358391e-27,  1.587616974633767e-02, -1.521678468531267e-04,  1.429737563540434e-06,
 -1.152374092970286e-08,  8.454908145656633e-11, -5.782783098388523e-13,  3.739789575528088e-15, -2.309233799499934e-17,  1.371070162236819e-19, -7.869019967843911e-22,
  4.383650267035472e-24, -2.378007887913397e-26,  9.383520673155009e-03, -1.172006338588595e-04,  1.300084964814940e-06, -1.215490510117949e-08,  1.021825189728708e-10,
 -7.930329765992529e-13,  5.776102288955364e-15, -3.992745349269814e-17,  2.640552727257396e-19, -1.680813434078510e-21,  1.034595428037930e-23, -6.180766884667308e-26,
  5.082677696039651e-03, -8.088724440117215e-05,  1.048930351334883e-06, -1.129068030592064e-08,  1.079397204214544e-10, -9.439539280878055e-13,  7.693072178401510e-15,
 -5.916691952695609e-17,  4.332973288955785e-19, -3.041815002481868e-21,  2.057641885354486e-23, -1.346684300475532e-25,  2.523615136990258e-03, -5.015370525996095e-05,
  7.550367840851943e-07, -9.296420581550851e-09,  1.004469426499940e-10, -9.842743721341095e-13,  8.928725877998860e-15, -7.602485731841180e-17,  6.136123392573454e-19,
 -4.729302201221795e-21,  3.500486113400296e-23, -2.499315927632648e-25,  1.148901185683490e-03, -2.801862160184869e-05,  4.869242842021974e-07, -6.819096433348214e-09,
  8.284883261198735e-11, -9.054307577814967e-13,  9.102700649407446e-15, -8.545701733147628e-17,  7.572319485311956e-19, -6.383690485853337e-21,  5.151608592713717e-23,
 -3.998811866776491e-25,  4.797677624568381e-04, -1.414189159198178e-05,  2.822948733039429e-07, -4.474489787796938e-09,  6.086458192128012e-11, -7.389596937578766e-13,
  8.203459495605580e-15, -8.462509159024381e-17,  8.205622109275750e-19, -7.543011278749103e-21,  6.616958557879484e-23, -5.567874266771542e-25,  1.838529840800483e-04,
 -6.465305960887290e-06,  1.475553569776127e-07, -2.635676269757912e-09,  3.999091326234549e-11, -5.375876616274162e-13,  6.569649685009817e-15, -7.425201864436963e-17,
  7.857012085713452e-19, -7.854902822906209e-21,  7.471404852830501e-23, -6.798601682351322e-25,  6.469282629291333e-05, -2.683559845406710e-06,  6.971891907113640e-08,
 -1.398050878536154e-09,  2.358485846694207e-11, -3.500206086448599e-13,  4.696199459591181e-15, -5.800914659349617e-17,  6.682855404799937e-19, -7.249756315361305e-21,
  7.461057195985577e-23, -7.326641322578065e-25,  2.091730466193007e-05, -1.013528221579296e-06,  2.985049998024861e-08, -6.696920855491840e-10,  1.252519359774923e-11,
 -2.046991249139743e-13,  3.008324419880543e-15, -4.052521213237754e-17,  5.072577805717992e-19, -5.959816861058582e-21,  6.624085241483224e-23, -7.007246827168115e-25,
  6.220359062698831e-06, -3.490584943162213e-07,  1.160888861905091e-08, -2.904868535147736e-10,  6.007960538043147e-12, -1.078842973069040e-13,  1.733179408422970e-15,
 -2.541455276471668e-17,  3.450341200435683e-19, -4.383159500089526e-21,  5.252991823000247e-23, -5.976976024012030e-25,  1.703239102683944e-06, -1.098603525208234e-07,
  4.110621236827721e-09, -1.144027539506827e-10,  2.610547256716237e-12, -5.140410516931779e-14,  9.011228510531343e-16, -1.435982468262204e-17,  2.111253392400010e-19,
 -2.895737011931444e-21,  3.736861872835892e-23, -4.567309423997962e-25,  4.300221221188122e-07, -3.167001220132386e-08,  1.328562486079167e-09, -4.101901025643618e-11,
  1.030552415398749e-12, -2.221240601490120e-14,  4.242217501138797e-16, -7.335934899165868e-18,  1.166473350937171e-19, -1.725195522082781e-21,  2.394381367065816e-23,
 -3.139966679758340e-25,  1.002775595905206e-07, -8.382643150584138e-09,  3.929776164093242e-10, -1.342797315468369e-11,  3.707295935061725e-13, -8.732522331094910e-15,
  1.814385083722308e-16, -3.400397662557164e-18,  5.840646184980842e-20, -9.304345199459764e-22,  1.387363384175889e-23, -1.950122816453465e-25,  2.164332556696264e-08,
 -2.042749096544189e-09,  1.066909916714139e-10, -4.025744435684303e-12,  1.219243254082963e-13, -3.133917792821592e-15,  7.074719826226329e-17, -1.435304433863430e-18,
  2.660270769976164e-20, -4.560185929476740e-22,  7.298457308329008e-24, -1.098640067223698e-25,  4.334727428449606e-09, -4.597080392339026e-10,  2.667306216825329e-11,
 -1.109079681221927e-12,  3.678673201078861e-14, -1.030408085929807e-15,  2.524344130370741e-17, -5.538086375189472e-19,  1.106559706615958e-20, -2.039278636633474e-22,
  3.500303548703677e-24, -5.638141177617889e-26,  8.081067702274205e-10, -9.587727919515265e-11,  6.163202737950743e-12, -2.818457138893040e-13,  1.022235969451207e-14,
 -3.116253261760595e-16,  8.275809532204520e-18, -1.961434545278095e-19,  4.221220500747672e-21, -8.356613486838911e-23,  1.537121362245305e-24, -2.647452542381145e-26,
  1.407620985772380e-10, -1.860814111791924e-11,  1.321824862264081e-12, -6.635510635729118e-14,  2.627730827174994e-15, -8.707509408273645e-17,  2.504116688071589e-18,
 -6.405729916565351e-20,  1.483610486091721e-21, -3.152607854803011e-23,  6.209916611372083e-25, -1.142878317925743e-26,  2.301439312403355e-11, -3.377100205938408e-12,
  2.644357162056994e-13, -1.454523538257337e-14,  6.280093157797103e-16, -2.259392857332445e-17,  7.028964567144595e-19, -1.938946005188176e-20,  4.828949274615962e-22,
 -1.100621766299830e-23,  2.320017742365028e-25, -4.559464669069083e-27,  3.551476640774027e-12, -5.763934835591562e-13,  4.963121327762790e-14, -2.985872197868498e-15,
  1.403558330021993e-16, -5.475827149072817e-18,  1.840954459745620e-19, -5.471235277451649e-21,  1.464045468684002e-22, -3.576440553917109e-24,  8.061930490599887e-26,
 -1.690759644678647e-27,  5.207166926628478e-13, -9.314648835329729e-14,  8.798889103272450e-15, -5.779234376576427e-16,  2.953292645143943e-17, -1.247915727104346e-18,
  4.529088224070828e-20, -1.448812926178933e-21,  4.161922279586806e-23, -1.088832140640626e-24,  2.622801908411388e-26, -5.865768259124886e-28,  7.312071392418067e-14,
 -1.436709714555407e-14,  1.485294284297678e-15, -1.063085396773490e-16,  5.896773224512632e-18, -2.695169597194509e-19,  1.054748535989604e-20, -3.628001595571613e-22,
  1.117786572933409e-23, -3.129129689646145e-25,  8.048123928485337e-27, -1.917943162016401e-28,  9.928002681362285e-15, -2.135258179040517e-15,  2.409901928101015e-16,
 -1.875901794571036e-17,  1.127583950906439e-18, -5.566648614641232e-20,  2.346094338700613e-21, -8.667335514771652e-23,  2.861090831785795e-24, -8.561892718401277e-26,
  2.349129986158950e-27, -5.959987874743068e-29,  1.318193779849516e-15, -3.092276481316155e-16,  3.800101926758263e-17, -3.210200637868787e-18,  2.087230071459477e-19,
 -1.111198114066835e-20,  5.036235611154326e-22, -1.995701902454065e-23,  7.049620316541586e-25, -2.252574139499045e-26,  6.585818351080799e-28, -1.777010041153233e-29,
  1.734559716915000e-16, -4.421497152353161e-17,  5.899618948287787e-18, -5.395817012421975e-19,  3.787011655991911e-20, -2.170155950403533e-21,  1.055933803911944e-22,
 -4.481251240069337e-24,  1.691453809590930e-25, -5.763017414884116e-27,  1.793092776260485e-28, -5.138932407210324e-30,  2.297575089105798e-17, -6.338486096837188e-18,
  9.154163582820459e-19, -9.040286590217392e-20,  6.832592390501184e-21, -4.205425544762828e-22,  2.192382714004419e-23, -9.945771936050303e-25,  4.004261882852891e-26,
 -1.452306201255491e-27,  4.801016340776516e-29, -1.459202811075012e-30,  3.119261341623521e-18, -9.272701615859719e-19,  1.444406664900922e-19, -1.535468406902173e-20,
  1.246211509220933e-21, -8.217212309156369e-23,  4.578718829881237e-24, -2.215326828545640e-25,  9.493058346792040e-27, -3.657546195526823e-28,  1.282103983095745e-29,
 -4.124588365867936e-31,  4.430356567002110e-19, -1.412368953313389e-19,  2.363414607524091e-20, -2.694732757822321e-21,  2.340854751993662e-22, -1.648432327309769e-23,
  9.788946133070355e-25, -5.037292525331505e-26,  2.291389288721939e-27, -9.354592947355732e-29,  3.468568065672362e-30, -1.178277111264973e-31,  6.734853111432145e-20,
 -2.290288578431101e-20,  4.098173911555175e-21, -4.990663032116920e-22,  4.621831099332458e-23, -3.463062678291639e-24,  2.183917796355430e-25, -1.191238308799983e-26,
  5.733582438574017e-28, -2.472509191941057e-29,  9.668157100379514e-31, -3.457861050848705e-32,  1.122976591863950e-20, -4.049842203257971e-21,  7.708033699062940e-22,
 -9.975955077489131e-23,  9.803403143889691e-24, -7.781091214820145e-25,  5.188949973357062e-26, -2.987916324006894e-27,  1.515695820992344e-28, -6.877939989771647e-30,
  2.825827277046838e-31, -1.060287380440736e-32,  2.105991812453387e-21, -8.002387579783448e-22,  1.610221174774049e-22, -2.202064499224812e-23,  2.283621616801181e-24,
 -1.909899079818256e-25,  1.340005897587686e-26, -8.105812663072573e-28,  4.313237044420625e-29, -2.050205382810335e-30,  8.811304130469853e-32, -3.453528038301445e-33,
  4.547099983710131e-22, -1.807651195670125e-22,  3.818799623928555e-23, -5.481537167496667e-24,  5.960390549840153e-25, -5.220258077113704e-26,  3.830436121938557e-27,
 -2.420075747929132e-28,  1.343290436071874e-29, -6.652092006122759e-31,  2.974909647414559e-32, -1.211787667315127e-33,  1.150051725781821e-22, -4.746529505986345e-23,
  1.044580057651152e-23, -1.561844747270734e-24,  1.767584939116919e-25, -1.609620938219845e-26,  1.226689502228089e-27, -8.040741604516253e-29,  4.625420253918208e-30,
 -2.371368617040883e-31,  1.096815167347873e-32, -4.615755571605688e-34,  3.413013020561562e-23, -1.450441619225644e-23,  3.296569550411534e-24, -5.090645601243453e-25,
  5.946662576531784e-26, -5.585149031063983e-27,  4.386292899532137e-28, -2.960325204407928e-29,  1.751891859181082e-30, -9.232269822855354e-32,  4.385778366652198e-33,
 -1.894047164953057e-34,  1.139765144508906e-23, -4.944338657090726e-24,  1.149714620591711e-24, -1.816594038048645e-25,  2.170425005438225e-26, -2.083806699638186e-27,
  1.671916700162377e-28, -1.152095893327664e-29,  6.957100309521403e-31, -3.738916641945128e-32,  1.810303368658766e-33, -7.963401636757221e-35,  3.397787544862423e-24,
 -1.491085059871489e-24,  3.512236053931834e-25, -5.621877458969551e-26,  6.803085170068647e-27, -6.613410104938894e-28,  5.370882027349058e-29, -3.744854863300954e-30,
  2.287404682106016e-31, -1.243038081136821e-32,  6.083771862980770e-34, -2.704287810108435e-35,  5.861441876882634e-02, -1.415375230567202e-04,  3.529641097823938e-07,
 -9.049969831300147e-10,  2.371183708701766e-12, -6.316361228246597e-15,  1.700061439532898e-17, -4.613475773999084e-20,  1.254272134551429e-22, -3.428071479285575e-25,
  9.313937331064331e-28, -2.555415934422675e-30,  5.359013566528187e-02, -1.535092178585444e-04,  5.258862168528238e-07, -1.907586813805967e-09,  6.929885845893722e-12,
 -2.480357531291566e-14,  8.722593176494272e-17, -3.018578166868999e-19,  1.029656422425914e-21, -3.469794483032474e-24,  1.156074023060338e-26, -3.816313744605884e-29,
  4.479715488846792e-02, -1.687184358526231e-04,  8.070086512052045e-07, -3.796233286263221e-09,  1.705602258786360e-11, -7.374144389255904e-14,  3.092615551164803e-16,
 -1.265060092660824e-18,  5.066274140074554e-21, -1.991866287185553e-23,  7.704253788420184e-26, -2.936611615690156e-28,  3.423823267540346e-02, -1.754523902025470e-04,
  1.091493761643247e-06, -6.234421549174073e-09,  3.326149288960335e-11, -1.688900011562281e-13,  8.248120512508967e-16, -3.900079834799464e-18,  1.793980140069091e-20,
 -8.056383564980970e-23,  3.542166042173955e-25, -1.528175809577888e-27,  2.392677937486969e-02, -1.661889232265946e-04,  1.275861035801001e-06, -8.623064807405319e-09,
  5.373780561082459e-11, -3.156018623784859e-13,  1.767858222991679e-15, -9.521294474951713e-18,  4.959492076817747e-20, -2.509560904798921e-22,  1.237900967458614e-24,
 -5.968860536228064e-27,  1.528952970223075e-02, -1.412609369151454e-04,  1.299202937476316e-06, -1.025881471351956e-08,  7.383114676404610e-11, -4.958116209870796e-13,
  3.150599266319204e-15, -1.912627214140997e-17,  1.116979568018754e-19, -6.308177645752328e-22,  3.459140316121192e-24, -1.847683002541450e-26,  8.934633432639946e-03,
 -1.073567542347887e-04,  1.163535623165959e-06, -1.063970165646090e-08,  8.762227592491840e-11, -6.669205035044261e-13,  4.767873851883709e-15, -3.237099291861730e-17,
  2.103832493856356e-19, -1.316644494546295e-21,  7.971240974152995e-24, -4.685510816581787e-26,  4.775093148343983e-03, -7.300976696180227e-05,  9.232124128569571e-07,
 -9.705181964277623e-09,  9.078047649530426e-11, -7.777292554944659e-13,  6.215122117915263e-15, -4.690554564625444e-17,  3.372821867941641e-19, -2.326099199085675e-21,
  1.546495175024282e-23, -9.951762079611510e-26,  2.334411066762966e-03, -4.453374149750319e-05,  6.525088517784171e-07, -7.835796101500111e-09,  8.274275820585954e-11,
 -7.934586416648942e-13,  7.051142115175840e-15, -5.886323633633791e-17,  4.661179595097648e-19, -3.526645769053079e-21,  2.563729733842681e-23, -1.798600576165986e-25,
  1.044129328409673e-03, -2.442931205923619e-05,  4.124873704553871e-07, -5.627280985787414e-09,  6.674434831999868e-11, -7.131402851985782e-13,  7.017243432818388e-15,
 -6.453693451548954e-17,  5.606279541825622e-19, -4.636339986803290e-21,  3.672314307272319e-23, -2.799173473606986e-25,  4.273988268782041e-04, -1.208281046165855e-05,
  2.339888543007078e-07, -3.608948008225135e-09,  4.787662142880553e-11, -5.677773108947011e-13,  6.164128104902385e-15, -6.224540355628657e-17,  5.912870899224306e-19,
 -5.328488240359801e-21,  4.585056157632326e-23, -3.786412004941001e-25,  1.601666798030678e-04, -5.401262825666271e-06,  1.194374964460944e-07, -2.073927779495055e-09,
  3.066111748447573e-11, -4.022656769794478e-13,  4.803873084592322e-15, -5.311105498606214e-17,  5.502105723068023e-19, -5.389152087051627e-21,  5.025301706041287e-23,
 -4.485396924482780e-25,  5.497623986713121e-05, -2.186994673941029e-06,  5.499386745700672e-08, -1.071084265356647e-09,  1.759150525781508e-11, -2.546083973544468e-13,
  3.335867676836762e-15, -4.028154400085663e-17,  4.540530149938648e-19, -4.823185730575925e-21,  4.863683959903001e-23, -4.682528117248812e-25,  1.729433255330494e-05,
 -8.037500349887221e-07,  2.289323937801740e-08, -4.984731633079553e-10,  9.069998226038401e-12, -1.444629201145145e-13,  2.071939381752264e-15, -2.726923837576526e-17,
  3.337927427256076e-19, -3.838211178174818e-21,  4.178041142476992e-23, -4.331266810158639e-25,  4.989898292451788e-06, -2.686470058085163e-07,  8.635317048161535e-09,
 -2.095821408711409e-10,  4.214475708332146e-12, -7.371212002747635e-14,  1.155043767928331e-15, -1.653905808856553e-17,  2.194744195102014e-19, -2.727496225841871e-21,
  3.200036161538981e-23, -3.566838012442157e-25,  1.321781310365377e-06, -8.182777280419226e-08,  2.957937394252964e-09, -7.980770055349535e-11,  1.769737967275425e-12,
 -3.392553483298575e-14,  5.798095686554767e-16, -9.018500600799017e-18,  1.295513515415704e-19, -1.737603140848260e-21,  2.194401970630010e-23, -2.626521148532542e-25,
  3.218369852182643e-07, -2.276060167203797e-08,  9.222250828207207e-10, -2.759389587673509e-11,  6.734380759851143e-13, -1.412555245805950e-14,  2.629130163908773e-16,
 -4.436126285095061e-18,  6.889610681660908e-20, -9.961229647637016e-22,  1.352571503768626e-23, -1.736551587758092e-25,  7.214072030982372e-08, -5.794409322930120e-09,
  2.623548118876834e-10, -8.685841325460637e-12,  2.328851664801442e-13, -5.336833113889184e-15,  1.080341582096243e-16, -1.975031150546094e-18,  3.312581878794974e-20,
 -5.157555310989260e-22,  7.522219697050502e-24, -1.034968609890582e-25,  1.491464697976438e-08, -1.353519092760436e-09,  6.828368787274553e-11, -2.496237354188341e-12,
  7.340945575529469e-14, -1.835418366133865e-15,  4.036152402515144e-17, -7.986184908192090e-19,  1.445143050942992e-20, -2.420768203433299e-22,  3.789121933803618e-24,
 -5.582363841627833e-26,  2.850676017766692e-09, -2.909292600091231e-10,  1.630934641178047e-11, -6.570704487952843e-13,  2.116213345994160e-14, -5.765573654454572e-16,
  1.375827568702006e-17, -2.943616084398600e-19,  5.741900987864876e-21, -1.033987891021096e-22,  1.735631660156180e-24, -2.736049733153326e-26,  5.051677240467673e-10,
 -5.773159481612614e-11,  3.587173941086267e-12, -1.589808656158302e-13,  5.599665496251990e-15, -1.660520294938151e-16,  4.295635707716146e-18, -9.929196941978149e-20,
  2.086185115024145e-21, -4.035694759999129e-23,  7.259819514313344e-25, -1.223775466953362e-26,  8.329374370330228e-11, -1.061766140588487e-11,  7.294734134098179e-13,
 -3.550328947786389e-14,  1.365764484357117e-15, -4.403368808294279e-17,  1.233759759724094e-18, -3.078491102390066e-20,  6.961907540815272e-22, -1.445817582428310e-23,
  2.785609472106870e-25, -5.018253850202167e-27,  1.283392193313008e-11, -1.818158464226506e-12,  1.378009989732978e-13, -7.352839471938051e-15,  3.085266787248550e-16,
 -1.080375041599239e-17,  3.275661129820515e-19, -8.816444565646506e-21,  2.144559126501043e-22, -4.778283611349368e-24,  9.854308361998630e-26, -1.896164053706723e-27,
  1.857688818000171e-12, -2.914770618699355e-13,  2.431615785195241e-14, -1.420142984584510e-15,  6.491538330859874e-17, -2.466333391588641e-18,  8.084905755087248e-20,
 -2.345449901320865e-21,  6.132396349047957e-23, -1.465022618255108e-24,  3.232190630994926e-26, -6.639376654320406e-28,  2.542418811502163e-13, -4.403477055748004e-14,
  4.034598916087226e-15, -2.574904822150260e-16,  1.280543132387439e-17, -5.273026945709998e-19,  1.867198260102804e-20, -5.833863742241507e-22,  1.638376841479930e-23,
 -4.194001330212655e-25,  9.892809203700340e-27, -2.168117641582011e-28,  3.315653015702155e-14, -6.318536213911135e-15,  6.344144800115187e-16, -4.416997084937444e-17,
  2.386665691322241e-18, -1.063972523144643e-19,  4.065819975310984e-21, -1.366967696048088e-22,  4.120361221253416e-24, -1.129389681294860e-25,  2.846338774851798e-27,
 -6.651330513410487e-29,  4.159378113444389e-15, -8.692538645531088e-16,  9.542515373004811e-17, -7.234990920544811e-18,  4.241321248083669e-19, -2.044447025620883e-20,
  8.421937785815435e-22, -3.044020767120729e-23,  9.839265326359612e-25, -2.885436251554159e-26,  7.763787504238420e-28, -1.933015407349691e-29,  5.076182137602715e-16,
 -1.159455630886647e-16,  1.388286345961915e-17, -1.144024321820586e-18,  7.264274498615266e-20, -3.780873254681818e-21,  1.676889678227603e-22, -6.508401302722105e-24,
  2.253589303879458e-25, -7.063837988039244e-27,  2.027317538564873e-28, -5.373253149420467e-30,  6.108824897986982e-17, -1.519568005578154e-17,  1.979297020128906e-18,
 -1.768922817135719e-19,  1.214372882460512e-20, -6.813384652285652e-22,  3.248676305455463e-23, -1.352128511933004e-24,  5.009008257152207e-26, -1.676155703764944e-27,
  5.125291700701832e-29, -1.444470988505327e-30,  7.365924333088152e-18, -1.987751095879336e-18,  2.808313524547535e-19, -2.715245614675732e-20,  2.010905250280960e-21,
 -1.213835642548032e-22,  6.210857373666305e-24, -2.767428710884960e-25,  1.095111464280595e-26, -3.906310694915052e-28,  1.270782075005190e-29, -3.803052657824225e-31,
  9.067012260394109e-19, -2.643245189379595e-19,  4.037069570577003e-20, -4.210551155694497e-21,  3.355302560903286e-22, -2.173813737966241e-23,  1.190967053702173e-24,
 -5.669350617412119e-26,  2.391692168907986e-27, -9.076946035656456e-29,  3.135854253556145e-30, -9.947714027006137e-32,  1.164193343059191e-19, -3.649235363223627e-20,
  6.002123003549080e-21, -6.729772006424537e-22,  5.752317883111463e-23, -3.988327501909698e-24,  2.333268122981210e-25, -1.183530135532266e-26,  5.309639568415076e-28,
 -2.138908991766802e-29,  7.829312922326762e-31, -2.626814421678573e-32,  1.597598125027294e-20, -5.356399758069369e-21,  9.445033544782606e-22, -1.133837488636251e-22,
  1.035611446373285e-23, -7.656905481168786e-25,  4.767102832903174e-26, -2.568314520238597e-27,  1.221525933490937e-28, -5.207473746555076e-30,  2.013821859832418e-31,
 -7.126039946255550e-33,  2.406269564555506e-21, -8.578870316569742e-22,  1.613291654856868e-22, -2.063480113422520e-23,  2.004752880987003e-24, -1.573754428893371e-25,
  1.038392520006103e-26, -5.918389179847557e-28,  2.972763368675261e-29, -1.336203030378184e-30,  5.439645440296180e-32, -2.023044679439963e-33,  4.089876551166662e-22,
 -1.540387289019351e-22,  3.070527254804852e-23, -4.160393765790011e-24,  4.275859240037910e-25, -3.545162609159362e-26,  2.466560417650239e-27, -1.480030177587170e-28,
  7.814319625640003e-30, -3.686537129710496e-31,  1.572928639984687e-32, -6.122026759364462e-34,  8.056206080148807e-23, -3.182201890784561e-23,  6.676445579981381e-24,
 -9.518260025584501e-25,  1.028127693816083e-25, -8.946942058313248e-27,  6.524341356616450e-28, -4.097484053331608e-29,  2.261253532365257e-30, -1.113566866426196e-31,
  4.953299843760743e-33, -2.007225233988206e-34,  1.878151734546130e-23, -7.718691135628231e-24,  1.690827334990025e-24, -2.516509197582100e-25,  2.835267051558587e-26,
 -2.570694337146878e-27,  1.950909853058472e-28, -1.273610279247570e-29,  7.297769585673872e-31, -3.727306160186339e-32,  1.717682211767082e-33, -7.203168618673500e-35,
  5.211167934881676e-24, -2.209128689824873e-24,  5.007240672183740e-25, -7.711300563325868e-26,  8.984074906853924e-27, -8.416156097443791e-28,  6.593122630767532e-29,
 -4.438978939607207e-30,  2.620812887510609e-31, -1.378021985287229e-32,  6.531996903946398e-34, -2.814982392128349e-35,  1.656385943387777e-24, -7.176947758019489e-25,
  1.666670740155024e-25, -2.629932730610140e-26,  3.138119856017572e-27, -3.009087615096172e-28,  2.411351497189878e-29, -1.659659564684420e-30,  1.001057342256347e-31,
 -5.373932268747162e-33,  2.599132460736277e-34, -1.142147087919665e-35,  4.798998112404735e-25, -2.105063996890177e-25,  4.955998803481376e-26, -7.928865535895839e-27,
  9.590033567652836e-28, -9.318116012834050e-29,  7.563819681273524e-30, -5.271425587772957e-31,  3.218387206025414e-32, -1.748181515274427e-33,  8.552366887898548e-35,
 -3.799990977437707e-36,  5.805384822064063e-02, -1.387566145306702e-04,  3.423276814523255e-07, -8.680469239727897e-10,  2.248834294474638e-12, -5.923405367960747e-15,
  1.576322731599376e-17, -4.231156772775303e-20,  1.137305205262210e-22, -3.077065149190357e-25,  8.258747032131630e-28, -2.248204304663924e-30,  5.298437060900309e-02,
 -1.493918443382907e-04,  5.036444345171503e-07, -1.800566277855236e-09,  6.454082713532065e-12, -2.280796624714967e-14,  7.921703823240869e-17, -2.708213458639476e-19,
  9.126783828211245e-22, -3.039258406300680e-24,  1.000619383260579e-26, -3.265063183147438e-29,  4.413491117471088e-02, -1.624400561279910e-04,  7.630438347748901e-07,
 -3.534744000874321e-09,  1.565263926931864e-11, -6.672654903265013e-14,  2.760058620300014e-16, -1.113842071718475e-18,  4.401695568268163e-21, -1.708051091788761e-23,
  6.521612518873255e-26, -2.454298532076244e-28,  3.355342564128268e-02, -1.670108951223991e-04,  1.019765724263530e-06, -5.728220503264381e-09,  3.007312661050719e-11,
 -1.503426536959625e-13,  7.232295958167507e-16, -3.369802647732456e-18,  1.527913250615009e-20, -6.765320782044932e-23,  2.933509523557856e-25, -1.248391153753968e-27,
  2.328180212679505e-02, -1.563817905426237e-04,  1.177342017527060e-06, -7.811538448416925e-09,  4.782935265142824e-11, -2.762011031632717e-13,  1.522187599577186e-15,
 -8.069741947964677e-18,  4.139195166521723e-20, -2.063174073222577e-22,  1.002789062106152e-24, -4.765520912380238e-27,  1.474452092176048e-02, -1.313403822668279e-04,
  1.182870542876955e-06, -9.152912918355109e-09,  6.462968150522459e-11, -4.262398329175796e-13,  2.661871911002900e-15, -1.589009629250137e-17,  9.129492478807441e-20,
 -5.074365919910728e-22,  2.739498635056414e-24, -1.441072038770138e-26,  8.523046727872031e-03, -9.853631647193715e-05,  1.043850103475549e-06, -9.338530239934433e-09,
  7.535849166000744e-11, -5.626491314094820e-13,  3.949028513887823e-15, -2.633939490599920e-17,  1.682590359868752e-19, -1.035500641440517e-21,  6.167269791198886e-24,
 -3.567459951988516e-26,  4.497121250133611e-03, -6.606635572872458e-05,  8.149769370293403e-07, -8.369452051184504e-09,  7.661712859215729e-11, -6.431802852983595e-13,
  5.041084459305198e-15, -3.734102598277753e-17,  2.636971829177867e-19, -1.786949654186144e-21,  1.167875529577074e-23, -7.390620023836382e-26,  2.166150977024018e-03,
 -3.966843184974414e-05,  5.659272433722229e-07, -6.630202153589287e-09,  6.844059525444695e-11, -6.424343950818067e-13,  5.594032382517913e-15, -4.579539428766822e-17,
  3.558571178041899e-19, -2.643562089135870e-21,  1.887818605769680e-23, -1.301578680113164e-25,  9.526084767791725e-04, -2.138239555202908e-05,  3.509248292586140e-07,
 -4.664903172358095e-09,  5.402916892226883e-11, -5.645282753544734e-13,  5.438168532306540e-15, -4.900632332446519e-17,  4.174383734845867e-19, -3.387154286056410e-21,
  2.633745628792750e-23, -1.971709962338051e-25,  3.825544358222424e-04, -1.037192028289790e-05,  1.949274068692299e-07, -2.926284673313754e-09,  3.786963482569763e-11,
 -4.387799518750783e-13,  4.659662313192407e-15, -4.606966575686224e-17,  4.288167714686784e-19, -3.789068562316313e-21,  3.198741210210568e-23, -2.592925927584212e-25,
  1.403260260313579e-04, -4.537544681417137e-06,  9.724732647725242e-08, -1.641920147100601e-09,  2.365784683733654e-11, -3.029947696432245e-13,  3.536649134308303e-15,
 -3.825609174007944e-17,  3.880815177201335e-19, -3.724792859456558e-21,  3.405649872050895e-23, -2.982172072748561e-25,  4.703303896318300e-05, -1.794031423537790e-06,
  4.367470901276509e-08, -8.263634251473940e-10,  1.321643739319169e-11, -1.865882648856519e-13,  2.387757452403039e-15, -2.819144352563852e-17,  3.109790690639125e-19,
 -3.235187845391689e-21,  3.197103400373114e-23, -3.018216467462544e-25,  1.441095429755705e-05, -6.422670284658760e-07,  1.769502718689255e-08, -3.740048666397064e-10,
  6.621893982827537e-12, -1.028088472328467e-13,  1.439267742329612e-15, -1.851006914340123e-17,  2.216073586096854e-19, -2.494321671625939e-21,  2.659576964460505e-23,
 -2.702326904168261e-25,  4.039029176949674e-06, -2.085810591836274e-07,  6.480751717348813e-09, -1.525825462261661e-10,  2.983679643502497e-12, -5.083717357413972e-14,
  7.771115610170377e-16, -1.086763267317099e-17,  1.409823977966282e-19, -1.714196799387939e-21,  1.969157695415690e-23, -2.150392798707514e-25,  1.036349130752158e-06,
 -6.156072363752409e-08,  2.149982291321941e-09, -5.624201990555661e-11,  1.212123772207140e-12, -2.262412296054462e-14,  3.770149719106433e-16, -5.724610467818575e-18,
  8.035681923432531e-20, -1.054076219385217e-21,  1.302878237279974e-23, -1.527306198655875e-25,  2.436859066030963e-07, -1.654356913060698e-08,  6.474306074086976e-10,
 -1.877427672206714e-11,  4.451244313622928e-13, -9.086791531298635e-15,  1.648418695794233e-16, -2.714124704254768e-18,  4.117488807279640e-20, -5.820289896902812e-22,
  7.732532709031330e-24, -9.720323761600056e-26,  5.258041767048801e-08, -4.056428467936716e-09,  1.773690902160078e-10, -5.689543626912171e-12,  1.481504923749694e-13,
 -3.303121916176926e-15,  6.514992262708988e-17, -1.161890211922287e-18,  1.903028616496019e-20, -2.896013866009223e-22,  4.131667090543698e-24, -5.564671644058670e-26,
  1.042829550193035e-08, -9.095837607208214e-10,  4.431654188891956e-11, -1.569477994233360e-12,  4.481594331550985e-14, -1.089935709534675e-15,  2.334797929449285e-17,
 -4.505741967552770e-19,  7.960442427669387e-21, -1.303093529124765e-22,  1.994840432324360e-24, -2.876422725816743e-26,  1.905073510962878e-09, -1.870101124394423e-10,
  1.012680778432155e-11, -3.952532456989333e-13,  1.235964323140528e-14, -3.275144759771338e-16,  7.612339991373111e-18, -1.588290662171804e-19,  3.024512678413876e-21,
 -5.321895747181879e-23,  8.736057948474305e-25, -1.347759456483270e-26,  3.214117987873245e-10, -3.536237823767153e-11,  2.123231890020399e-12, -9.117798714257168e-14,
  3.118327072817004e-15, -8.994062489005300e-17,  2.266238842530994e-18, -5.108376703244663e-20,  1.047773724938286e-21, -1.980525062045877e-23,  3.484123802590371e-25,
 -5.747811201402942e-27,  5.024422164797896e-11, -6.172313219426324e-12,  4.099926848361275e-13, -1.934088712684806e-14,  7.225914947445592e-16, -2.266331332700176e-17,
  6.185718526304949e-19, -1.505340411646394e-20,  3.323637745998649e-22, -6.745088392381675e-24,  1.270988782986970e-25, -2.241045483994531e-27,  7.307159510579791e-12,
 -9.987804428360833e-13,  7.323894431617314e-14, -3.789644702935498e-15,  1.544925470971022e-16, -5.264327047952058e-18,  1.555257222373504e-19, -4.083534630076712e-21,
  9.699840701777553e-23, -2.112410572301400e-24,  4.261563306461262e-26, -8.027571924266876e-28,  9.936378854029279e-13, -1.506181320322793e-13,  1.216743484546395e-14,
 -6.895687498508338e-16,  3.064068494443304e-17, -1.133329525865692e-18,  3.621530488667413e-20, -1.025287658543120e-21,  2.618703653337073e-23, -6.116827108141726e-25,
  1.320555297504999e-26, -2.656388015364565e-28,  1.271178338922751e-13, -2.130154809400894e-14,  1.891933990994649e-15, -1.172668296460608e-16,  5.673146896276771e-18,
 -2.275707727941497e-19,  7.859718426306471e-21, -2.397751661412315e-22,  6.581335437571674e-24, -1.648012793342862e-25,  3.805645404593911e-27, -8.171286219903825e-29,
  1.541599577753595e-14, -2.847002560025639e-15,  2.774447791738168e-16, -1.877973876746724e-17,  9.880110409668459e-19, -4.294165643146181e-20,  1.601691750851687e-21,
 -5.261640325032690e-23,  1.551082458372644e-24, -4.161472065040859e-26,  1.027373567703871e-27, -2.353445166849162e-29,  1.788701465547177e-15, -3.629246043010017e-16,
  3.872517871025228e-17, -2.858025553411749e-18,  1.633110119187249e-19, -7.682517851438798e-21,  3.091897871467269e-22, -1.092876321263313e-23,  3.457653486311988e-25,
 -9.932920996414239e-27,  2.620042081266098e-28, -6.399476568842795e-30,  2.008087073810347e-16, -4.462032400122475e-17,  5.201604766942596e-18, -4.178513075205487e-19,
  2.589610092232105e-20, -1.316957056975352e-21,  5.712920627512203e-23, -2.170697207168400e-24,  7.364333436802855e-26, -2.263423750521068e-27,  6.374120666567749e-29,
 -1.658830449245593e-30,  2.211030839544140e-17, -5.362232172799049e-18,  6.812831722726232e-19, -5.945379021340152e-20,  3.989719899333578e-21, -2.190318462499493e-22,
  1.022831024115090e-23, -4.172868825059576e-25,  1.516438245680007e-26, -4.981437147879452e-28,  1.496285939099110e-29, -4.145127168896412e-31,  2.426775559711443e-18,
 -6.400110790574944e-19,  8.838255614869033e-20, -8.359995078912479e-21,  6.062734965974593e-22, -3.586760492840336e-23,  1.800191023752021e-24, -7.874095905220541e-26,
  3.060893159996065e-27, -1.073269245020371e-28,  3.434250283826908e-30, -1.011511655538453e-31,  2.706760870717629e-19, -7.731320207072035e-20,  1.156835469477818e-20,
 -1.182867937283681e-21,  9.248352510215862e-23, -5.883367918055451e-24,  3.167316613249255e-25, -1.482551516093959e-26,  6.153802939641173e-28, -2.299316954131042e-29,
  7.824889550601147e-31, -2.446503901372578e-32,  3.137817918858769e-20, -9.662777469972081e-21,  1.560877021164141e-21, -1.719725256885854e-22,  1.445376420067359e-23,
 -9.860382855138746e-25,  5.679448788231571e-26, -2.838037321373876e-27,  1.255002053663228e-28, -4.985871926940803e-30,  1.800765512052632e-31, -5.964305046397923e-33,
  3.879319472617623e-21, -1.281340507894172e-21,  2.224838164457662e-22, -2.630973660885929e-23,  2.368435409102731e-24, -1.726843324540209e-25,  1.060763930502881e-26,
 -5.641520680803960e-28,  2.649977334959051e-29, -1.116232019658933e-30,  4.266994212224657e-32, -1.493164059958069e-33,  5.263646157587518e-22, -1.853926559191978e-22,
  3.442377282505998e-23, -4.348526008910600e-24,  4.174215351827880e-25, -3.239001020631965e-26,  2.113399177293554e-27, -1.191649188137591e-28,  5.923809449804326e-30,
 -2.636158644258181e-31,  1.062875413632169e-32, -3.916378923521218e-34,  8.081184429547578e-23, -3.015117081651396e-23,  5.950515303671602e-24, -7.983859955255544e-25,
  8.127701129225694e-26, -6.677116179446656e-27,  4.604645459893371e-28, -2.739467003562813e-29,  1.434536866135826e-30, -6.714168694199234e-32,  2.842875686188026e-33,
 -1.098355167913970e-34,  1.446719096210361e-23, -5.675554239225128e-24,  1.182047176696693e-24, -1.672990235023298e-25,  1.794393190864101e-26, -1.550891011680357e-27,
  1.123525362407459e-28, -7.011398631672462e-30,  3.845706488287657e-31, -1.882682498223039e-32,  8.326830144722765e-34, -3.355812336490520e-35,  3.096603338079701e-24,
 -1.266837954543804e-24,  2.761390139926146e-25, -4.089728271342851e-26,  4.585771238184801e-27, -4.138634024218199e-28,  3.126799433044944e-29, -2.032465029952560e-30,
  1.159754388238411e-31, -5.899614396918643e-33,  2.708226023162974e-34, -1.131466578427408e-35,  8.003399963830390e-25, -3.383809784723945e-25,  7.647418105735242e-26,
 -1.174302426817316e-26,  1.364241561317192e-27, -1.274483266461955e-28,  9.957555901706480e-30, -6.686898192480626e-31,  3.938180537659984e-32, -2.065715456590963e-33,
  9.769009071736942e-35, -4.200559544915361e-36,  2.414168695117339e-25, -1.044708945211279e-25,  2.422670155305244e-26, -3.817484953619140e-27,  4.548860716795800e-28,
 -4.355965729015730e-29,  3.486132785417166e-30, -2.396368747270172e-31,  1.443650307179882e-32, -7.740702825034365e-34,  3.739538183443051e-35, -1.641458646145728e-36,
  6.785492175499634e-26, -2.975048962517704e-26,  7.000563805772898e-27, -1.119395341821967e-27,  1.353211960463898e-28, -1.314169311303914e-29,  1.066219716922543e-30,
 -7.427129027464697e-32,  4.532351168484992e-33, -2.460759148798638e-34,  1.203292145786569e-35, -5.344102569415779e-37,  5.750423388570265e-02, -1.360590565204746e-04,
  3.321231625101719e-07, -8.329931604078036e-10,  2.134055481812002e-12, -5.558903361872555e-15,  1.462783374481328e-17, -3.884324285278391e-20,  1.032246190769612e-22,
 -2.765688725510069e-25,  7.329436886389014e-28, -1.982269584462180e-30,  5.239472713305576e-02, -1.454473945425378e-04,  4.826425055739890e-07, -1.700849450132570e-09,
  6.016337891915250e-12, -2.099455146082098e-14,  7.202700689003815e-17, -2.432917260100336e-19,  8.101364308342451e-22, -2.666313724927897e-24,  8.674999097714039e-27,
 -2.798590965770479e-29,  4.349709689078742e-02, -1.565012147814918e-04,  7.220866581612026e-07, -3.294628433289802e-09,  1.438190341351510e-11, -6.046129342394278e-14,
  2.467012747467646e-16, -9.823430960525909e-19,  3.831263071080059e-21, -1.467556343707477e-23,  5.532130860580182e-26, -2.055804439393724e-28,  3.290127422194580e-02,
 -1.591197665709730e-04,  9.538178418255354e-07, -5.270193325262535e-09,  2.723248220048781e-11, -1.340643197730749e-13,  6.353695786448873e-16, -2.917677169589964e-18,
  1.304223530815805e-20, -5.694778042624710e-23,  2.435637922477575e-25, -1.022583489026037e-27,  2.267453658873972e-02, -1.473254059644824e-04,  1.088019107378633e-06,
 -7.088550266270983e-09,  4.265309882344178e-11, -2.422369567550573e-13,  1.313714736572171e-15, -6.856688911872267e-18,  3.463872088419140e-20, -1.701039196792997e-22,
  8.147880586161600e-25, -3.816886755424614e-27,  1.423741369113011e-02, -1.222998045313274e-04,  1.078969563245523e-06, -8.183710849980866e-09,  5.670933251702408e-11,
 -3.673800098005692e-13,  2.255246988785719e-15, -1.324097360888009e-17,  7.485587334043088e-20, -4.095574445529272e-22,  2.177228039711823e-24, -1.128095808490793e-26,
  8.144921186130904e-03, -9.061409055835885e-05,  9.386668283456983e-07, -8.217908930990883e-09,  6.499654234847686e-11, -4.761468747720245e-13,  3.281623839044886e-15,
 -2.150685122328958e-17,  1.350675685749550e-19, -8.175573935912920e-22,  4.790971210331879e-24, -2.727719094814286e-26,  4.245287563625861e-03, -5.992837069569889e-05,
  7.214946196950135e-07, -7.240252327502337e-09,  6.488338069574103e-11, -5.338436823495475e-13,  4.104608858533557e-15, -2.984783546455904e-17,  2.070469085172508e-19,
 -1.378892343055672e-21,  8.860494654429541e-24, -5.515077629873309e-26,  2.016053241073266e-03, -3.544157894607809e-05,  4.925335993073992e-07, -5.631061413130090e-09,
  5.683690639420669e-11, -5.223610803613545e-13,  4.457855983555217e-15, -3.579542637330091e-17,  2.730055316469069e-19, -1.991668367288200e-21,  1.397424813941334e-23,
 -9.470293218188062e-26,  8.723588304219123e-04, -1.878503055784376e-05,  2.997819611796556e-07, -3.884110379966051e-09,  4.393996567554212e-11, -4.490746979792839e-13,
  4.236029534685376e-15, -3.741180648720655e-17,  3.125436207141653e-19, -2.488737470834455e-21,  1.900081870947851e-23, -1.397325317057901e-25,  3.439769053916999e-04,
 -8.943291689946997e-06,  1.631764288144031e-07, -2.384911326502125e-09,  3.011537808083152e-11, -3.409945959505078e-13,  3.542954425160467e-15, -3.430380230755535e-17,
  3.129327576695351e-19, -2.711747072089429e-21,  2.246365893700916e-23, -1.787699828475656e-25,  1.236155316641837e-04, -3.832375602719117e-06,  7.962946263983993e-08,
 -1.307602420600802e-09,  1.836674140576254e-11, -2.296810345748990e-13,  2.620916124718169e-15, -2.774373597212008e-17,  2.756444439793079e-19, -2.592959137582151e-21,
  2.325014700672576e-23, -1.997675743416934e-25,  4.049763013199296e-05, -1.480968964763148e-06,  3.491337607730132e-08, -6.418903613911096e-10,  9.999180783498049e-12,
 -1.377293047812304e-13,  1.721826678681670e-15, -1.988059924951271e-17,  2.146524335180194e-19, -2.187361013612315e-21,  2.118728966880629e-23, -1.961627048937189e-25,
  1.209893338594182e-05, -5.170027851674475e-07,  1.378044727720389e-08, -2.827899671233689e-10,  4.872974760741088e-12, -7.376064031977338e-14,  1.008105927822951e-15,
 -1.267125242068528e-17,  1.484023897617459e-19, -1.635291197502305e-21,  1.708196770112204e-23, -1.701412764339583e-25,  3.297852258056637e-06, -1.633186143960067e-07,
  4.905662290715559e-09, -1.120592346386584e-10,  2.131206278961535e-12, -3.538023992208012e-14,  5.276859937658416e-16, -7.208323004642480e-18,  9.142943452284112e-20,
 -1.087826320479417e-21,  1.223680038054704e-23, -1.309394746563990e-25,  8.206553932992101e-07, -4.676222998727111e-08,  1.577965287320522e-09, -4.002595844334431e-11,
  8.385065292176368e-13, -1.524042996321815e-14,  2.476685799357145e-16, -3.671587639657238e-18,  5.036805427112533e-20, -6.462464303413741e-22,  7.818923342225444e-24,
 -8.977908053099435e-26,  1.865980074098305e-07, -1.215674929418503e-08,  4.595055885763095e-10, -1.291460698072848e-11,  2.974894885689684e-13, -5.911060909482935e-15,
  1.045243586506529e-16, -1.679557455986673e-18,  2.489160872489092e-20, -3.440338868919224e-22,  4.472482698900171e-24, -5.505257331086385e-26,  3.881110810060499e-08,
 -2.874795985719108e-09,  1.213846556736037e-10, -3.772615962275685e-12,  9.540742854389531e-14, -2.069706668532841e-15,  3.977760484321035e-17, -6.920828372185573e-19,
  1.107020986957612e-20, -1.646715581977421e-22,  2.298233735758775e-24, -3.030180066854516e-26,  7.394995391670743e-09, -6.196747011453144e-10,  2.915381605462417e-11,
 -1.000188995749843e-12,  2.773103686326305e-14, -6.560318824286527e-16,  1.368988266364749e-17, -2.576766669003611e-19,  4.444877279269481e-21, -7.110643282938365e-23,
  1.064640909374156e-24, -1.502541360989358e-26,  1.293185455484626e-09, -1.220460931209287e-10,  6.382586660142722e-12, -2.413105816347640e-13,  7.325894711488392e-15,
 -1.888033280409316e-16,  4.274187240527437e-18, -8.696695718879427e-20,  1.616692338866331e-21, -2.779634553181471e-23,  4.462134849546053e-25, -6.737035566308179e-27,
  2.080432052905084e-10, -2.202455596076744e-11,  1.277485846535786e-12, -5.314581348316135e-14,  1.764653547596710e-15, -4.949991193881689e-17,  1.214753966400698e-18,
 -2.670112391246758e-20,  5.346102094791590e-22, -9.873638204084250e-24,  1.698546827771209e-25, -2.742215663451171e-27,  3.088282999446603e-11, -3.654029823143884e-12,
  2.345807240483988e-13, -1.072318512360421e-14,  3.890143631360489e-16, -1.186724742414355e-17,  3.154868463370834e-19, -7.487102550478549e-21,  1.613753622721842e-22,
 -3.200069847155773e-24,  5.896890395156975e-26, -1.017589113889888e-27,  4.246074933047935e-12, -5.596042067168439e-13,  3.968419291267448e-14, -1.990612285788820e-15,
  7.882315735782477e-17, -2.613048773392249e-18,  7.520715777736196e-20, -1.926011965112450e-21,  4.466876931634764e-23, -9.506819985317468e-25,  1.875874141479455e-26,
 -3.458824620425187e-28,  5.432666135942679e-13, -7.950187880371169e-14,  6.216018766929246e-15, -3.417116826024670e-16,  1.475511016848378e-17, -5.311654470604997e-19,
  1.654126143808468e-20, -4.569041411056287e-22,  1.139752824615670e-23, -2.602500181336075e-25,  5.496904855043332e-27, -1.082631590355787e-28,  6.506462066551029e-14,
 -1.054091765228236e-14,  9.070157947348083e-16, -5.457435476553963e-17,  2.567313880685604e-18, -1.002870093732862e-19,  3.377203608550671e-21, -1.005679455182367e-22,
  2.697147201005327e-24, -6.605006489438077e-26,  1.492842019886643e-27, -3.139610176384418e-29,  7.347668487559149e-15, -1.313965651979370e-15,  1.242015411946160e-16,
 -8.168916967069999e-18,  4.182537374302491e-19, -1.771544631176502e-20,  6.447158133894966e-22, -2.068660822062125e-23,  5.962065386856972e-25, -1.565229093290465e-26,
  3.784168648757667e-28, -8.495289964459638e-30,  7.894752328207168e-16, -1.553837479958411e-16,  1.610417338896664e-17, -1.156232634108456e-18,  6.436457541599465e-20,
 -2.953499461914368e-21,  1.160779617624160e-22, -4.010752573540256e-24,  1.241546848400534e-25, -3.492579367495703e-27,  9.028086950874473e-29, -2.162530415804865e-30,
  8.160567003601547e-17, -1.762441220648160e-17,  1.998803666695063e-18, -1.564202906059848e-19,  9.455850467930637e-21, -4.696096035260512e-22,  1.991487488155922e-23,
 -7.404308708886447e-25,  2.460138177484941e-26, -7.410985147013313e-28,  2.047058730844245e-29, -5.228926381890529e-31,  8.225674197290618e-18, -1.943164983432854e-18,
  2.406217488323465e-19, -2.048938916654931e-20,  1.343159788083962e-21, -7.210825209083979e-23,  3.296032167795628e-24, -1.317388014057741e-25,  4.694022036906405e-27,
 -1.512999745080146e-28,  4.462321394904398e-30, -1.214596657243528e-31,  8.219017375791145e-19, -2.116388443271852e-19,  2.854362055860086e-20, -2.639347558087004e-21,
  1.872999379765384e-22, -1.085318038013561e-23,  5.339936474550227e-25, -2.291549948409062e-26,  8.746006723248359e-28, -3.013017385360758e-29,  9.478368501564786e-31,
 -2.746308243474498e-32,  8.302826957463599e-20, -2.321451047081658e-20,  3.400175536882621e-21, -3.405820819602103e-22,  2.610798689264285e-23, -1.629726391891193e-24,
  8.615780787828092e-26, -3.963141486958712e-27,  1.617672810850094e-28, -5.947498158843039e-30,  1.992761726061760e-31, -6.137783793130424e-33,  8.680262040252862e-21,
 -2.623733243293847e-21,  4.159018042129737e-22, -4.499265545311857e-23,  3.715610388408594e-24, -2.492379593905477e-25,  1.412499447196574e-26, -6.949210371789384e-28,
  3.027288081084514e-29, -1.185449871015463e-30,  4.222388165270917e-32, -1.379882215369671e-33,  9.650143483762638e-22, -3.137542945499293e-22,  5.360259580331538e-23,
 -6.239556401507577e-24,  5.532171990334620e-25, -3.974998480920134e-26,  2.407673978941286e-27, -1.263290107481267e-28,  5.857298869979006e-30, -2.436497275387258e-31,
  9.202078777011627e-33, -3.182866116263302e-34,  1.176444128155377e-22, -4.090545054698240e-23,  7.494119901965682e-24, -9.343426211536093e-25,  8.855895435857671e-26,
 -6.788358904486337e-27,  4.377544611072686e-28, -2.440530657846201e-29,  1.200068550884484e-30, -5.284679730133734e-32,  2.109287069175182e-33, -7.696765718579763e-35,
  1.626012436146448e-23, -6.006178841488137e-24,  1.172872210698837e-24, -1.557368410963872e-25,  1.569530296354707e-26, -1.276935438698109e-27,  8.723859953104217e-29,
 -5.143525859380109e-30,  2.670131621899760e-31, -1.239299996654918e-32,  5.205181761462992e-34, -1.995475276041674e-35,  2.635303607333803e-24, -1.026306176637087e-24,
  2.120810689840270e-25, -2.978538076143285e-26,  3.170788114370392e-27, -2.720702945498193e-28,  1.957244566405077e-29, -1.213218701689519e-30,  6.611330066988251e-32,
 -3.216397720774568e-33,  1.414000424211141e-34, -5.665568864520876e-36,  5.157584772709853e-25, -2.099721199103868e-25,  4.552703189124265e-26, -6.707444462528074e-27,
  7.482675344907164e-28, -6.719782806432809e-29,  5.052729416179241e-30, -3.269265310865684e-31,  1.857228479334080e-32, -9.407272188736870e-34,  4.300624624400643e-35,
 -1.789626159799607e-36,  1.236886757570059e-25, -5.214608026065132e-26,  1.174818258098735e-26, -1.798382774959240e-27,  2.082920106404808e-28, -1.940148886395782e-29,
  1.511526063787798e-30, -1.012259420643571e-31,  5.945772038714275e-33, -3.110774944393500e-34,  1.467481132274788e-35, -6.294957856734348e-37,  3.529550257215697e-26,
 -1.525307007137515e-26,  3.531851526847669e-27, -5.556885952141079e-28,  6.611748963293368e-29, -6.322304454052074e-30,  5.052787088740072e-31, -3.468613198161164e-32,
  2.086883001383966e-33, -1.117554100310821e-34,  5.392321726147220e-36, -2.364154420366181e-37,  9.605378117560207e-27, -4.209339185558899e-27,  9.899500886144559e-28,
 -1.582056205265200e-28,  1.911460505552735e-29, -1.855310281137566e-30,  1.504467826372913e-31, -1.047450598745322e-32,  6.388780114371414e-34, -3.466974499609317e-35,
  1.694513327407236e-36, -7.522232086167128e-38,  5.696524913123189e-02, -1.334414827564168e-04,  3.223285058288053e-07, -7.997189857296642e-10,  2.026301888944217e-12,
 -5.220522423007073e-15,  1.358501015758296e-17, -3.569386674347001e-20,  9.377548222113406e-23, -2.489253789754554e-25,  6.509056738590509e-28, -1.752265707267091e-30,
  5.182053283937215e-02, -1.416662901404399e-04,  4.627963222440721e-07, -1.607855513424474e-09,  5.613196330713241e-12, -1.934480621823055e-14,  6.556381347669411e-17,
 -2.188385210802143e-19,  7.201094888019033e-22, -2.342730049725557e-24,  7.532973036716369e-27, -2.403146833651728e-29,  4.288240043049495e-02, -1.508788416598229e-04,
  6.838928923358971e-07, -3.073879195924021e-09,  1.322972747816512e-11, -5.485714958846738e-14,  2.208355952175831e-16, -8.677857975717253e-19,  3.340687528567316e-21,
 -1.263345714194268e-23,  4.702422389664503e-26, -1.725789883151534e-28,  3.227966590166319e-02, -1.517349844102752e-04,  8.931039676599374e-07, -4.855122330715450e-09,
  2.469730314484980e-11, -1.197504578922069e-13,  5.592222509406850e-16, -2.531331813325833e-18,  1.115715810476163e-20, -4.804850653673336e-23,  2.027299906469850e-25,
 -8.398265002480695e-28,  2.210212044776213e-02, -1.389502592609048e-04,  1.006896701324721e-06, -6.443208606701095e-09,  3.810872436548698e-11, -2.128918382545516e-13,
  1.136368005198899e-15, -5.840253797665028e-18,  2.906330334549344e-20, -1.406376494769370e-22,  6.639852124083770e-25, -3.066578211641685e-27,  1.376487708747406e-02,
 -1.140459811255116e-04,  9.859758512538129e-07, -7.332322842204634e-09,  4.987430427886214e-11, -3.174454161295720e-13,  1.915933073790651e-15, -1.106560721960745e-17,
  6.156676223763652e-20, -3.316385420807686e-22,  1.736310440778455e-24, -8.862735166924973e-27,  7.796882970369353e-03, -8.348223342407812e-05,  8.459906548627289e-07,
 -7.250064809902902e-09,  5.621483041067971e-11, -4.041517290547751e-13,  2.735768355767420e-15, -1.762084142419912e-17,  1.088141496372312e-19, -6.479283901246357e-22,
  3.736555354081379e-24, -2.094262028326954e-26,  4.016591623123846e-03, -5.448707559645232e-05,  6.405046521373472e-07, -6.282452061640775e-09,  5.512760148019701e-11,
 -4.446567952776181e-13,  3.354625429569277e-15, -2.395265213463328e-17,  1.632418769636396e-19, -1.068635456292916e-21,  6.752722744784347e-24, -4.134826835901060e-26,
  1.881760326364855e-03, -3.175689930533354e-05,  4.300903869003895e-07, -4.799759463409799e-09,  4.738322041132965e-11, -4.264751983944267e-13,  3.567836009525807e-15,
 -2.810622252021069e-17,  2.104375798700764e-19, -1.507937977186171e-21,  1.039716637355264e-23, -6.927093447179419e-26,  8.017360433267256e-04, -1.656190889106306e-05,
  2.571114505897668e-07, -3.247735936855474e-09,  3.589577652562876e-11, -3.589280223716904e-13,  3.316029513457757e-15, -2.870847250435426e-17,  2.352669181280390e-19,
 -1.838815578467381e-21,  1.378685475605889e-23, -9.961450175383957e-26,  3.106442251115861e-04, -7.744654458628654e-06,  1.372376324918366e-07, -1.953311711250156e-09,
  2.407348092084162e-11, -2.664425664977109e-13,  2.709118531959674e-15, -2.569279971751486e-17,  2.297514747832484e-19, -1.952881404744096e-21,  1.587706291547078e-23,
 -1.240687260233457e-25,  1.094673418734710e-04, -3.253437217000812e-06,  6.556024124292272e-08, -1.047313081863188e-09,  1.434402509353410e-11, -1.751844488438263e-13,
  1.954733695636871e-15, -2.025305786019568e-17,  1.971153364865218e-19, -1.817664386825083e-21,  1.598644388687254e-23, -1.348001540341838e-25,  3.508716559215276e-05,
 -1.229948563537534e-06,  2.808649930901625e-08, -5.018710720507603e-10,  7.616466582964084e-12, -1.023764675357139e-13,  1.250571341383694e-15, -1.412359020321168e-17,
  1.492875329776674e-19, -1.490391362302340e-21,  1.415224622234414e-23, -1.285235887026455e-25,  1.023165084245979e-05, -4.191118137060095e-07,  1.081004166990061e-08,
 -2.154211321892959e-10,  3.613527561524660e-12, -5.333703618518565e-14,  7.118066015109493e-16, -8.745807050700896e-18,  1.002167818691720e-19, -1.081312320371920e-21,
  1.106735879975748e-23, -1.080753118977834e-25,  2.715304619538334e-06, -1.289220966850061e-07,  3.744251132421584e-09, -8.299577756371959e-11,  1.535464181172121e-12,
 -2.484023126702084e-14,  3.615394252985103e-16, -4.824930618780297e-18,  5.984548820743702e-20, -6.968614209131809e-22,  7.677221806005455e-24, -8.050636875580761e-26,
  6.561058361114205e-07, -3.585290824461658e-08,  1.169049703060455e-09, -2.875729524561327e-11,  5.856685700280746e-13, -1.036742230798363e-14,  1.643209002233632e-16,
 -2.378653626884608e-18,  3.189440907522147e-20, -4.003192540395171e-22,  4.741601615089574e-24, -5.333465289195133e-26,  1.444450056822875e-07, -9.027861142220397e-09,
  3.295894189406149e-10, -8.978750490016221e-12,  2.009656371682176e-13, -3.887117049713724e-15,  6.700746283954149e-17, -1.050905117354462e-18,  1.521681331816018e-20,
 -2.056615027584423e-22,  2.616458469258541e-24, -3.153942840328531e-26,  2.900023643500484e-08, -2.061692455837870e-09,  8.405798126337362e-11, -2.531313018281702e-12,
  6.217603030573777e-14, -1.312456527855348e-15,  2.458036673708740e-17, -4.172631330657118e-19,  6.518671022350967e-21, -9.478990887187181e-23,  1.294256299441898e-24,
 -1.670646915489359e-26,  5.316209843455939e-09, -4.278026917205546e-10,  1.943250535339240e-11, -6.457974568702166e-13,  1.738556459102148e-14, -4.000819617399604e-16,
  8.133279214622149e-18, -1.493197651917747e-19,  2.514980353020616e-21, -3.931998575099187e-23,  5.758213222885802e-25, -7.954397527796804e-27,  8.912587135835740e-10,
 -8.083015551492152e-11,  4.081556944853296e-12, -1.494647451364187e-13,  4.405087450745307e-15, -1.104122196033609e-16,  2.434518863299988e-18, -4.830616331107497e-20,
  8.766479871416217e-22, -1.472780202873877e-23,  2.312076390148901e-25, -3.416337659885982e-27,  1.369356799173410e-10, -1.394176501097591e-11,  7.809848476505848e-13,
 -3.147050678818460e-14,  1.014388829931701e-15, -2.767105196895881e-17,  6.613293035406057e-19, -1.417432797569738e-20,  2.770232981048340e-22, -4.998832351480436e-24,
  8.408964017426376e-26, -1.328522308650714e-27,  1.933362089252280e-11, -2.201965943888939e-12,  1.365759503970236e-13, -6.048317889222787e-15,  2.130225549475891e-16,
 -6.319803457317383e-18,  1.636249779323612e-19, -3.786407723178047e-21,  7.966314453046767e-23, -1.543453101761985e-24,  2.781214016431165e-26, -4.696707880644726e-28,
  2.517054382270361e-12, -3.196553282274748e-13,  2.191303619405598e-14, -1.065248535456306e-15,  4.096100774480283e-17, -1.320793998321659e-18,  3.702743801575403e-20,
 -9.247460536027782e-22,  2.093744070655385e-23, -4.354281163205991e-25,  8.402531861432750e-27, -1.516332522659196e-28,  3.035001959579423e-13, -4.284866120012072e-14,
  3.240955181736570e-15, -1.727524484781405e-16,  7.246570314455788e-18, -2.538242252896220e-19,  7.701444340306692e-21, -2.075100335913184e-22,  5.054576964960141e-24,
 -1.128044267933645e-25,  2.330645361300635e-27, -4.493607714674233e-29,  3.408141767246900e-14, -5.334002827069606e-15,  4.444138305364746e-16, -2.594588664724678e-17,
  1.186405480495951e-18, -4.511551045911269e-20,  1.480913182301599e-21, -4.303459497760489e-23,  1.127424982923799e-24, -2.699448129017480e-26,  5.970226581959244e-28,
 -1.229587018384620e-29,  3.589152399528319e-15, -6.210023494386120e-16,  5.690052770163740e-17, -3.634538300431836e-18,  1.810211010245607e-19, -7.468963059832916e-21,
  2.651140763155429e-22, -8.305878120696693e-24,  2.339645153262667e-25, -6.008579488196526e-27,  1.422177896967382e-28, -3.128077895732922e-30,  3.575719262769347e-16,
 -6.820953926959665e-17,  6.861686137126791e-18, -4.789743206336536e-19,  2.596194698281193e-20, -1.161509904879763e-21,  4.455931766686306e-23, -1.504424143408436e-24,
  4.554819448841804e-26, -1.254262005651060e-27,  3.176216272223628e-29, -7.458777010170671e-31,  3.406737295173506e-17, -7.144697331464840e-18,  7.877008783012716e-19,
 -6.001159218961291e-20,  3.536551055285664e-21, -1.714276765087213e-22,  7.103288477774381e-24, -2.583039747872420e-25,  8.401524466099167e-27, -2.479592201083058e-28,
  6.715296949993578e-30, -1.683008108017966e-31,  3.145871667958814e-18, -7.232008777319830e-19,  8.721210140609430e-20, -7.241041390658987e-21,  4.633962341637177e-22,
 -2.431320765788860e-23,  1.087219938287934e-24, -4.255058811372589e-26,  1.485819658072916e-27, -4.697022950301751e-29,  1.359613997112233e-30, -3.634563697063050e-32,
  2.862361490931862e-19, -7.189565135491439e-20,  9.462038441106280e-21, -8.546518521342457e-22,  5.930691990523269e-23, -3.363794849277154e-24,  1.621471847672537e-25,
 -6.822880547221699e-27,  2.555341974372758e-28, -8.644740609361816e-30,  2.672286286551626e-31, -7.613338704923379e-33,  2.618158088645941e-20, -7.158895965983701e-21,
  1.025505557550033e-21, -1.005476312489782e-22,  7.551446981940012e-24, -4.622277748132147e-25,  2.398135869284104e-26, -1.083389630369427e-27,  4.346167370617623e-29,
 -1.571463127025497e-30,  5.181359660051751e-32, -1.571358367578449e-33,  2.466141654942868e-21, -7.310001024857585e-22,  1.136114731806996e-22, -1.205839633673628e-23,
  9.777415700235108e-25, -6.444345102899356e-26,  3.591134674630365e-27, -1.738388336148853e-28,  7.455960137346214e-30, -2.876237414859443e-31,  1.009784670972391e-32,
 -3.254424991288249e-34,  2.461173382024951e-22, -7.869933251974561e-23,  1.321825712745134e-23, -1.513417356805753e-24,  1.320640707343211e-25, -9.345040056505567e-27,
  5.577741285525713e-28, -2.885545886470577e-29,  1.319836229357973e-30, -5.418839540624161e-32,  2.020929592238793e-33, -6.905787708532422e-35,  2.688919665504304e-23,
 -9.222686125354682e-24,  1.665884052541642e-24, -2.048441789123114e-25,  1.915807455236131e-26, -1.449787624710111e-27,  9.234302257188298e-29, -5.087405556023070e-30,
  2.473154028302894e-31, -1.077161806944835e-32,  4.253920968392621e-34, -1.536481010502748e-35,  3.334594251800039e-24, -1.218654466081584e-24,  2.353170167112251e-25,
 -3.090343471227034e-26,  3.081430748794531e-27, -2.481340702093950e-28,  1.678523688697715e-29, -9.802620926944787e-31,  5.042322773728823e-32, -2.319732820284047e-33,
  9.660521745722245e-35, -3.673284651481429e-36,  4.873299880067218e-25, -1.883090899805119e-25,  3.858949127498229e-26, -5.375206204552467e-27,  5.676635205733755e-28,
 -4.833446492685066e-29,  3.451393627489501e-30, -2.124128978268184e-31,  1.149575357894220e-32, -5.555647873742974e-34,  2.426808132678799e-35, -9.663988158135075e-37,
  8.683515830125065e-26, -3.516704013392852e-26,  7.581974115055644e-27, -1.110793206624062e-27,  1.232433341906936e-28, -1.100958007603586e-29,  8.236283477361787e-31,
 -5.303038167593280e-32,  2.998378445092483e-33, -1.511839146374050e-34,  6.881218030722404e-36, -2.851416890726857e-37,  1.924372063137650e-26, -8.088131162612527e-27,
  1.816092586534014e-27, -2.770756646449922e-28,  3.198705435555733e-29, -2.970068512807989e-30,  2.306870241177190e-31, -1.540357672557015e-32,  9.022049140170282e-34,
 -4.707346303111047e-35,  2.214789613908016e-36, -9.476505714795862e-38,  5.177380927786339e-27, -2.234165263383972e-27,  5.164877303974750e-28, -8.113141330579941e-29,
  9.638046134511342e-30, -9.202007136258217e-31,  7.343335210342282e-32, -5.033779731908825e-33,  3.024355411434969e-34, -1.617407630668204e-35,  7.794029934584955e-37,
 -3.412851699499675e-38,  1.361375532674209e-27, -5.962821284184220e-28,  1.401516050981208e-28, -2.238470204392565e-29,  2.702979054197772e-30, -2.622085919517025e-31,
  2.125063824843422e-32, -1.478724270577109e-33,  9.014508112335515e-35, -4.889347967559577e-36,  2.388510308611177e-37, -1.059782585669712e-38,  5.643658044543751e-02,
 -1.309006978887521e-04,  3.129230139056609e-07, -7.681160580502536e-10,  1.925072607213481e-12, -4.906144330571824e-15,  1.262628109111841e-17, -3.283155447797264e-20,
  8.526479509551960e-23, -2.243705682129319e-25,  5.782801558469955e-28, -1.553770544829064e-30,  5.126115234033498e-02, -1.380395986965349e-04,  4.440284267183807e-07,
 -1.521056083388471e-09,  5.241552329943485e-12, -1.784227642142672e-14,  5.974666802549304e-17, -1.970882813126421e-19,  6.409495523517845e-22, -2.061530603901632e-24,
  6.551446045892112e-27, -2.067343293067337e-29,  4.228959870790354e-02, -1.455517277887649e-04,  6.482411008523792e-07, -2.870700779837673e-09,  1.218367758465105e-11,
 -4.983699902363355e-14,  1.979683533414295e-16, -7.678119817579406e-19,  2.917987940612546e-21, -1.089592496863881e-23,  4.005178102366806e-26, -1.451860374849929e-28,
  3.168665588781757e-02, -1.448166582741421e-04,  8.371367035045456e-07, -4.478419720217308e-09,  2.243096818748446e-11, -1.071408511433720e-13,  4.930940818875723e-16,
 -2.200483105101990e-18,  9.564893990607481e-21, -4.063245226264053e-23,  1.691522070659258e-25, -6.915059079204025e-28,  2.156195429300017e-02, -1.311943083272431e-04,
  9.331007794962491e-07, -5.866103653731900e-09,  3.411089415619329e-11, -1.874807397312803e-13,  9.851352006639386e-16, -4.986362047712525e-18,  2.444760412732567e-20,
 -1.165916047444732e-22,  5.426493536015900e-25, -2.471221734486677e-27,  1.332393005545624e-02, -1.064970267936050e-04,  9.025742107889545e-07, -6.582728339606978e-09,
  4.396122853012931e-11, -2.749690115806873e-13,  1.631974478871647e-15, -9.273817274327056e-18,  5.078934230488702e-20, -2.693987445395808e-22,  1.389323973597509e-24,
 -6.987339229461288e-27,  7.475959687013894e-03, -7.704761280038793e-05,  7.641308747129237e-07, -6.411885295676269e-09,  4.875036184369666e-11, -3.440409835493638e-13,
  2.287822623145252e-15, -1.448485932276737e-17,  8.797089102079170e-20, -5.153865382649364e-22,  2.925443824301098e-24, -1.614385653306589e-26,  3.808434241192053e-03,
 -4.965024991914554e-05,  5.701275751434259e-07, -5.467398940640465e-09,  4.698815739733027e-11, -3.716373611673442e-13,  2.751652111932906e-15, -1.929567598860500e-17,
  1.292243058745250e-19, -8.316853057186478e-22,  5.169010023523789e-24, -3.114188354968778e-26,  1.761266770634934e-03, -2.853429571897626e-05,  3.767749599172674e-07,
 -4.105466006758890e-09,  3.964998197124300e-11, -3.495773139239803e-13,  2.867516355561902e-15, -2.216612990470010e-17,  1.629571466612462e-19, -1.147176060994852e-21,
  7.774279678467743e-24, -5.092988266818357e-26,  7.393684615323018e-04, -1.465166373461746e-05,  2.213610167505461e-07, -2.726766640261728e-09,  2.945210265904467e-11,
 -2.881961986289867e-13,  2.608352110595040e-15, -2.214067312774047e-17,  1.780232479924341e-19, -1.365982574547740e-21,  1.005969220144354e-23, -7.142490830754052e-26,
  2.817216954727413e-04, -6.734347571475992e-06,  1.159439032752736e-07, -1.607464576238227e-09,  1.934057985184946e-11, -2.092865500671682e-13,  2.082895508802359e-15,
 -1.935297732725533e-17,  1.696751867006363e-19, -1.414936032955057e-21,  1.129202831796142e-23, -8.665961158051202e-26,  9.742813785987940e-05, -2.775575367742055e-06,
  5.426164816916363e-08, -8.434699381912309e-10,  1.126698057697457e-11, -1.344194200215202e-13,  1.466935526016574e-15, -1.487966418330572e-17,  1.418900477276821e-19,
 -1.282837264482900e-21,  1.106862754661436e-23, -9.161025622124431e-26,  3.058134526286522e-05, -1.027420349190269e-06,  2.273259586580628e-08, -3.948824396457832e-10,
  5.839634951097057e-12, -7.661438555453505e-14,  9.146448727822855e-16, -1.010577984625456e-17,  1.045924444888328e-19, -1.023164339572945e-21,  9.526058477394101e-24,
 -8.487046122530096e-26,  8.713080077604040e-06, -3.420642454605419e-07,  8.539478207507211e-09, -1.652875939408213e-10,  2.699515575627224e-12, -3.886301460429292e-14,
  5.065282568184656e-16, -6.084776771612821e-18,  6.823061966461652e-20, -7.209711993161420e-22,  7.231509059537045e-24, -6.924480186798346e-26,  2.253760008220438e-06,
 -1.025691460853345e-07,  2.880722210813999e-09, -6.197365762828733e-11,  1.115513300521986e-12, -1.758928165559419e-14,  2.498662726896573e-16, -3.258300034175633e-18,
  3.952648087980287e-20, -4.505155272904611e-22,  4.861596989091103e-24, -4.996752180533244e-26,  5.294191902928051e-07, -2.773602984917074e-08,  8.739807091258190e-10,
 -2.085183963249396e-11,  4.129063132177726e-13, -7.119730970475985e-15,  1.100773568524043e-16, -1.556158806695569e-18,  2.039760084751373e-20, -2.504823727565653e-22,
  2.904826674496909e-24, -3.201201051360624e-26,  1.129946467950771e-07, -6.772849825060727e-09,  2.388295255898584e-10, -6.306956982640057e-12,  1.371794047838262e-13,
 -2.583198995899644e-15,  4.341588365043735e-17, -6.646651547111162e-19,  9.404044650340844e-21, -1.243004269387346e-22,  1.547720186217142e-24, -1.827203210678523e-26,
  2.192750012784664e-08, -1.495624568870785e-09,  5.887881559484952e-11, -1.718022181630569e-12,  4.098947067870025e-14, -8.419851409795714e-16,  1.536804770300536e-17,
 -2.545542325164990e-19,  3.884346014057014e-21, -5.522013275938006e-23,  7.376884952363175e-25, -9.323106740366436e-27,  3.872791769197739e-09, -2.991577194015296e-10,
  1.311872706565462e-11, -4.223089650532389e-13,  1.103923342412384e-14, -2.471249991567681e-16,  4.894359222298935e-18, -8.764883944764817e-20,  1.441515005290686e-21,
 -2.202675205878442e-23,  3.155202387451340e-25, -4.266425559355667e-27,  6.233774190799919e-10, -5.430309680864200e-11,  2.647147962401659e-12, -9.388323256078088e-14,
  2.686084039775274e-15, -6.547736843357373e-17,  1.406179934337386e-18, -2.720971550484198e-20,  4.820622805619960e-22, -7.913632967550799e-24,  1.214946714691264e-25,
 -1.756935089970997e-27,  9.161301149719878e-11, -8.965617509588952e-12,  4.849211093729867e-13, -1.892412016948606e-14,  5.920870741271873e-16, -1.570562853948420e-17,
  3.655409538548548e-19, -7.639232231506081e-21,  1.457331121200771e-22, -2.569291156995226e-24,  4.226223023945549e-26, -6.533907072664096e-28,  1.232198656034098e-11,
 -1.350115320880706e-12,  8.087906988584465e-14, -3.469211996390608e-15,  1.186048263920040e-16, -3.421535660362629e-18,  8.626587313072047e-20, -1.946372037543046e-21,
  3.996969560416119e-23, -7.565749323763486e-25,  1.333041610784405e-26, -2.202861556908245e-28,  1.521512683608405e-12, -1.860742410138599e-13,  1.232585157137265e-14,
 -5.805221895674429e-16,  2.167171547468097e-17, -6.795923885953027e-19,  1.855435629854611e-20, -4.518391839143599e-22,  9.985898469521061e-24, -2.029046160178094e-25,
  3.828814669486874e-27, -6.761820543007143e-29,  1.731773128108436e-13, -2.357125809251987e-14,  1.723903870886213e-15, -8.906560274617226e-17,  3.628404098553402e-18,
 -1.236290810799693e-19,  3.653969505234605e-21, -9.601895956590515e-23,  2.283414978839458e-24, -4.979834915597763e-26,  1.006281254562227e-27, -1.899020889806100e-29,
  1.826294568678173e-14, -2.759193347142614e-15,  2.224722201231584e-16, -1.259718080565781e-17,  5.596962005406987e-19, -2.071253726535841e-20,  6.625285392109987e-22,
 -1.878305608318667e-23,  4.805709365992617e-25, -1.124778010988905e-26,  2.433697117572060e-28, -4.907433228915008e-30,  1.796285858183021e-15, -3.004635989472922e-16,
  2.667011055949834e-17, -1.653598325851007e-18,  8.007974363841813e-20, -3.217384985094153e-21,  1.113470633512835e-22, -3.405046877711427e-24,  9.371612619597259e-26,
 -2.353719154192335e-27,  5.452689081677452e-29, -1.174735207205235e-30,  1.661616804073270e-16, -3.069385066714342e-17,  2.994949828283768e-18, -2.031376778119183e-19,
  1.071556996328522e-20, -4.671928809521639e-22,  1.748766971735621e-23, -5.767010594724045e-25,  1.707095906567960e-26, -4.600032390458897e-28,  1.140813662971630e-29,
 -2.625604938573232e-31,  1.460860088069272e-17, -2.972402688935988e-18,  3.183309033118181e-19, -2.359491677892365e-20,  1.354710894799725e-21, -6.405928293247837e-23,
  2.592310095925279e-24, -9.215667876307529e-26,  2.933065632436903e-27, -8.477660089714173e-29,  2.250229025037399e-30, -5.531323836412794e-32,  1.236911044048517e-18,
 -2.764536766535041e-19,  3.243996136317338e-20, -2.624357198247976e-21,  1.638497420559564e-22, -8.396732832166113e-24,  3.671264915204308e-25, -1.406200392226673e-26,
  4.809806955648956e-28, -1.490559241372520e-29,  4.232774464899712e-31, -1.110830185683616e-32,  1.025302696384162e-19, -2.509625317063078e-20,  3.220241208524763e-21,
 -2.839071791796592e-22,  1.925143291187948e-23, -1.068097413097162e-24,  5.041154017827444e-26, -2.078778289177904e-27,  7.635877935052566e-29, -2.535443562686873e-30,
  7.697959401581029e-32, -2.155486107005674e-33,  8.490782847810072e-21, -2.268241359102498e-21,  3.175043691278086e-22, -3.044729989503164e-23,  2.238684706056200e-24,
 -1.342780543055042e-25,  6.832529021140739e-27, -3.029672917569960e-28,  1.193823146904624e-29, -4.242837030422435e-31,  1.375910331957917e-32, -4.106603469400179e-34,
  7.200299233267221e-22, -2.090967746572095e-22,  3.183491283468800e-23, -3.312338012763867e-24,  2.635038800179898e-25, -1.705318687295420e-26,  9.337892691988973e-28,
 -4.444877173955519e-29,  1.875846259804664e-30, -7.124676509478791e-32,  2.464137037717429e-33, -7.827969027090527e-35,  6.440469251140412e-23, -2.023613883081585e-23,
  3.338629922557207e-24, -3.756851839903081e-25,  3.224115026564989e-26, -2.245215708295598e-27,  1.319668530716120e-28, -6.727089379973451e-30,  3.033607651155898e-31,
 -1.228621982338113e-32,  4.522248090788544e-34, -1.525889110947942e-35,  6.290583799101773e-24, -2.126605355855876e-24,  3.784252244165960e-25, -4.585947837260477e-26,
  4.229163781700422e-27, -3.157471523596689e-28,  1.985183605671523e-29, -1.080123005831915e-30,  5.188185948512874e-32, -2.233719876029470e-33,  8.723799025823359e-35,
 -3.117423750466286e-36,  6.976405523390530e-25, -2.520760312027370e-25,  4.809785241067446e-26, -6.243190347489854e-27,  6.155295810450108e-28, -4.902990721629000e-29,
  3.282161654097715e-30, -1.897604924889434e-31,  9.666978124526981e-33, -4.406074030436584e-34,  1.818517038135289e-35, -6.855260390217208e-37,  9.156581465423335e-26,
 -3.508699135175172e-26,  7.126478008539164e-27, -9.839951683106848e-28,  1.030382632017943e-28, -8.701721685631902e-30,  6.164748796980764e-31, -3.765328476761949e-32,
  2.022944765944807e-33, -9.707868997403230e-35,  4.211916563774893e-36, -1.666362826518814e-37,  1.478887546592642e-26, -5.955693274934548e-27,  1.276268913181101e-27,
 -1.858599836696224e-28,  2.050138934954640e-29, -1.821142087514261e-30,  1.355019748827856e-31, -8.678944979291032e-33,  4.882477433729926e-34, -2.449917429489757e-35,
  1.109890746526851e-36, -4.578499269841137e-38,  3.015468998014818e-27, -1.263222894546973e-27,  2.826196748693119e-28, -4.296411538284285e-29,  4.942711875338568e-30,
 -4.573933683717244e-31,  3.541030349236524e-32, -2.357010382406465e-33,  1.376345793551750e-34, -7.160251176313471e-36,  3.359384681040198e-37, -1.433498746842855e-38,
  7.621518651055060e-28, -3.283726538733477e-28,  7.578098550119578e-29, -1.188335429632812e-29,  1.409306959147315e-30, -1.343343714345038e-31,  1.070307570456946e-32,
 -7.325594075961129e-34,  4.394780128213962e-35, -2.346935232062900e-36,  1.129384485338805e-37, -4.938749173876708e-39,  1.931977822391754e-28, -8.457403096241158e-29,
  1.986623208114802e-29, -3.171018352142429e-30,  3.826694864679594e-31, -3.709943921446831e-32,  3.004954304770429e-33, -2.089801003319781e-34,  1.273262514202513e-35,
 -6.902259547077203e-37,  3.370062491486403e-38, -1.494530058422338e-39,  5.591792677481344e-02, -1.284336670804431e-04,  3.038872426166368e-07, -7.380837218606393e-10,
  1.829907128426387e-12, -4.613843976295633e-15,  1.174401297001276e-17, -3.022798472570445e-20,  7.758781824621080e-23, -2.025545540254861e-25,  5.137625686279740e-28,
 -1.383197625989532e-30,  5.071598477774063e-02, -1.345589828957919e-04,  4.262674141807172e-07, -1.439969936125324e-09,  4.898610699133324e-12, -1.647232718732849e-14,
  5.450453509223237e-17, -1.777164863548828e-19,  5.712402914265353e-22, -1.816791177294047e-24,  5.706318022173820e-27, -1.781735204807414e-29,  4.171755006183107e-02,
 -1.405003527696603e-04,  6.149302488161622e-07, -2.683484831867254e-09,  1.123276164402551e-11, -4.533354361383490e-14,  1.777200418820519e-16, -6.804152903037763e-19,
  2.553096766943109e-21, -9.414605856616346e-24,  3.418005669139788e-26, -1.223975553875138e-28,  3.112045148599829e-02, -1.383285863474649e-04,  7.854803538976835e-07,
 -4.136044113925584e-09,  2.040167622721967e-11, -9.601267518663108e-14,  4.355547012637486e-16, -1.916562178571724e-18,  8.216925754462098e-21, -3.443755982594088e-23,
  1.414708636127155e-25, -5.708096616257226e-28,  2.105167358139090e-02, -1.240020737574847e-04,  8.658624794312621e-07, -5.349087577229678e-09,  3.058684368881693e-11,
 -1.654282436536002e-13,  8.558672761014538e-16, -4.267209936163043e-18,  2.061616485419929e-20, -9.691297895141535e-23,  4.447304474988335e-25, -1.997332299658150e-27,
  1.291189919527201e-02, -9.958085116552969e-05,  8.276269290455219e-07, -5.921300723959983e-09,  3.883340162993766e-11, -2.387425646171181e-13,  1.393676357411462e-15,
 -7.793579941272238e-18,  4.202140933661668e-20, -2.195184644637008e-22,  1.115310418898929e-24, -5.527645911999771e-27,  7.179526080813795e-03, -7.122958042042511e-05,
  6.916505191485488e-07, -5.684075127562109e-09,  4.238734202506753e-11, -2.936984200523469e-13,  1.919021564890832e-15, -1.194538833891557e-17,  7.136268178092122e-20,
 -4.114284880579518e-22,  2.299012665287815e-24, -1.249349784164010e-26,  3.618557087382340e-03, -4.533942614416558e-05,  5.087955108585582e-07, -4.771637874533555e-09,
  4.017434662424212e-11, -3.116400846425827e-13,  2.265034296425881e-15, -1.560217771874628e-17,  1.026972057474450e-19, -6.499343943857617e-22,  3.973681637820764e-24,
 -2.355933133828898e-26,  1.652860526115394e-03, -2.570688168302391e-05,  3.310966053767341e-07, -3.523460312793760e-09,  3.329925772703432e-11, -2.876516055916737e-13,
  2.314064793897611e-15, -1.755638132328875e-17,  1.267552663431118e-19, -8.767989694556759e-22,  5.841255831619219e-24, -3.763307407533149e-26,  6.841071072735274e-04,
 -1.300406638904603e-05,  1.912874778504338e-07, -2.298442851879334e-09,  2.426711187118574e-11, -2.324340884660534e-13,  2.061294998661563e-15, -1.715883023387797e-17,
  1.353923645646792e-19, -1.020082307590793e-21,  7.380150710758000e-24, -5.150064278457907e-26,  2.565242688682505e-04, -5.878995348350703e-06,  9.838121496025442e-08,
 -1.328958826394447e-09,  1.561383316688067e-11, -1.652302376449868e-13,  1.609949832809012e-15, -1.465814869169648e-17,  1.260254832564840e-19, -1.031237607766373e-21,
  8.080014826888739e-24, -6.090931172289434e-26,  8.713399102847948e-05, -2.379096677938770e-06,  4.513875260107731e-08, -6.829254138109336e-10,  8.899390714293350e-12,
 -1.037392618375528e-13,  1.107495366169280e-15, -1.099995437636622e-17,  1.027926348536684e-19, -9.113544443371278e-22,  7.715593033577143e-24, -6.269081124095924e-26,
  2.680747242904969e-05, -8.630347150980181e-07,  1.850766211758272e-08, -3.126036992767773e-10,  4.505761322853821e-12, -5.771181977667963e-14,  6.734879286719993e-16,
 -7.281355874914633e-18,  7.380317045450744e-20, -7.075625076105345e-22,  6.460235929232344e-24, -5.647382602164714e-26,  7.469856697727408e-06, -2.810030071210208e-07,
  6.791522336602350e-09, -1.277066911289061e-10,  2.031201936903388e-12, -2.852622417352571e-14,  3.631859026342465e-16, -4.266310961078821e-18,  4.682275378516338e-20,
 -4.846135835232979e-22,  4.764239685315355e-24, -4.473971974885413e-26,  1.885260579954082e-06, -8.221944737356351e-08,  2.233495146862311e-09, -4.664253138817533e-11,
  8.169853911449121e-13, -1.255809557252370e-14,  1.741481191440929e-16, -2.219335822573914e-18,  2.633579135203775e-20, -2.938603360739668e-22,  3.106597870513637e-24,
 -3.129947225460532e-26,  4.310194015863188e-07, -2.164271988591432e-08,  6.591260815923490e-10, -1.525454169018918e-11,  2.937494390703370e-13, -4.934579644319294e-15,
  7.443264506431195e-17, -1.027782361380826e-18,  1.317133718756459e-20, -1.582680206081023e-22,  1.797285702868529e-24, -1.940760417867726e-26,  8.929311912061319e-08,
 -5.131222502447778e-09,  1.747778178451264e-10, -4.474548902464445e-12,  9.458741245586059e-14, -1.734283759844385e-15,  2.842242251381648e-17, -4.247986420593839e-19,
  5.873521459614135e-21, -7.593381527225172e-23,  9.254691723578244e-25, -1.070179007654851e-26,  1.677069630521464e-08, -1.097070673066911e-09,  4.170068231341399e-11,
 -1.179060666788492e-12,  2.732624856703265e-14, -5.462879090377373e-16,  9.718246491749654e-18, -1.570836111641062e-19,  2.341518597062611e-21, -3.254565157431390e-23,
  4.254256569883861e-25, -5.264662372564102e-27,  2.857756469911248e-09, -2.118140186220415e-10,  8.966284119153530e-12, -2.795882186301354e-13,  7.096712084172282e-15,
 -1.545517874144133e-16,  2.982228483241898e-18, -5.209748886996033e-20,  8.367055193481812e-22, -1.249635023871520e-23,  1.751008119580836e-25, -2.317752677903084e-27,
  4.422980908475851e-10, -3.699047530766654e-11,  1.740498851167084e-12, -5.977935303041779e-14,  1.660311015486758e-15, -3.936148330359285e-17,  8.233450804175150e-19,
 -1.553706012253702e-20,  2.687299636239739e-22, -4.310831778516999e-24,  6.472492873351642e-26, -9.160547239022164e-28,  6.227043599745442e-11, -5.854660446388802e-12,
  3.056722910761493e-13, -1.155119694188927e-14,  3.507777369826450e-16, -9.047513754652322e-18,  2.050620181383905e-19, -4.178487710127584e-21,  7.780659528262158e-23,
 -1.340201002316738e-24,  2.155612224648700e-26, -3.261233766990040e-28,  7.991437617289205e-12, -8.418967657533938e-13,  4.869575637794264e-14, -2.022708546598100e-15,
  6.711573916183427e-17, -1.882513663569413e-18,  4.621595904732903e-20, -1.016618664496393e-21,  2.037569020442127e-23, -3.767867598924874e-25,  6.491081215071734e-27,
 -1.049602159048971e-28,  9.374444892696031e-13, -1.103325635446501e-13,  7.059553565469805e-15, -3.220436077072502e-16,  1.166954801258823e-17, -3.558177562532524e-19,
  9.459604043212801e-21, -2.245934976460530e-22,  4.844569255924467e-24, -9.616751447591300e-26,  1.774348397686830e-27, -3.066298585645609e-29,  1.008854133120175e-13,
 -1.322921099444858e-14,  9.351012164155558e-16, -4.681134090703117e-17,  1.851542203555856e-18, -6.135388179494674e-20,  1.766053492329326e-21, -4.525254204451442e-23,
  1.050465602986299e-24, -2.238385021038669e-26,  4.423149847166456e-28, -8.169101728444095e-30,  1.000787929735173e-14, -1.458488634297845e-15,  1.137425406539598e-16,
 -6.243867299167185e-18,  2.694602692367754e-19, -9.701362615454357e-21,  3.023120661896543e-22, -8.359603582638448e-24,  2.088342134586239e-25, -4.776863898398739e-27,
  1.010977541978740e-28, -1.995573604885824e-30,  9.208006690657433e-16, -1.487800916232968e-16,  1.278562290618892e-17, -7.690992737013779e-19,  3.619952038253963e-20,
 -1.415695994601326e-21,  4.775327350566072e-23, -1.424970174925239e-24,  3.830895943399098e-26, -9.406835165761230e-28,  2.132378533056602e-29, -4.498781251533260e-31,
  7.920359824423390e-17, -1.415554699831548e-17,  1.338812594248441e-18, -8.818408552480682e-20,  4.524776171617776e-21, -1.921671801507700e-22,  7.015502966420368e-24,
 -2.258927904170593e-25,  6.535287516974430e-27, -1.722707246965170e-28,  4.182758596352917e-30, -9.432052162564987e-32,  6.434053862069451e-18, -1.268927969717299e-18,
  1.319090308916257e-19, -9.506008784934924e-21,  5.314473444096410e-22, -2.450218688085208e-23,  9.678982523079425e-25, -3.362378041199513e-26,  1.046720140523122e-27,
 -2.961749055385770e-29,  7.702023514172234e-31, -1.856247815572355e-32,  5.000124002971453e-19, -1.085452856809073e-19,  1.238383979378149e-20, -9.754509913458387e-22,
  5.937729613165243e-23, -2.970332920431734e-24,  1.269128830549165e-25, -4.755120921895459e-27,  1.592415328074566e-28, -4.835582406877887e-30,  1.346552283859124e-31,
 -3.467812636680769e-33,  3.778270854431985e-20, -9.003177164993516e-21,  1.125375865138709e-21, -9.676841693102181e-23,  6.407460867193573e-24, -3.475176533807722e-25,
  1.604998341629832e-26, -6.482295216364821e-28,  2.334100526879892e-29, -7.603074436570404e-31,  2.266182888689521e-32, -6.233683817380621e-34,  2.833043940056419e-21,
 -7.386674873949361e-22,  1.009459178562597e-22, -9.460191499238554e-24,  6.804644586828330e-25, -3.996713612238417e-26,  1.993229570129678e-27, -8.669840946940141e-29,
  3.353735372935898e-30, -1.170921048075597e-31,  3.732767345038997e-33, -1.095898113843964e-34,  2.161651069254457e-22, -6.143974262370265e-23,  9.155125752939732e-24,
 -9.330339337256440e-25,  7.276667920607065e-26, -4.620641511672523e-27,  2.484521350561949e-28, -1.162178886433473e-29,  4.823137173062715e-31, -1.802585838388902e-32,
  6.138395250325589e-34, -1.921109519059464e-35,  1.730577883346772e-23, -5.337931268222153e-24,  8.643056234418744e-25, -9.550741018439173e-26,  8.054714389126926e-27,
 -5.516142768087555e-28,  3.190632928238941e-29, -1.601596324870467e-30,  7.116412191692088e-32, -2.841458550548713e-33,  1.031642491989375e-34, -3.435388817491145e-36,
  1.507644356998060e-24, -5.019240935831184e-25,  8.791807912652945e-26, -1.049202849389267e-26,  9.533756175290741e-28, -7.017486926064510e-29,  4.352322646490169e-30,
 -2.337251736171951e-31,  1.108614323736797e-32, -4.715574306402375e-34,  1.820324784066804e-35, -6.432369878472182e-37,  1.490395928465763e-25, -5.320382029331992e-26,
  1.002400831141084e-26, -1.285133318127206e-27,  1.251992349858413e-28, -9.858745117851695e-30,  6.527128017965248e-31, -3.733841184795296e-32,  1.882808060446952e-33,
 -8.497685673813592e-35,  3.474235725988029e-36, -1.297831420922464e-37,  1.749652668610816e-26, -6.644676204464207e-27,  1.336825515005358e-27, -1.828672002449879e-28,
  1.897641454740519e-29, -1.588680045102834e-30,  1.116105813765458e-31, -6.762240043609446e-33,  3.604979381962541e-34, -1.717120954273028e-35,  7.396665975542740e-37,
 -2.906210705265778e-38,  2.549690356259953e-27, -1.020608427702720e-27,  2.172914962012925e-28, -3.144092548102655e-29,  3.446545160474492e-30, -3.043197026215366e-31,
  2.251196943847065e-32, -1.433872856854392e-33,  8.023258299044445e-35, -4.005124522622497e-36,  1.805436462951005e-37, -7.412202077830122e-39,  4.761536429400493e-28,
 -1.987592413157545e-28,  4.429599222239783e-29, -6.708042398433504e-30,  7.688260842916952e-31, -7.088906853698183e-32,  5.468916039717897e-33, -3.628025662641529e-34,
  2.111675353658339e-35, -1.095141174171661e-36,  5.122633285718225e-38, -2.179581841499254e-39,  1.126223122944165e-28, -4.844162065042948e-29,  1.115847067830082e-29,
 -1.746539220824664e-30,  2.067561988161460e-31, -1.967330530740822e-32,  1.564807521530950e-33, -1.069257308922135e-34,  6.404540082037859e-36, -3.414970156168482e-37,
  1.640912275232564e-38, -7.165422778140788e-40,  2.745490789546215e-29, -1.201161485787195e-29,  2.819655676983845e-30, -4.497730900399744e-31,  5.424214320469716e-32,
 -5.255387504752906e-33,  4.254087483456566e-34, -2.956729184832571e-35,  1.800402157639635e-36, -9.754265318838946e-38,  4.759918407271552e-39, -2.109752627083094e-40,
  5.540899890157248e-02, -1.260375063383765e-04,  2.952029127339994e-07, -7.095283914568921e-10,  1.740381676820360e-12, -4.341870309201947e-15,  1.093132011634002e-17,
 -2.785799606074504e-20,  7.065150473586874e-23, -1.831767103004802e-25,  4.561887512515479e-28, -1.237746619128005e-30,  5.018446153569678e-02, -1.312166543015962e-04,
  4.094473955305839e-07, -1.364158318832530e-09,  4.581852607321539e-12, -1.522192437551997e-14,  4.977486206766893e-17, -1.604407042952629e-19,  5.097622516429626e-22,
 -1.603473386011961e-24,  4.977281111270915e-27, -1.538479984863770e-29,  4.116518781427651e-02, -1.357067301727338e-04,  5.837775891945565e-07, -2.510788580985769e-09,
  1.036724681680309e-11, -4.128795413601849e-14,  1.597630712659695e-16, -6.038853160617777e-19,  2.237536348679792e-21, -8.149270693148296e-24,  2.922500363789717e-26,
 -1.033981942689845e-28,  3.057939813329272e-02, -1.322378667155281e-04,  7.377448082677847e-07, -3.824429084397553e-09,  1.858175792399775e-11, -8.617472251065904e-14,
  3.853932780831031e-16, -1.672411709371140e-18,  7.073259551975580e-21, -2.925059991306056e-23,  1.185938613904810e-25, -4.723349282299038e-28,  2.056912397809999e-02,
 -1.173238549006591e-04,  8.045040901834565e-07, -4.885089869011157e-09,  2.747438095863380e-11, -1.462497686008904e-13,  7.451204643883179e-16, -3.660045957792027e-18,
  1.742740539264816e-20, -8.076386918284981e-23,  3.654784592295920e-25, -1.618970167130896e-27,  1.252638225064275e-02, -9.323384692171308e-05,  7.601474473668911e-07,
 -5.336419305969136e-09,  3.437611221815795e-11, -2.077680310859550e-13,  1.193152415074426e-15, -6.567181295965072e-18,  3.486643214500088e-20, -1.794143500290092e-22,
  8.981910450497320e-25, -4.387490651542900e-27,  6.905257885709635e-03, -6.595811322629837e-05,  6.273247675242712e-07, -5.050476245018149e-09,  3.694812443714427e-11,
 -2.514105823580080e-13,  1.614415096065597e-15, -9.882038723282579e-18,  5.808213282831234e-20, -3.295871288160662e-22,  1.813336815350766e-24, -9.705509513723309e-27,
  3.444992292227846e-03, -4.148762846776760e-05,  4.551960883452026e-07, -4.175899255516832e-09,  3.445159872526415e-11, -2.621708109620022e-13,  1.870871731629125e-15,
 -1.266147083419251e-17,  8.192727717937460e-20, -5.099335174413772e-22,  3.067520293352869e-24, -1.790036779069357e-26,  1.555074996269050e-03, -2.321859596015030e-05,
  2.918312973049246e-07, -3.033838154423971e-09,  2.806403395342341e-11, -2.375822779045763e-13,  1.874830916164573e-15, -1.396320485948286e-17,  9.902555272994634e-20,
 -6.731913027721674e-22,  4.409581833204600e-24, -2.794379639986757e-26,  6.349856335294316e-04, -1.157782778189938e-05,  1.658906807376436e-07, -1.944825546786213e-09,
  2.007661797645778e-11, -1.882707962651691e-13,  1.636364751592839e-15, -1.336102195326744e-17,  1.034788011724774e-19, -7.656771638980348e-22,  5.443063615315729e-24,
 -3.733767933403587e-26,  2.344870670085206e-04, -5.151726861146632e-06,  8.383002303120302e-08, -1.103606724423822e-09,  1.266458901460446e-11, -1.310930676186151e-13,
  1.250816134974085e-15, -1.116183811220489e-17,  9.412567874080674e-20, -7.559112940461579e-22,  5.815933167424991e-24, -4.307163451202107e-26,  7.829114271554094e-05,
 -2.048495237725607e-06,  3.773392845185980e-08, -5.557876709461258e-10,  7.067256161079328e-12, -8.051197160771111e-14,  8.410108339899948e-16, -8.180972950286493e-18,
  7.493271460703064e-20, -6.516007549511112e-22,  5.413758892393905e-24, -4.319067668432621e-26,  2.362931962914562e-05, -7.288351704610116e-07,  1.515354735653895e-08,
 -2.489319830077848e-10,  3.497933398631257e-12, -4.374963942372830e-14,  4.991737297407413e-16, -5.281823961680755e-18,  5.243960130346504e-20, -4.927997302186957e-22,
  4.413090406350894e-24, -3.785881322959480e-26,  6.445529777079981e-06, -2.322887355764498e-07,  5.436640149983875e-09, -9.933582501958555e-11,  1.538977193505027e-12,
 -2.108882654981056e-14,  2.623245496962090e-16, -3.013874893071603e-18,  3.237992107276102e-20, -3.283123240860421e-22,  3.164037381883208e-24, -2.914398409018946e-26,
  1.588864174803013e-06, -6.638581894809749e-08,  1.744608764203684e-09, -3.537250331509315e-11,  6.030391785669431e-13, -9.037987132040687e-15,  1.223713320470111e-16,
 -1.524329436753887e-18,  1.769698183914811e-20, -1.933455968577298e-22,  2.002708063192017e-24, -1.978218092097404e-26,  3.539388440661472e-07, -1.702894467173483e-08,
  5.013042985522429e-10, -1.125601371263467e-11,  2.108161580085975e-13, -3.450710482102589e-15,  5.078897116441576e-17, -6.851018817938816e-19,  8.585210111894824e-21,
 -1.009578753534982e-22,  1.122801685966097e-24, -1.188160822512149e-26,  7.125773510880519e-08, -3.924464478329628e-09,  1.291288557647369e-10, -3.205264850259812e-12,
  6.585958302246613e-14, -1.175930828315919e-15,  1.879449989748021e-17, -2.742692250368526e-19,  3.706386953379176e-21, -4.687254354085814e-23,  5.592451910507213e-25,
 -6.334969190815051e-27,  1.296950978213263e-08, -8.133822621875765e-10,  2.985202658062495e-11, -8.179300624083027e-13,  1.841616231738692e-14, -3.583386564924425e-16,
  6.213796194062382e-18, -9.802257666952577e-20,  1.427465977595904e-21, -1.940078162631527e-23,  2.481679125492118e-25, -3.007393613466215e-27,  2.135156719435251e-09,
 -1.517855861586905e-10,  6.201867754683519e-12, -1.873267059934982e-13,  4.617287811578448e-15, -9.782940262328195e-17,  1.839305336457246e-18, -3.134629863701241e-20,
  4.916499246463243e-22, -7.177548585398480e-24,  9.838720002441139e-26, -1.274933004753179e-27,  3.182075883948938e-10, -2.553781214563043e-11,  1.159669957207534e-12,
 -3.857067775422547e-14,  1.039918929800552e-15, -2.397723333056781e-17,  4.885203712966087e-19, -8.990597296729019e-21,  1.518169016682598e-22, -2.379873248379179e-24,
  3.494698295912234e-26, -4.840901508872275e-28,  4.298319729261320e-11, -3.880521714865631e-12,  1.955297700014763e-13, -7.154189470407432e-15,  2.108500323061264e-16,
 -5.287907919159733e-18,  1.167099289685737e-19, -2.318776271454958e-21,  4.214482172529998e-23, -7.092458698874927e-25,  1.115476160942964e-26, -1.651442312081693e-28,
  5.271697135435143e-12, -5.336782972119026e-13,  2.979555080132398e-14, -1.198290486085454e-15,  3.858507084443434e-17, -1.052178881013778e-18,  2.515069277453029e-20,
 -5.393514420131449e-22,  1.055007720439381e-23, -1.905828558533869e-25,  3.210103829096766e-27, -5.078972034054187e-29,  5.884492078676095e-13, -6.661027643605321e-14,
  4.115260504167073e-15, -1.817859484455086e-16,  6.392674155298088e-18, -1.895002202330888e-19,  4.905117072247989e-21, -1.135307993851929e-22,  2.389931636029326e-24,
 -4.634360553165567e-26,  8.359949034657007e-28, -1.413586004273799e-29,  5.997710080415416e-14, -7.571913111905830e-15,  5.170481987740083e-16, -2.507127963577431e-17,
  9.625504765348752e-19, -3.101288983026963e-20,  8.692435758156425e-22, -2.171484650865118e-23,  4.919742360995109e-25, -1.024138740140911e-26,  1.978756532072336e-28,
 -3.576137115763511e-30,  5.606105501112268e-15, -7.874918753079191e-16,  5.936969511498805e-17, -3.158294815402228e-18,  1.323461722767005e-19, -4.634289065519914e-21,
  1.406529504363714e-22, -3.792712625084197e-24,  9.249134317353059e-26, -2.067239877724682e-27,  4.278681391160260e-29, -8.266081725705996e-31,  4.833003897418257e-16,
 -7.537135818241928e-17,  6.267098382766511e-18, -3.655712456787905e-19,  1.671639441647994e-20, -6.361238831456604e-22,  2.090710063652299e-23, -6.085954280577490e-25,
  1.597754814054428e-26, -3.834839971233607e-28,  8.504128450732356e-30, -1.756562384785440e-31,  3.871647623300389e-17, -6.688976045997137e-18,  6.127928110350312e-19,
 -3.917500165545941e-20,  1.954279706488488e-21, -8.081326276290024e-23,  2.876316346899796e-24, -9.039602989458309e-26,  2.555184249264507e-27, -6.586839349650484e-29,
  1.565299469509231e-30, -3.457379192937220e-32,  2.910079301170546e-18, -5.557845999625153e-19,  5.603828460806617e-20, -3.923870001595716e-21,  2.134842892524910e-22,
 -9.591794764287763e-24,  3.696953742019083e-25, -1.254446903570709e-26,  3.818142682515967e-28, -1.057231767538052e-29,  2.692638671961120e-31, -6.360488362026352e-33,
  2.078099676463757e-19, -4.377414376368990e-20,  4.851700446073274e-21, -3.718283242902720e-22,  2.205328765018265e-23, -1.076284746211722e-24,  4.491505662512273e-26,
 -1.645346657308884e-27,  5.392190855345945e-29, -1.603757075059181e-30,  4.377551789594983e-32, -1.105863505225794e-33,  1.432579419223287e-20, -3.319909685864805e-21,
  4.038979660371787e-22, -3.384693315422455e-23,  2.186919272503742e-24, -1.158743898547377e-25,  5.233654096501937e-27, -2.069157409574875e-28,  7.299564213288642e-30,
 -2.331451594338072e-31,  6.818862901998388e-33, -1.841819623433477e-34,  9.728963944788833e-22, -2.473247549604492e-22,  3.296785412845612e-23, -3.016868688238491e-24,
  2.121270648011524e-25, -1.219204759163982e-26,  5.955619255299395e-28, -2.539545143964708e-29,  9.638240261063685e-31, -3.304021915010067e-32,  1.034882911851224e-33,
 -2.987189768171218e-35,  6.676740970221662e-23, -1.855452742329756e-23,  2.703459687440110e-24, -2.696408368499683e-25,  2.059975758311927e-26, -1.282523183044799e-27,
  6.767141288438644e-29, -3.108671358028019e-30,  1.267902669107454e-31, -4.660146796685292e-33,  1.561632058896448e-34, -4.812392236875237e-36,  4.778454864326031e-24,
 -1.445483570620174e-24,  2.294897825922158e-25, -2.488158143340771e-26,  2.060505595008107e-27, -1.386676002516783e-28,  7.887659586886324e-30, -3.896301089928926e-31,
  1.704769806234353e-32, -6.706722020858805e-34,  2.400519521333239e-35, -7.884906383325984e-37,  3.705030255486522e-25, -1.213613632420171e-25,  2.090699350823434e-26,
 -2.455004141417553e-27,  2.196366261615082e-28, -1.592734058281226e-29,  9.737933872843230e-31, -5.158040717879094e-32,  2.414506709043438e-33, -1.014080538393264e-34,
  3.867096111067964e-36, -1.350551173131616e-37,  3.254437048569367e-26, -1.146875749136249e-26,  2.131983141619746e-27, -2.697726373812786e-28,  2.595144748508307e-29,
 -2.018854054666940e-30,  1.321106302747725e-31, -7.473156100448576e-33,  3.728009715372235e-34, -1.665231034923406e-35,  6.740720352299486e-37, -2.494067701077436e-38,
  3.403204730837600e-27, -1.280101333127468e-27,  2.549412113959864e-28, -3.452855457907177e-29,  3.548762330315706e-30, -2.943575330006204e-31,  2.049629567520262e-32,
 -1.231238785382640e-33,  6.509986969386685e-35, -3.076386504776647e-36,  1.315130733676681e-37, -5.129603742651761e-39,  4.453449668959836e-28, -1.771106338439753e-28,
  3.744525163527383e-29, -5.380959455037492e-30,  5.859357765342237e-31, -5.140450689213029e-32,  3.779154080761029e-33, -2.392788570248552e-34,  1.331238559949589e-35,
 -6.608869757922758e-37,  2.963396262514125e-38, -1.210438219195807e-39,  7.580600121688630e-29, -3.152227629018605e-29,  6.995854252666383e-30, -1.055053643096523e-30,
  1.204368483571946e-31, -1.106170948912161e-32,  8.501918919491843e-34, -5.619776246772192e-35,  3.259621898198768e-36, -1.684836571016156e-37,  7.855654393723758e-39,
 -3.332105391477857e-40,  1.671013577090029e-29, -7.174412730994797e-30,  1.649316281719136e-30, -2.576394683138883e-31,  3.044025955861973e-32, -2.891005839564007e-33,
  2.295312256190472e-34, -1.565667787651330e-35,  9.361998354321391e-37, -4.983753432114527e-38,  2.390940889467822e-39, -1.042472943167409e-40,  3.907214995576327e-30,
 -1.708359997546058e-30,  4.007493959464167e-31, -6.388033041790077e-32,  7.698605669316939e-33, -7.453980062737266e-34,  6.029836338177207e-35, -4.188261808405613e-36,
  2.548721875619808e-37, -1.380020242948234e-38,  6.730316502258867e-40, -2.981399762606597e-41,  };
  int offset = -40;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 40;
    if (std::isnan(t)) {
      fill_n(rr+offset, 40, 0.5);
      fill_n(ww+offset, 40, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 40; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=40; ++j) {
        const int boxof = it*480+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
