# Introduction

The `perf_to_profile` binary can be used to turn a perf.data file, which is
generated by the linux profiler, perf, into a profile.proto file which can be
visualized using the tool pprof.

For details on pprof, see https://github.com/google/pprof

**THIS IS NOT AN OFFICIAL GOOGLE PRODUCT**


# Prerequisites:
- Protocol buffers: http://github.com/google/protobuf
- Google Test: http://github.com/google/googletest

# Compilation:
To install all dependences and build the binary, run the following commands.
These were tested on Debian GNU/Linux 8 (jessie):
```
sudo apt-get -y install autoconf automake g++ git libelf-dev libssl-dev libtool make pkg-config
git clone --recursive https://github.com/google/perf_data_converter.git
cd perf_data_converter/src
make perf_to_profile
```

If you already have protocol buffers and googletest installed on your system,
you can compile using your local packages with the following commands:
```
sudo apt-get -y install autoconf automake g++ git libelf-dev libssl-dev libtool make pkg-config
git clone https://github.com/google/perf_data_converter.git
cd perf_data_converter/src
make perf_to_profile
```

Place the `perf_to_profile` binary in a place accessible from your path (eg `/usr/local/bin`).

# Running tests:
There are a small number of tests that verify the basic functionality.
To run these, after successful compilation, run:
```
make check clean
make check clean -C quipper/ -f Makefile.external
```

# Usage:
Profile a command using perf, for example:
```
perf record /bin/ls
```

The example command will generate a profile named perf.data, you
should convert this into a profile.proto then visualize it using
pprof:

```
perf_to_profile perf.data profile.pb
pprof -web profile.pb
```

Recent versions of pprof will automatically invoke `perf_to_profile`:
```
pprof -web perf.data
```

# Contribution:
We appreciate your help!

Note that perf data converter and quipper projects do not use GitHub pull
requests, and that we use the issue tracker for bug reports.
