#! /bin/bash

######################################################################
# Create autogenerated Evosuite unit tests. These are really a 
# stop-gap measure until more unit tests can be coded up "manually".
# This test generation is a one-off step and should not need to be 
# repeated, unless there are significant Evosuite changes.
#
# They will be moved into the src/test/evosuite folder by the 
# evosuite:export maven target.
# It is likely that some will need to be fixed after generation.
# 
# The Evosuite evosuite:prepare target is used to create a list of 
# scaffold files (.scaffolding_list.tmp) for the Evosuite unit test 
# listener to use. The listener is called from surefire and runs the 
# Evosuite tests in a sandbox.
######################################################################

echo
echo "This may take several hours and needs a lot of heap space...."
echo
echo "EMBOSS_ROOT set to: "$EMBOSS_ROOT
echo

export JAVA_TOOL_OPTIONS="-Xmx5g"

cd ..

mvn -Dcores=2 -DmemoryInMB=2000 -Dsearch_budget=90 -Dconsider_main_methods=false -Duse_separate_classloader=false -DEMBOSS_ROOT=$EMBOSS_ROOT evosuite:generate evosuite:export test-compile evosuite:prepare


exit 0
