/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:45:05 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.BufferedReader;
import java.io.StringReader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.Codon12CorrelationAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class Codon12CorrelationAlgorithm_ESTest extends Codon12CorrelationAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("1$B]/H{Js]n", "1$B]/H{Js]n");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      codon12CorrelationAlgorithm0.getDefaultStepSize(8);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      codon12CorrelationAlgorithm0.getDefaultStepSize(4065);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      float[] floatArray0 = new float[6];
      // Undeclared exception!
      try { 
        codon12CorrelationAlgorithm0.getValues(2, 0, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 1 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.plot.Codon12CorrelationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      codon12CorrelationAlgorithm0.setRevCompDisplay(true);
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        codon12CorrelationAlgorithm0.getValues(0, 19, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -2
         //
         verifyException("uk.ac.sanger.artemis.plot.Codon12CorrelationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = null;
      try {
        codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.Codon12CorrelationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      codon12CorrelationAlgorithm0.getDefaultStepSize(78);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      codon12CorrelationAlgorithm0.getDefaultStepSize((-435));
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      codon12CorrelationAlgorithm0.getDefaultMinWindowSize();
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      codon12CorrelationAlgorithm0.getDefaultMaxWindowSize();
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(codon12CorrelationAlgorithm0);
      
      Integer integer0 = codon12CorrelationAlgorithm0.getDefaultWindowSize();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      assertEquals(240, (int)integer0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      rawStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(5, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getTCount());
      
      codon12CorrelationAlgorithm0.setRevCompDisplay(true);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(5, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertTrue(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      
      float[] floatArray0 = new float[8];
      codon12CorrelationAlgorithm0.getValues(0, 2, floatArray0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(5, rawStreamSequence0.length());
      assertEquals(1, rawStreamSequence0.getOtherCount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertTrue(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(8, floatArray0.length);
      assertArrayEquals(new float[] {0.5F, 24.3F, 21.6F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      rawStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getOtherCount());
      assertEquals(5, rawStreamSequence0.length());
      
      float[] floatArray0 = new float[8];
      codon12CorrelationAlgorithm0.getValues(0, 19, floatArray0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(1, rawStreamSequence0.getACount());
      assertEquals(1, rawStreamSequence0.getGCount());
      assertEquals(1, rawStreamSequence0.getCCount());
      assertEquals(1, rawStreamSequence0.getTCount());
      assertEquals(1, rawStreamSequence0.getOtherCount());
      assertEquals(5, rawStreamSequence0.length());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(8, floatArray0.length);
      assertArrayEquals(new float[] {13.016666F, 9.183333F, 12.666667F, 0.0F, 0.0F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      StringReader stringReader0 = new StringReader("Reverse Correlation Scores");
      assertNotNull(stringReader0);
      
      BufferedReader bufferedReader0 = new BufferedReader(stringReader0);
      assertNotNull(bufferedReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(bufferedReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      assertNotNull(linePushBackReader0);
      
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(linePushBackReader0);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(codon12CorrelationAlgorithm0);
      
      codon12CorrelationAlgorithm0.setRevCompDisplay(true);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertTrue(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      
      float[] floatArray0 = new float[6];
      codon12CorrelationAlgorithm0.getValues((-1611), 2, floatArray0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, linePushBackReader0.getLineNumber());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertTrue(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(6, floatArray0.length);
      assertArrayEquals(new float[] {0.5F, 0.5F, 0.5F, 0.0F, 0.0F, 0.0F}, floatArray0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("1$B]/H{Js]n", "1$B]/H{Js]n");
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertNotNull(bases0);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      codon12CorrelationAlgorithm0.setRevCompDisplay(true);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(11, fastaStreamSequence0.getOtherCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertTrue(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      
      // Undeclared exception!
      try { 
        codon12CorrelationAlgorithm0.getValues((-2408), (-1206), (float[]) null);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.StreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      codon12CorrelationAlgorithm0.setRevCompDisplay(true);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertTrue(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      codon12CorrelationAlgorithm0.getValues(0, 74391461, floatArray0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      float[] floatArray0 = new float[8];
      // Undeclared exception!
      try { 
        codon12CorrelationAlgorithm0.getValues(3, 1, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      Float float0 = codon12CorrelationAlgorithm0.getMaximumInternal();
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertNotNull(float0);
      assertEquals(100.0F, (float)float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(codon12CorrelationAlgorithm0);
      
      int int0 = codon12CorrelationAlgorithm0.getValueCount();
      assertEquals("Reverse Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertEquals(3, int0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("C7Tx!Ty");
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertNotNull(bases0);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      Codon12CorrelationAlgorithm codon12CorrelationAlgorithm0 = new Codon12CorrelationAlgorithm(strand0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertNotNull(codon12CorrelationAlgorithm0);
      
      Float float0 = codon12CorrelationAlgorithm0.getMinimumInternal();
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(7, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(7, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(1.4E-45F, codon12CorrelationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3, codon12CorrelationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, codon12CorrelationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(codon12CorrelationAlgorithm0.scalingFlag());
      assertFalse(codon12CorrelationAlgorithm0.isRevCompDisplay());
      assertEquals("correlation_score", codon12CorrelationAlgorithm0.getAlgorithmShortName());
      assertEquals("Correlation Scores", codon12CorrelationAlgorithm0.getAlgorithmName());
      assertFalse(codon12CorrelationAlgorithm0.isUserMaxMin());
      assertNotNull(float0);
      assertEquals(0.0F, (float)float0, 0.01F);
  }
}
