/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:12:16 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.GffToEMBL;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class GffToEMBL_ESTest extends GffToEMBL_ESTest_scaffolding {


  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      String[] stringArray0 = new String[7];
      stringArray0[0] = "";
      stringArray0[1] = "";
      stringArray0[2] = "i3+s^j~RN?,E";
      stringArray0[3] = "";
      stringArray0[4] = "-h\tshow help";
      stringArray0[5] = "-o";
      // Undeclared exception!
      try { 
        GffToEMBL.main(stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      String[] stringArray0 = new String[1];
      stringArray0[0] = "-f";
      // Undeclared exception!
      try { 
        GffToEMBL.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "/To.ut'kb]";
      stringArray0[1] = "uk.ac.sanger.artemis.io.GffToEMBL";
      stringArray0[2] = "PZx1^";
      stringArray0[3] = "!NH1!CjI/-alZ";
      stringArray0[4] = "n";
      stringArray0[5] = "-s";
      stringArray0[6] = "ozsty4p";
      stringArray0[7] = "-a";
      // Undeclared exception!
      try { 
        GffToEMBL.main(stringArray0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      String[] stringArray0 = new String[7];
      stringArray0[0] = "-o\toutput directory";
      stringArray0[1] = "";
      stringArray0[2] = "com.google.common.io.PatternFilenameFilter";
      stringArray0[3] = "color";
      stringArray0[4] = "-z";
      // Undeclared exception!
      try { 
        GffToEMBL.main(stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GffToEMBL", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      GffToEMBL gffToEMBL0 = null;
      try {
        gffToEMBL0 = new GffToEMBL("", "", true, true, true);
      
      } catch(Exception e) {
         fail("Caught exception: " + e.getMessage());
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      String[] stringArray0 = new String[0];
      // Undeclared exception!
      try { 
        GffToEMBL.main(stringArray0);
        fail("Expecting exception: System.SystemExitException");
      
      } catch(System.SystemExitException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.System", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      String[] stringArray0 = new String[8];
      stringArray0[0] = "rna";
      stringArray0[1] = "rna";
      stringArray0[2] = "rna";
      stringArray0[3] = "rna";
      stringArray0[4] = "rna";
      stringArray0[5] = "-s";
      stringArray0[6] = "ozsty4p";
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("ozsty4p");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "rna");
      stringArray0[7] = "rna";
      // Undeclared exception!
      try { 
        GffToEMBL.main(stringArray0);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("$Y");
      FileSystemHandling.appendLineToFile(evoSuiteFile0, "#<t");
      GffToEMBL gffToEMBL0 = new GffToEMBL("$Y", "$Y", true, true, true);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("$Y");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, "rbb");
      GffToEMBL gffToEMBL0 = null;
      try {
        gffToEMBL0 = new GffToEMBL("$Y", "$Y", true, true, true);
        fail("Expecting exception: StringIndexOutOfBoundsException");
      
      } catch(StringIndexOutOfBoundsException e) {
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GffToEMBL gffToEMBL0 = null;
      try {
        gffToEMBL0 = new GffToEMBL((String) null, (String) null, true, true, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.File", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("ozsty4p.tbi");
      FileSystemHandling.createFolder(evoSuiteFile0);
      String[] stringArray0 = new String[8];
      stringArray0[0] = "/To.ut'kb]";
      stringArray0[1] = "/To.ut'kb]";
      stringArray0[2] = "/To.ut'kb]";
      stringArray0[3] = "/To.ut'kb]";
      stringArray0[4] = "/To.ut'kb]";
      stringArray0[5] = "-s";
      stringArray0[6] = "ozsty4p";
      EvoSuiteFile evoSuiteFile1 = new EvoSuiteFile("ozsty4p");
      FileSystemHandling.appendLineToFile(evoSuiteFile1, "/To.ut'kb]");
      stringArray0[7] = "/To.ut'kb]";
      // Undeclared exception!
      try { 
        GffToEMBL.main(stringArray0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.GraphicsEnvironment", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      EvoSuiteFile evoSuiteFile0 = new EvoSuiteFile("$Y");
      FileSystemHandling.appendStringToFile(evoSuiteFile0, ".tbi");
      GffToEMBL gffToEMBL0 = null;
      try {
        gffToEMBL0 = new GffToEMBL("$Y", "$Y", true, true, true);
      
      } catch(Exception e) {
    	  	fail("caught exception: " + e.getMessage());
      }
  }
}
