/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:13:02 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.datatransfer.Clipboard;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryGroup;
import uk.ac.sanger.artemis.Feature;
import uk.ac.sanger.artemis.FeatureEnumeration;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FeatureVector;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.util.Document;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class Entry_ESTest extends Entry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(blastEntryInformation0);
      Entry entry0 = new Entry(bases0, publicDBDocumentEntry0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      Entry.FeatureEnumerator entry_FeatureEnumerator0 = entry0.new FeatureEnumerator();
      boolean boolean0 = entry_FeatureEnumerator0.hasMoreFeatures();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      entry0.save(2);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(genbankStreamFeature0);
      Feature feature0 = new Feature(databaseStreamFeature0);
      try { 
        feature0.copyTo(entry0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // CDS can't have ID as a qualifier
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "htsjdk.variant.variantcontext.VariantContextComparator");
      Entry entry0 = filteredEntryGroup0.createEntry("htsjdk.variant.variantcontext.VariantContextComparator");
      String string0 = entry0.getName();
      assertEquals("htsjdk.variant.variantcontext.VariantContextComparator", string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("e@%VDT<aA5h`vfK");
      Bases bases0 = entry0.getBases();
      assertNull(bases0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range(0);
      EntryGroup entryGroup0 = simpleEntryGroup0.truncate(range0);
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "'^B7U", "'^B7U", false, false);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(entryGroup0, featureKeyQualifierPredicate0, "");
      Entry entry0 = filteredEntryGroup0.createEntry("'^B7U");
      Bases bases1 = entry0.getBases();
      assertNotSame(bases0, bases1);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      try { 
        entry0.setHeaderText("[Dg^z;$Xq):t~W5]!");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // the header must contain only header lines
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Assertion failure: Should be able to manipulate this FeatureHolder");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("uk.ac.sanger.artemis.Entry$FeatureEnumerator");
      // Undeclared exception!
      entry0.saveStandardOnly(3);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      Entry entry0 = filteredEntryGroup0.createEntry("");
      // Undeclared exception!
      try { 
        entry0.saveStandardOnly((-2191));
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      // Undeclared exception!
      try { 
        entry0.remove((Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("0H* .");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key("0H* .");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "8 vDGQ0L*)KhF+6ZA", (String) null, false, false);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry("8 vDGQ0L*)KhF+6ZA");
      // Undeclared exception!
      try { 
        entry0.remove((Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      Entry.newEntry(bases0);
      // Undeclared exception!
      Entry.newEntry(bases0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("");
      // Undeclared exception!
      try { 
        entry0.createFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.add((Feature) null, false, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Entry entry0 = null;
      try {
        entry0 = new Entry((uk.ac.sanger.artemis.io.Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("K0.wc,84L)T]s#");
      entry0.dispose();
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      boolean boolean0 = entry0.setName((String) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("`");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, (FeatureVector) null, "`");
      Entry entry0 = filteredEntryGroup0.createEntry("-PZ6 ua");
      entry0.addEntryChangeListener(simpleEntryGroup0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("Assertion failure: Should be able to manpulate this FeatureHolder");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("uk.ac.sanger.artemis.Entry$FeatureEnumerator");
      entry0.removeEntryChangeListener(simpleEntryGroup0);
      assertEquals(0, simpleEntryGroup0.refCount());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry();
      entry0.removeFeatureChangeListener(simpleEntryGroup0);
      assertEquals(1, simpleEntryGroup0.size());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      String string0 = entry0.getName();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "'^B7U", "'^B7U", false, false);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "");
      Entry entry0 = filteredEntryGroup0.createEntry("'^B7U");
      Bases bases1 = entry0.getBases();
      assertEquals(5, Bases.MAX_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      uk.ac.sanger.artemis.io.Entry entry1 = entry0.getEMBLEntry();
      assertFalse(entry1.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("]myO");
      entry0.addFeatureChangeListener(simpleEntryGroup0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Entry entry0 = null;
      try {
        entry0 = new Entry((Bases) null, (uk.ac.sanger.artemis.io.Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("]myO");
      MockFile mockFile0 = new MockFile("", "");
      EntryInformation entryInformation0 = entry0.getEntryInformation();
      try { 
        entry0.save((File) mockFile0, 0, true, entryInformation0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "");
      Entry entry0 = filteredEntryGroup0.createEntry("");
      FeatureEnumeration featureEnumeration0 = entry0.features();
      assertFalse(featureEnumeration0.hasMoreFeatures());
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("ByClass(");
      int int0 = entry0.getFeatureCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("e@%VDT<aA5h`vfK");
      boolean boolean0 = entry0.isReadOnly();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Key key0 = Key.CDS;
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry("J,>0Ql*k}~bZ");
      // Undeclared exception!
      try { 
        entry0.createFeature(key0, (Location) null, (QualifierVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.FeatureTree", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("jqZJA)l");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key(".BPJ_d7Bb");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "J\u0001");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "jqZJA)l");
      Entry entry0 = filteredEntryGroup0.createEntry(".BPJ_d7Bb");
      FeatureVector featureVector0 = entry0.checkForMissingQualifiers();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      FeatureVector featureVector0 = entry0.checkForOverlappingCDSs();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      FeatureVector featureVector0 = entry0.checkForEMBLDuplicates();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "htsjdk.variant.variantcontext.VariantContextComparator");
      Entry entry0 = filteredEntryGroup0.createEntry("htsjdk.variant.variantcontext.VariantContextComparator");
      FeatureVector featureVector1 = entry0.checkFeatureStopCodons();
      assertNotSame(featureVector0, featureVector1);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      FeatureVector featureVector0 = selection0.getSelectedFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, (String) null);
      Entry entry0 = filteredEntryGroup0.createEntry("J,>0Ql*k}~bZ");
      FeatureVector featureVector1 = entry0.checkFeatureStartCodons();
      assertNotSame(featureVector0, featureVector1);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("e@%VDT<aA5h`vfK");
      FeatureVector featureVector0 = entry0.checkForNonEMBLKeys();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      char[] charArray0 = new char[8];
      Short short0 = new Short((short) (-2777));
      Integer integer0 = GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR;
      PartialSequence partialSequence0 = new PartialSequence(charArray0, 11, (-2103), short0, integer0);
      Bases bases0 = new Bases(partialSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry();
      FeatureVector featureVector0 = new FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "1..");
      filteredEntryGroup0.createFeature();
      // Undeclared exception!
      try { 
        entry0.truncate(bases0, (Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("jqZJA)l");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Range range0 = new Range((-189));
      Key key0 = new Key(".BPJ_d7Bb");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "J\u0001");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "jqZJA)l");
      Entry entry0 = filteredEntryGroup0.createEntry(".BPJ_d7Bb");
      Entry entry1 = entry0.truncate(bases0, range0);
      assertNotSame(entry0, entry1);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      FeatureVector featureVector0 = entry0.getAllFeatures();
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", true);
      Range range0 = new Range(0, 2320);
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "");
      Entry entry0 = filteredEntryGroup0.createEntry("");
      FeatureVector featureVector0 = entry0.getFeaturesInRange(range0);
      assertNotNull(featureVector0);
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("zn}T9");
      Document document0 = entry0.getRootDocument();
      assertEquals("Artemis", document0.getName());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      Document document0 = entry0.getRootDocument();
      assertNull(document0);
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.setHeaderText((String) null);
        fail("Expecting exception: IllegalArgumentException");
      
      } catch(IllegalArgumentException e) {
         //
         // null source
         //
         verifyException("java.util.EventObject", e);
      }
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("e@%VDT<aA5h`vfK");
      boolean boolean0 = entry0.setName("e@%VDT<aA5h`vfK");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = Key.CDS;
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "");
      Entry entry0 = filteredEntryGroup0.createEntry((String) null);
      entry0.saveStandardOnly(0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      entry0.saveStandardOnly(1);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      entry0.save(0);
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      // Undeclared exception!
      try { 
        entry0.save((-19));
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unknown DocumentEntry type
         //
         verifyException("uk.ac.sanger.artemis.io.DocumentEntryFactory", e);
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(simpleEntryInformation0);
      Entry entry0 = null;
      try {
        entry0 = new Entry(publicDBDocumentEntry0);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("e@%VDT<aA5h`vfK");
      Entry.FeatureEnumerator entry_FeatureEnumerator0 = entry0.new FeatureEnumerator();
      // Undeclared exception!
      try { 
        entry_FeatureEnumerator0.nextFeature();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      Feature feature0 = new Feature(genbankStreamFeature0);
      Feature feature1 = feature0.copyTo(entry0);
      assertNotSame(feature1, feature0);
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      String string0 = entry0.getHeaderText();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = new Key("org.biojava.bio.symbol.InfiniteCrossProductAlphabet");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "org.biojava.bio.symbol.InfiniteCrossProductAlphabet");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "org.biojava.bio.symbol.InfiniteCrossProductAlphabet");
      Entry entry0 = filteredEntryGroup0.createEntry();
      // Undeclared exception!
      try { 
        entry0.contains((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("jqZJA)l");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Key key0 = new Key(".BPJ_d7Bb");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "J\u0001");
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "jqZJA)l");
      Entry entry0 = filteredEntryGroup0.createEntry(".BPJ_d7Bb");
      Feature feature0 = entry0.createFeature();
      Feature feature1 = feature0.duplicate();
      assertNotSame(feature0, feature1);
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry((String) null);
      Key key0 = Key.CDS;
      Range range0 = new Range(0);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      // Undeclared exception!
      try { 
        entry0.createFeature(key0, location0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Feature", e);
      }
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      FeatureVector featureVector0 = simpleEntryGroup0.getAllFeatures();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "htsjdk.variant.variantcontext.VariantContextComparator");
      Entry entry0 = filteredEntryGroup0.createEntry("htsjdk.variant.variantcontext.VariantContextComparator");
      // Undeclared exception!
      try { 
        entry0.getFeature((-1090));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Entry", e);
      }
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry("e@%VDT<aA5h`vfK");
      boolean boolean0 = entry0.hasUnsavedChanges();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test58()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      entry0.removeAllFeatures();
      assertFalse(entry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test59()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Entry entry0 = simpleEntryGroup0.createEntry();
      MockFile mockFile0 = new MockFile("");
      // Undeclared exception!
      entry0.saveStandardOnly((File) mockFile0, 3, true);
  }

  @Test(timeout = 4000)
  public void test60()  throws Throwable  {
      Entry entry0 = Entry.newEntry((Bases) null);
      // Undeclared exception!
      try { 
        entry0.save((File) null, (-1121), false);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }
}
