/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:54:11 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Graphics;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.plot.AGWindowAlgorithm;
import uk.ac.sanger.artemis.plot.ATDeviationAlgorithm;
import uk.ac.sanger.artemis.plot.LineAttributes;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.SequenceChangeEvent;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class ATDeviationAlgorithm_ESTest extends ATDeviationAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("seE!lW1t}9}");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.getAverage();
      aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getDefaultWindowSize();
      aTDeviationAlgorithm0.getValueCount();
      float[] floatArray0 = new float[8];
      floatArray0[0] = (float) (-5);
      floatArray0[1] = (float) 1;
      floatArray0[2] = 0.0F;
      floatArray0[3] = (float) 1;
      floatArray0[4] = 2981.1284F;
      floatArray0[5] = (float) 1;
      floatArray0[6] = (float) 0;
      floatArray0[7] = (float) 2;
      aTDeviationAlgorithm0.getValues(1, 30, floatArray0);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(30, 5, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 30 > end: 5
         //
         verifyException("uk.ac.sanger.artemis.plot.ATDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("seE!lW1t}9}");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.getAverage();
      aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getDefaultWindowSize();
      aTDeviationAlgorithm0.getValueCount();
      float[] floatArray0 = new float[8];
      floatArray0[0] = (float) (-5);
      floatArray0[1] = (float) 1;
      floatArray0[2] = 0.0F;
      floatArray0[3] = (float) 1;
      floatArray0[4] = 2981.1284F;
      floatArray0[5] = (float) 1;
      floatArray0[6] = (float) 0;
      floatArray0[7] = (float) 2;
      fastaStreamSequence0.setFromChar(bases0.letter_index);
      aTDeviationAlgorithm0.getValues(1, 30, floatArray0);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(30, 5, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 30 > end: 5
         //
         verifyException("uk.ac.sanger.artemis.plot.ATDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Key key0 = new Key("internal error - ");
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultWindowSize();
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.setUserMax(2);
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.setUserMin((-1.0F));
      aTDeviationAlgorithm0.getMaximum();
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.getMaximumInternal();
      aTDeviationAlgorithm0.getDefaultStepSize(1);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("seE!lW1t}9}");
      assertNotNull(fastaStreamSequence0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertNotNull(bases0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Integer integer0 = aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      assertEquals(1000000, (int)integer0);
      assertNotNull(integer0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      int int0 = aTDeviationAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      int int1 = aTDeviationAlgorithm0.getValueCount();
      assertEquals(1, int1);
      assertTrue(int1 == int0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Integer integer1 = aTDeviationAlgorithm0.getDefaultMinWindowSize();
      assertEquals(10, (int)integer1);
      assertFalse(integer1.equals((Object)integer0));
      assertFalse(integer1.equals((Object)int1));
      assertFalse(integer1.equals((Object)int0));
      assertNotNull(integer1);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Float float0 = aTDeviationAlgorithm0.getAverage();
      assertEquals(1.0F, (float)float0, 0.01F);
      assertNotNull(float0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Integer integer2 = aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      assertEquals(1000000, (int)integer2);
      assertFalse(integer2.equals((Object)integer1));
      assertTrue(integer2.equals((Object)integer0));
      assertFalse(integer2.equals((Object)int0));
      assertFalse(integer2.equals((Object)int1));
      assertNotNull(integer2);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Float float1 = aTDeviationAlgorithm0.getMinimumInternal();
      assertEquals((-1.0F), (float)float1, 0.01F);
      assertNotEquals((float)float1, (float)float0, 0.01F);
      assertNotNull(float1);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      int int2 = aTDeviationAlgorithm0.getValueCount();
      assertEquals(1, int2);
      assertTrue(int2 == int1);
      assertTrue(int2 == int0);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Integer integer3 = aTDeviationAlgorithm0.getDefaultWindowSize();
      assertEquals(30, (int)integer3);
      assertFalse(integer3.equals((Object)integer2));
      assertFalse(integer3.equals((Object)integer1));
      assertFalse(integer3.equals((Object)int0));
      assertFalse(integer3.equals((Object)integer0));
      assertFalse(integer3.equals((Object)int1));
      assertFalse(integer3.equals((Object)int2));
      assertNotNull(integer3);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      int int3 = aTDeviationAlgorithm0.getValueCount();
      assertEquals(1, int3);
      assertTrue(int3 == int0);
      assertTrue(int3 == int1);
      assertTrue(int3 == int2);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      float[] floatArray0 = new float[8];
      floatArray0[0] = (float) (-5);
      floatArray0[1] = (float) 1;
      floatArray0[2] = 0.0F;
      floatArray0[3] = (float) 1;
      floatArray0[4] = 2981.1284F;
      floatArray0[5] = (float) 1;
      floatArray0[6] = (float) 0;
      floatArray0[7] = (float) 2;
      aTDeviationAlgorithm0.getValues(1, 30, floatArray0);
      assertArrayEquals(new float[] {1.0F, 1.0F, 0.0F, 1.0F, 2981.1284F, 1.0F, 0.0F, 2.0F}, floatArray0, 0.01F);
      assertEquals(1, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertEquals(11, fastaStreamSequence0.length());
      assertEquals(10, fastaStreamSequence0.getOtherCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(8, floatArray0.length);
      
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(30, 5, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 30 > end: 5
         //
         verifyException("uk.ac.sanger.artemis.plot.ATDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("long", "Cannot create a FramedFeature on the negative strand of an RNA");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 8250, 8250, "Cannot create a FramedFeature on the negative strand of an RNA");
      Bases bases1 = sequenceChangeEvent0.getBases();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases1).when(strand0).getBases();
      doReturn(true).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(71);
      aTDeviationAlgorithm0.setUserMaxMin(true);
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.setAlgorithmName("V\";");
      aTDeviationAlgorithm0.setRevCompDisplay(true);
      aTDeviationAlgorithm0.setUserMaxMin(true);
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 8250;
      floatArray0[2] = (float) (-5);
      floatArray0[3] = 5.685F;
      floatArray0[4] = (float) 1;
      aTDeviationAlgorithm0.getValues((-1961), 2, floatArray0);
      aTDeviationAlgorithm0.getMinimumInternal();
      float[] floatArray1 = new float[0];
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(1, 38, floatArray1);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.ATDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("seE!lW1t}9}");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.getAverage();
      aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getValueCount();
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("Can't retrieve symbol as symbol list is the wrong length ", "");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(1791);
      aTDeviationAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("long", "Cannot create a FramedFeature on the negative strand of an RNA");
      Bases bases0 = new Bases(fastaStreamSequence0);
      SequenceChangeEvent sequenceChangeEvent0 = new SequenceChangeEvent(bases0, 8250, 8250, "Cannot create a FramedFeature on the negative strand of an RNA");
      Bases bases1 = sequenceChangeEvent0.getBases();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases1).when(strand0).getBases();
      doReturn(true).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(71);
      aTDeviationAlgorithm0.setUserMaxMin(true);
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.setAlgorithmName("V\";");
      aTDeviationAlgorithm0.setRevCompDisplay(true);
      aTDeviationAlgorithm0.setUserMaxMin(true);
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      aTDeviationAlgorithm0.getMinimumInternal();
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(1, 38, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.ATDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("internal error - unexpected exception: ");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getMaximumInternal();
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.setUserMaxMin(false);
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[9];
      LineAttributes lineAttributes0 = mock(LineAttributes.class, new ViolatedAssumptionAnswer());
      lineAttributesArray0[0] = lineAttributes0;
      lineAttributesArray0[1] = lineAttributes0;
      lineAttributesArray0[2] = lineAttributes0;
      lineAttributesArray0[3] = lineAttributes0;
      lineAttributesArray0[4] = lineAttributes0;
      lineAttributesArray0[5] = lineAttributes0;
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      aTDeviationAlgorithm0.getAverage();
      lineAttributesArray0[6] = lineAttributes0;
      lineAttributesArray0[7] = lineAttributes0;
      lineAttributesArray0[8] = lineAttributes0;
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.drawLegend(graphics0, 2, 0, lineAttributesArray0, 773);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // codegen.java.awt.Graphics$MockitoMock$1526629561 cannot be cast to java.awt.Graphics2D
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      int int0 = 10000000;
      aTDeviationAlgorithm0.getDefaultStepSize(10000000);
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.setUserMax(2);
      boolean boolean0 = false;
      aTDeviationAlgorithm0.setUserMaxMin(false);
      aTDeviationAlgorithm0.setUserMin(2);
      int int0 = 1540;
      aTDeviationAlgorithm0.getDefaultStepSize(1540);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Bases bases0 = mock(Bases.class, new ViolatedAssumptionAnswer());
      doReturn((Strand) null).when(bases0).getForwardStrand();
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      float[] floatArray0 = new float[4];
      floatArray0[0] = (float) 420;
      floatArray0[1] = (float) 0;
      floatArray0[2] = (float) 0;
      floatArray0[3] = (float) 2;
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(1551, 420, floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 1551 > end: 420
         //
         verifyException("uk.ac.sanger.artemis.plot.ATDeviationAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getMaximumInternal();
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      aTDeviationAlgorithm0.getValueCount();
      aTDeviationAlgorithm0.getDefaultWindowSize();
      aTDeviationAlgorithm0.getDefaultWindowSize();
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getMinimum();
      aTDeviationAlgorithm0.getDefaultStepSize(1220);
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.getMinimumInternal();
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(1);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getMinimumInternal();
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.setUserMaxMin(true);
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultWindowSize();
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getValueCount();
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      ATDeviationAlgorithm aTDeviationAlgorithm0 = null;
      try {
        aTDeviationAlgorithm0 = new ATDeviationAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.getDefaultStepSize(1);
      int int0 = 1;
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      int int1 = 1469;
      float[] floatArray0 = new float[2];
      aTDeviationAlgorithm0.setUserMaxMin(false);
      floatArray0[0] = (float) 1;
      floatArray0[1] = (float) 1;
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(351, 1, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.setAlgorithmName(":^'");
      aTDeviationAlgorithm0.setUserMaxMin(false);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(1, 1, (float[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      simpleEntryGroup0.getBases();
      Range range0 = null;
      try {
        range0 = new Range(27, 0);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // start: 27 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("", "]$tT G");
      Bases bases0 = new Bases(fastaStreamSequence0);
      Strand strand0 = bases0.getReverseStrand();
      bases0.getAverageGCPercent();
      AGWindowAlgorithm aGWindowAlgorithm0 = new AGWindowAlgorithm(strand0);
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "internal error - unexpected exception: ");
      Strand strand1 = aGWindowAlgorithm0.getStrand();
      RangeVector rangeVector0 = new RangeVector();
      fastaStreamSequence0.setFastaHeaderPositionsOnReverseComplement(rangeVector0);
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand1);
      aTDeviationAlgorithm0.getAverage();
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      aTDeviationAlgorithm0.setScalingFlag(true);
      aTDeviationAlgorithm0.setUserMin(0.0F);
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      aTDeviationAlgorithm0.setRevCompDisplay(false);
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.setScalingFlag(false);
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.getDefaultMaxWindowSize();
      Graphics graphics0 = mock(Graphics.class, new ViolatedAssumptionAnswer());
      LineAttributes[] lineAttributesArray0 = new LineAttributes[1];
      LineAttributes lineAttributes0 = mock(LineAttributes.class, new ViolatedAssumptionAnswer());
      lineAttributesArray0[0] = lineAttributes0;
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.drawLegend(graphics0, 1, 1, lineAttributesArray0, 2);
        fail("Expecting exception: ClassCastException");
      
      } catch(ClassCastException e) {
         //
         // codegen.java.awt.Graphics$MockitoMock$1526629561 cannot be cast to java.awt.Graphics2D
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultWindowSize();
      aTDeviationAlgorithm0.getMinimumInternal();
      aTDeviationAlgorithm0.setUserMax(2);
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.setUserMin((-1.0F));
      aTDeviationAlgorithm0.getMaximum();
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.getMaximumInternal();
      aTDeviationAlgorithm0.getDefaultStepSize(1);
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getAverage();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      assertNotNull(aTDeviationAlgorithm0);
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
      
      Integer integer0 = aTDeviationAlgorithm0.getDefaultStepSize(1791);
      assertEquals(179, (int)integer0);
      assertNotNull(integer0);
      assertEquals("at_deviation", aTDeviationAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, aTDeviationAlgorithm0.getUserMin(), 0.01F);
      assertFalse(aTDeviationAlgorithm0.isUserMaxMin());
      assertFalse(aTDeviationAlgorithm0.isRevCompDisplay());
      assertEquals("AT Deviation (A-T)/(A+T)", aTDeviationAlgorithm0.getAlgorithmName());
      assertTrue(aTDeviationAlgorithm0.scalingFlag());
      assertEquals(1, aTDeviationAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, aTDeviationAlgorithm0.getUserMax(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("");
      Bases bases0 = new Bases(rawStreamSequence0);
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false).when(strand0).isForwardStrand();
      ATDeviationAlgorithm aTDeviationAlgorithm0 = new ATDeviationAlgorithm(strand0);
      aTDeviationAlgorithm0.getDefaultStepSize(2);
      aTDeviationAlgorithm0.setRevCompDisplay(true);
      aTDeviationAlgorithm0.max_min_disabled = false;
      aTDeviationAlgorithm0.getDefaultMinWindowSize();
      aTDeviationAlgorithm0.setScalingFlag(false);
      int int0 = 0;
      aTDeviationAlgorithm0.getMaximumInternal();
      aTDeviationAlgorithm0.getDefaultStepSize(12310);
      aTDeviationAlgorithm0.setUserMaxMin(false);
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        aTDeviationAlgorithm0.getValues(0, 2, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.BaseAlgorithm", e);
      }
  }
}
