/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:32:56 GMT 2018
 */

package uk.ac.sanger.artemis.circular;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.image.renderable.ParameterBlock;
import java.text.AttributedCharacterIterator;
import java.util.Stack;
import java.util.Vector;
import javax.swing.border.SoftBevelBorder;
import org.apache.xmlgraphics.java2d.DefaultGraphics2D;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.circular.DNADraw;
import uk.ac.sanger.artemis.circular.GCGraph;
import uk.ac.sanger.artemis.circular.GCSkewGraph;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class Graph_ESTest extends Graph_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw((Vector) null, (Vector) null, (Vector) null, (Vector) null);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setGraphHeight(3.4028235E38F);
      assertEquals(3.4028235E38F, gCGraph0.getGraphHeight(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      gCSkewGraph0.setMaxValue((-1015.27F));
      assertEquals((-1015.27F), gCSkewGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      assertEquals(200, gCGraph0.getBaseStepSize());
      
      gCGraph0.setBaseStepSize(0);
      assertEquals(0, gCGraph0.getBaseStepSize());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      String[] stringArray0 = new String[9];
      stringArray0[0] = "U+0301";
      stringArray0[1] = "";
      stringArray0[2] = "plus_colour";
      stringArray0[3] = "";
      // Undeclared exception!
      try { 
        gCGraph0.setOptionsStr(stringArray0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // For input string: \"\"
         //
         verifyException("java.lang.NumberFormatException", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      int int0 = gCGraph0.getWindowSize();
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(10000, int0);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      DefaultGraphics2D defaultGraphics2D0 = new DefaultGraphics2D(true);
      // Undeclared exception!
      try { 
        gCSkewGraph0.paintComponent(defaultGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.apache.xmlgraphics.java2d.AbstractGraphics2D", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      DefaultGraphics2D defaultGraphics2D0 = new DefaultGraphics2D(true);
      // Undeclared exception!
      try { 
        gCGraph0.drawLinear(defaultGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.apache.xmlgraphics.java2d.AbstractGraphics2D", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      DefaultGraphics2D defaultGraphics2D0 = new DefaultGraphics2D(true);
      // Undeclared exception!
      try { 
        gCSkewGraph0.draw(defaultGraphics2D0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.apache.xmlgraphics.java2d.AbstractGraphics2D", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Stack<Integer> stack0 = new Stack<Integer>();
      DNADraw dNADraw0 = new DNADraw(stack0, stack0, stack0, stack0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      // Undeclared exception!
      try { 
        gCGraph0.calcGraphValues();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Graph", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw((Vector) null, (Vector) null, (Vector) null, (Vector) null);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      Color color0 = gCGraph0.getPlusColour();
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals((-5000422), color0.getRGB());
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      int int0 = gCSkewGraph0.getBaseStepSize();
      assertEquals(200, int0);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      Color color0 = gCGraph0.getMinusColour();
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals((-6750055), color0.getRGB());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      float float0 = gCGraph0.getGraphHeight();
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(0.2F, float0, 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      double double0 = gCGraph0.getTrack();
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(0.4, double0, 0.01);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      String[] stringArray0 = new String[9];
      stringArray0[0] = "U+0301";
      stringArray0[1] = "";
      stringArray0[2] = "plus_colour";
      // Undeclared exception!
      try { 
        gCGraph0.setOptionsStr(stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.circular.Graph", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      ParameterBlock parameterBlock0 = new ParameterBlock();
      Vector<Object> vector0 = parameterBlock0.getSources();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      String[] stringArray0 = new String[7];
      stringArray0[0] = "uk.ac.sanger.artemis.circular.Graph$6";
      stringArray0[1] = "uk.ac.sanger.artemis.circular.Graph$6";
      stringArray0[2] = "window_size";
      // Undeclared exception!
      try { 
        gCSkewGraph0.setOptionsStr(stringArray0);
        fail("Expecting exception: NumberFormatException");
      
      } catch(NumberFormatException e) {
         //
         // null
         //
         verifyException("java.lang.Integer", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      String[] stringArray0 = new String[6];
      stringArray0[0] = "PanelUI";
      stringArray0[1] = "PanelUI";
      stringArray0[2] = "PanelUI";
      stringArray0[3] = "height=0.2 window_size=10000 base_step_size=200 track=0.4 minus_colour=153:0:153 plus_colour=179:179:26";
      // Undeclared exception!
      try { 
        gCGraph0.setOptionsStr(stringArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
      }
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      String[] stringArray0 = new String[0];
      gCGraph0.setOptionsStr(stringArray0);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>(553, 255);
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setStrokeSize((-634));
      int int0 = gCGraph0.getStrokeSize();
      assertEquals((-634), int0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      SoftBevelBorder softBevelBorder0 = new SoftBevelBorder(3754);
      Color color0 = softBevelBorder0.getShadowInnerColor((Component) dNADraw0);
      gCGraph0.setMinusColour(color0);
      gCGraph0.getMinusColour();
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>(553, 255);
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      float float0 = gCGraph0.getMaxValue();
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(1.4E-45F, float0, 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Vector<Object> vector0 = new Vector<Object>(553, 255);
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      int int0 = gCGraph0.getStrokeSize();
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(1, int0);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setMinValue(0.6F);
      assertEquals(0.6F, gCGraph0.getMinValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      assertEquals(200, gCGraph0.getBaseStepSize());
      
      gCGraph0.setBaseStepSize(1);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Vector<AttributedCharacterIterator.Attribute> vector0 = new Vector<AttributedCharacterIterator.Attribute>();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      // Undeclared exception!
      try { 
        gCGraph0.showOptions();
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.awt.dnd.DropTarget", e);
      }
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw((Vector) null, (Vector) null, (Vector) null, (Vector) null);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      
      gCGraph0.setMaxValue(0.0F);
      float float0 = gCGraph0.getMaxValue();
      assertEquals(0.0F, float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      
      gCSkewGraph0.setTrack(0.0);
      double double0 = gCSkewGraph0.getTrack();
      assertEquals(0.0, double0, 0.01);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      Color color0 = Color.magenta;
      gCSkewGraph0.setPlusColour(color0);
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(200, gCSkewGraph0.getBaseStepSize());
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      ParameterBlock parameterBlock0 = new ParameterBlock();
      Vector<Object> vector0 = parameterBlock0.getParameters();
      DNADraw dNADraw0 = new DNADraw(vector0, vector0, vector0, vector0);
      GCSkewGraph gCSkewGraph0 = new GCSkewGraph(dNADraw0);
      gCSkewGraph0.getCurrentDna();
      assertEquals(0.2F, gCSkewGraph0.getGraphHeight(), 0.01F);
      assertEquals(0.4, gCSkewGraph0.getTrack(), 0.01);
      assertEquals(3.4028235E38F, gCSkewGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCSkewGraph0.getBaseStepSize());
      assertEquals(1.4E-45F, gCSkewGraph0.getMaxValue(), 0.01F);
      assertEquals(1, gCSkewGraph0.getStrokeSize());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw((Vector) null, (Vector) null, (Vector) null, (Vector) null);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      float float0 = gCGraph0.getMinValue();
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(3.4028235E38F, float0, 0.01F);
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Stack<Integer> stack0 = new Stack<Integer>();
      DNADraw dNADraw0 = new DNADraw(stack0, stack0, stack0, stack0);
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.getBases();
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      gCGraph0.setWindowSize((-1840700267));
      int int0 = gCGraph0.getWindowSize();
      assertEquals(0.2F, gCGraph0.getGraphHeight(), 0.01F);
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(200, gCGraph0.getBaseStepSize());
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
      assertEquals((-1840700267), int0);
      assertEquals(0.4, gCGraph0.getTrack(), 0.01);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      DNADraw dNADraw0 = new DNADraw();
      GCGraph gCGraph0 = new GCGraph(dNADraw0);
      String string0 = gCGraph0.getOptionsStr();
      assertEquals("height=0.2 window_size=10000 base_step_size=200 track=0.4 minus_colour=153:0:153 plus_colour=179:179:26", string0);
      assertEquals(1, gCGraph0.getStrokeSize());
      assertEquals(3.4028235E38F, gCGraph0.getMinValue(), 0.01F);
      assertEquals(1.4E-45F, gCGraph0.getMaxValue(), 0.01F);
  }
}
