/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgFunction;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import java.text.MessageFormat;

public class CreateFunctionParser {
    public static void parse(PgDatabase pgDatabase, String string) {
        Parser parser = new Parser(string);
        parser.expect("CREATE");
        parser.expectOptional("OR", "REPLACE");
        parser.expect("FUNCTION");
        String string2 = parser.parseIdentifier();
        String string3 = ParserUtils.getSchemaName(string2, pgDatabase);
        PgSchema pgSchema = pgDatabase.getSchema(string3);
        if (pgSchema == null) {
            throw new RuntimeException(MessageFormat.format(Resources.getString("CannotFindSchema"), string3, string));
        }
        PgFunction pgFunction = new PgFunction();
        pgFunction.setName(ParserUtils.getObjectName(string2));
        pgSchema.addFunction(pgFunction);
        parser.expect("(");
        while (!parser.expectOptional(")")) {
            String string4 = parser.expectOptional("IN") ? "IN" : (parser.expectOptional("OUT") ? "OUT" : (parser.expectOptional("INOUT") ? "INOUT" : (parser.expectOptional("VARIADIC") ? "VARIADIC" : null)));
            int n = parser.getPosition();
            String string5 = null;
            String string6 = parser.parseDataType();
            int n2 = parser.getPosition();
            if (!(parser.expectOptional(")") || parser.expectOptional(",") || parser.expectOptional("=") || parser.expectOptional("DEFAULT"))) {
                parser.setPosition(n);
                string5 = ParserUtils.getObjectName(parser.parseIdentifier());
                string6 = parser.parseDataType();
            } else {
                parser.setPosition(n2);
            }
            String string7 = parser.expectOptional("=") || parser.expectOptional("DEFAULT") ? parser.getExpression() : null;
            PgFunction.Argument argument = new PgFunction.Argument();
            argument.setDataType(string6);
            argument.setDefaultExpression(string7);
            argument.setMode(string4);
            argument.setName(string5);
            pgFunction.addArgument(argument);
            if (parser.expectOptional(")")) break;
            parser.expect(",");
        }
        pgFunction.setBody(parser.getRest());
    }

    private CreateFunctionParser() {
    }
}

